<?php
include 'dbconn.php';
include __DIR__ . '/../html_utility.php';

// Get current date and time
$now = new DateTime();
$two_days_ago = (clone $now)->modify('-2 days')->format('Y-m-d');
$seven_days_ago = (clone $now)->modify('-7 days')->format('Y-m-d');

$sql = "SELECT vcd.email, vq.auto_email_follow_up, vq.auto_email_follow_up_datetime, vq.quoteid, vq.quote_no
        FROM vtiger_quotes vq
        LEFT JOIN tdu_organisation o ON vq.accountid = o.organizationid
        LEFT JOIN tdu_contacts vcd ON o.organizationid = vcd.organizationid
        WHERE 
            (vq.quotestage = 'Created' OR vq.quotestage = 'Requote') 
            AND vq.quoteid IN (
                SELECT MIN(quoteid) 
                FROM vtiger_quotes 
                GROUP BY quote_no
            ) 
            AND vcd.email != '' AND vcd.email IS NOT NULL;
";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $follow_up = (int) $row['auto_email_follow_up'];
        $follow_up_datetime = $row['auto_email_follow_up_datetime'];

        if (empty($follow_up_datetime)) {
            continue;
        }

        $follow_up_date = new DateTime($follow_up_datetime);
        $follow_up_date_str = $follow_up_date->format('Y-m-d');

        $should_send_email = false;

        if ($follow_up === 0 && $follow_up_date_str <= $two_days_ago) {
            // Send after 2 days for initial follow-up
            $should_send_email = true;
        } elseif ($follow_up > 0 && $follow_up <= 3 && $follow_up_date_str <= $seven_days_ago) {
            // Send after 7 days for subsequent follow-ups
            $should_send_email = true;
        }

        if ($should_send_email) {
            $subject = "Follow-up from Turtle Down Under - " . $row['quote_no'];
            $email_body = "
                Greetings from Turtle Down Under!<br><br>
                I hope you're doing well. I wanted to follow up on the quote we shared with you earlier. 
                Please let us know if you have any questions or if any adjustments are required.<br><br>
                Looking forward to your response.
            ";

            $from = getMailboxByQuote($conn, $row['quoteid']);
            if($from == '') {
                continue;
            }
            
            $post_data = [
                'from' => $from,
                'to' => $row['email'],
                'subject' => $subject,
                'content' => $email_body,
                'compose' => 'Yes',
                'secret' => 'tdu_cronjob'
            ];

            $ch = curl_init();
            // curl_setopt($ch, CURLOPT_URL, "https://dev.yourbestwayhome.com.au/turtledownunder/email_sender.php");
            curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);
            curl_close($ch);

            if ($response === false) {
                error_log("Error sending email to {$row['email']} for quote ID {$row['quoteid']}");
            } else {
                // Optionally log success
                error_log("Follow-up email sent to {$row['email']} for quote ID {$row['quoteid']}");

                // Update auto_email_follow_up and auto_email_follow_up_datetime
                $new_follow_up = $follow_up + 1;
                $update_sql = "
                    UPDATE vtiger_quotes 
                    SET auto_email_follow_up = $new_follow_up, 
                        auto_email_follow_up_datetime = NOW() 
                    WHERE quoteid = {$row['quoteid']}
                ";
                mysqli_query($conn, $update_sql);
                echo "Follow-up email sent to {$row['email']} for quote ID {$row['quote_no']}\n";
            }
        }
    }
}

mysqli_close($conn);
?>
