<?php
include 'dbconn.php';

$sql = "SELECT quoteid FROM tdu_mailbox_tmp_send_vendor WHERE a_t_actioned=0;";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error fetching quote IDs: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result)) {
    $quoteid = $row['quoteid'];

    $date_sql = "SELECT vq.quote_no, vq.subject, vqcf.cf_1162 AS date_of_travel 
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                WHERE vq.quoteid='$quoteid';";
    $date_result = mysqli_query($conn, $date_sql);
    $date_row = mysqli_fetch_assoc($date_result);

    if (!$date_row || empty($date_row['date_of_travel']) || $date_row['date_of_travel'] == '0000-00-00') {
        continue;
    }
    $date_of_travel = $date_row['date_of_travel'];
    $quote_number = $date_row['quote_no'];
    $quote_subject = $date_row['subject'];

    // Fetch vendor details
    $vendor_sql = "SELECT vi.sequence_no, vi.day, vp.productName, vp.vendorid, vv.vendorName, vv.email 
                FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vp ON vi.productid=vp.productid
                LEFT JOIN tdu_vendors vv ON vp.vendorid=vv.vendorid
                WHERE vi.id='$quoteid' 
                    AND (vi.cf_928='Attraction' OR vi.cf_928='Tour')
                    AND vi.booking_status='Pending' 
                    AND vp.productName IS NOT NULL 
                    AND vv.vendorName IS NOT NULL;";
    $vendor_result = mysqli_query($conn, $vendor_sql);
    
    if (!$vendor_result) {
        die("Error fetching vendor details: " . mysqli_error($conn));
    }

    // Organize data by vendor
    $vendor_data = [];
    while ($vendor_row = mysqli_fetch_assoc($vendor_result)) {
        $vendorid = $vendor_row['vendorid'];
        $vendorName = $vendor_row['vendorName'];
        $vendorEmail = $vendor_row['email'];
        $productName = $vendor_row['productName'];
        $day_offset = (int) $vendor_row['day'] - 1;
        $travel_date = date('Y-m-d', strtotime($date_of_travel . " +$day_offset days"));
        $sequence_no = $vendor_row['sequence_no'];

        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                    VALUES ('$quoteid', '$sequence_no', 'booking_status', 'Awaiting confirmation', NOW(), 'SYSTEM')";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        $update_sql = "UPDATE vtiger_inventoryproductrel SET booking_status='Awaiting confirmation' WHERE id='$quoteid' AND sequence_no='$sequence_no'";
        mysqli_query($conn, $update_sql);
    
        // Fetch latest itinerary details (tour time, number of passengers)
        $itinerary_sql = "
            SELECT t.meta_key, t.meta_value
            FROM vtiger_itinerary t
            JOIN (
                SELECT meta_key, MAX(created_at) AS max_created_at
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid' 
                    AND sequence_no = '$sequence_no'
                    AND meta_key IN ('tourtime', 'adults', 'children')
                GROUP BY meta_key
            ) latest 
            ON t.meta_key = latest.meta_key
            AND t.created_at = latest.max_created_at;
        ";
        $itinerary_result = mysqli_query($conn, $itinerary_sql);
        
        // Default values if no records are found
        $pickup_time = '';
        $adults = 0;
        $children = 0;
    
        while ($itinerary_row = mysqli_fetch_assoc($itinerary_result)) {
            if ($itinerary_row['meta_key'] == 'tourtime') {
                $pickup_time = $itinerary_row['meta_value'];
            } elseif ($itinerary_row['meta_key'] == 'adults') {
                $adults = (int) $itinerary_row['meta_value'];
            } elseif ($itinerary_row['meta_key'] == 'children') {
                $children = (int) $itinerary_row['meta_value'];
            }
        }

        $pax_sql = " SELECT surname, given_name FROM vtiger_pax_in_hotel WHERE quoteid = '$quoteid' ";
        $pax_result = mysqli_query($conn, $pax_sql);
        $pax_details = "<table border='1'>";
        while ($pax_row = mysqli_fetch_assoc($pax_result)) {
            $pax_details .= "<tr><td>" . $pax_row['given_name'] . " " . $pax_row['surname'] . "</td></tr>";
        }
        $pax_details .= "</table>";
    
        if (!isset($vendor_data[$vendorid])) {
            $vendor_data[$vendorid] = [
                'vendorName' => $vendorName,
                'email' => $vendorEmail,
                'products' => [],
            ];
        }
    
        $vendor_data[$vendorid]['products'][] = [
            'name' => $productName,
            'dates' => $travel_date,
            'pax_details' => $pax_details,
            'pickup_time' => $pickup_time,
            'adults' => $adults,
            'children' => $children
        ];
    }    

    // Send emails
    foreach ($vendor_data as $vendorid => $data) {
        if (empty($data['email'])) {
            continue;
        }
    
        $subject = $quote_number . " Booking Request - " . $data['vendorName'];
        $email_body = "<p>Dear " . $data['vendorName'] . ",</p><br>";
        $email_body .= "<p>Please find below the booking request:</p><br>";
    
        foreach ($data['products'] as $product) {
            $email_body .= "<hr>";
            if (!empty($product['name'])) {
                $email_body .= "<p><strong>" . $product['name'] . "</strong></p>";
            }
            if (!empty($product['dates'])) {
                $email_body .= "<p>Date: " . $product['dates'] . "</p>";
            }
            if (!empty($product['pickup_time'])) {
                $email_body .= "<p>Tour time - " . $product['pickup_time'] . "</p>";
            }
            $email_body .= "<p>Number of Passengers: " . $product['adults'] . " adults, " . $product['children'] . " children</p>";
            if (!empty($product['pax_details'])) {
                $email_body .= "<p>" . $product['pax_details'] . "</p>";
            }
        }        
    
        // Send email via email_sender.php
        $post_data = [
            'from' => 'groups@turtledownunder.com.au',
            'to' => $data['email'],
            'subject' => $subject,
            'content' => $email_body,
            'compose' => 'Yes',
            'secret' => 'tdu_cronjob'
        ];
    
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "https://dev.yourbestwayhome.com.au/turtledownunder/email_sender.php");
        curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    
        // Mark email as sent
        $update_sql = "UPDATE tdu_mailbox_tmp_send_vendor SET a_t_actioned=1 WHERE quoteid='$quoteid'";
        mysqli_query($conn, $update_sql);
    }
}

mysqli_close($conn);
echo "Emails processed successfully.";
?>
