<?php
include 'dbconn.php';

$sql = "SELECT quoteid FROM tdu_mailbox_tmp_send_vendor WHERE transfers_actioned=0;";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error fetching quote IDs: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result)) {
    $quoteid = $row['quoteid'];

    $date_sql = "SELECT vq.quote_no, vq.subject, vqcf.cf_1162 AS date_of_travel 
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                WHERE vq.quoteid='$quoteid';";
    $date_result = mysqli_query($conn, $date_sql);
    $date_row = mysqli_fetch_assoc($date_result);

    if (!$date_row || empty($date_row['date_of_travel']) || $date_row['date_of_travel'] == '0000-00-00') {
        continue;
    }
    $date_of_travel = $date_row['date_of_travel'];
    $quote_number = $date_row['quote_no'];
    $quote_subject = $date_row['subject'];

    // Fetch vendor details
    $vendor_sql = "SELECT vi.sequence_no, vi.day, vp.productName, vp.vendorid, vv.vendorName, vv.email 
                FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vp ON vi.productid=vp.productid
                LEFT JOIN tdu_vendors vv ON vp.vendorid=vv.vendorid
                WHERE vi.id='$quoteid' 
                    AND vi.cf_928='Transfers' 
                    AND vi.booking_status='Pending' 
                    AND vp.productName IS NOT NULL 
                    AND vv.vendorName IS NOT NULL;";
    $vendor_result = mysqli_query($conn, $vendor_sql);
    if (!$vendor_result) {
        die("Error fetching vendor details: " . mysqli_error($conn));
    }

    // Organize data by vendor
    $vendor_data = [];
    while ($vendor_row = mysqli_fetch_assoc($vendor_result)) {
        $vendorid = $vendor_row['vendorid'];
        $vendorName = $vendor_row['vendorName'];
        $vendorEmail = $vendor_row['email'];
        $productName = $vendor_row['productName'];
        $day_offset = (int) $vendor_row['day'] - 1;
        $travel_date = date('Y-m-d', strtotime($date_of_travel . " +$day_offset days"));
        $sequence_no = $vendor_row['sequence_no'];

        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                    VALUES ('$quoteid', '$sequence_no', '0', 'booking_status', 'Awaiting confirmation', NOW(), 'SYSTEM')";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        $update_sql = "UPDATE vtiger_inventoryproductrel SET booking_status='Awaiting confirmation' WHERE id='$quoteid' AND sequence_no='$sequence_no'";
        mysqli_query($conn, $update_sql);
    
        // Fetch latest flight details, pickup time, pickup location, and dropoff location
        $itinerary_sql = "
            SELECT t.quoteid, t.sequence_no, t.meta_key, t.meta_value
            FROM vtiger_itinerary t
            JOIN (
                SELECT quoteid, sequence_no, meta_key, MAX(created_at) AS max_created_at
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid' 
                    AND sequence_no = '$sequence_no'
                    AND meta_key IN ('tourtime', 'pickup_location', 'dropoff_location')
                GROUP BY quoteid, sequence_no, meta_key
            ) latest 
            ON t.quoteid = latest.quoteid 
            AND t.sequence_no = latest.sequence_no
            AND t.meta_key = latest.meta_key
            AND t.created_at = latest.max_created_at;
        ";
        $itinerary_result = mysqli_query($conn, $itinerary_sql);
        
        // Default values if no records are found
        $flight_details = '';
        $pickup_time = '';
        $pickup_location = '';
        $dropoff_location = '';
    
        while ($itinerary_row = mysqli_fetch_assoc($itinerary_result)) {
            if ($itinerary_row['meta_key'] == 'tourtime') {
                $pickup_time = $itinerary_row['meta_value'];
            } elseif ($itinerary_row['meta_key'] == 'pickup_location') {
                $pickup_location = $itinerary_row['meta_value'];
            } elseif ($itinerary_row['meta_key'] == 'dropoff_location') {
                $dropoff_location = $itinerary_row['meta_value'];
            }
        }

        $flight_sql = " SELECT flight_number, from_city, from_datetime, to_city, to_datetime
                        FROM tdu_flight_details
                        WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'
                        ORDER BY created_at DESC LIMIT 1;
        ";
        $flight_result = mysqli_query($conn, $flight_sql);
        $flight_details = "";

        if ($flight_row = mysqli_fetch_assoc($flight_result)) {
            $flight_details = "Flight Number: " . $flight_row['flight_number'] . "<br>";
            $flight_details .= "Flight Details: " . $flight_row['from_city'] . " " . $flight_row['from_datetime'] . " -> ";
            $flight_details .= $flight_row['to_city'] . " " . $flight_row['to_datetime'];
        }
    
        if (!isset($vendor_data[$vendorid])) {
            $vendor_data[$vendorid] = [
                'vendorName' => $vendorName,
                'email' => $vendorEmail,
                'products' => [],
            ];
        }
    
        $vendor_data[$vendorid]['products'][] = [
            'name' => $productName,
            'dates' => $travel_date,
            'flight_details' => $flight_details,
            'pickup_time' => $pickup_time,
            'pickup_location' => $pickup_location,
            'dropoff_location' => $dropoff_location
        ];
    }    

    // Send emails
    foreach ($vendor_data as $vendorid => $data) {
        if (empty($data['email'])) {
            continue;
        }
    
        $subject = $quote_number . " Booking Request - " . $data['vendorName'];
        $email_body = "<p>Dear " . $data['vendorName'] . ",</p><br>";
        $email_body .= "<p>Please find below the booking request:</p><br>";
    
        foreach ($data['products'] as $product) {
            $email_body .= "<hr>";
            if (!empty($product['name'])) {
                $email_body .= "<p><strong>" . $product['name'] . "</strong></p>";
            }
            if (!empty($product['flight_details'])) {
                $email_body .= "<p>" . $product['flight_details'] . "</p>";
            }
            if (!empty($product['pickup_time'])) {
                $email_body .= "<p>Pickup time - " . $product['pickup_time'] . "</p>";
            }
            if (!empty($product['pickup_location'])) {
                $email_body .= "<p>Pickup location - " . $product['pickup_location'] . "</p>";
            }
            if (!empty($product['dropoff_location'])) {
                $email_body .= "<p>Drop off location - " . $product['dropoff_location'] . "</p>";
            }
        }        
    
        // Send email via email_sender.php
        $post_data = [
            'from' => 'groups@turtledownunder.com.au',
            'to' => $data['email'],
            'subject' => $subject,
            'content' => $email_body,
            'compose' => 'Yes',
            'secret' => 'tdu_cronjob'
        ];
    
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "https://dev.yourbestwayhome.com.au/turtledownunder/email_sender.php");
        curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    
        // Mark email as sent
        $update_sql = "UPDATE tdu_mailbox_tmp_send_vendor SET transfers_actioned=1 WHERE quoteid='$quoteid'";
        mysqli_query($conn, $update_sql);
    }
}

mysqli_close($conn);
echo "Emails processed successfully.";
?>
