<?php
include "dbconn.php";

$sql_payment_due_check =   "SELECT 
                                vq.quoteid, 
                                SUM(CAST(vph.total_amount AS DECIMAL(10,2))) AS amount_due, 
                                SUM(CAST(vph.trams_received_amount AS DECIMAL(10,2))) AS amount_received
                            FROM vtiger_quotes vq 
                            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                            LEFT JOIN vtiger_payment_history vph ON vq.quoteid = vph.quoteid
                            WHERE vq.quotestage = 'Accepted' AND vqcf.cf_1182 = DATE_ADD(CURDATE(), INTERVAL 2 DAY) AND (vph.source != 'final' OR vph.source IS NULL)
                            GROUP BY vq.quoteid
                            HAVING amount_received < amount_due - 30 OR amount_due <= 0 OR amount_due IS NULL OR amount_received IS NULL;";
$result_payment_due_check = mysqli_query($conn, $sql_payment_due_check);
if (mysqli_num_rows($result_payment_due_check) > 0) {
    while ($row = mysqli_fetch_assoc($result_payment_due_check)) {
        $sql_insert = "INSERT INTO vtiger_quotes_followup (quoteid, quotetype, followup_type, next_follow_up_date, description)
                        VALUES ('" . $row['quoteid'] . "', 'group', 'schedule_follow_up', NOW(), 'System generated: Payment deadline is due in 2 days')";
        $result_insert = mysqli_query($conn, $sql_insert);
        echo "Inserted payment deadline pending for quoteid: " . $row['quoteid'] . "<br>";
    }
} else {
    echo "No quotes found for payment deadline update.";
}

?>
