<?php
include "remotedbconn.php";

// Fetch the current date and tomorrow's date
date_default_timezone_set('Australia/Melbourne');
$current_date = date('Y-m-d');
$tomorrow_date = date('Y-m-d', strtotime('+1 day'));

// SQL query to fetch required data
$sql = "SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162 
        FROM vtiger_quotes vq
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid";
$result = mysqli_query($remote_conn, $sql) or die(mysqli_error($remote_conn));

// Loop through the results
while ($row = mysqli_fetch_assoc($result)) {
    $quoteid = $row['quoteid'];
    $quotestage = $row['quotestage'];
    $cf_1162 = $row['cf_1162']; // This is the date field

    // Check if cf_1162 is a valid date
    if (!empty($cf_1162)) {
        
        // 1. If quotestage is 'Create Project' and cf_1162 is in the past, change to 'Auto Rejected'
        if (($quotestage == 'Create Project' || $quotestage == 'Created') && $cf_1162 < $current_date) {
            $update_sql = "UPDATE vtiger_quotes 
                           SET quotestage = 'Auto Rejected' 
                           WHERE quoteid = $quoteid";
            mysqli_query($remote_conn, $update_sql) or die(mysqli_error($remote_conn));
            echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>Auto Rejected<br>';
        }
        continue;
        
        // 2. If quotestage is 'Delivered' and cf_1162 is tomorrow, change to 'On Ground - Changes (Ops)'
        if ($quotestage == 'Delivered' && $cf_1162 == $tomorrow_date) {
            $update_sql = "UPDATE vtiger_quotes 
                           SET quotestage = 'On Ground - Changes (Ops)' 
                           WHERE quoteid = $quoteid";
            mysqli_query($remote_conn, $update_sql) or die(mysqli_error($remote_conn));
            echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>On Ground - Changes (Ops)<br>';
        }

        // 3. Check for max(day) in vtiger_inventoryproductrel and cf_1162 + max(day) + 1 day = today
        $max_day_sql = "SELECT MAX(day) AS max_day 
                        FROM vtiger_inventoryproductrel 
                        WHERE id = $quoteid";
        $max_day_result = mysqli_query($remote_conn, $max_day_sql) or die(mysqli_error($remote_conn));
        $max_day_row = mysqli_fetch_assoc($max_day_result);
        $max_day = $max_day_row['max_day'];

        if (!empty($max_day) && $quotestage == 'On Ground - Changes (Ops)') {
            // Add max(day) and 1 day to cf_1162
            $target_date = date('Y-m-d', strtotime($cf_1162 . " + $max_day days"));

            // If cf_1162 + max(day) + 1 day equals the current date
            if ($target_date == $current_date) {
                // Update quotestage to 'Accounts - Reconciliation (Rakesh/Kunjan)'
                $update_sql = "UPDATE vtiger_quotes 
                               SET quotestage = 'Accounts - Reconciliation' 
                               WHERE quoteid = $quoteid";
                mysqli_query($remote_conn, $update_sql) or die(mysqli_error($remote_conn));
                echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>Accounts - Reconciliation<br>' ;
            }
        }
    }
}

echo "<br>DONE";
?>
