<?php
include 'dbconn.php';

// Update region tags
$existingRegions = [];
$result = mysqli_query($conn, "SELECT tag FROM vtiger_freetags WHERE raw_tag = 'region'");
while ($row = mysqli_fetch_assoc($result)) {
    $existingRegions[] = $row['tag'];
}

$actualRegions = [];
$result = mysqli_query($conn, "SELECT groupname FROM vtiger_groups");
while ($row = mysqli_fetch_assoc($result)) {
    $actualRegions[] = $row['groupname'];
}

// Tags to delete (in freetags but not in groups)
$regionsToDelete = array_diff($existingRegions, $actualRegions);
foreach ($regionsToDelete as $tag) {
    $tagEscaped = mysqli_real_escape_string($conn, $tag);
    mysqli_query($conn, "UPDATE vtiger_freetags SET visibility = 'private' WHERE raw_tag = 'region' AND tag = '$tagEscaped'");
}

// Tags to add (in groups but not in freetags)
$regionsToAdd = array_diff($actualRegions, $existingRegions);
foreach ($regionsToAdd as $tag) {
    $tagEscaped = mysqli_real_escape_string($conn, $tag);
    mysqli_query($conn, "INSERT INTO vtiger_freetags (tag, raw_tag) VALUES ('$tagEscaped', 'region')");
}

// Update person tags
$existingPersons = [];
$result = mysqli_query($conn, "SELECT tag FROM vtiger_freetags WHERE raw_tag = 'person'");
while ($row = mysqli_fetch_assoc($result)) {
    $existingPersons[] = $row['tag'];
}

$actualPersons = [];
$result = mysqli_query($conn, "SELECT CONCAT(first_name, ' ', last_name) AS fullname FROM vtiger_users WHERE title != 'block'");
while ($row = mysqli_fetch_assoc($result)) {
    $actualPersons[] = $row['fullname'];
}

// Tags to delete (in freetags but not in users)
$personsToDelete = array_diff($existingPersons, $actualPersons);
foreach ($personsToDelete as $tag) {
    $tagEscaped = mysqli_real_escape_string($conn, $tag);
    mysqli_query($conn, "UPDATE vtiger_freetags SET visibility = 'private' WHERE raw_tag = 'person' AND tag = '$tagEscaped'");
}

// Tags to add (in users but not in freetags)
$personsToAdd = array_diff($actualPersons, $existingPersons);
foreach ($personsToAdd as $tag) {
    $tagEscaped = mysqli_real_escape_string($conn, $tag);
    mysqli_query($conn, "INSERT INTO vtiger_freetags (tag, raw_tag) VALUES ('$tagEscaped', 'person')");
}

echo "Freetags updated.\n";
?>
