<?php
include "dbconn.php";
include __DIR__ . '/../dictionaries.php';

// Fetch the current date and tomorrow's date
date_default_timezone_set('Australia/Melbourne');
$current_date = date('Y-m-d');
$current_day_of_week = date('N');
$tomorrow_date = date('Y-m-d', strtotime('+1 day'));

// SQL query to fetch required data
$sql = "SELECT vq.quoteid, vq.quote_no, vq.subject, vq.quotestage, vqcf.cf_1162, vqinfo.assigned_to_region
        FROM vtiger_quotes vq
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'";
$result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

// Loop through the results
while ($row = mysqli_fetch_assoc($result)) {
    $quoteid = $row['quoteid'];
    $quotestage = $row['quotestage'];
    $cf_1162 = $row['cf_1162'];
    $quote_number = $row['quote_no'];
    $subject = $row['subject'];
    $assigned_to_region = $row['assigned_to_region'] ?? '';

    // Check if cf_1162 is a valid date
    if (!empty($cf_1162)) {
        
        // 1. If quotestage is 'Create Project' and cf_1162 is in the past, change to 'Auto Rejected'
        if ($quotestage == 'Created' && $cf_1162 < $current_date) {
            $update_sql = "UPDATE vtiger_quotes 
                           SET quotestage = 'Auto Rejected' 
                           WHERE quoteid = $quoteid";
            mysqli_query($conn, $update_sql) or die(mysqli_error($conn));
            echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>Auto Rejected<br>';

            $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                            VALUES ('$quoteid', 'admin', 'Change Stage to Auto Rejected Automatically', NOW());";
            mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));
        }
        
        // 2. If quotestage is 'Delivered' and cf_1162 is tomorrow, change to 'On Ground'
        if ($current_day_of_week == 5) { // If today is Friday
            $day_after_tomorrow = date('Y-m-d', strtotime('+2 days')); // Sunday
            $three_days_later = date('Y-m-d', strtotime('+3 days')); // Monday
            $valid_dates = [$tomorrow_date, $day_after_tomorrow, $three_days_later];
        } else {
            $valid_dates = [$tomorrow_date];
        }
        
        if ($quotestage == 'Delivered' && in_array($cf_1162, $valid_dates)) {
            $update_sql = "UPDATE vtiger_quotes 
                           SET quotestage = 'On Ground' 
                           WHERE quoteid = $quoteid";
            mysqli_query($conn, $update_sql) or die(mysqli_error($conn));

            $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                            VALUES ('$quoteid', 'admin', 'Change Stage to On Ground Automatically', NOW());";
            mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));

            createTaskWithMessage($conn, 'Customers On Ground', $quote_number, 'High', null, 'custom');

            echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>On Ground<br>';
        }

        // 3. Check for max(day) in vtiger_inventoryproductrel and cf_1162 + max(day) + 1 day = today
        $max_day_sql = "SELECT MAX(day) AS max_day 
                        FROM vtiger_inventoryproductrel 
                        WHERE id = $quoteid";
        $max_day_result = mysqli_query($conn, $max_day_sql) or die(mysqli_error($conn));
        $max_day_row = mysqli_fetch_assoc($max_day_result);
        $max_day = $max_day_row['max_day'];

        if (!empty($max_day) && $quotestage == 'On Ground') {
            $target_date = date('Y-m-d', strtotime($cf_1162 . " + $max_day days"));

            // travel is complete
            if ($target_date == $current_date) {
                $update_sql = "UPDATE vtiger_quotes 
                               SET quotestage = 'Accounts - Reconciliation' 
                               WHERE quoteid = $quoteid";
                mysqli_query($conn, $update_sql) or die(mysqli_error($conn));

                $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                    VALUES ('$quoteid', 'admin', 'Change Stage to Accounts - Reconciliation Automatically', NOW());";
                mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));

                createTaskWithMessage($conn, 'Accounts - Reconciliation', $quote_number);
                
                echo 'id: ' . $quoteid . ' date: ' . $cf_1162 . ' stage: ' . $quotestage . '=>Accounts - Reconciliation<br>' ;
            }
        }
    }
}

echo "<br>DONE";
?>
