<?php
include 'dbconn.php';

// Fetch the latest check_in for each quoteid and sequence_no
$sql = "
    SELECT t.quoteid, t.sequence_no, t.meta_value
    FROM vtiger_itinerary t
    JOIN (
        SELECT quoteid, sequence_no, MAX(created_at) AS max_created_at
        FROM vtiger_itinerary
        WHERE meta_key = 'check_in'
        GROUP BY quoteid, sequence_no
    ) latest ON t.quoteid = latest.quoteid 
           AND t.sequence_no = latest.sequence_no
           AND t.created_at = latest.max_created_at
    WHERE t.meta_key = 'check_in'
";

$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $sequence_no = $row['sequence_no'];
        $check_in = $row['meta_value'];

        if($check_in == '') {
            continue;
        }
        
        // Update the check_in in vtiger_inventoryproductrel
        $updateSql = "UPDATE vtiger_inventoryproductrel 
                      SET checkin = ? 
                      WHERE id = ? AND sequence_no = ?";
        $stmt = mysqli_prepare($conn, $updateSql);
        mysqli_stmt_bind_param($stmt, "sii", $check_in, $quoteid, $sequence_no);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
} else {
    error_log("Error fetching booking statuses: " . mysqli_error($conn));
}

// Fetch the latest check_out for each quoteid and sequence_no
$sql = "
    SELECT t.quoteid, t.sequence_no, t.meta_value
    FROM vtiger_itinerary t
    JOIN (
        SELECT quoteid, sequence_no, MAX(created_at) AS max_created_at
        FROM vtiger_itinerary
        WHERE meta_key = 'check_out'
        GROUP BY quoteid, sequence_no
    ) latest ON t.quoteid = latest.quoteid 
           AND t.sequence_no = latest.sequence_no
           AND t.created_at = latest.max_created_at
    WHERE t.meta_key = 'check_out'
";

$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $sequence_no = $row['sequence_no'];
        $check_out = $row['meta_value'];

        if($check_out == '') {
            continue;
        }
        
        // Update the check_out in vtiger_inventoryproductrel
        $updateSql = "UPDATE vtiger_inventoryproductrel 
                      SET checkout = ? 
                      WHERE id = ? AND sequence_no = ?";
        $stmt = mysqli_prepare($conn, $updateSql);
        mysqli_stmt_bind_param($stmt, "sii", $check_out, $quoteid, $sequence_no);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
} else {
    error_log("Error fetching booking statuses: " . mysqli_error($conn));
}

mysqli_close($conn);
?>
