<?php
include 'dbconn.php';

// Fetch the latest booking_status for each quoteid and sequence_no
$sql = "
    SELECT t.quoteid, t.sequence_no, t.meta_value
    FROM vtiger_itinerary t
    JOIN (
        SELECT quoteid, sequence_no, MAX(created_at) AS max_created_at
        FROM vtiger_itinerary
        WHERE meta_key = 'booking_status'
        GROUP BY quoteid, sequence_no
    ) latest ON t.quoteid = latest.quoteid 
           AND t.sequence_no = latest.sequence_no
           AND t.created_at = latest.max_created_at
    WHERE t.meta_key = 'booking_status'
";

$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $sequence_no = $row['sequence_no'];
        $booking_status = $row['meta_value'];

        if($booking_status == '') {
            continue;
        }
        
        // Update the booking_status in vtiger_inventoryproductrel
        $updateSql = "UPDATE vtiger_inventoryproductrel 
                      SET booking_status = ? 
                      WHERE id = ? AND sequence_no = ?";
        $stmt = mysqli_prepare($conn, $updateSql);
        mysqli_stmt_bind_param($stmt, "sii", $booking_status, $quoteid, $sequence_no);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
} else {
    error_log("Error fetching booking statuses: " . mysqli_error($conn));
}

mysqli_close($conn);
?>
