<?php
include 'dbconn.php';

// Fetch the latest tourtime for each quoteid and sequence_no
$sql = "
    SELECT t.quoteid, t.sequence_no, t.meta_value
    FROM vtiger_itinerary t
    JOIN (
        SELECT quoteid, sequence_no, MAX(created_at) AS max_created_at
        FROM vtiger_itinerary
        WHERE meta_key = 'tourtime'
        GROUP BY quoteid, sequence_no
    ) latest ON t.quoteid = latest.quoteid 
           AND t.sequence_no = latest.sequence_no
           AND t.created_at = latest.max_created_at
    WHERE t.meta_key = 'tourtime'
";

$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $sequence_no = $row['sequence_no'];
        $tourtime = $row['meta_value'] ?? '';

        // if($tourtime == '') {
        //     continue;
        // }
        
        // Update the tourtime in vtiger_inventoryproductrel
        $updateSql = "UPDATE vtiger_inventoryproductrel 
                      SET tourtime = ? 
                      WHERE id = ? AND sequence_no = ?";
        $stmt = mysqli_prepare($conn, $updateSql);
        mysqli_stmt_bind_param($stmt, "sii", $tourtime, $quoteid, $sequence_no);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
} else {
    error_log("Error fetching tourtimes: " . mysqli_error($conn));
}

mysqli_close($conn);
?>
