<?php
include "dbconn.php";
include "remotedbconn.php";

// Step 1: Fetch all rows from vtiger_quotes
$query = "SELECT * FROM vtiger_quotes;";
$result = $remote_conn->query($query);

if ($result) {
    // Step 2: Get column names using fetch_field()
    $columns = [];
    while ($fieldInfo = $result->fetch_field()) {
        $columns[] = $fieldInfo->name;
    }

    // Step 3: Loop through the result set and prepare the insert query
    while ($user = $result->fetch_assoc()) {
        $insertValues = [];

        foreach ($columns as $column) {
            $value = $user[$column];
            $insertValues[] = is_null($value) ? 'NULL' : "'" . $conn->real_escape_string($value) . "'";
        }

        // Construct the insert query with INSERT IGNORE
        $insertQuery = "INSERT IGNORE INTO vtiger_quotes_crm (" . implode(", ", $columns) . ") VALUES (" . implode(", ", $insertValues) . ")";

        // Execute the insert query
        if (!$conn->query($insertQuery)) {
            echo "Error inserting into vtiger_quotes_crm: " . $conn->error;
        }
    }
} else {
    echo "Error fetching from vtiger_quotes: " . $remote_conn->error;
}

// Step 1: Fetch all rows from vtiger_quotescf
$query_cf = "SELECT vqcf.* FROM vtiger_quotescf vqcf
            LEFT JOIN vtiger_quotes vq ON vqcf.quoteid = vq.quoteid;";
$result_cf = $remote_conn->query($query_cf);

if ($result_cf) {
    // Step 2: Get column names using fetch_field()
    $columns_cf = [];
    while ($fieldInfo_cf = $result_cf->fetch_field()) {
        $columns_cf[] = $fieldInfo_cf->name;
    }

    // Step 3: Loop through the result set and prepare the insert query
    while ($user_cf = $result_cf->fetch_assoc()) {
        $insertValues_cf = [];
        $updateValues_cf = [];

        foreach ($columns_cf as $column_cf) {
            $value_cf = $user_cf[$column_cf];
            $escapedValue = is_null($value_cf) ? 'NULL' : "'" . $conn->real_escape_string($value_cf) . "'";
            $insertValues_cf[] = $escapedValue;
            
            // Check if the column is cf_1162 and prepare for update if needed
            if ($column_cf == 'cf_1162') {
                $updateValues_cf[] = "cf_1162 = " . $escapedValue;
            }
        }

        // Assuming 'quoteid' is the unique key for checking duplication
        // $quoteid = $user_cf['quoteid'];

        // Construct the INSERT ... ON DUPLICATE KEY UPDATE query
        $insertQuery_cf = "INSERT INTO vtiger_quotescf_crm (" . implode(", ", $columns_cf) . ") 
                           VALUES (" . implode(", ", $insertValues_cf) . ") 
                           ON DUPLICATE KEY UPDATE " . implode(", ", $updateValues_cf);

        // Execute the query
        if (!$conn->query($insertQuery_cf)) {
            echo "Error inserting or updating vtiger_quotescf_crm: " . $conn->error;
        }
    }
} else {
    echo "Error fetching from vtiger_quotescf: " . $remote_conn->error;
}

// Step 1: Fetch all rows from vtiger_crmentity
$query_crmentity = "SELECT * FROM vtiger_crmentity WHERE crmid IN (SELECT quoteid FROM vtiger_quotes);";
$result_crmentity = $remote_conn->query($query_crmentity);

if ($result_crmentity) {
    // Step 2: Get column names using fetch_field()
    $columns_crmentity = [];
    while ($fieldInfo_crmentity = $result_crmentity->fetch_field()) {
        $columns_crmentity[] = $fieldInfo_crmentity->name;
    }

    // Step 3: Loop through the result set and prepare the insert query
    while ($user_crmentity = $result_crmentity->fetch_assoc()) {
        $insertValues_crmentity = [];

        foreach ($columns_crmentity as $column_crmentity) {
            $value_crmentity = $user_crmentity[$column_crmentity];
            $insertValues_crmentity[] = is_null($value_crmentity) ? 'NULL' : "'" . $conn->real_escape_string($value_crmentity) . "'";
        }

        // Construct the insert query with INSERT IGNORE
        $insertQuery_crmentity = "INSERT IGNORE INTO vtiger_crmentity_crm (" . implode(", ", $columns_crmentity) . ") VALUES (" . implode(", ", $insertValues_crmentity) . ")";

        // Execute the insert query
        if (!$conn->query($insertQuery_crmentity)) {
            echo "Error inserting into vtiger_crmentity_crm: " . $conn->error;
        }
    }
} else {
    echo "Error fetching from vtiger_crmentity: " . $remote_conn->error;
}

echo "<br>DONE";
?>
