<?php
include "dbconn.php";
include __DIR__ . '/../dictionaries.php';

// Query to get quotes with earliest unpaid deadline within 7 days
$sql = "SELECT q.quoteid, q.quote_no, q.subject, pp.payment_deadline, vp.productname, vp.vendorid
        FROM vtiger_quotes q
        LEFT JOIN vtiger_product_payment pp ON q.quoteid = pp.quoteid AND pp.is_paid = 0 AND pp.payment_deadline >= NOW()
        LEFT JOIN (
            SELECT productid, productName AS productname, vendorid FROM tdu_products 
            UNION 
            SELECT productid, productname, '' AS vendorid FROM vtiger_products_custom
        ) vp ON pp.productid = vp.productid
        WHERE 
            pp.payment_deadline <= DATE_ADD(NOW(), INTERVAL 7 DAY) AND 
            q.quoteid IN (SELECT MIN(quoteid) FROM vtiger_quotes GROUP BY quote_no) AND
            q.quotestage IN (
                    'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                    'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)');";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error fetching quotes: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result)) {
    $quote_id = $row['quoteid'];
    $vendorid = $row['vendorid'] ?? '';
    $quote_number = mysqli_real_escape_string($conn, $row['quote_no']);
    $subject = mysqli_real_escape_string($conn, $row['subject']);
    $productname = mysqli_real_escape_string($conn, $row['productname']);
    $payment_deadline = $row['payment_deadline'];

    createTaskWithMessage($conn, 'Vendor Payment Due', $quote_number, 'High', $payment_deadline, 'custom', $productname);

    if(!empty($vendorid)) {
        // Check if quoteid exists in vtiger_supplier_payment
        $check_supplier_payment_sql = "SELECT 1 FROM vtiger_supplier_payment WHERE quoteid = '$quote_id' AND vendorid = '$vendorid' LIMIT 1";
        $check_supplier_payment_result = mysqli_query($conn, $check_supplier_payment_sql);

        if (!$check_supplier_payment_result) {
            die("Error checking supplier payment: " . mysqli_error($conn));
        }

        if (mysqli_num_rows($check_supplier_payment_result) > 0) {
            // Update payment_deadline if quoteid exists and payment_deadline is NULL
            $update_sql = "UPDATE vtiger_supplier_payment 
                        SET payment_deadline = '$payment_deadline' 
                        WHERE quoteid = '$quote_id' AND vendorid = '$vendorid' AND payment_deadline IS NULL";
            if (!mysqli_query($conn, $update_sql)) {
                die("Error updating supplier payment: " . mysqli_error($conn));
            }
        } else {
            // Insert a new record if quoteid does not exist
            $insert_supplier_payment_sql = "INSERT INTO vtiger_supplier_payment (quoteid, vendorid, payment_deadline)  
                                            VALUES ('$quote_id', '$vendorid', '$payment_deadline')";
            if (!mysqli_query($conn, $insert_supplier_payment_sql)) {
                die("Error inserting into supplier payment: " . mysqli_error($conn));
            }
        }
    }
}

echo "Cron job executed successfully.";
?>
