<?php
// fetch adult/child price for quote summary -> Add CRM Products

include 'remotedbconn.php';
include 'dbconn.php';

$remote_query = "SELECT * FROM vtiger_products";
$remote_result = mysqli_query($remote_conn, $remote_query);

if ($remote_result && mysqli_num_rows($remote_result) > 0) {
    while ($row = mysqli_fetch_assoc($remote_result)) {
        $columns = array_keys($row);
        $values = array_values($row);

        $escaped_values = array_map(function($value) use ($conn) {
            return "'" . mysqli_real_escape_string($conn, $value) . "'";
        }, $values);

        $columns_str = implode(", ", array_map(function($col) { return "`$col`"; }, $columns));
        $values_str = implode(", ", $escaped_values);

        $update_str = implode(", ", array_map(function($col) use ($row, $conn) {
            return "`$col` = '" . mysqli_real_escape_string($conn, $row[$col]) . "'";
        }, $columns));

        $query = "
            INSERT INTO vtiger_products ($columns_str)
            VALUES ($values_str)
            ON DUPLICATE KEY UPDATE $update_str
        ";

        mysqli_query($conn, $query);

        if (mysqli_error($conn)) {
            echo "Error: " . mysqli_error($conn) . "<br>";
        }
    }
    echo "vtiger_products synchronization completed successfully.<br>";
} else {
    echo "No records found in the remote table or query failed.<br>";
}

$remote_query = "SELECT * FROM vtiger_productcf";
$remote_result = mysqli_query($remote_conn, $remote_query);

if ($remote_result && mysqli_num_rows($remote_result) > 0) {
    while ($row = mysqli_fetch_assoc($remote_result)) {
        $columns = array_keys($row);
        $values = array_values($row);

        $escaped_values = array_map(function($value) use ($conn) {
            return "'" . mysqli_real_escape_string($conn, $value) . "'";
        }, $values);

        $columns_str = implode(", ", array_map(function($col) { return "`$col`"; }, $columns));
        $values_str = implode(", ", $escaped_values);

        $update_str = implode(", ", array_map(function($col) use ($row, $conn) {
            return "`$col` = '" . mysqli_real_escape_string($conn, $row[$col]) . "'";
        }, $columns));

        $query = "
            INSERT INTO vtiger_productcf ($columns_str)
            VALUES ($values_str)
            ON DUPLICATE KEY UPDATE $update_str
        ";

        mysqli_query($conn, $query);

        if (mysqli_error($conn)) {
            echo "Error: " . mysqli_error($conn) . "<br>";
        }
    }
    echo "vtiger_productcf synchronization completed successfully.<br>";
} else {
    echo "No records found in the remote table or query failed.<br>";
}

mysqli_close($remote_conn);
mysqli_close($conn);

echo "<br>DONE";
?>