<?php
include "dbconn.php";
include __DIR__ . '/../dictionaries.php';

// Query to get quotes where vqcf.1182 is exactly 2 days from today
$sql = "SELECT vq.quote_no, vqcf.cf_1182 AS custom_date
        FROM (
            SELECT quoteid, quote_no
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(sub.quoteid)
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no
            )
        ) vq
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
        WHERE DATE(vqcf.cf_1182) = CURDATE() + INTERVAL 2 DAY";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error fetching quotes: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result)) {
    $quote_no = mysqli_real_escape_string($conn, $row['quote_no']);
    createTaskWithMessage($conn, 'Quote Payment Due', $quote_no, 'High', null, 'custom');
}

echo "Custom date-based cron job executed successfully.";
?>
