<?php
include "dbconn.php";

// Function to calculate the first Monday or Thursday before the given travel date
function getFirstMondayOrThursdayBefore($travel_date, $cf_928) {
    $travel_date_obj = new DateTime($travel_date);
    if($cf_928 == 'Hotel') {
        $travel_date_obj->modify('-35 days');
    }
    else {
        $travel_date_obj->modify('-7 days');
    }
    $day_of_week = $travel_date_obj->format('N');
    
    if (in_array($day_of_week, [2, 3, 4])) {
        // If Tuesday, Wednesday, or Thursday, go to the previous week's Monday
        $first_monday_or_thursday = $travel_date_obj->modify('last Monday')->format('Y-m-d');
    } else {
        // If Friday, Saturday, Sunday, or Monday, go to the previous week's Thursday
        $first_monday_or_thursday = $travel_date_obj->modify('last Thursday')->format('Y-m-d');
    }
    return $first_monday_or_thursday;
}

// Step 1: Get data from vtiger_inventoryproductrel and vtiger_quotescf, including productid
$query = "SELECT vi.id, vi.sequence_no, vi.day, vi.productid, vi.cf_928, vqcf.cf_1162
        FROM (SELECT quoteid, quotestage FROM vtiger_quotes 
              WHERE quoteid IN (SELECT MIN(quoteid) FROM vtiger_quotes GROUP BY quote_no)) vq 
        LEFT JOIN vtiger_quotescf vqcf ON vqcf.quoteid = vq.quoteid
        LEFT JOIN vtiger_inventoryproductrel vi ON vi.id = vq.quoteid
        WHERE vqcf.cf_1162 IS NOT NULL AND vqcf.cf_1162 != '0000-00-00' AND vqcf.cf_1162 >= NOW()  
            AND vq.quotestage IN (
                    'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                    'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
                );";
$result = mysqli_query($conn, $query);

if (!$result) {
    die("Error in SELECT query: " . mysqli_error($conn));
}

// Step 2: Process each row and insert/update in vtiger_product_payment
while ($row = mysqli_fetch_assoc($result)) {
    $quoteid = $row['id'];
    $sequence_no = $row['sequence_no'];
    $productid = $row['productid'];
    $cf_928 = $row['cf_928'];
    $cf_1162_date = $row['cf_1162'];
    $day_increment = $row['day'];

    // Calculate travel_date and payment_deadline
    $travel_date_obj = new DateTime($cf_1162_date);
    $travel_date_obj->modify("+{$day_increment} days -1 day");
    $travel_date = $travel_date_obj->format('Y-m-d');
    $payment_deadline = getFirstMondayOrThursdayBefore($travel_date, $cf_928);

    // Step 3: Insert or update the vtiger_product_payment table
    $sql = "
        INSERT INTO vtiger_product_payment (quoteid, sequence_no, productid, travel_date, payment_deadline)
        VALUES ('$quoteid', '$sequence_no', '$productid', '$travel_date', '$payment_deadline')
        ON DUPLICATE KEY UPDATE 
            productid = '$productid',
            travel_date = '$travel_date',
            payment_deadline = '$payment_deadline'
    ";
    
    if (!mysqli_query($conn, $sql)) {
        echo "Error in INSERT/UPDATE for quoteid $quoteid: " . mysqli_error($conn) . "<br>";
    }
    // echo $sql . "<br>";
}

// Close the connection
mysqli_close($conn);

echo "<br>DONE";
?>
