<?php
// update quote stage from crm

include 'remotedbconn.php';
include 'dbconn.php';

// Query to fetch quotestage from remote database
$remote_query = "SELECT quoteid, quotestage FROM vtiger_quotes";
$remote_result = mysqli_query($remote_conn, $remote_query);

if (!$remote_result) {
    die("Error fetching data from remote database: " . mysqli_error($remote_conn));
}

// Loop through the remote database records
while ($remote_row = mysqli_fetch_assoc($remote_result)) {
    $remote_quoteid = $remote_row['quoteid'];
    $remote_quotestage = $remote_row['quotestage'];

    // Fetch the corresponding quotestage from the local database
    $local_query = "SELECT quotestage FROM vtiger_quotes_crm WHERE quoteid = '$remote_quoteid'";
    $local_result = mysqli_query($conn, $local_query);

    if (!$local_result) {
        continue;
    }

    // Check if the quote exists in the local database
    if (mysqli_num_rows($local_result) > 0) {
        $local_row = mysqli_fetch_assoc($local_result);
        $local_quotestage = $local_row['quotestage'];

        // If the quotestage is different, update it in the local database
        if ($local_quotestage != $remote_quotestage) {
            $update_query = "UPDATE vtiger_quotes_crm SET quotestage = '$remote_quotestage' WHERE quoteid = '$remote_quoteid'";
            if (mysqli_query($conn, $update_query)) {
                echo "Updated quotestage for quoteid $remote_quoteid from '$local_quotestage' to '$remote_quotestage'.<br>";
            } else {
                echo "Error updating quotestage for quoteid $remote_quoteid: " . mysqli_error($conn) . "<br>";
            }
        }
    }
}

// Close the database connections
mysqli_close($remote_conn);
mysqli_close($conn);

echo "Synchronization complete.";

echo "<br>DONE";
?>
