<?php
include 'dbconn.php';

// Fetch the maximum contactid to ensure unique contactid increment
$max_contactid_sql = "SELECT MAX(contactid) as max_contactid FROM vtiger_contactdetails";
$max_contactid_result = mysqli_query($conn, $max_contactid_sql);

if (!$max_contactid_result) {
    die("Error fetching maximum contactid: " . mysqli_error($conn));
}

$max_contactid_row = mysqli_fetch_assoc($max_contactid_result);
$max_contactid = $max_contactid_row['max_contactid'] ?? 0; // Use 0 if table is empty

$sql = "SELECT organizationid, name FROM tdu_contacts WHERE organizationid > 2335438";
$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Error fetching contacts: " . mysqli_error($conn));
}

while ($row = mysqli_fetch_assoc($result)) {
    $organizationid = mysqli_real_escape_string($conn, $row['organizationid']);
    $name = mysqli_real_escape_string($conn, $row['name']);

    $name_parts = explode(' ', $name, 2);
    $firstname = isset($name_parts[0]) ? $name_parts[0] : '';
    $lastname = isset($name_parts[1]) ? $name_parts[1] : '';

    $check_sql = "
        SELECT 1 
        FROM vtiger_contactdetails 
        WHERE accountid = '$organizationid' 
        AND CONCAT(firstname, ' ', lastname) = '$name'
    ";
    $check_result = mysqli_query($conn, $check_sql);

    if (mysqli_num_rows($check_result) > 0) {
        // Skip if contact already exists
        continue;
    }

    // Increment contactid
    $max_contactid++;

    $insert_sql = "
        INSERT INTO vtiger_contactdetails (contactid, accountid, firstname, lastname)
        VALUES ('$max_contactid', '$organizationid', '$firstname', '$lastname')
        ON DUPLICATE KEY UPDATE firstname = '$firstname', lastname = '$lastname'
    ";

    if (!mysqli_query($conn, $insert_sql)) {
        echo "Error inserting/updating organizationid $organizationid: " . mysqli_error($conn) . "\n";
    }
}

mysqli_close($conn);
echo "DONE";
?>
