<?php

// Include the database connection file
include 'dbconn.php';

try {
    // Fetch data from the database based on the query
    $fetchQuery = "
        SELECT vq.quoteid, vg.groupname
        FROM (
            SELECT *
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(quoteid) AS quoteid
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no
            )
            ORDER BY quote_no DESC
        ) vq
        LEFT JOIN vtiger_crmentity vuvc ON vq.quoteid = vuvc.crmid
        LEFT JOIN vtiger_groups vg ON vg.groupid = vuvc.smownerid
        WHERE vg.groupname IS NOT NULL;
    ";

    // Execute the query
    $result = mysqli_query($conn, $fetchQuery);

    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $quoteId = $row['quoteid'];
            $groupName = $row['groupname'];

            // Check if the record exists
            $checkQuery = "SELECT 1 FROM vtiger_quotes_info WHERE quoteid = '$quoteId' AND quotetype = 'group'";
            $checkResult = mysqli_query($conn, $checkQuery);

            if (mysqli_num_rows($checkResult) == 0) {
                // Insert if not exist
                $insertQuery = "INSERT INTO vtiger_quotes_info (quoteid, assigned_to_region, quotetype) VALUES ('$quoteId', '$groupName', 'group')";
                mysqli_query($conn, $insertQuery);
            } else {
                // Update if exists
                $updateQuery = "UPDATE vtiger_quotes_info SET assigned_to_region = '$groupName' WHERE quoteid = '$quoteId' AND quotetype = 'group'";
                mysqli_query($conn, $updateQuery);
            }
        }
    }

    echo "Cron job executed successfully.";

} catch (Exception $e) {
    echo "Error executing cron job: " . $e->getMessage();
}

// Close the database connection
mysqli_close($conn);
