<?php
include "dbconn.php";

// Fetch quotes with linked contact data
$sql = "SELECT vq.quoteid, tc.name AS contact_name, tc.email, tc.mobile 
        FROM vtiger_quotes vq
        LEFT JOIN tdu_contacts tc ON vq.contactid = tc.auto_id
        WHERE tc.auto_id IS NOT NULL";
$result = mysqli_query($conn, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $contact_name = mysqli_real_escape_string($conn, $row['contact_name']);
        $email = mysqli_real_escape_string($conn, $row['email']);
        $mobile = mysqli_real_escape_string($conn, $row['mobile']);

        $update_sql = " UPDATE vtiger_quotes_info
                        SET 
                            travel_agent_contact_name = CASE
                                WHEN travel_agent_contact_name IS NULL OR travel_agent_contact_name = '' THEN '$contact_name'
                                ELSE travel_agent_contact_name
                            END,
                            email = CASE
                                WHEN email IS NULL OR email = '' THEN '$email'
                                ELSE email
                            END,
                            mobile_phone = CASE
                                WHEN mobile_phone IS NULL OR mobile_phone = '' THEN '$mobile'
                                ELSE mobile_phone
                            END
                        WHERE quoteid = '$quoteid' AND quotetype = 'group'";
        mysqli_query($conn, $update_sql);
    }
}

mysqli_close($conn);
