<?php
include "dbconn.php";
include "remotedbconn.php";

$query = "SELECT * FROM vtiger_users";
$result = $remote_conn->query($query);

if ($result->num_rows > 0) {
    // Get column names
    $columns = [];
    while ($fieldInfo = $result->fetch_field()) {
        $columns[] = $fieldInfo->name;
    }

    // Loop through each row and insert into local database
    while ($user = $result->fetch_assoc()) {
        // Construct the insert query dynamically
        $insertValues = [];
        $updateValues = [];
        
        foreach ($columns as $column) {
            $value = $user[$column];
            $insertValues[] = is_null($value) ? 'NULL' : "'" . $conn->real_escape_string($value) . "'";
            
            if ($column != 'title' && $column != 'department') {
                $updateValues[] = "$column = " . (is_null($value) ? 'NULL' : "'" . $conn->real_escape_string($value) . "'");
            }
        }

        $insertQuery = "INSERT INTO vtiger_users (" . implode(", ", $columns) . ") VALUES (" . implode(", ", $insertValues) . ") ON DUPLICATE KEY UPDATE " . implode(", ", $updateValues);
        
        // Execute the insert query
        if (!$conn->query($insertQuery)) {
            echo "Error inserting/updating data: " . $conn->error . "\n";
        }
    }

    echo "Data copied successfully!";
} else {
    echo "No data found in the remote table.";
}

echo "<br>DONE";
?>
