<?php
// test_exchange_rate.php

// Include the QBOUtilityLibrary
require_once __DIR__ . '/../qbo_functions.php'; // Ensure this path is correct

// --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
// IMPORTANT: CONFIGURE YOUR QBO APP DETAILS HERE
// --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
$qboConfig = [
    'auth_mode'       => 'oauth2',
    'ClientID'        => "AB3WEwQtfG1Ws43pqxY7Y2Ok3s7QfN97VniZxSssaQhl9PA4JE",
    'ClientSecret'    => "GRjmj4WxpMo5ZkMOjfnEQ5LmzXkAna1xb9YpwEWL",
    'accessTokenKey'  => "eyJhbGciOiJkaXIiLCJlbmMiOiJBMTI4Q0JDLUhTMjU2IiwieC5vcmciOiJIMCJ9..CSzURhmZqBNYFYoGZOQKAg.62blb5tQvqV5Ad38Vtzu-_zH5jsJKvUaUUN-Bi5Y7jbZaBKZ3igNOSwZnRNHmAaGqu-uO8DYbvHaXN-TdipGwUkI3yrEB2cfLv2E5dF9pCY8TlOmol9OzJwV8e_OIw3-mGIC1gEaGt4IQ-J658f3pZig_CXkUyRS3Z9Otc9q9bym5HORNEL6yzDkZHvyCXHM4-Cm7X9uBG1YZvDn87Dbrz6zimvjcIIN0HDMBAGQX7sda58GxdKmQQMt8G2sH84wtd0pFxkMU0ZdYaIWJ_JagpaaS5ZmoLMvOG38oMhmf7mRptwXVkkcyPuApAst0e0svQau10S7tCzZ1ds-5E88uG1toEJ_dwRuVXe5XEj_OOIY3O4xJ0yDpYbgiWKOHZQ0m2Aopvq_D-GO9b9QpjmDPwJmkPaLdWEva4rMBL92eHRjK3ieWEXbt85yJMkCcRGyGYZmXjQhMzTXSH7j3uSlFWh0bpuxAXVHgA6b3xUhOtMREKZJnJ85mqf9qC_wj2VOVA_7MVFwD-K6rGgnrzM7f2Xj_CA7GAivOi84NmljQ6jPtEkadrCWpD15k8TT5Bl7Mt50GElChRN-T2Go_6IYAVfwdVXR7VSXCF0B_rKAARgoXD-ylj0O2GniWfiW1mBY.KnlwPyRmov_A2To1KKTeMw",
    'refreshTokenKey' => "RT1-151-H0-1757204986jq2zgkueu6jxrg28n1rz",
    'QBORealmID'      => "9341454710400258",
    'baseUrl'         => "Development",
];
// --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
$qboUtility = new QBOUtilityLibrary($qboConfig);
$currencyCode = '';
$asOfDate = '';
$exchangeRateInfo = null;
$errorMessage = '';
$successMessage = '';
$action = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currencyCode = strtoupper(trim($_POST['currency_code'] ?? ''));
    $asOfDate = trim($_POST['as_of_date'] ?? '');

    if (isset($_POST['get_specific_date_rate'])) {
        $action = 'specific_date';
    } elseif (isset($_POST['get_latest_rate'])) {
        $action = 'latest';
    }

    if (empty($currencyCode)) {
        $errorMessage = "Currency code cannot be empty.";
    } else {
        if ($action === 'specific_date' && empty($asOfDate)) {
            $errorMessage = "Date cannot be empty for specific date lookup.";
        } elseif ($action === 'specific_date' && !preg_match('/^\d{4}-\d{2}-\d{2}$/', $asOfDate)) {
            $errorMessage = "Date must be in YYYY-MM-DD format.";
        }
    }

    if (empty($errorMessage)) { // Proceed if no initial validation errors
        try {
            if ($qboConfig['ClientID'] === 'YOUR_CLIENT_ID' || $qboConfig['ClientSecret'] === 'YOUR_CLIENT_SECRET') {
                throw new \Exception("Please configure your QBO ClientID and ClientSecret in the \$qboConfig array in test_exchange_rate.php before running.");
            }

            $qboUtility = new QBOUtilityLibrary($qboConfig);

            if ($action === 'specific_date') {
                $exchangeRateInfo = $qboUtility->getExchangeRateForCurrency($currencyCode, $asOfDate);
                if ($exchangeRateInfo) {
                    $successMessage = "Exchange Rate found for {$currencyCode} as of {$asOfDate}:";
                } else {
                    $errorMessage = "No exchange rate found for {$currencyCode} as of {$asOfDate}. This could mean QBO doesn't have a rate for this specific currency/date, or the currency code is not enabled/valid for your QBO company.";
                }
            } elseif ($action === 'latest') {
                $exchangeRateInfo = $qboUtility->getMostRecentExchangeRate($currencyCode); // Using the new method
                if ($exchangeRateInfo) {
                    $effectiveDate = $exchangeRateInfo->AsOfDate ?? 'N/A';
                    $successMessage = "Latest recorded exchange rate found for {$currencyCode} (effective {$effectiveDate}):";
                } else {
                    $errorMessage = "No exchange rate records found for {$currencyCode}. Ensure the currency is valid and has rates recorded in QBO.";
                }
            }

        } catch (QuickBooksOnline\API\Exception\IdsException $e) {
            $errorMessage = "QBO API Error: " . $e->getMessage() . "<br>";
        } catch (\InvalidArgumentException $e) {
            $errorMessage = "Input Error: " . $e->getMessage();
        } catch (\Exception $e) {
            $errorMessage = "An unexpected error occurred: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QBO Exchange Rate Tester</title>
    <style>
        body { font-family: sans-serif; margin: 20px; background-color: #f4f4f4; }
        .container { background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); max-width: 600px; margin: auto; }
        h1 { color: #333; text-align: center; }
        label { display: block; margin-top: 10px; margin-bottom: 5px; color: #555; }
        input[type="text"], input[type="date"] {
            width: 100%; /* Full width */
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        .button-group { display: flex; justify-content: space-between; gap: 10px; margin-top:20px; }
        input[type="submit"] {
            flex-grow: 1; /* Allow buttons to grow */
            background-color: #007bff;
            color: white;
            padding: 12px 15px; /* Adjusted padding */
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }
        input[type="submit"]:hover { background-color: #0056b3; }
        input[type="submit"].secondary { background-color: #6c757d; }
        input[type="submit"].secondary:hover { background-color: #545b62; }
        .message {
            padding: 15px;
            margin-top: 20px;
            border-radius: 4px;
            font-weight: bold;
        }
        .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        pre { background-color: #eee; padding: 10px; border-radius: 4px; white-space: pre-wrap; word-wrap: break-word; font-size: 0.9em; }
        .warning { background-color: #fff3cd; color: #856404; border: 1px solid #ffeeba; padding: 15px; margin-bottom:20px; border-radius: 4px;}
    </style>
</head>
<body>
    <div class="container">
        <h1>QuickBooks Online Exchange Rate Finder</h1>

        <?php if ($qboConfig['ClientID'] === 'YOUR_CLIENT_ID'): ?>
            <div class="warning">
                <strong>Configuration Needed:</strong> Please update the <code>$qboConfig</code> array in
                <code>test_exchange_rate.php</code> with your actual QuickBooks Online application credentials
                before using this tool.
            </div>
        <?php endif; ?>

        <form action="test_exchange_rate.php" method="POST">
            <div>
                <label for="currency_code">Currency Code (e.g., USD, CAD, EUR, NZD):</label>
                <input type="text" id="currency_code" name="currency_code" value="<?= htmlspecialchars($currencyCode) ?>" required placeholder="e.g., NZD">
            </div>
            <div>
                <label for="as_of_date">As of Date (for specific date lookup):</label>
                <input type="date" id="as_of_date" name="as_of_date" value="<?= htmlspecialchars($asOfDate ?: date('Y-m-d')) ?>">
            </div>
            <div class="button-group">
                <input type="submit" name="get_specific_date_rate" value="Get Rate for Specific Date">
                <input type="submit" name="get_latest_rate" value="Get Latest Recorded Rate" class="secondary">
            </div>
        </form>

        <?php if ($errorMessage): ?>
            <div class="message error">
                <p><strong>Error:</strong></p>
                <p><?= $errorMessage; // Allow HTML for error details from IdsException ?></p>
            </div>
        <?php endif; ?>

        <?php if ($successMessage): ?>
            <div class="message success">
                <p><?= htmlspecialchars($successMessage) ?></p>
                <?php if ($exchangeRateInfo): ?>
                    <pre><?php
                        echo "Source Currency Code: " . htmlspecialchars($exchangeRateInfo->SourceCurrencyCode ?? 'N/A') . "\n";
                        echo "Target Currency Code (Home Currency): " . htmlspecialchars($exchangeRateInfo->TargetCurrencyCode ?? 'N/A') . "\n";
                        echo "Rate: " . htmlspecialchars($exchangeRateInfo->Rate ?? 'N/A') . "\n";
                        echo "As Of Date (Effective Date): " . htmlspecialchars($exchangeRateInfo->AsOfDate ?? 'N/A') . "\n";
                        // For debugging, you can uncomment the line below:
                        // print_r($exchangeRateInfo);
                    ?></pre>
                <?php endif; ?>
            </div>
        <?php endif; ?>

    </div>
</body>
</html>