<?php
// prototype_phase3_test_db_link.php
// Goal: Prove we can link a QBO Bill ID back to our local Vtiger records.

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- Essential Includes ---
require_once __DIR__ . '/../dbconn.php';

// =========================================================================
// --- PHASE 3: PROTOTYPE LOGIC ---
// =========================================================================

echo "--- Starting Prototype Phase 3: Test Local Database Linkage ---\n\n";

global $conn; // From dbconn.php
if (!$conn) {
    die("CRITICAL: Database connection failed. Check dbconn.php.\n");
}
echo "SUCCESS: Database connection established.\n";


// =========================================================================
// --- CRITICAL STEP FOR TESTING ---
// This is the Bill ID we found in the successful Phase 1 test.
$hardcodedQboBillId = '1335';
// =========================================================================


echo "\nStep 1: Querying local 'tdu_qbo_sync_history' table for QBO Bill ID: " . $hardcodedQboBillId . "\n";

// This query finds the Vtiger source data based on the QBO ID we have.
$sql = "SELECT source_identifier, organisation_name 
        FROM tdu_qbo_sync_history 
        WHERE qbo_entity_id = '" . mysqli_real_escape_string($conn, $hardcodedQboBillId) . "' 
          AND qbo_entity_type = 'Bill'
        LIMIT 1;";

$result = mysqli_query($conn, $sql);

if (!$result) {
    die("\nERROR: SQL query failed. Error: " . mysqli_error($conn) . "\n");
}

if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    
    echo "\nSUCCESS: Found a matching record in the local database!\n";
    echo "\n--- Linked Vtiger Data ---\n";
    echo "Quote Number (source_identifier): " . $row['source_identifier'] . "\n";
    echo "Vendor Name (organisation_name): " . $row['organisation_name'] . "\n";
    echo "---------------------------\n\n";
    
    echo "Phase 3 is complete. We have successfully linked a QBO transaction back to our internal records.\n";

} else {
    echo "\nINFO: No record found for Bill ID '{$hardcodedQboBillId}' in 'tdu_qbo_sync_history'.\n";
    echo "This is expected if you haven't synced this specific bill from Vtiger to QBO yet.\n";
    echo "Please ensure the original Bill (ID 1335) was created by your 'cronjob_qbo_processing.php' script.\n";
}

mysqli_close($conn);

echo "\n--- Prototype Phase 3 Finished ---\n";
?>