<?php
// test_find_taxcode.php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Adjust paths as necessary
require_once __DIR__ . '/../vendor/autoload.php'; // QBO SDK Autoloader
require_once __DIR__ . '/../qbo_functions.php'; // Your QBOUtilityLibrary

// --- Token Management & Logging Functions (Minimal for this test) ---
$tokenStorageFile = __DIR__ . '/../tokens/qbo_token.json'; // Centralized token file

function loadTokensForTaxTest() {
    global $tokenStorageFile;
    if (file_exists($tokenStorageFile)) {
        $json = file_get_contents($tokenStorageFile);
        return $json ? json_decode($json, true) : null;
    }
    return null;
}
// --- End Token Management ---

// --- QBO Configuration (Credentials mainly, tokens will be loaded) ---
$qboBaseConfig = [
    'auth_mode'       => 'oauth2',
    'ClientID'        => "AB3WEwQtfG1Ws43pqxY7Y2Ok3s7QfN97VniZxSssaQhl9PA4JE", // YOUR CLIENT ID
    'ClientSecret'    => "GRjmj4WxpMo5ZkMOjfnEQ5LmzXkAna1xb9YpwEWL", // YOUR CLIENT SECRET
    'QBORealmID'      => "9341454710400258",          // YOUR REALM ID
    'baseUrl'         => "Development",             // Or "Production"
    // 'logLocation'     => __DIR__ . "/qbo_sdk_logs_tax_test"
];

$currentTokens = loadTokensForTaxTest();
$qboConfigForLibrary = $qboBaseConfig;

if ($currentTokens && isset($currentTokens['access_token']) && isset($currentTokens['refresh_token'])) {
    $qboConfigForLibrary['accessTokenKey'] = $currentTokens['access_token'];
    $qboConfigForLibrary['refreshTokenKey'] = $currentTokens['refresh_token'];
} else {
    // For this simple test, we'll just output an error if tokens aren't found.
    // A more robust app would guide through authorization or token refresh.
    if ($_SERVER['REQUEST_METHOD'] === 'POST') { // Only show error if form submitted without tokens
        die("<p style='color:red; font-weight:bold;'>Error: QBO Tokens not found in {$tokenStorageFile}. Please ensure tokens are present and valid.</p>");
    }
}

$tax_code_name_input = '';
$search_result_display = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tax_code_name'])) {
    $tax_code_name_input = trim($_POST['tax_code_name']);

    if (empty($tax_code_name_input)) {
        $search_result_display = "<p style='color:orange; font-weight:bold;'>Please enter a tax code name to search.</p>";
    } elseif (empty($qboConfigForLibrary['accessTokenKey'])) {
        // This check is a bit redundant due to the die() above, but good for clarity
         $search_result_display = "<p style='color:red; font-weight:bold;'>Error: QBO Access Token is missing. Cannot perform search.</p>";
    }
    else {
        try {
            $qboLibrary = new QBOUtilityLibrary($qboConfigForLibrary);

            $search_result_display = "<h3>Searching for Tax Code: \"" . htmlspecialchars($tax_code_name_input) . "\"</h3>";

            $foundTaxCode = $qboLibrary->findTaxCodeByName($tax_code_name_input);

            if ($foundTaxCode) {
                $search_result_display .= "<p style='color:green; font-weight:bold;'>Tax Code Found!</p>";
                $search_result_display .= "<pre>";
                $search_result_display .= "ID: " . htmlspecialchars($foundTaxCode->Id ?? 'N/A') . "\n";
                $search_result_display .= "Name: " . htmlspecialchars($foundTaxCode->Name ?? 'N/A') . "\n";
                $search_result_display .= "Description: " . htmlspecialchars($foundTaxCode->Description ?? 'N/A') . "\n";
                $search_result_display .= "Active: " . (isset($foundTaxCode->Active) ? ($foundTaxCode->Active ? 'True' : 'False') : 'N/A') . "\n";
                // Display TaxRateDetails if they exist (common for many tax codes)
                if (isset($foundTaxCode->SalesTaxRateList->TaxRateDetail) && is_array($foundTaxCode->SalesTaxRateList->TaxRateDetail)) {
                    $search_result_display .= "\nSales Tax Rate Details:\n";
                    foreach($foundTaxCode->SalesTaxRateList->TaxRateDetail as $rateDetail) {
                        $search_result_display .= "  - TaxRateRef ID: " . htmlspecialchars($rateDetail->TaxRateRef->value ?? 'N/A');
                        $search_result_display .= " (Name: " . htmlspecialchars($rateDetail->TaxRateRef->name ?? 'N/A') . ")\n";
                        $search_result_display .= "    TaxTypeApplicable: " . htmlspecialchars($rateDetail->TaxTypeApplicable ?? 'N/A') . "\n";
                    }
                }
                if (isset($foundTaxCode->PurchaseTaxRateList->TaxRateDetail) && is_array($foundTaxCode->PurchaseTaxRateList->TaxRateDetail)) {
                     $search_result_display .= "\nPurchase Tax Rate Details:\n";
                    foreach($foundTaxCode->PurchaseTaxRateList->TaxRateDetail as $rateDetail) {
                        $search_result_display .= "  - TaxRateRef ID: " . htmlspecialchars($rateDetail->TaxRateRef->value ?? 'N/A');
                        $search_result_display .= " (Name: " . htmlspecialchars($rateDetail->TaxRateRef->name ?? 'N/A') . ")\n";
                        $search_result_display .= "    TaxTypeApplicable: " . htmlspecialchars($rateDetail->TaxTypeApplicable ?? 'N/A') . "\n";
                    }
                }
                // For more details, you can print the whole object:
                // $search_result_display .= "\n\n--- Full Object Dump ---\n";
                // $search_result_display .= htmlspecialchars(print_r($foundTaxCode, true));
                $search_result_display .= "</pre>";

            } else {
                $search_result_display .= "<p style='color:red; font-weight:bold;'>Tax Code \"" . htmlspecialchars($tax_code_name_input) . "\" not found.</p>";
            }

        } catch (QuickBooksOnline\API\Exception\IdsException $e) {
            $search_result_display .= "<p style='color:red; font-weight:bold;'>QBO API Error:</p>";
            $search_result_display .= "<pre>";
            $search_result_display .= "Message: " . htmlspecialchars($e->getMessage()) . "\n";
            $search_result_display .= "HTTP Status Code: " . htmlspecialchars($e->getHttpStatusCode()) . "\n";
            $search_result_display .= "QBO Error Code: " . htmlspecialchars($e->getOAuthHelperError() ?? 'N/A') . "\n";
            $search_result_display .= "Detailed QBO Error Response: \n" . htmlspecialchars($e->getResponseBody() ?? 'N/A');
            $search_result_display .= "</pre>";
        } catch (InvalidArgumentException $e) {
            $search_result_display = "<p style='color:red; font-weight:bold;'>Configuration Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        } catch (Exception $e) {
            $search_result_display = "<p style='color:red; font-weight:bold;'>An unexpected error occurred: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>QBO Tax Code Finder</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f9f9f9; }
        .container { max-width: 700px; margin: auto; padding: 20px; background-color: #fff; border: 1px solid #ccc; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; text-align: center; }
        label { display: block; margin-bottom: 8px; font-weight: bold; color: #555; }
        input[type="text"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box;}
        input[type="submit"] { display: block; width: 100%; padding: 10px 15px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
        input[type="submit"]:hover { background-color: #0056b3; }
        .results { margin-top: 25px; padding: 15px; background-color: #eef7ff; border: 1px solid #cce0ff; border-radius: 4px; }
        pre { background-color: #f0f0f0; padding: 10px; border: 1px solid #e0e0e0; border-radius: 3px; white-space: pre-wrap; word-wrap: break-word; font-size: 0.9em; max-height: 300px; overflow-y: auto;}
        .token-warning { color: #856404; background-color: #fff3cd; border: 1px solid #ffeeba; padding: 10px; margin-bottom:15px; border-radius:4px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>QuickBooks Online Tax Code Finder</h1>

        <?php if (empty($qboConfigForLibrary['accessTokenKey'])): ?>
            <p class="token-warning"><strong>Warning:</strong> QBO Access Token not found. Please ensure <code>../tokens/qbo_token.json</code> exists and contains valid tokens.</p>
        <?php endif; ?>

        <form method="POST" action="">
            <div>
                <label for="tax_code_name">Enter Tax Code Name (Exact Match):</label>
                <input type="text" id="tax_code_name" name="tax_code_name" value="<?= htmlspecialchars($tax_code_name_input) ?>" required>
            </div>
            <div>
                <input type="submit" value="Find Tax Code">
            </div>
        </form>

        <?php if (!empty($search_result_display)): ?>
            <div class="results">
                <?= $search_result_display ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>