<?php
// test_query_invoice.php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Adjust paths as necessary
require_once '../vendor/autoload.php'; // QBO SDK Autoloader
require_once '../qbo_functions.php'; // Your QBOUtilityLibrary

// --- Token Management (Minimal for this test) ---
$tokenStorageFile = __DIR__ . '/../tokens/qbo_token.json';

function loadTokensForInvoiceQuery() {
    global $tokenStorageFile;
    if (file_exists($tokenStorageFile)) {
        $json = file_get_contents($tokenStorageFile);
        return $json ? json_decode($json, true) : null;
    }
    return null;
}
// --- End Token Management ---

// --- QBO Configuration ---
$qboBaseConfig = [
    'auth_mode'       => 'oauth2',
    'ClientID'        => "AB3WEwQtfG1Ws43pqxY7Y2Ok3s7QfN97VniZxSssaQhl9PA4JE", // YOUR CLIENT ID
    'ClientSecret'    => "GRjmj4WxpMo5ZkMOjfnEQ5LmzXkAna1xb9YpwEWL", // YOUR CLIENT SECRET
    'QBORealmID'      => "9341454710400258",          // YOUR REALM ID
    'baseUrl'         => "Development",             // Or "Production"
    // 'logLocation'     => __DIR__ . "/qbo_sdk_logs_inv_query_test"
];

$currentTokens = loadTokensForInvoiceQuery();
$qboConfigForLibrary = $qboBaseConfig;

if ($currentTokens && isset($currentTokens['access_token']) && isset($currentTokens['refresh_token'])) {
    $qboConfigForLibrary['accessTokenKey'] = $currentTokens['access_token'];
    $qboConfigForLibrary['refreshTokenKey'] = $currentTokens['refresh_token'];
} else {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        die("<p style='color:red; font-weight:bold;'>Error: QBO Tokens not found in {$tokenStorageFile}. Please ensure tokens are present and valid.</p>");
    }
}

$invoice_id_input = '';
$query_result_display = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['invoice_id'])) {
    $invoice_id_input = trim($_POST['invoice_id']);

    if (empty($invoice_id_input) || !is_numeric($invoice_id_input)) {
        $query_result_display = "<p style='color:orange; font-weight:bold;'>Please enter a numeric Invoice ID to query.</p>";
    } elseif (empty($qboConfigForLibrary['accessTokenKey'])) {
         $query_result_display = "<p style='color:red; font-weight:bold;'>Error: QBO Access Token is missing. Cannot perform query.</p>";
    } else {
        try {
            $qboLibrary = new QBOUtilityLibrary($qboConfigForLibrary);
            $dataService = $qboLibrary->getDataService(); // Get the underlying DataService object

            $query_result_display = "<h3>Querying for Invoice ID: \"" . htmlspecialchars($invoice_id_input) . "\"</h3>";

            // The DataService's findById method is used for fetching a single entity by its ID
            // The entity type for an Invoice is 'Invoice'
            $invoiceObject = $dataService->FindById('Invoice', $invoice_id_input);

            if ($invoiceObject) {
                $query_result_display .= "<p style='color:green; font-weight:bold;'>Invoice Found!</p>";
                $query_result_display .= "<h4>Full Invoice Data (JSON):</h4>";
                $query_result_display .= "<pre>";
                // Convert the object to JSON for pretty printing.
                // Note: The SDK objects can be complex. json_encode might not capture everything perfectly
                // if there are private/protected properties not exposed via getters or ArrayAccess.
                // However, for standard data properties, it usually works well.
                $query_result_display .= htmlspecialchars(json_encode($invoiceObject, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
                $query_result_display .= "</pre>";

                // Specifically display Line items and their TaxCodeRef for clarity
                if (isset($invoiceObject->Line) && is_array($invoiceObject->Line)) {
                    $query_result_display .= "<h4>Line Item Tax Details:</h4>";
                    $query_result_display .= "<pre>";
                    foreach ($invoiceObject->Line as $index => $line) {
                        $query_result_display .= "Line " . ($index + 1) . ":\n";
                        $query_result_display .= "  Description: " . htmlspecialchars($line->Description ?? 'N/A') . "\n";
                        $query_result_display .= "  Amount: " . htmlspecialchars($line->Amount ?? 'N/A') . "\n";
                        if (isset($line->SalesItemLineDetail->TaxCodeRef)) {
                            $query_result_display .= "  TaxCodeRef ID: " . htmlspecialchars($line->SalesItemLineDetail->TaxCodeRef->value ?? 'N/A');
                            $query_result_display .= " (Name: " . htmlspecialchars($line->SalesItemLineDetail->TaxCodeRef->name ?? 'N/A') . ")\n";
                        } else {
                            $query_result_display .= "  TaxCodeRef: Not Set on this line detail\n";
                        }
                        $query_result_display .= "-------------------------------------\n";
                    }
                    $query_result_display .= "</pre>";
                }

                // Display TxnTaxDetail
                if (isset($invoiceObject->TxnTaxDetail)) {
                    $query_result_display .= "<h4>Transaction Tax Detail (TxnTaxDetail):</h4>";
                    $query_result_display .= "<pre>";
                    $query_result_display .= htmlspecialchars(json_encode($invoiceObject->TxnTaxDetail, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
                    $query_result_display .= "</pre>";
                }


            } else {
                // This case should ideally not happen if FindById is successful,
                // as it throws an exception on failure (like 404 Not Found).
                // But as a fallback.
                $query_result_display .= "<p style='color:red; font-weight:bold;'>Invoice ID \"" . htmlspecialchars($invoice_id_input) . "\" not found (or no data returned).</p>";
            }

        } catch (QuickBooksOnline\API\Exception\IdsException $e) {
            $query_result_display .= "<p style='color:red; font-weight:bold;'>QBO API Error:</p>";
            $query_result_display .= "<pre>";
            $query_result_display .= "Message: " . htmlspecialchars($e->getMessage()) . "\n";
            $query_result_display .= "</pre>";
        } catch (InvalidArgumentException $e) { // For QBOUtilityLibrary instantiation
            $query_result_display = "<p style='color:red; font-weight:bold;'>Configuration Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        } catch (Exception $e) {
            $query_result_display = "<p style='color:red; font-weight:bold;'>An unexpected error occurred: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>QBO Invoice Query Tool</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f9f9f9; }
        .container { max-width: 900px; margin: auto; padding: 20px; background-color: #fff; border: 1px solid #ccc; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1, h3, h4 { color: #333; }
        h1 {text-align: center;}
        label { display: block; margin-bottom: 8px; font-weight: bold; color: #555; }
        input[type="text"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box;}
        input[type="submit"] { display: block; width: 100%; padding: 10px 15px; background-color: #5cb85c; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
        input[type="submit"]:hover { background-color: #4cae4c; }
        .results { margin-top: 25px; padding: 15px; background-color: #f0f8ff; border: 1px solid #d1e9ff; border-radius: 4px; }
        pre { background-color: #272822; color: #f8f8f2; padding: 15px; border-radius: 5px; white-space: pre-wrap; word-wrap: break-word; font-size: 0.9em; max-height: 600px; overflow-y: auto; }
        .token-warning { color: #856404; background-color: #fff3cd; border: 1px solid #ffeeba; padding: 10px; margin-bottom:15px; border-radius:4px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>QuickBooks Online Invoice Query Tool</h1>

        <?php if (empty($qboConfigForLibrary['accessTokenKey'])): ?>
            <p class="token-warning"><strong>Warning:</strong> QBO Access Token not found. Please ensure <code>../tokens/qbo_token.json</code> exists and contains valid tokens.</p>
        <?php endif; ?>

        <form method="POST" action="">
            <div>
                <label for="invoice_id">Enter Invoice ID to Query:</label>
                <input type="text" id="invoice_id" name="invoice_id" value="<?= htmlspecialchars($invoice_id_input) ?>" required placeholder="e.g., 408">
            </div>
            <div>
                <input type="submit" value="Query Invoice">
            </div>
        </form>

        <?php if (!empty($query_result_display)): ?>
            <div class="results">
                <?= $query_result_display ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>