<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "../dbconn.php"; // Vtiger Database Connection
global $conn;

// --- QBO Includes & Config ---
require_once __DIR__ . '/../qbo_functions.php'; // QBO Utility Library

$qboConfig = [
    'auth_mode'       => 'oauth2',
    'ClientID'        => "AB3WEwQtfG1Ws43pqxY7Y2Ok3s7QfN97VniZxSssaQhl9PA4JE",
    'ClientSecret'    => "GRjmj4WxpMo5ZkMOjfnEQ5LmzXkAna1xb9YpwEWL",
    'accessTokenKey'  => "eyJhbGciOiJkaXIiLCJlbmMiOiJBMTI4Q0JDLUhTMjU2IiwieC5vcmciOiJIMCJ9..CSzURhmZqBNYFYoGZOQKAg.62blb5tQvqV5Ad38Vtzu-_zH5jsJKvUaUUN-Bi5Y7jbZaBKZ3igNOSwZnRNHmAaGqu-uO8DYbvHaXN-TdipGwUkI3yrEB2cfLv2E5dF9pCY8TlOmol9OzJwV8e_OIw3-mGIC1gEaGt4IQ-J658f3pZig_CXkUyRS3Z9Otc9q9bym5HORNEL6yzDkZHvyCXHM4-Cm7X9uBG1YZvDn87Dbrz6zimvjcIIN0HDMBAGQX7sda58GxdKmQQMt8G2sH84wtd0pFxkMU0ZdYaIWJ_JagpaaS5ZmoLMvOG38oMhmf7mRptwXVkkcyPuApAst0e0svQau10S7tCzZ1ds-5E88uG1toEJ_dwRuVXe5XEj_OOIY3O4xJ0yDpYbgiWKOHZQ0m2Aopvq_D-GO9b9QpjmDPwJmkPaLdWEva4rMBL92eHRjK3ieWEXbt85yJMkCcRGyGYZmXjQhMzTXSH7j3uSlFWh0bpuxAXVHgA6b3xUhOtMREKZJnJ85mqf9qC_wj2VOVA_7MVFwD-K6rGgnrzM7f2Xj_CA7GAivOi84NmljQ6jPtEkadrCWpD15k8TT5Bl7Mt50GElChRN-T2Go_6IYAVfwdVXR7VSXCF0B_rKAARgoXD-ylj0O2GniWfiW1mBY.KnlwPyRmov_A2To1KKTeMw",
    'refreshTokenKey' => "RT1-151-H0-1757204986jq2zgkueu6jxrg28n1rz",
    'QBORealmID'      => "9341454710400258",
    'baseUrl'         => "Development",
];

define('QBO_DEFAULT_INCOME_ACCOUNT_ID_FOR_SERVICES', '84');
define('QBO_DEFAULT_EXPENSE_ACCOUNT_ID_FOR_PURCHASES', '8');
define('QBO_DEFAULT_TERM_NAME', 'Due on receipt');
define('DEFAULT_QBO_HOME_CURRENCY', 'AUD');
define('TARGET_GST_FREE_TAX_CODE_NAME', 'GST-free non-capital');

$quoteid = $_GET['quoteid'] ?? '2348599';
$date_of_travel_from_get = $_GET['date_of_travel'] ?? null;

$output_data = [
    'quoteid_processed' => $quoteid,
    'vtiger_quote_no' => null,
    'quote_country' => null,
    'date_of_travel' => null,
    'all_vendors_data_with_qbo_status' => [],
    'sql_queries_executed' => [],
    'debug_notes' => [],
    'qbo_operations_log' => []
];

$qboLibrary = null;
try {
    $qboLibrary = new QBOUtilityLibrary($qboConfig);
    $output_data['qbo_operations_log'][] = "QBOUtilityLibrary instantiated.";
} catch (Exception $e) {
    $output_data['debug_notes'][] = "FATAL: QBOUtilityLibrary instantiation error: " . $e->getMessage();
    header('Content-Type: application/json');
    echo json_encode($output_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_INVALID_UTF8_SUBSTITUTE);
    exit;
}

// --- Get QBO Account ID for "Cost of Sales" ---
$qboCostOfSalesAccountId = null;
try {
    $cosAccountName = 'Cost of sales'; // Or your exact QBO account name
    $output_data['qbo_operations_log'][] = "Attempting to find QBO Account: '{$cosAccountName}' for item setup.";
    $cosAccountObject = $qboLibrary->findAccountByName($cosAccountName);
    if ($cosAccountObject && !empty($cosAccountObject->Id)) {
        $qboCostOfSalesAccountId = $cosAccountObject->Id;
        $output_data['qbo_operations_log'][] = "QBO Account '{$cosAccountObject->Name}' (ID: {$qboCostOfSalesAccountId}) found for default item expense/income.";
    } else {
        $output_data['debug_notes'][] = "WARNING: QBO Account '{$cosAccountName}' NOT FOUND. Newly created items for bills might not have the correct Income/Expense accounts set automatically to 'Cost of Sales'. They will use fallbacks from defaultItemData or might fail if those are insufficient.";
    }
} catch (Exception $e) {
    $output_data['debug_notes'][] = "Error finding QBO Account '{$cosAccountName}': " . $e->getMessage() . ($e instanceof IdsException ? " | Resp: ".$e->getResponseBody() : "");
}
// --- End Get QBO Account ID for "Cost of Sales" ---

if ($conn) {
    // --- Fetch General Quote Details ---
    $sql_quote_meta = "SELECT vq.quote_no, vq.country AS QuoteCountry, vqcf.cf_1162 AS DateOfTravelActual
                       FROM vtiger_quotes vq
                       LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                       WHERE vq.quoteid = '" . mysqli_real_escape_string($conn, $quoteid) . "';";
    $output_data['sql_queries_executed'][] = $sql_quote_meta;
    $result_quote_meta = mysqli_query($conn, $sql_quote_meta);
    if ($result_quote_meta && mysqli_num_rows($result_quote_meta) > 0) {
        $row_meta = mysqli_fetch_assoc($result_quote_meta);
        $output_data['vtiger_quote_no'] = $row_meta['quote_no'];
        $output_data['quote_country'] = $row_meta['QuoteCountry'];
        if (!empty($date_of_travel_from_get)) { $output_data['date_of_travel'] = $date_of_travel_from_get; }
        else if (!empty($row_meta['DateOfTravelActual']) && $row_meta['DateOfTravelActual'] != '0000-00-00') {
            try { $output_data['date_of_travel'] = (new DateTime($row_meta['DateOfTravelActual']))->format('Y-m-d'); }
            catch (Exception $e) { $output_data['date_of_travel'] = $row_meta['DateOfTravelActual']; }
        } else { $output_data['date_of_travel'] = date('Y-m-d'); }
    } else {
        $output_data['debug_notes'][] = "No general details for quote ID: " . htmlspecialchars($quoteid);
        $output_data['date_of_travel'] = $date_of_travel_from_get ?? date('Y-m-d');
    }
    if($result_quote_meta) mysqli_free_result($result_quote_meta);

    // --- Get or Create QBO Class based on Vtiger quote_no ---
    $qboClassNameForBillLines = $output_data['vtiger_quote_no'];
    $qboClassRefId = null;
    if (empty($qboClassNameForBillLines)) {
        $output_data['debug_notes'][] = "Vtiger quote_no is empty. Bill lines will not be classified by quote number.";
    } else {
        try {
            $output_data['qbo_operations_log'][] = "Attempting to get/create QBO Class: '{$qboClassNameForBillLines}'";
            $classObject = $qboLibrary->getOrCreateClassByName($qboClassNameForBillLines);
            if ($classObject && !empty($classObject->Id)) {
                $qboClassRefId = $classObject->Id;
                $output_data['qbo_operations_log'][] = "QBO Class '{$classObject->Name}' (ID: {$qboClassRefId}) processed for bill lines.";
            } else { $output_data['debug_notes'][] = "Failed to get or create QBO Class for '{$qboClassNameForBillLines}'."; }
        } catch (Exception $e) { $output_data['debug_notes'][] = "Error QBO Class '{$qboClassNameForBillLines}': " . $e->getMessage() . ($e instanceof IdsException ? " | Resp: ".$e->getResponseBody() : "");}
    }

    // --- Get or Create QBO Term "Due on receipt" ---
    $qboTermRefId = null;
    try {
        $termName = QBO_DEFAULT_TERM_NAME;
        $defaultTermData = ['Name' => $termName, 'Type' => 'STANDARD', 'DueDays' => 0];
        $output_data['qbo_operations_log'][] = "Attempting to get/create QBO Term: '{$termName}'";
        $termObject = $qboLibrary->getOrCreateTermByName($termName, $defaultTermData);
        if ($termObject && !empty($termObject->Id)) {
            $qboTermRefId = $termObject->Id;
            $output_data['qbo_operations_log'][] = "QBO Term '{$termObject->Name}' (ID: {$qboTermRefId}) processed for bill headers.";
        } else { $output_data['debug_notes'][] = "Failed to get/create QBO Term '{$termName}'."; }
    } catch (Exception $e) { $output_data['debug_notes'][] = "Error QBO Term '" . QBO_DEFAULT_TERM_NAME . "': " . $e->getMessage() . ($e instanceof IdsException ? " | Resp: ".$e->getResponseBody() : "");}

    // --- Get QBO TaxCode "GST-free non-capital (0%)" ---
    $qboTaxCodeRefId = null;
    try {
        $taxCodeName = TARGET_GST_FREE_TAX_CODE_NAME;
        $output_data['qbo_operations_log'][] = "Attempting to find QBO TaxCode: '{$taxCodeName}'";
        $taxCodeObject = $qboLibrary->findTaxCodeByName($taxCodeName);
        if ($taxCodeObject && !empty($taxCodeObject->Id)) {
            $qboTaxCodeRefId = $taxCodeObject->Id;
            $output_data['qbo_operations_log'][] = "QBO TaxCode '{$taxCodeObject->Name}' (ID: {$qboTaxCodeRefId}) found for bill lines.";
        } else {
            $output_data['debug_notes'][] = "QBO TaxCode '{$taxCodeName}' NOT FOUND. Bill lines will not use this specific tax code.";
        }
    } catch (Exception $e) {
        $output_data['debug_notes'][] = "Error finding QBO TaxCode '{$taxCodeName}': " . $e->getMessage() . ($e instanceof IdsException ? " | Resp: ".$e->getResponseBody() : "");
    }

    // --- Fetch PAX Numbers ---
    $single_rooms = $double_rooms = $triple_rooms = $child_without_bed = 0;
    $created_at_query_filter_for_pax = "";
    $invoice_initial_query_for_pax = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '" . mysqli_real_escape_string($conn, $quoteid) . "' AND type = 'initial'";
    $result_invoice_initial_for_pax = mysqli_query($conn, $invoice_initial_query_for_pax);
    if ($result_invoice_initial_for_pax && $invoice_initial_for_pax_row = mysqli_fetch_assoc($result_invoice_initial_for_pax)) {
        if (!empty($invoice_initial_for_pax_row['created_at'])) {
            $created_at_query_filter_for_pax = " AND created_at < '" . mysqli_real_escape_string($conn, $invoice_initial_for_pax_row['created_at']) . "' ";
        }
    }
    if($result_invoice_initial_for_pax) mysqli_free_result($result_invoice_initial_for_pax);
    $sql_pax_no = "SELECT meta_key, meta_value FROM vtiger_itinerary WHERE quoteid = '" . mysqli_real_escape_string($conn, $quoteid) . "' AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed') AND (meta_key, created_at) IN (SELECT meta_key, MAX(created_at) FROM vtiger_itinerary WHERE quoteid = '" . mysqli_real_escape_string($conn, $quoteid) . "' $created_at_query_filter_for_pax AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed') GROUP BY meta_key);";
    $result_pax_no = mysqli_query($conn, $sql_pax_no);
    if ($result_pax_no) { while ($row_pax_no = mysqli_fetch_assoc($result_pax_no)) { switch($row_pax_no['meta_key']) { case 'single_rooms': $single_rooms = (int)($row_pax_no['meta_value'] ?? 0); break; case 'double_rooms': $double_rooms = (int)($row_pax_no['meta_value'] ?? 0); break; case 'triple_rooms': $triple_rooms = (int)($row_pax_no['meta_value'] ?? 0); break; case 'child_without_bed': $child_without_bed = (int)($row_pax_no['meta_value'] ?? 0); break;}}}
    if($result_pax_no) mysqli_free_result($result_pax_no);

    // --- SQL to fetch ALL vendor and product details for the quote ---
    // Added sale_price_adult for clarity, assuming 'sale_price' is adult price for non-hotel/non-transfer/guide
    $sql_supplier_all_products = "SELECT DISTINCT vq.adults, vq.children, vq.infants, vv.vendorname, vv.vendorid, vi.productid AS lineitem_productid, vi.day, vi.cf_928, vi.sequence_no, vi.checkin, vi.checkout, vp.productname, vps.sale_price AS sale_price_adult, vps.sale_price_child, vps.sale_price_infant, vps.sale_price_single, vps.sale_price_double, vps.sale_price_triple, vps.sale_price_child_with_bed, vps.sale_price_child_no_bed, vps.subquoteid AS vps_subquoteid, vi.quantity AS vtiger_line_item_quantity FROM (SELECT * FROM vtiger_quotes WHERE quoteid='" . mysqli_real_escape_string($conn, $quoteid) . "') vq LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id LEFT JOIN ( SELECT productid, productname FROM vtiger_products_custom UNION ALL SELECT productid, productName AS productname FROM tdu_products ) vp ON vi.productid COLLATE utf8mb4_unicode_ci = vp.productid LEFT JOIN ( SELECT vendorid, vendorname FROM vtiger_vendor_custom UNION ALL SELECT vendorid, vendorName AS vendorname FROM tdu_vendors ) vv ON vi.vendorid COLLATE utf8mb4_unicode_ci = vv.vendorid LEFT JOIN vtiger_products_saleprice vps ON vq.quoteid = vps.quoteid AND vi.sequence_no = vps.sequence_no AND vps.subquoteid <= 1 WHERE vv.vendorname IS NOT NULL AND vi.productid IS NOT NULL ORDER BY vv.vendorname ASC, vi.sequence_no ASC;";
    $output_data['sql_queries_executed'][] = $sql_supplier_all_products;
    $result_supplier_all_products = mysqli_query($conn, $sql_supplier_all_products);

    $vendors_temp_data = [];
    $vendor_calculated_line_totals = []; // This will store the sum of all line amounts for a vendor

    if (!$result_supplier_all_products) {
        $output_data['debug_notes'][] = "SQL Error in \$sql_supplier_all_products: " . mysqli_error($conn);
    } else {
        while ($row = mysqli_fetch_assoc($result_supplier_all_products)) {
            // Initialize array for line item details to be split by pax type
            $line_items_pax_split = [];

            $adults_no_for_item = (int)($row['adults'] ?? 0);
            $children_no_for_item = (int)($row['children'] ?? 0);
            $infants_no_for_item = (int)($row['infants'] ?? 0);
            $item_type = $row['cf_928']; // Hotel, Transfers, Guide, or other

            if ($item_type == 'Hotel') {
                $total_nights = 1;
                if (!empty($row['checkin']) && !empty($row['checkout'])) {
                    try {
                        $checkin_date = new DateTime($row['checkin']);
                        $checkout_date = new DateTime($row['checkout']);
                        $total_nights = $checkin_date->diff($checkout_date)->days;
                        $total_nights = max(1, $total_nights);
                    } catch (Exception $e) {}
                }
                // Hotels are typically per room, not per pax type directly in this structure.
                // For simplicity, we'll treat the calculated hotel cost as one line.
                // If you need to split hotel costs by pax type, the logic would be more complex here.
                $hotel_cost_single = $single_rooms * (float)($row['sale_price_single'] ?? 0) * $total_nights;
                $hotel_cost_double = $double_rooms * (float)($row['sale_price_double'] ?? 0) * $total_nights;
                $hotel_cost_triple = $triple_rooms * (float)($row['sale_price_triple'] ?? 0) * $total_nights;
                $hotel_cost_child_no_bed = $child_without_bed * (float)($row['sale_price_child_no_bed'] ?? 0) * $total_nights;
                $total_hotel_cost = $hotel_cost_single + $hotel_cost_double + $hotel_cost_triple + $hotel_cost_child_no_bed;

                if ($total_hotel_cost > 0) {
                     $line_items_pax_split[] = [
                        'pax_type_description' => 'Hotel Room(s)', // Or more specific if needed
                        'quantity' => 1, // Representing the total hotel booking for these room types
                        'unit_price' => $total_hotel_cost,
                        'line_total' => $total_hotel_cost
                    ];
                }
            } else if ($item_type == 'Transfers' || $item_type == 'Guide') {
                // These are usually a flat rate, not per pax type from this data structure
                $flat_rate_cost = (float) ($row['sale_price_adult'] ?? 0); // Using sale_price_adult as the generic sale_price
                if ($flat_rate_cost > 0) {
                    $line_items_pax_split[] = [
                        'pax_type_description' => $item_type, // "Transfers" or "Guide"
                        'quantity' => (int)($row['vtiger_line_item_quantity'] ?? 1), // Use original quantity
                        'unit_price' => $flat_rate_cost / (int)($row['vtiger_line_item_quantity'] ?? 1), // Calculate unit price
                        'line_total' => $flat_rate_cost
                    ];
                }
            } else {
                // Default: Per Pax Type (Adults, Children, Infants)
                $adult_price = (float)($row['sale_price_adult'] ?? 0);
                $child_price = (float)($row['sale_price_child'] ?? 0);
                $infant_price = (float)($row['sale_price_infant'] ?? 0);

                if ($adults_no_for_item > 0 && $adult_price > 0) {
                    $line_items_pax_split[] = [
                        'pax_type_description' => 'Adult(s)',
                        'quantity' => $adults_no_for_item,
                        'unit_price' => $adult_price,
                        'line_total' => $adults_no_for_item * $adult_price
                    ];
                }
                if ($children_no_for_item > 0 && $child_price > 0) {
                     $line_items_pax_split[] = [
                        'pax_type_description' => 'Child(ren)',
                        'quantity' => $children_no_for_item,
                        'unit_price' => $child_price,
                        'line_total' => $children_no_for_item * $child_price
                    ];
                }
                if ($infants_no_for_item > 0 && $infant_price > 0) {
                    $line_items_pax_split[] = [
                        'pax_type_description' => 'Infant(s)',
                        'quantity' => $infants_no_for_item,
                        'unit_price' => $infant_price,
                        'line_total' => $infants_no_for_item * $infant_price
                    ];
                }
            }

            // Store these potentially split lines along with original row data
            if (!empty($line_items_pax_split)) {
                $row_to_store = $row; // Keep original row data for reference
                $row_to_store['pax_split_lines'] = $line_items_pax_split;

                $vendors_temp_data[$row['vendorname']]['details']['vtiger_vendor_id'] = $row['vendorid'];
                $vendors_temp_data[$row['vendorname']]['details']['vtiger_vendor_name'] = $row['vendorname'];
                $vendors_temp_data[$row['vendorname']]['products'][] = $row_to_store; // Store the modified row

                // Aggregate total for the vendor from these split lines
                foreach ($line_items_pax_split as $split_line) {
                    $vendor_calculated_line_totals[$row['vendorname']] =
                        ($vendor_calculated_line_totals[$row['vendorname']] ?? 0) + $split_line['line_total'];
                }
            }
        }
    }
    if($result_supplier_all_products) mysqli_free_result($result_supplier_all_products);

    $all_vendor_payments_summary = [];
    $sql_all_payments = "SELECT vendorid, SUM(total_amount) AS total_payable_summary, SUM(paid_amount) AS total_paid_summary, MAX(payment_deadline) AS latest_deadline, MAX(created_at) AS latest_created_at, GROUP_CONCAT(DISTINCT remark SEPARATOR '; ') AS all_remarks, GROUP_CONCAT(DISTINCT invoice_path SEPARATOR ',') AS all_invoice_paths FROM vtiger_supplier_payment sp WHERE sp.quoteid = '" . mysqli_real_escape_string($conn, $quoteid) . "' GROUP BY vendorid;";
    $output_data['sql_queries_executed'][] = $sql_all_payments;
    $result_all_payments = mysqli_query($conn, $sql_all_payments);
    if($result_all_payments){ while($payment_row = mysqli_fetch_assoc($result_all_payments)){ $all_vendor_payments_summary[$payment_row['vendorid']] = ['summary_supplier_invoice_total_due' => (float)($payment_row['total_payable_summary'] ?? 0), 'summary_total_paid_to_supplier' => (float)($payment_row['total_paid_summary'] ?? 0), 'summary_payment_due_date' => $payment_row['latest_deadline'], 'summary_last_record_created_at' => $payment_row['latest_created_at'], 'summary_supplier_invoice_ref_remark' => $payment_row['all_remarks'], 'summary_supplier_invoice_attachment_path' => $payment_row['all_invoice_paths'] ]; }
    } else { $output_data['debug_notes'][] = "SQL Error fetching all vendor payments: " . mysqli_error($conn); }
    if($result_all_payments) mysqli_free_result($result_all_payments);

    $qboGenericPurchaseItem = null;
    try {
        $genericItemName = "General Supplier Services (Vtiger Summary)";
        $genericItemData = ['Name' => $genericItemName, 'Type' => 'Service', 'IncomeAccountRef' => ['value' => QBO_DEFAULT_INCOME_ACCOUNT_ID_FOR_SERVICES],'ExpenseAccountRef' => ['value' => QBO_DEFAULT_EXPENSE_ACCOUNT_ID_FOR_PURCHASES], 'PurchaseCost' => 0];
        $output_data['qbo_operations_log'][] = "Attempting get/create generic QBO Item for summary: {$genericItemName}";
        $qboGenericPurchaseItem = $qboLibrary->getOrCreateItemByName($genericItemName, $genericItemData);
        if (!$qboGenericPurchaseItem || empty($qboGenericPurchaseItem->Id)) { throw new Exception("Failed to get/create generic QBO Item for summary lines '{$genericItemName}'."); }
        $output_data['qbo_operations_log'][] = "Generic QBO Item for summary '{$qboGenericPurchaseItem->Name}' (ID: {$qboGenericPurchaseItem->Id}) processed.";
    } catch (Exception $e) { $output_data['debug_notes'][] = "Warning: Error with generic QBO Item for summary: " . $e->getMessage() . ($e instanceof IdsException ? " | Resp: ".$e->getResponseBody() : "");}

    foreach($vendors_temp_data as $vendor_name_key => $vendor_detail_lines) {
        $vtiger_vid = $vendor_detail_lines['details']['vtiger_vendor_id'];
        $original_vtiger_vendor_name = $vendor_detail_lines['details']['vtiger_vendor_name'];
        $payment_summary = $all_vendor_payments_summary[$vtiger_vid] ?? [];

        $vendor_qbo_status_entry = [
            'vtiger_vendor_id' => $vtiger_vid, 'original_vtiger_vendor_name' => $original_vtiger_vendor_name,
            'qbo_vendor_id' => null, 'qbo_bill_id' => null, 'qbo_bill_status' => 'Not Processed',
            'qbo_bill_error_message' => null, 'qbo_bill_lines_created_count' => 0, 'qbo_bill_total_amount' => 0.0,
            'calculated_total_from_lines' => $vendor_calculated_line_totals[$vendor_name_key] ?? 0.0,
            'summary_total_from_vtiger_payment' => (float)($payment_summary['summary_supplier_invoice_total_due'] ?? 0.0)
        ];

        $createBill = false;
        if (!empty($vendor_detail_lines['products']) && ($vendor_calculated_line_totals[$vendor_name_key] ?? 0) > 0) { $createBill = true; }
        elseif (($payment_summary['summary_supplier_invoice_total_due'] ?? 0) > 0) { $createBill = true; if(empty($vendor_detail_lines['products'])) $output_data['debug_notes'][] = "Vendor '{$original_vtiger_vendor_name}' has amount in payment_summary but no product lines. Bill will be based on summary.";}
        if (!$createBill) { $vendor_qbo_status_entry['qbo_bill_status'] = 'Skipped - No costs/payment summary amount.'; $output_data['all_vendors_data_with_qbo_status'][] = $vendor_qbo_status_entry; continue; }

        try {
            $cleaned_vendor_name = trim($original_vtiger_vendor_name);
            if (empty($cleaned_vendor_name)) {
                $cleaned_vendor_name = "Unknown Vtiger Vendor {$vtiger_vid}";
                if(empty($original_vtiger_vendor_name)) $output_data['debug_notes'][] = "Original Vtiger Vendor name for ID {$vtiger_vid} was empty. Using placeholder: {$cleaned_vendor_name}";
                else $output_data['debug_notes'][] = "Vtiger Vendor name for ID {$vtiger_vid} ('{$original_vtiger_vendor_name}') became empty after trim. Using placeholder: {$cleaned_vendor_name}.";
            }
            $vendor_qbo_status_entry['cleaned_vendor_name_used_for_qbo'] = $cleaned_vendor_name;

            $current_transaction_currency = DEFAULT_QBO_HOME_CURRENCY;
            if (isset($output_data['quote_country'])) {
                if (strcasecmp($output_data['quote_country'], 'New Zealand') == 0) { $current_transaction_currency = 'NZD'; }
            }

            $vendorConfig = [
                'search_field' => 'DisplayName', 'search_value' => $cleaned_vendor_name,
                'create_data'  => [ "DisplayName" => $cleaned_vendor_name, "CompanyName" => $cleaned_vendor_name ]
            ];
            if ($current_transaction_currency !== DEFAULT_QBO_HOME_CURRENCY) {
               $vendorConfig['create_data']['CurrencyRef'] = ["value" => $current_transaction_currency];
            }

            $output_data['qbo_operations_log'][] = "Attempting get/create QBO Vendor: '{$cleaned_vendor_name}'";
            $qboVendor = $qboLibrary->getOrCreateVendor($vendorConfig['create_data'], $vendorConfig['search_field'], $vendorConfig['search_value']);
            if (!$qboVendor || empty($qboVendor->Id)) throw new Exception("Failed to get/create QBO Vendor '{$cleaned_vendor_name}'.");
            $vendor_qbo_status_entry['qbo_vendor_id'] = $qboVendor->Id;
            $output_data['qbo_operations_log'][] = "QBO Vendor '{$qboVendor->DisplayName}' (ID: {$qboVendor->Id}) processed.";

            $qboBillLineItems = [];
            $total_cost_from_processed_lines = 0.0;

            if (!empty($vendor_detail_lines['products'])) {
                foreach ($vendor_detail_lines['products'] as $vtiger_product_entry) { // Renamed $vtiger_line to $vtiger_product_entry
                    $qboItemName = trim($vtiger_product_entry['productname'] ?? "Unknown Product");
                    if (empty($qboItemName)) $qboItemName = "Vtiger Service (PID: {$vtiger_product_entry['lineitem_productid']})";

                    // Iterate through the pax_split_lines for this product entry
                    if (isset($vtiger_product_entry['pax_split_lines']) && is_array($vtiger_product_entry['pax_split_lines'])) {
                        foreach ($vtiger_product_entry['pax_split_lines'] as $split_line_detail) {
                            $pax_description_suffix = $split_line_detail['pax_type_description'];
                            $qboQuantity = (float) $split_line_detail['quantity'];
                            $lineSupplierUnitCost = (float) $split_line_detail['unit_price'];
                            $qboLineAmount = (float) $split_line_detail['line_total'];

                            if ($qboLineAmount == 0 && empty(trim($qboItemName))) continue; // Skip truly empty lines
                            if ($qboLineAmount == 0 && !empty(trim($qboItemName))) {
                                $output_data['debug_notes'][] = "Info: Adding $0.00 line for '{$qboItemName} - {$pax_description_suffix}' (Vendor: '{$cleaned_vendor_name}').";
                            }

                            $defaultQBOItemDataForSupplierItem = [
                                'Type' => 'Service',
                                'IncomeAccountRef' => ['value' => QBO_DEFAULT_INCOME_ACCOUNT_ID_FOR_SERVICES],
                                'ExpenseAccountRef' => ['value' => QBO_DEFAULT_EXPENSE_ACCOUNT_ID_FOR_PURCHASES],
                                'PurchaseCost' => round($lineSupplierUnitCost, 2)
                            ];
                            $output_data['qbo_operations_log'][] = "Attempting get/create QBO Item: '{$qboItemName}' for bill line (Pax: {$pax_description_suffix}). Will use 'Cost of Sales' (ID: {$qboCostOfSalesAccountId}) if available.";
                            $qboLineItem = $qboLibrary->getOrCreateItemByName(
                                $qboItemName,
                                $defaultQBOItemDataForSupplierItem,
                                $qboCostOfSalesAccountId
                            );

                            if (!$qboLineItem || empty($qboLineItem->Id)) {
                                $output_data['debug_notes'][] = "Failed get/create QBO Item '{$qboItemName}'. Skipping line part for '{$cleaned_vendor_name} - {$pax_description_suffix}'.";
                                continue;
                            }
                            $output_data['qbo_operations_log'][] = "QBO Item '{$qboLineItem->Name}' (ID: {$qboLineItem->Id}) for bill line processed.";

                            $billLineDetail = [
                                "ItemRef" => ["value" => $qboLineItem->Id, "name" => $qboLineItem->Name],
                                "Qty" => $qboQuantity,
                                "UnitPrice" => round($lineSupplierUnitCost, 2),
                            ];
                            if ($qboClassRefId) {
                                $billLineDetail["ClassRef"] = ["value" => $qboClassRefId, "name" => $qboClassNameForBillLines];
                            }
                            if ($qboTaxCodeRefId) {
                                $billLineDetail["TaxCodeRef"] = ["value" => $qboTaxCodeRefId];
                            }

                            // Construct the description including the pax type
                            //$lineDescription = substr($qboItemName . " - " . $pax_description_suffix . " (Q:{$quoteid} S:{$vtiger_product_entry['sequence_no']} SQ:{$vtiger_product_entry['vps_subquoteid']})", 0, 4000);
                            $lineDescription = $pax_description_suffix ?? '';

                            $qboBillLineItems[] = [
                                "Amount" => round($qboLineAmount, 2),
                                "DetailType" => "ItemBasedExpenseLineDetail",
                                "ItemBasedExpenseLineDetail" => $billLineDetail,
                                "Description" => $lineDescription
                            ];
                            $total_cost_from_processed_lines += $qboLineAmount;
                        }
                    } else {
                        // This case handles products that were not split (e.g., already simple or error in split logic)
                        // Or if your previous logic created 'actual_supplier_cost_for_line' directly without 'pax_split_lines'
                        $output_data['debug_notes'][] = "Warning: Product '{$qboItemName}' for vendor '{$cleaned_vendor_name}' did not have pax_split_lines. Using overall vtiger_line_item_quantity if available or defaulting to 1.";

                        $lineSupplierTotalCost = (float)($vtiger_product_entry['actual_supplier_cost_for_line'] ?? 0); // Fallback to original calculation if any
                        $lineVtigerQuantity = (float)($vtiger_product_entry['vtiger_line_item_quantity'] ?? 1);
                        $qboQuantity = $lineVtigerQuantity > 0 ? $lineVtigerQuantity : 1;
                        $qboLineAmount = $lineSupplierTotalCost;
                        $lineSupplierUnitCost = ($qboQuantity != 0 && $qboLineAmount != 0) ? $qboLineAmount / $qboQuantity : $qboLineAmount;


                        if ($qboLineAmount == 0 && empty(trim($qboItemName))) continue;
                        if ($qboLineAmount == 0 && !empty(trim($qboItemName))) { $output_data['debug_notes'][] = "Info: Adding $0.00 line for '{$qboItemName}' (Vendor: '{$cleaned_vendor_name}')."; }

                        $defaultQBOItemDataForSupplierItem = [
                            'Type' => 'Service',
                            'IncomeAccountRef' => ['value' => QBO_DEFAULT_INCOME_ACCOUNT_ID_FOR_SERVICES],
                            'ExpenseAccountRef' => ['value' => QBO_DEFAULT_EXPENSE_ACCOUNT_ID_FOR_PURCHASES],
                            'PurchaseCost' => round($lineSupplierUnitCost, 2)
                        ];
                        $qboLineItem = $qboLibrary->getOrCreateItemByName($qboItemName, $defaultQBOItemDataForSupplierItem, $qboCostOfSalesAccountId);
                        if (!$qboLineItem || empty($qboLineItem->Id)) {
                            $output_data['debug_notes'][] = "Failed get/create QBO Item '{$qboItemName}'. Skipping line for '{$cleaned_vendor_name}'.";
                            continue;
                        }
                        $billLineDetail = [
                            "ItemRef" => ["value" => $qboLineItem->Id, "name" => $qboLineItem->Name],
                            "Qty" => $qboQuantity, "UnitPrice" => round($lineSupplierUnitCost, 2),
                        ];
                        if ($qboClassRefId) { $billLineDetail["ClassRef"] = ["value" => $qboClassRefId, "name" => $qboClassNameForBillLines]; }
                        if ($qboTaxCodeRefId) { $billLineDetail["TaxCodeRef"] = ["value" => $qboTaxCodeRefId]; }
                        $qboBillLineItems[] = [
                            "Amount" => round($qboLineAmount, 2), "DetailType" => "ItemBasedExpenseLineDetail",
                            "ItemBasedExpenseLineDetail" => $billLineDetail,
                            "Description" => substr($qboItemName . " (Q:{$quoteid} S:{$vtiger_product_entry['sequence_no']} SQ:{$vtiger_product_entry['vps_subquoteid']})", 0, 4000)
                        ];
                        $total_cost_from_processed_lines += $qboLineAmount;
                    }
                }
            } // End of: if (!empty($vendor_detail_lines['products']))

            $vendor_qbo_status_entry['qbo_bill_lines_created_count'] = count($qboBillLineItems);
            $vendor_qbo_status_entry['calculated_total_from_lines'] = round($total_cost_from_processed_lines, 2);

            if (empty($qboBillLineItems) && ($payment_summary['summary_supplier_invoice_total_due'] ?? 0) > 0) {
                if ($qboGenericPurchaseItem && !empty($qboGenericPurchaseItem->Id)) {
                    $output_data['qbo_operations_log'][] = "No detailed lines for '{$cleaned_vendor_name}', creating summary bill line from payment data.";
                    $summaryAmount = (float)$payment_summary['summary_supplier_invoice_total_due'];
                    $summaryDesc = $payment_summary['summary_supplier_invoice_ref_remark'] ?? "Summary for Quote ID {$quoteid}";
                    if(empty(trim($summaryDesc))) $summaryDesc = "Services for Quote ID {$quoteid} by {$cleaned_vendor_name}";

                    $summaryLineDetail = ["ItemRef" => ["value" => $qboGenericPurchaseItem->Id, "name" => $qboGenericPurchaseItem->Name], "Qty" => 1, "UnitPrice" => $summaryAmount];
                    if ($qboClassRefId) { $summaryLineDetail["ClassRef"] = ["value" => $qboClassRefId, "name" => $qboClassNameForBillLines]; }
                    if ($qboTaxCodeRefId) { $summaryLineDetail["TaxCodeRef"] = ["value" => $qboTaxCodeRefId]; }

                    $qboBillLineItems[] = ["Amount" => $summaryAmount, "DetailType" => "ItemBasedExpenseLineDetail", "ItemBasedExpenseLineDetail" => $summaryLineDetail,"Description" => substr($summaryDesc, 0, 4000)];
                    $total_cost_from_processed_lines = $summaryAmount;
                    $vendor_qbo_status_entry['qbo_bill_lines_created_count'] = 1;
                    $vendor_qbo_status_entry['calculated_total_from_lines'] = round($summaryAmount, 2);
                    $output_data['debug_notes'][] = "Created summary bill line for '{$cleaned_vendor_name}'.";
                } else { $output_data['debug_notes'][] = "Warning: No detailed lines for '{$cleaned_vendor_name}' and generic summary item not available. Bill might be $0 or skipped."; }
            }

            if (empty($qboBillLineItems) || $total_cost_from_processed_lines <= 0) {
                 $vendor_qbo_status_entry['qbo_bill_status'] = 'Skipped';
                 $vendor_qbo_status_entry['qbo_bill_error_message'] = 'No billable lines with amount > 0 found or generated after all checks.';
                 $output_data['all_vendors_data_with_qbo_status'][] = $vendor_qbo_status_entry;
                 $output_data['qbo_operations_log'][] = "Skipping QBO Bill for '{$cleaned_vendor_name}': No billable lines with amount > 0.";
                 continue;
            }

            $billTxnDate = $output_data['date_of_travel'] ?? date('Y-m-d');
            // **MODIFICATION 1: Bill Number Format**
            $billDocNumber = 'B' . date('YmdHis'); // B + datetime
            $vendor_payment_ref = $payment_summary['summary_supplier_invoice_ref_remark'] ?? null;
            if(!empty($vendor_payment_ref)) {
                $billDocNumber .= "-" . substr(preg_replace("/[^A-Za-z0-9]/", '', $vendor_payment_ref), 0, 5); // Append part of vendor ref
            }
            $billDocNumber = substr($billDocNumber, 0, 21); // Ensure it fits QBO limit

            $billDueDate = $payment_summary['summary_payment_due_date'];
            if (empty($billDueDate) || $billDueDate == '0000-00-00') $billDueDate = date('Y-m-d', strtotime($billTxnDate . ' +30 days'));
            else { try { $billDueDate = (new DateTime($billDueDate))->format('Y-m-d');} catch (Exception $e) { $billDueDate = date('Y-m-d', strtotime($billTxnDate . ' +30 days')); }}

            $billMetaData = [ "DocNumber" => $billDocNumber, "TxnDate" => $billTxnDate, "DueDate" => $billDueDate, "GlobalTaxCalculation" => "TaxExcluded" ];
            if ($qboTermRefId) { $billMetaData["SalesTermRef"] = ["value" => $qboTermRefId]; }

            if ($current_transaction_currency !== DEFAULT_QBO_HOME_CURRENCY) {
                $billMetaData["CurrencyRef"] = ["value" => $current_transaction_currency];
                $output_data['qbo_operations_log'][] = "Bill currency set to: {$current_transaction_currency} for vendor '{$cleaned_vendor_name}'. TxnDate for rate lookup: {$billTxnDate}.";

                $fetchedExchangeRate = null;
                $exchangeRateFetchError = null;
                try {
                    $exchangeRateObject = $qboLibrary->getMostRecentExchangeRate($current_transaction_currency);
                    if ($exchangeRateObject && property_exists($exchangeRateObject, 'Rate')) {
                        $rateValue = (float) $exchangeRateObject->Rate;
                        if ($rateValue > 0) {
                            $fetchedExchangeRate = $rateValue;
                            $output_data['qbo_operations_log'][] = "QBO API returned exchange rate: {$fetchedExchangeRate} for {$current_transaction_currency} to " . DEFAULT_QBO_HOME_CURRENCY . " as of " . ($exchangeRateObject->AsOfDate ?? $billTxnDate) . ".";
                        } else { $exchangeRateFetchError = "QBO API returned a non-positive rate ({$rateValue}) for {$current_transaction_currency}."; }
                    } else { $exchangeRateFetchError = "QBO did not return a valid exchange rate object or 'Rate' property via API for {$current_transaction_currency}."; }
                } catch (Exception $e) { $exchangeRateFetchError = "Error querying QBO for exchange rate for {$current_transaction_currency}: " . $e->getMessage(); }
                if ($fetchedExchangeRate !== null) { $billMetaData["ExchangeRate"] = $fetchedExchangeRate;
                } else {
                    if ($exchangeRateFetchError) { $output_data['debug_notes'][] = $exchangeRateFetchError; }
                    $output_data['debug_notes'][] = "No valid exchange rate obtained/set via API for {$current_transaction_currency}. Letting QBO attempt to apply its own automated rate.";
                }
            }
            if (!empty($payment_summary['summary_supplier_invoice_attachment_path'])) $billMetaData["PrivateNote"] = "Vtiger Inv Path(s): " . $payment_summary['summary_supplier_invoice_attachment_path'];

            $output_data['qbo_operations_log'][] = "Attempting create QBO Bill for Vendor ID {$qboVendor->Id}, DocNo: {$billMetaData['DocNumber']}, Expected Line Total: {$total_cost_from_processed_lines}";
            $qboBill = $qboLibrary->createBill($qboVendor->Id, $qboBillLineItems, $billMetaData);

            if ($qboBill && !empty($qboBill->Id)) {
                $vendor_qbo_status_entry['qbo_bill_id'] = $qboBill->Id;
                $vendor_qbo_status_entry['qbo_bill_status'] = 'Successfully Created';
                $vendor_qbo_status_entry['qbo_bill_total_amount'] = (float)$qboBill->TotalAmt;
                $output_data['qbo_operations_log'][] = "QBO Bill ID {$qboBill->Id} created. Vtiger VID: {$vtiger_vid}. QBO Total: {$qboBill->TotalAmt}";
                if (abs((float)$qboBill->TotalAmt - $total_cost_from_processed_lines) > 0.01 ) {
                     $output_data['debug_notes'][] = "Discrepancy Bill ID {$qboBill->Id} (Vendor: {$cleaned_vendor_name}): QBO Total {$qboBill->TotalAmt}, Vtiger Lines Sum {$total_cost_from_processed_lines}. Vtiger Payment Summary: " . ($payment_summary['summary_supplier_invoice_total_due'] ?? 'N/A');
                }
            } else {
                throw new Exception("QBO Bill creation failed for '{$cleaned_vendor_name}' - no Bill object or ID returned.");
            }

        } catch (IdsException $e) {
             $vendor_qbo_status_entry['qbo_bill_status'] = 'Error (QBO API)';
             $vendor_qbo_status_entry['qbo_bill_error_message'] = "Msg: " . $e->getMessage() . " | HTTP: " . $e->getHttpStatusCode() . " | Resp: " . $e->getResponseBody();
             $output_data['qbo_operations_log'][] = "QBO API Error for Vtiger Vendor ID {$vtiger_vid}: " . $e->getMessage();
        } catch (Exception $e) {
             $vendor_qbo_status_entry['qbo_bill_status'] = 'Error (General PHP)';
             $vendor_qbo_status_entry['qbo_bill_error_message'] = $e->getMessage();
             $output_data['qbo_operations_log'][] = "General PHP Error for Vtiger Vendor ID {$vtiger_vid}: " . $e->getMessage();
        }
        $output_data['all_vendors_data_with_qbo_status'][] = $vendor_qbo_status_entry;
    }
} else {
    $output_data['debug_notes'][] = 'Database connection not established.';
}

header('Content-Type: application/json');
echo json_encode($output_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_INVALID_UTF8_SUBSTITUTE);
exit;
?>