<?php
// qbo_sync_simple_test.php
// Simpler web interface to trigger and get basic feedback from QBO sync.

ini_set('display_errors', 1);
error_reporting(E_ALL);
include_once __DIR__ . "/header.php";

// Attempt to increase execution time - may or may not be respected by server config
// For very long tasks, the background execution method is still superior.
set_time_limit(300); // Try for 5 minutes

$feedback_output = [];
$quote_no_processed = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quote_no'])) {
    $quote_no_to_process = trim($_POST['quote_no']);
    $quote_no_processed = $quote_no_to_process;

    if (!empty($quote_no_to_process)) {
        if (preg_match('/^[a-zA-Z0-9\-]+$/', $quote_no_to_process)) {
            $php_executable = 'php'; 
            $cronjob_script_path = __DIR__ . '/cronjob_qbo_processing.php'; // Adjust if in different directory

            if (!file_exists($cronjob_script_path)) {
                $error_message = "Error: Cronjob script not found at: " . htmlspecialchars($cronjob_script_path);
            } else {
                $sanitized_quote_no_arg = escapeshellarg($quote_no_to_process);
                $command = $php_executable . ' ' . $cronjob_script_path . ' ' . $sanitized_quote_no_arg;

                $feedback_output[] = "Processing started for Quote No: " . htmlspecialchars($quote_no_to_process) . "...";
                
                // Capture output from the command
                // Use popen for potentially better handling of real-time-ish output,
                // though for this simple case, exec might also work.
                $handle = popen($command . ' 2>&1', 'r'); // Capture stdout and stderr
                if ($handle) {
                    while (!feof($handle)) {
                        $line = fgets($handle);
                        if ($line !== false) {
                            // We only really care about the summary lines from cliLog
                            // You can filter here if you want, or just display everything
                            // For simplicity, let's keep the last few lines or specific summary lines.
                            // This example just appends all output.
                            $feedback_output[] = htmlspecialchars(trim($line));
                        }
                    }
                    $status = pclose($handle);
                    if ($status === 0) {
                        $feedback_output[] = "Processing finished successfully.";
                    } else {
                        $feedback_output[] = "Processing finished with errors (Exit status: $status). Check qbo_cli_cron.log for details.";
                    }
                } else {
                    $error_message = "Error: Could not execute the sync process. Check server permissions and PHP configuration.";
                }
            }
        } else {
            $error_message = "Error: Invalid Quote Number format.";
        }
    } else {
        $error_message = "Error: Quote Number cannot be empty.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QBO Sync</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; padding: 20px; max-width: 800px; margin: auto; border: 1px solid #ccc; border-radius: 8px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; }
        input[type="text"] { width: 100%; padding: 8px; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
        button { padding: 10px 15px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background-color: #0056b3; }
        .feedback-area { margin-top: 20px; padding: 10px; border: 1px solid #eee; background-color: #f9f9f9; border-radius: 4px; min-height: 100px; max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-family: monospace; }
        .error { color: red; font-weight: bold; }
        .log-note { margin-top: 15px; font-size: 0.9em; color: #555; }
    </style>
</head>
<body>
    <h1>Trigger QBO Sync (Simple Test)</h1>
    <p>Enter a Vtiger Number to initiate the synchronization process with QuickBooks Online.
       Output from the script will be shown below. For very long processes, this page might time out.</p>

    <form method="POST" action="">
        <div class="form-group">
            <label for="quote_no">Quote Number:</label>
            <input type="text" id="quote_no" name="quote_no" value="<?php echo htmlspecialchars($quote_no_processed); ?>" required>
        </div>
        <button type="submit">Start Sync</button>
    </form>

    <?php if (!empty($error_message)): ?>
        <p class="error"><?php echo $error_message; ?></p>
    <?php endif; ?>

    <?php if (!empty($feedback_output)): ?>
        <h3>Processing Output:</h3>
        <div class="feedback-area">
            <?php foreach ($feedback_output as $line): ?>
                <?php echo $line; ?><br>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

</body>
</html>