<?php
include "dbconn.php";
include "dictionaries.php";
include "quote_pricing.php";
include "html_utility.php";


session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
}

$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

date_default_timezone_set('Australia/Melbourne');

// Get search query from textarea
$searchQuery = isset($_GET['query']) ? trim($_GET['query']) : '';
//$searchWords = $searchQuery ? array_unique(preg_split('/\s+/', strtolower($searchQuery))) : [];   //search words
$searchWords = array_filter(array_map('trim', explode(',', strtolower($searchQuery))));             //search lines
$quoteNumber = isset($_GET['quoteNumber']) ? trim($_GET['quoteNumber']) : '';
$test = isset($_GET['test']) ? trim($_GET['test']) : '';

function generate_pagination_link($page) {
    $params = $_GET;
    $params['page'] = $page;
    return '?' . http_build_query($params);
}

function generate_sorting_url2($order_by_column, $current_order_by, $current_order_dir) {
    $order_dir = ($current_order_by === $order_by_column && $current_order_dir === 'asc') ? 'desc' : 'asc';
    $query_params = $_GET;
    $query_params['order_by'] = $order_by_column;
    $query_params['order_dir'] = $order_dir;
    return $_SERVER['PHP_SELF'] . '?' . http_build_query($query_params);
}

function get_sort_icon2($order_by_column, $current_order_by, $current_order_dir) {
    if ($current_order_by === $order_by_column) {
        return $current_order_dir === 'asc'
            ? 'fas fa-sort-up'
            : 'fas fa-sort-down';
    }
    return 'fas fa-sort';
}

function getAllCities($conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS City FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_city); // Execute the query

    $cities = array(); // Initialize the array *before* the loop

    if ($result) { // Check if the query was successful
        while ($row = mysqli_fetch_assoc($result)) {
            $city = $row['City']; // Get the city value
            if (!empty($city)) { //Check if the city name is empty or not. If it's not empty, add it to the array.
              $cities[] = $city; // Add the city to the array
            }
        }
        mysqli_free_result($result); // Free the result set (good practice)
    } else {
        // Handle the error (e.g., log it, return an empty array, etc.)
        error_log("Error in getAllCities query: " . mysqli_error($conn));
        return array(); // Return an empty array in case of error
    }

    return $cities;
}

function getAllCountries($conn){
    $sql_countries = "SELECT DISTINCT vpcf.country AS Country FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_countries); // Execute the query

    $countries = array(); // Initialize the array *before* the loop

    if ($result) { // Check if the query was successful
        while ($row = mysqli_fetch_assoc($result)) {
            $country = $row['Country']; // Get the city value
            if (!empty($country)) { //Check if the city name is empty or not. If it's not empty, add it to the array.
              $countries[] = $country; // Add the country to the array
            }
        }
        mysqli_free_result($result); // Free the result set (good practice)
    } else {
        // Handle the error (e.g., log it, return an empty array, etc.)
        error_log("Error in getAllCountries query: " . mysqli_error($conn));
        return array(); // Return an empty array in case of error
    }

    return $countries;
}

function getCitiesByCountry($conn) {
    $sql_city = "SELECT DISTINCT vpcf.city AS City, vpcf.country AS Country
                 FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_city);

    $citiesByCountry = array();

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $city = $row['City'];
            $country = $row['Country'];

            if (!empty($city) && !empty($country)) { // Ensure both city and country are present
                if (!isset($citiesByCountry[$country])) {
                    $citiesByCountry[$country] = array(); // Initialize country array if it doesn't exist
                }
                $citiesByCountry[$country][] = $city; // Add city to the country's array
            }
        }
        mysqli_free_result($result);
    } else {
        error_log("Error in getCitiesByCountry query: " . mysqli_error($conn));
        return array();
    }

    return $citiesByCountry;
}

function getCitiesString($quoteid, $conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS cf_1248 FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid
                WHERE vi.id='$quoteid';";
    $result_city = mysqli_query($conn, $sql_city);
    $cities = array();
    $citiesString = "";
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        while($row_city = mysqli_fetch_assoc($result_city)) {
            if(isset($row_city['cf_1248']) && $row_city['cf_1248'] != '') {
                $cities[] = $row_city['cf_1248'];
            }
        }
    }
    if (isset($_GET['city']) && !empty($_GET['city'])) {
        $cityQuery = strtolower($_GET['city']);
        $found = false;
        foreach ($cities as $city) {
            if (strpos(strtolower($city), $cityQuery) !== false) {
                $found = true;
                break;
            }
        }
        if (!$found) {
            return "";
        }
    }
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        //echo (implode(', ', $cities));
        $citiesString = implode(', ', $cities);
    }
    return $citiesString;
}

function getCities($quoteid, $conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS cf_1248 FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid
                WHERE vi.id='$quoteid';";
    $result_city = mysqli_query($conn, $sql_city);
    $cities = array();
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        while($row_city = mysqli_fetch_assoc($result_city)) {
            if(isset($row_city['cf_1248']) && $row_city['cf_1248'] != '') {
                $cities[] = $row_city['cf_1248'];
            }
        }
    }
    if (isset($_GET['city']) && !empty($_GET['city'])) {
        $cityQuery = strtolower($_GET['city']);
        $found = false;
        foreach ($cities as $city) {
            if (strpos(strtolower($city), $cityQuery) !== false) {
                $found = true;
                break;
            }
        }
        if (!$found) {
            return "";
        }
    }
    return $cities;
}

function getAllTypes($conn)
{
    $sql = "SELECT DISTINCT vi.cf_928 FROM vtiger_inventoryproductrel vi";
    $types = []; // Initialize an empty array to store the types

    try {
        $result = $conn->query($sql); // Execute the query

        if ($result) { // Check if the query was successful
            if ($result->num_rows > 0) { // Check if there are any results
                while ($row = $result->fetch_assoc()) { // Fetch each row as an associative array
                    $type = $row['cf_928']; // Access the value of cf_928

                    if (!empty($type)) { // Check if the value is not empty
                        $types[] = $type; // Add the type to the array
                    }
                }
            }
            $result->free_result(); // Free the result set
        } else {
            // Handle query error, you might want to log this or throw an exception
            echo "Error executing query: " . $conn->error;
            return false; // Or handle error in a way that suits your application
        }
    } catch (Exception $e) {
        // Handle exceptions if any, like connection issues
        echo "Exception in getTypes: " . $e->getMessage();
        return false; // Or handle exception as needed
    }

    return $types; // Return the array of types
}

// Home
if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa'|| $title == 'external')  && ($quoteNumber == '') && ($test == ''))  {
include "header.php";

//for duplicates
if (isset($_GET['get_duplicates'])) {
    $quoteId = $_GET['quote'];
    // Query database for duplicates of $quoteId
    // Return JSON formatted duplicates
    echo json_encode($duplicatesData);
    exit;
}

    $quote_type = $_GET["quote_type"] ?? 'group';
    $allCities = getAllCities($conn);
    $allCountries = getAllCountries($conn);
    $citiesByCountry = getCitiesByCountry($conn);
    $allCountries = array_keys($citiesByCountry);
    $tagValues = isset($_GET['tagValues']) ? explode(',', $_GET['tagValues']) : array();
    $initialTagsJson = json_encode($tagValues);
    $cityMatches = array();
    $keywordMatches = array();
    $cityCountDeductible = 0;
    $allTypes = getAllTypes($conn); // Get all available types
    $selectedTypeFilter = $_GET['type_filter'] ?? 'All'; // Get selected filter, might be array or 'All'
?>

    <div id="loader">
        <p>Loading.....</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            /* Add relevancy highlighting styles */
            .highlight {
                background-color: yellow;
                font-weight: bold;
            }
            .relevance-badge {
                background: #4CAF50;
                color: white;
                padding: 2px 5px;
                border-radius: 3px;
                font-size: 0.8em;
            }

            .tag-container {
            border: 1px solid #ccc;
            padding: 5px;
            display: flex;
            flex-wrap: wrap;
            min-height: 40px; /* Ensure some height even when empty */
          }

              .tag {
                background-color: #eee;
                border: 1px solid #ccc;
                padding: 3px 5px;
                margin: 2px;
                border-radius: 3px;
                display: flex;
                align-items: center; /* Vertically center the text and the 'x' */
              }

              .tag span {
                margin-right: 3px;
              }

              .tag .remove-tag {
                cursor: pointer;
                color: #888;
                font-weight: bold;
                margin-left: 3px;
              }

              select {
                margin-top: 5px;
              }

              /* Style for the Duplicates Badge in the table cell */
            .duplicates-badge-container {
                display: inline-block; /* Or inline-flex if you want to control button alignment */
            }

            .duplicates-badge {
                background-color: #f0f0f0; /* Light gray background for the badge */
                color: #333; /* Darker text color */
                border: 1px solid #ccc; /* Light border */
                border-radius: 15px; /* Rounded corners for badge look */
                padding: 3px 8px; /* Padding inside the badge */
                font-size: 0.8em; /* Smaller font size for badge text */
                cursor: pointer; /* Indicate it's clickable */
            }

            .duplicates-badge:hover {
                background-color: #e0e0e0; /* Slightly darker on hover */
            }


            /* Modal Styles (Existing styles remain the same, only updating #duplicatesModalList and .duplicate-modal-link-item) */
            .modal {
                display: none; /* Hidden by default */
                position: fixed; /* Stay in place */
                z-index: 1; /* Sit on top */
                left: 0;
                top: 0;
                width: 100%; /* Full width */
                height: 100%; /* Full height */
                overflow: auto; /* Enable scroll if needed */
                background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
            }

            .modal-content {
                background-color: #fefefe;
                margin: 15% auto; /* 15% from the top and centered */
                padding: 20px;
                border: 1px solid #888;
                width: 80%; /* Could be more or less, depending on screen size and content */
                max-width: 1200px; /* Example max width */
            }

            .close-button {
                color: #aaa;
                float: right;
                font-size: 28px;
                font-weight: bold;
            }

            .close-button:hover,
            .close-button:focus {
                color: black;
                text-decoration: none;
                cursor: pointer;
            }

            /* Styles for links inside the modal - UPDATED FOR GRID LAYOUT WITH BORDERS */
            #duplicatesModalList {
                margin-top: 15px;
                display: grid; /* Use grid layout */
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); /* Responsive columns */
                gap: 10px; /* Spacing between grid items */
            }

            .duplicate-modal-link-item {
                display: flex;
                align-items: center;
                width: auto; /* Let width be determined by grid */
                padding: 8px; /* Add some padding inside each grid item for spacing */
                border: 1px solid #ccc; /* **Added border: 1px solid light gray** */
                border-radius: 5px; /* Optional: Add rounded corners to grid items */
            }


            .medal { /* Reusing medal styles - ensure they are in your stylesheet */
                display: inline-flex;
                justify-content: center;
                align-items: center;
                border-radius: 50%;
                width: 20px;
                height: 20px;
                font-size: 0.6em;
                color: white;
                text-align: center;
                margin-left: 3px;
            }

            .medal-green {
                background-color: lightgreen;
                color: black;
            }

            .medal-yellow {
                background-color: gold;
                color: black;
            }

            /* New Styles for Filter */
            .dropdown-checkbox-button {
                border-radius: 25px; /* Rounded button */
                padding: 8px 15px;
                background-color: #f8f9fa; /* Light background */
                color: #495057;
                border: 1px solid #ced4da;
                cursor: pointer;
            }

            .dropdown-checkbox-list {
                border-radius: 10px; /* Rounded list */
                border: 1px solid #ced4da;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Light shadow */
                padding: 5px 0;
            }

            .dropdown-checkbox-item label {
                padding: 8px 20px; /* Nicer spacing in list items */
                display: block;
            }
            .filter-buttons {
                margin-top: 10px;
            }

            .filter-buttons button {
                border-radius: 5px;
                padding: 5px 10px;
                background-color: #007bff; /* Example color */
                color: white;
                border: none;
                cursor: pointer;
                margin-right: 5px;
            }
            .filter-buttons button#clearTypeFilter {
                background-color: #dc3545; /* Example color for clear */
            }

        </style>


            <?php
            $base_sql = "SELECT vq.*, va.organization_name AS accountname, va.preferred,
                            CONCAT(vcd.firstname, ' ', vcd.lastname) AS contactname,
                            vqcf.cf_1162, vqcf.cf_1182,
                            vqinfo.assigned_to_region, vqinfo.assigned_to_ops
                    FROM (SELECT *
                            FROM vtiger_quotes
                            WHERE quoteid = (
                                SELECT MIN(quoteid) AS quoteid
                                FROM vtiger_quotes AS sub
                                WHERE sub.quote_no = vtiger_quotes.quote_no)
                            ORDER BY quote_no DESC) vq
                    LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON vq.accountid = va.accountid
                    LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
                    LEFT JOIN vtiger_contactdetails vcd ON vq.contactid=vcd.contactid
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
                    WHERE 1=1";

            $valid_columns = [
                'vqcf.cf_1162' => 'Travel Date',
                'vq.quote_no' => 'Quote Number',
                'vq.subject' => 'Subject',
                'va.accountname' => 'Organization',
                'contactname' => 'Contact Name'
            ];

            $order_by = isset($_GET['order_by']) && array_key_exists($_GET['order_by'], $valid_columns)
                ? $_GET['order_by']
                : 'vq.quote_no';

            $order_dir = isset($_GET['order_dir']) && in_array(strtoupper($_GET['order_dir']), ['ASC', 'DESC'])
                ? $_GET['order_dir']
                : 'DESC';

            $base_sql .= " ORDER BY $order_by $order_dir";
                // Remove LIMIT for full results
                $sql = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql);
                $result = mysqli_query($conn, $sql);
                $allRows = [];


                // Calculate relevance
                while ($row = mysqli_fetch_assoc($result)) {
                    $relevance = 0;
                    $content = "";
                    $content2 = "";
                    $row['Matches'] = array();
                    $row['Items'] = array();
                    $row['Content'] = array();
                    //bandaid
                    $base_sql2 =
                    "
                    SELECT DISTINCT
                    ROW_NUMBER() OVER (ORDER BY sq.sequence_no) AS row_num,
                        sq.quoteid,
                        sq.sequence_no,
                        sq.cf_928,
                        sq.productName,
                        sq.vendorName,
                        sq.Comment,
                        sq.Description
                    FROM (
                        SELECT
                            vi.id AS quoteid, /* Alias vi.id as quoteid for clarity in subquery */
                            vi.sequence_no,
                            vi.cf_928,
                            COALESCE(vpc.productname, tdp.productname) AS productName,
                            COALESCE(vvc.vendorname, tdv.vendorname) AS vendorName,
                            vi.comment AS Comment,
                            tdp.description AS Description,
                            vq.quoteid AS actual_quoteid /* Keep actual quoteid for filtering later */
                        FROM vtiger_inventoryproductrel vi
                        LEFT JOIN tdu_products tdp
                            ON vi.productid = tdp.productid
                        LEFT JOIN vtiger_products_custom vpc
                            ON vi.productid = vpc.productid
                        LEFT JOIN vtiger_vendor_custom vvc
                            ON vi.vendorid = vvc.vendorid
                        LEFT JOIN tdu_vendors tdv
                            ON tdp.vendorid = tdv.vendorid
                        LEFT JOIN vtiger_quotes vq
                            ON vi.id = vq.quoteid
                        WHERE vq.quote_no = '$row[quote_no]'
                    ";
                    if (is_array($selectedTypeFilter) && !in_array('All', $selectedTypeFilter)) { // Check if it's an array and 'All' is NOT selected
                        $types_string = "'" . implode("', '", array_map(function($type) use ($conn) { // Use anonymous function
                            return mysqli_real_escape_string($conn, $type); // Correct argument order: $conn first, then $type
                        }, $selectedTypeFilter)) . "'";
                        $base_sql2 .= " AND vi.cf_928 IN (" . $types_string . ")";
                    } else {
                        $base_sql2 .= ""; // Default behavior when "All" type selected (or no filter selected) - Adjust this if "All" should mean NO type filter at all.
                    }

                    $base_sql2 .=
                    "
                    ) AS sq
                    WHERE sq.quoteid = (SELECT MIN(quoteid) FROM (SELECT vq.quoteid AS quoteid FROM vtiger_quotes vq WHERE vq.quote_no = '$row[quote_no]') AS min_quote_subquery )
                    GROUP BY sq.sequence_no
                    ORDER BY sq.sequence_no ASC
                    ";

                        // Remove LIMIT for full results
                        $sql2 = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql2);
                        $result2 = mysqli_query($conn, $sql2);
                        //$allRows = [];

                        // put whatever is needed to compare to be added into row['Duplicates'] later
                        while ($row2 = mysqli_fetch_assoc($result2))
                    {
                        // REMOVE THIS CONDITIONAL TYPE CHECK:
                        // if(($row2['cf_928']=='Attraction' || $row2['cf_928']=='Tour')
                        // && $row2['productName']!="" )

                        // KEEP THIS (if productName check is still needed - otherwise remove if not)
                        if($row2['productName']!="" )
                        {
                            $row['Items'][] = [
                                'Product' => $row2['productName'] ?? '',
                                'Vendor' => $row2['vendorName'] ?? '',
                                'Type' => $row2['cf_928'] ?? ''
                            ];
                            $row['Content'][] = implode(' ', array_map('strtolower', [
                            //$row['sequence_no'],
                            //$row2['cf_928'],
                            $row2['productName'] ?? '',
                            $row2['vendorName'] ?? '',
                            //$row2['Comment'],
                            //$row2['Description']
                            ]));
                        }
                    }
                    //var_dump($row['Items']);
                    if(!empty($row['Content']))
                    {
                        $allRows[] = $row;
                    }

                    }
                    $superAllRows = [];
                    $rowsDuplicated = []; //rows that are a duplicate and to be ignored
                    foreach($allRows as $row)
                    {
                        $row['Duplicates'] = []; // Initialize Duplicates array for each row
                        if(in_array($row['quote_no'], $rowsDuplicated)){continue;} //skip any rows that are considered to have been duplicated in an exact match
                        foreach($allRows as $row2)
                        {
                            // perfect match
                            if(empty(array_diff($row['Content'], $row2['Content'])) && empty(array_diff($row2['Content'], $row['Content']))
                                && $row['quote_no']!=$row2['quote_no']
                                && !empty($row2['Content']) && !empty($row['Content']))
                            {
                                $row['Duplicates'][] = $row2['quote_no']."|EXACT";
                                $rowsDuplicated[] = $row2['quote_no'];
                            } else
                            //row2 contains row in its entirety but may have more (AKA more)
                            if(empty(array_diff($row['Content'], $row2['Content']))
                                && $row['quote_no']!=$row2['quote_no']
                                && !empty($row2['Content']) && !empty($row['Content']))
                            {
                                $row['Duplicates'][] = $row2['quote_no']."|MORE";
                            }
                        }

                        //if(!empty($row['Duplicates'])) // Only add to superAllRows if duplicates were found
                        {
                            $superAllRows[] = $row;
                        }
                    }
                    $allRows = $superAllRows;

                    // --- FILTER ALL ROWS BASED ON SELECTED TYPES ---
                    $filteredAllRows = [];
                    if (is_array($selectedTypeFilter) && !in_array('All', $selectedTypeFilter) && !empty($selectedTypeFilter)) {
                        foreach ($allRows as $row) {
                            $quoteItemTypes = [];
                            foreach ($row['Items'] as $item) {
                                $quoteItemTypes[] = $item['Type'];
                            }
                            $allTypesPresent = true;
                            foreach ($selectedTypeFilter as $typeToFilter) {
                                if (!in_array($typeToFilter, $quoteItemTypes)) {
                                    $allTypesPresent = false;
                                    break;
                                }
                            }
                            if ($allTypesPresent) {
                                $filteredAllRows[] = $row;
                            }
                        }
                        $allRows = $filteredAllRows; // Replace allRows with filtered rows
                    }
                    // --- END FILTERING ---


                    //sort by EXACT duplicate count
                    usort($allRows, function ($a, $b) {
                        $exactCountA = 0;
                        if (isset($a['Duplicates']) && is_array($a['Duplicates'])) {
                            foreach ($a['Duplicates'] as $duplicate) {
                                if (strpos($duplicate, "|EXACT") !== false) {
                                    $exactCountA++;
                                }
                            }
                        }

                        $exactCountB = 0;
                        if (isset($b['Duplicates']) && is_array($b['Duplicates'])) {
                            foreach ($b['Duplicates'] as $duplicate) {
                                if (strpos($duplicate, "|EXACT") !== false) {
                                    $exactCountB++;
                                }
                            }
                        }

                        return $exactCountB - $exactCountA; // Sort in descending order by EXACT count
                    });
                $total_quotes = count($allRows);
            ?>
            <strong>Rows: </strong>
            <label> <?php echo $total_quotes ;?></label>

<?php
$current_order_by = $_GET['order_by'] ?? 'vq.quote_no';
$current_order_dir = $_GET['order_dir'] ?? 'desc';
?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none';
            document.getElementById('content-all').style.display = 'block';
        });
    </script>

<div style="margin-bottom: 10px; margin-left: 15px; width: 200px; float: left;"> <!-- Filter Container Moved Here -->
    <form method="GET" action="" id="typeFilterForm">
        <input type="hidden" name="opt" value="<?= htmlspecialchars($_GET['opt'] ?? '') ?>">
        <input type="hidden" name="quote_type" value="<?= htmlspecialchars($quote_type) ?>">

        <label for="type_filter_dropdown" style="display: block;">Filter by Type:</label>
        <div class="dropdown-checkbox-container">
            <div class="dropdown-checkbox-list" id="type_filter_dropdown">
                <?php
                foreach ($allTypes as $type) {
                    echo '<div class="dropdown-checkbox-item">';
                    echo '<label>';
                    echo '<input type="checkbox" name="type_filter[]" value="' . htmlspecialchars($type) . '"';
                    if (is_array($selectedTypeFilter) && in_array($type, $selectedTypeFilter)) echo ' checked';
                    echo '>' . htmlspecialchars($type);
                    echo '</label>';
                    echo '</div>';
                }
                ?>
            </div>
        </div>

        <div class="filter-buttons">
            <button type="submit">Filter</button>
            <button type="button" id="clearTypeFilter">Clear</button>
        </div>


        <input type="hidden" name="order_by" value="<?= htmlspecialchars($current_order_by) ?>">
        <input type="hidden" name="order_dir" value="<?= htmlspecialchars($current_order_dir) ?>">
    </form>
</div>

<div class="columns-container" id="columnsContainer" style="margin-left: 220px;"> <!-- Columns Container Adjusted Margin -->
    <div class="quote-column" data-level="1" id="initialQuotesColumn">
        <div class="column-header">
            <h3>Initial Quotes</h3>
            <div class="legend">
                <span class="legend-item" id="exactLegend" title="Sort by Exact Duplicates"><span class="legend-color exact-legend"></span> Exact</span>
                <span class="legend-item" id="moreLegend" title="Sort by More Duplicates"><span class="legend-color more-legend"></span> More</span>
            </div>
        </div>
        <div class="column-search">
            <input type="text" class="column-search-input" id="initialColumnSearch" placeholder="Filter Quotes...">
        </div>
        <div class="quote-items-container" id="initialQuoteItemsContainer" style="overflow-y: auto; max-height: 600px;">
            <?php foreach ($allRows as $row):
                $exactCount = 0;
                $moreCount = 0;
                    foreach ($row['Duplicates'] as $duplicate) {
                        if (strpos($duplicate, "|EXACT") !== false) {
                            $exactCount++;
                        } elseif (strpos($duplicate, "|MORE") !== false) {
                            $moreCount++;
                        }
                    }
                ?>
                <div class="quote-item"
                     data-quote="<?= htmlspecialchars($row['quote_no']) ?>"
                     data-exact-count="<?= $exactCount ?>"
                     data-more-count="<?= $moreCount ?>"
                     data-duplicates="<?= htmlspecialchars(json_encode($row['Duplicates'] ?? [])) ?>">
                    <span class="quote-number"><?= $row['quote_no'] ?></span>
                    <span style="margin-right: 20px;">
                        <button class="view-duplicate-items"
                                data-items='<?= htmlspecialchars(json_encode($row['Items']), ENT_QUOTES, 'UTF-8') ?>'>
                            ⓘ
                        </button>
                    </span>
                    <div class="duplicate-counts-container">
                        <div class="exact-counts-col">
                            <span class="count exact-count"><?= $exactCount ?></span> <?php // ALWAYS SHOW EXACT COUNT ?>
                        </div>
                        <div class="more-counts-col">
                            <span class="count more-count"><?= $moreCount ?></span> <?php // ALWAYS SHOW MORE COUNT ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

<div class="quote-column" data-level="2" id="duplicatesColumn">
    <div class="column-header">
        <h3>Duplicates of <span id="selectedQuoteNo"></span></h3>
    </div>
    <div class="column-search">
        <input type="text" class="column-search-input" id="duplicatesColumnSearch" placeholder="Filter Duplicates...">
    </div>
    <div class="quote-items-container" id="duplicateQuoteItemsContainer" style="overflow-y: auto; max-height: 600px;">
        <div class="no-dupes">Select a quote to see duplicates</div>
    </div>
</div>
</div>
<div id="itemsModal" class="modal">
    <div class="modal-content" style="max-width: 600px;">
        <span class="close-button" id="itemsModalClose">×</span>
        <h3>Items in Quote</h3>
        <div id="itemsList"></div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const initialQuoteItemsContainer = document.getElementById('initialQuoteItemsContainer');
    let allQuotesData = Array.from(initialQuoteItemsContainer.querySelectorAll('.quote-item')).map(item => {
        return {
            element: item,
            quoteNo: item.dataset.quote,
            exactCount: parseInt(item.dataset.exactCount),
            moreCount: parseInt(item.dataset.moreCount),
            duplicates: JSON.parse(item.dataset.duplicates)
        };
    });

    let currentSort = { type: null, order: 'desc' }; // Track current sort

    document.querySelectorAll('.quote-item').forEach(quoteItem => {
        quoteItem.addEventListener('click', function(e) {
            document.querySelectorAll('.quote-item.active').forEach(item => item.classList.remove('active'));
            this.classList.add('active');

            const selectedQuoteNo = this.dataset.quote;
            document.getElementById('selectedQuoteNo').textContent = selectedQuoteNo;
            populateDuplicatesColumn(this.dataset.duplicates, selectedQuoteNo);
        });
    });

    document.getElementById('exactLegend').addEventListener('click', function() {
        cycleSort('exact');
    });

    document.getElementById('moreLegend').addEventListener('click', function() {
        cycleSort('more');
    });

    function populateDuplicatesColumn(duplicatesJson, parentQuoteNo) {
        const duplicates = JSON.parse(duplicatesJson);
        const duplicateQuoteItemsContainer = document.getElementById('duplicateQuoteItemsContainer');
        duplicateQuoteItemsContainer.innerHTML = ''; // Clear existing duplicates

        if (duplicates.length === 0) {
            duplicateQuoteItemsContainer.innerHTML = '<div class="no-dupes">No duplicates found</div>';
            return;
        }

        const exactDupes = duplicates.filter(d => d.includes('|EXACT'));
        const moreDupes = duplicates.filter(d => d.includes('|MORE'));

        if (exactDupes.length > 0) {
            duplicateQuoteItemsContainer.appendChild(createCategoryHeader('Exact Matches'));
            exactDupes.forEach(dupe => addDupeItem(dupe, duplicateQuoteItemsContainer)); // Removed parentQuoteNo
        }

        if (moreDupes.length > 0) {
            duplicateQuoteItemsContainer.appendChild(createCategoryHeader('Extended Matches'));
            moreDupes.forEach(dupe => addDupeItem(dupe, duplicateQuoteItemsContainer)); // Removed parentQuoteNo
        }
    }


    function createCategoryHeader(title) {
        const header = document.createElement('div');
        header.className = 'category-header';
        header.innerHTML = `<strong>${title}</strong>`;
        return header;
    }

    function addDupeItem(dupeString, container) {
        const [quoteId, type] = dupeString.split('|');
        const dupeItem = document.createElement('div');
        dupeItem.className = 'quote-item';

        dupeItem.innerHTML = `
            <span class="quote-number">${quoteId}</span>
            <span class="duplicate-type ${type.toLowerCase()}-match">${type}</span>
        `;

        // Fetch items data using AJAX
        fetch('ajax_fetch_quote_items.php?quote_no=' + quoteId) // Call the new PHP endpoint
            .then(response => response.json())
            .then(items => {
                if (items && items.length > 0) {
                    const button = document.createElement('button');
                    button.className = 'view-duplicate-items';
                    button.dataset.items = JSON.stringify(items);
                    button.innerHTML = 'ⓘ';
                    button.addEventListener('click', function() {
                        // Get the quote number from the parent duplicate item div (dupeItem)
                        const quoteNumber = dupeItem.querySelector('.quote-number').textContent;
                        showItemsModal(JSON.parse(this.dataset.items), quoteNumber); // Pass quoteNumber
                    });
                    dupeItem.querySelector('.duplicate-type').insertAdjacentElement('beforebegin', button); // Insert button before duplicate-type span
                }
            })
            .catch(error => {
                console.error('Error fetching items for quote ' + quoteId + ':', error);
            });

        container.appendChild(dupeItem);
    }

    document.getElementById('initialColumnSearch').addEventListener('keyup', function(event) {
        const inputElement = event.target; // Get the input element from the event
        const searchText = inputElement.value.toUpperCase().trim();
        const column = document.getElementById('initialQuotesColumn'); // Directly reference the column

        if (!column) return; // Safety check

        const quoteItemsContainer = column.querySelector('.quote-items-container');
        const quoteItems = quoteItemsContainer.querySelectorAll('.quote-item');

        quoteItems.forEach(item => {
            const quoteText = item.querySelector('.quote-number').textContent.toUpperCase().trim();
            // Keep display as 'flex' when showing, 'none' when hiding
            item.style.display = (quoteText.indexOf(searchText) > -1) ? "flex" : "none";
        });
    });

    document.getElementById('duplicatesColumnSearch').addEventListener('keyup', function(event) {
        const inputElement = event.target; // Get the inputElement from the event
        const searchText = inputElement.value.toUpperCase().trim();
        const column = document.getElementById('duplicatesColumn'); // Directly reference the column

        if (!column) return; // Safety check

        const quoteItemsContainer = column.querySelector('.quote-items-container');
        const quoteItems = quoteItemsContainer.querySelectorAll('.quote-item');

        quoteItems.forEach(item => {
            const quoteText = item.querySelector('.quote-number').textContent.toUpperCase().trim();
            // Keep display as 'flex' when showing, 'none' when hiding
            item.style.display = (quoteText.indexOf(searchText) > -1) ? "flex" : "none";
        });
    });


    function cycleSort(sortBy) {
        let sortOrder = 'desc'; // Default to descending

        if (currentSort.type === sortBy) {
            // Cycle sort order if same type is clicked again
            sortOrder = currentSort.order === 'desc' ? 'asc' : 'desc';
            currentSort.order = sortOrder;
        } else {
            // Default to descending order when a new type is selected
            currentSort.type = sortBy;
            currentSort.order = 'desc';
            sortOrder = 'desc';
        }
        sortInitialQuotes(sortBy, sortOrder);
        updateLegendVisuals(sortBy, sortOrder);
    }


    function sortInitialQuotes(sortBy, sortOrder) {
        let sortedQuotesData;
        if (sortBy === 'exact') {
            sortedQuotesData = [...allQuotesData].sort((a, b) => sortOrder === 'desc' ? (b.exactCount - a.exactCount) : (a.exactCount - b.exactCount));
        } else if (sortBy === 'more') {
            sortedQuotesData = [...allQuotesData].sort((a, b) => sortOrder === 'desc' ? (b.moreCount - a.moreCount) : (a.moreCount - b.moreCount));
        } else {
            sortedQuotesData = [...allQuotesData].sort((a, b) => a.quoteNo.localeCompare(b.quoteNo)); // Default sort by quote number
        }

        const initialQuoteItemsContainer = document.getElementById('initialQuoteItemsContainer');
        initialQuoteItemsContainer.innerHTML = ''; // Clear current items
        sortedQuotesData.forEach(quoteData => {
            initialQuoteItemsContainer.appendChild(quoteData.element); // Append sorted elements
        });
    }

    function updateLegendVisuals(sortBy, sortOrder) {
        // Reset legend visuals
        document.querySelectorAll('.legend-item').forEach(item => {
            item.classList.remove('active-sort-asc', 'active-sort-desc');
        });

        const legendItem = document.getElementById(sortBy + 'Legend');
        if (sortOrder === 'asc') {
            legendItem.classList.add('active-sort-asc'); // Add class for ascending visual
        } else if (sortOrder === 'desc') {
            legendItem.classList.add('active-sort-desc'); // Add class for descending visual
        }
    }

    function getSelectedTypes() {
        const typeCheckboxes = document.querySelectorAll('#typeFilterForm input[name="type_filter[]"]');
        let selectedTypes = [];

        typeCheckboxes.forEach(checkbox => {
            if (checkbox.checked) {
                selectedTypes.push(checkbox.value);
            }
        });

        return selectedTypes.length === 0 ? 'All' : selectedTypes;
    }

    function showItemsModal(items, quoteNumber) { // Added quoteNumber as argument
        const modal = document.getElementById('itemsModal');
        const itemsList = document.getElementById('itemsList');
        const modalTitle = modal.querySelector('h3'); // Get the <h3> element in the modal

        // Get selected types from the filter
        const selectedTypes = getSelectedTypes();

        // Filter items based on selected types
        let filteredItems = items; // Default to all items if 'All' is selected or no filter
        if (selectedTypes !== 'All' && Array.isArray(selectedTypes) && selectedTypes.length > 0) {
            filteredItems = items.filter(item => selectedTypes.includes(item.Type));
        }


        // Clear previous content
        itemsList.innerHTML = '';

        // **Update Modal Title**
        modalTitle.textContent = `Items in Quote ${quoteNumber}`; // Dynamically set the title

        // Create list element for all items
        const ul = document.createElement('ul');

        // **Create Header Row (LI element for headers) - ADD TYPE HEADER**
        const headerLi = document.createElement('li');
        headerLi.style.padding = '10px';
        headerLi.style.display = 'flex';
        headerLi.style.justifyContent = 'space-between';
        headerLi.style.fontWeight = 'bold';
        headerLi.style.borderBottom = '2px solid #ccc';

        headerLi.innerHTML = `
            <span style="flex:1">Product</span>
            <span style="flex:1; text-align:right; margin-left: 10px;">Vendor</span>
            <span style="flex:0.8; text-align:right; margin-left: 10px;">Type</span>  <!-- ADDED TYPE HEADER -->
        `;
        ul.appendChild(headerLi);

        // Add filtered items
        filteredItems.forEach(item => {
            const li = document.createElement('li');
            li.style.display = 'flex';
            li.style.justifyContent = 'space-between';
            li.style.padding = '8px';
            li.style.borderBottom = '1px solid #eee';

            li.innerHTML = `
                <span style="flex:1">${item.Product || 'N/A'}</span>
                <span style="flex:1; text-align:right; margin-left: 10px;">${item.Vendor || 'N/A'}</span>
                <span style="flex:0.8; text-align:right; margin-left: 10px;">${item.Type || 'N/A'}</span> <!-- ADDED TYPE DATA -->
            `;
            ul.appendChild(li);
        });

        itemsList.appendChild(ul);
        modal.style.display = 'block';
    }
    function closeItemsModal() {
        document.getElementById('itemsModal').style.display = 'none';
    }

    // Close modal when clicking outside
    window.onclick = function(event) {
        const modal = document.getElementById('itemsModal');
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }

    document.getElementById('itemsModalClose').addEventListener('click', closeItemsModal);

    document.getElementById('clearTypeFilter').addEventListener('click', function() {
        const typeCheckboxes = document.querySelectorAll('#typeFilterForm input[name="type_filter[]"]');
        typeCheckboxes.forEach(checkbox => {
            checkbox.checked = false;
        });
        //document.getElementById('typeFilterForm').submit(); //optional: submit form to refresh results
    });


    document.querySelectorAll('.view-duplicate-items').forEach(button => {
        button.addEventListener('click', function() {
            const items = JSON.parse(this.dataset.items);
            // Get the quote number from the parent quote-item div (button.closest('.quote-item'))
            const quoteNumber = button.closest('.quote-item').dataset.quote;
            showItemsModal(items, quoteNumber); // Pass quoteNumber
        });
    });
});


</script>
<?php
//DATABASE TEST
} else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && ($test != '')) {
include "header.php";
?>

    <div>
        <p>Running Database Test.....</p><br>
        
    </div>
    <div></div>
    <div id="content-all" style="display: block;" style="width: 100%;">
        <h1>Database Test</h1>
        <p>Creating and populating 'tdu_duplicates' table...</p>
        <?php
        //DATABASE TEST
        if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa'|| $title == 'external')  && ($test != ""))  {

            // Check if table exists, if not create it
            $table_check_sql = "SHOW TABLES LIKE 'tdu_duplicates'";
            $table_check_result = mysqli_query($conn, $table_check_sql);

            if(mysqli_num_rows($table_check_result) == 0) {
                $create_table_sql = "CREATE TABLE tdu_duplicates (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    quoteid VARCHAR(255) NOT NULL,
                    duplicate_quoteid VARCHAR(255) NOT NULL,
                    status VARCHAR(50) NOT NULL
                )";

                if (mysqli_query($conn, $create_table_sql)) {
                    echo "<p style='color: green;'>Table 'tdu_duplicates' created successfully</p>";
                } else {
                    echo "<p style='color: red;'>Error creating table: " . mysqli_error($conn) . "</p>";
                }
            } else {
                echo "<p style='color: blue;'>Table 'tdu_duplicates' already exists.</p>";
            }

            // Clear existing data from the table
            $clear_table_sql = "DELETE FROM tdu_duplicates";
            if (mysqli_query($conn, $clear_table_sql)) {
                echo "<p style='color: green;'>Table 'tdu_duplicates' cleared.</p>";
            } else {
                echo "<p style='color: red;'>Error clearing table: " . mysqli_error($conn) . "</p>";
            }
            
            // Reset auto increment
            $reset_auto_increment_sql = "ALTER TABLE tdu_duplicates AUTO_INCREMENT = 1";
            if (mysqli_query($conn, $reset_auto_increment_sql)) {
                echo "<p style='color: green;'>Table 'tdu_duplicates' auto increment reset.</p>";
            } else {
                echo "<p style='color: red;'>Error resetting table: " . mysqli_error($conn) . "</p>";
            }
            
            //supposingly, does both clear and reset 
            /*
            $truncate_table_sql = "TRUNCATE TABLE tdu_duplicates";
            if (mysqli_query($conn, $truncate_table_sql)) {
                echo "<p style='color: green;'>Table 'tdu_duplicates' truncated (data and auto-increment reset).</p>";
            } else {
                echo "<p style='color: red;'>Error truncating table: " . mysqli_error($conn) . "</p>";
            }
            */
            
            // Repopulate the table with data (exact same sql from //Home with the ordering)
            $base_sql = "SELECT vq.*, va.organization_name AS accountname, va.preferred,
                            CONCAT(vcd.firstname, ' ', vcd.lastname) AS contactname,
                            vqcf.cf_1162, vqcf.cf_1182,
                            vqinfo.assigned_to_region, vqinfo.assigned_to_ops
                    FROM (SELECT *
                            FROM vtiger_quotes
                            WHERE quoteid = (
                                SELECT MIN(quoteid) AS quoteid
                                FROM vtiger_quotes AS sub
                                WHERE sub.quote_no = vtiger_quotes.quote_no)
                            ORDER BY quote_no DESC) vq
                    LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON vq.accountid = va.accountid
                    LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
                    LEFT JOIN vtiger_contactdetails vcd ON vq.contactid=vcd.contactid
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
                    WHERE 1=1";
            
            $valid_columns = [
                'vqcf.cf_1162' => 'Travel Date',
                'vq.quote_no' => 'Quote Number',
                'vq.subject' => 'Subject',
                'va.accountname' => 'Organization',
                'contactname' => 'Contact Name'
            ];
                     
            
            $order_by = isset($_GET['order_by']) && array_key_exists($_GET['order_by'], $valid_columns) 
                ? $_GET['order_by'] 
                : 'vq.quote_no';
            
            $order_dir = isset($_GET['order_dir']) && in_array(strtoupper($_GET['order_dir']), ['ASC', 'DESC']) 
                ? $_GET['order_dir'] 
                : 'DESC';
            
            $base_sql .= " ORDER BY $order_by $order_dir";
                // Remove LIMIT for full results
                $sql = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql);
                $result = mysqli_query($conn, $sql);
                $allRows = [];
                
                
                // Calculate relevance
                while ($row = mysqli_fetch_assoc($result)) {
                    $relevance = 0;
                    $content = "";
                    $content2 = "";
                    $row['Matches'] = array();
                    $row['Items'] = array();
                    $row['Content'] = array();
                    //bandaid
                    $base_sql2 = 
                    "
                    SELECT DISTINCT
                    ROW_NUMBER() OVER (ORDER BY sq.sequence_no) AS row_num,
                        sq.quoteid,
                        sq.sequence_no,
                        sq.cf_928,
                        sq.productName,
                        sq.vendorName,
                        sq.Comment,
                        sq.Description
                    FROM (
                        SELECT
                            vi.id AS quoteid, /* Alias vi.id as quoteid for clarity in subquery */
                            vi.sequence_no,
                            vi.cf_928,
                            COALESCE(vpc.productname, tdp.productname) AS productName,
                            COALESCE(vvc.vendorname, tdv.vendorname) AS vendorName,
                            vi.comment AS Comment,
                            tdp.description AS Description,
                            vq.quoteid AS actual_quoteid /* Keep actual quoteid for filtering later */
                        FROM vtiger_inventoryproductrel vi
                        LEFT JOIN tdu_products tdp
                            ON vi.productid = tdp.productid
                        LEFT JOIN vtiger_products_custom vpc
                            ON vi.productid = vpc.productid
                        LEFT JOIN vtiger_vendor_custom vvc
                            ON vi.vendorid = vvc.vendorid
                        LEFT JOIN tdu_vendors tdv
                            ON tdp.vendorid = tdv.vendorid
                        LEFT JOIN vtiger_quotes vq
                            ON vi.id = vq.quoteid
                        WHERE vq.quote_no = '$row[quote_no]'
                        AND (vi.cf_928 = 'Attraction')
                    ) AS sq
                    WHERE sq.quoteid = (SELECT MIN(quoteid) FROM (SELECT vq.quoteid AS quoteid FROM vtiger_quotes vq WHERE vq.quote_no = '$row[quote_no]') AS min_quote_subquery )
                    GROUP BY sq.sequence_no
                    ORDER BY sq.sequence_no ASC
                    ";
                        
                        // Remove LIMIT for full results
                        $sql2 = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql2);
                        $result2 = mysqli_query($conn, $sql2);
                        //$allRows = [];
        
                        // put whatever is needed to compare to be added into row['Duplicates'] later
                        while ($row2 = mysqli_fetch_assoc($result2)) 
                        {
                            if(($row2['cf_928']=='Attraction' || $row2['cf_928']=='Tour')
                            && $row2['productName']!="" )
                            {
                                $row['Items'][] = [
                                    'Product' => $row2['productName'] ?? '',
                                    'Vendor' => $row2['vendorName'] ?? ''
                                ];
                                $row['Content'][] = implode(' ', array_map('strtolower', [
                                //$row['sequence_no'],
                                //$row2['cf_928'],
                                $row2['productName'] ?? '',
                                $row2['vendorName'] ?? '',
                                //$row2['Comment'],
                                //$row2['Description']
                            ]));
                            }
                        }
                        if(!empty($row['Content']))
                        {
                            
                            $allRows[] = $row;
                        }
                        
                    }
                    $superAllRows = [];
                    $rowsDuplicated = []; //rows that are a duplicate and to be ignored
                    foreach($allRows as $row)
                    {
                        $row['Duplicates'] = []; // Initialize Duplicates array for each row
                        if(in_array($row['quote_no'], $rowsDuplicated)){continue;} //skip any rows that are considered to have been duplicated in an exact match
                        foreach($allRows as $row2)
                        {
                            // perfect match
                            if(empty(array_diff($row['Content'], $row2['Content'])) && empty(array_diff($row2['Content'], $row['Content']))
                                && $row['quote_no']!=$row2['quote_no']
                                && !empty($row2['Content']) && !empty($row['Content']))
                            {
                                $row['Duplicates'][] = $row2['quote_no']."|EXACT";
                                $rowsDuplicated[] = $row2['quote_no'];
                            } else
                            //row2 contains row in its entirety but may have more (AKA more)
                            if(empty(array_diff($row['Content'], $row2['Content']))
                                && $row['quote_no']!=$row2['quote_no']
                                && !empty($row2['Content']) && !empty($row['Content']))
                            {
                                $row['Duplicates'][] = $row2['quote_no']."|MORE";
                            }
                        }
                    
                        if(!empty($row['Duplicates'])) // Only add to superAllRows if duplicates were found
                        {
                            $superAllRows[] = $row;
                        }
                    }
                    $allRows = $superAllRows;
            ?>
            <table style="width:100%;">
                <tr>
                    <th>Auto ID</th>
                    <th>Quote ID</th>
                    <th>Duplicate</th>
                    <th>Status</th>
                </tr>
                <?php
                $i = 1; // Initialize auto ID counter
                $insertion_success = true; // Flag to track overall insertion success

                foreach($allRows as $row) {
                    foreach($row['Duplicates'] as $duplicate) {
                        $parts = explode("|", $duplicate);
                        $duplicate_quote_id = $parts[0] ?? null;
                        $status = $parts[1] ?? null;

                        $quote_no = $row['quote_no'] ?? null;

                        // SQL INSERT statement
                        $sql_insert_duplicate = "INSERT INTO tdu_duplicates (quoteid, duplicate_quoteid	, status) VALUES (?, ?, ?)";
                        $stmt = mysqli_prepare($conn, $sql_insert_duplicate);

                        if ($stmt) {
                            mysqli_stmt_bind_param($stmt, "sss", $quote_no, $duplicate_quote_id, $status);
                            if (mysqli_stmt_execute($stmt)) {
                                // Insertion successful for this row
                            } else {
                                echo "<tr><td colspan='4' style='color:red;'><strong>Error inserting record for Quote ID: " . htmlspecialchars($row['quote_no'] ?? "N/A") . ", Duplicate: " . htmlspecialchars($duplicate_quote_id ?? "N/A") . ": " . mysqli_error($conn) . "</strong></td></tr>";
                                $insertion_success = false; // Set flag to false if any insertion fails
                            }
                            mysqli_stmt_close($stmt);
                        } else {
                            echo "<tr><td colspan='4' style='color:red;'><strong>Error preparing statement for Quote ID: " . htmlspecialchars($row['quote_no'] ?? "N/A") . ", Duplicate: " . htmlspecialchars($duplicate_quote_id ?? "N/A") . ": " . mysqli_error($conn) . "</strong></td></tr>";
                            $insertion_success = false;
                        }
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($i) ?></td>
                            <td><?= htmlspecialchars($row['quote_no'] ?? "N/A") ?></td>
                            <td><?= htmlspecialchars($duplicate_quote_id ?? "N/A") ?></td>
                            <td><?= htmlspecialchars($status ?? "N/A") ?></td>
                        </tr>
                        <?php
                        $i++;
                    }
                }

                if ($insertion_success) {
                    echo "<tr><td colspan='4' style='color:green;'><strong>Data insertion into tdu_duplicates table completed successfully.</strong></td></tr>";
                } else {
                    echo "<tr><td colspan='4' style='color:red;'><strong>Data insertion into tdu_duplicates table encountered errors. Check error messages above.</strong></td></tr>";
                }
                ?>
            </table>
<?php
        }
        ?>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none';
            document.getElementById('content-all').style.display = 'block';
        });
    </script>
<?php
}
?>

    <style>
    /* Tooltip container */
    .tooltip-content {
        display: none;
        position: absolute;
        background-color: #f9f9f9;
        border: 1px solid #ddd;
        padding: 10px;
        width: 200px;
        z-index: 10;
        right: 30px;
        top: 40px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .tooltip-content ul {
        list-style-type: none;
        padding: 0;
    }

    .tooltip-content ul li {
        font-size: 14px;
        margin: 5px 0;
    }
    .styled-table th {
        text-align: left;
    }
    .styled-table td {
        word-wrap: break-word;
        white-space: normal;
        max-width: 150px;
        text-align: left;
    }

    .styled-table td input[type="text"], .styled-table td select, #composeFormContainer input[type="text"] {
        width: 100%;
        height: 30px;
        margin: 0;
    }
    #popupForm input, #popupForm select {
        width: 75%;
        height: 30px;
        margin-bottom: 20px;
    }
    .styled-table td select {
        width: 80%;
        height: 30px;
        margin: 0;
    }

    .tag {
        display: inline-block;
        padding: 5px 10px;
        margin: 5px 2px;
        font-size: 14px;
        background-color: green;
        color: white;
        border-radius: 12px;
        position: relative;
    }
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: center;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        /*background-color: #f9f9f9;*/
    }
    .styled-table tr:hover {
        /*background-color: #f1f1f1;*/
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }

    p, strong, h3 {
        margin: 10px;
    }

    .so input[type="text"], select {
        margin-bottom: 10px;
    }
    .so textarea {
        height: 30px;
        margin-bottom: 0;
    }
    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }

    button:disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* -------------------------------------------- */
/* -------- General Layout & Structure -------- */
/* -------------------------------------------- */

.columns-container {
    display: flex;
    overflow-x: auto;
    padding: 20px 0;
    gap: 15px;
    max-width: 1200px;
    margin: 0 auto;
}

.quote-column {
    min-width: 400px;
    flex: 1; /* Allow columns to grow and share space */
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 15px;
    background: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.quote-items-container {
    overflow-y: auto;
    max-height: 600px;
    border: 1px solid #eee;
    padding-right: 5px;
    display: flex;
    flex-direction: column;
}

.quote-items-container .quote-item {
    display: flex; /* Default state */
}

/* Hide Filtered Quote Items */
.quote-items-container .quote-item[hidden],
.quote-items-container .quote-item.style.display = 'none' {
    display: none !important;
}


/* -------------------------------------------- */
/* -------------- Column Header --------------- */
/* -------------------------------------------- */

.column-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

/* Legend in Column Header */
.legend {
    display: flex;
    gap: 15px;
    font-size: 0.9em;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 5px;
    cursor: pointer;
    padding: 5px 8px;
    border-radius: 5px;
}

.legend-item:hover {
    background-color: #f0f0f0;
}

.legend-color {
    display: inline-block;
    width: 10px;
    height: 10px;
    border-radius: 3px;
}

.exact-legend {
    background-color: green;
}

.more-legend {
    background-color: orange;
}


/* -------------------------------------------- */
/* -------------- Column Search --------------- */
/* -------------------------------------------- */

.column-search {
    margin-bottom: 10px;
}

.column-search-input {
    width: calc(100% - 12px);
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
    font-size: 1em;
}


/* -------------------------------------------- */
/* -------------- Quote Items ---------------- */
/* -------------------------------------------- */

.quote-item {
    display: flex;
    justify-content: space-between;
    align-items: baseline;
    padding: 8px 10px;
    border-bottom: 1px solid #eee;
}

.quote-item:last-child {
    border-bottom: none;
}

.quote-item:hover {
    background: #e9ecef;
}

.quote-item.active {
    background: #e3f2fd;
}

.quote-number {
    flex-grow: 1;
    text-align: left;
}


/* -------------------------------------------- */
/* -------- Duplicate Counts & Badges -------- */
/* -------------------------------------------- */

.duplicate-counts-container {
    display: flex;
    flex-direction: row;
    text-align: center;
    flex-shrink: 0;
    font-weight: bold;
}

.exact-counts-col,
.more-counts-col {
    width: 40px;
}

.more-counts-col {
    margin-left: 5px;
}

.exact-counts-col {
    margin-right: 5px;
}

.duplicate-counts {
    display: block;
    font-size: 1.4em;
    font-weight: bold;
    text-align: center;
    width: 100%;
    box-sizing: border-box;
    padding: 4px 8px;
    border-radius: 5px;
}

.count.exact-count {
    color: green;
    background-color: #f0f9f0;
    font-size: 1.2em;
    padding: 6px 10px;
    border-radius: 7px;
}

.count.more-count {
    color: orange;
    background-color: #fff8f0;
    font-size: 1.2em;
    padding: 6px 10px;
    border-radius: 7px;
}

.duplicate-type {
    font-size: 0.8em;
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 8px;
}

.exact-match {
    background: #c8e6c9;
    color: #2e7d32;
}

.more-match {
    background: #fff3e0;
    color: #ef6c00;
}


/* -------------------------------------------- */
/* ------------------ Modal ------------------ */
/* -------------------------------------------- */

#itemsList {
    max-height: 400px;
    overflow-y: auto;
    margin-top: 15px;
}

#itemsList ul {
    list-style-type: none;
    padding: 0;
    margin: 0;
}

#itemsList li {
    padding: 8px;
    margin: 4px 0;
    background: #f8f8f8;
    border-radius: 4px;
}


</style>