<?php
session_start();
require 'vendor/autoload.php';
use League\OAuth2\Client\Provider\GenericProvider;

// Database connection
include "dbconn.php";

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: ../login.php');
    exit;
}

// OAuth2 Client Credentials
$clientId = '5b1494de-7d7a-48cd-a2d8-da6fb9b8b1d6';
$clientSecret = '-iO8Q~MICIQW7FP~9-RZpnXBKQSjsqK6IZRu-a.l';
$tenantId = '7811efff-0816-46b8-a5b9-39c263c51b20';
// $redirectUri = 'https://dev.yourbestwayhome.com.au/turtledownunder/email/auth.php';
$redirectUri = 'https://dashboard.turtledownunder.com.au/email/auth.php';

// Set up the OAuth provider
$provider = new GenericProvider([
    'clientId'                => $clientId,
    'clientSecret'            => $clientSecret,
    'redirectUri'             => $redirectUri,
    'urlAuthorize'            => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/authorize",
    'urlAccessToken'          => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/token",
    'urlResourceOwnerDetails' => 'https://graph.microsoft.com/v1.0/me',
]);

// Check if the authorization code is received
if (!isset($_GET['code']) && !isset($_SESSION['current_email'])) {
    // The user hasn't authorized yet, so redirect them to the authorization URL
    if (isset($_GET['email'])) {
        // Store email in session before redirecting
        $_SESSION['current_email'] = $_GET['email'];
        $authorizationUrl = $provider->getAuthorizationUrl(['scope' => 'https://graph.microsoft.com/Mail.Read https://graph.microsoft.com/Mail.Send offline_access openid profile']);
        header("Location: " . $authorizationUrl);
        exit();
    } else {
        // If email isn't available, something went wrong. Handle this case appropriately.
        die('Email parameter is missing.');
    }
} else if (isset($_GET['code']) && isset($_SESSION['current_email'])) {
    // The user has returned from the Microsoft authorization, now we handle the token exchange

    try {
        // Exchange authorization code for tokens
        $token = $provider->getAccessToken('authorization_code', [
            'code' => $_GET['code'],
        ]);

        // Save tokens to the database
        $email = $_SESSION['current_email']; // Retrieve email from session
        $accessToken = $token->getToken();
        $refreshToken = $token->getRefreshToken();
        $expiresAt = time() + $token->getExpires();

        // Use INSERT ON DUPLICATE KEY to avoid overwriting
        $sql = "INSERT INTO oauth_tokens (email, access_token, refresh_token, status, expires_at, org)
                VALUES ('$email', '$accessToken', '$refreshToken', 'active', $expiresAt, 'au')
                ON DUPLICATE KEY UPDATE access_token='$accessToken', refresh_token='$refreshToken', status='active', expires_at=$expiresAt, org='au'";

        if (mysqli_query($conn, $sql)) {
            echo "Authentication successful for $email. Tokens saved!";
        } else {
            echo "Failed to save tokens for $email: " . mysqli_error($conn);
        }

        // Clear session data once the process is complete
        unset($_SESSION['current_email']);
    } catch (Exception $e) {
        echo 'Failed to get tokens: ' . $e->getMessage();
    }
} else {
    // If session email isn't set, it's the first time visiting this page, handle the case
    echo 'Session expired or email not set. Please go back to the previous step.';
}
?>
