<?php
require 'vendor/autoload.php';
use League\OAuth2\Client\Provider\GenericProvider;
use GuzzleHttp\Client;

// Database connection
include "dbconn.php";
date_default_timezone_set('Australia/Melbourne');

// OAuth2 Client Credentials
$clientId = '5b1494de-7d7a-48cd-a2d8-da6fb9b8b1d6';
$clientSecret = '-iO8Q~MICIQW7FP~9-RZpnXBKQSjsqK6IZRu-a.l';
$tenantId = '7811efff-0816-46b8-a5b9-39c263c51b20';

// Set up the OAuth provider
$provider = new GenericProvider([
    'clientId'                => $clientId,
    'clientSecret'            => $clientSecret,
    'urlAuthorize'            => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/authorize",
    'urlAccessToken'          => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/token",
    'urlResourceOwnerDetails' => 'https://graph.microsoft.com/v1.0/me',
]);

// Retrieve tokens for all users
$result = mysqli_query($conn, "SELECT * FROM oauth_tokens WHERE org='au'");
if (mysqli_num_rows($result) == 0) {
    die("No tokens found. Run auth.php first to authenticate.");
}

// Calculate the past 24-hour time range in UTC
$now = new DateTime('now', new DateTimeZone('UTC'));
$past24Hours = (clone $now)->modify('-5 minutes');

$startTime = $past24Hours->format('Y-m-d\TH:i:s\Z');
$endTime = $now->format('Y-m-d\TH:i:s\Z');

// Process emails for each user
while ($row = mysqli_fetch_assoc($result)) {
    $emailid = $row['email'];
    $accessToken = $row['access_token'];
    $refreshToken = $row['refresh_token'];
    $expiresAt = $row['expires_at'];

    try {
        // Refresh token
        $newToken = $provider->getAccessToken('refresh_token', [
            'refresh_token' => $refreshToken,
        ]);

        $accessToken = $newToken->getToken();
        $refreshToken = $newToken->getRefreshToken();
        $expiresAt = time() + $newToken->getExpires();

        $sql = "UPDATE oauth_tokens 
                SET access_token = '$accessToken', 
                    refresh_token = '$refreshToken', 
                    expires_at = $expiresAt
                WHERE email = '$emailid'";
        mysqli_query($conn, $sql);
    } catch (Exception $e) {
        echo "Failed to refresh access token for $emailid: " . $e->getMessage() . "\n";
        // $sql = "UPDATE oauth_tokens SET status = 'inactive' WHERE email = '$emailid'";
        // mysqli_query($conn, $sql);
        continue;
    }

    try {
        $httpClient = new Client();

        // Fetch emails from Inbox
        $responseInbox = $httpClient->request('GET', 'https://graph.microsoft.com/v1.0/me/mailFolders/inbox/messages?$top=100&$filter=receivedDateTime ge ' . $startTime . ' and receivedDateTime le ' . $endTime, [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept'        => 'application/json',
            ],
        ]);

        $emailsInbox = json_decode($responseInbox->getBody()->getContents(), true);
        processEmails($emailsInbox, $emailid, $conn, 'Inbox');

        // Fetch emails from Sent Items
        $responseSent = $httpClient->request('GET', 'https://graph.microsoft.com/v1.0/me/mailFolders/sentItems/messages?$top=100&$filter=sentDateTime ge ' . $startTime . ' and sentDateTime le ' . $endTime, [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept'        => 'application/json',
            ],
        ]);

        $emailsSent = json_decode($responseSent->getBody()->getContents(), true);
        processEmails($emailsSent, $emailid, $conn, 'Sent Items');

    } catch (Exception $e) {
        echo "Failed to fetch emails for $emailid: " . $e->getMessage() . "\n";
        $sql = "UPDATE oauth_tokens SET status = 'inactive' WHERE email = '$emailid'";
        mysqli_query($conn, $sql);
        continue;
    }
}

echo 'DONE';

// Function to process emails
function processEmails($emails, $emailid, $conn, $folder) {
    $auto_acknowledge = ['sales@turtledownunder.com.au', 'groupsales@turtledownunder.com.au', 'asia@turtledownunder.com.au'];
    if (!empty($emails['value'])) {
        foreach ($emails['value'] as $email) {
            $id = mysqli_real_escape_string($conn, $email['id']);
            $messageId = mysqli_real_escape_string($conn, $email['internetMessageId']);
            $conversationId = mysqli_real_escape_string($conn, $email['conversationId']);
            $inReplyTo = isset($email['inReplyTo']) ? mysqli_real_escape_string($conn, $email['inReplyTo']) : null;
            $subject = preg_replace('/[^\x00-\x7F]/', '', $email['subject']);
            $subject = mysqli_real_escape_string($conn, $subject);

            $fromEmail = mysqli_real_escape_string($conn, $email['from']['emailAddress']['address']);
            $fromName = mysqli_real_escape_string($conn, $email['from']['emailAddress']['name']); // Get sender's name

            $body = $email['body']['content'];
            $body = preg_replace('/[^\x00-\x7F]/', '', $body);
            $body = mysqli_real_escape_string($conn, $body);
            $bodyPreview = mysqli_real_escape_string($conn, $email['bodyPreview']);

            $plaintextBody = strip_tags($body); // Strip HTML tags to get plain text
            $plaintextBody = html_entity_decode($plaintextBody, ENT_QUOTES | ENT_HTML5, 'UTF-8'); // Decode HTML entities
            $plaintextBody = mysqli_real_escape_string($conn, $plaintextBody);

            $utcDateTime = new DateTime($email['receivedDateTime'] ?? $email['sentDateTime'], new DateTimeZone('UTC'));
            $melbourneDateTime = $utcDateTime->setTimezone(new DateTimeZone('Australia/Melbourne'));
            $receivedDateTime = $melbourneDateTime->format('Y-m-d H:i:s');

            $ccList = [];
            if (!empty($email['ccRecipients'])) {
                foreach ($email['ccRecipients'] as $cc) {
                    $ccList[] = $cc['emailAddress']['address'];
                }
            }
            $cc = mysqli_real_escape_string($conn, implode(',', $ccList));

            $toList = [];
            if (!empty($email['toRecipients'])) {
                foreach ($email['toRecipients'] as $to) {
                    $toList[] = $to['emailAddress']['address'];
                }
            }
            $to = mysqli_real_escape_string($conn, implode(',', $toList));

            $sqlCheck = "SELECT COUNT(*) AS count FROM tdu_emails WHERE message_id = '$messageId' AND mailbox='$emailid' AND folder='$folder'";
            $resultCheck = mysqli_query($conn, $sqlCheck);
            $rowCheck = mysqli_fetch_assoc($resultCheck);

            if ($rowCheck['count'] == 0) {
                $sql = "INSERT IGNORE INTO tdu_emails (msgid, message_id, conversation_id, in_reply_to, subject, sender, sender_name, received_datetime, body_preview, cc, full_body, mailbox, folder, recipient, plaintext_body) 
                        VALUES ('$id', '$messageId', '$conversationId', '$inReplyTo', '$subject', '$fromEmail', '$fromName', '$receivedDateTime', '$bodyPreview', '$cc', '$body', '$emailid', '$folder', '$to', '$plaintextBody')";        
                mysqli_query($conn, $sql);

                // Fetch attachments for this email
                fetchAttachments($email['id'], $messageId, $emailid, $conn);

                if ($folder == 'Sent Items') {
                    $sql_tagging = "SELECT auto_id, quoteid, quote_type, sender, vendorid FROM tdu_mailbox_tmp_tagging
                                    WHERE subject = '$subject' AND mailbox = '$emailid' AND actioned = 0;";
                    $result_tagging = mysqli_query($conn, $sql_tagging);
                
                    while ($row_tagging = mysqli_fetch_assoc($result_tagging)) {
                        $quoteid = $row_tagging['quoteid'];
                        $auto_id = $row_tagging['auto_id'];
                        $quote_type = $row_tagging['quote_type'];
                        $sender = $row_tagging['sender'];
                        $vendorid_sent = $row_tagging['vendorid'] ?? 0;
                
                        // Get assigned values from tdu_quotes
                        $sql_quote = "SELECT assigned_to_region, assigned_to_sales_agent, assigned_to_external_sales_agent, assigned_to_ops, assigned_to_qa
                                      FROM vtiger_quotes_info 
                                      WHERE quoteid = '$quoteid' AND quotetype = 'group';";
                        $result_quote = mysqli_query($conn, $sql_quote);

                        if ($row_quote = mysqli_fetch_assoc($result_quote)) {
                            if($quote_type == 'ops') {
                                $tags = [
                                    'assigned_to_region' => $row_quote['assigned_to_region'],
                                    'assigned_to_ops' => $row_quote['assigned_to_ops'],
                                    'sender' => $sender
                                ];
                            } else if($quote_type == 'sales') {
                                $tags = [
                                    'assigned_to_region' => $row_quote['assigned_to_region'],
                                    'assigned_to_sales_agent' => $row_quote['assigned_to_sales_agent'],
                                    'assigned_to_external_sales_agent' => $row_quote['assigned_to_external_sales_agent'],
                                    'sender' => $sender
                                ];
                            } else {
                                $tags = [
                                    'assigned_to_region' => $row_quote['assigned_to_region'],
                                    'sender' => $sender
                                ];
                            }
                
                            foreach ($tags as $key => $tag_value) {
                                if (!empty($tag_value)) {
                                    $sql_tag = "SELECT id FROM vtiger_freetags WHERE tag = '$tag_value';";
                                    $result_tag = mysqli_query($conn, $sql_tag);
                                    
                                    if ($row_tag = mysqli_fetch_assoc($result_tag)) {
                                        $tag_id = $row_tag['id'];
                
                                        $sql_insert = "INSERT IGNORE INTO vtiger_freetagged_objects (tag_id, object_id, module)
                                                       VALUES ('$tag_id', '$conversationId', 'Dashboard');";
                                        mysqli_query($conn, $sql_insert);
                                    }
                                }
                            }
                        }

                        $sql_quote = "SELECT quote_no, country FROM vtiger_quotes WHERE quoteid = '$quoteid';";
                        $result_quote = mysqli_query($conn, $sql_quote);
                        $row_quote = mysqli_fetch_assoc($result_quote);
                        $quote_no = $row_quote['quote_no'];
                        $country = $row_quote['country'];
                        if($country == 'Australia') {
                            $sql_insert = "INSERT IGNORE INTO vtiger_freetagged_objects (tag_id, object_id, module)
                                            VALUES ('93', '$conversationId', 'Dashboard');";
                            mysqli_query($conn, $sql_insert);
                        } else if($country == 'New Zealand') {
                            $sql_insert = "INSERT IGNORE INTO vtiger_freetagged_objects (tag_id, object_id, module)
                                            VALUES ('94', '$conversationId', 'Dashboard');";
                            mysqli_query($conn, $sql_insert);
                        }
                        if($quote_no) {
                            $sql_insert = "INSERT IGNORE INTO vtiger_support (ticketid, quote_no, vendorid)
                                            VALUES ('$conversationId', '$quote_no', '$vendorid_sent');";
                            mysqli_query($conn, $sql_insert);
                        }

                        $sql_update = "UPDATE tdu_mailbox_tmp_tagging SET actioned = 1 WHERE auto_id = '$auto_id';";
                        mysqli_query($conn, $sql_update);
                    }
                }

                if ($folder == 'Inbox' && in_array($emailid, $auto_acknowledge) && strpos($fromEmail, '@turtledownunder') === false) {
                    $sql_auto_ack_check = "SELECT id FROM tdu_emails WHERE sender = '$fromEmail' AND folder = 'Inbox' AND DATE(received_datetime) = DATE(NOW());";
                    $result_auto_ack_check = mysqli_query($conn, $sql_auto_ack_check);
                    if (mysqli_num_rows($result_auto_ack_check) == 1) {
                        $email_body = "<p>Greetings from Turtle Down Under!<br><br>
                                    Thank you for reaching out. We have received your request and are currently working on it. We will get back to you soon with the necessary details.<br><br>
                                    Please let us know if you have any specific requirements in the meantime.<br><p>";
                        $post_data = [
                            'from' => $emailid,
                            'to' => $fromEmail,
                            'compose' => 'Yes',
                            'subject' => 'Auto Reply from Turtledownunder - ' . $subject,
                            'content' => $email_body,
                            'secret' => 'tdu_cronjob'
                        ];
                    
                        $ch = curl_init();
                        // curl_setopt($ch, CURLOPT_URL, "https://dev.yourbestwayhome.com.au/turtledownunder/email_sender.php");
                        curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        $response = curl_exec($ch);
                        curl_close($ch);
                    }
                }
            }
        }
    } else {
        echo "No new emails found for $emailid in $folder.\n";
    }
}

// Function to fetch and process attachments
function fetchAttachments($messageId, $internetMessageId, $emailid, $conn) {
    try {
        global $accessToken;  // Access token needs to be global to use in the API call

        // Fetch the attachments using the messageId
        $httpClient = new Client();
        $responseAttachments = $httpClient->request('GET', "https://graph.microsoft.com/v1.0/me/messages/$messageId/attachments", [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept' => 'application/json',
            ],
        ]);

        $attachments = json_decode($responseAttachments->getBody()->getContents(), true);

        // If attachments exist, process them
        if (!empty($attachments['value'])) {
            foreach ($attachments['value'] as $attachment) {
                $attachmentId = mysqli_real_escape_string($conn, $attachment['id']);
                $attachmentName = mysqli_real_escape_string($conn, $attachment['name']);
                $attachmentContentType = mysqli_real_escape_string($conn, $attachment['contentType']);
                $contentId = isset($attachment['contentId']) ? trim($attachment['contentId'], '<>') : '';
        
                // Check if the attachment is a file
                if ($attachment['@odata.type'] == '#microsoft.graph.fileAttachment') {
                    $sqlAttachment = "INSERT IGNORE INTO tdu_attachments (attachment_id, message_id, email_id, file_name, content_type, content_id)
                                      VALUES ('$attachmentId', '$internetMessageId', '$emailid', '$attachmentName', '$attachmentContentType', '$contentId')";
                    mysqli_query($conn, $sqlAttachment);
                }
            }
        }
    } catch (Exception $e) {
        echo "Failed to fetch attachments for message ID $messageId: " . $e->getMessage() . "\n";
    }
}
?>
