<?php
session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: ../login.php');
    exit;
}

require 'vendor/autoload.php';
use League\OAuth2\Client\Provider\GenericProvider;

// Database connection
include "dbconn.php";
include "header.php";

// OAuth2 Client Credentials
$clientId = '5b1494de-7d7a-48cd-a2d8-da6fb9b8b1d6';
$clientSecret = '-iO8Q~MICIQW7FP~9-RZpnXBKQSjsqK6IZRu-a.l';
$tenantId = '7811efff-0816-46b8-a5b9-39c263c51b20';
// $redirectUri = 'https://dev.yourbestwayhome.com.au/turtledownunder/email/auth.php';
$redirectUri = 'https://dashboard.turtledownunder.com.au/email/auth.php';
$scope = 'https://graph.microsoft.com/Mail.Read https://graph.microsoft.com/Mail.Send offline_access openid profile';

// Set up the OAuth provider
$provider = new GenericProvider([
    'clientId'                => $clientId,
    'clientSecret'            => $clientSecret,
    'redirectUri'             => $redirectUri,
    'urlAuthorize'            => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/authorize",
    'urlAccessToken'          => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/token",
    'urlResourceOwnerDetails' => 'https://graph.microsoft.com/v1.0/me',
]);

// Define emails
$emails = [
    'sales@turtledownunder.com.au', 'groupsales@turtledownunder.com.au',
    'operations@turtledownunder.com.au', 'groups@turtledownunder.com.au',
    'accounts@turtledownunder.com.au', 'contracts@turtledownunder.com.au',
    'asia@turtledownunder.com.au'
];

// Fetch stored tokens
$results = [];
$sql = "SELECT email FROM oauth_tokens WHERE status='active' AND org='au'";
$query = mysqli_query($conn, $sql);
while ($row = mysqli_fetch_assoc($query)) {
    $results[] = $row['email'];
}

?>
<div class="table-container" style="width: 50%; margin: 20px auto;">
    <h1><a style="text-decoration: none;" href="../quote.php?opt=office-email"><i class="fas fa-arrow-left"></i> Dashboard</a></h1>
</div>

<div class="table-container" style="width: 50%; margin: auto;">
    <div class="table-wrapper">
    <?php
    // Generate HTML table
    echo '<table>';
    echo '<tr><th>Email</th><th>Status</th><th>Auth</th><th>Password</th></tr>';
    foreach ($emails as $email) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($email) . '</td>';
        
        // If token is stored, show green tick, else show authorization link
        if (in_array($email, $results)) {
            echo '<td style="color: green;"><i class="fa-solid fa-circle-check"></i></td>';
        } else {
            echo '<td style="color: red;"><i class="fa-solid fa-circle-xmark"></i></td>';
        }
        
        // Authorization link
        $authorizationUrl = $provider->getAuthorizationUrl(['scope' => $scope]);
        echo '<td><button onclick="window.location.href=\'auth.php?email=' . urlencode($email) . '&auth_url=' . urlencode($authorizationUrl) . '\'" class="btn btn-primary"><i class="fa-brands fa-windows"></i></button></td>';
        
        // Password column with "Set Password" button
        echo '<td><button class="set-password-btn" data-email="' . htmlspecialchars($email) . '"><i class="fa-solid fa-pen-to-square"></i></button></td>';
        echo '</tr>';
    }
    echo '</table>';
    ?>
    </div>
</div>

<!-- Modal Form -->
<div id="passwordModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 1000; background: white; padding: 20px; border-radius: 5px; box-shadow: 0px 0px 10px rgba(0,0,0,0.5);">
    <h3>Set New Password</h3>
    <form id="passwordForm" method="post" action="ajax_outlook_password.php">
        <input type="hidden" name="email" id="modalEmail">
        <label for="newPassword">New Password:</label>
        <input type="text" name="password" id="newPassword" required>
        <button type="submit">Save</button>
        <button type="button" id="closeModal">Cancel</button>
    </form>
</div>

<!-- Overlay -->
<div id="overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999;"></div>

<script>
    // JavaScript to handle the modal
    document.querySelectorAll('.set-password-btn').forEach(button => {
        button.addEventListener('click', function() {
            const email = this.getAttribute('data-email');
            document.getElementById('modalEmail').value = email;
            document.getElementById('passwordModal').style.display = 'block';
            document.getElementById('overlay').style.display = 'block';
        });
    });

    document.getElementById('closeModal').addEventListener('click', function() {
        document.getElementById('passwordModal').style.display = 'none';
        document.getElementById('overlay').style.display = 'none';
    });
</script>


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<style>
    .table-container {
        display: flex;
        flex-direction: row;
        width: 100%;
    }

    .table-wrapper {
        border: 1px solid #ccc;
        border-radius: 5px;
        padding: 10px;
        margin: 20px;
        flex: 1;
        min-width: 300px; /* Ensure minimum width */
    }

    .table-container table {
        width: 100%;
        border-collapse: collapse;
    }

    .table-container th, .table-container td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    .table-container th {
        background-color: #f2f2f2;
    }

    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
</style>
