<?php
require 'vendor/autoload.php';
use League\OAuth2\Client\Provider\GenericProvider;
use GuzzleHttp\Client;

// Database connection
include "dbconn.php";
date_default_timezone_set('Australia/Melbourne');

// OAuth2 Client Credentials
$clientId = '5b1494de-7d7a-48cd-a2d8-da6fb9b8b1d6';
$clientSecret = '-iO8Q~MICIQW7FP~9-RZpnXBKQSjsqK6IZRu-a.l';
$tenantId = '7811efff-0816-46b8-a5b9-39c263c51b20';

// Set up the OAuth provider
$provider = new GenericProvider([
    'clientId'                => $clientId,
    'clientSecret'            => $clientSecret,
    'urlAuthorize'            => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/authorize",
    'urlAccessToken'          => "https://login.microsoftonline.com/$tenantId/oauth2/v2.0/token",
    'urlResourceOwnerDetails' => 'https://graph.microsoft.com/v1.0/me',
]);

// Retrieve tokens for all users
$result = mysqli_query($conn, "SELECT * FROM oauth_tokens WHERE org='au' AND temp=1");
if (mysqli_num_rows($result) == 0) {
    die("No tokens found. Run auth.php first to authenticate.");
}

// Calculate the past 24-hour time range in UTC
$now = new DateTime('now', new DateTimeZone('UTC'));
$past24Hours = (clone $now)->modify('-30 days');

$startTime = $past24Hours->format('Y-m-d\TH:i:s\Z');
$endTime = $now->format('Y-m-d\TH:i:s\Z');

// Process emails for each user
while ($row = mysqli_fetch_assoc($result)) {
    $emailid = $row['email'];
    $accessToken = $row['access_token'];
    $refreshToken = $row['refresh_token'];
    $expiresAt = $row['expires_at'];

    try {
        // Refresh token
        $newToken = $provider->getAccessToken('refresh_token', [
            'refresh_token' => $refreshToken,
        ]);

        $accessToken = $newToken->getToken();
        $refreshToken = $newToken->getRefreshToken();
        $expiresAt = time() + $newToken->getExpires();

        $sql = "UPDATE oauth_tokens 
                SET access_token = '$accessToken', 
                    refresh_token = '$refreshToken', 
                    expires_at = $expiresAt
                WHERE email = '$emailid'";
        mysqli_query($conn, $sql);
    } catch (Exception $e) {
        echo "Failed to refresh access token for $emailid: " . $e->getMessage() . "\n";
        $sql = "UPDATE oauth_tokens SET status = 'inactive' WHERE email = '$emailid'";
        mysqli_query($conn, $sql);
        continue;
    }

    try {
        // Fetch emails from Inbox
        $inboxUrl = "https://graph.microsoft.com/v1.0/me/mailFolders/inbox/messages?\$top=100&\$filter=receivedDateTime ge $startTime and receivedDateTime le $endTime";
        fetchEmailsWithPagination($inboxUrl, $accessToken, $emailid, $conn, 'Inbox');

        // Fetch emails from Sent Items
        $sentItemsUrl = "https://graph.microsoft.com/v1.0/me/mailFolders/sentItems/messages?\$top=100&\$filter=sentDateTime ge $startTime and sentDateTime le $endTime";
        fetchEmailsWithPagination($sentItemsUrl, $accessToken, $emailid, $conn, 'Sent Items');

    } catch (Exception $e) {
        echo "Failed to fetch emails for $emailid: " . $e->getMessage() . "\n";
        $sql = "UPDATE oauth_tokens SET status = 'inactive' WHERE email = '$emailid'";
        mysqli_query($conn, $sql);
        continue;
    }
}

echo 'DONE';

// Function to fetch emails with pagination support
function fetchEmailsWithPagination($folderUrl, $accessToken, $emailid, $conn, $folder) {
    $httpClient = new Client();
    $nextLink = $folderUrl;

    do {
        $response = $httpClient->request('GET', $nextLink, [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept'        => 'application/json',
            ],
        ]);

        $emails = json_decode($response->getBody()->getContents(), true);
        processEmails($emails, $emailid, $conn, $folder);

        // Check if more results are available
        $nextLink = $emails['@odata.nextLink'] ?? null;

    } while ($nextLink);
}

// Function to process emails
function processEmails($emails, $emailid, $conn, $folder) {
    if (!empty($emails['value'])) {
        foreach ($emails['value'] as $email) {
            $id = mysqli_real_escape_string($conn, $email['id']);
            $messageId = mysqli_real_escape_string($conn, $email['internetMessageId']);
            $conversationId = mysqli_real_escape_string($conn, $email['conversationId']);
            $inReplyTo = isset($email['inReplyTo']) ? mysqli_real_escape_string($conn, $email['inReplyTo']) : null;
            $subject = mysqli_real_escape_string($conn, $email['subject']);

            $fromEmail = mysqli_real_escape_string($conn, $email['from']['emailAddress']['address']);
            $fromName = mysqli_real_escape_string($conn, $email['from']['emailAddress']['name']); // Get sender's name

            $body = $email['body']['content'];
            $body = html_entity_decode($body, ENT_QUOTES | ENT_HTML5, 'UTF-8'); // Decode HTML entities
            $body = preg_replace('/[^\x00-\x7F]/', '', $body);
            $body = mysqli_real_escape_string($conn, $body);
            $bodyPreview = mysqli_real_escape_string($conn, $email['bodyPreview']);
            
            $plaintextBody = strip_tags($body); // Strip HTML tags to get plain text
            $plaintextBody = html_entity_decode($plaintextBody, ENT_QUOTES | ENT_HTML5, 'UTF-8'); // Decode HTML entities
            $plaintextBody = mysqli_real_escape_string($conn, $plaintextBody);

            $utcDateTime = new DateTime($email['receivedDateTime'] ?? $email['sentDateTime'], new DateTimeZone('UTC'));
            $melbourneDateTime = $utcDateTime->setTimezone(new DateTimeZone('Australia/Melbourne'));
            $receivedDateTime = $melbourneDateTime->format('Y-m-d H:i:s');

            $ccList = [];
            if (!empty($email['ccRecipients'])) {
                foreach ($email['ccRecipients'] as $cc) {
                    $ccList[] = $cc['emailAddress']['address'];
                }
            }
            $cc = mysqli_real_escape_string($conn, implode(',', $ccList));

            $toList = [];
            if (!empty($email['toRecipients'])) {
                foreach ($email['toRecipients'] as $to) {
                    $toList[] = $to['emailAddress']['address'];
                }
            }
            $to = mysqli_real_escape_string($conn, implode(',', $toList));

            $sqlCheck = "SELECT COUNT(*) AS count FROM tdu_emails WHERE message_id = '$messageId' AND mailbox='$emailid' AND folder='$folder'";
            $resultCheck = mysqli_query($conn, $sqlCheck);
            $rowCheck = mysqli_fetch_assoc($resultCheck);

            if ($rowCheck['count'] >= 0) {
                $sql = "INSERT INTO tdu_emails (msgid, message_id, conversation_id, in_reply_to, subject, sender, sender_name, received_datetime, body_preview, cc, full_body, mailbox, folder, recipient, plaintext_body) 
                        VALUES ('$id', '$messageId', '$conversationId', '$inReplyTo', '$subject', '$fromEmail', '$fromName', '$receivedDateTime', '$bodyPreview', '$cc', '$body', '$emailid', '$folder', '$to', '$plaintextBody')
                        ON DUPLICATE KEY UPDATE full_body = '$body'
                        ";        
                mysqli_query($conn, $sql);

                // Fetch attachments for this email
                // fetchAttachments($email['id'], $messageId, $emailid, $conn);
            }
        }
    } else {
        echo "No new emails found for $emailid in $folder.\n";
    }
}

// Function to fetch and process attachments
function fetchAttachments($messageId, $internetMessageId, $emailid, $conn) {
    try {
        global $accessToken;  // Access token needs to be global to use in the API call

        // Fetch the attachments using the messageId
        $httpClient = new Client();
        $responseAttachments = $httpClient->request('GET', "https://graph.microsoft.com/v1.0/me/messages/$messageId/attachments", [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept' => 'application/json',
            ],
        ]);

        $attachments = json_decode($responseAttachments->getBody()->getContents(), true);

        // If attachments exist, process them
        if (!empty($attachments['value'])) {
            foreach ($attachments['value'] as $attachment) {
                $attachmentId = mysqli_real_escape_string($conn, $attachment['id']);
                $attachmentName = mysqli_real_escape_string($conn, $attachment['name']);
                $attachmentContentType = mysqli_real_escape_string($conn, $attachment['contentType']);

                // Check if the attachment is a file
                if ($attachment['@odata.type'] == '#microsoft.graph.fileAttachment') {
                    $sqlAttachment = "INSERT IGNORE INTO tdu_attachments (attachment_id, message_id, email_id, file_name, content_type, created_at)
                                      VALUES ('$attachmentId', '$internetMessageId', '$emailid', '$attachmentName', '$attachmentContentType', '2024-04-01')";
                    mysqli_query($conn, $sqlAttachment);
                }
            }
        }        
    } catch (Exception $e) {
        echo "Failed to fetch attachments for message ID $messageId: " . $e->getMessage() . "\n";
    }
}
?>
