<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'email/vendor/autoload.php';
include "dbconn.php";

session_start();

if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $from = $_POST['from'] ?? '';
    $to = $_POST['to'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $content = $_POST['content'] ?? '';
    if(!empty($content)) {
        // Add inline styles to <table>
        $content = preg_replace(
            '/<table(.*?)>/i',
            '<table style="border-collapse: collapse; border-spacing: 0; width: 100%; border: 1px solid #999999;"$1>',
            $content
        );

        // Add inline styles to <th>
        $content = preg_replace(
            '/<th(.*?)>/i',
            '<th style="border: 1px solid #999999; padding: 4px; text-align: left;"$1>',
            $content
        );

        // Add inline styles to <td>
        $content = preg_replace(
            '/<td(.*?)>/i',
            '<td style="border: 1px solid #999999; padding: 4px;"$1>',
            $content
        );

        // Add inline styles to <p> (with margin: 0)
        $content = preg_replace(
            '/<p(.*?)>/i',
            '<p style="margin: 0;"$1>',
            $content
        );
    }
    $messageid = $_POST['messageid'] ?? '';
    $cc = $_POST['cc'] ?? '';

    // Sanitize inputs
    $from = filter_var($from, FILTER_SANITIZE_EMAIL);
    $subject = htmlspecialchars($subject);

    $originalEmailQuery = "SELECT msgid, full_body, sender_name, received_datetime FROM tdu_emails WHERE message_id = '$messageid'";
    $originalEmailResult = mysqli_query($conn, $originalEmailQuery);
    $originalEmail = mysqli_fetch_assoc($originalEmailResult);

    if ($originalEmail) {
        $msgid = htmlspecialchars($originalEmail['msgid']);
        $originalBody = $originalEmail['full_body'];
        $originalSender = $originalEmail['sender_name'];
        $originalDate = $originalEmail['received_datetime'];

        // Format the reply body
        $content .= "<br><br>On $originalDate, $originalSender wrote:<br>";
        $content .= "<blockquote style='border-left: 2px solid #ccc; padding-left: 10px; color: #555;'>$originalBody</blockquote>";
    }

    // Process 'to' field for multiple recipients
    $toEmails = [];
    if (!empty($to)) {
        $toArray = explode(',', $to);
        foreach ($toArray as $email) {
            $toEmails[] = filter_var(trim($email), FILTER_SANITIZE_EMAIL);
        }
    }

    // Process 'cc' field for multiple recipients
    $ccEmails = [];
    if (!empty($cc)) {
        $ccArray = explode(',', $cc);
        foreach ($ccArray as $email) {
            $ccEmails[] = filter_var(trim($email), FILTER_SANITIZE_EMAIL);
        }
    }

    // Retrieve sender email credentials
    $sql_login = "SELECT email, password FROM oauth_tokens";
    $result_login = $conn->query($sql_login);

    $emailCredentials = [];
    if ($result_login->num_rows > 0) {
        while ($row_login = $result_login->fetch_assoc()) {
            $emailCredentials[$row_login['email']] = $row_login['password'];
        }
    }

    if (!array_key_exists($from, $emailCredentials)) {
        echo "<script>alert('Invalid sender email address.');</script>";
        exit;
    }

    $password = $emailCredentials[$from];
    if (empty($password)) {
        echo "<script>alert('Password for the sender email is not configured.');</script>";
        exit;
    }

    // Initialize PHPMailer
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.office365.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = $from;
        $mail->Password   = $password;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;

        $mail->setFrom($from);

        // Add recipients
        foreach ($toEmails as $toEmail) {
            if (filter_var($toEmail, FILTER_VALIDATE_EMAIL)) {
                $mail->addAddress($toEmail);
            }
        }

        // Add CC recipients
        foreach ($ccEmails as $ccEmail) {
            if (filter_var($ccEmail, FILTER_VALIDATE_EMAIL)) {
                $mail->addCC($ccEmail);
            }
        }

        if (isset($_FILES['attachments'])) {
            foreach ($_FILES['attachments']['tmp_name'] as $index => $tmpName) {
                if ($_FILES['attachments']['error'][$index] === UPLOAD_ERR_OK) {
                    $mail->addAttachment($tmpName, $_FILES['attachments']['name'][$index]);
                }
            }
        }

        // Process and attach files associated with the message_id
        if (!empty($messageid)) {
            $attachmentUrl = "https://dashboard.turtledownunder.com.au/ajax_outlook_attachment_download_all.php?message_id=" . urlencode($msgid);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $attachmentUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $attachmentResponse = curl_exec($ch);
            curl_close($ch);

            $filePaths = json_decode($attachmentResponse, true);

            foreach ($filePaths as $filePath) {
                if (file_exists($filePath)) {
                    $mail->addAttachment($filePath);
                }
            }
        }        

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $content;

        $mail->send();
        echo "<script>alert('Email has been sent successfully.'); window.history.back();</script>";
    } catch (Exception $e) {
        echo "<script>alert('Email could not be sent. Please try again later.');</script>";
    }
}
?>
