<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

session_start();

if (!isset($_SESSION['user_name']) && $_POST['secret'] != 'tdu_cronjob') {
    header('Location: login.php');
    exit;
}

require 'email/vendor/autoload.php';
include "dbconn.php";

$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name, alias_name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
    $alias_name = $row_ajax['alias_name'] ?? '';
    if (trim($alias_name) == '') {
        $alias_name = $username_ajax;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $from = $_POST['from'] ?? '';
    $to = $_POST['to'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $content = $_POST['content'] ?? '';
    if(!empty($content)) {
        // Add inline styles to <table>
        $content = preg_replace(
            '/<table(.*?)>/i',
            '<table style="border-collapse: collapse; border-spacing: 0; width: 100%; border: 1px solid #999999;"$1>',
            $content
        );

        // Add inline styles to <th>
        $content = preg_replace(
            '/<th(.*?)>/i',
            '<th style="border: 1px solid #999999; padding: 4px; text-align: left;"$1>',
            $content
        );

        // Add inline styles to <td>
        $content = preg_replace(
            '/<td(.*?)>/i',
            '<td style="border: 1px solid #999999; padding: 4px;"$1>',
            $content
        );

        // Add inline styles to <p> (with margin: 0)
        $content = preg_replace(
            '/<p(.*?)>/i',
            '<p style="margin: 0;"$1>',
            $content
        );
    }

    $messageid = $_POST['messageid'] ?? '';
    $cc = $_POST['cc'] ?? '';
    $conversation_id = $_POST['conversation_id'] ?? '';

    // Sanitize inputs
    $from = filter_var($from, FILTER_SANITIZE_EMAIL);
    $subject = htmlspecialchars($subject);

    $signature = '
    <br><br>
    <div style="font-family: Arial, sans-serif; color: #555; line-height: 1.5;">
        <span style="color: #333;">Kind Regards, </span><br>
        <span style="color: #333;">' . $alias_name . '</span><br>
        <span style="color: #333;">Turtle Down Under</span><br>
        <span>Email: <a href="mailto:' . $from . '" style="color: #007BFF;">' . $from . '</a></span><br>';
    if ($from == 'sales@turtledownunder.com.au' || $from == 'groupsales@turtledownunder.com.au') {
        $signature .= '<span>Phone: +91 2269475370</span><br>';
    }
    if ($from == 'sales@turtledownunder.com.au' || $from == 'groupsales@turtledownunder.com.au' || $from == 'asia@turtledownunder.com.au') {
        $signature .= '
            <span>Website: <a href="https://www.turtledownunder.com.au" style="color: #007BFF;">https://www.turtledownunder.com.au</a></span><br>
            <div style="margin-top: 20px;">
                <img src="https://dashboard.turtledownunder.com.au/email_signature/logo4.png" alt="TDU LOGO" style="margin: 5px; width: 100px; height: auto;"><br>
                <a href="https://turtledownunder.com.au/webinar/" target="_blank">
                    <img src="https://dashboard.turtledownunder.com.au/email_signature/emailsignature.jpg" alt="Banner" style="border: none;">
                </a>
            </div>
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                Please Note: This email (including any attachments) is for the intended recipient\'s use only. It contains information which may be confidential. 
                If you have received this email by mistake, please notify us immediately by reply email or telephone and permanently delete it from your email system. 
                Any confidentiality is not waived because this email has been sent to you by mistake. 
                We use virus-checking software and take all reasonable precautions to ensure no viruses are present in this email, but we cannot guarantee that this email is error or virus-free.
            </p>
        </div>
        ';
    } else {
        $signature .= '
            <span>Website: <a href="https://www.turtledownunder.com.au" style="color: #007BFF;">https://www.turtledownunder.com.au</a></span><br>
            <div style="margin-top: 20px;">
                <img src="https://dashboard.turtledownunder.com.au/email_signature/logo1.png" alt="Image 1" style="margin: 5px; width: 100px; height: auto;">
                <img src="https://dashboard.turtledownunder.com.au/email_signature/logo2.png" alt="Image 2" style="margin: 5px; width: 100px; height: auto;">
                <img src="https://dashboard.turtledownunder.com.au/email_signature/logo3.png" alt="Image 3" style="margin: 5px; width: 100px; height: auto;">
                <br>
                <img src="https://dashboard.turtledownunder.com.au/email_signature/logo4.png" alt="Image 4" style="margin: 5px; width: 100px; height: auto;">
            </div>
            <p style="font-size: 12px; color: #999; margin-top: 20px;">
                Please Note: This email (including any attachments) is for the intended recipient\'s use only. It contains information which may be confidential. 
                If you have received this email by mistake, please notify us immediately by reply email or telephone and permanently delete it from your email system. 
                Any confidentiality is not waived because this email has been sent to you by mistake. 
                We use virus-checking software and take all reasonable precautions to ensure no viruses are present in this email, but we cannot guarantee that this email is error or virus-free.
            </p>
        </div>
        ';
    }
    
    $content .= $signature;

    // Process 'to' field for multiple recipients
    $toEmails = [];
    if (!empty($to)) {
        $toArray = explode(',', $to);
        foreach ($toArray as $email) {
            $toEmails[] = filter_var(trim($email), FILTER_SANITIZE_EMAIL);
        }
    }

    // Process 'cc' field for multiple recipients
    $ccEmails = [];
    if (!empty($cc)) {
        $ccArray = explode(',', $cc);
        foreach ($ccArray as $email) {
            $ccEmails[] = filter_var(trim($email), FILTER_SANITIZE_EMAIL);
        }
    }

    if(!isset($_POST['compose'])) {
        // Retrieve original email content for quoting
        $originalEmailQuery = "SELECT full_body, sender_name, received_datetime FROM tdu_emails WHERE message_id = '$messageid'";
        $originalEmailResult = mysqli_query($conn, $originalEmailQuery);
        $originalEmail = mysqli_fetch_assoc($originalEmailResult);

        if ($originalEmail) {
            $originalBody = $originalEmail['full_body'];
            $originalSender = $originalEmail['sender_name'];
            $originalDate = $originalEmail['received_datetime'];

            // Format the reply body
            $content .= "<br><br>On $originalDate, $originalSender wrote:<br>";
            $content .= "<blockquote style='border-left: 2px solid #ccc; padding-left: 10px; color: #555;'>$originalBody</blockquote>";
        }
    }

    // Sender email credentials
    $sql_login = "SELECT email, password FROM oauth_tokens";
    $result_login = $conn->query($sql_login);

    $emailCredentials = [];
    if ($result_login->num_rows > 0) {
        while ($row_login = $result_login->fetch_assoc()) {
            $emailCredentials[$row_login['email']] = $row_login['password'];
        }
    }

    if (!array_key_exists($from, $emailCredentials)) {
        echo "<script>alert('Invalid sender email address.');</script>";
        exit;
    }

    $password = $emailCredentials[$from];
    if (empty($password)) {
        echo "<script>alert('Password for the sender email is not configured.');</script>";
        exit;
    }

    // Initialize PHPMailer
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.office365.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = $from;
        $mail->Password   = $password;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;

        $mail->setFrom($from);

        // Add recipients
        foreach ($toEmails as $toEmail) {
            if (filter_var($toEmail, FILTER_VALIDATE_EMAIL)) {
                $mail->addAddress($toEmail);
            }
        }

        // Add CC recipients
        foreach ($ccEmails as $ccEmail) {
            if (filter_var($ccEmail, FILTER_VALIDATE_EMAIL)) {
                $mail->addCC($ccEmail);
            }
        }

        // Add custom headers for replies
        if (!empty($messageid)) {
            $mail->addCustomHeader('In-Reply-To', $messageid);
            $mail->addCustomHeader('References', $messageid);
        }

        // Handle attachments
        if (isset($_FILES['attachments'])) {
            foreach ($_FILES['attachments']['tmp_name'] as $index => $tmpName) {
                if ($_FILES['attachments']['error'][$index] === UPLOAD_ERR_OK) {
                    $mail->addAttachment($tmpName, $_FILES['attachments']['name'][$index]);
                }
            }
        }

        if (isset($_POST['existing_attachments'])) {
            foreach ($_POST['existing_attachments'] as $filePath) {
                $fileName = basename($filePath);
                if (file_exists($filePath)) {
                    $mail->addAttachment($filePath, $fileName);
                }
            }
        }

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $content;

        $mail->send();
        if(isset($_POST['need-process-booking-status']) && $_POST['need-process-booking-status'] == 'yes') {
            $quoteid = $_POST['email-quoteid'];
            $vendorid = $_POST['email-vendorid'];
            $sql = "SELECT vi.sequence_no, vi.cf_928 FROM vtiger_inventoryproductrel vi
                    LEFT JOIN tdu_products p ON vi.productid = p.productid
                    WHERE vi.id='$quoteid' AND p.vendorid = '$vendorid'";
            $result = mysqli_query($conn, $sql);
            while ($row = mysqli_fetch_assoc($result)) {
                $sequence_no = $row['sequence_no'];
                $cf_928 = $row['cf_928'];

                $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                               VALUES ('$quoteid', '$sequence_no', 'booking_status', 'Awaiting confirmation', NOW(), 'SYSTEM')";
                if($cf_928 == 'Transfers') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 0, 'booking_status', 'Awaiting confirmation', NOW(), 'SYSTEM')";
                }
                mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            
                $update_sql = "UPDATE vtiger_inventoryproductrel 
                               SET booking_status='Awaiting confirmation' 
                               WHERE id='$quoteid' AND sequence_no='$sequence_no'";
                mysqli_query($conn, $update_sql) or die(mysqli_error($conn));
            }
        }

        if(!isset($_POST['compose'])) {
            $sql_history = "INSERT INTO vtiger_support_history (conversation_id, details, created_by) VALUES ('$conversation_id', 'Reply Email', '$username_ajax')";
            mysqli_query($conn, $sql_history);
            ?>
            <script>
                alert('Email has been sent successfully.');
                
                var referrer = document.referrer;
                var newUrl = referrer.includes('?') ? referrer + '&replied=1' : referrer + '?replied=1';

                window.location.href = newUrl;
            </script>
            <?php
        } 
        else {
            echo "<script>alert('Email has been sent successfully.'); window.history.back();</script>";
        }

        if(isset($_POST['quoteid_compose']) && $subject != '') {
            $quoteid = $_POST['quoteid_compose'];
            $subject = mysqli_real_escape_string($conn, $subject);
            $quote_type_compose = $_POST['quote_type_compose'];
            $email_sender_compose = $_POST['email_sender_compose'];
            $vendorid = 0;
            if(isset($_POST['need-process-booking-status']) && isset($_POST['email-vendorid']) && !empty($_POST['email-vendorid'])) {
                $vendorid = $_POST['email-vendorid'];
            }
            $sql_quote = "INSERT INTO tdu_mailbox_tmp_tagging (quoteid, subject, mailbox, quote_type, sender, vendorid) VALUES ('$quoteid', '$subject', '$from', '$quote_type_compose', '$email_sender_compose', '$vendorid')";
            mysqli_query($conn, $sql_quote);
        }
    } catch (Exception $e) {
        echo "<script>alert('Email could not be sent. Please check whether to is entered. Otherwise, try again later.'); window.history.back();</script>";
    }
}
?>
