<?php
require '/home/dashboardturtled/vendor/autoload.php';

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;
use Dompdf\Dompdf;
use Dompdf\Options;

include "dbconn.php";
include "html_utility.php";
include "quote_pricing.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) && !isset($_POST['download-invoice']) && $_POST['so'] != 'SO001' && $_POST['quote'] != 'Q001') {
    header('Location: login.php');
    exit;
}

$created_by = $_SESSION['user_name'];
$sql_user = "SELECT CONCAT(first_name, ' ', last_name) AS user_fullname FROM vtiger_users WHERE user_name = '$created_by';";
$result_user = mysqli_query($conn, $sql_user);
if ($result_user) {
    if (mysqli_num_rows($result_user) > 0) {
        $row_user = mysqli_fetch_assoc($result_user);
        $created_by = $row_user['user_fullname'];
    }
}

require_once '/home/dashboardturtled/vendor/phpoffice/phpword/bootstrap.php';

// keep track of history of downloaded files
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['download-invoice']) && isset($_POST['quoteid'])) {
    $quoteid = $_POST['quoteid'];
    $filepath = $_POST['filepath'];
    $type = $_POST['type'];

    $insert_sql = "INSERT INTO vtiger_invoice (quoteid, filepath, type, created_by) VALUES ('$quoteid', '$filepath', '$type', '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
}

// generate quote
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quote']) && isset($_POST['quoteid'])) {
    $quoteid = $_POST['quoteid'];

    $invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'initial'";
    $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
    $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
    $created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;
    if($created_at_query) {
        $created_at_query = " AND created_at < '$created_at_query' ";
    }
    else { 
        $created_at_query = "";
    }

    // query the room info
    $sql = "SELECT meta_key, meta_value 
            FROM vtiger_itinerary 
            WHERE quoteid = '$quoteid' 
            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
            AND (meta_key, created_at) IN (
                SELECT meta_key, MAX(created_at)
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid' $created_at_query
                AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
                GROUP BY meta_key);";
    $result = mysqli_query($conn, $sql);

    $single_rooms_global = 0;
    $double_rooms_global = 0;
    $triple_rooms_global = 0;
    $child_no_bed_global = 0;
    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['meta_key']) {
            case 'single_rooms':
                $single_rooms_global = (int) $row['meta_value'];
                break;
            case 'double_rooms':
                $double_rooms_global = (int) $row['meta_value'];
                break;
            case 'triple_rooms':
                $triple_rooms_global = (int) $row['meta_value'];
                break;
            case 'child_without_bed':
                $child_no_bed_global = (int) $row['meta_value'];
                break;
        }
    }
    
    $quote_number = $_POST['quoteNumber'];
    $date_of_travel = htmlspecialchars($_POST['dateoftravel']);
    $mode = $_POST['mode'];
    $hotel_markup_percentage = 0;
    $sql = "SELECT DISTINCT 
                vq.quoteid, vq.quote_no, vq.created_at, vq.country, vq.adults, vq.children, vq.infants, 
                vi.productid, vi.sequence_no, vi.day, vi.cf_928, vi.comment, vi.quantity,
                vp.productName AS productname, vp.description,
                vv.vendorName AS vendorname, 
                IFNULL(vps.sale_price, '') AS sale_price, tdo.membershipid
            FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
            LEFT JOIN vtiger_display_order vdo ON vi.id=vdo.id AND vi.sequence_no=vdo.sequence_no
            LEFT JOIN ( SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description FROM vtiger_products_custom
                        UNION ALL
                        SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description FROM tdu_products
                        ) vp ON vi.productid = vp.productid
            LEFT JOIN tdu_vendors vv ON vp.vendor_id = vv.vendorid
            LEFT JOIN tdu_organisation tdo ON vq.accountid=tdo.organizationid 
            LEFT JOIN vtiger_products_saleprice vps ON vq.quoteid = vps.quoteid AND vi.productid = vps.productid AND vi.sequence_no = vps.sequence_no AND vps.subquoteid <= 1
            ORDER BY vi.day ASC, vdo.display_order ASC;";
    $result = mysqli_query($conn, $sql);

    $hotels = [];
    $others = [];
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['cf_928'] === 'Hotel') {
            $sequence_no = $row['sequence_no'];
            $sql_time = "SELECT meta_value FROM vtiger_itinerary 
                        WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND meta_key='check_in' 
                        ORDER BY created_at DESC
                        LIMIT 1;";
            $result_time = mysqli_query($conn, $sql_time);
            if ($result_time && mysqli_num_rows($result_time) > 0) {
                $row_time = mysqli_fetch_assoc($result_time);
                $check_in = $row_time['meta_value'] ?? '';
            } else {
                $check_in = '';
            }
            $sql_time = "SELECT meta_value FROM vtiger_itinerary 
                        WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND meta_key='check_out' 
                        ORDER BY created_at DESC
                        LIMIT 1;";
            $result_time = mysqli_query($conn, $sql_time);
            if ($result_time && mysqli_num_rows($result_time) > 0) {
                $row_time = mysqli_fetch_assoc($result_time);
                $check_out = $row_time['meta_value'] ?? '';
            } else {
                $check_out = '';
            }

            $row['check_in'] = $check_in;
            $row['check_out'] = $check_out;
            $hotels[] = $row;
        } else {
            $others[] = $row;
        }
    }
    
    $highlightStyle = ['bgColor' => 'FFFFE0'];
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    $section = $phpWord->addSection();
    
    $section->addText('Dear Team,');
    $section->addTextBreak(1);
    $section->addText('Greetings from Turtle Down Under!!!');
    $section->addTextBreak(1);
    $section->addText('Please find below quote - ' . $quote_number);
    $section->addTextBreak(1);
    
    $styleTable = array('borderSize' => 6, 'borderColor' => '999999', 'cellMargin' => 80);
    $phpWord->addTableStyle('Styled Table', $styleTable);
    
    $table = $section->addTable('Styled Table');
    $day = -1;
    foreach ($others as $row) {
        $country = $row['country'];
        $quoteid = $row['quoteid'];
        $sequence_no = $row['sequence_no'];
        $adults = $row['adults'] ?? 0;
        $children = $row['children'] ?? 0;
        $infants = $row['infants'] ?? 0;
        $membershipid = $row['membershipid'] ?? 1;
        $no_pax = $adults + $children;
        $pax_no = $adults + $children;

        $sql_time = "SELECT meta_value FROM vtiger_itinerary 
                    WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND meta_key='tourtime' 
                    ORDER BY created_at DESC
                    LIMIT 1;";
        $result_time = mysqli_query($conn, $sql_time);
        if ($result_time && mysqli_num_rows($result_time) > 0) {
            $row_time = mysqli_fetch_assoc($result_time);
            $tour_time = $row_time['meta_value'] ?? '';
        } else {
            $tour_time = '';
        }

        if (empty($sequence_no)) {
            continue;
        }
        if ($day != $row['day']) {
            if ($day != -1) {
                foreach ($hotels as $hotel) {
                    $check_date = date('Y-m-d', strtotime($date_of_travel . ' + ' . ($day - 1) . ' days'));
        
                    if ($check_date >= $hotel['check_in'] && $check_date <= date('Y-m-d', strtotime($hotel['check_out'] . ' -1 day'))) {
                        $table->addRow();
                        $table->addCell(2000);
                        $table->addCell(20000)->addText(str_replace('&', 'and', $hotel['productname'] ?? ''));
                    }
                }
                $table->addRow();
                $table->addCell(2000);
                $table->addCell(20000);
            }
            $day = $row['day'];
            $day_col = 'Day ' . $day . ' ' . $tour_time;
        }
        else {
            $day_col = $tour_time;
        }
        
        $table->addRow();
        $table->addCell(2000)->addText($day_col);
        
        $itemName = $row['productname'] ?? '';
        if(isset($row['quantity']) && $row['adults'] + $row['children'] >= 50) {
            $itemName = $row['quantity'] . ' x '. $row['productname'] ?? '';
        }
        $itemName = str_replace('&', 'and', $itemName);
        // $vendorName = htmlspecialchars($row['vendorname'] ?? '');
        // $comment = htmlspecialchars($row['comment'] ?? '');

        $cell = $table->addCell(20000);
        $cell->addText($itemName);
        // $cell->addTextBreak(1);
        // $cell->addText($vendorName, array('bold' => true));
        // $cell->addTextBreak(0);
        // $cell->addText($comment);
        if(isset($row['comment']) && $row['comment'] != '') {
            $textRun = $cell->addTextRun();
            $comment = str_replace('&', 'and', $row['comment']);
            $comment = str_replace('<', ' ', $comment);
            $comment = str_replace('>', ' ', $comment);
            $commentLines = preg_split('/\r\n|\r|\n/', $comment);
            foreach ($commentLines as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }
        }
        if(isset($row['description']) && $row['description'] != '') {
            $textRun = $cell->addTextRun();
            $comment = str_replace('&', 'and', $row['description']);
            $comment = str_replace('<', ' ', $comment);
            $comment = str_replace('>', ' ', $comment);
            $commentLines = preg_split('/\r\n|\r|\n/', $comment);
            foreach ($commentLines as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }
        }
    }

    $child_with_bed_global = $children - $child_no_bed_global;
    $infants_global = $infants;
    
    if($country == 'Australia') {
        $currency = 'AUD';
    }
    else if ($country == 'New Zealand') {
        $currency = 'NZD';
    }
    else {
        $currency = '';
    }

    $pricing_data = getPricingDetails($conn, $quoteid);
    if($pricing_data) {
        $pricing_attraction = $pricing_data['Attraction']['adult'];
        $pricing_attraction_child = $pricing_data['Attraction']['child'];
        $pricing_attraction_infant = $pricing_data['Attraction']['infant'];

        $pricing_sic = $pricing_data['SIC']['adult'];
        $pricing_sic_child = $pricing_data['SIC']['child'];
        $pricing_sic_infant = $pricing_data['SIC']['infant'];

        $pricing_single = $pricing_data['Hotel']['single'];
        $pricing_double = $pricing_data['Hotel']['double'];
        $pricing_triple = $pricing_data['Hotel']['triple'];
        $pricing_child_with_bed = $pricing_data['Hotel']['child_with_bed'];
        $pricing_child_no_bed = $pricing_data['Hotel']['child_no_bed'];

        $pricing_restaurant = $pricing_data['Restaurant']['adult'];
        $pricing_restaurant_child = $pricing_data['Restaurant']['child'];
        $pricing_restaurant_infant = $pricing_data['Restaurant']['infant'];

        $pricing_transfers = $pricing_data['Transfers']['adult'];
        $pricing_guide = $pricing_data['Guide']['adult'];

        $pricing_tour = $pricing_data['Tour']['adult'];
        $pricing_tour_child = $pricing_data['Tour']['child'];
        $pricing_tour_infant = $pricing_data['Tour']['infant'];
    }

    if(substr($quote_number, -1) === 'G') {
        $quote_type_mup = 'Group';
    } else {
        $quote_type_mup = 'FIT';
    }

    $mode_sql = '=0';
    if($mode == 'group') {
        $mode_sql = '>1';
    }
    $sql_group_sum = "SELECT vps.subquoteid, SUM(vps.sale_price) AS total_sale_price, MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                    FROM vtiger_products_saleprice vps
                    WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                    GROUP BY vps.subquoteid
                    ORDER BY pax_min ASC;";
    $result_group_sum = mysqli_query($conn, $sql_group_sum);

    if (mysqli_num_rows($result_group_sum) > 0) {
        $pax_no_pax_range = $pax_no;
        $section->addTextBreak(1);
        $section->addText('Quote Based on:', array('bold' => true));
        
        $table = $section->addTable('Styled Table');
        
        $table->addRow();
        $table->addCell()->addText('Slabs based on minimum number of travelling passengers per adult');
        if ($single_rooms_global == 0 && $double_rooms_global == 0 && $triple_rooms_global == 0) {
            $table->addCell(3000)->addText('Package Price');
        }
        if ($single_rooms_global > 0) {
            $table->addCell(3000)->addText('Single Room');
        }
        if ($double_rooms_global > 0) {
            $table->addCell(3000)->addText('Double Room');
        }
        if ($triple_rooms_global > 0) {
            $table->addCell(3000)->addText('Triple Room');
        }
        if ($child_with_bed_global > 0) {
            $table->addCell(3000)->addText('Child with Bed');
        }
        if ($child_no_bed_global > 0) {
            $table->addCell(3000)->addText('Child No Bed');
        }
        if ($infants_global > 0) {
            $table->addCell(3000)->addText('Infant');
        }

        while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
            $min_pax = (int) $row_group_sum['pax_min'] ?? 1;
            $max_pax = (int) $row_group_sum['pax_max'] ?? 1;

            if($mode == 'group') {
                $pricing = getQuotePricing($conn, $quoteid, $min_pax);
            } else {
                $pricing = getQuotePricing($conn, $quoteid, -1);
            }
            $single_room = $pricing['single_room'];
            $double_room = $pricing['double_room'];
            $triple_room = $pricing['triple_room'];
            $child_with_bed = $pricing['child_with_bed'];
            $child_no_bed = $pricing['child_no_bed'];
            $infant = $pricing['infant'];

            $table->addRow();
            if($mode != 'group') {
                $table->addCell(3000)->addText('Based on ' . $no_pax . ' Adults travelling passengers');
            } else {
                $table->addCell()->addText("Minimum $min_pax - $max_pax adult paying travelling passengers");
            }

            if ($single_rooms_global == 0 && $double_rooms_global == 0 && $triple_rooms_global == 0) {
                $table->addCell(3000)->addText('$' . $single_room);
            }
            if ($single_rooms_global > 0) {
                $table->addCell(3000)->addText('$' . $single_room);
            }
            if ($double_rooms_global > 0) {
                $table->addCell(3000)->addText('$' . $double_room);
            }
            if ($triple_rooms_global > 0) {
                $table->addCell(3000)->addText('$' . $triple_room);
            }
            if ($child_with_bed_global > 0) {
                $table->addCell(3000)->addText('$' . $child_with_bed);
            }
            if ($child_no_bed_global > 0) {
                $table->addCell(3000)->addText('$' . $child_no_bed);
            }
            if ($infants_global > 0) {
                $table->addCell(3000)->addText('$' . $infant);
            }
        }
        $section->addText('*All Costs are in '.$currency, ['bold' => true]);
    } else {
        $pricing = getQuotePricing($conn, $quoteid, -1);
        $single_room = $pricing['single_room'];
        $double_room = $pricing['double_room'];
        $triple_room = $pricing['triple_room'];
        $child_with_bed = $pricing['child_with_bed'];
        $child_no_bed = $pricing['child_no_bed'];
        $infant = $pricing['infant'];

        $section->addTextBreak(1);
        $section->addText('Quote Based on:', array('bold' => true));
        
        $table = $section->addTable('Styled Table');

        // <th>
        $table->addRow();
        $table->addCell(3000)->addText('');

        if ($single_rooms_global == 0 && $double_rooms_global == 0 && $triple_rooms_global == 0) {
            $table->addCell(3000)->addText('Package Price');
        }
        if ($single_rooms_global > 0) {
            $table->addCell(3000)->addText('Single Room');
        }
        if ($double_rooms_global > 0) {
            $table->addCell(3000)->addText('Double Room');
        }
        if ($triple_rooms_global > 0) {
            $table->addCell(3000)->addText('Triple Room');
        }
        if ($child_with_bed_global > 0) {
            $table->addCell(3000)->addText('Child with Bed');
        }
        if ($child_no_bed_global > 0) {
            $table->addCell(3000)->addText('Child No Bed');
        }
        if ($infants_global > 0) {
            $table->addCell(3000)->addText('Infant');
        }
        
        // <td>
        $table->addRow();
        $table->addCell(3000)->addText('Based on ' . $no_pax . ' Adults travelling passengers');

        if ($single_rooms_global == 0 && $double_rooms_global == 0 && $triple_rooms_global == 0) {
            $table->addCell(3000)->addText('$' . $single_room);
        }
        if ($single_rooms_global > 0) {
            $table->addCell(3000)->addText('$' . $single_room);
        }
        if ($double_rooms_global > 0) {
            $table->addCell(3000)->addText('$' . $double_room);
        }
        if ($triple_rooms_global > 0) {
            $table->addCell(3000)->addText('$' . $triple_room);
        }
        if ($child_with_bed_global > 0) {
            $table->addCell(3000)->addText('$' . $child_with_bed);
        }
        if ($child_no_bed_global > 0) {
            $table->addCell(3000)->addText('$' . $child_no_bed);
        }
        if ($infants_global > 0) {
            $table->addCell(3000)->addText('$' . $infant);
        }

        $section->addText('*All Costs are in '.$currency, ['bold' => true]);
    }

    $section->addTextBreak(1);
    $section->addText('Note - The rooms are subject to availability and the rates might change at the time of confirmation.', array('bold' => true));
    
    // Add exclusions section at the end of the document
    $section->addTextBreak(1);
    $section->addText('Exclusions:', array('bold' => true));
    $exclusions = [];
    if($country == 'Australia') {
        $exclusions = [
            '• International and Domestic Air tickets',
            '• Australia Visa.',
            '• Travel Insurance.',
            '• Meals, Laundry, telephone, optional excursions, and other items of a personal nature.',
            '• Cost of foreign exchange for personal use.',
            '• Any items or services not mentioned in the itinerary section.',
            '• Portage Charges in Hotel/Airport/During Tours.',
            '• Remittance 35 AUD or CC Charges of 2% applicable on the total billing.'
        ];
    }
    else if($country == 'New Zealand') {
        $exclusions = [
            '• International and Domestic Air tickets.',
            '• New Zealand Visa.',
            '• Travel Insurance.',
            '• Meals, Laundry, telephone, optional excursions, and other items of a personal nature.',
            '• Cost of foreign exchange for personal use.',
            '• Any items or services not mentioned in the itinerary section.',
            '• Portage Charges in Hotel/Airport/During Tours.',
            '• Remittance 35 NZD or CC Charges of 2-5% applicable on the total billing.'
        ];
    }
    
    foreach ($exclusions as $exclusion) {
        $section->addText($exclusion);
    }
    
    // Add terms and conditions section
    $section->addTextBreak(1);
    $section->addText('Terms and Conditions:', array('bold' => true));
    $terms = [];

    if($country == 'Australia') {
        $terms = [
            '1. Normal Hotel Check-In Time is 14:00hrs and Check-Out Time is between 10:00-11:00hrs',
            '2. All prices are NETT and non-commissionable in Australian dollars, including GST.',
            '3. This Quote Is NOT Valid in case there is a Change of Routing / Dates / Hotels / Room Categories / Pax Number, etc.',
            '4. Confirmation of all quote services and Hotels is Strictly Subject to Availability at the Rates and STANDARD Room Category Quoted',
            '5. Full payment of this booking is required 7 days prior to travel or earlier depending on cancellation terms and conditions of each supplier or service.',
            '6. Payments by Visa or Master card incur a 3% transaction fee.',
            '7. Once the booking has been confirmed, one amendment by the client is free of charge.',
            '8. Bookings cancelled within 7 days to 48 hours of arrival incur a 100% cancellation fee.',
            '9. Certain sightseeing and day tours may be subject to weather conditions or minimum number of Pax’s before they operate, and suppliers may cancel or postpone the date of the tour at short notice. Any changes shall be notified to you at the earliest opportunity.',
            '10. Any services purchased by the traveller while on tour is non-commissionable to the travel agent.',
            '11. There is no refund for services not utilized. Extra note for private transfers services: waiting time for more than 15 minutes will incur an additional hour charge.',
            '12. Prepayment is required one week in advance before the group\'s arrival in Australia.',
            '13. A security deposit is required either in cash or credit card by hotels, which is refundable provided no room incidentals are incurred. This security deposit is not included in this quote and must be paid directly by the guest to the hotel when checking in.',
            '14. It is the responsibility of the booking agent to verify if all his requests are quoted for. If any are missing, request for the same.',
            '15. We are not responsible for any loss or damage to person or property in any manner whatsoever in connection with any travel the subject of this booking, and the customer specifically and unconditionally releases us from all claims in connection with or arising out of that travel. It is the express responsibility of the customer to obtain all travel insurances required in connection with their travel.',
            '16. If we are found liable for any loss to the customer whatsoever, our liability for that loss shall be limited to a refund of any fees paid to us by or on behalf of the customer in connection with the booking the subject of the loss, or provision of the services again (to be elected at our discretion).',
            '17. These terms are governed by the laws of the State of Victoria, and the parties all submit to the non-exclusive jurisdiction of that State.'
        ];
    } else if($country == 'New Zealand') {
        $terms = [
            '1. Normal Hotel Check-In Time is 14:00hrs and Check-Out Time is between 10:00-11:00hrs',
            '2. All prices are NETT and non-commissionable in New Zealand dollars, including GST.',
            '3. This Quote Is NOT Valid in case there is a Change of Routing / Dates / Hotels / Room Categories / Pax Number, etc.',
            '4. Confirmation of all quote services and Hotels is Strictly Subject to Availability at the Rates and STANDARD Room Category Quoted',
            '5. Full payment of this booking is required 7 days prior to travel or earlier depending on cancellation terms and conditions of each supplier or service.',
            '6. Payments by Visa or Master card incur a 3% transaction fee.',
            '7. Once the booking has been confirmed, one amendment by the client is free of charge.',
            '8. Bookings cancelled within 7 days to 48 hours of arrival incur a 100% cancellation fee.',
            '9. Certain sightseeing and day tours may be subject to weather conditions or minimum number of Pax’s before they operate, and suppliers may cancel or postpone the date of the tour at short notice. Any changes shall be notified to you at the earliest opportunity.',
            '10. Any services purchased by the traveller while on tour is non-commissionable to the travel agent.',
            '11. There is no refund for services not utilized. Extra note for private transfers services: waiting time for more than 15 minutes will incur an additional hour charge.',
            '12. Prepayment is required one week in advance before the group\'s arrival in New Zealand.',
            '13. A security deposit is required either in cash or credit card by hotels, which is refundable provided no room incidentals are incurred. This security deposit is not included in this quote and must be paid directly by the guest to the hotel when checking in.',
            '14. It is the responsibility of the booking agent to verify if all his requests are quoted for. If any are missing, request for the same.',
            '15. We are not responsible for any loss or damage to person or property in any manner whatsoever in connection with any travel the subject of this booking, and the customer specifically and unconditionally releases us from all claims in connection with or arising out of that travel. It is the express responsibility of the customer to obtain all travel insurances required in connection with their travel.',
            '16. If we are found liable for any loss to the customer whatsoever, our liability for that loss shall be limited to a refund of any fees paid to us by or on behalf of the customer in connection with the booking the subject of the loss, or provision of the services again (to be elected at our discretion).',
            '17. These terms are governed by the laws of the State of Victoria, and the parties all submit to the non-exclusive jurisdiction of that State.'
        ];
    }

    foreach ($terms as $term) {
        $section->addText($term);
    }
    
    $timestamp = date('YmdHis');
    $fileName = 'QUOTE-' . $quote_number . '-' . $timestamp . '.docx';

    $insert_sql = "INSERT INTO vtiger_invoice (quoteid, filepath, type, created_by) VALUES ('$quoteid', '$fileName', 'quote', '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
    header('Content-Disposition: attachment;filename="' . $fileName . '"');
    header('Cache-Control: max-age=0');

    $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
    $objWriter->save('php://output');
    exit;
}

// update operation data
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quoteid']) 
    && ((isset($_POST['itinerary']) && $_POST['itinerary'] != 'download') || isset($_POST['itinerary-add-transfer']) || isset($_POST['itinerary-del-transfer']))) {
    $quoteid = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];
    $operation_type = $_POST['operation_type'];

    $sql = "SELECT vqcf.cf_1162
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            WHERE vq.quoteid = '$quoteid'
            LIMIT 1;";
    $result = mysqli_query($conn, $sql);
    if(mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $travel_date = $row['cf_1162'];
    }
    
    foreach ($_POST['comment'] as $sequence_no => $comment) {
        if ($operation_type != 'Transfer') {
            $comment = mysqli_real_escape_string($conn, $comment);
            $sql = "UPDATE vtiger_inventoryproductrel SET comment='$comment' WHERE id='$quoteid' AND sequence_no='$sequence_no';";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }
        
        if ($operation_type == 'Hotel') {
            $div = 'div-hotel';

            $sql_update = "UPDATE vtiger_products_saleprice SET ";
            $update_parts = []; // Array to hold the parts of the SET clause

            // Check each value and add to the query if it's set
            if (isset($_POST['single_room_price'][$sequence_no]) && $_POST['single_room_price'][$sequence_no] !== '') {
                $single_room_price = (float) $_POST['single_room_price'][$sequence_no];
                $update_parts[] = "sale_price_single = '$single_room_price'";
            }

            if (isset($_POST['double_room_price'][$sequence_no]) && $_POST['double_room_price'][$sequence_no] !== '') {
                $double_room_price = (float) $_POST['double_room_price'][$sequence_no];
                $update_parts[] = "sale_price_double = '$double_room_price'";
            }

            if (isset($_POST['triple_room_price'][$sequence_no]) && $_POST['triple_room_price'][$sequence_no] !== '') {
                $triple_room_price = (float) $_POST['triple_room_price'][$sequence_no];
                $update_parts[] = "sale_price_triple = '$triple_room_price'";
            }

            if (isset($_POST['child_with_bed_price'][$sequence_no]) && $_POST['child_with_bed_price'][$sequence_no] !== '') {
                $child_with_bed_price = (float) $_POST['child_with_bed_price'][$sequence_no];
                $update_parts[] = "sale_price_child_with_bed = '$child_with_bed_price'";
            }

            if (isset($_POST['child_no_bed_price'][$sequence_no]) && $_POST['child_no_bed_price'][$sequence_no] !== '') {
                $child_no_bed_price = (float) $_POST['child_no_bed_price'][$sequence_no];
                $update_parts[] = "sale_price_child_no_bed = '$child_no_bed_price'";
            }

            if (!empty($_POST['check_in'][$sequence_no]) && !empty($_POST['check_out'][$sequence_no])) {
                $check_in = $_POST['check_in'][$sequence_no];
                $check_out = $_POST['check_out'][$sequence_no];
            
                // Convert to DateTime objects
                $date_in = new DateTime($check_in);
                $date_out = new DateTime($check_out);
            
                // Ensure check-out is after check-in
                if ($date_out > $date_in) {
                    $interval = $date_in->diff($date_out);
                    $num_nights = $interval->days; // Get the number of nights
                    $update_parts[] = "nights = '$num_nights'";
                }
            }

            // Retrieve existing values
            $existing_query = "SELECT sale_price_single, sale_price_double, sale_price_triple, sale_price_child_with_bed, sale_price_child_no_bed FROM vtiger_products_saleprice 
                                WHERE quoteid='$quoteid' AND sequence_no='$sequence_no'";
            $existing_result = mysqli_query($conn, $existing_query);
            $existing_row = mysqli_fetch_assoc($existing_result);

            $changes = [];
            if ($existing_row) {
                if (isset($_POST['single_room_price'][$sequence_no]) && $_POST['single_room_price'][$sequence_no] !== '' && bccomp($existing_row['sale_price_single'], $single_room_price, 2) !== 0) {
                    $changes[] = "Single Room Price: $".number_format($existing_row['sale_price_single'], 2)." -> $".number_format($single_room_price, 2);
                }
                if (isset($_POST['double_room_price'][$sequence_no]) && $_POST['double_room_price'][$sequence_no] !== '' && bccomp($existing_row['sale_price_double'], $double_room_price, 2) !== 0) {
                    $changes[] = "Double Room Price: $".number_format($existing_row['sale_price_double'], 2)." -> $".number_format($double_room_price, 2);
                }
                if (isset($_POST['triple_room_price'][$sequence_no]) && $_POST['triple_room_price'][$sequence_no] !== '' && bccomp($existing_row['sale_price_triple'], $triple_room_price, 2) !== 0) {
                    $changes[] = "Triple Room Price: $".number_format($existing_row['sale_price_triple'], 2)." -> $".number_format($triple_room_price, 2);
                }
                if (isset($_POST['child_with_bed_price'][$sequence_no]) && $_POST['child_with_bed_price'][$sequence_no] !== '' && bccomp($existing_row['sale_price_child_with_bed'], $child_with_bed_price, 2) !== 0) {
                    $changes[] = "Child with Bed Price: $".number_format($existing_row['sale_price_child_with_bed'], 2)." -> $".number_format($child_with_bed_price, 2);
                }
                if (isset($_POST['child_no_bed_price'][$sequence_no]) && $_POST['child_no_bed_price'][$sequence_no] !== '' && bccomp($existing_row['sale_price_child_no_bed'], $child_no_bed_price, 2) !== 0) {
                    $changes[] = "Child No Bed Price: $".number_format($existing_row['sale_price_child_no_bed'], 2)." -> $".number_format($child_no_bed_price, 2);
                }
            }
            if (!empty($changes)) {
                $hotel_data3 = getHotelName($conn, $quoteid, $sequence_no);
                $hotel_name3 = $hotel_data3['productName'];

                $log_details = $hotel_name3 . " Price change: " . implode(', ', $changes);
                $session_user_name = $_SESSION['user_name'];
                $log_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                            VALUES ('$quoteid', '$session_user_name', '$log_details', NOW())";
                
                mysqli_query($conn, $log_sql) or die(mysqli_error($conn));
            }

            if (!empty($update_parts)) {
                $sql_update .= implode(", ", $update_parts); // Join the parts with commas
                $sql_update .= " WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'";
            
                // Execute the query
                $result_update = mysqli_query($conn, $sql_update);
            }

            $hotel_data = [
                'confirmation_number' => $_POST['hotel_confirmation'][$sequence_no],
                'single_rooms' => $_POST['single_rooms'][$sequence_no],
                'double_rooms' => $_POST['double_rooms'][$sequence_no],
                'triple_rooms' => $_POST['triple_rooms'][$sequence_no],
                'child_without_bed' => $_POST['child_without_bed'][$sequence_no],
                'check_in' => $_POST['check_in'][$sequence_no],
                'check_out' => $_POST['check_out'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($hotel_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }

            if($_POST['check_in'][$sequence_no] != '' && $_POST['check_out'][$sequence_no] != '') {
                $hotel_data2 = getHotelName($conn, $quoteid, $sequence_no);
                $hotel_name = $hotel_data2['productName'];
                $hotel_city = $hotel_data2['city'];
                if($hotel_name != '' && $hotel_city != '') {
                    processTransfersItineraryFromHotel($conn, $quoteid, $_POST['check_in'][$sequence_no], $_POST['check_out'][$sequence_no], $hotel_name, $hotel_city);
                }
            }

            $invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'initial'";
            $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
            $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
            $created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;
            if($created_at_query) {
                $created_at_query = " AND created_at < '$created_at_query' ";
            }
            else { 
                $created_at_query = "";
            }

            $sql_pax_no = "SELECT meta_key, meta_value 
                            FROM vtiger_itinerary 
                            WHERE quoteid = '$quoteid' 
                            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms')
                            AND (meta_key, created_at) IN (
                                SELECT meta_key, MAX(created_at)
                                FROM vtiger_itinerary
                                WHERE quoteid = '$quoteid' $created_at_query
                                AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms')
                                GROUP BY meta_key);";
            $result_pax_no = mysqli_query($conn, $sql_pax_no);

            $single_rooms = $double_rooms = $triple_rooms = 0;
            if(mysqli_num_rows($result_pax_no) > 0) {
                while($row_pax_no = mysqli_fetch_assoc($result_pax_no)) {
                    switch($row_pax_no['meta_key']) {
                        case 'single_rooms':
                            $single_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                        case 'double_rooms':
                            $double_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                        case 'triple_rooms':
                            $triple_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                    }
                }
            }

            $pax_no = $single_rooms + $double_rooms*2 + $triple_rooms*3;
            if($pax_no <= 0) {
                $pax_no = 1;
            }
            $sql = "UPDATE vtiger_quotes SET no_pax='$pax_no' WHERE quoteid='$quoteid'";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }
        else if ($operation_type == 'Attraction') {
            $div = 'div-attraction';
            // Capture attraction data
            $attraction_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'confirmation_number' => $_POST['attraction_confirmation'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'attraction_address' => $_POST['attraction_address'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($attraction_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }
        }
        else if ($operation_type == 'Guide') {
            $div = 'div-guide';
            // Capture attraction data
            $attraction_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'confirmation_number' => $_POST['attraction_confirmation'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'attraction_address' => $_POST['attraction_address'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($attraction_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }
        }
        else if ($operation_type == 'SIC') {
            $div = 'div-sic';
            // Capture attraction data
            $attraction_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'confirmation_number' => $_POST['attraction_confirmation'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'attraction_address' => $_POST['attraction_address'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($attraction_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }
        }
        else if ($operation_type == 'Tour') {
            $div = 'div-tour';
            // Capture tour data
            $tour_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'confirmation_number' => $_POST['attraction_confirmation'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'attraction_address' => $_POST['attraction_address'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($tour_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }
        } 
        else if ($operation_type == 'Restaurant') {
            $div = 'div-restaurant';
            // Capture restaurant data
            $restaurant_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'confirmation_number' => $_POST['restaurant_confirmation'][$sequence_no],
                'adults' => $_POST['adults'][$sequence_no],
                'children' => $_POST['children'][$sequence_no],
                'infants' => $_POST['infants'][$sequence_no],
                'tour_manager' => $_POST['tour_manager'][$sequence_no],
                'restaurant_address' => $_POST['restaurant_address'][$sequence_no],
                'cancellation_deadline' => $_POST['cancellation_deadline'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            foreach ($restaurant_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value, created_at FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' 
                                        AND sequence_no = '$sequence_no' 
                                        AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC 
                                        LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];
                    $latest_created_at = $latest_row['created_at'];
        
                    if ($latest_meta_value !== $meta_value) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                        VALUES ('$quoteid', '$sequence_no', '$meta_key', '$meta_value', '$created_by', NOW())";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
            }
        } 
        else if ($operation_type == 'Transfer') {
            $div = 'div-transfer';
            $total_over_10000 = 0;
            $remaining = $sequence_no;
        
            while ($remaining > 10000) {
                $total_over_10000 += 10000;
                $remaining -= 10000;
            }
        
            $tourtime = mysqli_real_escape_string($conn, $_POST['tourtime'][$sequence_no]);
            // Check if the tourtime already exists
            $check_sql = "SELECT 1 FROM vtiger_itinerary WHERE quoteid = '$quoteid' AND sequence_no = '$remaining' AND sub_seq_no = '$total_over_10000' AND meta_key = 'tourtime' AND meta_value = '$tourtime'";
            $check_result = mysqli_query($conn, $check_sql) or die(mysqli_error($conn));
            
            if (mysqli_num_rows($check_result) == 0) {
                $sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_by) VALUES ('$quoteid', '$remaining', '$total_over_10000', 'tourtime', '$tourtime', '$created_by');";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            }
        
            // Capture transfer data
            $transfer_data = [
                'tourtime' => $_POST['tourtime'][$sequence_no],
                'comment' => mysqli_real_escape_string($conn, $_POST['comment'][$sequence_no]),
                'pickup_location' => $_POST['pickup_location'][$sequence_no],
                'dropoff_location' => $_POST['dropoff_location'][$sequence_no],
                'driver_name' => $_POST['driver_name'][$sequence_no],
                'driver_contact' => $_POST['driver_contact'][$sequence_no],
                'transfer_option' => $_POST['transfer_option'][$sequence_no],
                'booking_status' => $_POST['booking_status'][$sequence_no],
            ];
        
            $sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_by) VALUES ";
            $values = [];

            foreach ($transfer_data as $meta_key => $meta_value) {
                $latest_check_sql = "SELECT meta_value FROM vtiger_itinerary 
                                    WHERE quoteid = '$quoteid' 
                                    AND sequence_no = '$remaining' 
                                    AND sub_seq_no = '$total_over_10000' 
                                    AND meta_key = '$meta_key' 
                                    ORDER BY created_at DESC 
                                    LIMIT 1";
                
                $latest_check_result = mysqli_query($conn, $latest_check_sql) or die(mysqli_error($conn));
                
                if (mysqli_num_rows($latest_check_result) == 0 && $meta_value != '') {
                    $values[] = "('$quoteid', '$remaining', '$total_over_10000', '$meta_key', '$meta_value', '$created_by')";
                } else {
                    $latest_row = mysqli_fetch_assoc($latest_check_result);
                    $latest_meta_value = $latest_row['meta_value'];

                    if ($latest_meta_value !== $meta_value) {
                        $values[] = "('$quoteid', '$remaining', '$total_over_10000', '$meta_key', '$meta_value', '$created_by')";
                    }
                }
            }

            if (!empty($values)) {
                $sql .= implode(", ", $values);
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            }
        }

        if(isset($_POST['booking_status'][$sequence_no]) && $_POST['booking_status'][$sequence_no] != '') {
            $sql_booking_status = "UPDATE vtiger_inventoryproductrel SET booking_status = '". mysqli_real_escape_string($conn, $_POST['booking_status'][$sequence_no]). "' WHERE id = '$quoteid' AND sequence_no = '$sequence_no';";
            mysqli_query($conn, $sql_booking_status);
        }

        if($operation_type != 'Transfer' && isset($travel_date) && $_POST['booking_status'][$sequence_no] == 'Confirmation received' && $_POST['cancellation_deadline'][$sequence_no] == '') {
            $sql_cancel = "SELECT vi.day, tv.cancelHoursGroup, tv.cancelHoursFIT FROM vtiger_inventoryproductrel vi
                            LEFT JOIN tdu_products tp ON vi.productid=tp.productid
                            LEFT JOIN tdu_vendors tv ON tp.vendorid=tv.vendorid
                            WHERE vi.id = '$quoteid' AND sequence_no = '$sequence_no';";
            $cancel_result = mysqli_query($conn, $sql_cancel);
            if(mysqli_num_rows($cancel_result) > 0) {
                $row = mysqli_fetch_assoc($cancel_result);
                $day = (int) $row['day'] - 1;
                if(substr($quote_number, -1) === 'G') {
                    $cancelHours = $row['cancelHoursGroup'];
                } else {
                    $cancelHours = $row['cancelHoursFIT'];
                }

                if($cancelHours != '') {
                    $cancelDays = floor($cancelHours / 24);
                    $new_date = date('Y-m-d', strtotime($travel_date . " + $day days"));
                    $cancellation_deadline_auto = date('Y-m-d', strtotime($new_date . " - $cancelDays days"));

                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_by, created_at) 
                                    VALUES ('$quoteid', '$sequence_no', 'cancellation_deadline', '$cancellation_deadline_auto', 'SYSTEM', NOW())";
                    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                }
            }
        }
    }
    if(isset($_POST['itinerary-add-transfer']) && $_POST['itinerary-add-transfer'] != '') {
        $sequence_no = $_POST['itinerary-add-transfer'];

        $checkQuery = "SELECT COUNT(*) AS count FROM vtiger_transfer_index WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'";
        $result = mysqli_query($conn, $checkQuery);
        $row = mysqli_fetch_assoc($result);
        $count = $row['count'];

        // Insert based on the count
        if ($count > 0) {
            $insertQuery = "INSERT INTO vtiger_transfer_index (quoteid, sequence_no) VALUES ('$quoteid', '$sequence_no')";
            mysqli_query($conn, $insertQuery);
        } else {
            $insertQuery = "INSERT INTO vtiger_transfer_index (quoteid, sequence_no) VALUES ('$quoteid', '$sequence_no')";
            mysqli_query($conn, $insertQuery);
            mysqli_query($conn, $insertQuery);
        }

        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=div-transfer");
        exit();
    }

    else if(isset($_POST['itinerary-del-transfer']) && $_POST['itinerary-del-transfer'] != '') {

        $sequence_no = $_POST['itinerary-del-transfer'];
        $total_over_10000 = 0;
        $remaining = $sequence_no;
        while ($remaining > 10000) {
            $total_over_10000 += 10000;
            $remaining -= 10000;
        }

        $deleteQuery = "DELETE FROM vtiger_itinerary WHERE quoteid = '$quoteid' AND sequence_no='$remaining' AND sub_seq_no='$total_over_10000';";
        mysqli_query($conn, $deleteQuery) or die("Error deleting record: " . mysqli_error($conn));

        $updateQuery = "UPDATE vtiger_itinerary 
                        SET sub_seq_no = sub_seq_no - 10000 
                        WHERE quoteid = '$quoteid' AND sequence_no='$remaining' AND sub_seq_no > '$total_over_10000'
                        ORDER BY sub_seq_no DESC;";
        mysqli_query($conn, $updateQuery) or die("Error updating records: " . mysqli_error($conn));


        $maxIdQuery = "SELECT MAX(auto_id) AS max_auto_id FROM vtiger_transfer_index WHERE quoteid = '$quoteid' AND sequence_no = '$remaining'";
        $maxIdResult = mysqli_query($conn, $maxIdQuery);
        $maxIdRow = mysqli_fetch_assoc($maxIdResult);
        $max_auto_id = $maxIdRow['max_auto_id'];

        if ($max_auto_id !== null) {
            $deleteQuery = "DELETE FROM vtiger_transfer_index WHERE auto_id = $max_auto_id";
            mysqli_query($conn, $deleteQuery) or die("Error deleting record: " . mysqli_error($conn));
        }

        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=div-transfer");
        exit();
    }

    $conn->close();
    header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=$div");
    exit();
}

// generate sales order
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quoteid']) && isset($_POST['so'])) {
    $quoteid = $_POST['quoteid'];

    $vendor_transfers_days_array = [];
    if(isset($_POST['vendor_transfers_days']) && $_POST['vendor_transfers_days'] != '') {
        $vendor_transfers_days_string = $_POST['vendor_transfers_days'];
        $vendor_transfers_days_array = explode(',', $vendor_transfers_days_string);
    }

    $sql = "SELECT auto_id, day, tour_time, event_name FROM vtiger_itinerary_new_event
            WHERE quoteid='$quoteid'
            ORDER BY day ASC, tour_time ASC;";
    $result = mysqli_query($conn, $sql);
    $eventsArray = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $day = $row['day'];
        if (!isset($eventsArray[$day])) {
            $eventsArray[$day] = [];
        }
        $eventsArray[$day][] = [
            'auto_id' => $row['auto_id'],
            'tour_time' => $row['tour_time'],
            'event_name' => $row['event_name']
        ];
    }
    
    $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid' LIMIT 1;";
    $result = mysqli_query($conn, $sql);
    
    $date_of_travel = null;
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        if (isset($row['cf_1162']) && !empty($row['cf_1162'])) {
            $date_of_travel = $row['cf_1162'];
        }
    }
    
    $sql = "SELECT vp.productname, vp.description, vi.sequence_no, vdo.display_order AS display_order, vi.day, vi.comment, vi.cf_928, vi.tourtime, tv.address, tv.locationPhone
            FROM vtiger_inventoryproductrel vi
            LEFT JOIN vtiger_display_order vdo ON vi.id=vdo.id AND vi.sequence_no=vdo.sequence_no
            LEFT JOIN (
                SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description FROM vtiger_products_custom
                UNION ALL
                SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description FROM tdu_products
            ) vp ON vi.productid = vp.productid
            LEFT JOIN tdu_vendors tv ON vi.vendorid=tv.vendorid
            WHERE vi.id='$quoteid' AND vi.show_in_so = 1

            UNION ALL

            SELECT 
                product_field AS productname, 
                '' AS description, 
                (1000+auto_id) AS sequence_no, 
                (1000+auto_id) AS display_order, 
                day_field AS day, 
                remark AS comment, 
                cf_928,
                '' AS tourtime,
                '' AS address,
                '' AS locationPhone
            FROM vtiger_invoice_add_products
            WHERE quoteid='$quoteid'

            ORDER BY 
                day ASC,
                CASE 
                    WHEN tourtime IS NULL OR tourtime = '' THEN 1
                    ELSE 0
                END ASC,
                tourtime ASC,
                display_order ASC, 
                sequence_no ASC;";
    $result = mysqli_query($conn, $sql);

    $hotels = [];
    $others = [];
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['cf_928'] === 'Hotel') {
            $sequence_no = $row['sequence_no'];
        
            // List of keys to retrieve
            $meta_keys = [
                'check_in',
                'check_out',
                'confirmation_number',
                'single_rooms',
                'double_rooms',
                'triple_rooms'
            ];
        
            // Convert to comma-separated quoted values for SQL
            $keys_in = "'" . implode("','", $meta_keys) . "'";
        
            $sql_meta = "SELECT meta_key, meta_value FROM vtiger_itinerary 
                         WHERE quoteid='$quoteid' 
                         AND sequence_no='$sequence_no' 
                         AND meta_key IN ($keys_in)
                         ORDER BY created_at DESC;";
        
            $result_meta = mysqli_query($conn, $sql_meta);
        
            // Initialize values
            $meta_data = [];
        
            if ($result_meta && mysqli_num_rows($result_meta) > 0) {
                while ($meta_row = mysqli_fetch_assoc($result_meta)) {
                    // Only assign if not already set (first/latest entry)
                    if (!isset($meta_data[$meta_row['meta_key']])) {
                        $meta_data[$meta_row['meta_key']] = $meta_row['meta_value'];
                    }
                }
            }
        
            // Merge into original row
            $row = array_merge($row, $meta_data);
        
            $hotels[] = $row;
        } else {
            $others[] = $row;
        }
    }
    if($hotels == []) {
        $sql_self_booked_hotels = "SELECT auto_id, hotel_name AS productname, city, checkin_date AS check_in, checkout_date AS check_out 
                                    FROM tdu_self_booked_hotels WHERE quoteid = '$quoteid'";
        $result_self_booked_hotels = mysqli_query($conn, $sql_self_booked_hotels);
        while ($row = mysqli_fetch_assoc($result_self_booked_hotels)) {
            $row['productname'] .= ' (Self-Booked)';
            $hotels[] = $row;
        }
    }
    
    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    $phpWord->addTitleStyle(1, ['size' => 12, 'bold' => true], ['alignment' => 'left']);

    $imagePath = 'images/ES_TDU.png';
    $section = null;
    $currentDay = null;
    
    $sequenceCount = [];
    $usedEvents = [];
    foreach ($others as $row) {
        if (!empty($vendor_transfers_days_array) && !in_array($row['day'], $vendor_transfers_days_array)) {
            continue;
        }
        if ($currentDay !== $row['day']) {
            if ($table && !empty($currentDay) && isset($eventsArray[$currentDay])) {
                foreach ($eventsArray[$currentDay] as $event) {
                    if (!in_array($event['auto_id'], $usedEvents)) {
                        $table->addRow();
                        if($event['tour_time'] == '') {
                            $table->addCell(2800)->addText('');
                        }
                        else {
                            $table->addCell(2800)->addText(convertTo12Hour($event['tour_time']));
                        }
                        $textRun = $table->addCell(20000)->addTextRun();
                        $event_name = $event['event_name'] ?? '';
                        $event_name = str_replace('&', 'and', $event_name);
                        $textRun->addText($event_name, array('bold' => true));
    
                        $usedEvents[] = $event['auto_id']; // Mark event as used
                    }
                }
            }

            if ($section) {
                foreach ($hotels as $hotel) {
                    $check_date = date('Y-m-d', strtotime($date_of_travel . ' + ' . ($row['day'] - 2) . ' days'));
        
                    if ($check_date >= $hotel['check_in'] && $check_date <= date('Y-m-d', strtotime($hotel['check_out'] . ' -1 day'))) {
                        $table = $section->addTable([
                            'borderSize' => 6,
                            'borderColor' => '000000',
                            'cellMargin' => 50,
                        ]);
                        $table->addRow();
                        $table->addCell(2800)->addText('Stay At');
                        $cell = $table->addCell(20000);
                        $textRun = $cell->addTextRun();
                    
                        // Product name
                        $itemName = $hotel['productname'] ?? '';
                        $itemName = str_replace('&', 'and', $itemName);
                        $textRun->addText($itemName, ['bold' => true]);
                    
                        // Confirmation Number
                        if (!empty($hotel['confirmation_number'])) {
                            $textRun->addTextBreak();
                            $textRun->addText("Confirmation Number: {$hotel['confirmation_number']}");
                        }
                    
                        // Room Details
                        $roomDetails = [];
                        if (!empty($hotel['single_rooms']) && (int)$hotel['single_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['single_rooms']} Single Room";
                        }
                        if (!empty($hotel['double_rooms']) && (int)$hotel['double_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['double_rooms']} Double Room";
                        }
                        if (!empty($hotel['triple_rooms']) && (int)$hotel['triple_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['triple_rooms']} Triple Room";
                        }
                    
                        if (!empty($roomDetails)) {
                            $textRun->addTextBreak();
                            $textRun->addText(implode(', ', $roomDetails));
                        }

                        // Address and Phone
                        if (!empty($hotel['address'])) {
                            $address = str_replace('&', 'and', $hotel['address']);
                            $addressLines = preg_split('/\r\n|\r|\n/', $address);
                            foreach ($addressLines as $line) {
                                $textRun->addTextBreak();
                                $textRun->addText($line);
                            }
                        }
                        if (!empty($hotel['locationPhone'])) {
                            $locationPhone = str_replace('&', 'and', $hotel['locationPhone']);
                            $locationPhoneLines = preg_split('/\r\n|\r|\n/', $locationPhone);
                            foreach ($locationPhoneLines as $line) {
                                $textRun->addTextBreak();
                                $textRun->addText($line);
                            }
                        }
                    }                    
                }
            }
            
            $currentDay = $row['day'];
            $section = $phpWord->addSection();
            $section->addImage($imagePath, [
                'width' => 150,
                'height' => 75,
                'align' => 'left'
            ]);
            $section->addTextBreak();

            if (isset($date_of_travel) && $date_of_travel != '') {
                $date = ' - ' . date('d F Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
            } else {
                $date = '';
            }
            $section->addTitle("Day ".$currentDay.$date, 1);
            $section->addTextBreak();
        }

        $sequence_no = $row['sequence_no'];
        if (!isset($sequenceCount[$sequence_no])) {
            $sequenceCount[$sequence_no] = 0; // First time
        }
        // Increment the count for this sequence number
        $sequenceCount[$sequence_no]++;
        // Calculate the new value based on how many times it has been seen
        $sub_seq_no = ($sequenceCount[$sequence_no] - 1) * 10000;
        $remaining = $sequence_no;
        $sequence_no += $sub_seq_no;

        $sqlMeta = "
            SELECT t1.meta_key, t1.meta_value
            FROM vtiger_itinerary AS t1
            INNER JOIN (
                SELECT meta_key, MAX(created_at) AS max_created_at
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid'
                AND sequence_no = '$remaining'
                AND (sub_seq_no = '$sub_seq_no' OR sub_seq_no IS NULL)
                GROUP BY meta_key
            ) AS t2
            ON t1.meta_key = t2.meta_key 
            AND t1.created_at = t2.max_created_at
            WHERE t1.quoteid = '$quoteid'
            AND t1.sequence_no = '$remaining'
            AND (t1.sub_seq_no = '$sub_seq_no' OR t1.sub_seq_no IS NULL)
            GROUP BY t1.meta_key;
        ";
        $resultMeta = mysqli_query($conn, $sqlMeta);
        
        $adults = $children = $infants = $tour_manager = null;
        $otherMeta = [];  // To hold other meta data
        $adults = $children = $infants = $tour_manager = $tourtime = '';
        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
            $metaKey = $metaRow['meta_key'];
            $metaValue = $metaRow['meta_value'];
        
            if ($metaKey === 'adults') {
                $adults = $metaValue;
            } elseif ($metaKey === 'children') {
                $children = $metaValue;
            } elseif ($metaKey === 'infants') {
                $infants = $metaValue;
            } elseif ($metaKey === 'tour_manager') {
                $tour_manager = $metaValue;
            } elseif ($metaKey === 'tourtime') {
                $tourtime = $metaValue;
            } else {
                $otherMeta[$metaKey] = $metaValue;
            }
        }
        
        // Display the "Number of Adults", "Children", "Infants", and "Tour Manager" in a single line if any are set
        $fieldsToShow = [];
        // if (!empty($adults)) {
        //     $fieldsToShow[] = "Adults: $adults";
        // }
        // if (!empty($children)) {
        //     $fieldsToShow[] = "Children: $children";
        // }
        // if (!empty($infants)) {
        //     $fieldsToShow[] = "Infants: $infants";
        // }
        // if (!empty($tour_manager)) {
        //     $fieldsToShow[] = "Tour Manager: $tour_manager";
        // }
        
        if($section == null) {
            $section = $phpWord->addSection();
        }
        $table = $section->addTable([
            'borderSize' => 6,
            'borderColor' => '000000',
            'cellMargin' => 50,
        ]);

        if (!empty($currentDay) && isset($eventsArray[$currentDay])) {
            foreach ($eventsArray[$currentDay] as $event) {
                if (!in_array($event['auto_id'], $usedEvents) && (empty($tourtime) || $event['tour_time'] < $tourtime)) {
                    $table->addRow();
                    if($event['tour_time'] == '') {
                        $table->addCell(2800)->addText('');
                    }
                    else {
                        $table->addCell(2800)->addText(convertTo12Hour($event['tour_time']));
                    }
                    $textRun = $table->addCell(20000)->addTextRun();
                    $event_name = $event['event_name'] ?? '';
                    $event_name = str_replace('&', 'and', $event_name);
                    $textRun->addText($event_name, array('bold' => true));

                    $usedEvents[] = $event['auto_id']; // Mark event as used
                }
            }
        }
        
        $table->addRow();
        if($row['cf_928'] == 'Hotel') {
            $table->addCell(2800)->addText('');
        }
        else if($tourtime == '') {
            $table->addCell(2800)->addText('');
        }
        else {
            $table->addCell(2800)->addText(convertTo12Hour($tourtime));
        }
        
        
        $textRun = $table->addCell(20000)->addTextRun();
        
        $itemName = $row['productname'] ?? '';
        $itemName = str_replace('&', 'and', $itemName);
        $textRun->addText($itemName, array('bold' => true));

        $comment = str_replace('&', 'and', $row['comment']);
        $commentLines = preg_split('/\r\n|\r|\n/', $comment);
        foreach ($commentLines as $line) {
            $textRun->addTextBreak();
            $textRun->addText($line);
        }

        $description = str_replace('&', 'and', $row['description']);
        $descriptionLines = preg_split('/\r\n|\r|\n/', $description);
        foreach ($descriptionLines as $line) {
            $textRun->addTextBreak();
            $textRun->addText($line);
        }

        if (isset($otherMeta['transfer_option'])) {
            $comment = str_replace('&', 'and', $otherMeta['comment']);
            $commentLines = preg_split('/\r\n|\r|\n/', $comment);
            foreach ($commentLines as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }

            if ($otherMeta['transfer_option'] == 'a') {
                unset($otherMeta['pickup_location']);
                unset($otherMeta['dropoff_location']);
            } elseif ($otherMeta['transfer_option'] == 'b') {
                unset($otherMeta['hourly_charter']);
                unset($otherMeta['driver_name']);
                unset($otherMeta['driver_contact']);
            } else {
                unset($otherMeta['pickup_location']);
                unset($otherMeta['dropoff_location']);
                unset($otherMeta['hourly_charter']);
                unset($otherMeta['driver_name']);
                unset($otherMeta['driver_contact']);
            }
        } else {
            unset($otherMeta['payment_deadline']);
            unset($otherMeta['cancellation_deadline']);
            unset($otherMeta['booking_status']);
        }
        
        // Display other meta data
        foreach ($otherMeta as $key => $value) {
            if($key == 'transfer_option' || $key == 'booking_status' || $key == 'comment' || $key == 'payment_status' || $value == '' || $value == 0 ) {
                continue;
            }
            $key = str_replace('_', ' ', $key);
            $key = ucwords($key);
            $value = str_replace('&', 'and', $value);
            $textRun->addTextBreak();
            $textRun->addText("$key: $value");
        }
        
        // if (!empty($fieldsToShow)) {
        //     $textRun->addTextBreak();
        //     $textRun->addText('Number of ' . implode(', ', $fieldsToShow));
        // }
        
        // Address and Phone
        if (!empty($row['address']) && $row['cf_928'] != 'Transfers') {
            $address = str_replace('&', 'and', "Address: " . $row['address']);
            $addressLines = preg_split('/\r\n|\r|\n/', $address);
            foreach ($addressLines as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }
        }
        if (!empty($row['locationPhone']) && $row['cf_928'] != 'Transfers') {
            $locationPhone = str_replace('&', 'and', "Phone: " . $row['locationPhone']);
            $locationPhoneLines = preg_split('/\r\n|\r|\n/', $locationPhone);
            foreach ($locationPhoneLines as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }
        }

        $sql_flight_details = "SELECT flight_number, from_city, to_city, from_datetime, to_datetime 
                                FROM tdu_flight_details 
                                WHERE quoteid='$quoteid' AND sequence_no='$sequence_no'";
        $result_flight_details = mysqli_query($conn, $sql_flight_details);

        if ($result_flight_details && mysqli_num_rows($result_flight_details) > 0) {
            $flight = mysqli_fetch_assoc($result_flight_details);

            // Format flight details
            $flightDetails = [
                "Flight Number: " . str_replace('&', 'and', $flight['flight_number']),
                "From: " . str_replace('&', 'and', $flight['from_city']) . 
                " at " . date('d M Y, h:i A', strtotime($flight['from_datetime'])),
                "To: " . str_replace('&', 'and', $flight['to_city']) . 
                " at " . date('d M Y, h:i A', strtotime($flight['to_datetime']))
            ];

            $textRun->addTextBreak();
            foreach ($flightDetails as $line) {
                $textRun->addTextBreak();
                $textRun->addText($line);
            }
        }
    }
    
    // Save the document
    $timestamp = date('YmdHis');
    $fileName = 'ITINERARY-' . $quote_number . '-' . $timestamp . '.docx';

    $insert_sql = "INSERT INTO vtiger_invoice (quoteid, filepath, type, created_by) VALUES ('$quoteid', '$fileName', 'so', '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
    header('Content-Disposition: attachment;filename="' . $fileName . '"');
    header('Cache-Control: max-age=0');
    
    $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
    $objWriter->save("php://output");
    exit();
}

// generate visa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quoteid']) && isset($_POST['visa'])) {
    $quoteid = $_POST['quoteid'];

    $sql = "SELECT quote_no, visa_pax_path FROM vtiger_quotes WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $quote_number = $row['quote_no'];
        $visa_pax_path = $row['visa_pax_path'];
    }

    // Hotel Table
    $sql = "SELECT vp.productname, vp.city, vi.cf_928, vi.sequence_no
            FROM vtiger_inventoryproductrel vi
            LEFT JOIN (
                SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description, '' AS city FROM vtiger_products_custom
                UNION ALL
                SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description, city FROM tdu_products
            ) vp ON vi.productid = vp.productid
            WHERE vi.id='$quoteid' AND vi.cf_928 = 'Hotel';";
    $result = mysqli_query($conn, $sql);
    $hotels = [];
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['cf_928'] === 'Hotel') {
            $sequence_no = $row['sequence_no'];

            $meta_keys = ['check_in', 'check_out', 'confirmation_number'];
            $keys_in = "'" . implode("','", $meta_keys) . "'";
            $sql_meta = "SELECT meta_key, meta_value FROM vtiger_itinerary 
                         WHERE quoteid='$quoteid' 
                         AND sequence_no='$sequence_no' 
                         AND meta_key IN ($keys_in)
                         ORDER BY created_at DESC;";
            $result_meta = mysqli_query($conn, $sql_meta);
        
            $meta_data = [];
            if ($result_meta && mysqli_num_rows($result_meta) > 0) {
                while ($meta_row = mysqli_fetch_assoc($result_meta)) {
                    if (!isset($meta_data[$meta_row['meta_key']])) {
                        $meta_data[$meta_row['meta_key']] = $meta_row['meta_value'];
                    }
                }
            }
            $row = array_merge($row, $meta_data);
            $hotels[] = $row;
        }
    }
    if($hotels == []) {
        $sql_self_booked_hotels = "SELECT auto_id, hotel_name AS productname, city, checkin_date AS check_in, checkout_date AS check_out 
                                    FROM tdu_self_booked_hotels WHERE quoteid = '$quoteid'";
        $result_self_booked_hotels = mysqli_query($conn, $sql_self_booked_hotels);
        while ($row = mysqli_fetch_assoc($result_self_booked_hotels)) {
            $hotels[] = $row;
        }
    }

    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    $section = $phpWord->addSection();

    // Add Header with Image
    $header = $section->addHeader();
    $table = $header->addTable();
    $cell1 = $table->addRow()->addCell(10000);
    $cell1->addImage('images/ES_TDU.png', [
        'width' => 100,
        'height' => 50,
        'alignment' => 'left'
    ]);
    $cell2 = $table->addCell(10000, ['valign' => 'center']);
    $cell2->addText($quote_number, ['bold' => true, 'size' => 18], ['alignment' => 'right']);

    // Add Footer
    $footer = $section->addFooter();
    $footer->addText(
        'Turtle Down Under • Suite 3, Level 6, 60 Albert Road • 3205 South Melbourne • Australia | E: sales@turtledownunder.com.au | P: +61 386409902',
        ['size' => 7],
        ['alignment' => 'center']
    );

    // Date and Letter Header
    $date = date('d M, Y');
    $section->addText($date, ['size' => 11], ['spaceAfter' => 200]);
    $section->addText("To,", ['size' => 11, 'bold' => true]);
    $section->addText("The Visa Officer", ['size' => 11, 'bold' => true]);
    $section->addText("The Australian High", ['size' => 11, 'bold' => true]);
    $section->addText("Commission India", ['size' => 11, 'bold' => true]);
    $section->addTextBreak(1);
    $section->addText("SUBJECT: REQUEST FOR NECESSARY AUSTRALIAN VISA", ['size' => 11, 'bold' => true]);
    $section->addTextBreak(1);
    $section->addText("Dear Sir/Madam", ['size' => 11]);
    $section->addTextBreak(1);
    $section->addText("With this Letter we would like to confirm that Turtle Down Under is handling all land arrangements for the following passenger.", ['size' => 11]);
    $section->addTextBreak(1);

    // Table with Hotel Details
    $section->addText("The Travel details are as follows:", ['size' => 11]);
    $table = $section->addTable([
        'borderSize' => 6,
        'borderColor' => '999999',
        'cellMargin' => 50
    ]);

    $table->addRow();
    $table->addCell(1500)->addText("Sr No", ['bold' => true], ['alignment' => 'center']);
    $table->addCell(2000)->addText("City", ['bold' => true], ['alignment' => 'center']);
    $table->addCell(3000)->addText("Hotel", ['bold' => true], ['alignment' => 'center']);
    $table->addCell(2500)->addText("Confirmation", ['bold' => true], ['alignment' => 'center']);
    $table->addCell(2000)->addText("Check in", ['bold' => true], ['alignment' => 'center']);
    $table->addCell(2000)->addText("Check out", ['bold' => true], ['alignment' => 'center']);

    $hotel_no = 1;
    foreach ($hotels as $hotel) {
        $table->addRow();
        $table->addCell(1500)->addText($hotel_no++, [], ['alignment' => 'center']);
        $table->addCell(2000)->addText($hotel['city'] ?? '', [], ['alignment' => 'center']);
        $table->addCell(3000)->addText($hotel['productname'] ?? '', [], ['alignment' => 'center']);
        $table->addCell(2500)->addText($hotel['confirmation_number'] ?? '', [], ['alignment' => 'center']);
        $table->addCell(2000)->addText($hotel['check_in'] ?? '', [], ['alignment' => 'center']);
        $table->addCell(2000)->addText($hotel['check_out'] ?? '', [], ['alignment' => 'center']);
    }
    $section->addTextBreak(1);

    // Table with Pax Details
    $section->addText("Passenger list as follows:", ['size' => 11]);
    if (!empty($visa_pax_path) && file_exists($visa_pax_path)) {
        if (($handle = fopen($visa_pax_path, "r")) !== false) {
            $passengerTable = $section->addTable([
                'borderSize' => 6,
                'borderColor' => '999999',
                'cellMargin' => 50
            ]);
    
            // Add header row
            $passengerTable->addRow();
            $passengerTable->addCell(500)->addText("S.No", ['bold' => true], ['alignment' => 'center']);
            $passengerTable->addCell(5000)->addText("First Name As Per Passport", ['bold' => true], ['alignment' => 'center']);
            $passengerTable->addCell(5000)->addText("Last Name As Per Passport", ['bold' => true], ['alignment' => 'center']);
            $passengerTable->addCell(5000)->addText("Passport Number", ['bold' => true], ['alignment' => 'center']);
            $passengerTable->addCell(500)->addText("Gender", ['bold' => true], ['alignment' => 'center']);
    
            $no = 1;
            // Skip the header row if CSV has it
            $headerSkipped = false;
    
            while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                if (!$headerSkipped) {
                    $headerSkipped = true;
                    continue;
                }
    
                // Adjust indexes if needed depending on your csv column order
                $firstName = trim($data[0] ?? '');
                $lastName = trim($data[1] ?? '');
                if (empty($firstName) && empty($lastName)) {
                    continue; // Skip empty rows
                }
                $passportNumber = trim($data[2] ?? '');
                $gender = trim($data[3] ?? '');
    
                $passengerTable->addRow();
                $passengerTable->addCell(2000)->addText($no++, [], ['alignment' => 'center']);
                $passengerTable->addCell(5000)->addText($firstName, [], ['alignment' => 'center']);
                $passengerTable->addCell(5000)->addText($lastName, [], ['alignment' => 'center']);
                $passengerTable->addCell(5000)->addText($passportNumber, [], ['alignment' => 'center']);
                $passengerTable->addCell(3000)->addText($gender, [], ['alignment' => 'center']);
            }
    
            fclose($handle);
        } else {
            $section->addText("Error opening passenger list CSV.", ['color' => 'FF0000']);
        }
    }
    $section->addTextBreak(1);

    // signature
    $section->addText(
        'Should you require any further information, concerning this departure, please do not hesitate to contact us.',
        ['size' => 11]
    );
    $section->addImage('images/visa_signature.jpg', ['width' => 60, 'height' => 33, 'alignment' => 'left']);
    $section->addText('Name: Abhishek Sonthalia', ['size' => 10]);
    $section->addText('Designation: Managing Director', ['size' => 10]);
    $section->addText('Turtle Down Under', ['size' => 10]);
    $section->addText('Mobile No.: +61 430442201', ['size' => 10]);
    $section->addText('Email Id: abhisheks@turtledownunder.com.au', ['size' => 10]);
    $section->addTextBreak(1);
    $section->addText(
        'This is an auto-generated document and does not need a signature.',
        ['bold' => true, 'size' => 11] , ['alignment' => 'center']
    );

    // Output Word File
    $timestamp = date('YmdHis');
    $fileName = 'VISA-LETTER-' . $quote_number . '-' . $timestamp . '.docx';
    header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
    header('Content-Disposition: attachment;filename="' . $fileName . '"');
    header('Cache-Control: max-age=0');
    $objWriter = IOFactory::createWriter($phpWord, 'Word2007');
    $objWriter->save("php://output");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quoteid']) && isset($_POST['invoice']) && $_POST['invoice'] == 'initial') {
    $quoteid = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];
    $mode = $_POST['mode'];

    $invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'initial'";
    $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
    $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
    $created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;
    if($created_at_query) {
        $created_at_query = " AND created_at < '$created_at_query' ";
    }
    else { 
        $created_at_query = "";
    }

    // query the room info
    $sql = "SELECT meta_key, meta_value 
            FROM vtiger_itinerary 
            WHERE quoteid = '$quoteid' 
            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
            AND (meta_key, created_at) IN (
                SELECT meta_key, MAX(created_at)
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid' $created_at_query
                AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
                GROUP BY meta_key);";
    $result = mysqli_query($conn, $sql);

    $single_rooms = 0;
    $double_rooms = 0;
    $triple_rooms = 0;
    $child_no_bed = 0;
    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['meta_key']) {
            case 'single_rooms':
                $single_rooms = (int) $row['meta_value'];
                break;
            case 'double_rooms':
                $double_rooms = (int) $row['meta_value'];
                break;
            case 'triple_rooms':
                $triple_rooms = (int) $row['meta_value'];
                break;
            case 'child_without_bed':
                $child_no_bed = (int) $row['meta_value'];
                break;
        }
    }

    // query the quote information
    $sql = "SELECT vq.quoteid, vq.subject, vq.adults, vq.children, vq.infants, va.organization_name AS accountname, va.address, vqcf.cf_1182, vq.country
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
            WHERE vq.quoteid = '$quoteid'
            LIMIT 1;";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        if ($row) {
            $accountName = $row['accountname'];
            $accountName = str_replace('&', 'and', $accountName);
            $address = $row['address'];
            $address = str_replace('&', 'and', $address);
            $subject = $row['subject'];
            $subject = str_replace('&', 'and', $subject);
            $country = $row['country'];
            $currency = 'AUD';
            if($country == 'New Zealand') {
                $currency = 'NZD';
            }

            $adults_no = $row['adults'] ?? 0;
            $children_no = $row['children']?? 0;
            $infants_no = $row['infants']?? 0;
            $no_pax = $row['adults'] + $row['children'];
            $pax_no = $row['adults'] + $row['children'];
            if($no_pax == 0) {
                echo '<script>alert("No of passengers not entered.");</script>';
                exit();
            }
            $payment_deadline = '';
            if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00') {
                $date = new DateTime($row['cf_1182']);
                $payment_deadline = $date->format('d-M-Y');
            }
        }
    }
    $child_with_bed = $children_no - $child_no_bed;

    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    $phpWord->setDefaultParagraphStyle([
        'spaceAfter' => 1,
        'spaceBefore' => 1
    ]);
    $section = $phpWord->addSection();

    $imagePath = 'images/ES_TDU.png';
    $section->addImage($imagePath, ['width' => 100, 'height' => 50, 'align' => 'center']);
    $section->addText('Address: 6/60 Albert Rd, South Melbourne VIC 3205, Australia', [] , ['align' => 'center']);
    $section->addTextBreak(1);
    
    $styleTable = array('borderSize' => 6, 'borderColor' => '999999', 'cellMargin' => 80);
    $phpWord->addTableStyle('Styled Table', $styleTable);
    $table = $section->addTable('Styled Table');
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('Initial Invoice', ['size' => 12], ['align' => 'center']);
    
    // blue break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(10000)->addText('To,', ['bold' => true]);
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    $table->addRow();
    $table->addCell(10000)->addText($accountName ?? '', ['bold' => true]);
    $table->addCell(3500);
    $table->addCell(3000)->addText('Date:', ['bold' => true]);
    $table->addCell(3500)->addText(date('d-M-Y'));

    $table->addRow();
    $table->addCell(10000)->addText($address ?? '');
    $table->addCell(3500);
    $table->addCell(3000)->addText('Ref No:', ['bold' => true]);
    $table->addCell(3500)->addText($quote_number ?? '', ['bold' => true]);

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(10000)->addText($subject ?? '', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText('Cost per unit', ['bold' => true], ['align' => 'center']);
    $table->addCell(3000)->addText('Number of Units', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText('Amount', ['bold' => true], ['align' => 'center']);

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    $quote_pax = -1;
    if($mode == 'group') {
        $mode_sql = '>1';
        $sql_group_sum = "SELECT MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                        FROM vtiger_products_saleprice vps
                        WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                        GROUP BY vps.subquoteid
                        ORDER BY pax_min ASC;";
        $result_group_sum = mysqli_query($conn, $sql_group_sum);

        if (mysqli_num_rows($result_group_sum) > 0) {
            while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
                if ($row_group_sum['pax_min'] <= ($adults_no+$children_no) && ($adults_no+$children_no) <= $row_group_sum['pax_max']) {
                    $quote_pax = $row_group_sum['pax_min'];
                    break;
                }
            }
        }
    }

    $pricing = getQuotePricing($conn, $quoteid, $quote_pax);
    $pricing_single_room = $pricing['single_room'];
    $pricing_double_room = $pricing['double_room'];
    $pricing_triple_room = $pricing['triple_room'];
    $pricing_child_with_bed = $pricing['child_with_bed'];
    $pricing_child_no_bed = $pricing['child_no_bed'];
    $pricing_infant = $pricing['infant'];

    $total_amount = 0;

    if ($single_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Single Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($single_rooms, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room * $single_rooms, [], ['align' => 'right']);
        $total_amount += $pricing_single_room * $single_rooms;
    }
    
    if ($double_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Double Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_double_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($double_rooms * 2, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_double_room * $double_rooms * 2, [], ['align' => 'right']);
        $total_amount += $pricing_double_room * $double_rooms * 2;
    }
    
    if ($triple_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Triple Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_triple_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($triple_rooms * 3 - $child_with_bed, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_triple_room * ($triple_rooms * 3 - $child_with_bed), [], ['align' => 'right']);
        $total_amount += $pricing_triple_room * ($triple_rooms * 3 - $child_with_bed);
    }

    if ($single_rooms == 0 && $double_rooms == 0 && $triple_rooms == 0) {
        if($adults_no > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Adult No Hotel');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room, [], ['align' => 'right']);
            $table->addCell(3000)->addText($adults_no, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room * $adults_no, [], ['align' => 'right']);
            $total_amount += $pricing_single_room * $adults_no;
        }
        if($children_no > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child No Hotel');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($children_no, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed * $children_no, [], ['align' => 'right']);
            $total_amount += $pricing_child_no_bed * $children_no;
        }
    } else {
        if ($child_with_bed > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child with Bed');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_with_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($child_with_bed, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_with_bed * $child_with_bed, [], ['align' => 'right']);
            $total_amount += $pricing_child_with_bed * $child_with_bed;
        }
        
        if ($child_no_bed > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child without Bed');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($child_no_bed, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed * $child_no_bed, [], ['align' => 'right']);
            $total_amount += $pricing_child_no_bed * $child_no_bed;
        }
    }
    if($infants_no > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Infant');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_infant, [], ['align' => 'right']);
        $table->addCell(3000)->addText($infants_no, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_infant * $infants_no, [], ['align' => 'right']);
        $total_amount += $pricing_infant * $infants_no;
    }

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(10000);
    $table->addCell(6500, ['gridSpan' => 2])->addText('Total Amount', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . $total_amount, ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Total', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . $total_amount, ['bold' => true], ['align' => 'right']);

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('less: Received till date', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText('', ['bold' => true], ['align' => 'right']);

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('add: Remitance Charges', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' 30', ['bold' => true], ['align' => 'right']);
    $total_amount += 30;

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Balance Amount', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . ceil($total_amount), ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');
    
    $date = new DateTime();
    $date->modify('+1 day');
    $deadline = $date->format('d-M-Y');
    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Balance to be received by ' . $deadline, ['bold' => true, 'color' => 'FF0000'], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . ceil($total_amount), ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(20000, ['gridSpan' => 4])->addText('Please have the full amount remitted without any further deduction, bank charges or VAT.', ['bold' => true], ['align' => 'left']);

    if($currency == 'NZD') {
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Name and Address of bank', ['bold' => true], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Name: TURTLE DOWN UNDER LIMITED', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Number: 01-0527-0727847-00', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Address:  642 MAUNGATAUTARI ROAD', [], ['align' => 'center']);
    }
    else {
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Name and Address of bank', ['bold' => true], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Bank Name: Commonwealth Bank', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Address: 978-980 Main Rd Eltham VIC 3095', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Name: Turtle Down Under Pty Ltd', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Number: 1090-5957', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('BSB: 063-622', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Swift Code: CTBAAU2S', [], ['align' => 'center']);
    }

    $insert_sql = "INSERT INTO vtiger_payment_history (quoteid, source, total_amount, added_on, added_by) VALUES ('$quoteid', 'initial', '$total_amount', NOW(), '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
    
    $timestamp = date('YmdHis');
    $fileName = 'INITIAL-INVOICE-' . $quote_number . '-' . $timestamp;
    $folderPath = 'invoice/';
    $localFilePath = $folderPath . $fileName;

    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0777, true);
    }
    $insert_sql = "INSERT INTO vtiger_invoice (quoteid, filepath, type, created_by) VALUES ('$quoteid', '$localFilePath', 'initial', '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    // Export as PDF
    $tempHtmlFile = 'temp_invoice' . $timestamp . '.html';
    $phpWord->save($tempHtmlFile, 'HTML');
    $htmlContent = file_get_contents($tempHtmlFile);

    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($htmlContent);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Save PDF temporarily for download
    $pdfOutput = $dompdf->output();
    $pdfFilePath = $localFilePath . '.pdf';
    file_put_contents($pdfFilePath, $pdfOutput);
    unlink($tempHtmlFile);

    // Pass PDF file path to frontend
    header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=doc");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quoteid']) && isset($_POST['invoice']) && $_POST['invoice'] == 'final') {
    $quoteid = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];
    $mode = $_POST['mode'];

    $invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'final'";
    $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
    $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
    $created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;
    if($created_at_query) {
        $created_at_query = " AND created_at < '$created_at_query' ";
    }
    else { 
        $created_at_query = "";
    }

    // query the room info
    $sql = "SELECT meta_key, meta_value 
            FROM vtiger_itinerary 
            WHERE quoteid = '$quoteid' 
            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
            AND (meta_key, created_at) IN (
                SELECT meta_key, MAX(created_at)
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid' $created_at_query
                AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
                GROUP BY meta_key);";
    $result = mysqli_query($conn, $sql);

    $single_rooms = 0;
    $double_rooms = 0;
    $triple_rooms = 0;
    $child_no_bed = 0;
    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['meta_key']) {
            case 'single_rooms':
                $single_rooms = (int) $row['meta_value'];
                break;
            case 'double_rooms':
                $double_rooms = (int) $row['meta_value'];
                break;
            case 'triple_rooms':
                $triple_rooms = (int) $row['meta_value'];
                break;
            case 'child_without_bed':
                $child_no_bed = (int) $row['meta_value'];
                break;
        }
    }

    // query the quote information
    $sql = "SELECT vq.quoteid, vq.subject, vq.adults, vq.children, vq.infants, va.organization_name AS accountname, va.address, vqcf.cf_1182, vq.country
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
            WHERE vq.quoteid = '$quoteid'
            LIMIT 1;";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        if ($row) {
            $accountName = $row['accountname'];
            $accountName = str_replace('&', 'and', $accountName);
            $address = $row['address'];
            $address = str_replace('&', 'and', $address);
            $subject = $row['subject'];
            $subject = str_replace('&', 'and', $subject);
            $country = $row['country'];
            $currency = 'AUD';
            if($country == 'New Zealand') {
                $currency = 'NZD';
            }

            $adults_no = $row['adults'] ?? 0;
            $children_no = $row['children']?? 0;
            $infants_no = $row['infants']?? 0;
            $no_pax = $row['adults'] + $row['children'];
            $pax_no = $row['adults'] + $row['children'];
            if($no_pax == 0) {
                echo '<script>alert("No of passengers not entered.");</script>';
                exit();
            }
            $payment_deadline = '';
            if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00') {
                $date = new DateTime($row['cf_1182']);
                $payment_deadline = $date->format('d-M-Y');
            }
        }
    }
    $child_with_bed = $children_no - $child_no_bed;

    $phpWord = new \PhpOffice\PhpWord\PhpWord();
    $phpWord->setDefaultParagraphStyle([
        'spaceAfter' => 1,
        'spaceBefore' => 1
    ]);
    $section = $phpWord->addSection();

    $imagePath = 'images/ES_TDU.png';
    $section->addImage($imagePath, ['width' => 100, 'height' => 50, 'align' => 'center']);
    $section->addText('Address: 6/60 Albert Rd, South Melbourne VIC 3205, Australia', [] , ['align' => 'center']);
    $section->addTextBreak(1);
    
    $styleTable = array('borderSize' => 6, 'borderColor' => '999999', 'cellMargin' => 80);
    $phpWord->addTableStyle('Styled Table', $styleTable);
    $table = $section->addTable('Styled Table');
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('Final Invoice', ['size' => 12], ['align' => 'center']);
    
    // blue break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(10000)->addText('To,', ['bold' => true]);
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    $table->addRow();
    $table->addCell(10000)->addText($accountName ?? '', ['bold' => true]);
    $table->addCell(3500);
    $table->addCell(3000)->addText('Date:', ['bold' => true]);
    $table->addCell(3500)->addText(date('d-M-Y'));

    $table->addRow();
    $table->addCell(10000)->addText($address ?? '');
    $table->addCell(3500);
    $table->addCell(3000)->addText('Ref No:', ['bold' => true]);
    $table->addCell(3500)->addText($quote_number ?? '', ['bold' => true]);

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(10000)->addText($subject ?? '', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText('Cost per unit', ['bold' => true], ['align' => 'center']);
    $table->addCell(3000)->addText('Number of Units', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText('Amount', ['bold' => true], ['align' => 'center']);

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    $quote_pax = -1;
    if($mode == 'group') {
        $mode_sql = '>1';
        $sql_group_sum = "SELECT MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                        FROM vtiger_products_saleprice vps
                        WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                        GROUP BY vps.subquoteid
                        ORDER BY pax_min ASC;";
        $result_group_sum = mysqli_query($conn, $sql_group_sum);

        if (mysqli_num_rows($result_group_sum) > 0) {
            while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
                if ($row_group_sum['pax_min'] <= ($adults_no+$children_no) && ($adults_no+$children_no) <= $row_group_sum['pax_max']) {
                    $quote_pax = $row_group_sum['pax_min'];
                    break;
                }
            }
        }
    }

    $pricing = getQuotePricing($conn, $quoteid, $quote_pax);
    $pricing_single_room = $pricing['single_room'];
    $pricing_double_room = $pricing['double_room'];
    $pricing_triple_room = $pricing['triple_room'];
    $pricing_child_with_bed = $pricing['child_with_bed'];
    $pricing_child_no_bed = $pricing['child_no_bed'];
    $pricing_infant = $pricing['infant'];

    $total_amount = 0;

    if ($single_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Single Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($single_rooms, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room * $single_rooms, [], ['align' => 'right']);
        $total_amount += $pricing_single_room * $single_rooms;
    }
    
    if ($double_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Double Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_double_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($double_rooms * 2, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_double_room * $double_rooms * 2, [], ['align' => 'right']);
        $total_amount += $pricing_double_room * $double_rooms * 2;
    }
    
    if ($triple_rooms > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Adult on Triple Occupancy');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_triple_room, [], ['align' => 'right']);
        $table->addCell(3000)->addText($triple_rooms * 3 - $child_with_bed, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_triple_room * ($triple_rooms * 3 - $child_with_bed), [], ['align' => 'right']);
        $total_amount += $pricing_triple_room * ($triple_rooms * 3 - $child_with_bed);
    }

    if ($single_rooms == 0 && $double_rooms == 0 && $triple_rooms == 0) {
        if($adults_no > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Adult No Hotel');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room, [], ['align' => 'right']);
            $table->addCell(3000)->addText($adults_no, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_single_room * $adults_no, [], ['align' => 'right']);
            $total_amount += $pricing_single_room * $adults_no;
        }
        if($children_no > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child No Hotel');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($children_no, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed * $children_no, [], ['align' => 'right']);
            $total_amount += $pricing_child_no_bed * $children_no;
        }
    } else {
        if ($child_with_bed > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child with Bed');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_with_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($child_with_bed, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_with_bed * $child_with_bed, [], ['align' => 'right']);
            $total_amount += $pricing_child_with_bed * $child_with_bed;
        }
        
        if ($child_no_bed > 0) {
            $table->addRow();
            $table->addCell(10000)->addText('Package Cost Per Child without Bed');
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed, [], ['align' => 'right']);
            $table->addCell(3000)->addText($child_no_bed, [], ['align' => 'right']);
            $table->addCell(3500)->addText($currency . ' ' . $pricing_child_no_bed * $child_no_bed, [], ['align' => 'right']);
            $total_amount += $pricing_child_no_bed * $child_no_bed;
        }
    }
    if($infants_no > 0) {
        $table->addRow();
        $table->addCell(10000)->addText('Package Cost Per Infant');
        $table->addCell(3500)->addText($currency . ' ' . $pricing_infant, [], ['align' => 'right']);
        $table->addCell(3000)->addText($infants_no, [], ['align' => 'right']);
        $table->addCell(3500)->addText($currency . ' ' . $pricing_infant * $infants_no, [], ['align' => 'right']);
        $total_amount += $pricing_infant * $infants_no;
    }
    
    $sql_adjustments = "SELECT * FROM vtiger_invoice_add_products WHERE quoteid='$quoteid' ORDER BY created_at DESC";
    $result_adjustments = $conn->query($sql_adjustments);
    if ($result_adjustments->num_rows > 0) {
        while ($row_adjustment = $result_adjustments->fetch_assoc()) {
            $remark = str_replace('&', 'and', $row_adjustment['remark']);
            $price_field = (float) $row_adjustment['price_field'];
            $quantity = (int) $row_adjustment['quantity'];
            $total_amount += $price_field*$quantity;

            // Add a new row to the table
            $table->addRow();
            $cell = $table->addCell(10000);
            $cell->addText($remark ?? '');
            if(isset($row_adjustment['product_field']) && !empty($row_adjustment['product_field'])) {
                $cell->addText($row_adjustment['product_field'] ?? '', ['bold' => true]);
            }
            $table->addCell(3500)->addText("+ $currency " . $price_field, [], ['align' => 'right']);
            $table->addCell(3000)->addText($quantity ?? '', [], ['align' => 'right']);
            $table->addCell(3500)->addText("+ $currency " . $price_field*$quantity, [], ['align' => 'right']);
        }
    }

    $sql_refunds = "SELECT * FROM vtiger_invoice_refunds WHERE quoteid='$quoteid' ORDER BY created_at DESC";
    $result_refunds = $conn->query($sql_refunds);
    if ($result_refunds->num_rows > 0) {
        while ($row_refund = $result_refunds->fetch_assoc()) {
            $product = str_replace('&', 'and', $row_refund['product']);
            $refund_amount = (float) $row_refund['refund_amount'];
            $refund_reason = $row_refund['refund_reason'];
            $total_amount -= $refund_amount;

            // Add a new row to the table
            $table->addRow();
            $cell = $table->addCell(10000);
            $cell->addText("Reduction: " . $product);
            $cell->addText($refund_reason);
            $table->addCell(3500)->addText('');
            $table->addCell(3000)->addText('');
            $table->addCell(3500)->addText("- $currency " . $refund_amount, [], ['align' => 'right']);
        }
    }

    // $total_amount_adjust = $total_amount - $total_amount_before_adjust;
    $delete_sql = "DELETE FROM vtiger_payment_history WHERE quoteid = '$quoteid' AND source = 'final';";
    mysqli_query($conn, $delete_sql) or die(mysqli_error($conn));

    $insert_sql = "INSERT INTO vtiger_payment_history (quoteid, source, total_amount, added_on, added_by) VALUES ('$quoteid', 'final', '$total_amount', NOW(), '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    if(isset($_POST['delete_on_success']) && $_POST['delete_on_success'] == 'true') {
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=doc");
        exit;
    }

    // blank
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(3500);
    $table->addCell(3000);
    $table->addCell(3500);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $total_amount = ceil($total_amount);
    $table->addRow();
    $table->addCell(10000)->addText('');
    $table->addCell(6500, ['gridSpan' => 2])->addText('Total Amount', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . $total_amount, ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Total', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . $total_amount, ['bold' => true], ['align' => 'right']);

    $sql = "SELECT * FROM vtiger_payment_history WHERE quoteid='$quoteid';";
    $result = $conn->query($sql);
    $trams_received_amount = 0;
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            if(isset($row['trams_received_amount']) && !empty($row['trams_received_amount'])) {
                $trams_received_amount += (float) $row['trams_received_amount'];
            }
        }
    }
    $total_amount -= $trams_received_amount;
    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('less: Received till date', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . $trams_received_amount, ['bold' => true], ['align' => 'right']);

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('add: Remitance Charges', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' 30', ['bold' => true], ['align' => 'right']);
    $total_amount += 30;

    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Balance Amount', ['bold' => true], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . ceil($total_amount), ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $date = new DateTime();
    $date->modify('+1 day');
    $deadline = $date->format('d-M-Y');
    $table->addRow();
    $table->addCell(16500, ['gridSpan' => 3])->addText('Balance to be received by ' . $deadline, ['bold' => true, 'color' => 'FF0000'], ['align' => 'center']);
    $table->addCell(3500)->addText($currency . ' ' . ceil($total_amount), ['bold' => true], ['align' => 'right']);

    // yellow break
    $table->addRow();
    $table->addCell(20000, ['bgColor' => 'FFFF99', 'gridSpan' => 4])->addText('');

    $table->addRow();
    $table->addCell(20000, ['gridSpan' => 4])->addText('Please have the full amount remitted without any further deduction, bank charges or VAT.', ['bold' => true], ['align' => 'left']);

    if($currency == 'NZD') {
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Name and Address of bank', ['bold' => true], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Name: TURTLE DOWN UNDER LIMITED', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Number: 01-0527-0727847-00', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Address:  642 MAUNGATAUTARI ROAD', [], ['align' => 'center']);
    }
    else {
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Name and Address of bank', ['bold' => true], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Bank Name: Commonwealth Bank', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Address: 978-980 Main Rd Eltham VIC 3095', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Name: Turtle Down Under Pty Ltd', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Account Number: 1090-5957', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('BSB: 063-622', [], ['align' => 'center']);
        $table->addRow();
        $table->addCell(20000, ['bgColor' => 'ADD8E6', 'gridSpan' => 4])->addText('Swift Code: CTBAAU2S', [], ['align' => 'center']);
    }
    
    // export
    $timestamp = date('YmdHis');
    $fileName = 'FINAL-INVOICE-' . $quote_number . '-' . $timestamp;
    $folderPath = 'invoice/';
    $localFilePath = $folderPath . $fileName;

    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0777, true);
    }
    $insert_sql = "INSERT INTO vtiger_invoice (quoteid, filepath, type, created_by) VALUES ('$quoteid', '$localFilePath', 'final', '$created_by');";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    // Export as PDF
    $tempHtmlFile = 'temp_invoice' . $timestamp . '.html';
    $phpWord->save($tempHtmlFile, 'HTML');
    $htmlContent = file_get_contents($tempHtmlFile);

    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($htmlContent);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Save PDF temporarily for download
    $pdfOutput = $dompdf->output();
    $pdfFilePath = $localFilePath . '.pdf';
    file_put_contents($pdfFilePath, $pdfOutput);
    unlink($tempHtmlFile);

    // Pass PDF file path to frontend
    header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=doc");
    exit;
}

function convertTo12Hour($time24) {
    if(!$time24) {
        return;
    }
    $dateTime = DateTime::createFromFormat('H:i', $time24);
    if (!$dateTime) {
        return "";
    }
    return $dateTime->format('h:i A');
}

?>
