<?php

function redirectWithoutParam($paramToRemove) {
    $currentUrl = $_SERVER['REQUEST_URI'];
    $parsedUrl = parse_url($currentUrl);
    parse_str($parsedUrl['query'] ?? '', $queryParams);
    unset($queryParams[$paramToRemove]);
    $newQueryString = http_build_query($queryParams);
    $newUrl = $parsedUrl['path'] . ($newQueryString ? '?' . $newQueryString : '');
    header("Location: $newUrl");
    exit;
}

function print_th_pax_ranges($conn, $quoteid, $quote_number, $subject, $quoteid_history, $edit) { 
    $sql_pax = "SELECT DISTINCT pax_min, pax_max, subquoteid
                FROM vtiger_products_saleprice
                WHERE quoteid='$quoteid' AND subquoteid > 1
                ORDER BY pax_min ASC;";
    $result_pax = mysqli_query($conn, $sql_pax);
    $pax_row_num = mysqli_num_rows($result_pax);
    $pax_row = '';
    
    while ($row_pax = mysqli_fetch_array($result_pax)) {
        $pax_min = $row_pax['pax_min'];
        $pax_max = $row_pax['pax_max'];
        $subquoteid_row = $row_pax['subquoteid'];
        
        if ($quoteid_history == '' && $edit == 'price') {
            $pax_row .= "<th>
                        <input type='hidden' name='quoteid' value='" . htmlspecialchars($quoteid) . "' />
                        Pax: <input type='number' name='pax_min_$subquoteid_row' value='" . htmlspecialchars($pax_min) . "' min='1' style='width: 60px;' /> - 
                        <input type='number' name='pax_max_$subquoteid_row' value='" . htmlspecialchars($pax_max) . "' min='1' style='width: 60px;' />
                        <button type='submit' name='delete_pax' value='$subquoteid_row' style='background-color: red; color: white;' onclick=\"return confirm('Are you sure you want to delete this column?');\">DEL</button>
                    </th>";
        } else {
            // For quote history, we don't need the delete button
            $pax_row .= "<th>
                        <input type='hidden' name='quoteid' value='" . htmlspecialchars($quoteid) . "' />
                        Pax: " . htmlspecialchars($pax_min) . "-" . htmlspecialchars($pax_max) . "
                    </th>";
        }
    }
    
    if ($pax_row_num > 0 && $quoteid_history == '' && $edit == 'price') {
        // Add a button to add new pax range when in edit mode
        $add_pax = '<th><button type="button" id="openPopup">+</button></th>';
    } else {
        $add_pax = '<th></th>';
    }

    return array(
        'pax_row' => $pax_row . $add_pax,
        'pax_row_num' => $pax_row_num
    );
}


function getHotelTypeNumber($hotel_type) {
    switch ($hotel_type) {
        case 'Single':
            return 1;
        case 'Double':
            return 2;
        case 'Triple':
            return 3;
        default:
            return 1;
    }
}

function generate_sorting_url($column, $current_dir, $query_params) {
    $query_params['order_by'] = $column;
    $query_params['order_dir'] = ($current_dir === 'asc') ? 'desc' : 'asc';
    return '?' . http_build_query($query_params);
}

function get_sort_icon($column, $current_order_by, $current_order_dir) {
    if ($current_order_by === $column) {
        return $current_order_dir === 'asc' ? 'fas fa-sort-up' : 'fas fa-sort-down';
    }
    return 'fas fa-sort';
}

function insertRooms($conn, $quote_id, $room_type, $count, $child_count, $sequence_no) {
    if($room_type == 'Single') {
        for ($i = 0; $i < $count; $i++) {
            $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, room_type, num_child, child_type) 
                    VALUES ($quote_id, $sequence_no, '', '', '', '$room_type', 0, '')";

            mysqli_query($conn, $sql) or die(mysqli_error($conn));
            $sequence_no++;
        }
    }
    if($room_type == 'Double') {
        for ($i = 0; $i < $count; $i++) {
            if($child_count > 0) {
                $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, room_type, num_child, child_type) 
                        VALUES 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_without_bed'),
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_without_bed'),
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_without_bed')";
                mysqli_query($conn, $sql);
                $child_count--;
            }
            else {
                $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, room_type, num_child, child_type) 
                        VALUES 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 0, ''), 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 0, '')";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            }
            
            $sequence_no++;
        }
    }

    if($room_type == 'Triple') {
        for ($i = 0; $i < $count; $i++) {
            if($child_count > 0) {
                $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, room_type, num_child, child_type) 
                        VALUES 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_with_bed'),
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_with_bed'),
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 1, 'child_with_bed')";
                mysqli_query($conn, $sql);
                $child_count--;
            }
            else {
                $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, room_type, num_child, child_type) 
                        VALUES 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 0, ''), 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 0, ''), 
                        ($quote_id, $sequence_no, '', '', '', '$room_type', 0, '')";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            }
            
            $sequence_no++;
        }
    }
    
    return $sequence_no++;
}

function auto_create_task_quotestage($conn, $quoteid, $latest_stage, $quote_stage, $assigned_to_ops, $assigned_to_qa) {
    $sql = "SELECT vq.quote_no, vq.subject, vqinfo.assigned_to_region, vqinfo.assigned_to_ops, vqinfo.assigned_to_qa 
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
            WHERE vq.quoteid = '$quoteid';";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);

    $quote_number = $row['quote_no'];
    $subject = $row['subject'];
    $assigned_to_region = $row['assigned_to_region'] ?? '';
    $assigned_to_ops_old = $row['assigned_to_ops'] ?? '';
    $assigned_to_qa_old = $row['assigned_to_qa'] ?? '';

    if(($latest_stage == 'Created' && $quote_stage == 'Accepted') || ($quote_stage == 'Accepted' && $assigned_to_ops_old != $assigned_to_ops)) {
        if($assigned_to_ops != '') {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_ops', 'Operation');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        } else {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_ops_old', 'Operation');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        }

        $task_id = mysqli_insert_id($conn);
        $message = "Quote $quote_number Accepted, Please action";
        $insert_msg_sql = "INSERT INTO tdu_tasks_management_msg (task_id, message, created_by) VALUES ('$task_id', '$message', 'SYSTEM')";
        mysqli_query($conn, $insert_msg_sql) or die(mysqli_error($conn));
    }
    else if(($latest_stage == 'Accepted' && $quote_stage == 'PRE QA - pending') || ($quote_stage == 'PRE QA - pending' && $assigned_to_qa_old != $assigned_to_qa)) {
        if($assigned_to_qa != '') {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_qa', 'QA');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        } else {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_qa_old', 'QA');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        }
        $task_id = mysqli_insert_id($conn);
        $message = "Quote $quote_number PRE QA - pending, Please action";
        $insert_msg_sql = "INSERT INTO tdu_tasks_management_msg (task_id, message, created_by) VALUES ('$task_id', '$message', 'SYSTEM')";
        mysqli_query($conn, $insert_msg_sql) or die(mysqli_error($conn));
    }
    else if(($latest_stage == 'PRE QA - completed' && $quote_stage == 'Payment Received - Release Vouchers') || ($quote_stage == 'PRE QA - completed' && $assigned_to_ops_old != $assigned_to_ops)) {
        if($assigned_to_ops != '') {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_ops', 'Operation');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        } else {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_ops_old', 'Operation');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        }
        $task_id = mysqli_insert_id($conn);
        $message = "Quote $quote_number Payment Received - Release Vouchers, Please action";
        $insert_msg_sql = "INSERT INTO tdu_tasks_management_msg (task_id, message, created_by) VALUES ('$task_id', '$message', 'SYSTEM')";
        mysqli_query($conn, $insert_msg_sql) or die(mysqli_error($conn));
    }
    else if(($latest_stage == 'Payment Received - Release Vouchers' && $quote_stage == 'Final QA') || ($quote_stage == 'Payment Received - Release Vouchers' && $assigned_to_qa_old != $assigned_to_qa)) {
        if($assigned_to_qa != '') {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_qa', 'QA');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        } else {
            $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                            VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_qa_old', 'QA');";
            mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        }
        $task_id = mysqli_insert_id($conn);
        $message = "Quote $quote_number Final QA, Please action";
        $insert_msg_sql = "INSERT INTO tdu_tasks_management_msg (task_id, message, created_by) VALUES ('$task_id', '$message', 'SYSTEM')";
        mysqli_query($conn, $insert_msg_sql) or die(mysqli_error($conn));
    }
}

function auto_create_task_quotestage_sales($conn, $quoteid, $latest_stage, $quote_stage) {
    $sql = "SELECT vq.quote_no, vq.subject, vqinfo.assigned_to_region, vqinfo.assigned_to_ops, vqinfo.assigned_to_qa 
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
            WHERE vq.quoteid = '$quoteid';";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);

    $quote_number = $row['quote_no'];
    $subject = $row['subject'];
    $assigned_to_region = $row['assigned_to_region'] ?? '';
    $assigned_to_ops_old = $row['assigned_to_ops'] ?? '';
    $assigned_to_qa_old = $row['assigned_to_qa'] ?? '';

    if($latest_stage == 'Created' && $quote_stage == 'Accepted') {
        $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                        VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_ops_old', 'Operation');";
        mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
    } 
    else if($latest_stage == 'Accepted' && $quote_stage == 'PRE QA - pending') {
        $insert_sql5 = "INSERT INTO tdu_tasks_management (subject, quote_no, assigned_to_region, assigned_to_user, category) 
                        VALUES ('$subject', '$quote_number', '$assigned_to_region', '$assigned_to_qa_old', 'QA');";
        mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
    }
}

function processTransfersItineraryFromHotel($conn, $quoteid, $checkin_date, $checkout_date, $hotel_name, $city_name) {
    // Fetch date of travel
    $query = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid'";
    $result = mysqli_query($conn, $query);
    if ($row = mysqli_fetch_assoc($result)) {
        $date_of_travel = $row['cf_1162'];
    } else {
        echo 'Error fetching date of travel.';
        exit;
    }

    // Fetch all transfers (activities) for this quote
    $query = "
        SELECT vi.id, vi.sequence_no, vi.day, tp.keywords, tp.city 
        FROM vtiger_inventoryproductrel vi
        LEFT JOIN tdu_products tp ON vi.productid = tp.productid
        WHERE vi.id='$quoteid' AND vi.cf_928='Transfers'
    ";

    $result = mysqli_query($conn, $query);
    if (!$result) {
        echo 'Error fetching activities: ' . mysqli_error($conn);
        exit;
    }

    while ($row = mysqli_fetch_assoc($result)) {
        $sequence_no = $row['sequence_no'];
        $day = $row['day'];
        $city = $row['city'];
        $keywords = strtolower($row['keywords']); // lowercase for easier matching

        // Calculate date of activity
        $date_of_activity = date('Y-m-d', strtotime("$date_of_travel + " . ($day - 1) . " days"));

        // Check if date of activity is within check-in and check-out dates
        if ($date_of_activity >= $checkin_date && $date_of_activity <= $checkout_date && trim(strtolower($city)) == trim(strtolower($city_name))) {
            $meta_key = '';
            $meta_value = $hotel_name;
            $meta_value = mysqli_real_escape_string($conn, $meta_value);

            if (strpos($keywords, 'inbound') !== false) {
                $meta_key = 'dropoff_location';
            } elseif (strpos($keywords, 'outbound') !== false) {
                $meta_key = 'pickup_location';
            }

            if ($meta_key) {
                // Insert into vtiger_itinerary
                $insert_query = "
                    INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value)
                    VALUES ('$quoteid', '$sequence_no', 0, '$meta_key', '$meta_value')
                ";

                if (!mysqli_query($conn, $insert_query)) {
                    echo 'Error inserting itinerary: ' . mysqli_error($conn);
                    exit;
                }
            }
        }
    }
}

function getHotelName($conn, $quoteid, $sequence_no) {
    $query = "SELECT tp.productName, tp.city
              FROM vtiger_inventoryproductrel vi
              LEFT JOIN tdu_products tp ON vi.productid = tp.productid
              WHERE vi.id='$quoteid' AND vi.sequence_no='$sequence_no';";
    
    $result = mysqli_query($conn, $query);
    if ($row = mysqli_fetch_assoc($result)) {
        return [
            'productName' => $row['productName'] ?? '',
            'city' => $row['city'] ?? ''
        ];
    } else {
        return [
            'productName' => '',
            'city' => ''
        ];
    }
}

function getMailboxByQuote($conn, $quoteid) {
    // Query to fetch quote_no and country
    $query = "SELECT quote_no, country FROM vtiger_quotes WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $query);

    if (!$result || mysqli_num_rows($result) === 0) {
        return '';
    }

    $row = mysqli_fetch_assoc($result);
    $quote_no = $row['quote_no'];
    $country = strtolower(trim($row['country'])); // Normalize country name for comparison

    // Determine the base domain by country
    if ($country === 'australia') {
        $domain = 'turtledownunder.com.au';
    } elseif ($country === 'new zealand') {
        $domain = 'turtledownunder.co.nz';
    } else {
        return '';
    }

    // Determine the mailbox based on quote_no ending
    if (str_ends_with($quote_no, 'G')) {
        $mailbox = "groups@$domain";
    } else {
        $mailbox = "operations@$domain";
    }

    return $mailbox;
}

function fetchDynamicPrice($conn, $productid, $newDate) {
    $productid = mysqli_real_escape_string($conn, $productid);
    $newDate = mysqli_real_escape_string($conn, $newDate); // format: YYYY-MM-DD
    $dayOfWeek = date('l', strtotime($newDate)); 

    // Query the pricebook first
    $sql = "SELECT unit_price AS unitPrice, child_price AS childPrice, infant_price AS infantPrice, 
                   sharing_price AS sharingPrice, triple_price AS triplePrice, 
                   child_with_bed_price AS childWithBedPrice, child_no_bed_price AS childNoBedPrice, dayOfWeek 
            FROM tdu_pricebook 
            WHERE productid = '$productid' 
              AND '$newDate' BETWEEN start_date AND end_date
            ORDER BY 
                CASE 
                    WHEN dayOfWeek != '' THEN 1 
                    ELSE 2 
                END, dayOfWeek;";
    $result = mysqli_query($conn, $sql);

    $row = null;
    if ($result && mysqli_num_rows($result) > 0) {
        while ($tempRow = mysqli_fetch_assoc($result)) {
            if ($tempRow['dayOfWeek'] == $dayOfWeek || $tempRow['dayOfWeek'] == '') {
                $row = $tempRow;
                break;
            }
        }
    } else {
        // Fallback: Fetch from tdu_products
        $sql = "SELECT unitPrice, childPrice, infantPrice, familyPrice, 
                       sharingPrice, triplePrice, childWithBedPrice, childNoBedPrice 
                FROM tdu_products 
                WHERE productid = '$productid' 
                LIMIT 1;";
        $result = mysqli_query($conn, $sql);

        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
        } else {
            return null;
        }
    }

    return $row;
}

function getSurchargeForDate($conn, $productid, $date) {
    $timestamp = strtotime($date);
    $month = (int)date('n', $timestamp); // 1-12
    $day = (int)date('j', $timestamp);   // 1-31

    $sql = "SELECT s.surcharge, s.start_m, s.start_d, s.end_m, s.end_d
            FROM tdu_products_surcharge ps
            LEFT JOIN tdu_vendors_surcharge s ON ps.surcharge_id = s.auto_id
            WHERE ps.productid = '$productid';";
    
    $result = $conn->query($sql);
    
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $start = strtotime("2000-{$row['start_m']}-{$row['start_d']}");
            $end = strtotime("2000-{$row['end_m']}-{$row['end_d']}");
            $current = strtotime("2000-$month-$day");

            if ($start <= $end) {
                if ($current >= $start && $current <= $end) {
                    return (float) $row['surcharge'];
                }
            } else {
                // Range wraps around year end (e.g. Dec to Jan)
                if ($current >= $start || $current <= $end) {
                    return (float) $row['surcharge'];
                }
            }
        }
    }
    
    return 0;
}

function duplicateTableRows($conn, $table, $oldId, $newId, $idColumn = 'quoteid') {
    // Fetch column names dynamically except the primary id column
    $result = mysqli_query($conn, "SHOW COLUMNS FROM `$table`");
    $columns = [];

    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['Field'] != $idColumn && $row['Field'] != 'auto_id' && $row['Field'] != 'lineitem_id') { // Exclude primary id column
            $columns[] = "`" . $row['Field'] . "`";
        }
    }

    if (empty($columns)) {
        die("Error: No columns found in table $table.");
    }

    // Convert column names to a string
    $columnsList = implode(", ", $columns);

    // Construct and execute the duplication query
    $sql = "
        INSERT INTO `$table` (`$idColumn`, $columnsList)
        SELECT '$newId', $columnsList
        FROM `$table`
        WHERE `$idColumn` = '$oldId';
    ";

    if (!mysqli_query($conn, $sql)) {
        die("Error duplicating rows in table $table: " . mysqli_error($conn));
    }
}
?>
