%bcond_without tests

%bcond_without libheif

%if 0%{?flatpak}
%bcond_with perl
%else
%bcond_without perl
%endif

# Disable automatic .la file removal
%global __brp_remove_la_files %nil
%global Version 7.1.1
%global Patchlevel 47
%global libsover 10
%global libcxxsover 5

Name:           ImageMagick
Epoch:          1
Version:        %{Version}
Release:        %{Patchlevel}
Summary:        Use ImageMagick to create, edit, convert, and display raster image files.

License:        ImageMagick
URL:            https://imagemagick.org/
Source0:        https://imagemagick.org/archive/releases/%{name}-%{Version}-%{Patchlevel}.tar.xz

BuildRequires:  pkgconfig(bzip2)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libtiff-4)
BuildRequires:  giflib-devel
BuildRequires:  pkgconfig(zlib)
%if %{with perl}
BuildRequires:  perl-devel >= 5.8.1
BuildRequires:  perl-generators
%endif
%if 0%{?rhel} && 0%{?rhel} < 8
BuildRequires:  ghostscript-devel
%else
BuildRequires:  libgs-devel
%endif
BuildRequires:  pkgconfig(ddjvuapi)
BuildRequires:  pkgconfig(libwmf)
BuildRequires:  pkgconfig(jasper)
BuildRequires:  libtool-ltdl-devel
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xt)
BuildRequires:  pkgconfig(lcms2)
BuildRequires:  pkgconfig(libxml-2.0)
BuildRequires:  pkgconfig(librsvg-2.0)
%if 0%{?rhel} && 0%{?rhel} < 9
BuildRequires:  pkgconfig(IlmBase), pkgconfig(OpenEXR) < 2.5.6
%else
BuildRequires:  pkgconfig(OpenEXR)
%endif
BuildRequires:  pkgconfig(fftw3)
BuildRequires:  pkgconfig(libwebp)
BuildRequires:  jbigkit-devel
BuildRequires:  pkgconfig(libjxl)
BuildRequires:  pkgconfig(libopenjp2) >= 2.1.0
BuildRequires:  pkgconfig(libcgraph) >= 2.9.0
BuildRequires:  pkgconfig(raqm)
%if 0%{?fedora} || 0%{?rhel} > 8
BuildRequires:  pkgconfig(lqr-1)
%endif
BuildRequires:  pkgconfig(libraw) >= 0.14.8
BuildRequires:  pkgconfig(libzstd)
BuildRequires:  pkgconfig(libzip) >= 1.0.0
BuildRequires:  pkgconfig(pango) >= 1.28.1
BuildRequires:  pkgconfig(pangocairo) >= 1.28.1
BuildRequires:  urw-base35-fonts-devel
BuildRequires:  autoconf automake gcc gcc-c++
BuildRequires:  make
BuildRequires:  gnupg2
# for doc
BuildRequires:  doxygen

Requires:       %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
# allow smooth upgrade for 3rd party repository
# providing latest version/soname as ImageMagick7
Obsoletes:      %{name}7            < %{epoch}:%{version}-%{release}
Provides:       %{name}7            = %{epoch}:%{version}-%{release}

%description
ImageMagick® is a free, open-source software suite, used for editing and manipulating digital images. It can be used to create, edit, compose, or convert bitmap images, and supports a wide range of file formats, including JPEG, PNG, GIF, TIFF, and Ultra HDR.

ImageMagick is widely used in industries such as web development, graphic design, and video editing, as well as in scientific research, medical imaging, and astronomy. Its versatile and customizable nature, along with its robust image processing capabilities, make it a popular choice for a wide range of image-related tasks.

ImageMagick includes a command-line interface for executing complex image processing tasks, as well as APIs for integrating its features into software applications. It is written in C and can be used on a variety of operating systems, including Linux, Windows, and macOS.


%package devel
Summary:        Library links and header files for ImageMagick app development
Requires:       %{name}%{?_isa} = %{epoch}:%{version}-%{release}
Requires:       %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Obsoletes:      %{name}7-devel       < %{epoch}:%{version}-%{release}
Provides:       %{name}7-devel       = %{epoch}:%{version}-%{release}

%description devel
ImageMagick-devel contains the library links and header files you'll need to
develop ImageMagick applications. ImageMagick is an image manipulation program.

If you want to create applications that will use ImageMagick code or APIs,
you need to install ImageMagick-devel as well as ImageMagick.  You do not
need to install it if you just want to use ImageMagick, however.


%package libs
Summary: ImageMagick libraries to link with
Obsoletes: %{name}7-libs < %{epoch}:%{version}-%{release}
Provides:  %{name}7-libs = %{epoch}:%{version}-%{release}
# These may be used for some functions
Recommends: urw-base35-fonts
# default font is OpenSans-Regular
Recommends: open-sans-fonts

%description libs
This packages contains a shared libraries to use within other applications.


%package djvu
Summary: DjVu plugin for ImageMagick
Requires: %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Obsoletes: %{name}7-djvu       < %{epoch}:%{version}-%{release}
Provides:  %{name}7-djvu       = %{epoch}:%{version}-%{release}

%description djvu
This packages contains a plugin for ImageMagick which makes it possible to
save and load DjvU files from ImageMagick and libMagickCore using applications.


%if %{with libheif}
%package heic
Summary: HEIC plugin for ImageMagick
BuildRequires:  pkgconfig(libheif) >= 1.4.0
%if 0%{?rhel} == 7
# ensure we use our on EL-7
Requires:       libheif%{?_isa} >= 1.4.0
%endif
Requires:       %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}

%description heic
This packages contains a plugin for ImageMagick which makes it possible to
save and load HEIC files from ImageMagick and libMagickCore using applications.
%endif


%package doc
Summary: ImageMagick html documentation
Obsoletes: %{name}7-doc < %{epoch}:%{version}-%{release}
Provides:  %{name}7-doc = %{epoch}:%{version}-%{release}

%description doc
ImageMagick documentation, this package contains usage (for the commandline
tools) and API (for the libraries) documentation in HTML format.
Note this documentation can also be found on the ImageMagick website:
https://imagemagick.org/


%if %{with perl}
%package perl
Summary:        ImageMagick perl bindings
Requires:       %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Obsoletes:      %{name}7-perl        < %{epoch}:%{version}-%{release}
Provides:       %{name}7-perl        = %{epoch}:%{version}-%{release}

%description perl
Perl bindings to ImageMagick.

Install ImageMagick-perl if you want to use any perl scripts that use
ImageMagick.
%endif


%package c++
Summary:        ImageMagick Magick++ library (C++ bindings)
Requires:       %{name}-libs%{?_isa} = %{epoch}:%{version}-%{release}
Obsoletes:      %{name}7-c++         < %{epoch}:%{version}-%{release}
Provides:       %{name}7-c++         = %{epoch}:%{version}-%{release}

%description c++
This package contains the Magick++ library, a C++ binding to the ImageMagick
graphics manipulation library.

Install ImageMagick-c++ if you want to use any applications that use Magick++.


%package c++-devel
Summary:        C++ bindings for the ImageMagick library
Requires:       %{name}-c++%{?_isa} = %{epoch}:%{version}-%{release}
Requires:       %{name}-devel%{?_isa} = %{epoch}:%{version}-%{release}
Obsoletes:      %{name}7-c++-devel    < %{epoch}:%{version}-%{release}
Provides:       %{name}7-c++-devel    = %{epoch}:%{version}-%{release}

%description c++-devel
ImageMagick-devel contains the static libraries and header files you'll
need to develop ImageMagick applications using the Magick++ C++ bindings.
ImageMagick is an image manipulation program.

If you want to create applications that will use Magick++ code or APIs, you'll
need to install ImageMagick-c++-devel, ImageMagick-devel and ImageMagick.
You don't need to install it if you just want to use ImageMagick, or if you
want to develop/compile applications using the ImageMagick C interface,
however.


%prep
%autosetup -p1 -n %{name}-%{Version}-%{Patchlevel}


%build
autoconf -f -i -v
# Reduce thread contention, upstream sets this flag for Linux hosts
export CFLAGS="%{optflags} -DIMPNG_SETJMP_IS_THREAD_SAFE"
%configure \
        --enable-shared \
        --disable-static \
        --with-modules \
%if %{with perl}
        --with-perl \
        --with-perl-options="INSTALLDIRS=vendor %{?perl_prefix} CC='%__cc -L$PWD/MagickCore/.libs' LDDLFLAGS='-shared -L$PWD/MagickCore/.libs'" \
%endif
        --with-x \
        --with-threads \
        --with-magick_plus_plus \
        --with-gslib \
        --with-pango \
        --with-fftw \
        --with-wmf \
        --with-webp \
        --with-openexr \
        --with-rsvg \
        --with-xml \
        --with-urw-base35-font-dir="%{urw_base35_fontpath}" \
        --without-dps \
        --enable-openmp \
        --without-gcc-arch \
        --with-jbig \
        --with-jxl \
        --with-openjp2 \
        --with-raw \
%if 0%{?fedora} || 0%{?rhel} > 8
        --with-lqr \
%endif
        --with-gvc \
        --with-raqm \
%if %{with libheif}
        --with-heic \
%endif

# Do *NOT* use %%{?_smp_mflags}, this causes PerlMagick to be silently misbuild
make -j6
# Generate API docs
make html-local


%install
%make_install

# Compatibility symlinks for headers for IM6->IM7 transition
ln -sr %{buildroot}%{_includedir}/%{name}-7/MagickCore %{buildroot}%{_includedir}/%{name}-7/magick
ln -sr %{buildroot}%{_includedir}/%{name}-7/MagickWand %{buildroot}%{_includedir}/%{name}-7/wand

# Do NOT remove .la files for codecs
rm %{buildroot}%{_libdir}/*.la

%if %{with perl}
chmod 755 %{buildroot}%{perl_vendorarch}/auto/Image/Magick/Q16HDRI/Q16HDRI.so

# perlmagick: fix perl path of demo files
%{__perl} -MExtUtils::MakeMaker -e 'MY->fixin(@ARGV)' PerlMagick/demo/*.pl

# perlmagick: cleanup various perl tempfiles from the build which get installed
find %{buildroot} -name "*.bs" |xargs rm -f
find %{buildroot} -name ".packlist" |xargs rm -f
find %{buildroot} -name "perllocal.pod" |xargs rm -f

# perlmagick: build files list
find %{buildroot}/%{_libdir}/perl* -type f -print \
        | sed "s@^%{buildroot}@@g" > perl-pkg-files
find %{buildroot}%{perl_vendorarch} -type d -print \
        | sed "s@^%{buildroot}@%dir @g" \
        | grep -v '^%dir %{perl_vendorarch}$' \
        | grep -v '/auto$' >> perl-pkg-files
if [ -z perl-pkg-files ] ; then
        echo "ERROR: EMPTY FILE LIST"
        exit -1
fi
%endif

# fix multilib issues: Rename provided file with platform-bits in name.
# Create platform independant file inplace of provided and conditionally include required.
# $1 - filename.h to process.
function multilibFileVersions(){
mv $1 ${1%%.h}-%{__isa_bits}.h

local basename=$(basename $1)

cat >$1 <<EOF
#include <bits/wordsize.h>

#if __WORDSIZE == 32
# include "${basename%%.h}-32.h"
#elif __WORDSIZE == 64
# include "${basename%%.h}-64.h"
#else
# error "unexpected value for __WORDSIZE macro"
#endif
EOF
}

multilibFileVersions %{buildroot}%{_includedir}/%{name}-7/MagickCore/magick-config.h
multilibFileVersions %{buildroot}%{_includedir}/%{name}-7/MagickCore/magick-baseconfig.h
multilibFileVersions %{buildroot}%{_includedir}/%{name}-7/MagickCore/version.h


%check
%if %{with tests}
export LD_LIBRARY_PATH=%{buildroot}/%{_libdir}
%make_build check
%endif
rm PerlMagick/demo/Generic.ttf

%files
%doc NOTICE AUTHORS.txt
%license LICENSE
%{_bindir}/[a-z]*
%{_mandir}/man[145]/[a-z]*
%{_mandir}/man1/%{name}.*

%files libs
%doc NOTICE AUTHORS.txt
%license LICENSE
%{_libdir}/libMagickCore-7.Q16HDRI.so.%{libsover}{,.*}
%{_libdir}/libMagickWand-7.Q16HDRI.so.%{libsover}{,.*}
%{_libdir}/%{name}-%{Version}
%{_datadir}/%{name}-7
%exclude %{_libdir}/%{name}-%{Version}/modules-Q16HDRI/coders/djvu.*
%dir %{_sysconfdir}/%{name}-7
%config(noreplace) %{_sysconfdir}/%{name}-7/*.xml

%files devel
%{_bindir}/MagickCore-config
%{_bindir}/MagickWand-config
%{_libdir}/libMagickCore-7.Q16HDRI.so
%{_libdir}/libMagickWand-7.Q16HDRI.so
%{_libdir}/pkgconfig/MagickCore.pc
%{_libdir}/pkgconfig/MagickCore-7.Q16HDRI.pc
%{_libdir}/pkgconfig/ImageMagick.pc
%{_libdir}/pkgconfig/ImageMagick-7.Q16HDRI.pc
%{_libdir}/pkgconfig/MagickWand.pc
%{_libdir}/pkgconfig/MagickWand-7.Q16HDRI.pc
%dir %{_includedir}/%{name}-7
%{_includedir}/%{name}-7/MagickCore/
%{_includedir}/%{name}-7/MagickWand/
%{_includedir}/%{name}-7/magick
%{_includedir}/%{name}-7/wand
%{_mandir}/man1/MagickCore-config.*
%{_mandir}/man1/MagickWand-config.*

%files djvu
%{_libdir}/%{name}-%{Version}/modules-Q16HDRI/coders/djvu.*

%if %{with libheif}
%files heic
%{_libdir}/%{name}-%{Version}/modules-Q16HDRI/coders/heic.*
%endif

%files doc
%doc %{_datadir}/doc/%{name}-7

%files c++
%doc Magick++/AUTHORS
%license Magick++/LICENSE
%{_libdir}/libMagick++-7.Q16HDRI.so.%{libcxxsover}{,.*}

%files c++-devel
%doc Magick++/demo
%{_bindir}/Magick++-config
%{_includedir}/%{name}-7/Magick++/
%{_includedir}/%{name}-7/Magick++.h
%{_libdir}/libMagick++-7.Q16HDRI.so
%{_libdir}/pkgconfig/Magick++.pc
%{_libdir}/pkgconfig/Magick++-7.Q16HDRI.pc
%{_mandir}/man1/Magick++-config.*

%if %{with perl}
%files perl -f perl-pkg-files
%{_mandir}/man3/*
%doc PerlMagick/demo/ PerlMagick/Changelog PerlMagick/README.txt
%endif

%changelog
* Sat Jan 27 2024 Cristy <cristy@devel.imagemagick.org> - 7.1.1-28
-  Port of RedHat's script to create ImageMagick's RPM distribution.
