<?php
// Include the database connection file (adjust as per your setup)
include 'dbconn.php';

session_start();

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_name = $_POST['user_name'];
    $user_password = $_POST['user_password'];

    // Validate inputs
    if (empty($user_name) || empty($user_password)) {
        echo 'Please fill in all fields.';
        exit;
    }

    // Fetch the stored hashed password for the user
    $sql = "SELECT id, user_password, status, title, department FROM vtiger_users WHERE user_name = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param('s', $user_name);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            // User found, fetch the stored hashed password
            $user = $result->fetch_assoc();
            
            $id = $user['id'];
            $title = $user['title'];
            $department = $user['department'];
            $stored_hashed_password = $user['user_password'];

            // Extract the salt from the stored hashed password
            $salt = substr($stored_hashed_password, 0, 12); // Adjust based on your salt length
            $hashed_password = crypt($user_password, $salt);

            // Compare the hashed password
            if ($hashed_password === $stored_hashed_password && isset($user['status']) && $user['status'] === 'Active') {
                // User authenticated, start the session
                $_SESSION['user_name'] = $user_name;
                $_SESSION['title'] = $title;
                $_SESSION['department'] = $department;

                if($_SESSION['title'] == 'sales') {
                    header('Location: quote.php?opt=sales-home-v2');
                    exit;
                }
                else if($_SESSION['title'] == 'external') {
                    $is_mobile = preg_match('/Mobile|Android|iPhone|iPad|iPod/i', $_SERVER['HTTP_USER_AGENT']);

                    if ($is_mobile) {
                        header('Location: quote.php?opt=organizations');
                    } else {
                        header('Location: quote.php?opt=sales-home-v2');
                    }
                    exit;
                }

                header('Location: quote.php?opt=office-email');
                exit;

                if($_SESSION['title'] == 'admin') {
                    header('Location: quote.php?opt=ops-group');
                    exit;
                }
                else if($_SESSION['title'] == 'ops' || $_SESSION['title'] == 'ops/sales') {
                    header('Location: quote.php?opt=ops-group');
                    exit;
                }
                else if($_SESSION['title'] == 'sales') {
                    header('Location: quote.php?opt=sales-home');
                    exit;
                }
                else if($_SESSION['title'] == 'acc') {
                    header('Location: quote.php?opt=account');
                    exit;
                }
            } else {
                echo '<script type="text/javascript">
                    alert("Invalid username or password.");
                  </script>';
            }
        } else {
            echo '<script type="text/javascript">
                    alert("Invalid username or password.");
                  </script>';
        }
    } else {
        echo 'Database query failed: ' . $conn->error;
    }
}

include "header.php";
?>
<div class="login-container">
    <form method="post" action="login.php">
        <br><br><br><br><br><br><br><br><br><br>
        <label for="user_name">Username:</label>
        <input type="text" id="user_name" name="user_name" required>
        <br>
        <label for="user_password">Password:</label>
        <input type="password" id="user_password" name="user_password" required>
        <br>
        <input type="submit" value="Login">
    </form>
</div>
<style>
    .login-container {
        /*font-family: 'Poppins', sans-serif;*/
        /*background-color: #f0f0f0;*/
        display: flex;
        justify-content: center;
        align-items: center;
        /*height: 80vh;*/
        margin-top: 0;
    }

    form {
        /*background-color: #f0f0f0;*/
        padding: 30px;
        border-radius: 10px;
        /*box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);*/
        max-width: 400px;
        width: 100%;
    }

    label {
        font-size: 1rem;
        font-weight: 600;
        color: #333;
        display: block;
        margin-bottom: 8px;
    }

    input[type="text"],
    input[type="password"] {
        width: 100%;
        padding: 10px;
        border-radius: 5px;
        border: 1px solid #ccc;
        margin-bottom: 20px;
        font-size: 1rem;
    }

    input[type="submit"] {
        width: 100%;
        background-color: #4CAF50;
        color: white;
        padding: 10px;
        border: none;
        border-radius: 5px;
        font-size: 1rem;
        cursor: pointer;
    }

    input[type="submit"]:hover {
        background-color: #45a049;
    }

</style>
