<?php
$quoteid = $_GET['quoteid'];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['upload']) && isset($_FILES['csv_file'])) {
    include "header.php";

    $sql = "SELECT quote_no, adults, children, infants FROM vtiger_quotes WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $quote_number = $row['quote_no'];
        $adults_no = (int) $row['adults'] ?? 0;
        $children_no = (int) $row['children'] ?? 0;
        $infants_no = $row['infants'];
    }

    $file = $_FILES['csv_file']['tmp_name'];

    if (($handle = fopen($file, 'r')) !== FALSE) {
        fgetcsv($handle);
        $data = [];

        // Read CSV rows
        while (($row = fgetcsv($handle, 1000, ',')) !== FALSE) {
            $data[] = ['day' => $row[0], 'productName' => $row[1], 'city' => $row[2], 'category' => $row[3]];
        }
        fclose($handle);

        ?>
        <div id="loader">
            <p>Loading...<br><br>This may take a while</p>
        </div>
        <style>
            #loader {
                display: flex;
                justify-content: center;
                align-items: center;
                height: 50vh;
                font-size: 2em;
            }
        </style>
        <div id="content-all" style="display: none;" style="width: 100%;">
            <form action="" method="post" style="width: 50%; margin: 20px auto;">
                <script>
                    function untickOthers(rowIndex, checkbox) {
                        const checkboxes = document.querySelectorAll(`[name='selected[${rowIndex}][productid][]']`);
                        checkboxes.forEach(cb => {
                            if (cb !== checkbox) {
                                cb.checked = false;
                            }
                        });
                    }
                </script>
                <?php
                foreach ($data as $index => $entry) {
                    $day = $entry['day'];
                    $inputProductName = $entry['productName'];
                    $inputCity = $entry['city'];
                    $inputCategory = $entry['category'];

                    // Fetch all products from database
                    $sql = "SELECT p.productid, p.productName, v.vendorName, p.category, p.city, p.unitPrice, p.childPrice, p.sharingPrice, p.seats, p.keywords, p.featured, p.preferred
                            FROM tdu_products p
                            JOIN tdu_vendors v ON p.vendorid = v.vendorid
                            WHERE v.vendorActive = 'Yes' AND p.productActive = 'Yes' 
                            ORDER BY (p.seats = '') ASC, p.seats ASC;";
                    $result = mysqli_query($conn, $sql);

                    $products = [];
                    while ($row = mysqli_fetch_assoc($result)) {
                        $products[] = $row;
                    }

                    $similarities = [];
                    foreach ($products as $product) {
                        // Only calculate similarity if the city matches
                        if (strpos(strtolower(trim($product['city'])), strtolower(trim($inputCity))) !== false && (empty($inputCategory) || stripos(trim($product['category']), trim($inputCategory)) !== false)) {
                            if(strpos(strtolower(trim($inputCategory)), 'transfer') !== false) {
                                if(empty($product['seats']) || ((int) $product['seats'] < $adults_no + $children_no || (int) $product['seats'] > $adults_no + $children_no + 10)) {
                                    continue;
                                }
                            }

                            $inputProductNameLower = strtolower($inputProductName);
                            $productNameLower = strtolower($product['productName']);
                            $inputWords = preg_split('/[^a-zA-Z]+/', $inputProductNameLower, -1, PREG_SPLIT_NO_EMPTY);
                            $productWords = preg_split('/[^a-zA-Z]+/', $productNameLower, -1, PREG_SPLIT_NO_EMPTY);

                            // Determine the shorter and longer lists
                            if (count($inputWords) < count($productWords)) {
                                $shorterList = $inputWords;
                                $longerList = $productWords;
                            } else {
                                $shorterList = $productWords;
                                $longerList = $inputWords;
                            }

                            // Compare each word in the shorter list with words in the longer list
                            $matches = 0;
                            foreach ($shorterList as $shortWord) {
                                foreach ($longerList as $longWord) {
                                    $similarity = 0;
                                    similar_text(strtolower($shortWord), strtolower($longWord), $similarity);
                                    if ($similarity > 85) {
                                        $matches++;
                                        break;
                                    }
                                }
                            }
                            $productNameSimilarity = count($shorterList) > 0 ? $matches / count($shorterList) * 100 : 0;

                            // keywords check
                            $keywordSimilarity = 0;
                            if (!empty($product['keywords'])) {
                                $productKeywordsLower = strtolower(trim($product['keywords']));
                                $keywordsArray = array_map('trim', explode(',', $productKeywordsLower));
                                foreach ($keywordsArray as $keyword) {
                                    $similarity = 0;
                                    similar_text($inputProductNameLower, strtolower(trim($keyword)), $similarity);
                                    if ($similarity > 85) {
                                        $keywordSimilarity = 105;
                                        break;
                                    }
                                }
                            }                            

                            if (
                                ($index === 0 || strtolower(trim($data[$index - 1]['city'])) !== strtolower(trim($data[$index]['city']))) &&
                                strpos(strtolower(trim($inputCategory)), 'transfer') !== false
                            ) {
                                if (empty($product['keywords']) || strpos(strtolower($product['keywords']), 'inbound') === false) {
                                    continue;
                                }
                            } else if (
                                ($index === count($data) || strtolower(trim($data[$index + 1]['city'])) !== strtolower(trim($data[$index]['city']))) &&
                                strpos(strtolower(trim($inputCategory)), 'transfer') !== false
                            ) {
                                if (empty($product['keywords']) || strpos(strtolower($product['keywords']), 'outbound') === false) {
                                    continue;
                                }
                            } else {
                                if (
                                    (strpos(strtolower($product['keywords']), 'inbound') !== false) || (strpos(strtolower($product['keywords']), 'outbound') !== false)
                                ) {
                                    continue;
                                }
                            }

                            if ($productNameSimilarity + $keywordSimilarity <= 50) {
                                continue;
                            }
                    
                            $highestSimilarity = $productNameSimilarity + $keywordSimilarity + $product['featured']*200 + $product['preferred']*300;
                    
                            // Store the highest similarity for this product
                            $similarities[] = [
                                'productid' => $product['productid'],
                                'productName' => $product['productName'],
                                'vendorName' => $product['vendorName'],
                                'category' => $product['category'],
                                'city' => $product['city'],
                                'featured' => $product['featured'],
                                'preferred' => $product['preferred'],
                                'seats' => $product['seats'],
                                'unitPrice' => (float)$product['unitPrice'],
                                'childPrice' => (float)$product['childPrice'],
                                'sharingPrice' => (float)$product['sharingPrice'],
                                'similarity' => $highestSimilarity,
                                'source' => $highestSimilarity === $productNameSimilarity ? 'productName' : 'keywords'
                            ];
                        }
                    }

                    // Sort by similarity in descending order
                    usort($similarities, function ($a, $b) {
                        return $b['similarity'] <=> $a['similarity'];
                    });
                    
                    usort($similarities, function ($a, $b) {
                        return $a['seats'] <=> $b['seats'];
                    });
                    
                    // Get the top 5 matches
                    $topMatches = array_slice($similarities, 0, 5);
                    ?>
                    <h3>Day: <?= htmlspecialchars($day) ?> | <?= htmlspecialchars($inputProductName) ?></h3>
                    <table class="styled-table">
                        <tr>
                            <th></th>
                            <th></th>
                            <th style="width: 20%; text-align: left;">Product Name</th>
                            <th style="width: 20%; text-align: left;">Vendor Name</th>
                            <th style="width: 15%; text-align: left;">Category</th>
                            <th style="width: 15%; text-align: left;">City</th>
                            <th style="width: 15%; text-align: left;">Unit Price</th>
                            <th style="width: 15%; text-align: left;">Child Price</th>
                        </tr>
                        <?php foreach ($topMatches as $matchIndex => $match): ?>
                        <tr>
                            <td style="width: 5%;">
                                <input type="checkbox" name="selected[<?= $index ?>][productid][]" value="<?= $match['productid'] ?>" onclick="untickOthers(<?= $index ?>, this)" <?= $matchIndex === 0 ? "checked" : "" ?>>
                                <input type="hidden" name="selected[<?= $index ?>][day]" value="<?= htmlspecialchars($day) ?>">
                            </td>
                            <td style="width: 5%; padding: 0;">
                                <?= $match['preferred'] > 0 ? '<i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i>' : '' ?>
                                <?= $match['featured'] > 0 ? '<i class="fa-solid fa-fire" style="color: red;" title="Popular"></i>' : '' ?>
                            </td>
                            <td style="width: 20%; text-align: left;">
                                <a href="quote.php?opt=product-details&productid=<?= urlencode($match['productid']) ?>">
                                    <?= htmlspecialchars($match['productName']) ?>
                                </a>
                            </td>
                            <td style="width: 20%; text-align: left;">
                                <?= htmlspecialchars($match['vendorName']) ?>
                            </td>
                            <td style="width: 15%; text-align: left;">
                                <?= htmlspecialchars($match['category']) ?>
                            </td>
                            <td style="width: 15%; text-align: left;">
                                <?= htmlspecialchars($match['city']) ?>
                            </td>
                            <?php
                            if($match['category'] == 'Hotel') {
                                ?>
                                <td style="width: 15%; text-align: left;">
                                    $<?= number_format($match['sharingPrice'], 2) ?>
                                </td>
                                <td style="width: 15%; text-align: left;"></td>
                                <?php
                            } else {
                                ?>
                                <td style="width: 15%; text-align: left;">
                                    $<?= number_format($match['unitPrice'], 2) ?>
                                </td>
                                <td style="width: 15%; text-align: left;">
                                    $<?= number_format($match['childPrice'], 2) ?>
                                </td>
                                <?php
                            }
                            ?>
                        </tr>
                        <?php endforeach; ?>
                        <tr>
                            <td style="width: 5%;">
                                <input type="checkbox" name="selected[<?= $index ?>][productid][]" value="manual" onclick="untickOthers(<?= $index ?>, this)">
                                <input type="hidden" name="selected[<?= $index ?>][day]" value="<?= htmlspecialchars($day) ?>">
                            </td>
                            <td style="padding: 0;"></td>
                            <td colspan="6" style="text-align: left;">None of them is correct. Please get in touch with administrator</td>
                        </tr>
                    </table>
                    <br>
                    <?php
                }
                ?>
                <button type="submit" name="generate">Generate Quote</button>
            </form>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.getElementById('loader').style.display = 'none'; // Hide loader
                document.getElementById('content-all').style.display = 'block'; // Show content
            });
        </script>
        <?php
    } else {
        echo "Failed to open the file.";
    }
} 
else if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['generate'])) {
    $sql = "SELECT MAX(sequence_no) AS max_sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $sequence_no = ($row['max_sequence_no'] !== NULL) ? $row['max_sequence_no'] : 0;
    } else {
        echo "Error: " . mysqli_error($conn);
    }

    // $cfByProductID = getCFByProductID($conn);
    $selectedData = $_POST['selected'];

    $sql = "SELECT quote_no, adults, children, infants FROM vtiger_quotes WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $quote_number = $row['quote_no'];
        $adults_no = $row['adults'];
        $children_no = $row['children'];
        $infants_no = $row['infants'];
    }
    foreach ($selectedData as $index => $selection) {
        $day = mysqli_real_escape_string($conn, $selection['day']);
        $productIds = $selection['productid'];

        $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid';";
        $result = mysqli_query($conn, $sql);
        if ($result) {
            $row = mysqli_fetch_assoc($result);
            $cf_1162 = $row['cf_1162']; // yyyy-mm-dd format

            $date = new DateTime($cf_1162);
            $date->modify('+' . ((int) $day - 1) . ' days');
            $activity_date = $date->format('Y-m-d');
        }

        // Check if it's a manual entry
        if (!isset($productIds) || in_array('manual', $productIds)) {
            // Handle the manual entry logic here if needed
            continue;
        }

        // Process each selected product ID
        foreach ($productIds as $productid) {
            $productid = (int)$productid;
            
            $sql = "SELECT unitPrice, childPrice, sharingPrice, category, vendorid FROM tdu_products WHERE productid='$productid';";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $vendorid = $row['vendorid'];
                $cf_928 = $row['category'];
                
                $row_dynamic = fetchDynamicPrice($conn, $productid, $activity_date);
                if($row['category'] == 'Hotel') {
                    $price = (float) $row_dynamic['sharingPrice'];
                } else {
                    $price = (float) $row_dynamic['unitPrice'];
                }
                $child_price = (float) $row_dynamic['childPrice'];
                $infant_price = (float) $row_dynamic['infantPrice'];

                $surcharge = getSurchargeForDate($conn, $productid, $activity_date);
                $price += $surcharge;
                $child_price += $surcharge;
            }

            // Insert into vtiger_inventoryproductrel
            $sequence_no++;
            $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no) 
                            VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no')";
            mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));

            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'adults', '$adults_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'children', '$children_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'infants', '$infants_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

            // Step 1: Get the current max display_order for the given quoteid
            $query = "SELECT COALESCE(MAX(display_order), 0) + 1 AS new_display_order 
                    FROM vtiger_display_order 
                    WHERE id = '$quoteid'";
            $result = mysqli_query($conn, $query);

            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $new_display_order = $row['new_display_order'];

                // Step 2: Insert the new record with the calculated display_order
                $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                            VALUES ('$quoteid', '$sequence_no', '$new_display_order')";

                mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
            } 

            if($cf_928 == 'Transfers') {
                $existing_subquoteid_query = "SELECT DISTINCT subquoteid, pax_min, pax_max FROM vtiger_products_saleprice WHERE quoteid = '$quoteid' AND cf_928 = '$cf_928';";
                $existing_subquoteid_result = mysqli_query($conn, $existing_subquoteid_query);

                $existing_subquoteids = [];
                $pax_values = [];

                while ($row = mysqli_fetch_assoc($existing_subquoteid_result)) {
                    $existing_subquoteids[] = $row['subquoteid'];
                    $pax_values[$row['subquoteid']] = [
                        'pax_min' => $row['pax_min'],
                        'pax_max' => $row['pax_max']
                    ];
                }

                if(mysqli_num_rows($existing_subquoteid_result) > 0) {
                    foreach ($existing_subquoteids as $subquoteid) {
                        // Get the pax_min and pax_max for the current subquoteid
                        $pax_min = $pax_values[$subquoteid]['pax_min'];
                        $pax_max = $pax_values[$subquoteid]['pax_max'];
                        
                        $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, pax_min, pax_max) 
                                        VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', '$subquoteid', '$price', '$pax_min', '$pax_max')
                                        ON DUPLICATE KEY UPDATE sale_price = '$price', pax_min = VALUES(pax_min), pax_max = VALUES(pax_max), updated_at = NOW()";
                        mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                    }
                }

                else {
                    $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price) 
                                    VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 0, '$price')
                                    ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                    mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                }
            }
            else {
                $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_child)  
                                VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '$price', '$child_price')
                                ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
            }
        }
    }
    $insert_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                    VALUES ('$quoteid', '$username', 'Import CSV - Products', NOW())";
    mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

    header("Location: quote.php?opt=summary&quoteNumber=$quote_number");
    exit();
}
else {
    include "header.php";
    ?>
    <div style="margin: 20px auto; width: 50%; padding: 20px; border: 1px solid #ccc; border-radius: 10px; background-color: #f9f9f9; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <h1 style="text-align: center;">Products Quick Upload</h1><br>
        <form action="" method="post" enctype="multipart/form-data">
            <label for="csv_file">Choose CSV File:</label><br><br>
            <a href="vendor_uploads/activities-import-template.csv" download>Download Template</a><br><br>
            <input type="file" name="csv_file" id="csv_file" accept=".csv" required style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; box-sizing: border-box;"><br><br>
            <button type="submit" name="upload" style="width: 100%; padding: 10px; border: none; font-size: 16px; border-radius: 5px; cursor: pointer; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
                Upload and Process
            </button>
        </form>
    </div>
    <?php
}
?>
