<?php
// qbo_ajax_fetch_all_customer_pnl.php
// New, efficient backend to fetch P&L data for ALL customers in a single server-side run.

header('Content-Type: application/json');
set_time_limit(300); // Allow script to run for up to 5 minutes

require_once __DIR__ . '/qbo_bootstrap.php';
use QuickBooksOnline\API\ReportService\ReportService;

if (!$qboUtil) {
    echo json_encode(['success' => false, 'error' => 'QBO Connection Not Established']);
    exit;
}

$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;
$accountingMethod = $_GET['accounting_method'] ?? 'Accrual';

if (!$startDate || !$endDate) {
    echo json_encode(['success' => false, 'error' => 'Start and End dates are required.']);
    exit;
}

$reportData = [];

try {
    // Step 1: Get the complete list of all active customers using pagination
    $allCustomers = [];
    $startPosition = 1;
    while (true) {
        $query = "SELECT Id, DisplayName FROM Customer WHERE Active = true ORDERBY DisplayName ASC STARTPOSITION {$startPosition} MAXRESULTS 1000";
        $customerBatch = $qboUtil->getDataService()->Query($query);
        if (empty($customerBatch)) break;
        $allCustomers = array_merge($allCustomers, $customerBatch);
        $startPosition += count($customerBatch);
    }

    // Step 2: Loop through customers on the server and fetch P&L for each one
    $reportService = new ReportService($qboUtil->getDataService()->getServiceContext());
    $reportService->setStartDate($startDate);
    $reportService->setEndDate($endDate);
    $reportService->setAccountingMethod($accountingMethod);

    foreach ($allCustomers as $customer) {
        $reportService->setCustomer($customer->Id);
        $pnlReport = $reportService->executeReport("ProfitAndLoss");
        
        $income = 0;
        
        if ($pnlReport && isset($pnlReport->Rows, $pnlReport->Rows->Row)) {
            foreach ($pnlReport->Rows->Row as $row) {
                if (isset($row->Summary->ColData) && ($row->Summary->ColData[0]->value ?? '') === 'Total Income') {
                    $income = (float)($row->Summary->ColData[1]->value ?? 0);
                    break;
                }
            }
        }
        
        if ($income != 0) {
            $reportData[] = [
                'id' => $customer->Id,
                'name' => $customer->DisplayName,
                'income' => $income
            ];
        }
    }
    
    echo json_encode(['success' => true, 'data' => $reportData]);

} catch (Exception $e) {
    error_log("Error in qbo_ajax_fetch_all_customer_pnl.php: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}