<?php
// qbo_ajax_fetch_customer_list.php
// This is a new file required for the dynamic report instances.
// It takes a date range and returns a JSON list of customers with sales in that period.

header('Content-Type: application/json');

// Bootstrap the QBO connection
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/qbo_functions.php';
require_once __DIR__ . '/config/qbo_config.php';

use QuickBooksOnline\API\Core\OAuth\OAuth2\OAuth2LoginHelper;
use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\ReportService\ReportService;

global $qboBaseConfig;
$dataService = null;

$tokenStorageFile = __DIR__ . '/tokens/qbo_token.json';
$currentTokens = file_exists($tokenStorageFile) ? json_decode(file_get_contents($tokenStorageFile), true) : null;

if (!$currentTokens || empty($currentTokens['refresh_token'])) {
    echo json_encode(['success' => false, 'error' => 'Authentication token not found.']);
    exit;
}

try {
    $oauth2LoginHelper = new OAuth2LoginHelper($qboBaseConfig['ClientID'], $qboBaseConfig['ClientSecret']);
    $refreshedAccessTokenObj = $oauth2LoginHelper->refreshAccessTokenWithRefreshToken($currentTokens['refresh_token']);
    $newAccessToken = $refreshedAccessTokenObj->getAccessToken();
    $newRefreshToken = $refreshedAccessTokenObj->getRefreshToken();

    if ($newAccessToken && $newRefreshToken) {
        file_put_contents($tokenStorageFile, json_encode(['access_token' => $newAccessToken, 'refresh_token' => $newRefreshToken], JSON_PRETTY_PRINT));
        $qboBaseConfig['accessTokenKey'] = $newAccessToken;
    } else {
         throw new Exception("Failed to refresh tokens.");
    }

    $qboBaseConfig['auth_mode'] = 'oauth2';
    $dataService = DataService::Configure($qboBaseConfig);

} catch (Exception $e) {
    error_log("AJAX Customer List Error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'QBO Connection failed during token refresh.']);
    exit;
}

// --- Get Parameters ---
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;

if (!$startDate || !$endDate) {
    echo json_encode(['success' => false, 'error' => 'Start and End date parameters are required.']);
    exit;
}

// --- Fetch Customer List ---
$customerList = [];
if ($dataService) {
    try {
        $reportService = new ReportService($dataService->getServiceContext());
        $reportService->setStartDate($startDate);
        $reportService->setEndDate($endDate);
        $report = $reportService->executeReport("CustomerSales");

        if ($report && isset($report->Rows->Row)) {
            $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
            foreach ($rows as $row) {
                if (isset($row->ColData) && !isset($row->Summary)) {
                    $salesTotal = (float)($row->ColData[1]->value ?? 0);
                    if ($salesTotal != 0) {
                        $customerList[] = [
                            'id' => $row->ColData[0]->id, 
                            'name' => $row->ColData[0]->value
                        ];
                    }
                }
            }
        }
    } catch (Exception $e) {
        error_log("Failed to fetch customer list via AJAX: " . $e->getMessage());
        echo json_encode(['success' => false, 'error' => 'Failed to execute QBO report.']);
        exit;
    }
}

echo json_encode(['success' => true, 'data' => $customerList]);