<?php
// qbo_ajax_fetch_sales_detail.php
// VERSION 21.0 - FINAL: Passes both total amount and unit price.

header('Content-Type: application/json');
require_once __DIR__ . '/qbo_bootstrap.php';

if (!$qboUtil) {
    echo json_encode(['success' => false, 'error' => 'Bootstrap failed']);
    exit;
}

// --- Get Parameters from the AJAX Request ---
$customerId = $_GET['customer_id'] ?? null;
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;
$selectedProductServices = $_GET['product_service'] ?? [];

if (!$customerId || !$startDate || !$endDate) {
    echo json_encode(['success' => false, 'error' => 'Missing required parameters']);
    exit;
}

// --- Initialize Variables ---
$processedTransactions = [];
$customerTotalAmount = 0.00;
$customerTotalQuantity = 0;

try {
    $dataService = $qboUtil->getDataService();
    
    $invoiceQuery = "SELECT * FROM Invoice WHERE CustomerRef = '{$customerId}' AND TxnDate >= '{$startDate}' AND TxnDate <= '{$endDate}'";
    $transactions = $dataService->Query($invoiceQuery) ?: [];

    if (empty($transactions)) {
        echo json_encode(['success' => true, 'total' => 0.00, 'quantity' => 0, 'data' => []]);
        exit;
    }

    $itemIdsToFetch = [];
    $classIdsToFetch = [];
    foreach ($transactions as $txn) {
        if (empty($txn->Line)) continue;
        foreach ($txn->Line as $line) {
            if (isset($line->DetailType) && $line->DetailType === 'SalesItemLineDetail') {
                if (!empty($line->SalesItemLineDetail->ItemRef)) {
                    $itemIdsToFetch[] = $line->SalesItemLineDetail->ItemRef;
                }
                if (!empty($line->SalesItemLineDetail->ClassRef)) {
                    $classIdsToFetch[] = $line->SalesItemLineDetail->ClassRef;
                }
            }
        }
    }
    
    $itemIdToNameMap = [];
    if (!empty($itemIdsToFetch)) {
        $uniqueItemIds = array_unique($itemIdsToFetch);
        $idString = "('" . implode("','", $uniqueItemIds) . "')";
        $itemQuery = "SELECT Id, Name FROM Item WHERE Id IN {$idString}";
        $items = $dataService->Query($itemQuery);
        if ($items) {
            foreach ($items as $item) {
                $itemIdToNameMap[$item->Id] = $item->Name;
            }
        }
    }

    $classIdToNameMap = [];
    if (!empty($classIdsToFetch)) {
        $uniqueClassIds = array_unique($classIdsToFetch);
        $idString = "('" . implode("','", $uniqueClassIds) . "')";
        $classQuery = "SELECT Id, Name FROM Class WHERE Id IN {$idString}";
        $classes = $dataService->Query($classQuery);
        if ($classes) {
            foreach ($classes as $class) {
                $classIdToNameMap[$class->Id] = $class->Name;
            }
        }
    }

    $lowercaseSelectedServices = array_map('strtolower', $selectedProductServices);

    foreach ($transactions as $txn) {
        if (empty($txn->Line)) continue;
        
        $docNumber = $txn->DocNumber ?: 'ID: ' . $txn->Id;
        $txnType = 'Invoice';

        foreach ($txn->Line as $line) {
            if (isset($line->DetailType) && $line->DetailType === 'SalesItemLineDetail' && !empty($line->SalesItemLineDetail->ItemRef)) {
                $itemId = $line->SalesItemLineDetail->ItemRef;
                $itemName = $itemIdToNameMap[$itemId] ?? 'Unknown Item';
                
                if (!empty($lowercaseSelectedServices) && !in_array(strtolower($itemName), $lowercaseSelectedServices)) {
                    continue; 
                }

                $classId = $line->SalesItemLineDetail->ClassRef;
                $className = isset($classIdToNameMap[$classId]) ? $classIdToNameMap[$classId] : '';

                $lineAmount = (float)($line->Amount ?? 0);
                $lineQty = (int)($line->SalesItemLineDetail->Qty ?? 0);
                // FIX: Get the UnitPrice and pass it as sales_price
                $salesPrice = (float)($line->SalesItemLineDetail->UnitPrice ?? 0);
                
                $processedTransactions[] = [
                    'date'          => $txn->TxnDate,
                    'type'          => $txnType,
                    'num'           => $docNumber,
                    'class'         => $className,
                    'product_service' => $itemName,
                    'qty'           => $lineQty,
                    'amount'        => $lineAmount, // Total line amount
                    'sales_price'   => $salesPrice   // Per-unit sales price
                ];
                $customerTotalAmount += $lineAmount;
                $customerTotalQuantity += $lineQty;
            }
        }
    }
    
} catch (Exception $e) {
    error_log("AJAX Error for Customer {$customerId}: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'API Error']);
    exit;
}

echo json_encode([
    'success' => true, 
    'total' => $customerTotalAmount,
    'quantity' => $customerTotalQuantity,
    'data' => $processedTransactions
]);