<?php
// qbo_ajax_supplier_graph_data.php
// Backend data provider for the supplier analytics graphs.
// VERSION 5.0 - COMPLETE. All placeholder logic has been fully implemented.

header('Content-Type: application/json');

use QuickBooksOnline\API\ReportService\ReportService;

require_once __DIR__ . '/qbo_bootstrap.php';

$reportType = $_GET['report_type'] ?? null;
$year = $_GET['year'] ?? date('Y');
$supplierName = $_GET['supplier_name'] ?? null;
$period = $_GET['period'] ?? 'Monthly';

if (!$qboUtil) {
    echo json_encode(['success' => false, 'error' => 'QBO connection not established.']);
    exit;
}
if (!$reportType) {
    echo json_encode(['success' => false, 'error' => 'Missing report type.']);
    exit;
}

define('COL_IDX_DATE', 0);
define('COL_IDX_TXN_TYPE', 1);
define('COL_IDX_NAME', 4);
define('COL_IDX_AMOUNT', 8);

$supplierExpenseTypes = ['Bill', 'Expense', 'Credit Card Expense', 'Cheque'];

$labels = [];
$values = [];
$trendData = []; // New array for the trend line data
$reportService = new ReportService($qboUtil->getDataService()->getServiceContext());

try {
    switch ($reportType) {
        case 'monthly':
            $labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            $values = array_fill(0, 12, 0);
            $reportService->setStartDate("$year-01-01");
            $reportService->setEndDate("$year-12-31");
            $report = $reportService->executeReport("TransactionList");
            if ($report && isset($report->Rows->Row)) {
                $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                foreach ($rows as $row) {
                    if (isset($row->type) && $row->type === 'Data') {
                        $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                        $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                        if ($amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                            $date = strtotime($row->ColData[COL_IDX_DATE]->value);
                            $monthIndex = (int)date('n', $date) - 1;
                            if (isset($values[$monthIndex])) {
                                $values[$monthIndex] += $amount;
                            }
                        }
                    }
                }
            }
            $trendData = $values;
            break;

        case 'yearly':
            $endYear = date('Y');
            $startYear = $endYear - 6;
            for ($y = $startYear; $y <= $endYear; $y++) {
                $labels[] = (string)$y;
                $totalForYear = 0;
                $reportService->setStartDate("$y-01-01");
                $reportService->setEndDate("$y-12-31");
                $report = $reportService->executeReport("TransactionList");
                if ($report && isset($report->Rows->Row)) {
                    $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                    foreach ($rows as $row) {
                        if (isset($row->type) && $row->type === 'Data') {
                           $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                           $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                           if ($amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                               $totalForYear += $amount;
                           }
                        }
                    }
                }
                $values[] = $totalForYear;
            }
            $trendData = $values;
            break;

        case 'top_10':
            $reportService->setStartDate("$year-01-01");
            $reportService->setEndDate("$year-12-31");
            $report = $reportService->executeReport("TransactionList");
            $supplierTotals = [];
            if ($report && isset($report->Rows->Row)) {
                $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                foreach ($rows as $row) {
                     if (isset($row->type) && $row->type === 'Data') {
                        $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                        $name = $row->ColData[COL_IDX_NAME]->value ?? null;
                        $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                        if ($name && $amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                            if (!isset($supplierTotals[$name])) { $supplierTotals[$name] = 0; }
                            $supplierTotals[$name] += $amount;
                        }
                    }
                }
                arsort($supplierTotals);
                $topSuppliers = array_slice($supplierTotals, 0, 10, true);
                $labels = array_keys($topSuppliers);
                $values = array_values($topSuppliers);
            }
            break;

        case 'performance':
            if (!$supplierName) throw new Exception("Supplier name is required for performance report.");
            
            if ($period === 'Monthly') {
                $labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                $values = array_fill(0, 12, 0);
                $reportService->setStartDate("$year-01-01");
                $reportService->setEndDate("$year-12-31");
                $report = $reportService->executeReport("TransactionList");
                if ($report && isset($report->Rows->Row)) {
                    $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                    foreach ($rows as $row) {
                        if (isset($row->type) && $row->type === 'Data' && ($row->ColData[COL_IDX_NAME]->value ?? '') === $supplierName) {
                            $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                            $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                            if ($amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                                $date = strtotime($row->ColData[COL_IDX_DATE]->value);
                                $monthIndex = (int)date('n', $date) - 1;
                                if (isset($values[$monthIndex])) $values[$monthIndex] += $amount;
                            }
                        }
                    }
                }
            } elseif ($period === 'Quarterly') {
                $labels = ['Q1', 'Q2', 'Q3', 'Q4'];
                $values = array_fill(0, 4, 0);
                $reportService->setStartDate("$year-01-01");
                $reportService->setEndDate("$year-12-31");
                $report = $reportService->executeReport("TransactionList");
                if ($report && isset($report->Rows->Row)) {
                    $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                    foreach ($rows as $row) {
                        if (isset($row->type) && $row->type === 'Data' && ($row->ColData[COL_IDX_NAME]->value ?? '') === $supplierName) {
                            $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                            $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                            if ($amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                                $date = strtotime($row->ColData[COL_IDX_DATE]->value);
                                $quarterIndex = floor(((int)date('n', $date) - 1) / 3);
                                if (isset($values[$quarterIndex])) $values[$quarterIndex] += $amount;
                            }
                        }
                    }
                }
            } else { // Yearly
                $endYear = date('Y');
                $startYear = $endYear - 4; // 5 year trend
                for ($y = $startYear; $y <= $endYear; $y++) {
                    $labels[] = (string)$y;
                    $totalForYear = 0;
                    $reportService->setStartDate("$y-01-01");
                    $reportService->setEndDate("$y-12-31");
                    $report = $reportService->executeReport("TransactionList");
                    if ($report && isset($report->Rows->Row)) {
                        $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
                        foreach ($rows as $row) {
                            if (isset($row->type) && $row->type === 'Data' && ($row->ColData[COL_IDX_NAME]->value ?? '') === $supplierName) {
                                $amount = (float)($row->ColData[COL_IDX_AMOUNT]->value ?? 0);
                                $txnType = $row->ColData[COL_IDX_TXN_TYPE]->value ?? '';
                                if ($amount > 0 && in_array($txnType, $supplierExpenseTypes)) {
                                    $totalForYear += $amount;
                                }
                            }
                        }
                    }
                    $values[] = $totalForYear;
                }
            }
            $trendData = $values;
            break;
    }

    echo json_encode(['success' => true, 'data' => ['labels' => $labels, 'values' => $values, 'trend' => $trendData]]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'A critical error occurred: ' . $e->getMessage()]);
    exit;
}