<?php
// qbo_quotes_table.php
// Corrected logic based on proven tests.

function generateConfirmedQuotesTable($filters, $conn) {
    if (!$conn) {
        return "<tr><td colspan='5' style='color:red;'>Database connection failed.</td></tr>";
    }

    $start_date = $filters['start_date'];
    $end_date = $filters['end_date'];
    
    $confirmed_stages = ['Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers', 'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'];
    $escaped_stages = array_map([$conn, 'real_escape_string'], $confirmed_stages);
    $confirmed_stages_sql_in = "('" . implode("','", $escaped_stages) . "')";

    $unique_quotes_subquery = "(
        SELECT inner_vq.quoteid, inner_vq.created_at, inner_vq.deleted, inner_vq.quote_no,
        inner_vq.quotestage, inner_vq.no_pax, inner_vq.country, inner_vq.subject, inner_vq.contactid
        FROM vtiger_quotes inner_vq
        WHERE inner_vq.quoteid = (
            SELECT MIN(sub.quoteid) FROM vtiger_quotes AS sub WHERE sub.quote_no = inner_vq.quote_no AND sub.deleted = 0
        )
    ) vq";

    $sql = "SELECT 
                vq.quote_no, 
                vq.created_at,
                o.organization_name,
                vqinfo.assigned_to_region,
                COALESCE(vq.no_pax, 0) AS no_pax
            FROM " . $unique_quotes_subquery . "
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            LEFT JOIN tdu_contacts c ON c.auto_id = vq.contactid
            LEFT JOIN tdu_organisation o ON o.organizationid = c.organizationid
            WHERE vq.deleted = 0 
            AND vq.quotestage IN " . $confirmed_stages_sql_in . "
            AND vq.created_at BETWEEN '" . $conn->real_escape_string($start_date) . " 00:00:00' AND '" . $conn->real_escape_string($end_date) . " 23:59:59'
            ORDER BY vq.created_at DESC";

    $result = $conn->query($sql);
    
    $html_output = '';
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $html_output .= "<tr>
                                <td>" . htmlspecialchars($row['quote_no']) . "</td>
                                <td>" . htmlspecialchars($row['organization_name']) . "</td>
                                <td>" . htmlspecialchars($row['assigned_to_region']) . "</td>
                            </tr>";
        }
    } else {
        $html_output = "<tr><td colspan='3'>No confirmed quotes found for the selected date range.</td></tr>";
    }

    return $html_output;
}
?>