<?php
// qbo_reports.php
// VERSION 3.2 - FINAL LAYOUT: Fixes the disappearing menu button.

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "header.php";

if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    echo "<div style='padding: 20px;'>Access Denied. Please log in as an administrator.</div>";
    exit();
}

$uid = 'qbo_comp_' . uniqid();
$currentView = $_GET['view'] ?? 'reports';
$reportType = isset($_GET['report']) ? $_GET['report'] : null;

// --- Dynamic Page Title ---
$pageTitle = "QBO Reports";
if ($currentView === 'reports') {
    if ($reportType === 'ap') { $pageTitle = "QBO A/P Ageing Report"; }
    elseif ($reportType === 'ar') { $pageTitle = "QBO A/R Ageing Report"; }
    elseif ($reportType === 'pl_report') { $pageTitle = "QBO P&L Report"; }
    elseif ($reportType === 'pl_by_month') { $pageTitle = "QBO P&L by Month Report"; }
    elseif ($reportType === 'income_by_customer') { $pageTitle = "Income by Customer Summary"; }
    elseif ($reportType === 'sales_by_customer_detail') { $pageTitle = "Sales by Customer Detail"; }
    elseif ($reportType === 'sales_revenue') { $pageTitle = "Sales & Revenue Report"; }
    elseif (in_array($reportType, ['supplier_expense', 'supplier_expense_detail', 'supplier_cost'])) { $pageTitle = "Supplier Reports"; }
} else {
    $pageTitle = "QBO Graphs";
    if ($reportType === 'supplier_graph') { $pageTitle = "Supplier Expense Analysis"; }
    if ($reportType === 'pnl_graph') { $pageTitle = "P&L Graph by Month"; }
}
?>
<title><?php echo htmlspecialchars($pageTitle); ?></title>
<style>
    :root {
        --header-height: 72px; /* Adjust this to your exact header height */
    }
    
    /* MODIFIED: Set a base font-family for the entire component for consistency */
    .qbo-component-wrapper {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    }

    .qbo-component-wrapper .sidebar {
        top: var(--header-height);
        height: calc(100vh - var(--header-height));
        width: 250px;
        position: fixed;
        z-index: 1000;
        left: 0;
        background-color: #343a40;
        overflow-y: auto;
        overflow-x: hidden;
        transition: left 0.3s;
        display: flex;
        flex-direction: column;
        padding-top: 20px;
    }
    .qbo-component-wrapper .main-content {
        margin-left: 250px;
        padding: 20px;
        transition: margin-left 0.3s;
    }

    .qbo-component-wrapper.sidebar-closed .sidebar {
        left: -250px;
    }
    .qbo-component-wrapper.sidebar-closed .main-content {
        margin-left: 0;
    }
    
    .qbo-component-wrapper .open-btn {
        position: fixed;
        top: calc(var(--header-height) + 15px);
        left: 15px;
        z-index: 1001;
        background-color: #343a40;
        border: none;
        color: white;
        cursor: pointer;
        padding: 10px 15px;
        border-radius: 5px;
        /* MODIFIED: Standardized font size */
        font-size: 20px; 
    }
    
    .qbo-component-wrapper .report-header { padding-top: 20px; }
    /* MODIFIED: Standardized font sizes for headers */
    .qbo-component-wrapper .report-header h2 { font-size: 28px; }
    .qbo-component-wrapper .report-header h3 { font-size: 22px; }
    .qbo-component-wrapper .report-header h2, .qbo-component-wrapper .report-header h3 { margin-bottom: 5px; color: #333; }
    .qbo-component-wrapper .report-header p { margin-top: 0; color: #666; font-size: 16px; }

    .qbo-component-wrapper .filter-form { background-color: #fff; padding: 15px; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); display: flex; gap: 15px; align-items: center; flex-wrap: wrap; }
    .qbo-component-wrapper .sidebar-header { padding: 10px 15px; text-align: center; color: #f8f9fa; border-bottom: 1px solid #495057; margin-bottom: 10px;}
    
    /* MODIFIED: Standardized font size */
    .qbo-component-wrapper .sidebar-header strong { 
        font-size: 19px; 
    }
    
    /* MODIFIED: Standardized font size */
    .qbo-component-wrapper .sidebar a { 
        padding: 10px 15px; 
        text-decoration: none; 
        color: #adb5bd; 
        display: block; 
        transition: 0.2s; 
        border-radius: 4px; 
        margin: 2px 10px; 
        font-size: 16px; 
    }

    .qbo-component-wrapper .sidebar a:hover, .qbo-component-wrapper .sidebar a.active { color: #f8f9fa; background-color: #495057; }
    
    /* MODIFIED: Standardized font size and removed !important */
    .qbo-component-wrapper .view-toggle { 
        display: block; 
        background-color: #007bff; 
        color: white; 
        text-align: center; 
        padding: 8px; 
        margin: 15px; 
        border-radius: 5px; 
        font-size: 14px; 
        text-decoration: none; /* Add this to ensure it behaves like a link */
    }
    .qbo-component-wrapper .view-toggle:hover { background-color: #0056b3; color: white; }

    .qbo-component-wrapper table { border-collapse: collapse; width: 100%; margin-bottom: 30px; background-color: #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden; }
    .qbo-component-wrapper th, .qbo-component-wrapper td { border: 1px solid #ddd; padding: 10px 12px; text-align: left; }
    .qbo-component-wrapper th { background-color: #f7f7f7; color: #555; font-weight: 600; }
    .qbo-component-wrapper td.currency, .qbo-component-wrapper th.currency { text-align: right; }
    .qbo-component-wrapper .total-row td, .qbo-component-wrapper tfoot td { font-weight: bold; background-color: #f2f2f2; border-top: 2px solid #ccc; }
    .qbo-component-wrapper .no-data-message { text-align: center; padding: 20px; color: #555; font-style: italic; }
    .qbo-component-wrapper .sub-row td { background-color: #fafafa; padding-left: 40px !important; }
</style>

<div id="<?php echo htmlspecialchars($uid); ?>" class="qbo-component-wrapper">
    <!-- MOVED: The button is now a direct child of the wrapper, NOT the sidebar. -->
    <button class="open-btn" onclick="toggleNav_<?php echo $uid; ?>()">☰</button>

    <nav id="<?php echo htmlspecialchars($uid . '_sidebar'); ?>" class="sidebar">
        <div class="sidebar-header">
            <strong><?php echo $currentView === 'reports' ? 'QBO Reports' : 'QBO Graphs'; ?></strong>
            <?php if ($currentView === 'reports'): ?>
                <a href="?view=graphs" class="view-toggle">Switch to Graphs</a>
            <?php else: ?>
                <a href="?view=reports" class="view-toggle">Switch to Reports</a>
            <?php endif; ?>
        </div>

        <?php if ($currentView === 'reports'): ?>
            <?php if($title == 'admin'): ?>
                <a href="?report=income_by_customer" class="<?php echo ($reportType === 'income_by_customer' ? 'active' : ''); ?>">Income by Customer</a>
                <a href="?report=sales_by_customer_detail" class="<?php echo ($reportType === 'sales_by_customer_detail' ? 'active' : ''); ?>">Sales by Customer Detail</a>
            <?php endif; ?>
            <?php if($_SESSION['user_name'] == 'abhisheks' || $_SESSION['user_name'] == 'jobm' || $_SESSION['user_name'] == 'intern'): ?>
                <a href="?report=pl_by_month" class="<?php echo ($reportType === 'pl_by_month' ? 'active' : ''); ?>">P&L by Month</a>
                <a href="?report=pl_report" class="<?php echo ($reportType === 'pl_report' ? 'active' : ''); ?>">Profit & Loss</a>
                <a href="?report=sales_revenue" class="<?php echo ($reportType === 'sales_revenue' ? 'active' : ''); ?>">Sales & Revenue</a>
                <a href="?report=supplier_cost" class="<?php echo ($reportType === 'supplier_cost' ? 'active' : ''); ?>">Supplier Cost Report</a>
                <a href="?report=supplier_expense" class="<?php echo (in_array($reportType, ['supplier_expense', 'supplier_expense_detail']) ? 'active' : ''); ?>">Expenses by Supplier</a>
                <a href="?report=ar" class="<?php echo ($reportType === 'ar' ? 'active' : ''); ?>">A/R Ageing</a>
                <a href="?report=ap" class="<?php echo ($reportType === 'ap' ? 'active' : ''); ?>">A/P Ageing</a>
            <?php endif; ?>
        <?php else: ?>
            <?php if($_SESSION['user_name'] == 'abhisheks' || $_SESSION['user_name'] == 'jobm' || $_SESSION['user_name'] == 'intern'): ?>
                <a href="?view=graphs&report=pnl_graph" class="<?php echo ($reportType === 'pnl_graph' ? 'active' : ''); ?>">P&L Graph</a>
                <a href="?view=graphs&report=supplier_graph" class="<?php echo ($reportType === 'supplier_graph' ? 'active' : ''); ?>">Supplier Expense Analysis</a>
            <?php endif; ?>
        <?php endif; ?>
    </nav>

    <div id="<?php echo htmlspecialchars($uid . '_main'); ?>" class="main-content">
        <?php
        if ($currentView === 'reports') {
            if ($reportType) {
                $report_file = 'qbo_' . str_replace(' ', '_', $reportType) . '_report.php';
                if (file_exists($report_file)) { include $report_file; } 
                else {
                     echo '<div class="report-header"><h2>Report Not Found</h2></div><p class="no-data-message">The selected report could not be found.</p>';
                }
            } else {
                echo '<div class="report-header"><h2>Welcome to QuickBooks Online Reports</h2></div><p class="no-data-message">Please select a report from the menu to get started.</p>';
            }
        } else {
            if ($reportType) {
                $graph_file = 'qbo_' . str_replace(' ', '_', $reportType) . '_report.php';
                 if (file_exists($graph_file)) { include $graph_file; }
                 else {
                     echo '<div class="report-header"><h2>Graph Not Found</h2></div><p class="no-data-message">The selected graph could not be found.</p>';
                }
            } else {
                echo '<div class="report-header"><h2>Welcome to QuickBooks Online Graphs</h2></div><p class="no-data-message">Please select a graph from the menu to get started.</p>';
            }
        }
        ?>
    </div>
</div>

<script>
    function toggleNav_<?php echo $uid; ?>() {
        const wrapper = document.getElementById('<?php echo $uid; ?>');
        if (wrapper) {
            wrapper.classList.toggle('sidebar-closed');
        }
    }

    // MODIFIED: This logic now opens the sidebar on desktop and closes it on mobile.
    document.addEventListener('DOMContentLoaded', function() {
        const wrapper = document.getElementById('<?php echo $uid; ?>');
        if (wrapper) {
            if (window.innerWidth > 768) {
                // On larger screens, start with the sidebar OPEN.
                wrapper.classList.remove('sidebar-closed');
            } else {
                // On smaller screens, start with the sidebar CLOSED.
                wrapper.classList.add('sidebar-closed');
            }
        }
    });
</script>