<?php
// qbo_test_trigger.php
// Simpler web interface to trigger and get basic feedback from QBO sync.

ini_set('display_errors', 1);
error_reporting(E_ALL);
include_once __DIR__ . "/header.php"; // Assuming header.php might apply body styles

// Attempt to increase execution time - may or may not be respected by server config
set_time_limit(300); // Try for 5 minutes

$feedback_output = [];
$quote_no_processed = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quote_no'])) {
    $quote_no_to_process = trim($_POST['quote_no']);
    $quote_no_processed = $quote_no_to_process;

    if (!empty($quote_no_to_process)) {
        if (preg_match('/^[a-zA-Z0-9\-]+$/', $quote_no_to_process)) {
            $php_executable = 'php'; 
            // Adjusted path: Assuming 'cronjob' is a subdirectory relative to this file's location
            $cronjob_script_path = __DIR__ . '/cronjob/cronjob_qbo_processing.php'; 

            if (!file_exists($cronjob_script_path)) {
                $error_message = "Error: Cronjob script not found at: " . htmlspecialchars($cronjob_script_path);
            } else {
                $sanitized_quote_no_arg = escapeshellarg($quote_no_to_process);
                $command = $php_executable . ' ' . $cronjob_script_path . ' ' . $sanitized_quote_no_arg;

                $feedback_output[] = "Processing started for Quote No: " . htmlspecialchars($quote_no_to_process) . "...";
                
                $handle = popen($command . ' 2>&1', 'r'); 
                if ($handle) {
                    while (!feof($handle)) {
                        $line = fgets($handle);
                        if ($line !== false) {
                            $feedback_output[] = htmlspecialchars(trim($line));
                        }
                    }
                    $status = pclose($handle);
                    if ($status === 0) {
                        $feedback_output[] = "Processing finished successfully.";
                    } else {
                        $feedback_output[] = "Processing finished with errors (Exit status: $status). Check qbo_cli_cron.log in the cronjob directory for details.";
                    }
                } else {
                    $error_message = "Error: Could not execute the sync process. Check server permissions and PHP configuration.";
                }
            }
        } else {
            $error_message = "Error: Invalid Quote Number format.";
        }
    } else {
        $error_message = "Error: Quote Number cannot be empty.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QBO Sync Test Trigger</title>
    <style>
        /* Unique container ID for scoping styles */
        #qboTestTriggerContainer { 
            font-family: Arial, sans-serif; 
            margin: 20px auto; /* Keep auto margin for centering if desired */
            padding: 20px; 
            max-width: 800px; 
            border: 1px solid #ccc; 
            border-radius: 8px; 
            background-color: #fff; /* Explicit background for the container */
        }
        #qboTestTriggerContainer .qbo-trigger-form-group { 
            margin-bottom: 15px; 
        }
        #qboTestTriggerContainer label { 
            display: block; 
            margin-bottom: 5px; 
            font-weight: bold;
        }
        #qboTestTriggerContainer input[type="text"] { 
            width: 100%; 
            padding: 8px; 
            box-sizing: border-box; 
            border: 1px solid #ccc; 
            border-radius: 4px; 
        }
        #qboTestTriggerContainer button[type="submit"] { 
            padding: 10px 15px; 
            background-color: #007bff; 
            color: white; 
            border: none; 
            border-radius: 4px; 
            cursor: pointer; 
        }
        #qboTestTriggerContainer button[type="submit"]:hover { 
            background-color: #0056b3; 
        }
        #qboTestTriggerContainer .qbo-trigger-feedback-area { 
            margin-top: 20px; 
            padding: 10px; 
            border: 1px solid #eee; 
            background-color: #f9f9f9; 
            border-radius: 4px; 
            min-height: 100px; 
            max-height: 400px; 
            overflow-y: auto; 
            white-space: pre-wrap; /* Preserves line breaks from output */
            font-family: monospace; 
            font-size: 0.9em;
            line-height: 1.4;
        }
        #qboTestTriggerContainer .qbo-trigger-error-message { 
            color: red; 
            font-weight: bold; 
            margin-top: 15px;
            padding: 10px;
            border: 1px solid #f5c6cb;
            background-color: #f8d7da;
            border-radius: 4px;
        }
        #qboTestTriggerContainer .qbo-trigger-page-title {
            text-align: center;
            margin-bottom: 10px;
            font-size: 1.5em;
            color: #333;
        }
        #qboTestTriggerContainer .qbo-trigger-page-description {
            text-align: center;
            margin-bottom: 20px;
            font-size: 0.95em;
            color: #555;
        }
        /* Note: Styles for generic p, h1, h3 are removed or scoped */
    </style>
</head>
<body> <!-- Body tag is here, styles from header.php might apply to it -->

    <div id="qboTestTriggerContainer"> <!-- Unique ID for the container -->
        <h1 class="qbo-trigger-page-title">Trigger QBO Sync</h1>
        <p class="qbo-trigger-page-description">
            Enter a Quote Number to initiate the synchronization process with QuickBooks Online.
            Output from the script will be shown below. For very long processes, this page might time out.
        </p>

        <form method="POST" action="">
            <div class="qbo-trigger-form-group">
                <label for="quote_no_trigger">Quote Number:</label> <!-- Changed id for uniqueness if needed -->
                <input type="text" id="quote_no_trigger" name="quote_no" value="<?php echo htmlspecialchars($quote_no_processed); ?>" required>
            </div>
            <button type="submit">Start Sync</button>
        </form>

        <?php if (!empty($error_message)): ?>
            <div class="qbo-trigger-error-message"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <?php if (!empty($feedback_output)): ?>
            <h3 style="margin-top: 20px;">Processing Output:</h3> <!-- Inline style for this specific h3 -->
            <div class="qbo-trigger-feedback-area">
                <?php foreach ($feedback_output as $line): ?>
                    <?php echo $line; ?><br>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

</body>
</html>