<?php
include "dbconn.php";
include "dictionaries.php";
include "quote_pricing.php";
include "html_utility.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];
$sql_ajax = "SELECT id, user_name, CONCAT(first_name, ' ', last_name) AS name, quote_view, file_access, quote_pricing, delete_tag, view_followup FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
$global_file_access = 'all';
$global_pricing_access = 0;
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $global_user_id = (int) $row_ajax['id'];
    $username_plain_ajax = $row_ajax['user_name'];
    $username_ajax = $row_ajax['name'];
    $quote_view = $row_ajax['quote_view'];
    $global_file_access = $row_ajax['file_access'] ?? 'all';
    $global_pricing_access = (int) $row_ajax['quote_pricing'];
    $global_delete_tag = (int) $row_ajax['delete_tag'];
    $global_view_followup = (int) $row_ajax['view_followup'];
}

$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

date_default_timezone_set('Australia/Melbourne');

// Home
if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'home') {
    include "header.php";

}

// Quotes Create and Search - quotes.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['sales-search', 'multi-edit-sales', 'search', 'duplicate-quote', 'multi-edit-grp', 
        'create-standard', 'create-fit', 'create-group', 'custom-approval', 'alt-vendor-approval'])) {
    
    include "quote/quotes.php";
}

// Quotes Details - details.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['summary', 'products-csv-analysis', 'hotel-pax', 'rezdy-booking'])) {
    
    include "quote/details.php";
}

// Operation
else if (($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account') && isset($_GET['opt']) && $_GET['opt'] == 'ops-group') {
    include "header.php";
    $activeStages = fetchActiveQuoteStages($conn);
    $groupStages = fetchGroupQuoteStages($conn);
    $commonStages = array_intersect($activeStages, $groupStages);
    $active_quote_stages = implode(',', $commonStages);
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <?php
        $sql = "SELECT 
                    IF(vqr.assigned_to_ops IS NULL OR vqr.assigned_to_ops = '', 'Unassigned', vqr.assigned_to_ops) AS name,
                    COUNT(
                        CASE 
                            WHEN YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) = MONTH(CURDATE()) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) THEN vq.quoteid
                        END
                    ) AS count_per_month,
                    MONTH(vqcf.cf_1162) AS month_num
                FROM (SELECT *
                    FROM vtiger_quotes
                    WHERE quoteid = (
                        SELECT MIN(quoteid) AS quoteid
                        FROM vtiger_quotes AS sub
                        WHERE sub.quote_no = vtiger_quotes.quote_no)
                    ORDER BY quote_no DESC) vq
                LEFT JOIN vtiger_quotes_info vqr ON vq.quoteid = vqr.quoteid AND vqr.quotetype = 'group'
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vq.quotestage NOT LIKE '%deliver%' 
                AND vq.quotestage NOT LIKE '%reject%'
                AND vq.quotestage NOT LIKE '%create%'
                AND vq.quotestage NOT LIKE '%requote%'
                AND vq.quotestage NOT LIKE '%complete%'
                AND vq.quotestage NOT LIKE '%Ground%'
                AND vq.quotestage NOT LIKE '%Reconciliation%'
                AND vq.quotestage NOT LIKE '%Final QA%'
                AND vq.quotestage != 'Handover to Ops'
                AND vq.quotestage != 'Create Project'
                AND vq.quotestage NOT LIKE '%Partial Payment Due%'
                AND vq.quotestage NOT LIKE '%TA Verification%'
                AND ((YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) >= MONTH(CURDATE())) OR YEAR(vqcf.cf_1162) > YEAR(CURDATE()))
                GROUP BY name, month_num
                ORDER BY month_num ASC;";
        $result = $conn->query($sql);

        // Organizing data by person and month
        $personData = [];
        $totalPerMonth = array_fill(1, 12, 0); // Total for each month
        while ($row = $result->fetch_assoc()) {
            $personName = $row['name'];
            $monthNum = $row['month_num'];
            $count = $row['count_per_month'];

            if (!isset($personData[$personName])) {
                $personData[$personName] = array_fill(1, 12, 0); // Initialize for 12 months with 0
            }

            $personData[$personName][$monthNum] = $count;
            $totalPerMonth[$monthNum] += $count; // Sum counts per month
        }
        ?>

        <h1 style="text-align:center; margin-top: 20px;">Group Quotes</h1>
        <div class="table-container" style="width: 80%; margin: auto;">
            <div class="table-wrapper">
                <h2 style="margin-bottom: 10px;">Working Quotes by Ops</h2>
                <table>
                    <tr>
                        <th style="width: 15%;">Ops By Person</th>
                        <?php
                        // Output month headers (starting from the current month)
                        for ($i = 0; $i < 12; $i++) {
                            $monthName = date("M-y", strtotime("first day of +$i month"));
                            echo "<th>$monthName</th>";
                        }
                        ?>
                        <th>Total</th> <!-- Total column header -->
                    </tr>
                    <?php
                    // Output data for each person
                    foreach ($personData as $personName => $monthsData) {
                        echo "<tr>";
                        echo "<td>$personName</td>";

                        $totalPerPerson = 0; // Sum counts for this person
                        // Output counts for each month
                        for ($i = 0; $i < 12; $i++) {
                            $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                            $dateRange = "$startDate to $endDate";
                            $count = $monthsData[$monthNum];

                            // Generate the link for each month
                            if($count != 0) {
                                $link = "<a href='?opt=search&quote_stage=$active_quote_stages&ops_by_person=" . urlencode($personName) . "&date_range=$dateRange'>$count</a>";
                                // $link = "<a href='?opt=agent-quote-stage&ops_by_person=" . urlencode($personName) . "&date_range=$dateRange'>$count</a>";
                            } else {
                                $link = '';
                            }

                            echo "<td>$link</td>";
                            $totalPerPerson += $count; // Add to person total
                        }

                        // Output total count for this person
                        echo "<td>$totalPerPerson</td>";

                        echo "</tr>";
                    }
                    ?>
                    <tr>
                        <th>Total</th>
                        <?php
                        $grandTotal = 0; // Total for all persons and months
                        // Output total per month
                        for ($i = 0; $i < 12; $i++) {
                            $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month

                            $sql_country = "SELECT vq.country, COUNT(*) AS country_count
                                            FROM (
                                                SELECT *
                                                FROM vtiger_quotes
                                                WHERE quoteid = (
                                                    SELECT MIN(quoteid) AS quoteid
                                                    FROM vtiger_quotes AS sub
                                                    WHERE sub.quote_no = vtiger_quotes.quote_no
                                                )
                                                ORDER BY quote_no DESC
                                            ) vq
                                            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                                            WHERE ((vq.quotestage NOT LIKE '%deliver%'
                                                AND vq.quotestage NOT LIKE '%reject%'
                                                AND vq.quotestage NOT LIKE '%create%'
                                                AND vq.quotestage NOT LIKE '%requote%'
                                                AND vq.quotestage NOT LIKE '%complete%'
                                                AND vq.quotestage NOT LIKE '%Reconciliation%'
                                                AND vq.quotestage NOT LIKE '%Final QA%'
                                                AND vq.quotestage != 'Accepted' 
                                                AND vq.quotestage != 'Handover to Ops'
                                                AND vq.quotestage != 'Create Project'
                                                AND vq.quotestage NOT LIKE '%Partial Payment Due%'
                                                AND vq.quotestage NOT LIKE '%TA Verification%')
                                                OR vq.quotestage = 'On Ground - Changes (Ops)')
                                                AND vqcf.cf_1162 >= '$startDate' AND vqcf.cf_1162 <= '$endDate'
                                            GROUP BY vq.country;";

                            $result_country = $conn->query($sql_country);

                            // Fetch the results and display the count for each country
                            $au = 0;
                            $nz = 0;
                            if ($result_country->num_rows > 0) {
                                while ($row = $result_country->fetch_assoc()) {
                                    if($row['country'] == 'Australia') {
                                        $au += $row['country_count'];
                                    }
                                    else {
                                        $nz += $row['country_count'];
                                    }
                                }
                            }

                            $dateRange = "$startDate to $endDate";
                            $totalForMonth = $totalPerMonth[$monthNum];
                            if($totalForMonth != 0) {
                                echo "<td style='white-space: nowrap;'><a href='?opt=search&quote_stage=$active_quote_stages&date_range=$dateRange'>$totalForMonth</a> [AU: $au, NZ: $nz]</td>";
                            }
                            else {
                                echo "<td></td>";
                            }
                            
                            $grandTotal += $totalForMonth;
                        }
                        // Output grand total
                        echo "<th>$grandTotal</th>";
                        ?>
                    </tr>
                </table>
            </div>
        </div>

        <?php
        $sql = "SELECT 
                    quotestage,
                    COUNT(
                        CASE 
                            WHEN YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) = MONTH(CURDATE()) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) THEN vq.quoteid
                        END
                    ) AS count_per_month,
                    MONTH(vqcf.cf_1162) AS month_num
                FROM (SELECT *
                    FROM vtiger_quotes
                    WHERE quoteid = (
                        SELECT MIN(quoteid) AS quoteid
                        FROM vtiger_quotes AS sub
                        WHERE sub.quote_no = vtiger_quotes.quote_no)
                    ORDER BY quote_no DESC) vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE ((YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) >= MONTH(CURDATE())) OR YEAR(vqcf.cf_1162) > YEAR(CURDATE()))
                AND deleted = 0
                GROUP BY quotestage, month_num
                ORDER BY month_num ASC;";

        $result = $conn->query($sql);

        // Organizing data by quote stage and month
        $quoteStageData = [];
        $totalPerMonth = array_fill(1, 12, 0); // Total for each month
        while ($row = $result->fetch_assoc()) {
            $quoteStage = $row['quotestage'];
            $monthNum = $row['month_num'];
            $count = $row['count_per_month'];

            if (!isset($quoteStageData[$quoteStage])) {
                $quoteStageData[$quoteStage] = array_fill(1, 12, 0); // Initialize for 12 months with 0
            }

            $quoteStageData[$quoteStage][$monthNum] = $count;
            $totalPerMonth[$monthNum] += $count; // Sum counts per month
        }
        ?>
        <div class="table-container" style="width: 80%; margin: auto;">
            <div class="table-wrapper">
                <h2 style="margin-bottom: 10px;">Quotes based on Stage</h2>
                <table>
                    <tr>
                        <th style="width: 15%;">Quote Stage</th>
                        <?php
                        // Output month headers (starting from the current month)
                        for ($i = 0; $i < 12; $i++) {
                            $monthName = date("M-y", strtotime("first day of +$i month"));
                            echo "<th>$monthName</th>";
                        }
                        ?>
                        <th>Total</th> <!-- Total column header -->
                    </tr>
                    <?php
                    // Output data for each quote stage
                    foreach ($quoteStageData as $quoteStage => $monthsData) {
                        echo "<tr>";
                        $quoteStage1 = preg_replace('/\([^)]*\)/', '', $quoteStage);
                        echo "<td>$quoteStage1</td>";

                        $totalPerQuoteStage = 0; // Sum counts for this quote stage
                        // Output counts for each month
                        for ($i = 0; $i < 12; $i++) {
                            $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                            $dateRange = "$startDate to $endDate";
                            $count = $monthsData[$monthNum];

                            // Generate the link for each month
                            if($count != 0) {
                                $link = "<a href='?opt=search&quote_stage=" . urlencode($quoteStage) . "&date_range=$dateRange'>$count</a>";
                            } else {
                                $link = '';
                            }

                            echo "<td>$link</td>";
                            $totalPerQuoteStage += $count; // Add to quote stage total
                        }

                        // Output total count for this quote stage
                        echo "<td>$totalPerQuoteStage</td>";

                        echo "</tr>";
                    }
                    ?>
                    <tr>
                        <th>Total</th>
                        <?php
                        $grandTotal = 0; // Total for all quote stages and months
                        // Output total per month
                        for ($i = 0; $i < 12; $i++) {
                            $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                            $totalForMonth = $totalPerMonth[$monthNum];
                            if($totalForMonth != 0) {
                                echo "<th>$totalForMonth</th>";
                            }
                            else {
                                echo "<th></th>";
                            }
                            $grandTotal += $totalForMonth;
                        }
                        // Output grand total
                        echo "<th>$grandTotal</th>";
                        ?>
                    </tr>
                </table>
            </div>
        </div>
        <style>
            .table-wrapper table tr th {
                width: 7%;
            }
            .table-wrapper table tr:nth-child(odd) {
                background-color: #f2f2f2;
            }
        </style>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}

// Sales
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'sales-home') {
    include "header.php";

    echo '<h1 style="text-align:center; margin-top: 20px;">Internal Sales</h1>';

    if($title == 'admin') {
        $tagFilter = isset($_GET['filter_tag']) ? $conn->real_escape_string($_GET['filter_tag']) : ''; 
        ?>
        <form class="filter-form" method="GET" style="text-align:center; margin-top: 20px;">
            <input type="hidden" name="opt" value="sales-home">
            <label for="filter_tag">Filter by Tag:</label>
            <input type="text" id="filter_tag" name="filter_tag" value="<?php echo htmlspecialchars($tagFilter); ?>">
            <button type="submit">Search</button>
        </form>
        <style>
            .filter-form input, .filter-form button {
                height: 30px;
            }
        </style>
        <?php
    }
    else {
        $tagFilter = $username_ajax; 
    }
    include "components/internal_sales.php";

    if($title == 'admin') {
        echo '<h1 style="text-align:center; margin-top: 20px;">External Sales</h1>';
        include "components/external_sales.php";
    }
    
    $tagDict = getTagByTagID($conn);
    $tagCategoryDict = getTagCategory($conn);
    $sql = "SELECT o2.tag_id AS related_tag_id, f.id, f.tag, f.raw_tag, COUNT(*) AS tag_count
            FROM vtiger_freetagged_objects o
            JOIN vtiger_freetags f ON o.tag_id = f.id
            JOIN vtiger_freetagged_objects o2 ON o.object_id = o2.object_id
            GROUP BY o2.tag_id, f.tag, f.raw_tag";
    $result = mysqli_query($conn, $sql);

    // Step 2: Organize data by related_tag_id and raw_tag
    $data = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $data[$row['related_tag_id']][$row['raw_tag']][] = $row;
        }
    }
    ?>
    <div class="table-container" style="width: 67%; margin: auto; padding: 20px; background-color: #ffd1d1;">
        <h2><a href="quote.php?opt=office-email">Click here to view UNTAGGED emails</a></h2>
    </div>
    <?php if (!empty($data)): 
        $assignedToSalesAgents = array_merge(fetchInternalSales($conn), fetchExternalSales($conn)); ?>
        <?php foreach ($data as $related_tag_id => $tag_data): ?>
            <?php
            if(!array_key_exists($related_tag_id, $tagCategoryDict)) {
                continue;
            }
            if(!empty($tagFilter) && strpos($tagDict[$related_tag_id], $tagFilter) === false) {
                continue;
            }
            if(!in_array($tagDict[$related_tag_id], $assignedToSalesAgents)) {
                continue;
            }
            ?>
            <div class="table-container" style="width: 70%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="text-align: left; margin-bottom: 10px;"><?= $tagDict[$related_tag_id] ?>'s Tickets</h2>
                    <?php
                    // Array to define the metadata for each category (region, type, country)
                    $categories = [
                        'region' => ['title' => 'Region', 'data' => $tag_data['region']],
                        'type' => ['title' => 'Type', 'data' => $tag_data['type']],
                        'country' => ['title' => 'Country', 'data' => $tag_data['country']],
                    ];

                    // Loop through each category
                    foreach ($categories as $key => $category): ?>
                        <table>
                            <tr>
                                <th style="width: 50%;"><?= htmlspecialchars($category['title']) ?></th>
                                <th>New</th>
                                <th>In Progress</th>
                                <th>Wait For Response</th>
                                <th>Closed</th>
                                <th>Total</th> <!-- New Total Column -->
                            </tr>
                            <?php if (!empty($category['data'])): ?>
                                <?php foreach ($category['data'] as $item): ?>
                                    <?php
                                    $item_id = (int) $item['id'];
                                    $sql = "SELECT 
                                                IF(vs.status = '' OR vs.status IS NULL, 'New', vs.status) AS status,
                                                COUNT(*) AS count
                                            FROM vtiger_freetagged_objects vfo1
                                            JOIN vtiger_freetagged_objects vfo2 ON vfo1.object_id = vfo2.object_id
                                            LEFT JOIN vtiger_support vs ON vfo1.object_id = vs.ticketid
                                            WHERE vfo1.tag_id = $related_tag_id AND vfo2.tag_id = $item_id
                                            GROUP BY status;";
                                    $result = $conn->query($sql);
                                    
                                    $statuses_order = ['New', 'In Progress', 'Wait For Response', 'Closed'];
                                    $status_counts = array_fill_keys($statuses_order, 0);
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $status = $row['status'];
                                            $count = (int)$row['count'];
                                            if (array_key_exists($status, $status_counts)) {
                                                $status_counts[$status] += $count;
                                            }
                                        }
                                    }

                                    // Calculate the total for this row
                                    $row_total = array_sum($status_counts);
                                    ?>
                                    <tr>
                                        <td><?= htmlspecialchars($item['tag']) ?></td>
                                        <?php foreach ($statuses_order as $status): ?>
                                            <td><a href="quote.php?opt=office-mailbox&tag=<?= urlencode($item['id']) ?>&userid=<?= urlencode($related_tag_id) ?>&status=<?= urlencode($status) ?>"><?= htmlspecialchars($status_counts[$status] > 0 ? $status_counts[$status] : '') ?></a></td>
                                        <?php endforeach; ?>
                                        <td><?= htmlspecialchars($row_total > 0 ? $row_total : '') ?></td> <!-- Display the Total -->
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6">No results found for <?= htmlspecialchars($category['title']) ?>.</td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; 
}
else if (($title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'sales-home') {
    include "header.php";

    echo '<h1 style="text-align:center; margin-top: 20px;">External Sales</h1>';

    if($title == 'admin') {
        $tagFilter = isset($_GET['filter_tag']) ? $conn->real_escape_string($_GET['filter_tag']) : ''; 
        ?>
        <form class="filter-form" method="GET" style="text-align:center; margin-top: 20px;">
            <input type="hidden" name="opt" value="sales-home">
            <label for="filter_tag">Filter by Tag:</label>
            <input type="text" id="filter_tag" name="filter_tag" value="<?php echo htmlspecialchars($tagFilter); ?>">
            <button type="submit">Search</button>
        </form>
        <style>
            .filter-form input, .filter-form button {
                height: 30px;
            }
        </style>
        <?php
    }
    else {
        $tagFilter = $username_ajax; 
    }
    include "components/external_sales.php";

    $tagDict = getTagByTagID($conn);
    $tagCategoryDict = getTagCategory($conn);
    $sql = "SELECT o2.tag_id AS related_tag_id, f.id, f.tag, f.raw_tag, COUNT(*) AS tag_count
            FROM vtiger_freetagged_objects o
            JOIN vtiger_freetags f ON o.tag_id = f.id
            JOIN vtiger_freetagged_objects o2 ON o.object_id = o2.object_id
            GROUP BY o2.tag_id, f.tag, f.raw_tag";
    $result = mysqli_query($conn, $sql);

    // Step 2: Organize data by related_tag_id and raw_tag
    $data = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $data[$row['related_tag_id']][$row['raw_tag']][] = $row;
        }
    }
    ?>
    <?php if (!empty($data)): 
        $assignedToSalesAgents = fetchExternalSales($conn); ?>
        <?php foreach ($data as $related_tag_id => $tag_data): ?>
            <?php
            if(!array_key_exists($related_tag_id, $tagCategoryDict)) {
                continue;
            }
            if(!empty($tagFilter) && strpos($tagDict[$related_tag_id], $tagFilter) === false) {
                continue;
            }
            if(!in_array($tagDict[$related_tag_id], $assignedToSalesAgents)) {
                continue;
            }
            ?>
            <div class="table-container" style="width: 70%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">Tickets</h2>
                    <?php
                    // Array to define the metadata for each category (region, type, country)
                    $categories = [
                        'region' => ['title' => 'Region', 'data' => $tag_data['region']],
                        'type' => ['title' => 'Type', 'data' => $tag_data['type']],
                        'country' => ['title' => 'Country', 'data' => $tag_data['country']],
                    ];

                    // Loop through each category
                    foreach ($categories as $key => $category): ?>
                        <table>
                            <tr>
                                <th style="width: 50%;"><?= htmlspecialchars($category['title']) ?></th>
                                <th>New</th>
                                <th>In Progress</th>
                                <th>Wait For Response</th>
                                <th>Closed</th>
                                <th>Total</th> <!-- New Total Column -->
                            </tr>
                            <?php if (!empty($category['data'])): ?>
                                <?php foreach ($category['data'] as $item): ?>
                                    <?php
                                    $item_id = (int) $item['id'];
                                    $sql = "SELECT 
                                                IF(vs.status = '' OR vs.status IS NULL, 'New', vs.status) AS status,
                                                COUNT(*) AS count
                                            FROM vtiger_freetagged_objects vfo1
                                            JOIN vtiger_freetagged_objects vfo2 ON vfo1.object_id = vfo2.object_id
                                            LEFT JOIN vtiger_support vs ON vfo1.object_id = vs.ticketid
                                            WHERE vfo1.tag_id = $related_tag_id AND vfo2.tag_id = $item_id
                                            GROUP BY status;";
                                    $result = $conn->query($sql);
                                    
                                    $statuses_order = ['New', 'In Progress', 'Wait For Response', 'Closed'];
                                    $status_counts = array_fill_keys($statuses_order, 0);
                                    
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $status = $row['status'];
                                            $count = (int)$row['count'];
                                            if (array_key_exists($status, $status_counts)) {
                                                $status_counts[$status] += $count;
                                            }
                                        }
                                    }

                                    // Calculate the total for this row
                                    $row_total = array_sum($status_counts);
                                    ?>
                                    <tr>
                                        <td><?= htmlspecialchars($item['tag']) ?></td>
                                        <?php foreach ($statuses_order as $status): ?>
                                            <td><a href="quote.php?opt=office-mailbox&tag=<?= urlencode($item['id']) ?>&userid=<?= urlencode($related_tag_id) ?>&status=<?= urlencode($status) ?>"><?= htmlspecialchars($status_counts[$status] > 0 ? $status_counts[$status] : '') ?></a></td>
                                        <?php endforeach; ?>
                                        <td><?= htmlspecialchars($row_total > 0 ? $row_total : '') ?></td> <!-- Display the Total -->
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6">No results found for <?= htmlspecialchars($category['title']) ?>.</td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; 
}

// Hotel
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'hotel' && isset($_GET['country'])) {
    include "header.php";
    if($_GET['country'] == 'au') {
        $hotel_search_url = 'https://hotel.ypsilon.net/en_AU?aid=shelltechhotels';
    } else if ($_GET['country'] == 'nz') {
        $hotel_search_url = 'https://hotel.ypsilon.net/en_GB?aid=shelltechhotelsnzd&currency=NZD';
    }
    ?>
    <iframe src="<?php echo $hotel_search_url; ?>" 
            style="width: 100%; height: 100vh; border: none;">
        Your browser does not support iframes.
    </iframe>
    <?php
}

// Rezdy - rezdy.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['rezdy-search'])) {
    
    include "rezdy.php";
}

// Car Hire
else if (($title=='admin' || $title=='ops' || $title=='sales' || $title=='acc' || $title=='ops/sales') && isset($_GET['opt']) && $_GET['opt'] == 'car-hire') {
    include "header.php";
    include "car-hire/searchWidget.php";
}

// AU Vendor
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'add-vendor') {
    include "header.php";
    
    ?>
    <form action="update_au_vendor.php" method="POST" enctype="multipart/form-data" style="margin-top: 20px;">
        <h2 style="margin: 20px 0;">New Document</h2>
        <div class="form-row">
            <label for="country">Country:</label>
            <select name="country" id="country" required>
                <option value="">Select a country</option>
                <option value="Australia">Australia</option>
                <option value="New Zealand">New Zealand</option>
            </select>
        </div>

        <div class="form-row">
            <label for="city">City:</label>
            <input type="text" id="city" name="city" list="cityList" required>
            <datalist id="cityList">
                <!-- Options will be populated by JavaScript -->
            </datalist>
        </div>

        <script>
            // Australian cities
            var australianCities = <?php echo json_encode(citiesAU()); ?>;

            // New Zealand cities
            var newZealandCities = <?php echo json_encode(citiesNZ()); ?>;

            // Update city options based on selected country
            document.getElementById('country').addEventListener('change', function() {
                var selectedCountry = this.value;
                var cityList = document.getElementById('cityList');
                cityList.innerHTML = ''; // Clear previous options

                var cities = selectedCountry === 'Australia' ? australianCities : newZealandCities;

                cities.forEach(function(city) {
                    var option = document.createElement('option');
                    option.value = city;
                    cityList.appendChild(option);
                });
                
                // Clear city input when country changes
                document.getElementById('city').value = '';
            });

            // Add blur event listener to check the input after user finishes
            document.getElementById('city').addEventListener('blur', function() {
                var inputCity = this.value;
                var selectedCountry = document.getElementById('country').value;
                var cities = selectedCountry === 'Australia' ? australianCities : newZealandCities;

                if (!cities.includes(inputCity)) {
                    this.value = ''; // Clear the input if not in the list
                }
            });
        </script>

        <div class="form-row">
            <label for="location">Location:</label>
            <input type="text" name="location" required>
        </div>
        <div class="form-row">
            <label for="vendor_name">Vendor Name:</label>
            <input type="text" name="vendor_name" required>
        </div>
        <div class="form-row">
            <label for="market">Market:</label>
            <input type="text" name="market" required>
        </div>
        <div class="form-row">
            <label for="category">Category:</label>
            <select name="category" id="category" required onchange="toggleFileInput()">
                <option value="">Select a category</option>
                <option value="Attraction">Attraction</option>
                <!--<option value="Hotel">Hotel</option>-->
                <option value="Restaurant">Restaurant</option>
                <option value="Transfer">Transfer (Import CSV)</option>
                <option value="Transfer-PDF">Transfer (Import PDF)</option>
            </select>
        </div>
        <div class="form-row" id="fileInputRow" style="display: none;">
            <label id="fileInputLabel" for="file_input">
                Import Products:
            </label>
            <input type="file" name="file_input" id="file_input" accept=".csv" required>
        </div>
        <button type="submit" name="new">Save</button>
    </form>

    <style>
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
    
        .form-row input, .form-row textarea {
            width: 100%;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border-radius: 5px;
        }
    </style>

    <script>
        function toggleFileInput() {
            const category = document.getElementById('category').value;
            const fileInputRow = document.getElementById('fileInputRow');
            const fileInputLabel = document.getElementById('fileInputLabel');
            const fileInput = document.getElementById('file_input');

            if (category === 'Transfer') {
                fileInputRow.style.display = 'block';
                fileInput.type = 'file';
                fileInput.accept = '.csv';
                fileInputLabel.innerHTML = 'Import Products:<br>upload csv file - <a href="vendor_uploads/vendor-template.csv" download>download template</a>';
            } else if (category === 'Attraction' || category === 'Hotel' || category === 'Restaurant' || category === 'Transfer-PDF') {
                fileInputRow.style.display = 'block';
                fileInput.type = 'file';
                fileInput.accept = '.pdf';
                fileInputLabel.innerHTML = 'Import Products (PDF):';
            } else {
                fileInputRow.style.display = 'none';
            }
        }
    </script>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'vendor') {
    $category = $_GET['category'];

    include "header.php";
    if($_GET['country'] == 'au') {
        $sql = "SELECT * FROM tdu_vendor WHERE country='Australia'"; 
    }
    else if($_GET['country'] == 'nz') {
        $sql = "SELECT * FROM tdu_vendor WHERE country='New Zealand'"; 
    }
    if($category == 'Transfer') {
        $sql .= " AND (category='Transfer' OR category='Transfer-PDF');";
    } else {
        $sql .= " AND category='$category';";
    }
    $result = mysqli_query($conn, $sql);

    $vendors = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $city = $row['city'];
        
        $vendors[$city][] = [
            'vendor_id' => $row['vendor_id'],
            'vendor_name' => $row['vendor_name'],
            'location' => $row['location'],
            'market' => $row['market'],
            'pdf_path' => $row['pdf_path']
        ];
    }

    ?>
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        <div id="vendor-list" style="width: 50%;">
            <?php foreach ($vendors as $city => $vendorList): ?>
                <div class="city" style="text-align: center; margin-bottom: 40px;">
                    <h2 style="margin-bottom: 20px; font-size: 32px;"><?= htmlspecialchars($city) ?></h2>
                    <div class="vendors-grid">
                        <?php foreach ($vendorList as $vendor): ?>
                            <div class="vendor-block">
                                <div class="vendor-row">
                                    <?php 
                                    if($category == 'Transfer' && empty($vendor['pdf_path'])) {
                                        ?>
                                        <button style="background: white; border: 0;" onclick="showProducts('<?= htmlspecialchars($vendor['vendor_name']) ?>', <?= $vendor['vendor_id'] ?>)">
                                            <i class="fa-solid fa-file-csv"></i>
                                        </button>
                                        <?php
                                    } else {
                                        $pdfPath = $vendor['pdf_path'];
                                        ?>
                                        <button onclick="window.open('<?= htmlspecialchars($pdfPath) ?>', '_blank');" style="background: white; border: 0; cursor: pointer;">
                                            <i class="fa-solid fa-file-pdf"></i>
                                        </button>
                                        <?php
                                    }
                                    ?>
                                    <p class="vendor-name"><?= htmlspecialchars($vendor['vendor_name']) ?></p>
                                    <p class="vendor-location"><?= htmlspecialchars($vendor['location']) ?></p>

                                    <!-- Delete Button -->
                                    <?php
                                    if ($title=='admin') {
                                        ?>
                                        <button onclick="deleteVendor(<?= $vendor['vendor_id'] ?>)" style="background: red; color: white; margin-left: 5px;"><i class="fa-solid fa-trash-can"></i></button>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div id="productModal" class="modal hidden">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div id="modal-product-list"></div>
        </div>
    </div>
    <style>
        body {
            background-color: #008fc0;
        }
        h2 {
            font-size: 32px !important;
            color: white;
        }
        .vendor-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .vendor-name {
            text-align: center;
            flex-grow: 1;
            margin: 0;
        }
        
        .vendor-location {
            text-align: right;
            margin: 0;
        }
        
        .vendor-block button {
            text-align: left;
        }

        .country, .city, .category-tabs, .vendor-table {
            margin-left: 20px;
            margin-top: 10px;
        }
    
        .category-tabs button {
            margin-right: 10px;
            padding: 5px 10px;
            cursor: pointer;
        }
    
        .vendors-grid {
            display: flex;
            flex-wrap: wrap;
        }
    
        .vendor-block {
            background-color: white;
            width: 48%;
            margin: 5px;
            padding: 20px;
            border: 7.5px solid #334155;
        }
        
        .vendor-row p {
            color: black;
            font-size: 20px;
        }
        
        .vendor-row i {
            color: black;
            font-size: 28px;
        }
    
        table {
            width: 100%;
            border-collapse: collapse;
        }
    
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
    
        .hidden {
            display: none;
        }
    
        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
        }
    
        .modal-content {
            background-color: #fff;
            margin: 75px auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.2);
        }
    
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
    
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    </style>
    <script>
        function showCategory(country, city, category) {
            document.querySelectorAll('.vendor-table').forEach(function(table) {
                table.classList.add('hidden');
            });
    
            document.getElementById(`${country}-${city}-${category}`).classList.remove('hidden');
    
            const productListDiv = document.getElementById('product-list');
            productListDiv.innerHTML = '';
        }
    
        function showProducts(vendorName, vendorId) {
            const modal = document.getElementById('productModal');
            const modalProductList = document.getElementById('modal-product-list');
            modalProductList.innerHTML = ''; // Clear existing content
    
            // Set the vendor name as an <h2>
            const vendorHeader = `<h2>${vendorName}</h2>`;
            modalProductList.innerHTML += vendorHeader;
    
            // AJAX request to fetch product details
            const xhr = new XMLHttpRequest();
            xhr.open('GET', 'ajax_show_products.php?vendor_id=' + vendorId, true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    const products = JSON.parse(xhr.responseText);
                    if (products.length > 0) {
                        // Find unique sub_categories
                        const subCategories = [...new Set(products.map(product => product.sub_category))];
    
                        // Create table headers
                        let table = '<table><tr><th>Product Name</th>';
                        subCategories.forEach(subCat => {
                            table += `<th>${subCat}</th>`;
                        });
                        table += '</tr>';
    
                        // Create a map to store product prices based on product_name and sub_category
                        const productMap = {};
                        products.forEach(product => {
                            if (!productMap[product.product_name]) {
                                productMap[product.product_name] = {};
                            }
                            productMap[product.product_name][product.sub_category] = product.price;
                        });
    
                        // Generate table rows
                        for (const productName in productMap) {
                            table += `<tr><td>${productName}</td>`;
                            subCategories.forEach(subCat => {
                                const price = productMap[productName][subCat] || 'N/A'; // Use 'N/A' if no price is available
                                table += `<td>${price}</td>`;
                            });
                            table += '</tr>';
                        }
                        table += '</table>';
                        modalProductList.innerHTML += table;
                    } else {
                        modalProductList.innerHTML += 'No products found.';
                    }
                }
            };
            xhr.send();
    
            // Open the modal
            modal.style.display = 'block';
    
            // Close the modal when the user clicks on <span> (x)
            document.querySelector('.close').onclick = function() {
                modal.style.display = 'none';
            };
    
            // Close the modal when the user clicks outside of it
            window.onclick = function(event) {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            };
        }
    </script>
    <script>
        function deleteVendor(vendorId) {
            if (confirm("Are you sure you want to delete this vendor?")) {
                // Send AJAX request to delete the vendor
                const xhr = new XMLHttpRequest();
                xhr.open('GET', 'ajax_delete_vendor.php?vendor_id=' + vendorId, true);
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        const response = xhr.responseText;
                        if (response == 'success') {
                            // Reload the page after successful deletion
                            alert('Vendor deleted successfully!');
                            location.reload();  // Refresh the page
                        } else {
                            alert('Error deleting vendor: ' + response);
                        }
                    }
                };
                xhr.send();
            }
        }
    </script>
    <?php
}

// Report - reports.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['account', 'report-hotel-deadline', 'detail-hotel-deadline', 'product-deadline',
        'report-ops', 'report-payment-deadline', 'booking-products-list', 'booking-hotels-list',
        'email-tags-monthly', 'sales-home-admin', 'sales-home-external', 'report-sales', 'report-sales-region', 'payment-due-approve-list'])) {
    
    include "quote/reports.php";
}

// New Report - salesreports.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['sales-home-v2', 'sales-confirmation-report'])) {
    
    include "quote/salesreports.php";
}

// Office MailBox - mailbox.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['office-email', 'office-mailbox', 'email-content'])) {
    
    include "quote/mailbox.php";
}

// Inventory - inventory.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['organizations', 'add-new-organization', 'organization-details', 
        'vendors', 'add-new-vendors', 'vendor-details', 'vendor-products-bulk-edit', 
        'add-new-products', 'product-details', 'products-list', 'product-price-import', 'quote-product-faq',
        'membership-list', 'membership'])) {

    include "quote/inventory.php";
}

// Template - template.php
else if (isset($_GET['opt']) && in_array($_GET['opt'], 
        ['templates', 'template-details'])) {
    
    include "quote/template.php";
}

// Auto-assign Rules
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'assign-rules') {
    include "header.php";
    $monthNames = ["1" => "Jan", "2" => "Feb", "3" => "Mar", "4" => "Apr", "5" => "May", "6" => "Jun", "7" => "Jul", "8" => "Aug", "9" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec"];
    $userFullName = ["sales" => "Internal Sales", "external" => "External Sales", "group" => "Group Operation", "fit" => "FIT Operation", "qa" => "QA"];
    $userRoles = [
        "sales" => "sales",
        "external" => "external",
        "fit" => "fit",
        "group" => "group",
        "qa" => "qa"
    ];

    $global_user = $_GET['user'] ?? '';
    $global_category = $_GET['category'] ?? '';

    $query = "SELECT * FROM tdu_auto_assign_rules ORDER BY assign_type ASC, username ASC, region ASC, start_m ASC, start_d ASC";
    $result = mysqli_query($conn, $query);

    $categories = ["sales" => [], "external" => [], "group" => [], "fit" => [], "qa" => []];
    while ($row = mysqli_fetch_assoc($result)) {
        $categories[$row["category"]][] = $row;
    }

    ?>
    <h1 style="text-align: center; margin: 20px 0;">Auto-Assign Rules</h1>
    <div style="text-align: center; margin-bottom: 20px;">
        <input type="text" id="usernameSearch" placeholder="Search by Username" style="padding: 8px; width: 80%; font-size: 16px;" value="<?= $_GET['user'] ?? '' ?>" <?= $_GET['user'] ? 'readonly' : '' ?>>
    </div>
    <?php foreach ($categories as $category => $rows) { ?>
        <table class="styled-table" style="width: 80%; margin: 20px auto;">
            <thead>
                <tr>
                    <th style="width: 35%; background-color: #334155; color: white;"> <?php echo $userFullName[$category]; ?> </th>
                    <th style="width: 10%; background-color: #334155; color: white;">Type</th>
                    <th style="width: 10%; background-color: #334155; color: white;"></th>
                    <th style="width: 50%; background-color: #334155; color: white;">Period</th>
                    <th style="background-color: #334155; color: white;"></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $mergedRows = [];
                foreach ($rows as $row) {
                    $key = $row["username"] . "|" . $row["region"];
                    $period = $monthNames[$row["start_m"]] . "-" . $row["start_d"] . " - " . $monthNames[$row["end_m"]] . "-" . $row["end_d"];

                    if (!isset($mergedRows[$key])) {
                        $mergedRows[$key] = [
                            "category" => $category,
                            "username" => $row["username"],
                            "assign_type" => $row["assign_type"],
                            "region" => $row["region"],
                            "periods" => [],
                            "auto_ids" => []
                        ];
                    }

                    $mergedRows[$key]["periods"][] = [
                        "text" => $period,
                        "id" => $row['auto_id']
                    ];
                    $mergedRows[$key]["auto_ids"][] = $row['auto_id']; // Collect auto_ids for AJAX
                }
                ?>

                <?php foreach ($mergedRows as $mergedRow) { ?>
                    <tr <?= $mergedRow['assign_type'] == 'overAmount' ? 'style="background-color: silver;"' : '' ?><?= $mergedRow['assign_type'] == 'keyPartner' ? 'style="background-color: gold;"' : '' ?>>
                        <td style="width: 25%;"> <?php echo $mergedRow["username"]; ?> </td>
                        <td style="width: 10%;">
                            <?php
                            if ($mergedRow["assign_type"] == "region") {
                                echo 'Region';
                            } else if ($mergedRow["assign_type"] == "overAmount") {
                                echo 'Amount';
                            } else if ($mergedRow["assign_type"] == "keyPartner") {
                                echo 'Key Partner';
                            }
                            ?>
                        </td>
                        <td style="width: 20%;">
                            <?php $isKeyPartner = true; ?>
                            <?= ($mergedRow["assign_type"] == "overAmount") ? '> $' : '' ?> <?php echo $mergedRow["assign_type"] == "keyPartner" ? '' : $mergedRow["region"]; ?>
                            <?php if ($mergedRow["assign_type"] == "keyPartner") : ?>
                                <?php
                                $regions = explode(";;", $mergedRow['region']);
                                $isKeyPartner = count($regions) <= 1;
                                foreach ($regions as $region) {
                                    ?>
                                    <span style="display: inline-block; background-color: lightgray; padding: 5px 10px; margin: 2px; border-radius: 10px; position: relative;">
                                        <?php echo htmlspecialchars($region); ?>  
                                        <?php if(!$isKeyPartner) : ?>
                                        <button onclick="deleteRegion('<?php echo addslashes($region); ?>', <?php echo htmlspecialchars(json_encode($mergedRow['auto_ids'])); ?>, this)" 
                                            style="border: none; background: none; color: red; font-weight: bold; position: absolute; top: -5px; right: -5px; cursor: pointer;">
                                            <i class="fa-solid fa-xmark"></i>
                                        </button>
                                        <?php endif;?>
                                    </span>
                                    <?php
                                }
                                ?>
                                <button type="button" onclick="openAddOrgModal(<?php echo htmlspecialchars(json_encode($mergedRow["auto_ids"])); ?>)" style="padding: 5px 10px; margin: 2px; border-radius: 10px; background-color: lightgray; border: none; color: black;">+</button>
                            <?php endif;?>
                        </td>
                        <td style="width: 50%;">
                            <?php foreach ($mergedRow["periods"] as $period) { ?>
                                <span style="display: inline-block; background-color: lightgray; padding: 5px 10px; margin: 2px; border-radius: 10px; position: relative;">
                                    <?php echo $period["text"]; ?>
                                    <?php if($isKeyPartner) : ?>
                                        <button onclick="deleteRow(<?php echo $period['id']; ?>, this)" style="border: none; background: none; color: red; font-weight: bold; position: absolute; top: -5px; right: -5px; cursor: pointer;"><i class="fa-solid fa-xmark"></i></button>
                                    <?php endif;?>
                                </span>
                            <?php } ?>
                            <?php if($isKeyPartner) : ?>
                                <button style="padding: 5px 10px; margin: 2px; border-radius: 10px; background-color: lightgray; border: none; color: black;" 
                                        onclick="openAddModal('<?php echo $mergedRow["category"]; ?>', '<?php echo $mergedRow["username"]; ?>', '<?php echo $mergedRow["region"]; ?>', '<?php echo $mergedRow["assign_type"]; ?>')">
                                    <i class="fa-solid fa-plus"></i>
                                </button>
                            <?php endif;?>
                        </td>
                        <td>
                            <button onclick='openEditModal(<?php echo json_encode($mergedRow); ?>)'>
                                <i class="fa-solid fa-wrench"></i>
                            </button>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    <?php } ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function deleteRow(auto_id, rowElement) {
            if (confirm("Are you sure you want to delete this rule?")) {
                $.ajax({
                    url: 'ajax_delete_assign_rule.php',
                    type: 'POST',
                    data: { auto_id: auto_id },
                    success: function(response) {
                        if (response === 'success') {
                            window.location.reload();
                        } else {
                            alert("Error deleting record.");
                        }
                    }
                });
            }
        }
        
        function filterTable(value) {
            value = value.toLowerCase();

            // Iterate through each table and check rows
            $("table.styled-table").each(function() {
                var table = $(this);
                var visibleRows = 0;

                // Show or hide rows based on search input
                table.find("tbody tr").each(function() {
                    var row = $(this);
                    var username = row.find("td").first().text().toLowerCase();
                    if (username.indexOf(value) > -1) {
                        row.show();
                        visibleRows++;
                    } else {
                        row.hide();
                    }
                });

                // Hide the table if no rows are visible
                if (visibleRows > 0) {
                    table.show();
                } else {
                    table.hide();
                }
            });
        }

        $(document).ready(function() {
            // Get initial search value from input field (which holds the GET parameter value)
            var initialSearch = $("#usernameSearch").val().trim();
            if (initialSearch !== "") {
                filterTable(initialSearch);
            }

            $("#usernameSearch").on("keyup", function() {
                filterTable($(this).val());
            });
        });
    </script>

    <!-- Modal for Editing -->
    <div id="editModal" style="display: none; position: fixed; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
        <div style="background: white; margin: 10% auto; padding: 20px; width: 30%; text-align: left;">
            <?php
            // Fetch regions from database (same logic as in the assign modal)
            $regionQuery = "SELECT groupname FROM vtiger_groups";
            $regionResult = mysqli_query($conn, $regionQuery);
            $regions = [];
            while ($row = mysqli_fetch_assoc($regionResult)) {
                $regions[] = $row['groupname'];
            }

            $userOptions = [];
            foreach ($userRoles as $key => $roleTitle) {
                $userQuery = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE title = '$roleTitle'";
                $userResult = mysqli_query($conn, $userQuery);
                while ($row = mysqli_fetch_assoc($userResult)) {
                    $userOptions[$key][] = $row['name'];
                }
            }
            ?>
            
            <h2 style="margin-bottom: 20px;">Assign Rule Tools</h2>

            <label>Role:
                <select id="edit_category" style="width: 100%; padding: 5px;" onchange="updateUsernameOptionsEdit()">
                    <option value=""></option>
                    <option value="sales">Internal Sales</option>
                    <option value="external">External Sales</option>
                    <option value="group">Ops</option>
                    <option value="qa">QA</option>
                </select>
            </label><br><br>

            <label>Username:
                <select id="edit_username" style="width: 100%; padding: 5px;">
                    <option value=""></option>
                </select>
            </label><br><br>

            <label>Rule Type:
                <select id="edit_assignType" style="width: 100%; padding: 5px;" onchange="toggleEditAssignFields()">
                    <option value="region">Region</option>
                    <option value="amount">Amount</option>
                    <option value="keyPartner">Key Partner</option>
                </select>
            </label><br><br>

            <!-- Region Dropdown -->
            <label id="edit_regionLabel">Region:
                <select id="edit_region" style="width: 100%; padding: 5px;">
                    <option value=""></option>
                    <?php foreach ($regions as $region) { echo "<option value=\"$region\">$region</option>"; } ?>
                </select>
            </label>

            <!-- Amount Input -->
            <label id="edit_amountLabel" style="display: none;">Threshold Amount:
                <input type="number" min="0" step="0.01" id="edit_thresholdAmount" style="width: 100%; padding: 5px;">
            </label>

            <!-- Key Partner Input -->
            <label id="edit_keyPartnerLabel" style="display: none;">Key Partner:
                <?php $accountContacts = getAccountContacts2($conn); ?>
                <input type="text" id="edit_keyPartner" style="width: 100%; padding: 5px;" list="edit_organizationList">
                <datalist id="edit_organizationList">
                    <?php foreach (array_keys($accountContacts) as $name): ?>
                        <option value="<?php echo $name; ?>"></option>
                    <?php endforeach; ?>
                </datalist>
            </label><br><br>

            <script>
                function toggleEditAssignFields() {
                    const assignType = document.getElementById("edit_assignType").value;
                    
                    document.getElementById("edit_regionLabel").style.display = (assignType === "region") ? "block" : "none";
                    document.getElementById("edit_amountLabel").style.display = (assignType === "amount") ? "block" : "none";
                    document.getElementById("edit_keyPartnerLabel").style.display = (assignType === "keyPartner") ? "block" : "none";
                }
            </script>

            <input type="hidden" id="edit_auto_ids" name="auto_ids"> <!-- To store the auto_ids -->

            <button type="submit" onclick="submitEditForm()" style="margin-top: 10px; padding: 10px; background: #334155; color: white; border: none; cursor: pointer;">Reassign</button>
            <button type="button" onclick="copyRows()" style="margin-top: 10px; padding: 10px; background: #efab23; color: black; border: none; cursor: pointer;">Copy</button>
            <button type="button" onclick="closeEditModal()" style="margin-top: 10px; padding: 10px; background: red; color: white; border: none; cursor: pointer;">Cancel</button>
        </div>
    </div>
    <script>
        function openEditModal(rowData) {
            // Fill the modal fields with the existing data
            document.getElementById("edit_category").value = rowData.category;
            document.getElementById("edit_auto_ids").value = JSON.stringify(rowData.auto_ids); // Pass the auto_ids as a JSON string
            
            // Show the modal
            document.getElementById("editModal").style.display = 'block';
            
            // Update username options based on the selected category
            updateUsernameOptionsEdit();

            document.getElementById("edit_username").value = rowData.username;
        }

        function closeEditModal() {
            // Hide the modal
            document.getElementById("editModal").style.display = 'none';
        }

        function updateUsernameOptionsEdit() {
            const role = document.getElementById("edit_category").value;
            const usernameSelect = document.getElementById("edit_username");
            usernameSelect.innerHTML = "";

            const userOptions = {
                "sales": <?php echo json_encode($userOptions["sales"]); ?>,
                "external": <?php echo json_encode($userOptions["external"]); ?>,
                "group": <?php echo json_encode($userOptions["group"]); ?>,
                "fit": <?php echo json_encode($userOptions["fit"]); ?>,
                "qa": <?php echo json_encode($userOptions["qa"]); ?>
            };

            // Add the relevant usernames based on selected category
            userOptions[role].forEach(user => {
                let option = document.createElement("option");
                option.value = user;
                option.textContent = user;
                usernameSelect.appendChild(option);
            });
        }

        function submitEditForm() {
            const formData = new FormData();
            formData.append('category', document.getElementById('edit_category').value);
            formData.append('username', document.getElementById('edit_username').value);
            formData.append('auto_ids', document.getElementById('edit_auto_ids').value);
            formData.append('assignType', document.getElementById('edit_assignType').value);
            formData.append('region', document.getElementById('edit_region').value);
            formData.append('thresholdAmount', document.getElementById('edit_thresholdAmount').value);
            formData.append('keyPartner', document.getElementById('edit_keyPartner').value);
            
            // Make AJAX call to update the rule
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_update_auto_assign_rule.php", true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    alert('Auto-Assign Rule updated successfully!');
                    location.reload(); // Reload the page to see the changes
                } else {
                    alert('Failed to update the rule.');
                }
            };
            xhr.send(formData);
        }

        function copyRows() {
            const formData = new FormData();
            formData.append('auto_ids', document.getElementById('edit_auto_ids').value);
            formData.append('category', document.getElementById('edit_category').value);
            formData.append('username', document.getElementById('edit_username').value);
            formData.append('assignType', document.getElementById('edit_assignType').value);
            
            if (document.getElementById('edit_assignType').value === "region") {
                formData.append('region', document.getElementById('edit_region').value);
            } else if (document.getElementById('edit_assignType').value === "amount") {
                formData.append('assignType', "overAmount");
                formData.append('region', document.getElementById('edit_thresholdAmount').value);
            } else if (document.getElementById('edit_assignType').value === "keyPartner") {
                formData.append('region', document.getElementById('edit_keyPartner').value);
            }

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_copy_auto_assign_rule.php", true);
            xhr.onload = function() {
                if (xhr.status === 200) {
                    alert('Rows copied successfully!');
                    location.reload();
                } else {
                    alert('Failed to copy the rows.');
                }
            };
            xhr.send(formData);
        }
    </script>
    
    <!-- Add New Assign Rule -->
    <div style="display: flex; justify-content: center; ">
        <button onclick="openModal()" style="margin: 10px; padding: 10px; background: #334155; color: white; border: none; cursor: pointer;">
            New Rules
        </button>
    </div>
    <div id="assignModal" style="display: none; position: fixed; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
        <div style="background: white; margin: 10% auto; padding: 20px; width: 30%; text-align: left;">
            <?php
            $regionQuery = "SELECT groupname FROM vtiger_groups";
            $regionResult = mysqli_query($conn, $regionQuery);
            $regions = [];
            while ($row = mysqli_fetch_assoc($regionResult)) {
                $regions[] = $row['groupname'];
            }

            $userOptions = [];
            foreach ($userRoles as $key => $roleTitle) {
                $userQuery = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE title = '$roleTitle'";
                $userResult = mysqli_query($conn, $userQuery);
                while ($row = mysqli_fetch_assoc($userResult)) {
                    $userOptions[$key][] = $row['name'];
                }
            }
            ?>
            <h2 style="margin-bottom: 20px;">Add Assign Rules</h2>
            <label>Role:
                <select id="category" style="width: 100%; padding: 5px;" onchange="updateUsernameOptions()">
                    <option value=""></option>
                    <option value="sales">Internal Sales</option>
                    <option value="external">External Sales</option>
                    <option value="group">Ops</option>
                    <option value="qa">QA</option>
                </select>
            </label><br><br>

            <label>Username:
                <select id="username" style="width: 100%; padding: 5px;">
                    <option value=""></option>
                </select>
            </label><br><br>

            <label>Rule Type:
                <select id="assignType" style="width: 100%; padding: 5px;" onchange="toggleAssignFields()">
                    <option value="region">Region</option>
                    <option value="amount">Amount</option>
                    <option value="keyPartner">Key Partner</option>
                </select>
            </label><br><br>

            <!-- Region Dropdown -->
            <label id="regionLabel">Region:
                <select id="region" style="width: 100%; padding: 5px;">
                    <option value=""></option>
                    <?php foreach ($regions as $region) { echo "<option value=\"$region\">$region</option>"; } ?>
                </select>
            </label>

            <!-- Amount Input -->
            <label id="amountLabel" style="display: none;">Threshold Amount:
                <input type="number" min="0" step="0.01" id="thresholdAmount" style="width: 100%; padding: 5px;">
            </label>

            <!-- Key Partner Input -->
            <label id="keyPartnerLabel" style="display: none;">Key Partner:
                <?php $accountContacts = getAccountContacts2($conn); ?>
                <input type="text" id="keyPartner" style="width: 100%; padding: 5px;" list="organizationList">
                <datalist id="organizationList">
                    <?php foreach (array_keys($accountContacts) as $name): ?>
                        <option value="<?php echo $name; ?>"></option>
                    <?php endforeach; ?>
                </datalist>
            </label><br><br>
            <script>
                function updateUsernameOptions() {
                    const role = document.getElementById("category").value;
                    const usernameSelect = document.getElementById("username");
                    usernameSelect.innerHTML = "";

                    const userOptions = {
                        "sales": <?php echo json_encode($userOptions["sales"]); ?>,
                        "external": <?php echo json_encode($userOptions["external"]); ?>,
                        "group": <?php echo json_encode($userOptions["group"]); ?>,
                        "fit": <?php echo json_encode($userOptions["fit"]); ?>,
                        "qa": <?php echo json_encode($userOptions["qa"]); ?>
                    };

                    userOptions[role].forEach(user => {
                        let option = document.createElement("option");
                        option.value = user;
                        option.textContent = user;
                        usernameSelect.appendChild(option);
                    });
                }
            </script>
            <label>Start Date: <br>
                <select id="start_month" onchange="updateDays('start_month', 'start_day')" style="width: 48%; padding: 5px;">
                    <option value=""></option>
                    <option value="01">January</option>
                    <option value="02">February</option>
                    <option value="03">March</option>
                    <option value="04">April</option>
                    <option value="05">May</option>
                    <option value="06">June</option>
                    <option value="07">July</option>
                    <option value="08">August</option>
                    <option value="09">September</option>
                    <option value="10">October</option>
                    <option value="11">November</option>
                    <option value="12">December</option>
                </select> -
                <select id="start_day" style="width: 48%; padding: 5px;"></select>
            </label><br>

            <label>End Date: <br>
                <select id="end_month" onchange="updateDays('end_month', 'end_day')" style="width: 48%; padding: 5px;">
                    <option value=""></option>
                    <option value="01">January</option>
                    <option value="02">February</option>
                    <option value="03">March</option>
                    <option value="04">April</option>
                    <option value="05">May</option>
                    <option value="06">June</option>
                    <option value="07">July</option>
                    <option value="08">August</option>
                    <option value="09">September</option>
                    <option value="10">October</option>
                    <option value="11">November</option>
                    <option value="12">December</option>
                </select> -
                <select id="end_day" style="width: 48%; padding: 5px;"></select>
            </label><br>
            <button onclick="submitForm()" style="margin-top: 10px; padding: 10px; background: #334155; color: white; border: none; cursor: pointer;">Save</button>
            <button onclick="closeModal()" style="margin-top: 10px; padding: 10px; background: red; color: white; border: none; cursor: pointer;">Cancel</button>
        </div>
    </div>
    <script>
        function toggleAssignFields() {
            const assignType = document.getElementById("assignType").value;
            
            document.getElementById("regionLabel").style.display = (assignType === "region") ? "block" : "none";
            document.getElementById("amountLabel").style.display = (assignType === "amount") ? "block" : "none";
            document.getElementById("keyPartnerLabel").style.display = (assignType === "keyPartner") ? "block" : "none";
        }

        function updateDays(monthSelectId, daySelectId) {
            const monthSelect = document.getElementById(monthSelectId);
            const daySelect = document.getElementById(daySelectId);
            const month = monthSelect.value;
            
            const daysInMonth = {
                "01": 31, "02": 29, "03": 31, "04": 30,
                "05": 31, "06": 30, "07": 31, "08": 31,
                "09": 30, "10": 31, "11": 30, "12": 31
            };
            
            daySelect.innerHTML = "";
            for (let i = 1; i <= daysInMonth[month]; i++) {
                let option = document.createElement("option");
                option.value = i < 10 ? "0" + i : i;
                option.textContent = i;
                daySelect.appendChild(option);
            }
        }
        
        function openAddModal(category, username, region, assign_type) {
            // Open the modal
            document.getElementById("assignModal").style.display = "block";
            
            // Set the values in the modal form
            document.getElementById("category").value = category;

            if(assign_type == 'overAmount') {
                document.getElementById("assignType").value = 'amount';
            } else {
                document.getElementById("assignType").value = assign_type;
            }

            toggleAssignFields();
            if(assign_type == 'region') {
                document.getElementById("region").value = region;
            } else if(assign_type == 'overAmount') {
                document.getElementById("thresholdAmount").value = region;
            } else if(assign_type == 'keyPartner') {
                document.getElementById("keyPartner").value = region;
            }

            // Optional: Trigger username selection change if necessary (e.g., if you want to populate more fields)
            updateUsernameOptions();

            document.getElementById("username").value = username;
        }

        function openModal() {
            document.getElementById("category").value = '<?= $global_category ?>';
            updateUsernameOptions();
            document.getElementById("username").value = '<?= $global_user ?>';

            document.getElementById("assignType").value = '';
            document.getElementById("region").value = '';
            document.getElementById("thresholdAmount").value = '';
            document.getElementById("keyPartner").value = '';

            document.getElementById("assignModal").style.display = "block";
        }
        
        function closeModal() {
            document.getElementById("assignModal").style.display = "none";
        }
        
        function submitForm() {
            const username = document.getElementById("username").value;
            const assignType = document.getElementById("assignType").value;
            const category = document.getElementById("category").value;
            const startMonth = document.getElementById("start_month").value;
            const startDay = document.getElementById("start_day").value;
            const endMonth = document.getElementById("end_month").value;
            const endDay = document.getElementById("end_day").value;

            let region = "";
            let thresholdAmount = "";
            let keyPartner = "";
            
            if (assignType === "region") {
                region = document.getElementById("region").value;
            } else if (assignType === "amount") {
                thresholdAmount = document.getElementById("thresholdAmount").value;
            } else if (assignType === "keyPartner") {
                keyPartner = document.getElementById("keyPartner").value;
            }

            if (!username || !category || !startMonth || !startDay || !endMonth || !endDay || (assignType === "region" && !region) || (assignType === "amount" && !thresholdAmount) || (assignType === "keyPartner" && !keyPartner)) {
                alert("Please fill all fields.");
                return;
            }

            const formData = new FormData();
            formData.append("username", username);
            formData.append("assignType", assignType);
            formData.append("category", category);
            formData.append("start_m", startMonth);
            formData.append("start_d", startDay);
            formData.append("end_m", endMonth);
            formData.append("end_d", endDay);
            
            if (assignType === "region") {
                formData.append("region", region);
            } else if (assignType === "amount") {
                formData.append("thresholdAmount", thresholdAmount);
            } else if (assignType === "keyPartner") {
                formData.append("keyPartner", keyPartner);
            }

            fetch("ajax_save_assign_rule.php", {
                method: "POST",
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                alert(data);
                window.location.reload();
            })
            .catch(error => console.error("Error:", error));
        }
    </script>

    <!-- Modal Structure -->
    <div id="addOrgModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%);
        background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.2); z-index: 1000;">
        <h3>Add Organization</h3>
        <?php $accountContacts = getAccountContacts2($conn); ?>
        <input type="text" id="orgInput" style="width: 100%; padding: 5px;" list="organizationList">
        <datalist id="organizationList">
            <?php foreach (array_keys($accountContacts) as $name): ?>
                <option value="<?php echo $name; ?>"></option>
            <?php endforeach; ?>
        </datalist>
        <br><br>
        <button onclick="submitOrg()">Submit</button>
        <button onclick="closeAddOrgModal()">Cancel</button>
    </div>
    <!-- Overlay Background -->
    <div id="modalOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 999;" onclick="closeAddOrgModal()"></div>

    <script>
        let selectedAutoIds = [];

        function openAddOrgModal(autoIds) {
            selectedAutoIds = autoIds; // Store the auto_ids
            document.getElementById('addOrgModal').style.display = 'block';
            document.getElementById('modalOverlay').style.display = 'block';
        }

        function closeAddOrgModal() {
            document.getElementById('addOrgModal').style.display = 'none';
            document.getElementById('modalOverlay').style.display = 'none';
        }

        function submitOrg() {
            let newOrg = document.getElementById('orgInput').value;

            if (newOrg.trim() === '') {
                alert("Please enter an organization name.");
                return;
            }

            let xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_auto_assign_add_organization.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded"); // Change content type

            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    alert(xhr.responseText);
                    closeAddOrgModal();
                    location.reload();
                }
            };

            let data = "organization=" + encodeURIComponent(newOrg) + "&auto_ids=" + encodeURIComponent(JSON.stringify(selectedAutoIds));

            xhr.send(data); // Send as URL-encoded form data
        }

        function deleteRegion(regionName, autoIds, buttonElement) {
            if (!confirm("Are you sure you want to delete this organization?")) return;

            let xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_auto_assign_delete_region.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    alert(xhr.responseText);
                    location.reload();
                }
            };

            let data = "region=" + encodeURIComponent(regionName) + "&auto_ids=" + encodeURIComponent(JSON.stringify(autoIds));
            xhr.send(data);
        }
    </script>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}

include "chatbot.php";

// disable copy and paste
$pages = ['organizations', 'add-new-organization', 'organization-details', 
          'vendors', 'add-new-vendors', 'vendor-details',
          'add-new-products', 'product-details', 'products-list', 'product-price-import'];
if(isset($_GET['opt']) && $_GET['opt'] && in_array($_GET['opt'], $pages)) {
    ?>
    <style>
        body {
            user-select: none; /* Disables text selection */
        }
    </style>
    <script>
        // Disable copy event
        document.addEventListener('copy', function(e) {
            e.preventDefault();
        });

        // Disable cut event
        document.addEventListener('cut', function(e) {
            e.preventDefault();
        });

        // Disable right-click context menu
        document.addEventListener('contextmenu', function(e) {
            e.preventDefault();
        });
    </script>
    <?php
}

function generateOccupantsRows($conn, $quote_id, $quote_sequence_no, $sequence) {
    $sql = "SELECT * FROM vtiger_pax_in_hotel WHERE quoteid='$quote_id' AND room_seq_no='$sequence' ORDER BY room_seq_no ASC";
    $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));
    
    $rows = '';
    $i = 0;
    while ($room = mysqli_fetch_assoc($result)) {
        $i += 1;
        $title = htmlspecialchars($room['title'] ?? '');
        $surname = htmlspecialchars($room['surname'] ?? '');
        $givenName = htmlspecialchars($room['given_name'] ?? '');
    
        $titleOptions = ['Mr', 'Mrs', 'Miss', 'Ms', 'MSTR'];
    
        // Build the <option> elements
        $titleSelect = "<select name='title_{$sequence}_{$i}'>";
        foreach ($titleOptions as $option) {
            $selected = ($title === $option) ? 'selected' : '';
            $titleSelect .= "<option value='{$option}' {$selected}>{$option}</option>";
        }
        $titleSelect .= "</select>";
    
        $rows .= "
            <tr>
                <td style='width: 10%;'>{$titleSelect}</td>
                <td><input type='text' name='given_name_{$sequence}_{$i}' value='{$givenName}' placeholder='Given Name'></td>
                <td><input type='text' name='surname_{$sequence}_{$i}' value='{$surname}' placeholder='Surname'></td>
            </tr>";
    }
    

    return $rows;
}

function getMonthRange($monthOffset) {
    $firstDay = date('Y-m-01', strtotime("+$monthOffset months"));
    $lastDay = date('Y-m-t', strtotime("+$monthOffset months"));
    return $firstDay . ' to ' . $lastDay;
}

function getMonthRangeMinus($monthOffset) {
    $firstDay = date('Y-m-01', strtotime("-$monthOffset months"));
    $lastDay = date('Y-m-t', strtotime("-$monthOffset months"));
    return $firstDay . ' to ' . $lastDay;
}

?>

<style>
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: center;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        /*background-color: #f9f9f9;*/
    }
    .styled-table tr:hover {
        /* background-color: #d6ebf6 !important; */
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }

    p, strong, h3 {
        margin: 10px;
    }
    
    .so input[type="text"], select {
        margin-bottom: 10px;
    }
    .so textarea {
        height: 30px;
        margin-bottom: 0;
    }
    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }

    button:disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }
</style>

<style>
    .button-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: left;
        margin: 0 0px;
    }

    .button-container button {
        font-size: 16px;
        padding: 10px 20px;
        border: 1px solid #ccc;
        color: white;
        background-color: #334155;
        cursor: pointer;
    }

    .button-container button.active {
        background-color: #5bc0de;
        color: black;
    }

    .content-div {
        margin: 0;
        display: none;
        margin-top: 0px;
        margin-bottom: 10px;
        padding: 0 0px;
    }

    .content-div input[type="text"], select, .content-div input[type="number"] {
        width: 500px;
        height: 30px;
    }

</style>

<style>
    .table-container {
        display: flex;
        flex-direction: row;
        width: 100%;
    }

    .table-wrapper {
        border: 1px solid #ccc;
        border-radius: 5px;
        padding: 10px;
        margin: 20px;
        flex: 1;
        min-width: 300px; /* Ensure minimum width */
    }

    .table-container table {
        width: 100%;
        border-collapse: collapse;
    }

    .table-container th, .table-container td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    .table-container th {
        background-color: #f2f2f2;
    }
</style>

<!-- validate organization / user -->
<script>
    document.getElementById('organization_name').addEventListener('blur', function() {
        var input = this.value;
        var list = document.getElementById('organizationList').options;
        var valid = false;

        if(input.length == 0) {
            valid = true;
        }
        
        for (var i = 0; i < list.length; i++) {
            if (input === list[i].value) {
                valid = true;
                break;
            }
        }
        
        if (!valid) {
            alert('Invalid organization name. Please select a valid one from the list. Use the + button if you want to add a new organization');
            this.value = '';
        }
    });

    document.getElementById('assigned_to').addEventListener('blur', function() {
        var input = this.value;
        var list = document.getElementById('assignedToList').options;
        var valid = false;

        // Check if input matches any option in the datalist
        for (var i = 0; i < list.length; i++) {
            if (input === list[i].value) {
                valid = true;
                break;
            }
        }
        
        if (!valid) {
            alert('Invalid name. Please select a valid one from the list.');
            this.value = '';
        }
    });
</script>

<!-- tab management -->
<script>
    function showDiv(divId, button) {
        <?php
        if(!isset($_GET['sales']) && $_GET['opt'] != 'organization-details' && $_GET['opt'] != 'vendor-details' && $_GET['opt'] != 'product-details') {
            echo "document.getElementById('saleOrderContainer').style.display = 'none';";
        }
        ?>

        // Hide all content divs
        var contentDivs = document.getElementsByClassName('content-div');
        for (var i = 0; i < contentDivs.length; i++) {
            contentDivs[i].style.display = 'none';
        }

        // Show the selected div
        document.getElementById(divId).style.display = 'block';

        // Remove active class from all buttons
        var buttons = document.querySelectorAll('.button-container button');
        buttons.forEach(function(btn) {
            btn.classList.remove('active');
        });

        // Add active class to the clicked button
        button.classList.add('active');

        if(divId == 'div-attraction' || divId == 'div-hotel' || divId == 'div-restaurant' || divId == 'div-transfer' || divId == 'div-tour' || divId == 'div-sic' || divId == 'div-guide') {
            var toggleOperationButtons = document.getElementById('toggleOperationButtons');
            toggleOperationButtons.classList.add('active');
        }
        else if(divId == 'div9' || divId == 'div10' || divId == 'div11' || divId == 'div12') {
            var toggleOperationButtons = document.getElementById('togglePaymentButtons');
            toggleOperationButtons.classList.add('active');
        }
        else {
            var operationButtons = document.getElementById('operation-buttons');
            operationButtons.style.display = 'none';

            var operationButtons = document.getElementById('payment-buttons');
            operationButtons.style.display = 'none';
        }
    }

    function toggleOperationButtons(button) {
        <?php
        if(!isset($_GET['sales'])) {
            echo "document.getElementById('saleOrderContainer').style.display = 'none';";
        }
        ?>

        // Hide all content divs
        var contentDivs = document.getElementsByClassName('content-div');
        for (var i = 0; i < contentDivs.length; i++) {
            contentDivs[i].style.display = 'none';
        }
        
        // Remove active class from all buttons
        var buttons = document.querySelectorAll('.button-container button');
        buttons.forEach(function(btn) {
            btn.classList.remove('active');
        });

        // Add active class to the clicked button
        button.classList.add('active');

        var operationButtons1 = document.getElementById('payment-buttons');
        operationButtons1.style.display = 'none';
        
        var operationButtons = document.getElementById('operation-buttons');
        operationButtons.style.display = 'flex';
    }

    function togglePaymentButtons(button) {
        <?php
        if(!isset($_GET['sales'])) {
            echo "document.getElementById('saleOrderContainer').style.display = 'none';";
        }
        ?>

        // Hide all content divs
        var contentDivs = document.getElementsByClassName('content-div');
        for (var i = 0; i < contentDivs.length; i++) {
            contentDivs[i].style.display = 'none';
        }
        
        // Remove active class from all buttons
        var buttons = document.querySelectorAll('.button-container button');
        buttons.forEach(function(btn) {
            btn.classList.remove('active');
        });

        // Add active class to the clicked button
        button.classList.add('active');

        var operationButtons1 = document.getElementById('operation-buttons');
        operationButtons1.style.display = 'none';
        
        var operationButtons = document.getElementById('payment-buttons');
        operationButtons.style.display = 'flex';
    }

    window.onload = function() {
        const urlParams = new URLSearchParams(window.location.search);
        const pricingStatus = urlParams.get('edit');
        const sales = urlParams.get('sales');
        const opt = urlParams.get('opt');

        if (opt === 'vendor-details') {
            showDiv('div-ven1', document.querySelector('button[onclick*="div-ven1"]'));
        } else if (sales) {
            showDiv('div-fit2', document.querySelector('button[onclick*="div-fit2"]'));
        } else if (pricingStatus === 'doc') {
            showDiv('div5', document.querySelector('button[onclick*="div5"]'));
        } else if (opt === 'organization-details') {
            showDiv('div-org7', document.querySelector('button[onclick*="div-org7"]'));
        } else if (pricingStatus === 'suppliers') {
            togglePaymentButtons(document.querySelector('button[onclick*="togglePaymentButtons"]'));
            showDiv('div12', document.querySelector('button[onclick*="div12"]'));
        } else if (pricingStatus === 'customers') {
            togglePaymentButtons(document.querySelector('button[onclick*="togglePaymentButtons"]'));
            showDiv('div9', document.querySelector('button[onclick*="div9"]'));
        } else if (pricingStatus === 'markup') {
            showDiv('div2', document.querySelector('button[onclick*="div2"]'));
        } else if (pricingStatus === 'adjustment') {
            showDiv('div8', document.querySelector('button[onclick*="div8"]'));
        } else if (pricingStatus === 'operation') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
        } else if (pricingStatus === 'div-transfer') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-transfer', document.querySelector('button[onclick*="div-transfer"]'));
        } else if (pricingStatus === 'div-attraction') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-attraction', document.querySelector('button[onclick*="div-attraction"]'));
        } else if (pricingStatus === 'div-hotel') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-hotel', document.querySelector('button[onclick*="div-hotel"]'));
        } else if (pricingStatus === 'div-restaurant') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-restaurant', document.querySelector('button[onclick*="div-restaurant"]'));
        } else if (pricingStatus === 'div-tour') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-tour', document.querySelector('button[onclick*="div-tour"]'));
        } else if (pricingStatus === 'div-transfers') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-transfers', document.querySelector('button[onclick*="div-transfers"]'));
        } else if (pricingStatus === 'div-guide') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-guide', document.querySelector('button[onclick*="div-guide"]'));
        } else if (pricingStatus === 'div-sic') {
            toggleOperationButtons(document.querySelector('button[onclick*="toggleOperationButtons"]'));
            showDiv('div-sic', document.querySelector('button[onclick*="div-sic"]'));
        } else if (pricingStatus === 'div-notes') {
            toggleOperationButtons(document.querySelector('button[onclick*="div-notes"]'));
            showDiv('div-notes', document.querySelector('button[onclick*="div-notes"]'));
        } else if (pricingStatus === 'pricebook') {
            showDiv('div-pro1', document.querySelector('button[onclick*="div-pro1"]'));
        } else if (pricingStatus === 'associated-products') {
            showDiv('div-pro2', document.querySelector('button[onclick*="div-pro2"]'));
        } else if (pricingStatus === 'suggested-products') {
            showDiv('div-pro3', document.querySelector('button[onclick*="div-pro3"]'));
        } else if (pricingStatus === 'subproduct') {
            showDiv('div-pro4', document.querySelector('button[onclick*="div-pro4"]'));
        } else if (pricingStatus === 'product-price') {
            showDiv('div-pro5', document.querySelector('button[onclick*="div-pro5"]'));
        } else if (pricingStatus === 'non-allowed-products') {
            showDiv('div-pro6', document.querySelector('button[onclick*="div-pro6"]'));
        } else if (pricingStatus === 'product-vendors') {
            showDiv('div-pro7', document.querySelector('button[onclick*="div-pro7"]'));
        } else if (pricingStatus === 'product-faq') {
            showDiv('div-pro8', document.querySelector('button[onclick*="div-pro8"]'));
        } else {
            showDiv('div1', document.querySelector('button[onclick*="div1"]'));
        }
    }

    document.getElementById('newOrganizationForm').addEventListener('submit', function(event){
        var organizationName = document.getElementById('new_organization_name').value.trim();
        if (organizationName == 'Turtle Down Under' || organizationName == 'TDU') {
            event.preventDefault();
            alert('Organization name cannot be "Turtle Down Under" or "TDU". Please choose a different name.');
        }
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const input = document.getElementById('organization_name');
        const datalist = document.getElementById('organizationList');

        // Initially, remove the datalist attribute
        input.removeAttribute('list');

        input.addEventListener('input', function () {
            // Add the datalist attribute only if there is input text
            if (this.value.length > 0) {
                input.setAttribute('list', 'organizationList');
            } else {
                input.removeAttribute('list');
            }
        });
    });
</script>
