<?php 
// Quote Details
if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'summary' && isset($_GET['sales'])) {
    $quoteid = $_GET['quoteid'];
    $quotetype = $_GET['quotetype'];
    if($quotetype == 'fit-dashboard') {
        $quotetype = 'group';
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_info'])) {
        $assigned_to_region = $_POST['assigned_to_region'];
        $assigned_to_sales_agent = $_POST['assigned_to_sales_agent'];
        $assigned_to_external_sales_agent = $_POST['assigned_to_external_sales_agent'];
        $priority = $_POST['priority'];
        
        $sql = "INSERT INTO vtiger_quotes_info 
                    (quoteid, assigned_to_region, assigned_to_sales_agent, assigned_to_external_sales_agent, priority, time_stamp_with_name, quotetype)
                VALUES
                    ('$quoteid', '$assigned_to_region', '$assigned_to_sales_agent', '$assigned_to_external_sales_agent', '$priority', NOW(), '$quotetype')
                ON DUPLICATE KEY UPDATE
                    assigned_to_region = '$assigned_to_region',
                    assigned_to_sales_agent = '$assigned_to_sales_agent',
                    assigned_to_external_sales_agent = '$assigned_to_external_sales_agent',
                    priority = '$priority',
                    quotetype = '$quotetype';";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));

        if(isset($_POST['quote_stage']) && $_POST['quote_stage'] != '') {
            $quote_stage = $_POST['quote_stage'];

            // Check the latest stage for the given quoteid
            $check_sql = "SELECT quotestage FROM vtiger_quotes WHERE quoteid = '$quoteid' LIMIT 1;";
            $check_result = mysqli_query($conn, $check_sql);

            if ($check_result && mysqli_num_rows($check_result) > 0) {
                $check_row = mysqli_fetch_assoc($check_result);
                $latest_stage = $check_row['quotestage'];

                if ($latest_stage != $quote_stage) {
                    $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                                    VALUES ('$quoteid', '$username', 'Change Stage to $quote_stage', NOW());";
                    mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));
    
                    if($latest_stage == 'Created' && $quote_stage == 'Accepted') {
                        $insert_sql5 = "INSERT INTO tdu_mailbox_tmp_send_vendor (quoteid, transfers_actioned, a_t_actioned) VALUES ('$new_quoteid', '0', '0');";
                        mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
                    }
                }
            } else {
                $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                                VALUES ('$quoteid', '$username', 'Change Stage to $quote_stage', NOW());";
                mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));
            }

            if($quotetype == 'fit') {
                $sql_stage = "UPDATE vtiger_quotes_crm SET quotestage = '$quote_stage' WHERE quoteid = '$quoteid';";
            } else {
                $sql_stage = "UPDATE vtiger_quotes SET quotestage = '$quote_stage' WHERE quoteid = '$quoteid';";
            }
            mysqli_query($conn, $sql_stage) or die(mysqli_error($conn));
        }
        if(isset($_POST['payment_deadline']) || isset($_POST['accepted_date'])) {
            if($quotetype == 'fit') {
                $table = 'vtiger_quotescf_crm';
            }
            else {
                $table = 'vtiger_quotescf';
            }
        }
        if (isset($_POST['payment_deadline']) && $_POST['payment_deadline'] != '') {
            $payment_deadline = $_POST['payment_deadline'];
            if (isset($_POST['payment_deadline_pending']) && $_POST['payment_deadline_pending'] == 1 && $title != 'admin') {
                $sql_update_payment_deadline = "UPDATE $table SET cf_1182_pending = '$payment_deadline' WHERE quoteid = '$quoteid';";
                mysqli_query($conn, $sql_update_payment_deadline) or die(mysqli_error($conn));

                // insert to quote history
                $history_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, stage, user_name)
                                VALUES ($quoteid, 'Request change Payment deadline to $payment_deadline (within 15 days)', '$username')";
                mysqli_query($conn, $history_sql) or die("Error: " . mysqli_error($conn));
            } else {
                $sql_update_payment_deadline = "UPDATE $table SET cf_1182 = '$payment_deadline' WHERE quoteid = '$quoteid';";
                mysqli_query($conn, $sql_update_payment_deadline) or die(mysqli_error($conn));

                // insert to quote history
                $history_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, stage, user_name)
                                VALUES ($quoteid, 'Change Payment deadline to $payment_deadline', '$username')";
                mysqli_query($conn, $history_sql) or die("Error: " . mysqli_error($conn));
            }
        }
        if (isset($_POST['accepted_date']) && $_POST['accepted_date'] != '') {
            $accepted_date = $_POST['accepted_date'];
            $sql_update_accepted_date = "UPDATE $table SET cf_1188 = '$accepted_date' WHERE quoteid = '$quoteid';";
            mysqli_query($conn, $sql_update_accepted_date) or die(mysqli_error($conn));
        }

        if($quote_stage == 'Accepted') {
            $assigned_to_ops = '';
            if(isset($_GET['quotetype']) && $_GET['quotetype'] == 'fit') {
                $sql = "SELECT 
                            vq.quote_no, vq.subject, vq.quotestage, vq.total, vq.country, 
                            va.organization_name AS accountname, 
                            vqcf.cf_1162, vqcf.cf_1542,
                            vqcf.cf_1182, vqcf.cf_1188,
                            vqinfo.assigned_to_region, vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent, vqinfo.assigned_to_ops,
                            vqinfo.priority, 
                            vqinfo.time_stamp_with_name, 
                            vqinfo.travel_agent_contact_name, 
                            vqinfo.office_phone, vqinfo.mobile_phone, vqinfo.email
                        FROM vtiger_quotes_crm vq
                        LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                        LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid=vqcf.quoteid
                        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='fit'
                        WHERE vq.quoteid='$quoteid';";
            } else {
                $sql = "SELECT vq.created_at AS createdtime, 
                            vq.quote_no, vq.subject, vq.quotestage, vq.total, vq.country, 
                            va.organization_name AS accountname, 
                            vqcf.cf_1162, vqcf.cf_1542,
                            vqcf.cf_1182, vqcf.cf_1188,
                            vqinfo.assigned_to_region, vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent, vqinfo.assigned_to_ops,
                            vqinfo.priority, vqinfo.time_stamp_with_name, 
                            vqinfo.travel_agent_contact_name, 
                            vqinfo.office_phone, vqinfo.mobile_phone, vqinfo.email
                        FROM vtiger_quotes vq
                        LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='group'
                        WHERE vq.quoteid='$quoteid';";
            }    
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            $quote_number = $row['quote_no'];
            $assigned_to_region = $row['assigned_to_region'];
            $assigned_to_ops = $row['assigned_to_ops'] ?? '';
            $organization_name = $row['accountname'];
            $date_of_travel = $row['cf_1162'];
        }

        if($quote_stage == 'Accepted' && $assigned_to_ops == '') {
            $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
            $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
            $travel_month = (int) $travel_month;
            $travel_day = (int) $travel_day;

            $sql = "SELECT * FROM tdu_auto_assign_rules 
                    WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                    AND (category = 'group' OR category = 'fit')
                    AND (
                        ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                        AND
                        ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                    )";
            $result = mysqli_query($conn, $sql);

            if(mysqli_num_rows($result) == 0) {
                $sql = "SELECT * FROM tdu_auto_assign_rules 
                        WHERE assign_type = 'region' AND region = '$assigned_to_region'
                        AND (
                            ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                            AND
                            ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                        )";
                $result = mysqli_query($conn, $sql);
            }

            if (mysqli_num_rows($result) > 0) {
                // if (substr($quote_number, -1) === 'G') {
                //     $quotetype_t = "group";
                // } else {
                //     $quotetype_t = "fit";
                // }
                $assignment_map = [
                    "group" => "assigned_to_ops",
                    "qa" => "assigned_to_qa"
                ];

                while ($row = mysqli_fetch_assoc($result)) {
                    $category = $row['category'];
                    if(!isset($assignment_map[$category])) {
                        continue;
                    }
                    $key = $assignment_map[$category];
                    $value = $row['username'];

                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                            VALUES ('$quoteid', 'group', '$value')
                            ON DUPLICATE KEY UPDATE $key = '$value'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }
        }

        if($quotetype == 'group') {
            if ($latest_stage != $quote_stage) {
                createTaskWithMessage($conn, $quote_stage, $new_quote_no);
            }
        }
    }
    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['followup'])) {
        $quoteid = $_POST['quoteid'];

        $follow_up_date = $_POST['follow_up_date'];
        $follow_up_description = $_POST['follow_up_description'];
        $follow_up_type = $_POST['follow_up_type']; // New field
    
        // Additional fields
        $travel_agent_contact_name = $_POST['travel_agent_contact_name'];
        $office_phone = $_POST['office_phone'];
        $mobile_phone = $_POST['mobile_phone'];
        $email = $_POST['email'];
    
        // Escape input data
        $follow_up_date = mysqli_real_escape_string($conn, $follow_up_date);
        $follow_up_description = mysqli_real_escape_string($conn, $follow_up_description);
        $follow_up_type = mysqli_real_escape_string($conn, $follow_up_type); // Escape follow_up_type
        $travel_agent_contact_name = mysqli_real_escape_string($conn, $travel_agent_contact_name);
        $office_phone = mysqli_real_escape_string($conn, $office_phone);
        $mobile_phone = mysqli_real_escape_string($conn, $mobile_phone);
        $email = mysqli_real_escape_string($conn, $email);
    
        // SQL query to insert data including followup_type
        if($follow_up_type == 'schedule_follow_up') {
            $sql = "INSERT INTO vtiger_quotes_followup (quoteid, next_follow_up_date, description, quotetype, followup_type, travel_agent_contact_name, office_phone, mobile_phone, email) 
                    VALUES ('$quoteid', '$follow_up_date', '$follow_up_description', '$quotetype', '$follow_up_type', '$travel_agent_contact_name', '$office_phone', '$mobile_phone', '$email')";
        }
        else {
            $sql_internal_external = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
            $result_internal_external = mysqli_query($conn, $sql_internal_external);
            if(mysqli_num_rows($result_internal_external) > 0) {
                $row_internal_external = $result_internal_external->fetch_assoc();
                $username = $row_internal_external['name'];
            }
            $sql = "INSERT INTO vtiger_quotes_followup (quoteid, next_follow_up_date, description, quotetype, followup_type, travel_agent_contact_name, office_phone, mobile_phone, email, followup, created_by, calltime) 
                    VALUES ('$quoteid', '$follow_up_date', '$follow_up_description', '$quotetype', '$follow_up_type', '$travel_agent_contact_name', '$office_phone', '$mobile_phone', '$email', 'checked', '$username', '$follow_up_date')";
        }
        
        // Execute the query
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
    
        // Redirect after successful insert
        $queryString = http_build_query($_GET);
        header("Location: " . $_SERVER['PHP_SELF'] . ($queryString ? '?' . $queryString : ''));
        exit;
    }    
    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['agent_detail_change'])) {
        $auto_id = $_POST['auto_id'];
        $travel_agent_contact_name = $_POST['travel_agent_contact_name'];
        $office_phone = $_POST['office_phone'];
        $mobile_phone = $_POST['mobile_phone'];
        $email = $_POST['email'];

        $travel_agent_contact_name = mysqli_real_escape_string($conn, $travel_agent_contact_name);
        $office_phone = mysqli_real_escape_string($conn, $office_phone);
        $mobile_phone = mysqli_real_escape_string($conn, $mobile_phone);
        $email = mysqli_real_escape_string($conn, $email);

        $sql = "UPDATE vtiger_quotes_followup 
                SET travel_agent_contact_name = '$travel_agent_contact_name', 
                    office_phone = '$office_phone', 
                    mobile_phone = '$mobile_phone', 
                    email = '$email' 
                WHERE auto_id = '$auto_id'";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));

        // Redirect after successful insert
        $queryString = http_build_query($_GET);
        header("Location: " . $_SERVER['PHP_SELF'] . ($queryString ? '?' . $queryString : ''));
        exit;
    }

    include "header.php";
    if(isset($_GET['quotetype']) && $_GET['quotetype'] == 'fit') {
        $sql = "SELECT 
                    vq.quote_no, vq.subject, vq.quotestage, vq.total, vq.country, 
                    va.organization_name AS accountname, 
                    vqcf.cf_1162, vqcf.cf_1542,
                    vqcf.cf_1182, vqcf.cf_1188, vqcf.cf_1182_pending,
                    vqinfo.assigned_to_region, vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent,
                    vqinfo.priority, 
                    vqinfo.time_stamp_with_name, 
                    vqinfo.travel_agent_contact_name, 
                    vqinfo.office_phone, vqinfo.mobile_phone, vqinfo.email
                FROM vtiger_quotes_crm vq
                LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid=vqcf.quoteid
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='fit'
                WHERE vq.quoteid='$quoteid';";
    } else {
        $sql = "SELECT vq.created_at AS createdtime, 
                    vq.quote_no, vq.subject, vq.quotestage, vq.total, vq.country, 
                    va.organization_name AS accountname, 
                    vqcf.cf_1162, vqcf.cf_1542,
                    vqcf.cf_1182, vqcf.cf_1188, vqcf.cf_1182_pending,
                    vqinfo.assigned_to_region, vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent,
                    vqinfo.priority, vqinfo.time_stamp_with_name, 
                    tc.name AS travel_agent_contact_name, tc.mobile AS mobile_phone, tc.email
                FROM vtiger_quotes vq
                LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='group'
                LEFT JOIN tdu_contacts tc ON vq.contactid = tc.auto_id
                WHERE vq.quoteid='$quoteid' AND vq.deleted=0;";
    }    
    $result = mysqli_query($conn, $sql);
    ?>
    <!-- search bar -->
    <div style="background-color: #EFAB23;">
        <form action="" method="GET" style="display: flex; align-items: center;">
            <p style="margin-right: 0; font-size: 18px;">Search by Quote Number:</p>
            <input type="hidden" name="opt" value="sales-search">
            <input type="text" name="quote_no" style="margin-left: 10px;">
            <button type="submit" style="margin: 0 10px;">Search</button>
        </form>
    </div>
    <?php
    if(mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $createdtime = $row['createdtime'];
        $quote_number = $row['quote_no'];
        $date_of_travel = $row['cf_1162'];
        $payment_deadline = $row['cf_1182'];
        $payment_deadline_pending = $row['cf_1182_pending'] ?? '';
        $accepted_date = $row['cf_1188'];
        $subject = $row['subject'];
        $organizationname = $row['accountname'];
        $quotestage = $row['quotestage'];
        $total = $row['total'];
        $assigned_to_region = $row['assigned_to_region'];
        $assigned_to_sales_agent = $row['assigned_to_sales_agent'];
        $assigned_to_external_sales_agent = $row['assigned_to_external_sales_agent'];
        $country = $row['country'];
        $priority = $row['priority'];
        $sql_followup = "SELECT MIN(next_follow_up_date) AS next_follow_up_date FROM vtiger_quotes_followup WHERE quoteid='$quoteid' AND next_follow_up_date IS NOT NULL;";
        $result_followup = mysqli_query($conn, $sql_followup) or die(mysqli_error($conn));
        if(mysqli_num_rows($result_followup) > 0) {
            $row_followup = mysqli_fetch_assoc($result_followup);
            $next_follow_up_date = $row_followup['next_follow_up_date'];
        } else {
            $next_follow_up_date = '';
        }
        $description = $row['description'];
        $time_stamp_with_name = $row['time_stamp_with_name'];
        $travel_agent_contact_name = $row['travel_agent_contact_name'];
        $office_phone = $row['office_phone'];
        $mobile_phone = $row['mobile_phone'];
        $email = $row['email'];
        ?>
        <div style="padding: 10px; background-color: #c5c5c5;">
            <h2>
                <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                <?php 
                echo htmlspecialchars($quote_number) . ' - ' . htmlspecialchars($subject); 
                ?>
            </h2>
            <div style="display: flex; justify-content: space-between; margin: 0;">
                <div style="flex: 1; padding-right: 20px;">
                    <p>Quote Stage: <?php echo htmlspecialchars($quotestage); ?></p>
                    <p>Created Time: 
                        <?php 
                        if (isset($createdtime)) {
                            $date = new DateTime($createdtime);
                            echo $date->format('d-M-Y H:i:s');
                        }
                        ?>
                    </p>
                    <p>Date of Travel: 
                        <?php 
                        if (isset($date_of_travel) && $date_of_travel != '0000-00-00') {
                            $date = new DateTime($date_of_travel);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </p>
                    <p>Organization Name: <?php echo htmlspecialchars($organizationname); ?></p>
                    <p>Country: <?php echo htmlspecialchars($country); ?></p>
                </div>

                <div style="flex: 1; padding-left: 20px;">
                    <p>Contact Name: <?php echo htmlspecialchars($travel_agent_contact_name); ?></p>
                    <p>Office Phone: <?php echo htmlspecialchars($office_phone); ?></p>
                    <p>Mobile Phone: <?php echo htmlspecialchars($mobile_phone); ?></p>
                    <p>Email: <?php echo htmlspecialchars($email); ?></p>
                </div>

                <div style="flex: 1; padding-left: 20px;">
                    <p>Next Follow-Up Date: 
                        <?php 
                        if (isset($next_follow_up_date) && $next_follow_up_date != '0000-00-00') {
                            $date = new DateTime($next_follow_up_date);
                            echo $date->format('d-M-Y H:i:s');
                        }
                        ?>
                    </p>
                    <p>Time Stamp: 
                        <?php 
                        if (isset($time_stamp_with_name)) {
                            $date = new DateTime($time_stamp_with_name);
                            echo $date->format('d-M-Y H:i:s');
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <?php $allowed_quote_tabs = explode(',', fetchAllowedQuoteTabs($conn, $title)); ?>
        <div class="button-container">
            <?php if (in_array(16, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div-fit2', this)">Follow Up</button>
            <?php endif; ?>
            <?php if (in_array(17, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div-fit1', this)">Edit Sales Details</button>
            <?php endif; ?>
            <?php if (in_array(12, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div13', this)">MailBox</button>
            <?php endif; ?>
            <?php if (in_array(5, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div17', this)">Tasks</button>
            <?php endif; ?>

            <?php 
            if(isset($_GET['quotetype']) && $_GET['quotetype'] == 'fit') {
                ?>
                <button type="button" onclick="window.open('https://crm.turtledownunder.com.au/index.php?module=Quotes&view=Detail&record=<?php echo urlencode($quoteid); ?>', '_blank')">View Quote</button>
                <?php
            } else {
                ?>
                <button type="button" onclick="location.href='?opt=summary&quoteNumber=<?php echo urlencode($quote_number); ?>'">View Quote</button>
                <?php
            }
            ?>
        </div>

        <div id="div-fit1" class="content-div">
            <div class="form-container">
                <form method="post" action="">
                    <div class="form-column">
                        <div class="form-row">
                            <label for="quote_stage">*Quote Stage:</label>
                            <select id="quote_stage" name="quote_stage" required>
                                <?php 
                                $quoteStages = fetchAllowedQuoteStages($conn, $title, $quotestage); 
                                $shouldDisableAccepted = shouldDisableAccepted($conn, $quoteid); 
                                $isPaymentReceivedToAccepted = isPaymentReceivedToAccepted($conn, $quoteid); 
                                if(substr($quote_number, -1) === 'G' || $title == 'admin') {
                                    $shouldDisableAccepted = false;
                                }
                                ?>
                                <script>
                                    var quoteStages = <?php echo json_encode($quoteStages); ?>;
                                    var shouldDisableAccepted = <?php echo json_encode($shouldDisableAccepted); ?>;
                                    var isPaymentReceivedToAccepted = <?php echo json_encode($isPaymentReceivedToAccepted); ?>;
                                    var selectElement = document.getElementById('quote_stage');

                                    var quotestagenow = "<?php echo $quotestage; ?>";
                                    var titlenow = "<?php echo $title; ?>";

                                    quoteStages.forEach(function(stage) {
                                        var option = document.createElement('option');
                                        option.value = stage.quotestage;
                                        option.textContent = stage.quotestage;

                                        // Disable all options that are not enabled
                                        if (!stage.enabled) {
                                            option.disabled = true; 
                                        }

                                        // Specifically disable "Accepted" and add tooltip if required
                                        if (stage.quotestage === 'Accepted' && isPaymentReceivedToAccepted) {
                                            option.disabled = true;
                                            option.setAttribute("title", "Cannot Accept - Payment Not Received and Travel date is within 15 days");
                                        } else if (stage.quotestage === 'Accepted' && shouldDisableAccepted) {
                                            option.disabled = true;
                                            option.setAttribute("title", "Cannot Accept - Rooming list incomplete");
                                        } else if (stage.quotestage === 'Accepted' && quotestagenow === 'Created' && titlenow === 'qa') {
                                            option.disabled = true;
                                        }

                                        selectElement.appendChild(option);
                                    });
                                </script>
                            </select>
                            <script>document.getElementById('quote_stage').value = "<?php echo $quotestage; ?>";</script>
                        </div>
                        <div class="form-row">
                            <label for="payment_deadline">Payment-Cancellation Deadline:</label>
                            <input type="date" id="payment_deadline" name="payment_deadline" value="<?php echo $payment_deadline; ?>" max="<?php echo $date_of_travel; ?>" <?= !empty($payment_deadline_pending) ? 'readonly' : ''; ?> >
                            <input type="hidden" id="payment_deadline_pending" name="payment_deadline_pending" value="0">
                        </div>
                        <div id="deadline-warning" style="color: red; display: none; margin-bottom: 10px; white-space: nowrap;"></div>
                        <?php if (!empty($payment_deadline_pending)) : ?>
                            <div class="form-row">
                                <label style="color: red;" for="payment_deadline_pending">Payment-Cancellation Deadline<br>Pending Approval:</label>
                                <?php if ($title== 'admin') : ?>
                                    <button type="button" id="approve-deadline-btn" title="Approve Deadline">
                                        <i class="fa-solid fa-check"></i>
                                    </button>
                                <?php endif; ?>
                                <input style="color: red;" type="date" value="<?php echo $payment_deadline_pending; ?>" disabled>
                            </div>
                            <script>
                                document.getElementById('approve-deadline-btn').addEventListener('click', function () {
                                    if (!confirm('You may be responsible for the loss if Payment-Cancellation Deadline is set within 15 days. Are you sure you want to approve this payment deadline change?')) return;

                                    fetch('ajax_approve_payment_deadline_change.php', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/x-www-form-urlencoded'
                                        },
                                        body: 'quoteid=<?php echo $quoteid; ?>&payment_deadline_pending=<?php echo urlencode($payment_deadline_pending); ?>&username=<?php echo urlencode($username); ?>'
                                    })
                                    .then(response => response.text())
                                    .then(data => {
                                        alert(data); // or use a toast/message system
                                        location.reload(); // reload to reflect the approved change
                                    })
                                    .catch(error => {
                                        console.error('Error:', error);
                                        alert('Something went wrong. Please try again.');
                                    });
                                });
                            </script>
                        <?php endif; ?>
                        <div class="form-row">
                            <label for="accepted_date">Accepted Date:</label>
                            <input type="date" id="accepted_date" name="accepted_date" value="<?php echo $accepted_date; ?>">
                        </div>
                        <div class="form-row">
                            <label for="priority">Priority:</label>
                            <select id="priority" name="priority">
                                <option value="" <?php echo empty($priority) ? 'selected' : ''; ?>>Select Priority</option>
                                <option value="not connected" <?php echo $priority === 'not connected' ? 'selected' : ''; ?>>Not connected</option>
                                <option value="low" <?php echo $priority === 'low' ? 'selected' : ''; ?>>Low</option>
                                <option value="high" <?php echo $priority === 'high' ? 'selected' : ''; ?>>High</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-column">
                        <div class="form-row">
                            <label for="assigned_to_region">Assigned To (Region):</label>
                            <select name="assigned_to_region">
                                <option value=""></option>
                                <?php
                                // Query to get group names from the vtiger_groups table
                                $sqlr = "SELECT groupname FROM vtiger_groups";
                                $resultr = $conn->query($sqlr);

                                // Populate the select dropdown with group names
                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        $selected = (isset($assigned_to_region) && $assigned_to_region == $rowr['groupname']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-row">
                            <label for="assigned_to_sales_agent">Assigned To (Internal Sales Agent):</label>
                            <select id="assigned_to_sales_agent" name="assigned_to_sales_agent">
                                <option value=""></option>
                                <?php
                                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                        WHERE title IN ('sales', 'admin') 
                                        ORDER BY title ASC;";

                                $resultr = $conn->query($sqlr);
                                $current_title = '';

                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        if ($rowr['title'] !== $current_title) {
                                            $current_title = $rowr['title'];
                                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                                        }

                                        $selected = (isset($assigned_to_sales_agent) && $assigned_to_sales_agent == $rowr['name']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-row">
                            <label for="assigned_to_external_sales_agent">Assigned To (External Sales Agent):</label>
                            <select id="assigned_to_external_sales_agent" name="assigned_to_external_sales_agent">
                                <option value=""></option>
                                <?php
                                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                        WHERE title IN ('external', 'admin') 
                                        ORDER BY title ASC;";

                                $resultr = $conn->query($sqlr);
                                $current_title = '';

                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        if ($rowr['title'] !== $current_title) {
                                            $current_title = $rowr['title'];
                                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                                        }

                                        $selected = (isset($assigned_to_external_sales_agent) && $assigned_to_external_sales_agent == $rowr['name']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>

                        <input type="hidden" name="quotetype" value="<?php echo $_GET['quotetype']; ?>" />
                        <button type="submit" name="update_info">Update</button>
                    </div>
                </form>
            </div>
        </div>
        <script>
            function checkPaymentDeadlineWarning() {
                var quoteStage = document.getElementById('quote_stage').value;
                var paymentDeadline = document.getElementById('payment_deadline').value;
                var warningDiv = document.getElementById('deadline-warning');

                if ((quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') && paymentDeadline) {
                    var travel = new Date("<?= $date_of_travel ?>");
                    var deadlineDate = new Date(paymentDeadline);
                    var diffTime = travel - deadlineDate;
                    var diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)); // Difference in days

                    if (diffDays <= 15) {
                        document.getElementById('payment_deadline_pending').value = 1;
                        warningDiv.style.display = 'block';
                        warningDiv.innerHTML = "<i class='fa-solid fa-triangle-exclamation'></i> You may be responsible for the loss if Payment-Cancellation Deadline is set within 15 days.<br><i class='fa-solid fa-triangle-exclamation'></i> Please check with your admin.";
                        return;
                    }
                }

                document.getElementById('payment_deadline_pending').value = 0;
                warningDiv.style.display = 'none';
                warningDiv.innerHTML  = '';
            }

            document.getElementById('quote_stage').addEventListener('change', function () {
                var quoteStage = this.value;
                var today = new Date();

                if (quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') {
                    document.getElementById('accepted_date').value = today.toISOString().split('T')[0];
                    document.getElementById('payment_deadline').required = true;

                    // Calculate 15 days before date_of_travel
                    var dateOfTravel = new Date("<?php echo $date_of_travel; ?>");
                    var paymentDeadline = new Date(dateOfTravel);
                    paymentDeadline.setDate(paymentDeadline.getDate() - 35);

                    // If 35 days before is in the past, set paymentDeadline to tomorrow
                    if (paymentDeadline < today) {
                        paymentDeadline = new Date();
                        paymentDeadline.setDate(today.getDate() + 1);
                    }

                    // Format paymentDeadline as YYYY-MM-DD
                    var year = paymentDeadline.getFullYear();
                    var month = String(paymentDeadline.getMonth() + 1).padStart(2, '0');
                    var day = String(paymentDeadline.getDate()).padStart(2, '0');
                    var formattedDeadline = `${year}-${month}-${day}`;

                    // Set the payment_deadline value
                    document.getElementById('payment_deadline').value = formattedDeadline;
                } else if (quoteStage === 'Created') {
                    document.getElementById('accepted_date').value = '';
                    document.getElementById('payment_deadline').required = false;
                } else {
                    document.getElementById('payment_deadline').required = false;
                }

                checkPaymentDeadlineWarning();
            });

            document.getElementById('payment_deadline').addEventListener('change', function () {
                checkPaymentDeadlineWarning();
            });
        </script>
        
        <div id="div-fit2" class="content-div">
            <?php
            $sql = "SELECT * FROM vtiger_quotes_followup WHERE quoteid = '$quoteid' AND quotetype='$quotetype' ORDER BY next_follow_up_date ASC;";
            $result = mysqli_query($conn, $sql);
            ?>
            <div class="table-container">
                <div class="table-wrapper">
                    <table>
                        <tr>
                            <th>Call Time</th>
                            <th style="width:10%;">Next Follow Up Time</th>
                            <th>Description</th>
                            <th style="width:15%;">Check time</th>
                            <th style="width:5%;">Agent</th>
                            <th style="width:10%;">Travel Agent Name</th>
                            <th style="width:10%;">Office Phone</th>
                            <th style="width:10%;">Mobile Phone</th>
                            <th style="width:10%;">Email</th>
                            <th style="width:2%;"></th>
                        </tr>
                        <?php
                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {
                                $by_name = '';
                                ?>
                                <tr>
                                    <?php 
                                    if($row['followup_type'] == 'schedule_follow_up') {
                                        ?>
                                        <td></td>
                                        <td><?php echo date("d-M-Y H:i:s", strtotime($row['next_follow_up_date'])); ?></td>
                                        <?php
                                    } 
                                    else {
                                        ?>
                                        <td><?php echo date("d-M-Y H:i:s", strtotime($row['next_follow_up_date'])); ?></td>
                                        <td></td>
                                        <?php
                                    }
                                    ?>
                                    <td><?php echo htmlspecialchars($row['description']); ?></td>
                                    <td>
                                        <?php
                                        if($row['followup_type'] == 'schedule_follow_up') {
                                            ?>
                                            <input type="checkbox" class="followup-checkbox" data-id="<?php echo $row['auto_id']; ?>" <?php echo $row['followup'] ? 'checked' : ''; ?> /> 
                                            <?php
                                        }
                                        if(isset($row['followup']) && $row['followup'] != '') {
                                            echo date("d-M-Y H:i:s", strtotime($row['calltime']));
                                            if(isset($row['created_by']) && $row['created_by'] != '') {
                                                $by_name = htmlspecialchars($row['created_by']);
                                                echo ' by ' . $by_name;
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        if($by_name == '' || $row['followup'] == '') {
                                            echo '';
                                        }
                                        else if($by_name == $assigned_to_sales_agent) {
                                            echo "Internal";
                                        }
                                        else {
                                            echo "External";
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <span class="contact-name" id="contact-name-<?php echo $row['auto_id']; ?>"><?php echo htmlspecialchars($row['travel_agent_contact_name']); ?></span>
                                        <input type="text" class="contact-name-input" id="contact-name-input-<?php echo $row['auto_id']; ?>" value="<?php echo htmlspecialchars($row['travel_agent_contact_name']); ?>" style="display:none; width:100%;" />
                                    </td>
                                    <td>
                                        <span class="office-phone" id="office-phone-<?php echo $row['auto_id']; ?>"><?php echo htmlspecialchars($row['office_phone']); ?></span>
                                        <input type="text" class="office-phone-input" id="office-phone-input-<?php echo $row['auto_id']; ?>" value="<?php echo htmlspecialchars($row['office_phone']); ?>" style="display:none; width:100%;" />
                                    </td>
                                    <td>
                                        <span class="mobile-phone" id="mobile-phone-<?php echo $row['auto_id']; ?>"><?php echo htmlspecialchars($row['mobile_phone']); ?></span>
                                        <input type="text" class="mobile-phone-input" id="mobile-phone-input-<?php echo $row['auto_id']; ?>" value="<?php echo htmlspecialchars($row['mobile_phone']); ?>" style="display:none; width:100%;" />
                                    </td>
                                    <td>
                                        <span class="email" id="email-<?php echo $row['auto_id']; ?>"><?php echo htmlspecialchars($row['email']); ?></span>
                                        <input type="email" class="email-input" id="email-input-<?php echo $row['auto_id']; ?>" value="<?php echo htmlspecialchars($row['email']); ?>" style="display:none; width:100%; height: 30px;" />
                                    </td>
                                    <td>
                                        <button class="edit-button" id="edit-button-<?php echo $row['auto_id']; ?>" onclick="toggleEdit(<?php echo $row['auto_id']; ?>)">Edit</button>
                                        <button class="save-button" id="save-button-<?php echo $row['auto_id']; ?>" style="display:none;" onclick="saveChanges(<?php echo $row['auto_id']; ?>)">Save</button>
                                    </td>
                                </tr>
                                <?php
                            }
                        }
                        else {
                            ?>
                            <tr>
                                <td colspan="10">No results found</td>
                            </tr>
                            <?php
                        }
                        ?>
                    </table>
                </div>
            </div>

            <script>
                function toggleEdit(id) {
                    const nameSpan = document.getElementById(`contact-name-${id}`);
                    const nameInput = document.getElementById(`contact-name-input-${id}`);
                    const officeSpan = document.getElementById(`office-phone-${id}`);
                    const officeInput = document.getElementById(`office-phone-input-${id}`);
                    const mobileSpan = document.getElementById(`mobile-phone-${id}`);
                    const mobileInput = document.getElementById(`mobile-phone-input-${id}`);
                    const emailSpan = document.getElementById(`email-${id}`);
                    const emailInput = document.getElementById(`email-input-${id}`);
                    const saveButton = document.getElementById(`save-button-${id}`);
                    const editButton = document.getElementById(`edit-button-${id}`);

                    if (nameSpan.style.display === "none") {
                        nameSpan.style.display = "inline";
                        nameInput.style.display = "none";
                        officeSpan.style.display = "inline";
                        officeInput.style.display = "none";
                        mobileSpan.style.display = "inline";
                        mobileInput.style.display = "none";
                        emailSpan.style.display = "inline";
                        emailInput.style.display = "none";
                        saveButton.style.display = "none";
                    } else {
                        nameSpan.style.display = "none";
                        nameInput.style.display = "inline";
                        officeSpan.style.display = "none";
                        officeInput.style.display = "inline";
                        mobileSpan.style.display = "none";
                        mobileInput.style.display = "inline";
                        emailSpan.style.display = "none";
                        emailInput.style.display = "inline";
                        saveButton.style.display = "inline";
                        editButton.style.display = "none";
                    }
                }

                function saveChanges(id) {
                    const nameInput = document.getElementById(`contact-name-input-${id}`).value;
                    const officeInput = document.getElementById(`office-phone-input-${id}`).value;
                    const mobileInput = document.getElementById(`mobile-phone-input-${id}`).value;
                    const emailInput = document.getElementById(`email-input-${id}`).value;

                    // Create a form to submit the data
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '';

                    form.appendChild(createHiddenInput('auto_id', id));
                    form.appendChild(createHiddenInput('agent_detail_change', 'agent_detail_change'));
                    form.appendChild(createHiddenInput('travel_agent_contact_name', nameInput));
                    form.appendChild(createHiddenInput('office_phone', officeInput));
                    form.appendChild(createHiddenInput('mobile_phone', mobileInput));
                    form.appendChild(createHiddenInput('email', emailInput));

                    document.body.appendChild(form);
                    form.submit();
                }

                function createHiddenInput(name, value) {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = name;
                    input.value = value;
                    return input;
                }
            </script>

            <div class="followup-form">
                <h2>Add New Follow-Up</h2><br>
                <form action="" method="post">
                    <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>" />
                    <input type="hidden" name="travel_agent_contact_name" value="<?php echo htmlspecialchars($travel_agent_contact_name); ?>" />
                    <input type="hidden" name="office_phone" value="<?php echo htmlspecialchars($office_phone); ?>" />
                    <input type="hidden" name="mobile_phone" value="<?php echo htmlspecialchars($mobile_phone); ?>" />
                    <input type="hidden" name="email" value="<?php echo htmlspecialchars($email); ?>" />

                    <label for="follow_up_type">Type:</label>
                    <select name="follow_up_type" style="height: 48px;" required>
                        <option value="schedule_follow_up">Schedule Next Follow-Up Time</option>
                        <option value="call_info">Call Information</option>
                    </select>
                    <br><br>

                    <!-- Follow-up Date -->
                    <label for="follow_up_date">Time:</label>
                    <input type="datetime-local" name="follow_up_date" required />
                    <br><br>

                    <!-- Follow-up Description -->
                    <label for="follow_up_description">Description:</label>
                    <textarea name="follow_up_description" rows="4" required></textarea>
                    <br><br>
                    <input type="hidden" name="quotetype" value="<?php echo $_GET['quotetype']; ?>" />
                    <button type="submit" name="followup">Add Follow-Up Schedule</button>
                </form>
            </div>
        </div>

        <div id="div13" class="content-div">
            <?php
            $sql13 = "SELECT te.received_datetime, te.sender_name, te.subject, vs.status, te.conversation_id
                    FROM tdu_emails te
                    LEFT JOIN vtiger_support vs ON vs.ticketid = te.conversation_id
                    WHERE vs.quote_no='$quote_number'";
            $sql13 .= " AND te.received_datetime IN (
                SELECT MAX(received_datetime) 
                FROM tdu_emails
                GROUP BY conversation_id, mailbox
            )";
            $sql13 .= " ORDER BY te.received_datetime DESC";
            $result13 = mysqli_query($conn, $sql13);

            if (mysqli_num_rows($result13) > 0) :
                ?>
                <table class="styled-table">
                    <tr>
                        <th>
                            <button type="button" id="composeButton">Compose <i class="fa-solid fa-angles-down"></i></button>
                            <div id="emailOptions" style="display: none; position: absolute; background: white; border: 1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="sales@turtledownunder.com.au">Sales</button><br>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groupsales@turtledownunder.com.au">Group Sales</button>
                            </div>
                        </th>
                        <th>Received Time</th>
                        <th>Subject</th>
                        <th>From</th>
                        <th>Status</th>
                    </tr>
                    <?php
                    while ($row = mysqli_fetch_assoc($result13)) :
                        ?>
                        <tr>
                            <td></td>
                            <td><?php echo htmlspecialchars($row['received_datetime']); ?></td>
                            <td>
                                <a href="quote.php?opt=email-content&conversation_id=<?php echo urlencode($row['conversation_id']); ?>">
                                    <?php echo htmlspecialchars($row['subject']); ?>
                                </a>
                            </td>
                            <td><?php echo htmlspecialchars($row['sender_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['status'] ?? 'New'); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </table>
            <?php else : ?>
                <p>
                    No records found.
                    <button type="button" id="composeButton">Compose <i class="fa-solid fa-angles-down"></i></button>
                    <div id="emailOptions" style="display: none; position: absolute; background: white; border: 1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="sales@turtledownunder.com.au">Sales</button><br>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groupsales@turtledownunder.com.au">Group Sales</button>
                    </div>
                </p>
            <?php endif; ?>

            <!-- Compose Mail Start -->
            <div id="statusMessage" style="display:none; margin-top:10px; text-align: center;"></div>

            <div id="composeFormContainer" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
                <h2 style="text-align: center;">Compose Email</h2>
                <form id="emailComposeForm" enctype="multipart/form-data">
                    <input type="hidden" name="quoteid_compose" value="<?php echo $quoteid;?>">
                    <input type="hidden" name="quote_type_compose" value="sales">
                    <input type="hidden" name="email_sender_compose" value="<?= $username_ajax ?>">
                    <div>
                        <label for="from">From:</label>
                        <input type="text" name="from" id="from" value="" style="width: 100%;" required readonly>
                    </div>
                    <div>
                        <label for="to">To:</label>
                        <div style="display: flex; gap: 5px;">
                            <input type="text" name="to" id="to" required style="flex: 1;">
                            <button type="button" onclick="openAddEmailModal('to')">+</button>
                        </div>
                    </div>
                    <div>
                        <?php
                        $cc_emails = '';
                        if (!empty($assigned_to_region)) {
                            $safe_region = mysqli_real_escape_string($conn, $assigned_to_region);
                            $cc_type = substr($quote_number, -1) === 'G' ? 'Group' : 'FIT';
                            $email_query = "SELECT email, email_type FROM tdu_email_auto_cc WHERE region = '$safe_region'";
                            $result = mysqli_query($conn, $email_query);

                            $emailList = [];
                            while ($row = mysqli_fetch_assoc($result)) {
                                if ($row['email_type'] === $cc_type || $row['email_type'] === 'All') {
                                    $emailList[] = $row['email'];
                                }
                                // $emailList[] = $row['email'];
                            }
                            $cc_emails = implode(', ', $emailList);
                        }
                        ?>
                        <label for="cc">CC:</label>
                        <div style="display: flex; gap: 5px;">
                            <input type="text" name="cc" id="cc" style="flex: 1;" value="<?= htmlspecialchars($cc_emails); ?>">
                            <button type="button" onclick="openAddEmailModal('cc')">+</button>
                        </div>
                    </div>
                    <div>
                        <label for="subject">Subject:</label>
                        <input type="text" name="subject" id="subject" value="<?= htmlspecialchars($quote_number . ' - ' . $subject) ?>" required style="width: 100%;">
                    </div>
                    <div>
                        <label for="content">Content:</label>
                        <textarea name="content" id="content" rows="10" style="display: none;"></textarea>
                    </div>
                    <div id="attachments-container" style="margin-bottom: 10px;">
                        <label>Attachments:</label>
                        <div class="attachment-row" style="margin-bottom: 10px;">
                            <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                        </div>
                    </div>
                    <div>
                        <button type="submit">Send</button>
                        <button type="button" onclick="closeComposeForm()">Cancel</button>
                    </div>
                </form>
            </div>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                $(document).ready(function(){
                    $("#emailComposeForm").on("submit", function(e){
                        e.preventDefault();
                        $("#composeFormContainer").hide();

                        let formData = new FormData(this);
                        formData.append("compose", "1");

                        $.ajax({
                            url: "email_sender.php",
                            type: "POST",
                            data: formData,
                            processData: false,
                            contentType: false,
                            success: function(response){
                                if (response.includes("Email has been sent successfully")) {
                                    $("#statusMessage").html('<p style="color: green;">Email sent successfully! It will appear here after 1-2 minutes</p>').fadeIn();
                                    setTimeout(function () { $("#statusMessage").fadeOut(); }, 5000);
                                    $("#emailComposeForm")[0].reset();
                                    if (editorInstance) {
                                        editorInstance.setData(''); // Reset CKEditor content
                                    }
                                    $("#attachments-container").html(`
                                        <label>Attachments:</label>
                                        <div class="attachment-row" style="margin-bottom: 10px;">
                                            <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                                        </div>
                                    `);
                                } else {
                                    $("#statusMessage").html('<p style="color: red;">Failed to send email.</p>').fadeIn();
                                }
                            },
                            error: function(){
                                $("#statusMessage").html('<p style="color: red;">Failed to send email.</p>').fadeIn();
                            }
                        });
                    });
                });
            </script>
            <style>
                .ck-editor__editable {
                    height: 300px;
                    overflow-y: auto;
                }
            </style>
            <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
            <script>
                let editorInstance; // Store the CKEditor instance

                ClassicEditor
                    .create(document.querySelector('#content'), {
                        toolbar: {
                            items: ['heading', 'bold', 'italic', 'link', 'insertTable', 'undo', 'redo']
                        }
                    })
                    .then(editor => {
                        editorInstance = editor; // Store editor instance
                    })
                    .catch(error => {
                        console.error(error);
                    });
            </script>
            <script>
                function handleAttachmentChange(containerId, input) {
                    const container = document.getElementById(containerId);

                    // If the input has a file, display the file name
                    if (input.files.length > 0) {
                        // Hide the input field
                        input.style.display = "none";

                        // Create a span to display the file name
                        const fileName = document.createElement("span");
                        fileName.textContent = input.files[0].name;
                        fileName.style.marginLeft = "10px";
                        fileName.style.fontSize = "0.9em";

                        // Add a remove icon
                        const removeButton = document.createElement("button");
                        removeButton.type = "button";
                        removeButton.style.marginLeft = "10px";
                        removeButton.style.border = "none";
                        removeButton.style.background = "none";
                        removeButton.style.color = "red";
                        removeButton.style.cursor = "pointer";
                        removeButton.style.fontSize = "1.2em";
                        removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                        removeButton.onclick = function () {
                            // Remove the parent row
                            input.parentElement.remove();
                        };

                        // Append the file name and remove button to the current row
                        input.parentElement.appendChild(fileName);
                        input.parentElement.appendChild(removeButton);

                        // Add a new file input for future attachments
                        const newField = document.createElement("div");
                        newField.className = "attachment-row";
                        newField.style.marginBottom = "10px";
                        newField.innerHTML = `
                            <input type="file" name="attachments[]" onchange="handleAttachmentChange('${containerId}', this)">
                        `;

                        container.appendChild(newField);
                    }
                }
            </script>
            <script>
                const composeButton = document.getElementById('composeButton');
                const emailOptions = document.getElementById('emailOptions');
                const fromField = document.getElementById('from');

                // Show options when hovering over the button
                composeButton.addEventListener('mouseenter', () => {
                    emailOptions.style.display = 'block';
                    const rect = composeButton.getBoundingClientRect();
                    emailOptions.style.top = rect.bottom + 'px';
                    emailOptions.style.left = rect.left + 'px';
                });

                // Hide options when mouse leaves both the button and the options menu
                emailOptions.addEventListener('mouseleave', () => {
                    emailOptions.style.display = 'none';
                });

                composeButton.addEventListener('mouseleave', () => {
                    setTimeout(() => {
                        if (!emailOptions.matches(':hover')) {
                            emailOptions.style.display = 'none';
                        }
                    }, 200);
                });

                // Update "From" field when hovering over an option
                document.querySelectorAll('.email-option').forEach(option => {
                    option.addEventListener('mouseenter', function() {
                        fromField.value = this.getAttribute('data-email');
                    });

                    option.addEventListener('click', function() {
                        emailOptions.style.display = 'none';
                        openComposeForm();
                    });
                });

                function openComposeForm() {
                    document.getElementById('composeFormContainer').style.display = 'block';
                }

                function closeComposeForm() {
                    document.getElementById('composeFormContainer').style.display = 'none';
                }
            </script>
            <!-- Compose Mail End -->
            
            <!-- Modal for adding email start -->
            <div id="emailModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; justify-content: center; align-items: center;">
                <div style="background: white; padding: 20px; border-radius: 8px; width: 600px; text-align: center;">
                    <h4>Search Email</h4>
                    <input type="text" id="emailModalInput" placeholder="Enter email address" style="width: 100%; margin-bottom: 15px; height: 30px;" onkeyup="searchEmail(this.value)">
                    <ul id="emailSuggestions" style="list-style: none; padding: 0; margin: 0;"></ul>
                    <div style="margin-top: 10px; display: flex; gap: 10px; justify-content: center;">
                        <button onclick="confirmAddEmail()" style="padding: 5px 10px;">Add</button>
                        <button onclick="closeEmailModal()" style="padding: 5px 10px;">Cancel</button>
                    </div>
                </div>
            </div>
            <script>
                function searchEmail(query) {
                    const suggestions = document.getElementById('emailSuggestions');
                    suggestions.innerHTML = ''; // Clear previous suggestions

                    if (query.trim().length === 0) {
                        return;
                    }
                    
                    const mailboxFilter = document.getElementById('from').value;
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_outlook_contacts.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            const results = JSON.parse(xhr.responseText);
                            results.forEach(emailData => {
                                const li = document.createElement('li');
                                li.textContent = `${emailData.sender_name} (${emailData.email})`;
                                li.style.cursor = 'pointer';
                                li.style.padding = '5px 10px';
                                li.style.borderBottom = '1px solid #ddd';
                                li.onclick = function () {
                                    document.getElementById('emailModalInput').value = emailData.email;
                                    suggestions.innerHTML = ''; // Clear suggestions
                                };
                                suggestions.appendChild(li);
                            });
                        }
                    };
                    xhr.send(`query=${encodeURIComponent(query)}&mailboxFilter=${mailboxFilter}`);
                }

                let currentFieldId = null;

                function openAddEmailModal(fieldId) {
                    currentFieldId = fieldId; // Store the current field ID
                    document.getElementById('emailModalInput').value = ''; // Clear the input field
                    document.getElementById('emailModal').style.display = 'flex'; // Show the modal
                }

                function closeEmailModal() {
                    document.getElementById('emailModal').style.display = 'none'; // Hide the modal
                    currentFieldId = null; // Reset the current field ID
                }

                function confirmAddEmail() {
                    const emailInput = document.getElementById('emailModalInput').value.trim();
                    if (emailInput && currentFieldId) {
                        const field = document.getElementById(currentFieldId);
                        const currentValue = field.value.trim();
                        field.value = currentValue ? `${currentValue}, ${emailInput}` : emailInput;
                    }
                    closeEmailModal(); // Close the modal after adding
                }
            </script>
            <!-- Modal for adding email end -->
        </div>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.followup-checkbox').on('change', function() {
                    var followupChecked = $(this).is(':checked') ? 1 : 0;
                    var autoId = $(this).data('id');
                    var user_name = "<?php echo $_SESSION['user_name']; ?>"; 

                    $.ajax({
                        url: 'ajax_update_followup.php', // The PHP file to handle the update
                        type: 'POST',
                        data: {
                            followup: followupChecked,
                            auto_id: autoId,
                            user_name: user_name
                        },
                        success: function(response) {
                            location.reload();
                        },
                        error: function() {
                            alert('Error updating follow-up status');
                        }
                    });
                });
            });
        </script>
        <style>
            .followup-form {
                padding: 20px;
                border-radius: 8px;
                max-width: 500px;
                margin: 20px;
            }

            .followup-form .form-group {
                margin-bottom: 20px;
            }

            .followup-form input[type="datetime-local"], 
            .followup-form select,
            .followup-form textarea {
                width: 100%;
                padding: 10px;
                font-size: 16px;
                border: 1px solid #ddd;
                border-radius: 4px;
                outline: none;
                transition: border-color 0.3s ease;
            }

            .followup-form input[type="datetime-local"]:focus, 
            .followup-form textarea:focus {
                border-color: #007bff;
                box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
            }

            .followup-form textarea {
                resize: vertical;
                min-height: 100px;
            }
        </style>
        <style>
            .form-container {
                display: grid;
                width: 80%;
                grid-template-columns: 1fr 1fr;
                gap: 20%;
            }
    
            .form-column {
                padding: 20px;
                border-radius: 5px;
            }
    
            .form-row {
                margin-bottom: 10px;
            }
        
            .form-row label {
                margin-right: 10px;
            }
            .form-row {
                display: flex;
                justify-content: space-between;
                margin-bottom: 10px;
            }
            .form-row label {
                width: 45%;
            }
            .form-row input, .form-row select, .form-row textarea {
                width: 300px !important;
                padding: 5px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }
            .form-row input[readonly] {
                background-color: #f9f9f9;
                cursor: not-allowed;
            }
        </style>

        <div id="div17" class="content-div">
            <?php
            $sql = "SELECT task_id, subject, quote_no, assigned_to_region, assigned_to_user, category, status, priority, deadline, created_at 
                    FROM tdu_tasks_management WHERE quote_no = '$quote_number'
                    ORDER BY 
                        CASE WHEN deadline IS NULL THEN 1 ELSE 0 END ASC, 
                        deadline ASC, created_at DESC";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                ?>
                <table class="styled-table" style="width: 100%; margin: 20px auto;">
                    <tr>
                        <th style="text-align: center;"><button onclick="window.location.href='task.php?opt=add-new-tasks&quoteNumber=<?= $quote_number ?>'"><i class="fa-solid fa-plus"></i></button></th>
                        <th>ID</th>
                        <th style="text-align: left;">Subject</th>
                        <th>Quote No</th>
                        <th>Assigned Region</th>
                        <th>Assigned User</th>
                        <th>Category</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Deadline</th>
                        <th>Created At</th>
                    </tr>

                    <?php while ($row = $result->fetch_assoc()): ?>
                        <?php
                        $iconColor = ''; 
                        if (isset($row['deadline']) && ($row['status'] == 'Open' || $row['status'] == 'In Progress')) {
                            $deadline_r = strtotime($row['deadline']);
                            $today = strtotime(date('Y-m-d'));
                            $threeDaysLater = strtotime('+3 days', $today);

                            if ($deadline_r <= $today) {
                                $iconColor = 'red'; // Past deadline
                            } elseif ($deadline_r <= $threeDaysLater) {
                                $iconColor = 'orange'; // Within 3 days
                            }
                        }
                        ?>
                        <tr>
                            <td></td>
                            <td><?= htmlspecialchars($row['task_id']); ?></td>
                            <td style="text-align: left;">
                                <?php if ($iconColor): ?>
                                    <i class="fa-solid fa-circle-exclamation" style="color: <?= $iconColor; ?>"></i>
                                <?php endif; ?>
                                <a href="task.php?opt=task-details&id=<?php echo urlencode($row['task_id']); ?>"><?php echo htmlspecialchars($row['subject']); ?></a>
                            </td>
                            <td>
                                <?php echo htmlspecialchars($row['quote_no']); ?>
                                <a href="quote.php?opt=quote-product-faq&quoteNumber=<?php echo urlencode($row['quote_no']); ?>" target="_blank"><i class="fa-solid fa-circle-question"></i></a>
                            </td>
                            <td><?= htmlspecialchars($row['assigned_to_region']); ?></td>
                            <td><?= htmlspecialchars($row['assigned_to_user']); ?></td>
                            <td><?= htmlspecialchars($row['category']); ?></td>
                            <td><?= htmlspecialchars($row['status']); ?></td>
                            <td><?= htmlspecialchars($row['priority']); ?></td>
                            <td><?= $row['deadline'] ? date('d-M-Y', strtotime($row['deadline'])) : ''; ?></td>
                            <td><?= date('d-M-Y', strtotime($row['created_at'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </table>
                <?php
            } else {
                echo "<p style='margin: 20px;'>No tasks found</p>";
            }
            ?>
        </div>
        <?php
    } else {
        echo "Quote Number not found";
    }
}
else if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'summary') {
    $quote_number = $_GET['quoteNumber'];
    $mode = 'group';

    $quoteid_history = '';
    if(isset($_GET['quoteid']) && $_GET['quoteid'] != '') {
        $quoteid = $_GET['quoteid'];
        $quoteid_history = "AND quoteid='$quoteid'";
    }
    $sql = "SELECT vq.*, 
                    va.organization_name AS accountname, va.membershipid, va.email,
                    vcd.name AS contactname, 
                    vqcf.cf_1162, vqcf.cf_1182, vqcf.cf_1188, vqcf.cf_1182_pending,
                    vqinfo.assigned_to_region, vqinfo.assigned_to_ops, vqinfo.assigned_to_qa, vqinfo.priority AS priority1
            FROM (SELECT * FROM vtiger_quotes WHERE quote_no='$quote_number' $quoteid_history) vq
            LEFT JOIN tdu_organisation va ON vq.accountid=va.organizationid 
            LEFT JOIN tdu_contacts vcd ON vq.contactid=vcd.auto_id
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='group'
            ORDER BY vq.quoteid ASC
            LIMIT 1;";
    
    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $subject = $row['subject'];
        $quoteid = $row['quoteid'];
        $quote_number = $row['quote_no'];
        $quotestage = $row['quotestage'];
        $accountname = $row['accountname'];
        $contactname = $row['contactname'];
        $membershipid = $row['membershipid'];
        $org_email = $row['email'];
        $country = $row['country'];
        $created_at = $row['created_at'];
        $created_by = $row['created_by'];
        $date_of_travel = $row['cf_1162'];
        $payment_deadline = $row['cf_1182'];
        $payment_deadline_pending = $row['cf_1182_pending'] ?? '';
        $accepted_date = $row['cf_1188'];
        $assigned_to_region = $row['assigned_to_region'];
        $assigned_to_ops = $row['assigned_to_ops'] ?? '';
        $assigned_to_qa = $row['assigned_to_qa'];
        $priority = $row['priority1'];
        if(isset($row['mode']) && $row['mode'] == 'standard') {
            $mode = $row['mode'];
        }
        $nsingle_room = $row['nsingle_room']?? 0;
        $ndouble_room = $row['ndouble_room']?? 0;
        $ntriple_room = $row['ntriple_room']?? 0;
        $nchild_without_bed = $row['nchild_without_bed']?? 0;
        $adults_no = $row['adults'] ?? 0;
        $children_no = $row['children']?? 0;
        $infants_no = $row['infants']?? 0;
        $pax_no = $adults_no + $children_no;
        $pax_no_pax_range = $pax_no;
        $child_ages = $row['child_ages'] ?? '';
        $subquoteid_supplier = 0;
        $hotel_num = 0;
        $auto_email_follow_up = $row['auto_email_follow_up'] ?? -1;
        $quote_deleted = (int) $row['deleted'] ?? 1;
        $ref_quote_no = $row['ref_quote_no'] ?? '';
        $ai_ref_id = (int) $row['ai_ref_id'] ?? 0;
        $extra_mup = (float) $row['extra_mup'] ?? 0;
        $visa_pax_path = $row['visa_pax_path'] ?? '';
    }
    else {
        include "header.php";
        echo "No data found for Quote: " . $quote_number;
        exit();
    }

    if ($quote_deleted == 1) {
        include "header.php";
        echo "This quote has been deleted.";
        exit();
    }
    
    // display quote summary
    $sql = "SELECT DISTINCT 
                vq.quoteid, vq.quote_no, vq.created_at, 
                vi.productid, vi.sequence_no, vi.day, vi.cf_928, vi.comment, vi.quantity, vi.margin, vi.booking_status, 
                vp.productname, vp.unit_price, vp.customised, vp.description, vp.keywords,
                vv.vendorname, 
                IFNULL(vps.sale_price, '') AS sale_price, IFNULL(vps.sale_price_child, '') AS sale_price_child, IFNULL(vps.sale_price_infant, '') AS sale_price_infant, vps.price_adjust, 
                vdo.display_order,
                (SELECT COUNT(*) FROM tdu_product_alt_vendors_in_quote tpa WHERE tpa.quoteid='$quoteid' AND tpa.sequence_no = vi.sequence_no AND ( tpa.actioned = 0 OR (tpa.approved = 1 AND vendorid = 0) )) AS alt_vendor_count,
                (SELECT COUNT(*) FROM tdu_products_suggested tps WHERE tps.productid = vi.productid) AS products_suggested_count
            FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
            LEFT JOIN vtiger_display_order vdo ON vi.id=vdo.id AND vi.sequence_no=vdo.sequence_no
            LEFT JOIN ( SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description, '' AS keywords FROM vtiger_products_custom
                        UNION ALL
                        SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description, keywords FROM tdu_products
                        ) vp ON vi.productid=vp.productid
            LEFT JOIN ( SELECT vendorid, vendorname FROM vtiger_vendor_custom
                        UNION ALL
                        SELECT vendorid, vendorName AS vendorname FROM tdu_vendors
                        ) vv ON vi.vendorid=vv.vendorid
            LEFT JOIN vtiger_products_saleprice vps ON vq.quoteid = vps.quoteid AND vi.sequence_no = vps.sequence_no AND vps.subquoteid <= 1
            ORDER BY vdo.display_order ASC, vi.sequence_no ASC;";
    $result = mysqli_query($conn, $sql);

    // pax ranges
    $pax_ranges = print_th_pax_ranges($conn, $quoteid, $quote_number, $subject, $quoteid_history, $_GET['edit']);
    $pax_row = $pax_ranges['pax_row'];
    $pax_row_num = $pax_ranges['pax_row_num'];

    // invoice path
    $invoice_initial_query = "SELECT filepath FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'initial'";
    $invoice_final_query = "SELECT filepath FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'final' ORDER BY created_at DESC LIMIT 1";
    $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
    $invoice_final_result = mysqli_query($conn, $invoice_final_query);
    $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
    $invoice_final = mysqli_fetch_assoc($invoice_final_result);
    $initial_path = !empty($invoice_initial['filepath']) ? $invoice_initial['filepath'] : null;
    $final_path = !empty($invoice_final['filepath']) ? $invoice_final['filepath'] : null;

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_new_products'])) {
        $quoteid = $_POST['quoteid'];
        $days = $_POST['day'];
        $products = $_POST['product'];
        $vendors = $_POST['vendor'];
        $categories = $_POST['category'];
        $prices = $_POST['price'];
        $child_prices = $_POST['child_price'];
        $cfByProductID = getCFByProductID($conn);
        $cities = $_POST['city'];

        // get the sequence number for the new products
        $sql = "SELECT MAX(sequence_no) AS max_sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
        $result = mysqli_query($conn, $sql);
        if ($result) {
            $row = mysqli_fetch_assoc($result);
            $sequence_no = ($row['max_sequence_no'] !== NULL) ? $row['max_sequence_no'] : 0;
        } else {
            echo "Error: " . mysqli_error($conn);
        }

        for ($i = 0; $i < count($days); $i++) {
            $day = $days[$i];
            $vendor = $vendors[$i];
            $product = $products[$i];
            $category = $categories[$i];
            $price = $prices[$i];
            $child_price = $child_prices[$i] ?? 0;
            $city = $cities[$i];
            $sequence_no += 1;

            if (isset($category) && $category == 'vtiger' && isset($productIDByProduct[$product])) {
                $productid = $productIDByProduct[$product];
                $cf_928 = $cfByProductID[$productid];
            }
            else if(isset($category) && in_array($category, ['Attraction', 'Restaurant', 'Tour', 'Transfers', 'Guide', 'SIC'])){
                $day = mysqli_real_escape_string($conn, $days[$i]);
                $vendor = mysqli_real_escape_string($conn, $vendors[$i]);
                $product = mysqli_real_escape_string($conn, $products[$i]);
                $category = mysqli_real_escape_string($conn, $categories[$i]);
                $price = mysqli_real_escape_string($conn, $prices[$i]);
                $query_union = "
                    SELECT MAX(vendorid) AS max_vendorid FROM (
                        SELECT vendorid FROM vtiger_vendor_custom
                    ) AS combined";
                $result_union = mysqli_query($conn, $query_union);
                if ($row_union = mysqli_fetch_assoc($result_union)) {
                    $vendorid = $row_union['max_vendorid'] + 1;
                } else {
                    $vendorid = 0;
                }
                $query_insert = "INSERT INTO vtiger_vendor_custom (vendorid, vendorname) VALUES ('$vendorid', '$vendor');";
                mysqli_query($conn, $query_insert) or die(mysqli_error($mysqli));

                $query_union = "
                    SELECT MAX(productid) AS max_productid FROM (
                        SELECT productid FROM vtiger_products_custom
                    ) AS combined";
                $result_union = mysqli_query($conn, $query_union);
                if($row_union = mysqli_fetch_assoc($result_union)) {
                    $productid = $row_union['max_productid'] + 1;
                } else {
                    $productid = 0;
                }
                $cf_928 = $category;
                $query_insert = "INSERT INTO vtiger_products_custom (productid, productname, vendor_id) VALUES ('$productid', '$product', '$vendorid');";
                mysqli_query($conn, $query_insert) or die(mysqli_error($mysqli));
            }
            else {
                continue;
            }

            $sql_internal_external = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
            $result_internal_external = mysqli_query($conn, $sql_internal_external);
            if(mysqli_num_rows($result_internal_external) > 0) {
                $row_internal_external = $result_internal_external->fetch_assoc();
                $username_full = $row_internal_external['name'];
            }
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'adults', '$adults_no', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'children', '$children_no', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'infants', '$infants_no', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

            if(isset($city) && $category != 'vtiger') {
                // Insert city
                $insert_sql1 = "INSERT INTO vtiger_productcf (productid, cf_1248) 
                                VALUES ('$productid', '$city');";
                mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
            }

            // Insert data into vtiger_inventoryproductrel
            $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no) 
                            VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no')";
            mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));

            // Step 1: Get the current max display_order for the given quoteid
            $query = "SELECT COALESCE(MAX(display_order), 0) + 1 AS new_display_order 
                    FROM vtiger_display_order 
                    WHERE id = '$quoteid'";
            $result = mysqli_query($conn, $query);

            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $new_display_order = $row['new_display_order'];

                // Step 2: Insert the new record with the calculated display_order
                $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                            VALUES ('$quoteid', '$sequence_no', '$new_display_order')";

                mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
            } 

            if($cf_928 == 'Transfers') {
                $existing_subquoteid_query = "SELECT DISTINCT subquoteid, pax_min, pax_max FROM vtiger_products_saleprice WHERE quoteid = '$quoteid' AND cf_928 = '$cf_928';";
                $existing_subquoteid_result = mysqli_query($conn, $existing_subquoteid_query);

                $existing_subquoteids = [];
                $pax_values = [];

                while ($row = mysqli_fetch_assoc($existing_subquoteid_result)) {
                    $existing_subquoteids[] = $row['subquoteid'];
                    $pax_values[$row['subquoteid']] = [
                        'pax_min' => $row['pax_min'],
                        'pax_max' => $row['pax_max']
                    ];
                }

                if(mysqli_num_rows($existing_subquoteid_result) > 0) {
                    foreach ($existing_subquoteids as $subquoteid) {
                        // Get the pax_min and pax_max for the current subquoteid
                        $pax_min = $pax_values[$subquoteid]['pax_min'];
                        $pax_max = $pax_values[$subquoteid]['pax_max'];
                        
                        $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, pax_min, pax_max) 
                                        VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', '$subquoteid', '$price', '$pax_min', '$pax_max')
                                        ON DUPLICATE KEY UPDATE sale_price = '$price', pax_min = VALUES(pax_min), pax_max = VALUES(pax_max), updated_at = NOW()";
                        mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                    }
                }

                else {
                    $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price) 
                                    VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 0, '$price')
                                    ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                    mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                }
            }
            else {
                $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_child)  
                                VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '$price', '$child_price')
                                ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
            }
            $insert_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                        VALUES ('$quoteid', '$username', 'Add Product: $product', NOW())";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        }
        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=price&alert");
        exit();
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_sale_price'])) {
        // $quoteid = $_POST['quoteid'];
        $cfByProductID = getCFByProductID2($conn);
        $productnameByID = getProductByProductID($conn);
    
        $del_sql = "DELETE FROM vtiger_display_order WHERE id='$quoteid'";
        mysqli_query($conn, $del_sql) or die(mysqli_error($conn));

        $processed_sequences = []; // Array to track processed sequence numbers
        $display_num = 1;

        foreach ($_POST['sale_price'] as $key => $sale_price) {
            list($quoteid, $productid, $sequence_no, $subquoteid) = explode('_', $key);
            
            if (!in_array($sequence_no, $processed_sequences)) {
                $processed_sequences[] = $sequence_no;
                $insert_sql = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                                VALUES ('$quoteid', '$sequence_no', $display_num)";
                mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                $display_num += 1;
            }
        
            // Escape values
            $sale_price = mysqli_real_escape_string($conn, $sale_price);
            
            $sale_price_child_key = str_replace('sale_price', 'sale_price_child', $key);
            $sale_price_child = isset($_POST['sale_price_child'][$sale_price_child_key]) 
                                ? mysqli_real_escape_string($conn, $_POST['sale_price_child'][$sale_price_child_key]) 
                                : null;
        
            $sale_price_infant_key = str_replace('sale_price', 'sale_price_infant', $key);
            $sale_price_infant = isset($_POST['sale_price_infant'][$sale_price_infant_key]) 
                                ? mysqli_real_escape_string($conn, $_POST['sale_price_infant'][$sale_price_infant_key]) 
                                : null;
        
            $pax_min = isset($_POST["pax_min_$subquoteid"]) ? mysqli_real_escape_string($conn, $_POST["pax_min_$subquoteid"]) : null;
            $pax_max = isset($_POST["pax_max_$subquoteid"]) ? mysqli_real_escape_string($conn, $_POST["pax_max_$subquoteid"]) : null;
        
            // Retrieve existing values
            $cf_928 = $cfByProductID[$productid];
            $existing_query = "SELECT sale_price, sale_price_child, sale_price_infant, pax_min, pax_max FROM vtiger_products_saleprice 
                               WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND subquoteid='$subquoteid'";
            $existing_result = mysqli_query($conn, $existing_query);
            $existing_row = mysqli_fetch_assoc($existing_result);
        
            $changes = [];
            // Compare each field and log changes
            if ($existing_row) {
                if (bccomp($existing_row['sale_price'], $sale_price, 2) !== 0) {
                    $changes[] = "Sale Price: $".number_format($existing_row['sale_price'], 2)." -> $".number_format($sale_price, 2);

                    if ($pax_min !== null && $existing_row['pax_min'] !== $pax_min) {
                        $changes[] = "Pax Min: {$existing_row['pax_min']} -> $pax_min";
                    }
                    if ($pax_max !== null && $existing_row['pax_max'] !== $pax_max) {
                        $changes[] = "Pax Max: {$existing_row['pax_max']} -> $pax_max";
                    }
                }
                if ($sale_price_child !== null && bccomp($existing_row['sale_price_child'], $sale_price_child, 2) !== 0) {
                    $changes[] = "Child Price: $".number_format($existing_row['sale_price_child'], 2)." -> $".number_format($sale_price_child, 2);
                }
                if ($sale_price_infant !== null && bccomp($existing_row['sale_price_infant'], $sale_price_infant, 2) !== 0) {
                    $changes[] = "Infant Price: $".number_format($existing_row['sale_price_infant'], 2)." -> $".number_format($sale_price_infant, 2);
                }
            }
        
            // Log changes if any
            if (!empty($changes)) {
                $log_details = mysqli_real_escape_string($conn, $productnameByID[$productid]) . " Price change: " . implode(', ', $changes);
                
                $log_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                            VALUES ('$quoteid', '$username_plain_ajax', '$log_details', NOW())";
                
                mysqli_query($conn, $log_sql) or die(mysqli_error($conn));
            }
        
            // Insert or update vtiger_products_saleprice
            $insert_sql = "INSERT INTO vtiger_products_saleprice 
                           (quoteid, subquoteid, productid, sequence_no, sale_price, sale_price_child, sale_price_infant, pax_min, pax_max, updated_at) 
                           VALUES 
                           ('$quoteid', '$subquoteid', '$productid', '$sequence_no', '$sale_price', '$sale_price_child', '$sale_price_infant', '$pax_min', '$pax_max', NOW())
                           ON DUPLICATE KEY UPDATE 
                           sale_price='$sale_price', sale_price_child='$sale_price_child', sale_price_infant='$sale_price_infant', pax_min='$pax_min', pax_max='$pax_max', updated_at=NOW()";
        
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        }        
    
        // Handle day field updates
        if (isset($_POST['day'])) {
            foreach ($_POST['day'] as $key => $day) {
                list($quoteid, $productid, $sequence_no) = explode('_', $key);
                $day = mysqli_real_escape_string($conn, $day);
    
                // Update day in vtiger_inventoryproductrel
                $update_day_sql = "UPDATE vtiger_inventoryproductrel SET day='$day' 
                                   WHERE id='$quoteid' AND sequence_no='$sequence_no'";
                mysqli_query($conn, $update_day_sql) or die(mysqli_error($conn));
            }
        }
    
        // Handle comment field updates
        if (isset($_POST['comment'])) {
            foreach ($_POST['comment'] as $key => $comment) {
                list($quoteid, $productid, $sequence_no) = explode('_', $key);
                $comment = mysqli_real_escape_string($conn, $comment);
    
                // Update comment in vtiger_inventoryproductrel
                $update_comment_sql = "UPDATE vtiger_inventoryproductrel SET comment='$comment' 
                                       WHERE id='$quoteid' AND sequence_no='$sequence_no'";
                mysqli_query($conn, $update_comment_sql) or die(mysqli_error($conn));
            }
        }
    
        $conn->close();
        redirectWithoutParam('edit');
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_pax'])) {
        $quoteid = $_POST['quoteid'];
        $subquoteid = $_POST['delete_pax'];
        $quoteid = filter_var($quoteid, FILTER_SANITIZE_NUMBER_INT);
        $subquoteid = filter_var($subquoteid, FILTER_SANITIZE_NUMBER_INT);
    
        $sql = "DELETE FROM vtiger_products_saleprice 
                WHERE quoteid = '$quoteid' AND subquoteid = '$subquoteid'";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        $conn->close();
        redirectWithoutParam('edit');
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['set_pax_range'])) {
        $quoteid = $_POST['quoteid'];
        $quote_number = $_POST['quote_number'];
        $min_pax = $_POST['min_pax_range'];
        $max_pax = $_POST['max_pax_range'];
        $subquoteid = -1;
        if ($subquoteid < 0) {
            $sql = "SELECT MAX(subquoteid) as max_subquoteid 
                    FROM vtiger_products_saleprice
                    WHERE quoteid = '$quoteid' AND cf_928 = 'Transfers'
                    GROUP BY quoteid;";
            $result = mysqli_query($conn, $sql);
            
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $max_subquoteid = $row['max_subquoteid'];
                $subquoteid = $max_subquoteid + 1;
                if(!isset($subquoteid) || $subquoteid <= 1) {
                    $subquoteid = 2;
                }
            } else {
                $subquoteid = 2;
            }
        }
        $insert_sql = "INSERT INTO vtiger_products_saleprice (subquoteid, cf_928, quoteid, productid, sequence_no, sale_price, pax_min, pax_max)
                    SELECT '$subquoteid' AS subquoteid, cf_928, quoteid, productid, sequence_no, 0 AS sale_price, '$min_pax' AS pax_min, '$max_pax' AS pax_max
                    FROM vtiger_products_saleprice
                    WHERE subquoteid = 0 AND quoteid = '$quoteid'";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        $conn->close();
        redirectWithoutParam('edit');
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['quick_set_pax_range'])) {
        $quoteid = $_POST['quoteid'];
        $start = $_POST['start'];
        $step = $_POST['step'];
        $number = $_POST['number'];
        
        for ($i = 0; $i < $number; $i++) {
            $min_pax = $start + ($i * $step);
            $max_pax = $min_pax + $step - 1;
    
            $subquoteid = -1;
            if ($subquoteid < 0) {
                $sql = "SELECT MAX(subquoteid) as max_subquoteid 
                        FROM vtiger_products_saleprice
                        WHERE quoteid = '$quoteid' AND cf_928 = 'Transfers'
                        GROUP BY quoteid;";
                $result = mysqli_query($conn, $sql);
                
                if ($result && mysqli_num_rows($result) > 0) {
                    $row = mysqli_fetch_assoc($result);
                    $max_subquoteid = $row['max_subquoteid'];
                    $subquoteid = $max_subquoteid + 1;
                    if (!isset($subquoteid) || $subquoteid <= 1) {
                        $subquoteid = 2;
                    }
                } else {
                    $subquoteid = 2;
                }
            }
            
            $insert_sql = "INSERT INTO vtiger_products_saleprice (subquoteid, cf_928, quoteid, productid, sequence_no, sale_price, pax_min, pax_max)
                           SELECT '$subquoteid' AS subquoteid, cf_928, quoteid, productid, sequence_no, 0 AS sale_price, '$min_pax' AS pax_min, '$max_pax' AS pax_max
                           FROM vtiger_products_saleprice
                           WHERE subquoteid = 0 AND quoteid = '$quoteid'";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        }
        $conn->close();
        redirectWithoutParam('edit');
    }
    
    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_sequence_no'])) {
        $quoteid = $_POST['quoteid'];
        $current_sequence_no = intval($_POST['update_sequence_no']);
        $new_sequence_no = intval($_POST['new_sequence_no'])-1;
        
        $sql_seq = "SELECT DISTINCT display_order
                FROM vtiger_display_order
                WHERE id='$quoteid'
                ORDER BY display_order ASC
                LIMIT $new_sequence_no, 1;";
        $result = mysqli_query($conn, $sql_seq);
        
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $new_sequence_no = $row['display_order'];
        }
        else {
            $sql_seq = "SELECT MAX(display_order) AS display_order
                FROM vtiger_display_order
                WHERE id='$quoteid'
                LIMIT 1;";
            $result = mysqli_query($conn, $sql_seq);
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $new_sequence_no = $row['display_order']+1;
            }
        }

        if ($current_sequence_no < $new_sequence_no) {
            $sql = "UPDATE vtiger_display_order
                    SET display_order = display_order + 1
                    WHERE id = '$quoteid' AND display_order >= $new_sequence_no;";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
            $sql = "UPDATE vtiger_display_order
                    SET display_order = $new_sequence_no
                    WHERE id = '$quoteid' AND display_order = $current_sequence_no;";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }
        else if ($current_sequence_no > $new_sequence_no) {
            $current_sequence_no += 1;
            $sql = "UPDATE vtiger_display_order
                    SET display_order = display_order + 1
                    WHERE id = '$quoteid' AND display_order >= $new_sequence_no;";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
            $sql = "UPDATE vtiger_display_order
                    SET display_order = $new_sequence_no
                    WHERE id = '$quoteid' AND display_order = $current_sequence_no;";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }
        $conn->close();
        redirectWithoutParam('edit');
    }
    
    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_quote'])) {
        $new_quoteid = $_POST['quoteid'];
        $new_quote_no = $_POST['quoteNumber'];
        // Quote Details
        $quote_stage = mysqli_real_escape_string($conn, $_POST['quote_stage'] ?? '');
        $priority = mysqli_real_escape_string($conn, $_POST['priority'] ?? '');
        $organization_name = mysqli_real_escape_string($conn, $_POST['organization_name'] ?? '');
        $assigned_to_region = mysqli_real_escape_string($conn, $_POST['assigned_to_region'] ?? '');

        // Custom Information
        $date_of_travel = mysqli_real_escape_string($conn, $_POST['date_of_travel'] ?? '');
        $accepted_date = mysqli_real_escape_string($conn, $_POST['accepted_date'] ?? '');

        if (isset($_POST['payment_deadline']) && $_POST['payment_deadline'] != '') {
            $payment_deadline = $_POST['payment_deadline'];
            if (isset($_POST['payment_deadline_pending']) && $_POST['payment_deadline_pending'] == 1 && $title != 'admin') {
                $sql_update_payment_deadline = "UPDATE vtiger_quotescf SET cf_1182_pending = '$payment_deadline' WHERE quoteid = '$quoteid';";
                mysqli_query($conn, $sql_update_payment_deadline) or die(mysqli_error($conn));

                // insert to quote history
                $history_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, stage, user_name)
                                VALUES ($quoteid, 'Request change Payment deadline to $payment_deadline (within 15 days)', '$username')";
                mysqli_query($conn, $history_sql) or die("Error: " . mysqli_error($conn));
            } else {
                $sql_update_payment_deadline = "UPDATE vtiger_quotescf SET cf_1182 = '$payment_deadline' WHERE quoteid = '$quoteid';";
                mysqli_query($conn, $sql_update_payment_deadline) or die(mysqli_error($conn));

                // insert to quote history
                $history_sql = "INSERT INTO vtiger_quote_stage_track (quoteid, stage, user_name)
                                VALUES ($quoteid, 'Change Payment deadline to $payment_deadline', '$username')";
                mysqli_query($conn, $history_sql) or die("Error: " . mysqli_error($conn));
            }
        }
        
        $adults = $_POST['no_of_adults'];
        $children = $_POST['no_of_children'];
        $infants = $_POST['no_of_infants'];

        $no_of_single = $_POST['no_of_single'];
        $no_of_double = $_POST['no_of_double'];
        $no_of_triple = $_POST['no_of_triple'];
        $no_of_children_without_bed = $_POST['no_of_children_without_bed'];

        $assigned_to_ops = mysqli_real_escape_string($conn, $_POST['assigned_to_ops'] ?? '');
        $assigned_to_qa = mysqli_real_escape_string($conn, $_POST['assigned_to_qa'] ?? '');

        $username_full = $username_ajax;

        $query = "SELECT sequence_no FROM vtiger_inventoryproductrel WHERE id = '$quoteid' AND cf_928 != 'Transfers';";
        $result = mysqli_query($conn, $query);
        while ($row = mysqli_fetch_assoc($result)) {
            $sequence_no = $row['sequence_no'];
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                    VALUES ('$quoteid', '$sequence_no', 'adults', '$adults', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'children', '$children', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'infants', '$infants', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        }

        $query = "SELECT sequence_no FROM vtiger_inventoryproductrel WHERE id = '$quoteid' AND cf_928 = 'Hotel';";
        $result = mysqli_query($conn, $query);
        while ($row = mysqli_fetch_assoc($result)) {
            $sequence_no = $row['sequence_no'];
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'single_rooms', '$no_of_single', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'double_rooms', '$no_of_double', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'triple_rooms', '$no_of_triple', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'child_without_bed', '$no_of_children_without_bed', NOW(), '$username_full')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        }

        // Check the latest stage for the given quoteid
        $check_sql = "SELECT quotestage FROM vtiger_quotes WHERE quoteid = '$new_quoteid' LIMIT 1;";
        $check_result = mysqli_query($conn, $check_sql);

        if ($check_result && mysqli_num_rows($check_result) > 0) {
            $check_row = mysqli_fetch_assoc($check_result);
            $latest_stage = $check_row['quotestage'];

            // Insert only if the stage is different from the latest one
            if ($latest_stage != $quote_stage) {
                $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                                VALUES ('$new_quoteid', '$username', 'Change Stage to $quote_stage', NOW());";
                mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));

                if($latest_stage == 'Created' && $quote_stage == 'Accepted') {
                    $insert_sql5 = "INSERT INTO tdu_mailbox_tmp_send_vendor (quoteid, transfers_actioned, a_t_actioned) VALUES ('$new_quoteid', '0', '0');";
                    mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
                }
            }
        } else {
            // If there are no records, proceed with the insert
            $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                            VALUES ('$new_quoteid', '$username', 'Change Stage to $quote_stage', NOW());";
            mysqli_query($conn, $insert_sql4) or die(mysqli_error($conn));
        }

        if(empty($quote_stage)) {
            $quote_stage = $latest_stage;
        }

        // Insert into vtiger_quotes table
        $child_ages = isset($_POST['child_ages']) ? implode(',', $_POST['child_ages']) : '';

        $insert_sql = "INSERT INTO vtiger_quotes (quoteid, quote_no, quotestage, adults, children, infants, nsingle_room, ndouble_room, ntriple_room, child_ages, created_at, created_by) 
                    VALUES ('$new_quoteid', '$new_quote_no', '$quote_stage', '$adults', '$children', '$infants', '$no_of_single', '$no_of_double', '$no_of_triple', '$child_ages', NOW(), '$username')
                    ON DUPLICATE KEY UPDATE quotestage='$quote_stage', adults='$adults', children='$children', infants='$infants', nsingle_room='$no_of_single', ndouble_room='$no_of_double', ntriple_room='$no_of_triple', nchild_without_bed='$no_of_children_without_bed', child_ages='$child_ages';";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

        $insert_sql5 = "UPDATE vtiger_quotes_info SET assigned_to_ops = '$assigned_to_ops', assigned_to_qa = '$assigned_to_qa', priority = '$priority' WHERE quoteid = '$quoteid' AND quotetype = 'group';";
        mysqli_query($conn, $insert_sql5) or die(mysqli_error($conn));
        
        $insert_sql3 = "INSERT INTO vtiger_quotescf (quoteid, cf_1162, cf_1188, cf_1542) 
                        VALUES ('$new_quoteid', '$date_of_travel', '$accepted_date', '$priority')
                        ON DUPLICATE KEY UPDATE cf_1162 = '$date_of_travel', cf_1188 = '$accepted_date', cf_1542 = '$priority';";
        mysqli_query($conn, $insert_sql3) or die(mysqli_error($conn));

        if($quote_stage == 'Accepted' && $assigned_to_ops == '') {
            $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
            $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
            $travel_month = (int) $travel_month;
            $travel_day = (int) $travel_day;

            $sql = "SELECT * FROM tdu_auto_assign_rules 
                    WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                    AND (category = 'group' OR category = 'fit')
                    AND (
                        ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                        AND
                        ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                    )";
            $result = mysqli_query($conn, $sql);

            if(mysqli_num_rows($result) == 0) {
                $sql = "SELECT * FROM tdu_auto_assign_rules 
                        WHERE assign_type = 'region' AND region = '$assigned_to_region'
                        AND (
                            ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                            AND
                            ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                        )";
                $result = mysqli_query($conn, $sql);
            }

            if (mysqli_num_rows($result) > 0) {
                // if (substr($quote_number, -1) === 'G') {
                //     $quotetype = "group";
                // } else {
                //     $quotetype = "fit";
                // }
                $assignment_map = [
                    "group" => "assigned_to_ops",
                    "qa" => "assigned_to_qa"
                ];

                while ($row = mysqli_fetch_assoc($result)) {
                    $category = $row['category'];
                    if(!isset($assignment_map[$category])) {
                        continue;
                    }
                    $key = $assignment_map[$category];
                    $value = $row['username'];

                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                            VALUES ('$new_quoteid', 'group', '$value')
                            ON DUPLICATE KEY UPDATE $key = '$value'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }
        }

        if ($latest_stage != $quote_stage) {
            createTaskWithMessage($conn, $quote_stage, $new_quote_no);
        }

        if($quote_stage == 'PRE QA - completed') {
            $sql = "SELECT *
                    FROM vtiger_payment_history
                    WHERE quoteid='$quoteid'
                    ORDER BY added_on ASC;";
            $result = $conn->query($sql);
            $initial_amount = 0;
            $total_amount = 0;
            $trams_received_amount = 0;

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    if (isset($row['total_amount']) && !empty($row['total_amount'])) {
                        if (isset($row['source']) && $row['source'] == 'initial') {
                            $initial_amount = (float) $row['total_amount'];
                        }
                        if (isset($row['source']) && $row['source'] == 'final') {
                            $total_amount = (float) $row['total_amount'];
                        }
                    }
                    if (isset($row['trams_received_amount']) && !empty($row['trams_received_amount'])) {
                        $trams_received_amount += (float) $row['trams_received_amount'];
                    }
                }
                if($trams_received_amount >= $initial_amount - 30 && $quote_stage == 'PRE QA - completed') {
                    $sql = "UPDATE vtiger_quotes SET quotestage='Payment Received - Release Vouchers' WHERE quoteid='$quoteid';";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));

                    createTaskWithMessage($conn, 'Payment Received - Release Vouchers', $quote_number);
                }
            }
        }

        $original_no_of_adults = $_POST['original_no_of_adults'];
        $original_no_of_children = $_POST['original_no_of_children'];
        
        $original_total = (int) $original_no_of_adults + (int) $original_no_of_children;
        $new_total = (int) $adults + (int) $children;
        
        if (substr($new_quote_no, -1) !== 'G' && $new_total > 10) {
            $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%G';";
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if ($row['max_quote_no']) {
                $numeric_part = (int)substr($row['max_quote_no'], 3, -1);
                $new_numeric_part = $numeric_part + 1;
                $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part) . 'G';
            } else {
                $new_quote_no = "TDU00001G";
            }

            $quoteid = $new_quoteid;
            $sql_max_quoteid = "SELECT IFNULL(MAX(quoteid), 0) AS max_quoteid FROM vtiger_quotes";
            $result_max_quoteid = mysqli_query($conn, $sql_max_quoteid);
            if ($result_max_quoteid) {
                $row_max = mysqli_fetch_assoc($result_max_quoteid);
                $max_quoteid = $row_max['max_quoteid'];
                $new_quoteid = $max_quoteid + 1;
            }

            $tablesToDuplicate = [
                'vtiger_quotes',
                'tdu_flight_details',
                'tdu_product_alt_vendors_in_quote',
                'vtiger_invoice',
                'vtiger_invoice_add_products',
                'vtiger_invoice_adjustment',
                'vtiger_invoice_adjustment_history',
                'vtiger_invoice_refunds',
                'vtiger_notes',
                'vtiger_pax_in_hotel',
                'vtiger_payment_history',
                'vtiger_payment_supplier_history',
                'vtiger_supplier_payment'
            ];
            foreach ($tablesToDuplicate as $table) {
                duplicateTableRows($conn, $table, $quoteid, $new_quoteid);
            }

            $update_sql3 = "UPDATE vtiger_quotes SET quote_no = '$new_quote_no' WHERE quoteid = '$new_quoteid';";
            mysqli_query($conn, $update_sql3) or die(mysqli_error($mysqli));

            $update_sql4 = "UPDATE vtiger_quotes SET quotestage = 'Auto Rejected', ref_quote_no = '$new_quote_no' WHERE quoteid = '$quoteid';";
            mysqli_query($conn, $update_sql4) or die(mysqli_error($mysqli));

            $tablesToDuplicate = [
                'vtiger_inventoryproductrel',
                'vtiger_display_order'
            ];
            foreach ($tablesToDuplicate as $table) {
                duplicateTableRows($conn, $table, $quoteid, $new_quoteid, 'id');
            }

            $tablesToDuplicate = [
                'tdu_self_booked_hotels',
                'vtiger_coach_info',
                'vtiger_itinerary',
                'vtiger_itinerary_new_event',
                'vtiger_products_saleprice',
                'vtiger_quotescf',
                'vtiger_transfer_index'
            ];
            foreach ($tablesToDuplicate as $table) {
                duplicateTableRows($conn, $table, $quoteid, $new_quoteid);
            }

            $sql_duplicate_quotes_info = "
                INSERT INTO vtiger_quotes_info (
                    quoteid, quotetype, assigned_to_region, assigned_to_sales_agent, 
                    assigned_to_external_sales_agent, assigned_to_ops, assigned_to_qa, 
                    priority, time_stamp_with_name, travel_agent_contact_name, 
                    office_phone, mobile_phone, email
                )
                SELECT $new_quoteid, quotetype, assigned_to_region, assigned_to_sales_agent, 
                    assigned_to_external_sales_agent, assigned_to_ops, assigned_to_qa, 
                    priority, time_stamp_with_name, travel_agent_contact_name, 
                    office_phone, mobile_phone, email 
                FROM vtiger_quotes_info 
                WHERE quoteid = '$quoteid' AND quotetype != 'fit-dashboard';
            ";
            mysqli_query($conn, $sql_duplicate_quotes_info) or die("Error duplicating quotes_info rows: " . mysqli_error($conn));
        }
        
        header("Location: ?opt=summary&quoteNumber=$new_quote_no");
        exit();
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_notes'])) {
        $quoteid = $_POST['quoteid'];
        $category = $conn->real_escape_string($_POST['category']);
        $subcategory = $conn->real_escape_string($_POST['subcategory'] ?? '');
        $notes = $conn->real_escape_string($_POST['notes']);
        $attachment_path = '';
    
        // Handle file upload if any
        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
            $uploadDir = 'note_attachments/';
            $originalName = pathinfo($_FILES['attachment']['name'], PATHINFO_FILENAME);
            $fileExt = pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION);
            $timestamp = date('YmdHis');
            $safeName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $originalName); // Sanitize filename
            $newFileName = $safeName . '-' . $timestamp . '.' . $fileExt;
            $uploadPath = $uploadDir . $newFileName;
        
            // Create folder if not exists
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0775, true);
            }
        
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadPath)) {
                $attachment_path = $conn->real_escape_string($uploadPath);
            } else {
                die('File upload failed.');
            }
        }        
    
        // Insert into database
        $sql = "INSERT INTO vtiger_notes (quoteid, category, subcategory, notes, created_by, attachment_path) 
                VALUES ('$quoteid', '$category', '$subcategory', '$notes', '$username', '$attachment_path');";
    
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        $conn->close();
    
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=div-notes");
        exit();
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add-payment'])) {
        $quoteid = $_POST['quoteid'];
        $process_date = mysqli_real_escape_string($conn, $_POST['process_date']);
        $pay_type = mysqli_real_escape_string($conn, $_POST['pay_type']);
        $received_amount = mysqli_real_escape_string($conn, $_POST['received_amount']);
        $reference_no = mysqli_real_escape_string($conn, $_POST['reference_no']);
        $remarks = mysqli_real_escape_string($conn, $_POST['remarks']);
        $payment_method = mysqli_real_escape_string($conn, $_POST['payment_method']);

        $created_by = $_SESSION['user_name'];
        $sql_user = "SELECT CONCAT(first_name, ' ', last_name) AS user_fullname FROM vtiger_users WHERE user_name = '$created_by';";
        $result_user = mysqli_query($conn, $sql_user);
        if ($result_user) {
            if (mysqli_num_rows($result_user) > 0) {
                $row_user = mysqli_fetch_assoc($result_user);
                $created_by = $row_user['user_fullname'];
            }
        }
    
        $sql = "INSERT INTO vtiger_payment_history (quoteid, process_date, pay_type, trams_received_amount, reference_no, trams_remarks, payment_method, added_on, added_by) 
                VALUES ('$quoteid', '$process_date', '$pay_type', '$received_amount', '$reference_no', '$remarks', '$payment_method', NOW(), '$created_by')";
        mysqli_query($conn, $sql) or die(mysqli_error($conn, $sql));

        $sql = "SELECT *
                FROM vtiger_payment_history
                WHERE quoteid='$quoteid'
                ORDER BY added_on ASC;";
        $result = $conn->query($sql);
        $initial_amount = 0;
        $total_amount = 0;
        $trams_received_amount = 0;

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                if (isset($row['total_amount']) && !empty($row['total_amount'])) {
                    if (isset($row['source']) && $row['source'] == 'initial') {
                        $initial_amount = (float) $row['total_amount'];
                    }
                    if (isset($row['source']) && $row['source'] == 'final') {
                        $total_amount = (float) $row['total_amount'];
                    }
                }
                if (isset($row['trams_received_amount']) && !empty($row['trams_received_amount'])) {
                    $trams_received_amount += (float) $row['trams_received_amount'];
                }
            }
            if($trams_received_amount >= $initial_amount - 30 && $quotestage == 'PRE QA - completed') {
                $sql = "UPDATE vtiger_quotes SET quotestage='Payment Received - Release Vouchers' WHERE quoteid='$quoteid';";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));

                createTaskWithMessage($conn, 'Payment Received - Release Vouchers', $quote_number);
            }
        }

        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=customers");
        exit();
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['supplier-payment'])) {
        $quoteid = $_POST['quoteid'];
        $vendorid = $_POST['vendor'];
        $process_date = $_POST['process_date'];
        $pay_type = $_POST['pay_type'];
        $received_amount = $_POST['paid_amount'];
        $reference_no = $_POST['reference_no'];
        $remarks = $_POST['remarks'];
        $payment_method = $_POST['payment_method'];

        $created_by = $_SESSION['user_name'];
        $sql_user = "SELECT CONCAT(first_name, ' ', last_name) AS user_fullname FROM vtiger_users WHERE user_name = '$created_by';";
        $result_user = mysqli_query($conn, $sql_user);
        if ($result_user) {
            if (mysqli_num_rows($result_user) > 0) {
                $row_user = mysqli_fetch_assoc($result_user);
                $created_by = $row_user['user_fullname'];
            }
        }
    
        $sql = "INSERT INTO vtiger_payment_supplier_history (quoteid, process_date, pay_type, trams_received_amount, reference_no, trams_remarks, payment_method, added_on, added_by) 
                VALUES ('$quoteid', '$process_date', '$pay_type', '$received_amount', '$reference_no', '$remarks', '$payment_method', NOW(), '$created_by')";
        mysqli_query($conn, $sql) or die(mysqli_error($conn, $sql));

        $check_query = "SELECT * FROM vtiger_supplier_payment 
                        WHERE vendorid = '$vendorid' AND quoteid = '$quoteid'";
        $check_result = mysqli_query($conn, $check_query);

        if (mysqli_num_rows($check_result) > 0) {
            $sql_update_paid = "UPDATE vtiger_supplier_payment
                                SET paid_amount = paid_amount+'$received_amount'
                                WHERE vendorid = '$vendorid' AND quoteid = '$quoteid'";
            mysqli_query($conn, $sql_update_paid);
        } else {
            $sql_insert_payable = "INSERT INTO vtiger_supplier_payment 
                                    (quoteid, vendorid, paid_amount) 
                                    VALUES ('$quoteid', '$vendorid', '$received_amount')";
            mysqli_query($conn, $sql_insert_payable);
        }

        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=suppliers");
        exit();
    }

    else if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_supplier_payable'])) {
        foreach ($_POST['total_amount'] as $vendorId => $totalAmount) {
            $amountPaid = $_POST['amount_paid'][$vendorId];
            $paymentDeadline = $_POST['payment_deadline'][$vendorId];
            $remark = isset($_POST['remark'][$vendorId]) ? mysqli_real_escape_string($conn, $_POST['remark'][$vendorId]) : '';
            $filePath = '';
    
            // Handle the uploaded file for this vendor, if it exists
            if (isset($_FILES['invoice']['name'][$vendorId]) && $_FILES['invoice']['error'][$vendorId] == UPLOAD_ERR_OK) {
                // Set the upload directory and file path
                $uploadDir = 'supplier_invoice/';
                $fileName = basename($_FILES['invoice']['name'][$vendorId]);
                $fileName = str_replace(',', '', $fileName);
                $fileName = str_replace('"', '', $fileName);
                $targetFilePath = $uploadDir . date('dmY-His') . '-' . $fileName;
    
                // Move the file to the target directory
                if (move_uploaded_file($_FILES['invoice']['tmp_name'][$vendorId], $targetFilePath)) {
                    $filePath = mysqli_real_escape_string($conn, $targetFilePath);
                }
            }
    
            // Check if a record exists; if not, insert a new one
            $check_query = "SELECT * FROM vtiger_supplier_payment WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
            $check_result = mysqli_query($conn, $check_query);
    
            if (mysqli_num_rows($check_result) > 0) {
                // Update existing records
                if (!empty($totalAmount)) {
                    $sql_update_total = "UPDATE vtiger_supplier_payment SET total_amount = '$totalAmount' WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    mysqli_query($conn, $sql_update_total);
                }
    
                if (!empty($paymentDeadline)) {
                    $sql_update_deadline = "UPDATE vtiger_supplier_payment SET payment_deadline = '$paymentDeadline' WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    mysqli_query($conn, $sql_update_deadline);
                }
    
                if (!empty($amountPaid)) {
                    $sql_update_paid = "UPDATE vtiger_supplier_payment SET paid_amount = '$amountPaid' WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    mysqli_query($conn, $sql_update_paid);
                }
    
                if (!empty($remark)) {
                    $sql_update_remark = "UPDATE vtiger_supplier_payment SET remark = '$remark' WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    mysqli_query($conn, $sql_update_remark);
                }
    
                if (!empty($filePath)) {
                    // Get the current value of invoice_path
                    $sql_get_invoice_path = "SELECT invoice_path FROM vtiger_supplier_payment WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    $result = mysqli_query($conn, $sql_get_invoice_path);
                    $row = mysqli_fetch_assoc($result);
                
                    // If the invoice_path already exists, append the new file path
                    if ($row && !empty($row['invoice_path'])) {
                        $existingPaths = $row['invoice_path'];
                        $newPath = $existingPaths . ',' . $filePath;
                    } else {
                        // If no existing invoice_path, just use the new file path
                        $newPath = $filePath;
                    }
                    $newPath = mysqli_real_escape_string($conn, $newPath);
                
                    // Update the invoice_path with the appended value
                    $sql_update_invoice = "UPDATE vtiger_supplier_payment SET invoice_path = '$newPath' WHERE vendorid = '$vendorId' AND quoteid = '$quoteid'";
                    mysqli_query($conn, $sql_update_invoice);
                }
                
            } else {
                // Prepare fields for the insert query
                $fields = ["quoteid", "vendorid"];
                $values = ["'$quoteid'", "'$vendorId'"];
    
                if (!empty($totalAmount)) {
                    $fields[] = "total_amount";
                    $values[] = "'$totalAmount'";
                }
    
                if (!empty($paymentDeadline)) {
                    $fields[] = "payment_deadline";
                    $values[] = "'$paymentDeadline'";
                }
    
                if (!empty($amountPaid)) {
                    $fields[] = "paid_amount";
                    $values[] = "'$amountPaid'";
                }
    
                if (!empty($remark)) {
                    $fields[] = "remark";
                    $values[] = "'$remark'";
                }
    
                if (!empty($filePath)) {
                    $fields[] = "invoice_path";
                    $values[] = "'$filePath'";
                }
    
                // Insert new record
                $fieldString = implode(", ", $fields);
                $valueString = implode(", ", $values);
    
                $sql_insert_payable = "INSERT INTO vtiger_supplier_payment ($fieldString) VALUES ($valueString)";
                mysqli_query($conn, $sql_insert_payable);
            }
        }
    
        $conn->close();
        header("Location: quote.php?opt=summary&quoteNumber=$quote_number&edit=suppliers");
        exit();
    }

    $sql_day_checking = "SELECT vi.day, vi.cf_928, SUM(CAST(tp.duration AS DECIMAL(10,2))) AS total_duration
            FROM vtiger_inventoryproductrel vi
            LEFT JOIN tdu_products tp ON vi.productid = tp.productid
            WHERE vi.id = '$quoteid'
            GROUP BY vi.day, vi.cf_928";
    $result_day_checking = mysqli_query($conn, $sql_day_checking);

    $dayDurations = [];
    while ($row = mysqli_fetch_assoc($result_day_checking)) {
        $day = $row['day'];
        $type = strtolower(trim($row['cf_928']));  // lowercase for easy comparison
        $duration = (float)$row['total_duration']; // force numeric

        if (!isset($dayDurations[$day])) {
            $dayDurations[$day] = [
                'transfer' => 0,
                'attraction' => 0,
                'restaurant' => 0,
                'tour' => 0
            ];
        }

        if (strpos($type, 'transfer') !== false) {
            $dayDurations[$day]['transfer'] += $duration;
        } elseif (strpos($type, 'attraction') !== false) {
            $dayDurations[$day]['attraction'] += $duration;
        } elseif (strpos($type, 'restaurant') !== false) {
            $dayDurations[$day]['restaurant'] += $duration;
        } elseif (strpos($type, 'tour') !== false) {
            $dayDurations[$day]['tour'] += $duration;
        }
    }

    // Compare totals and collect qualifying days
    $qualifyingDays = [];
    foreach ($dayDurations as $day => $totals) {
        $transfers = $totals['transfer'];
        $others = $totals['attraction'] + $totals['restaurant'] + $totals['tour'];

        if ($transfers < $others) {
            $qualifyingDays[] = $day;
        }
    }

    $sql_range_check = "SELECT * FROM vtiger_inventoryproductrel WHERE id='$quoteid' AND cf_928='Transfers';";
    $result_range_check = mysqli_query($conn, $sql_range_check);
    $can_add_range = mysqli_num_rows($result_range_check) > 0;
    $edit_price = isset($_GET['edit']) && $_GET['edit'] === 'price' && $title != 'external';
    $edit_markup = isset($_GET['edit']) && $_GET['edit'] === 'markup';
    $sql_new_quote_check = "SELECT * FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
    $result_new_quote_check = mysqli_query($conn, $sql_new_quote_check);
    $sql_new_quote_check2 = "SELECT DISTINCT display_order FROM vtiger_display_order WHERE id='$quoteid';";
    $result_new_quote_check2 = mysqli_query($conn, $sql_new_quote_check2);
    $has_customised = false;
    $hotel_to_edit = false;
    $non_operation_product = false;
    $hasMultipleVendorPending = false;
    
    include "header.php";
    
    ?>
    <style>
        .content-div {
            display: none;
        }
        .button-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: left;
            margin: 0 0px;
        }

        .button-container button {
            font-size: 16px;
            padding: 10px 20px;
            border: 1px solid #ccc;
            color: white;
            background-color: #334155;
            cursor: pointer;
        }
        button {
            color: white;
            background-color: #334155;
            padding: 3px 6px;
            cursor: pointer;
        }
        p, strong, h3 {
            margin: 10px;
        }
    </style>

    <!-- search bar -->
    <div style="background-color: #EFAB23;">
        <form action="" method="GET" style="display: flex; align-items: center;">
            <p style="margin-right: 0; font-size: 18px;">Search by Quote Number:</p>
            <input type="hidden" name="opt" value="search">
            <input type="text" name="quote_no" style="margin-left: 10px;">
            <button type="submit" style="margin: 0 10px;">Search</button>
        </form>
    </div>

    <?php
    if(mysqli_num_rows($result) > 0) {
        ?>
        <!-- headings -->
        <div style="padding: 10px; background-color: #c5c5c5;">
            <h2>
                <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                <?php 
                echo htmlspecialchars($quote_number) . ' - ' . $subject; 
                if($quoteid_history != '') {
                    echo ' - History: ' . htmlspecialchars($created_at);
                }
                else {
                    $quote_number_history = $_GET['quoteNumber'];
                    $sql_history = "SELECT quoteid, created_at FROM vtiger_quotes WHERE quote_no='$quote_number_history' ORDER BY quoteid DESC;";
                    $result_history = mysqli_query($conn, $sql_history);
                }

                if($initial_path) {
                    echo ' <i class="fa-solid fa-receipt" title="Initial Invoice"></i>';
                }
                if($final_path) {
                    echo ' <i class="fa-solid fa-receipt" title="Final Invoice"></i>';
                }
                ?>
            </h2>
            <div style="display: flex; justify-content: space-between; margin: 0;">
                <div style="flex: 2; padding-right: 20px;">
                    <p>Quote Stage: <?php echo htmlspecialchars($quotestage); ?></p>
                    <p>Organization: <?php echo htmlspecialchars($accountname); ?></p>
                    <p>Contact Name: <?php echo htmlspecialchars($contactname); ?></p>
                    <p>Region: <?php echo htmlspecialchars($assigned_to_region); ?></p>
                    <p>Country: <?php echo htmlspecialchars($country); ?></p>
                    <p>Number of Passengers: <?php echo htmlspecialchars($pax_no); ?></p>
                </div>
            
                <div style="flex: 2; padding-left: 20px;">
                    <p>Date of Travel: 
                        <?php 
                        if (isset($date_of_travel) && $date_of_travel != '0000-00-00') {
                            $date = new DateTime($date_of_travel);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </p>
                    <p>Payment Deadline: 
                        <?php 
                        if (isset($payment_deadline) && $payment_deadline != '0000-00-00') {
                            $date = new DateTime($payment_deadline);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </p>
                    <p>Accepted Date: 
                        <?php 
                        if (isset($accepted_date) && $accepted_date != '0000-00-00') {
                            $date = new DateTime($accepted_date);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </p>
                    <?php
                    $sql_user = "SELECT CONCAT(first_name, ' ', last_name) AS user_fullname FROM vtiger_users WHERE user_name = '$created_by';";
                    $result_user = mysqli_query($conn, $sql_user);
                    if ($result_user) {
                        if (mysqli_num_rows($result_user) > 0) {
                            $row_user = mysqli_fetch_assoc($result_user);
                            $created_by = $row_user['user_fullname'];
                        }
                    }
                    ?>
                    <p>Created by: <?php echo $created_by; ?></p>
                    <p>Assigned to Ops: <?php echo $assigned_to_ops; ?></p>
                </div>

                <?php
                // status bar
                if(mysqli_num_rows($result) > 0) {
                    $sql_status_check = "SELECT cf_928, COUNT(*) AS row_count FROM vtiger_inventoryproductrel WHERE id='$quoteid' GROUP BY cf_928;";
                    $result_status_check = mysqli_query($conn, $sql_status_check);
                    $num_attraction = $num_hotel = $num_restaurant = $num_transfers = $num_tour = $num_sic = $num_guide = 0;
                    if (mysqli_num_rows($result_status_check) > 0) {
                        while ($row_status_check = mysqli_fetch_assoc($result_status_check)) {
                            switch ($row_status_check['cf_928']) {
                                case 'Attraction':
                                    $num_attraction = $row_status_check['row_count'];
                                    break;
                                case 'Hotel':
                                    $num_hotel = $row_status_check['row_count'];
                                    break;
                                case 'Restaurant':
                                    $num_restaurant = $row_status_check['row_count'];
                                    break;
                                case 'Transfers':
                                    $num_transfers = $row_status_check['row_count'];
                                    break;
                                case 'Tour':
                                    $num_tour = $row_status_check['row_count'];
                                    break;
                                case 'SIC':
                                    $num_sic = $row_status_check['row_count'];
                                    break;
                                case 'Guide':
                                    $num_guide = $row_status_check['row_count'];
                                    break;
                            }
                        }
                    }

                    $sql_status_check = "SELECT vip.cf_928, COUNT(*) AS row_count FROM vtiger_itinerary vi 
                                        LEFT JOIN vtiger_inventoryproductrel vip ON vi.quoteid=vip.id AND vi.sequence_no=vip.sequence_no 
                                        WHERE vi.quoteid='$quoteid'
                                        GROUP BY vip.cf_928;";
                    $result_status_check = mysqli_query($conn, $sql_status_check);
                    $total_num_attraction = $total_num_hotel = $total_num_restaurant = $total_num_transfers = $total_num_tour = $total_num_sic = $total_num_guide = 0;
                    if (mysqli_num_rows($result_status_check) > 0) {
                        while ($row_status_check = mysqli_fetch_assoc($result_status_check)) {
                            switch ($row_status_check['cf_928']) {
                                case 'Attraction':
                                    $total_num_attraction = $row_status_check['row_count'];
                                    break;
                                case 'Hotel':
                                    $total_num_hotel = $row_status_check['row_count'];
                                    break;
                                case 'Restaurant':
                                    $total_num_restaurant = $row_status_check['row_count'];
                                    break;
                                case 'Transfers':
                                    $total_num_transfers = $row_status_check['row_count'];
                                    break;
                                case 'Tour':
                                    $total_num_tour = $row_status_check['row_count'];
                                    break;
                                case 'SIC':
                                    $total_num_sic = $row_status_check['row_count'];
                                    break;
                                case 'Guide':
                                    $total_num_guide = $row_status_check['row_count'];
                                    break;
                            }
                        }
                    }

                    $sql_status_check = "SELECT vip.cf_928, COUNT(*) AS row_count
                                        FROM vtiger_itinerary vi
                                        LEFT JOIN vtiger_inventoryproductrel vip 
                                            ON vi.quoteid = vip.id AND vi.sequence_no = vip.sequence_no
                                        WHERE vi.quoteid = '$quoteid'
                                        AND vi.meta_key = 'booking_status'
                                        AND (vi.meta_value = 'Confirmation received' OR vi.meta_value = 'Portal Booking done & confirmed')
                                        AND vi.created_at = (
                                            SELECT MAX(sub_vi.created_at)
                                            FROM vtiger_itinerary sub_vi
                                            WHERE sub_vi.quoteid = vi.quoteid
                                                AND sub_vi.sequence_no = vi.sequence_no
                                                AND sub_vi.meta_key = 'booking_status'
                                        )
                                        GROUP BY vip.cf_928;";
                    $result_status_check = mysqli_query($conn, $sql_status_check);
                    $total_confirmed_attraction = $total_confirmed_hotel = $total_confirmed_restaurant = $total_confirmed_transfers = $total_confirmed_tour = $total_confirmed_sic = $total_confirmed_guide = 0;

                    if (mysqli_num_rows($result_status_check) > 0) {
                        while ($row_status_check = mysqli_fetch_assoc($result_status_check)) {
                            switch ($row_status_check['cf_928']) {
                                case 'Attraction':
                                    $total_confirmed_attraction = $row_status_check['row_count'];
                                    break;
                                case 'Hotel':
                                    $total_confirmed_hotel = $row_status_check['row_count'];
                                    break;
                                case 'Restaurant':
                                    $total_confirmed_restaurant = $row_status_check['row_count'];
                                    break;
                                case 'Transfers':
                                    $total_confirmed_transfers = $row_status_check['row_count'];
                                    break;
                                case 'Tour':
                                    $total_confirmed_tour = $row_status_check['row_count'];
                                    break;
                                case 'SIC':
                                    $total_confirmed_sic = $row_status_check['row_count'];
                                    break;
                                case 'Guide':
                                    $total_confirmed_guide = $row_status_check['row_count'];
                                    break;
                            }
                        }
                    }

                    $condition_for_attraction = null;
                    $condition_for_hotel = null;
                    $condition_for_restaurant = null;
                    $condition_for_transfers = null;
                    $condition_for_tour = null;
                    $condition_for_sic = null;
                    $condition_for_guide = null;
                    if ($total_num_attraction > 0) {
                        $condition_for_attraction = 'orange';
                        if ($total_confirmed_attraction >= $num_attraction) {
                            $condition_for_attraction = 'green';
                        }
                    }
                    if ($total_num_hotel > 0) {
                        $condition_for_hotel = 'orange';
                        if ($total_confirmed_hotel >= $num_hotel) {
                            $condition_for_hotel = 'green';
                        }
                    }
                    if ($total_num_restaurant > 0) {
                        $condition_for_restaurant = 'orange';
                        if ($total_confirmed_restaurant >= $num_restaurant) {
                            $condition_for_restaurant = 'green';
                        }
                    }
                    if ($total_num_transfers > 0) {
                        $condition_for_transfers = 'orange';
                        if ($total_confirmed_transfers >= $num_transfers) {
                            $condition_for_transfers = 'green';
                        }
                    }
                    if ($total_num_tour > 0) {
                        $condition_for_tour = 'orange';
                        if ($total_confirmed_tour >= $num_tour) {
                            $condition_for_tour = 'green';
                        }
                    }
                    if ($total_num_sic > 0) {
                        $condition_for_sic = 'orange';
                        if ($total_confirmed_sic >= $num_sic) {
                            $condition_for_sic = 'green';
                        }
                    }
                    if ($total_num_guide > 0) {
                        $condition_for_guide = 'orange';
                        if ($total_confirmed_guide >= $num_guide) {
                            $condition_for_guide = 'green';
                        }
                    }
                    if ($num_attraction == 0 || $quotestage == 'Created') {
                        $condition_for_attraction = 'grey';
                    }
                    if ($num_hotel == 0 || $quotestage == 'Created') {
                        $condition_for_hotel = 'grey';
                    }
                    if ($num_restaurant == 0 || $quotestage == 'Created') {
                        $condition_for_restaurant = 'grey';
                    }
                    if ($num_transfers == 0 || $quotestage == 'Created') {
                        $condition_for_transfers = 'grey';
                    }
                    if ($num_tour == 0 || $quotestage == 'Created') {
                        $condition_for_tour = 'grey';
                    }
                    if ($num_sic == 0 || $quotestage == 'Created') {
                        $condition_for_sic = 'grey';
                    }
                    if ($num_guide == 0 || $quotestage == 'Created') {
                        $condition_for_guide = 'grey';
                    }

                    $sql_status_check = "SELECT * FROM vtiger_payment_history WHERE quoteid='$quoteid';";
                    $result_status_check = $conn->query($sql_status_check);
                    $total_amount_status_check_initial = 0;
                    $total_amount_status_check_final = 0;
                    $trams_received_amount_status_check = 0;

                    if ($result_status_check->num_rows > 0) {
                        while ($row_status_check = $result_status_check->fetch_assoc()) {
                            if (isset($row_status_check['total_amount']) && !empty($row_status_check['total_amount'])) {
                                // $total_amount_status_check_final += (float) $row_status_check['total_amount'];
                                if(isset($row_status_check['source']) && $row_status_check['source'] == 'initial') {
                                    $total_amount_status_check_initial += (float) $row_status_check['total_amount'];
                                }
                                if(isset($row_status_check['source']) && $row_status_check['source'] == 'final') {
                                    $total_amount_status_check_final += (float) $row_status_check['total_amount'];
                                }
                            }
                            if (isset($row_status_check['trams_received_amount']) && !empty($row_status_check['trams_received_amount'])) {
                                $trams_received_amount_status_check += (float) $row_status_check['trams_received_amount'];
                            }
                        }
                    }

                    if($total_amount_status_check_initial > 30) {
                        $total_amount_status_check_initial -= 30;
                    }
                    if($total_amount_status_check_final > 30) {
                        $total_amount_status_check_final -= 30;
                    }

                    if($trams_received_amount_status_check > 0) {
                        $accountname_esc = mysqli_real_escape_string($conn, $accountname);
                        $sql_vtiger_initial_invoice_percentage = "SELECT * FROM vtiger_initial_invoice_percentage 
                                                                  WHERE (accountname='$accountname_esc' AND type='accountname') OR (quote_no='$quote_number' AND type='quote_no');";
                        $result_vtiger_initial_invoice_percentage = mysqli_query($conn, $sql_vtiger_initial_invoice_percentage);
                        $ratio = 1;
                        if(mysqli_num_rows($result_vtiger_initial_invoice_percentage) > 0) {
                            $ratio = 0.8;
                        }
                        $initial_invoice_condition = 'orange';
                        $final_invoice_condition = 'orange';
                        if($trams_received_amount_status_check >= $total_amount_status_check_initial*$ratio) {
                            $initial_invoice_condition = 'green';
                        }
                        if($trams_received_amount_status_check >= $total_amount_status_check_final) {
                            $final_invoice_condition = 'green';
                        }
                    }
                    if(!$initial_path) {
                        $initial_invoice_condition = 'grey';
                    }
                    if(!$final_path) {
                        $final_invoice_condition = 'grey';
                    }

                    $condition_for_naming = shouldDisableAccepted($conn, $quoteid); 
                    
                    ?>
                    <div style="flex: 3;">
                        <div class="status-container">
                            <?php
                            if($title == 'admin' && $initial_path) {
                                ?>
                                <button type="button" id="resetInvoiceButton" style="margin-right: 5px;" onclick="resetInvoice()"><i class="fa-solid fa-rotate-right" title="Reset"></i></button>
                                <?php
                            }
                            ?>
                            <div class="status-text"><?= substr($quote_number, -1) === 'G' ? 'Initial' : '' ?> Invoice</div>
                            <div class="status-indicator <?php echo ($initial_invoice_condition ? $initial_invoice_condition : 'red'); ?>"></div>
                        </div>
                        <?php if($title == 'admin' && ($quotestage == 'Created' || $quotestage == 'Requote')) : ?>
                            <div class="status-container">
                                <div class="status-text"><i class="fa-solid fa-envelope"></i> Auto Followup</div>
                                <div class="status-indicator <?php echo ($auto_email_follow_up >= 0 ? 'green' : 'red'); ?>" 
                                    style="cursor: pointer;"
                                    data-quoteid="<?php echo $quoteid; ?>"
                                    data-current-status="<?php echo $auto_email_follow_up; ?>"
                                    onclick="toggleAutoFollowup(this)"></div>
                            </div>
                            <script>
                                function toggleAutoFollowup(element) {
                                    var quoteid = element.getAttribute('data-quoteid');
                                    var currentStatus = parseInt(element.getAttribute('data-current-status'));

                                    if (!quoteid) {
                                        console.error("Quote ID is missing");
                                        return;
                                    }

                                    var newStatus;
                                    var confirmMessage;

                                    if (currentStatus >= 0) {
                                        // Currently active, confirm to make inactive
                                        confirmMessage = "Are you sure you want to disable auto follow-up?";
                                        newStatus = -1;
                                    } else {
                                        // Currently inactive, confirm to make active
                                        confirmMessage = "Are you sure you want to enable auto follow-up?";
                                        newStatus = 0;
                                    }

                                    if (!confirm(confirmMessage)) {
                                        return; // User cancelled
                                    }

                                    var xhr = new XMLHttpRequest();
                                    xhr.open("POST", "ajax_update_auto_followup.php", true);
                                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                                    xhr.onload = function() {
                                        if (xhr.status === 200) {
                                            if (xhr.responseText === "success") {
                                                if (newStatus === -1) {
                                                    element.classList.remove("green");
                                                    element.classList.add("red");
                                                } else {
                                                    element.classList.remove("red");
                                                    element.classList.add("green");
                                                }
                                                element.setAttribute('data-current-status', newStatus);
                                            } else {
                                                alert("Failed to update auto follow-up status");
                                            }
                                        }
                                    };

                                    xhr.send("quoteid=" + encodeURIComponent(quoteid) + "&new_status=" + encodeURIComponent(newStatus));
                                }
                            </script>
                        <?php endif; ?>

                        <?php if (substr($quote_number, -1) === 'G'): ?>
                            <div class="status-container">
                                <div class="status-text">Final Invoice</div>
                                <div class="status-indicator <?php echo ($final_invoice_condition ? $final_invoice_condition : 'red'); ?>"></div>
                            </div>
                        <?php endif;?>
                    </div>
                    <div style="flex: 1; padding-right: 20px;">
                        <div class="status-container">
                            <div class="status-text">Attraction</div>
                            <div class="status-indicator <?php echo ($condition_for_attraction ? $condition_for_attraction : 'red'); ?>"></div>
                        </div>
                    
                        <div class="status-container">
                            <div class="status-text">Hotel</div>
                            <div class="status-indicator <?php echo ($condition_for_hotel ? $condition_for_hotel : 'red'); ?>"></div>
                        </div>
                    
                        <div class="status-container">
                            <div class="status-text">Restaurant</div>
                            <div class="status-indicator <?php echo ($condition_for_restaurant ? $condition_for_restaurant : 'red'); ?>"></div>
                        </div>
                    
                        <div class="status-container">
                            <div class="status-text">Transfers</div>
                            <div class="status-indicator <?php echo ($condition_for_transfers ? $condition_for_transfers : 'red'); ?>"></div>
                        </div>

                        <div class="status-container">
                            <div class="status-text">SIC</div>
                            <div class="status-indicator <?php echo ($condition_for_sic ? $condition_for_sic : 'red'); ?>"></div>
                        </div>
                        
                        <div class="status-container">
                            <div class="status-text">Tour</div>
                            <div class="status-indicator <?php echo ($condition_for_tour ? $condition_for_tour : 'red'); ?>"></div>
                        </div>

                        <div class="status-container">
                            <div class="status-text">Guide</div>
                            <div class="status-indicator <?php echo ($condition_for_guide ? $condition_for_guide : 'red'); ?>"></div>
                        </div>
                        
                        <div class="status-container">
                            <div class="status-text">Pax List</div>
                            <div class="status-indicator 
                                <?php 
                                    echo ($condition_for_naming ? 'red' : 'green'); 
                                ?>"
                            ></div>
                        </div>
                    </div>
                    <style>
                        .status-container {
                            display: flex;
                            justify-content: flex-end;
                            align-items: center;
                            margin-bottom: 10px;
                        }
                        .status-indicator {
                            width: 20px;
                            height: 20px;
                            border-radius: 50%;
                            margin-left: 10px;
                        }
                        .status-indicator.red {
                            background-color: red;
                        }
                        .status-indicator.green {
                            background-color: green;
                        }
                        .status-indicator.orange {
                            background-color: orange;
                        }
                        .status-indicator.grey {
                            background-color: grey;
                        }
                    </style>
                    <?php
                }
                ?>
            </div>
                <?php
                if($ref_quote_no) {
                    ?>
                    <h2 style="margin: 10px; padding: 10px; background-color: red; text-align: center;">
                        Quote is moved to 
                        <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($ref_quote_no); ?>">
                            <?= htmlspecialchars($ref_quote_no); ?>
                        </a>
                    </h2>
                    <?php
                }
                ?>
            
            <?php if ($ai_ref_id > 0) : ?>
                <h3 style="text-align: center;">
                    <i class="fa-solid fa-robot"></i> TAI Quote <?= $ai_ref_id ?>
                </h3>
            <?php endif; ?>
        </div>

        <!-- button taps -->
        <?php $allowed_quote_tabs = explode(',', fetchAllowedQuoteTabs($conn, $title)); ?>
        <div class="button-container">
            <?php if (in_array(1, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div1', this)">Quote</button>
            <?php endif; ?>
            <?php if (in_array(2, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div2', this)">Pricing</button>
            <?php endif; ?>
            <?php if (in_array(3, $allowed_quote_tabs) && $ref_quote_no == '') : ?>
                <button type="button" onclick="confirmRedirectPaxList()">Pax List</button>
                <script>
                    function confirmRedirectPaxList() {
                        if (confirm('Are you sure you want to view the Pax List? It will leave this page')) {
                            location.href = '?opt=hotel-pax&quoteid=<?php echo urlencode($quoteid); ?>&quoteNumber=<?php echo urlencode($quote_number); ?>';
                        }
                    }
                </script>
            <?php endif; ?>
            <?php if (in_array(4, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div-notes', this)">Notes</button>
            <?php endif; ?>
            <?php if (in_array(5, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div17', this)">Tasks</button>
            <?php endif; ?>
            <?php if (in_array(7, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div6', this)">Edit Details</button>
            <?php endif; ?>
            <?php if (in_array(8, $allowed_quote_tabs)) : ?>
                <?php if ($quoteid_history != '') : ?>
                    <button type="button" onclick="window.location.href='?opt=summary&quoteNumber=<?php echo $quote_number; ?>'">Edit Quote</button>
                <?php else : ?>
                    <button type="button" onclick="showDiv('div3', this)">History</button>
                <?php endif; ?>
            <?php endif; ?>
            <?php if (in_array(9, $allowed_quote_tabs) && $ref_quote_no == '') : ?>
                <button type="button" onclick="showDiv('div5', this)">Document</button>
            <?php endif; ?>
            <?php if (in_array(10, $allowed_quote_tabs)) : ?>
                <button type="button" id="toggleOperationButtons" onclick="toggleOperationButtons(this)">Operation</button>
            <?php endif; ?>
            <?php if (in_array(11, $allowed_quote_tabs)) : ?>
                <button type="button" id="togglePaymentButtons" onclick="togglePaymentButtons(this)">Payment</button>
            <?php endif; ?>
            <?php if (in_array(12, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div13', this)">MailBox</button>
            <?php endif; ?>
            <?php if (in_array(13, $allowed_quote_tabs)) : ?>
                <button type="button" onclick="showDiv('div14', this)">Template</button>
            <?php endif; ?>
            <?php if (in_array(15, $allowed_quote_tabs) && $initial_path) : ?>
                <button type="button" onclick="showDiv('div8', this)">Adjustment</button>
            <?php endif; ?>
            <?php if (true) : ?>
                <button type="button" onclick="if(confirm('Are you sure you want to proceed to the Rezdy booking?')) window.location.href='quote.php?opt=rezdy-booking&quoteNumber=<?= $quote_number ?>'">Rezdy</button>
            <?php endif; ?>
        </div>
        
        <!-- sub button tabs -->
        <div id="operation-buttons" class="button-container" style="display: none; margin-top: 20px;">
            <button type="button" onclick="showDiv('div-attraction', this)" <?= $num_attraction == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Attraction</button>
            <button type="button" onclick="showDiv('div-hotel', this)">Hotel</button>
            <button type="button" onclick="showDiv('div-restaurant', this)" <?= $num_restaurant == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Restaurant</button>
            <button type="button" onclick="showDiv('div-tour', this)" <?= $num_tour == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Tour</button>
            <button type="button" onclick="showDiv('div-transfer', this)" <?= $num_transfers == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Transfers</button>
            <button type="button" onclick="showDiv('div-guide', this)" <?= $num_guide == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Guide</button>
            <button type="button" onclick="showDiv('div-sic', this)" <?= $num_sic == 0 || (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>SIC</button>
            <button type="button" onclick="openImportEventModal()" <?= (empty($assigned_to_ops) && $title != 'admin') ? 'disabled' : '' ?>>Import Event</button>
            <?= (empty($assigned_to_ops) && $title != 'admin') ? '<div><h3>Please assign to ops person in Edit Details before operating</h3></div>' : '' ?>
            <style>
                #operation-buttons button {
                    padding: 5px 10px;
                }
            </style>
        </div>

        <!-- Import Event Modal -->
        <div id="importEventModal" class="modal" style="display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4);">
            <div class="modal-content">
                <span class="close" onclick="closeImportEventModal()">&times;</span>
                <h3>Import Event</h3>

                <label for="itineraryId">Enter Itinerary ID:</label>
                <input type="text" id="itineraryId"><br>

                <label for="itineraryFromDay">Enter Day you want to copy from:</label>
                <input type="number" id="itineraryFromDay" min="1"><br>

                <label for="itineraryToDay">Enter Day you want to put the itinerary to:</label>
                <input type="number" id="itineraryToDay" min="1"><br>

                <button type="button" onclick="importEvent()">Import</button>
            </div>
        </div>
        <script>
            function openImportEventModal() {
                document.getElementById('importEventModal').style.display = 'block';
            }

            function closeImportEventModal() {
                document.getElementById('importEventModal').style.display = 'none';
            }

            function importEvent() {
                var itineraryId = document.getElementById('itineraryId').value;
                var itineraryFromDay = document.getElementById('itineraryFromDay').value;
                var itineraryToDay = document.getElementById('itineraryToDay').value;
                var quoteId = <?= $quoteid ?>;
                
                if (!itineraryId) {
                    alert('Please enter an Itinerary ID.');
                    return;
                }

                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_import_quote_event.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert('Event imported successfully!');
                        location.reload();
                    }
                };

                var params = 
                    'quoteid=' + encodeURIComponent(quoteId) +
                    '&itineraryid=' + encodeURIComponent(itineraryId) +
                    '&fromday=' + encodeURIComponent(itineraryFromDay) +
                    '&today=' + encodeURIComponent(itineraryToDay);

                xhr.send(params);
            }
        </script>

        <div id="payment-buttons" class="button-container" style="display: none; margin-top: 20px;">
            <button type="button" onclick="showDiv('div9', this)">Receive from Customers</button>
            <button type="button" onclick="showDiv('div12', this)">Pay to Suppliers</button>
            <style>
                #payment-buttons button {
                    padding: 5px 10px;
                }
            </style>
        </div>

        <?php
        // add range
        if($can_add_range) {
            // code for quick generating pax ranges
            if($pax_row_num <= 0 && $mode == 'group') {
                ?>
                <div style="border: 1px solid black; border-collapse: collapse; padding: 10px; margin: 10px;">
                    <h2>Quick Set Pax Range</h2><br>
                    <form action="" method="post">
                        <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
                        <label for="start">Start:</label>
                        <input type="number" id="start" name="start" required>

                        <label for="step">Step:</label>
                        <input type="number" id="step" name="step" required>

                        <label for="number">Number of ranges:</label>
                        <input type="number" id="number" name="number" required>

                        <button type="submit" name="quick_set_pax_range">Quick Set</button>
                    </form>
                    
                    <p style="font-family: Arial, sans-serif; font-size: 16px;">
                        Start represents the minimum number of passengers for the first range. <br><br>
                        Step indicates how many passengers are included within each subsequent range. <br><br>
                        Number of ranges defines the total number of ranges to be created<br><br>
                        For example,
                        Start: <span style="color: #ff6347; padding: 0 5px; font-weight: bold;">25</span>, 
                        Step: <span style="color: #4682b4; padding: 0 5px; font-weight: bold;">5</span>, 
                        Number of ranges: <span style="color: #32cd32; padding: 0 5px; font-weight: bold;">2</span>
                        will generate <span style="color: #32cd32; padding: 0 5px; font-weight: bold;">2</span> ranges: 
                        <span style="color: #ff6347; padding: 0 5px; font-weight: bold;">25</span>-
                        <span style="padding: 0 5px; font-weight: bold;">29</span>,
                        <span style="color: #4682b4; padding: 0 5px; font-weight: bold;">30</span>-
                        <span style="padding: 0 5px; font-weight: bold;">34</span>
                        (<span style="color: #4682b4; padding: 0 5px; font-weight: bold;">30</span>=<span style="color: #ff6347; padding: 0 5px; font-weight: bold;">25</span>+<span style="color: #4682b4; padding: 0 5px; font-weight: bold;">5</span>)
                    </p>
                </div>
                <?php
            }
            ?>
            <!-- popup form to add new transfers rule -->
            <div id="popupForm-range" class="popup" style="display: none;">
                <div class="popup-content">
                    <span class="close1">&times;</span>
                    <form action="" method="post">
                        <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
                        Pax: 
                        <input type="number" name="min_pax_range" min="1" required placeholder="Min Pax"> - 
                        <input type="number" name="max_pax_range" min="1" required placeholder="Max Pax">
                        <button type="submit" name="set_pax_range">Add</button>
                    </form>
                </div>
            </div>
            <?php
        }
        ?>
        
        <!-- quote history -->
        <div id="div3" class="content-div" style="margin-top: 20px;">
            <button type="button" style="padding: 5px 10px; font-size: 16px;" onclick="showHistorySubTab('quote-history-tab3')">Assigned To</button>
            <button type="button" style="padding: 5px 10px; font-size: 16px;" onclick="showHistorySubTab('quote-history-tab1')">Quote Modification</button>
            <button type="button" style="padding: 5px 10px; font-size: 16px;" onclick="showHistorySubTab('quote-history-tab2')">Document Download</button>
            <button type="button" style="padding: 5px 10px; font-size: 16px;" onclick="showHistorySubTab('quote-history-tab4')">Deleted Products</button>

            <div id="quote-history-tab1" class="quote-history-tab-content">
                <?php
                $sql_quote_stage_history = "SELECT vqst.user_name, vqst.stage, vqst.created_at, CONCAT(first_name, ' ', last_name) AS user_fullname
                                            FROM vtiger_quote_stage_track vqst
                                            LEFT JOIN vtiger_users vu ON vqst.user_name=vu.user_name
                                            WHERE quoteid = '$quoteid'
                                            ORDER BY vqst.created_at DESC";
                $result_quote_stage_history = mysqli_query($conn, $sql_quote_stage_history);

                if (!$result_quote_stage_history) {
                    die("Query failed: " . mysqli_error($conn));
                }
                ?>
                    
                <h2 style="margin: 15px;">Quote Modification History</h2>
                <div class="table-container table-wrapper" style="width: 50%;">
                    <table>
                        <?php
                        if ($result_history && mysqli_num_rows($result_history) > 1) {
                            ?>
                            <tr>
                                <th>Stage</th>
                                <th>Updated by</th>
                                <th>Updated At</th>
                            </tr>
                            <?php
                        }
                        while ($row = mysqli_fetch_assoc($result_quote_stage_history)) {
                            echo "<tr>
                                    <td>" . htmlspecialchars($row['stage']) . "</td>
                                    <td>" . htmlspecialchars($row['user_fullname']) . "</td>
                                    <td>" . htmlspecialchars($row['created_at']) . "</td>
                                </tr>";
                        }
                        ?>
                    </table>
                </div>
            </div>
            <div id="quote-history-tab2" class="quote-history-tab-content">
                <h2 style="margin: 15px;">Document Download History</h2>
                <div class="table-container table-wrapper" style="width: 50%;">
                    <table border="1" cellpadding="10" cellspacing="0">
                        <tr>
                            <th>Details</th>
                            <th>Download Time</th>
                            <th>Download Person</th>
                        </tr>
                        <?php
                        $sql_download_history = "SELECT created_at, created_by, type FROM vtiger_invoice WHERE quoteid='$quoteid' ORDER BY created_at DESC;";
                        $result_download_history = $conn->query($sql_download_history);

                        $downloadTypes = downloadType();

                        if ($result_download_history->num_rows > 0) {
                            while($row_download_history = $result_download_history->fetch_assoc()) {
                                echo "<tr>";
                                echo "<td>" . $downloadTypes[$row_download_history["type"]] . "</td>";
                                echo "<td>" . $row_download_history["created_at"] . "</td>";
                                echo "<td>" . $row_download_history["created_by"] . "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='3'>No records found</td></tr>";
                        }
                        ?>
                    </table>
                </div>
            </div>
            <div id="quote-history-tab3" class="quote-history-tab-content">
                <h2 style="margin: 15px;">Assigned To History</h2>
                <?php
                $sql_history3 = "SELECT * FROM vtiger_quotes_info WHERE quoteid='$quoteid' AND quotetype='group'";
                $result_history3 = mysqli_query($conn, $sql_history3);

                if ($result_history3 && mysqli_num_rows($result_history3) > 0) {
                    $row_history3 = mysqli_fetch_assoc($result_history3); // Fetch only one row since it's displayed vertically
                    ?>
                    <table style="width: 50%; border-collapse: collapse; border: 1px solid #ddd; margin: 20px;">
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Assigned to Region</td>
                            <td style="padding: 10px; border: 1px solid #ddd;"><?php echo htmlspecialchars($row_history3['assigned_to_region']); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Assigned to Internal Sales Agent</td>
                            <td style="padding: 10px; border: 1px solid #ddd;"><?php echo htmlspecialchars($row_history3['assigned_to_sales_agent']); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Assigned to External Sales Agent</td>
                            <td style="padding: 10px; border: 1px solid #ddd;"><?php echo htmlspecialchars($row_history3['assigned_to_external_sales_agent']); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Assigned to Operation Person</td>
                            <td style="padding: 10px; border: 1px solid #ddd;"><?php echo htmlspecialchars($row_history3['assigned_to_ops']); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Assigned to QA</td>
                            <td style="padding: 10px; border: 1px solid #ddd;"><?php echo htmlspecialchars($row_history3['assigned_to_qa']); ?></td>
                        </tr>
                    </table>
                    <?php
                } else {
                    echo "<p style='text-align: center; font-weight: bold; color: red;'>No records found</p>";
                }
                ?>
            </div>
            <div id="quote-history-tab4" class="quote-history-tab-content">
                <h2 style="margin: 15px;">Deleted Products History</h2>
                <?php
                $sql_history = "SELECT details, created_at FROM vtiger_products_delete_history WHERE quoteid='$quoteid' ORDER BY created_at DESC";
                $result_history = $conn->query($sql_history);
                ?>
                <?php if ($result_history->num_rows > 0): ?>
                    <?php while ($row_history = $result_history->fetch_assoc()): ?>
                        <div class="note-container">
                            <table class="note-table">
                                <tr style="background-color: #f9f9f9;">
                                    <th colspan="2">Deleted at <?php echo $row_history['created_at']; ?></th>
                                </tr>
                                <tr>
                                    <td colspan="2"><?php echo nl2br($row_history['details']); ?></td>
                                </tr>
                            </table>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="note-container">
                        <table class="note-table">
                            <tr>
                                <td colspan="2">No deleted product history found</td>
                            </tr>
                        </table>
                    </div>
                <?php endif; ?>
            </div>

            <style>
                .quote-history-tab-content {
                    display: none;
                    margin-top: 20px;
                }
            </style>

            <script>
                function showHistorySubTab(tabId) {
                    document.querySelectorAll('.quote-history-tab-content').forEach(tab => {
                        tab.style.display = 'none';
                    });
                    document.getElementById(tabId).style.display = 'block';
                }
            </script>
        </div>

        <?php
        $sql_sequence_check = "SELECT sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid' AND cf_928='Hotel'";
        $result_sequence_check1 = mysqli_query($conn, $sql_sequence_check);
        
        $room_mismatch = false;
        while ($row1 = mysqli_fetch_assoc($result_sequence_check1)) {
            $sequence_no1 = $row1['sequence_no'];
        
            $sql_itinerary = "
                SELECT meta_key, meta_value 
                FROM vtiger_itinerary 
                WHERE quoteid='$quoteid' AND sequence_no = '$sequence_no1'
                ORDER BY created_at DESC";
            $result_itinerary = mysqli_query($conn, $sql_itinerary);
        
            $meta_values = [];
            while ($meta_row = mysqli_fetch_assoc($result_itinerary)) {
                $meta_key = $meta_row['meta_key'];
                $meta_value = $meta_row['meta_value'];
                
                if (!isset($meta_values[$meta_key])) {
                    $meta_values[$meta_key] = $meta_value;
                }
            }
        
            $adults = isset($meta_values['adults']) ? (int)$meta_values['adults'] : 0;
            $children = isset($meta_values['children']) ? (int)$meta_values['children'] : 0;
            $child_without_bed = isset($meta_values['child_without_bed']) ? (int)$meta_values['child_without_bed'] : 0;
            $single_rooms1 = isset($meta_values['single_rooms']) ? (int)$meta_values['single_rooms'] : 0;
            $double_rooms1 = isset($meta_values['double_rooms']) ? (int)$meta_values['double_rooms'] : 0;
            $triple_rooms1 = isset($meta_values['triple_rooms']) ? (int)$meta_values['triple_rooms'] : 0;
        
            $total_people = $adults + $children;
            $total_capacity = $single_rooms1 + (2 * $double_rooms1) + (3 * $triple_rooms1) + $child_without_bed;

            if($total_people != $total_capacity) {
                $room_mismatch = true;
                break;
            }
        }
        ?>

        <script>
            function resetInvoice() {
                var confirmed = confirm("Are you sure you want to reset this invoice? This action cannot be undone.");

                if (confirmed) {
                    var quoteid = <?= $quoteid ?>;
                    var username = '<?= $username ?>';
                    $.ajax({
                        url: 'ajax_reset_invoice.php',
                        type: 'POST',
                        data: { quoteid: quoteid, username: username },
                        success: function(response) {
                            alert(response);
                            location.reload();
                        },
                        error: function(xhr, status, error) {
                            alert('Error: ' + error);
                        }
                    });
                }
            }
        </script>

        <style>
            .tooltip {
                position: relative;
                display: inline-block;
                cursor: not-allowed; /* Optional: to show it's disabled */
            }

            .tooltip .tooltiptext {
                visibility: hidden;
                width: 50vw;
                background-color: black;
                color: white;
                text-align: left;
                border-radius: 5px;
                padding: 5px;
                position: fixed;
                z-index: 1;
                top: 45vh;
                left: 0%;
                font-size: 24px;
                opacity: 0;
                transition: opacity 0.3s;
            }

            .tooltip:hover .tooltiptext {
                visibility: visible;
                opacity: 1;
            }
        </style>

        <style>
            #saleOrderContainer {
                user-select: none; /* Standard */
                -webkit-user-select: none; /* Safari */
                -moz-user-select: none; /* Firefox */
                -ms-user-select: none; /* IE10+ */
            }
        </style>

        <script>
            const element = document.getElementById("saleOrderContainer");

            element.addEventListener("copy", (event) => {
                event.preventDefault();
            });

            element.addEventListener("cut", (event) => {
                event.preventDefault();
            });

            element.addEventListener("paste", (event) => {
                event.preventDefault();
            });
        </script>

        <!-- Document loading -->
        <script>
            function loadSaleOrder() {
                const container = document.getElementById('saleOrderContainer');

                // Show the container
                container.style.display = 'block';

                // Add animated loading content
                container.innerHTML = `
                    <div>
                        <h2>Loading...<br><br>This may take a while to display</h2><br><br>
                        <div class="spinner"></div>
                    </div>
                `;

                // AJAX request to fetch the sale order content
                const xhr = new XMLHttpRequest();
                xhr.open("GET", "ajax_display_itinerary.php?quoteid=<?php echo htmlspecialchars($quoteid); ?>", true);
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4) {
                        if (xhr.status === 200) {
                            container.innerHTML = xhr.responseText;
                        } else {
                            container.innerHTML = '<p>Error loading content. Please try again later.</p>';
                        }
                    }
                };
                xhr.send();
            }

            function downloadInvoice(filePath, quoteId, type) {
                // AJAX call to insert into database
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "export_quote.php", true);
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        console.log("Invoice inserted into database");
                    }
                };
                xhr.send("quoteid=" + quoteId + "&filepath=" + filePath + "&type=" + type + "&download-invoice");

                // Proceed with file download
                const link = document.createElement('a');
                link.href = filePath;
                link.download = '';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            }
        </script>
        <style>
            .spinner {
                width: 50px;
                height: 50px;
                border: 5px solid #ccc;
                border-top: 5px solid #3498db;
                border-radius: 50%;
                animation: spin 1s linear infinite;
            }

            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
        </style>

        <style>
            #div5 button {
                font-size: 16px;
                padding: 5px 10px;
                border: 1px solid #ccc;
                color: white;
                background-color: #334155;
                cursor: pointer;
            }
        </style>

        <!-- Self Drive Modal -->
        <div id="selfDrivePriceModal" 
            style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); 
                    background: white; padding: 20px; border-radius: 8px; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3); 
                    width: 300px; text-align: left;">
            <h3 style="margin: 10px 0;">Enter Price</h3>
            <span class="close-modal" style="cursor: pointer; color: red; font-weight: bold; position: absolute; top: 10px; right: 15px;"><i class="fa-solid fa-xmark"></i></span>
            <form id="updatePriceForm">
                <input type="hidden" id="self_drive_quote_id" name="self_drive_quote_id">
                <input type="hidden" id="self_drive_sequence_no" name="self_drive_sequence_no">
                <div style="margin-bottom: 15px;">
                    <input type="number" step="0.01" min="0" id="self_drive_price" name="self_drive_price" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                </div>
                <button type="submit">Save</button>
            </form>
        </div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
        $(document).ready(function() {
            $(".update-self-drive-btn").click(function() {
                let quoteId = $(this).data("quoteid");
                let sequenceNo = $(this).data("sequence-no");

                $("#self_drive_quote_id").val(quoteId);
                $("#self_drive_sequence_no").val(sequenceNo);

                $("#selfDrivePriceModal").show();
            });

            $(".close-modal").click(function() {
                $("#selfDrivePriceModal").hide();
            });

            $("#updatePriceForm").submit(function(e) {
                e.preventDefault();
                
                let formData = $(this).serialize();

                $.ajax({
                    url: "ajax_update_self_drive_price.php", // Update this to your PHP script
                    type: "POST",
                    data: formData,
                    success: function(response) {
                        alert(response); // Handle response from server
                        $("#selfDrivePriceModal").hide();
                        location.reload();
                    },
                    error: function() {
                        alert("Error updating price.");
                    }
                });
            });
        });
        </script>

        <!-- table showing all events -->
        <div id="div1" class="content-div">
            <?php if (in_array(1, $allowed_quote_tabs)) : ?>
            <form method="post" action="">
                <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo htmlspecialchars($quote_number); ?>">
                <table id="productTable" class="styled-table" style="text-align: left">
                    <thead id="productTableHeader" style="display: none;">
                        <tr>
                            <th></th>
                            <th>Source</th>
                            <th>Day</th>
                            <th style="width: 15%;">Vendor</th>
                            <th style="width: 15%;">Product <?= ($pax_no > 50) ? ' (Please edit Transfers price after saving)' : '' ?></th>
                            <th>Adult Price</th>
                            <th>Child Price</th>
                            <th>Category</th>
                            <th>City</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Rows will be added here -->
                    </tbody>
                </table>
                <?php 
                if($quoteid_history == '' && !$initial_path && $title != 'external' && $ref_quote_no == '') {
                    ?>
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div style="margin: 0;">
                            <button type="button" id="add-product-btn">Add TDU Products</button>
                            <button type="button" onclick="addCustomRow('<?= $country ?>')">Add Custom Products</button>
                            <button type="button" onclick="window.location.href='quote.php?opt=products-csv-analysis&quoteid=<?= $quoteid ?>'">Import CSV</button>
                            <button type="button" onclick="window.location.href='quote.php?opt=templates&quoteid=<?= $quoteid ?>'">Add Template Products</button>
                            <button type="button" id="downloadCsvBtn">Export Quote Details</button>
                            <script>
                                document.getElementById("downloadCsvBtn").addEventListener("click", function () {
                                    fetch("ajax_download_quote_products_csv.php?quoteid=<?= $quoteid ?>")
                                        .then(response => response.blob())
                                        .then(blob => {
                                            const url = window.URL.createObjectURL(blob);
                                            const a = document.createElement("a");
                                            a.href = url;
                                            a.download = "<?= $quote_number ?>-quote-details-<?= date('Ymd-His') ?>.csv";
                                            document.body.appendChild(a);
                                            a.click();
                                            a.remove();
                                        })
                                        .catch(err => {
                                            alert("Failed to download CSV.");
                                            console.error(err);
                                        });
                                });
                            </script>
                        </div>
                        <button id="saveButton" name="submit_new_products" type="submit" style="display: none; margin-right: 10px;">Save</button>
                    </div>
                    <?php
                }
                ?>
            </form>
            <?php

            if(mysqli_num_rows($result_new_quote_check) > 0) {
                ?>
                <form id="main-quote-form" method="post" action="">
                    <table class="styled-table">
                        <tr>
                            <?php
                            if(!$edit_price && !$initial_path && $ref_quote_no == '') {
                                ?>
                                <th style="text-align: left;">
                                    <?php if ($title == 'admin' || $title == 'group' || $title == 'fit' || $title == 'sales') : ?>
                                        <button type="button" onclick="window.location.href='?opt=summary&quoteNumber=<?php echo $quote_number; ?>&edit=price'">Edit</button>
                                    <?php endif; ?>
                                </th>
                                <th></th>
                                <?php
                            }
                            else {
                                ?>
                                <th>No</th>
                                <th></th>
                                <?php
                            }
                            ?>
                            <th>Day</th>
                            <th>Travel Date</th>
                            <th>Type</th>
                            <?php
                            if($mode != 'group') {
                                echo '<th></th>';
                            }
                            ?>
                            <th style="text-align: left; width: 75%;">Item Name</th>
                            <th>Suggestion</th>
                            <?php if ($global_pricing_access == 1) : ?>
                                <th style="width: 10%;">Adult Price</th>
                                <th style="width: 10%;">Child Price</th>
                                <th style="width: 10%;">Infant Price</th>
                                <?php echo $pax_row;?>
                            <?php endif; ?>
                        </tr>
                        <?php
                        $count = 0;
                        $currentIndex = 0; 
                        $tdu_city_prev = '';
                        $first_hotel = false;
                        while ($row = mysqli_fetch_assoc($result)) {
                            $alt_vendor_background = "";
                            if($row['alt_vendor_count'] > 0) {
                                $alt_vendor_background = 'style="background-color: #f8d7da;"';
                                $hasMultipleVendorPending = true;
                            }
                            $productid = $row['productid'];
                            $hotel_days = 0;
                            $hotel_acc = 0;
                            $currentIndex += 1;
                            // if(false && $row['cf_928'] == 'Hotel' && !$edit_price) {
                            //     $hotel_acc += floatval($row['sale_price']);
                            //     while($nextRow = mysqli_fetch_assoc($result)) {
                            //         $nextProductId = $nextRow ? $nextRow['productid'] : null;
                            //         if($nextProductId && $nextProductId == $productid) {
                            //             $hotel_days += 1;
                            //             $currentIndex += 1;
                            //             $hotel_acc += floatval($nextRow['sale_price']);
                            //         }
                            //         else {
                            //             mysqli_data_seek($result, $currentIndex);
                            //             break;
                            //         }
                            //     }
                            // }
                            $quoteid = $row['quoteid'];
                            $sequence_no = $row['sequence_no'];
                            if (empty($sequence_no)) {
                                continue;
                            }
                            if ((int) $productid > 100000000) {
                                $sql_tdu_city = "SELECT city FROM tdu_products WHERE productid = $productid";
                                $result_tdu_city = mysqli_query($conn, $sql_tdu_city);
                            } else {
                                $sql_tdu_city = "SELECT cf_1248 FROM vtiger_productcf WHERE productid = $productid";
                                $result_tdu_city = mysqli_query($conn, $sql_tdu_city);
                            }
                            if($result_tdu_city && $row['cf_928'] != 'Hotel') {
                                $tdu_city = mysqli_fetch_assoc($result_tdu_city)['city'] ?? '';
                                if (trim($tdu_city) != '' && trim(strtolower($tdu_city_prev)) != trim(strtolower($tdu_city))) {
                                    echo '<tr><td colspan="2">' . $tdu_city . '</td></tr>';
                                    $tdu_city_prev = $tdu_city;
                                }
                            } 
                            // if(!$first_hotel && $row['cf_928'] == 'Hotel') {
                            //     $first_hotel = true;
                            //     echo '<tr><td colspan="2">Hotel</td></tr>';
                            // }
                            $count += 1;

                            $price_adjust_highlight = '';
                            if($initial_path && isset($row['price_adjust']) && $row['price_adjust'] != '') {
                                $price_adjust_highlight = 'style="background-color: lightyellow;"';
                            } 
                            if($row['cf_928'] == $_GET['cf_928']) {
                                $price_adjust_highlight = 'style="background-color: lightyellow;"';
                            } 
                            ?>
                            <tr id="product_row_<?php echo $sequence_no; ?>" <?= $alt_vendor_background ?> <?php echo $price_adjust_highlight; ?> 
                                <?php if ($edit_price) { ?> draggable="true" <?php } ?> 
                                ondragstart="<?php echo $edit_price ? 'handleDragStart(event)' : ''; ?>" 
                                ondragover="<?php echo $edit_price ? 'handleDragOver(event)' : ''; ?>" 
                                ondrop="<?php echo $edit_price ? 'handleDrop(event)' : ''; ?>">
                                <td>
                                    <?php if ($title != 'external') : ?>
                                        <?php echo $count; ?>
                                    <?php endif; ?>
                                </td>
                                <td style="width: 10%;">
                                    <?php if (!$initial_path && $title != 'external' && $ref_quote_no == '') { ?>
                                        <?php $display_order_row = $row['display_order']; ?>
                                        <button type="button" class="insert-product" data-insert-key="<?php echo htmlspecialchars($quoteid . '_' . $display_order_row . '_' . $sequence_no); ?>" style="background-color: green; color: white;"><i class="fa-solid fa-plus"></i></button>
                                        <button type="button" class="replace-product" data-replace-key="<?php echo htmlspecialchars($quoteid . '_' . $display_order_row . '_' . $sequence_no . '_' . $productid . '_' . $tdu_city_prev . '_' . $row['day']); ?>" style="background-color: orange; color: white;" <?= ($row['booking_status'] == 'Confirmation received') ? 'disabled' : '' ?>><i class="fa-solid fa-sync-alt"></i></button>
                                        <button type="button" class="delete-product" data-delete-key="<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no); ?>" style="background-color: red; color: white;" <?= ($row['booking_status'] == 'Confirmation received') ? 'disabled' : '' ?>><i class="fa-solid fa-trash-can"></i></button>
                                        <?php if ($row['booking_status'] == 'Confirmation received') : ?>
                                            <p style="color: green;">Confirmed <i class="fa-regular fa-circle-check"></i></p>
                                        <?php endif;?>
                                    <?php } ?>
                                </td>
                                <div id="sequencePopupForm_<?php echo $row['sequence_no']; ?>" class="popup">
                                    <div class="popup-content">
                                        <span class="close" data-sequence-no="<?php echo $row['sequence_no']; ?>">&times;</span>
                                        <form action="" method="post">
                                            <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($row['quoteid'] ?? ''); ?>">
                                            Move product: <?php echo htmlspecialchars($row['productname'] ?? ''); ?> before row 
                                            <input type="number" name="new_sequence_no" min="1" max="<?php echo mysqli_num_rows($result_new_quote_check2)+1; ?>" step="1"> 
                                            (Enter <?php echo mysqli_num_rows($result_new_quote_check2)+1; ?> if you want to move it to the last)
                                            <button type="submit" name="update_sequence_no" value="<?php echo htmlspecialchars($row['display_order']); ?>">Confirm</button>
                                        </form>
                                    </div>
                                </div>
                                <?php
                                
                                ?>
                                <td>
                                    <?php 
                                    if($row['cf_928'] != 'Hotel') {
                                        if ($edit_price) {
                                            // Make day editable as a number input field
                                            ?>
                                            <input type="number" name="day[<?= htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no); ?>]" 
                                                value="<?= htmlspecialchars($row['day']); ?>" min="1" step="1" class="day-input" 
                                                data-date-of-travel="<?= htmlspecialchars($date_of_travel); ?>" 
                                                data-cf928="<?= htmlspecialchars($row['cf_928']); ?>" 
                                                data-target="date-<?= htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no); ?>" required>
                                            <?php
                                        } else {
                                            if($row['cf_928'] == 'Hotel' && $hotel_days > 0) {
                                                echo htmlspecialchars($row['day']) . '-' . htmlspecialchars((int) $row['day'] + $hotel_days);
                                            } else {
                                                echo htmlspecialchars($row['day']);
                                            }
                                        }
                                    }
                                    ?>
                                </td>
                                <td id="date-<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no); ?>" style="width: 20%;">
                                    <?php 
                                    if(true || $row['cf_928'] != 'Hotel') {
                                        if($row['cf_928'] == 'Hotel') {
                                            $sql_checkin = "SELECT meta_value FROM vtiger_itinerary 
                                                            WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = 'check_in' AND meta_value != ''
                                                            ORDER BY created_at DESC 
                                                            LIMIT 1";
                                            $result_checkin = mysqli_query($conn, $sql_checkin);

                                            $sql_checkout = "SELECT meta_value FROM vtiger_itinerary 
                                                            WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = 'check_out' AND meta_value != ''
                                                            ORDER BY created_at DESC 
                                                            LIMIT 1";
                                            $result_checkout = mysqli_query($conn, $sql_checkout);

                                            if ($result_checkin && mysqli_num_rows($result_checkin) > 0 && $result_checkout && mysqli_num_rows($result_checkout) > 0) {
                                                $row_checkin = mysqli_fetch_assoc($result_checkin);
                                                $row_checkout = mysqli_fetch_assoc($result_checkout);
                                                echo 'Checkin:' . date('d-M-Y, l', strtotime($row_checkin['meta_value'])) . '<br>'; 
                                                echo 'Checkout:' . date('d-M-Y, l', strtotime($row_checkout['meta_value'])) . '<br>'; 
                                            } else {
                                                echo '<div style="background-color: red; padding: 10px; color: white;">Please edit in Operation->Hotel</div>';
                                                $hotel_to_edit = true;
                                            }
                                        } else {
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                $calculated_date = date('Y-m-d', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days'));
                                                
                                                $calculated_month = date('n', strtotime($calculated_date));
                                                $calculated_day = date('j', strtotime($calculated_date));
                                                $calculated_day_of_week = date('l', strtotime($calculated_date));
                                            
                                                $sql_check = "SELECT * FROM tdu_products_non_operation 
                                                              WHERE productid = '{$row['productid']}'
                                                              AND 
                                                              (
                                                                ((start_m * 100 + start_d) <= ($calculated_month * 100 + $calculated_day) AND (end_m * 100 + end_d) >= ($calculated_month * 100 + $calculated_day))
                                                                OR day_week = '$calculated_day_of_week'
                                                              )";
                                                $result_check = mysqli_query($conn, $sql_check);
                                            
                                                $warning_icon = "";
                                                if (mysqli_num_rows($result_check) > 0) {
                                                    $warning_icon = ' <i class="fa-solid fa-triangle-exclamation" style="color: red;" title="This date falls within a non-operation period."></i>';
                                                    $non_operation_product = true;
                                                }
                                            
                                                echo date('d-M-Y, l', strtotime($calculated_date)) . $warning_icon;
                                            } else {
                                                echo '-';
                                            }
                                        }
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php 
                                    echo htmlspecialchars($row['cf_928']); 
                                    if($row['cf_928'] == 'Hotel') {
                                        $hotel_num += 1;
                                    }
                                    if(false && $row['cf_928'] == 'Transfers' && in_array($row['day'], $qualifyingDays)) {
                                        echo '<i class="fa-solid fa-triangle-exclamation" style="color: red;" title="Activity Time exceed Private Transfers"></i>';
                                    }
                                    ?>
                                </td>
                                <?php
                                if($mode != 'group') {
                                    echo '<td style="width: 5%;"></td>';
                                }
                                ?>
                                <td style="text-align: left; font-size: 12px; width: 40%;">
                                    <?php
                                    if(isset($row['customised']) && $row['customised'] == 'true') {
                                        if(!isset($row['margin']) || (float) $row['margin'] <= 0) {
                                            ?>
                                            <div style='background-color: #ffd1d1; padding: 10px; border-radius: 5px;'>
                                                <h1>Pending Approval
                                                    <?php
                                                    if($title == 'admin') {
                                                        ?>
                                                        <button type='button' class='approve-btn' data-quoteid='<?= $quoteid ?>' data-seq='<?= $sequence_no ?>' style='background-color: #4CAF50; color: white; border: none; border-radius: 5px;'>
                                                            <i class='fa-solid fa-check'></i> Approve
                                                        </button>
                                                        <button type='button' class='deny-btn' data-quoteid='<?= $quoteid ?>' data-seq='<?= $sequence_no ?>' style='background-color: #f44336; color: white; border: none; border-radius: 5px;'>
                                                            <i class='fa-solid fa-xmark'></i> Deny
                                                        </button>
                                                        <?php
                                                    }
                                                    ?>
                                                </h1>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                    <p style="font-size: 16px;">
                                        <?php 
                                        if(isset($row['quantity']) && $adults_no + $children_no >= 50) {
                                            echo htmlspecialchars($row['quantity']) . ' x ';
                                        }
                                        echo htmlspecialchars($row['productname'] ?? ''); 
                                        if(isset($row['customised']) && $row['customised'] == 'true') {
                                            $has_customised = true;
                                            echo ' <i class="fa-solid fa-palette" title="customised product"></i>';
                                        }
                                        ?>
                                    </p>
                                    <strong style="font-size: 13px;"><?php echo htmlspecialchars($row['vendorname'] ?? ''); ?></strong>
                                    <?php if (($row['cf_928'] == 'Hotel' || $row['cf_928'] == 'Transfers') && $ref_quote_no == '') : ?>
                                        <button type="button" class="select-alt-vendor" 
                                                data-productid="<?php echo $row['productid']; ?>" data-vendorid="<?php echo $row['vendorid']; ?>" 
                                                data-cf_928="<?php echo $row['cf_928']; ?>" data-productname="<?php echo $row['productname']; ?>"
                                                data-quoteid="<?php echo $quoteid; ?>" data-sequence_no="<?php echo $row['sequence_no']; ?>">
                                            <i class="fa-solid fa-share-nodes"></i>
                                        </button>
                                    <?php endif ;?>
                                    <br>
                                    <p><?php echo htmlspecialchars($row['description'] ?? ''); ?></p>
                                    <?php 
                                    if ($edit_price) { 
                                        // Make comment editable as a textarea
                                        echo '<textarea name="comment[' . htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no) . ']" 
                                                style="width: 50%; height: 150px;" class="comment-text">' . htmlspecialchars($row['comment'] ?? '') . '</textarea>';
                                    } else { 
                                        echo '<p class="comment-text">' . nl2br(htmlspecialchars($row['comment'] ?? '')) . '</p>';
                                    } 
                                    ?>
                                </td>

                                <td>
                                    <?php if ($row['products_suggested_count'] > 0 && $ref_quote_no == '') : ?>
                                        <button type="button" style="width: 48px; height: 48px;" onclick="showSuggestedProductsIndividual(<?php echo $row['day']; ?>, <?php echo $row['display_order']; ?>, <?php echo $row['productid']; ?>)">
                                            <i class="fa-solid fa-lightbulb" style="font-size: 20px;"></i>
                                        </button>
                                    <?php endif ;?>
                                </td>

                                <?php if ($global_pricing_access == 1) : ?>
                                <?php
                                // pax range quote
                                if ($row['cf_928'] == 'Transfers' && $mode == 'group') {
                                    $sql_transfer = "SELECT subquoteid, pax_min, pax_max, sale_price
                                                      FROM vtiger_products_saleprice
                                                      WHERE quoteid='$quoteid' AND cf_928='Transfers' AND sequence_no ='$sequence_no' AND subquoteid > 1
                                                      ORDER BY pax_min ASC;";
                                    $result_transfer = mysqli_query($conn, $sql_transfer);
                                    $price = '<td></td><td></td><td></td>';
                                    while ($subrow = mysqli_fetch_assoc($result_transfer)) {
                                        $subquoteid = $subrow['subquoteid'];
                                        $highlight_pax_range_quote = '';
                                        if($subrow['pax_min'] <= $pax_no && $pax_no <= $subrow['pax_max']) {
                                            $highlight_pax_range_quote = 'style="background-color: lightyellow;"';
                                        }
                                        if ($edit_price) {
                                            $price .= '<td ' . $highlight_pax_range_quote . '><input type="number" name="sale_price[' . htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no . '_' . $subquoteid) . ']" 
                                                        step="0.01" min="0" value="' . number_format(floatval($subrow['sale_price']), 2, '.', '') . '" class="sale-price-input" required></td>';
                                        } else {
                                            $price .= '<td ' . $highlight_pax_range_quote . '><p>' . number_format(floatval($subrow['sale_price']), 2, '.', '') . '</p></td>';
                                        }
                                    }
                                    echo $price . '<td></td></tr>';
                                    continue;
                                } 
                                // standard quote
                                else {
                                    if ($edit_price) {  // edit price
                                        if ($row['cf_928'] == 'Transfers') {
                                            ?>
                                            <td>
                                                <input type="number" name="sale_price[<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no . '_0'); ?>]" 
                                                       step="0.01" min="0" value="<?php echo number_format(floatval($row['sale_price']), 2, '.', ''); ?>" class="sale-price-input" 
                                                       <?= (floatval($row['sale_price']) > 0.001 && $title != 'admin') ? ' readonly' : '' ?>
                                                       <?= floatval($row['sale_price']) > 0.001 ? '' : ' style="background-color: lightcoral;"' ?>
                                                <?php
                                                if($pax_no > 50) {
                                                    ?>
                                                    readOnly>
                                                    <button type="button" class="open-addCoach-modal" data-row-id="<?php echo $quoteid . '_' . $productid . '_' . $sequence_no; ?>">C</button>
                                                    <?php
                                                } else {
                                                    echo '>';
                                                }
                                                ?>
                                            </td>
                                            <?php
                                        }
                                        else {
                                            ?>
                                            <td>
                                                <input type="<?php echo $row['cf_928'] == 'Hotel' ? 'hidden': 'number' ?>" name="sale_price[<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no . '_1'); ?>]" 
                                                       step="0.01" min="0" value="<?php echo number_format(floatval($row['sale_price']), 2, '.', ''); ?>" class="sale-price-input" 
                                                       <?= (floatval($row['sale_price']) > 0.001 && $title != 'admin') ? ' readonly' : '' ?>
                                                       <?= floatval($row['sale_price']) > 0.001 ? '' : ' style="background-color: lightcoral;"' ?> required>
                                            </td>
                                            
                                            <?php
                                            if ($row['cf_928'] == 'Attraction' || $row['cf_928'] == 'Restaurant' || $row['cf_928'] == 'SIC' || $row['cf_928'] == 'Tour') {
                                                ?>
                                                <td>
                                                    <input type="number" name="sale_price_child[<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no . '_1'); ?>]" 
                                                            step="0.01" min="0" value="<?php echo number_format(floatval($row['sale_price_child']), 2, '.', ''); ?>" class="sale-price-child-input" 
                                                            <?= (floatval($row['sale_price_child']) > 0.001 && $title != 'admin') ? ' readonly' : '' ?>
                                                            <?= floatval($row['sale_price_child']) > 0.001 ? '' : ' style="background-color: lightcoral;"' ?> required>
                                                </td>
                                                <td>
                                                    <input type="number" name="sale_price_infant[<?php echo htmlspecialchars($quoteid . '_' . $productid . '_' . $sequence_no . '_1'); ?>]" 
                                                        step="0.01" min="0" value="<?php echo number_format(floatval($row['sale_price_infant']), 2, '.', ''); ?>" class="sale-price-infant-input" required>
                                                </td>
                                                <?php
                                            }
                                        }
                                    } else {    // display price
                                        ?>
                                        <td>
                                            <p>
                                                <?php
                                                // if($row['cf_928'] == 'Hotel' && $hotel_days > 0 && !$edit_price) {
                                                if($row['cf_928'] == 'Hotel') {
                                                    // echo number_format(floatval($hotel_acc), 2, '.', '');
                                                    echo '';
                                                }
                                                else {
                                                    if ($initial_path && isset($row['price_adjust']) && $row['price_adjust'] != '') {
                                                        $price_adjust_sign = '';
                                                        $price_adjust_value = floatval($row['price_adjust']);
                                                        
                                                        if ($price_adjust_value > 0) {
                                                            $price_adjust_sign = '+';
                                                            $color = 'green';
                                                        } else {
                                                            $color = 'red';
                                                        }
                                                        echo number_format(floatval($row['sale_price']) - $price_adjust_value, 2, '.', '');
                                                        
                                                        echo '<span style="color:' . $color . ';">' . $price_adjust_sign . number_format($price_adjust_value, 2, '.', '') . '</span>';
                                                        
                                                        echo '</p><p> = ' . number_format(floatval($row['sale_price']), 2, '.', '');
                                                        
                                                    } else {
                                                        echo number_format(floatval($row['sale_price']), 2, '.', '');

                                                        if (!$initial_path && $row['cf_928'] == 'Transfers' && strpos($row['keywords'], 'Self Drive') !== false) {
                                                            ?>
                                                            <button type="button" class="update-self-drive-btn" data-quoteid="<?php echo $quoteid; ?>" data-sequence-no="<?php echo $row['sequence_no']; ?>">
                                                                <i class="fa-solid fa-pen"></i>
                                                            </button>
                                                            <?php
                                                        }
                                                    }
                                                }
                                                ?>
                                            </p>
                                        </td>
                                        <td>
                                            <p>
                                            <?php 
                                            if ($row['cf_928'] == 'Attraction' || $row['cf_928'] == 'Restaurant' || $row['cf_928'] == 'SIC' || $row['cf_928'] == 'Tour') {
                                                if ($initial_path && isset($row['price_adjust']) && $row['price_adjust'] != '') {
                                                    $price_adjust_sign = '';
                                                    $price_adjust_value = floatval($row['price_adjust']);
                                                    
                                                    if ($price_adjust_value > 0) {
                                                        $price_adjust_sign = '+';
                                                        $color = 'green';
                                                    } else {
                                                        $color = 'red';
                                                    }

                                                    echo number_format(floatval($row['sale_price_child']) - $price_adjust_value, 2, '.', ''); 
                                                    echo '<span style="color:' . $color . ';">' . $price_adjust_sign . number_format($price_adjust_value, 2, '.', '') . '</span>';
                                                    echo '</p><p> = ' . number_format(floatval($row['sale_price_child']), 2, '.', '');
                                                } else {
                                                    echo number_format(floatval($row['sale_price_child']), 2, '.', '');
                                                }
                                            }
                                            ?>
                                            </p>
                                        </td>
                                        <td>
                                            <?php 
                                            if ($row['cf_928'] == 'Attraction' || $row['cf_928'] == 'Restaurant' || $row['cf_928'] == 'SIC' || $row['cf_928'] == 'Tour') {
                                                echo number_format(floatval($row['sale_price_infant']), 2, '.', ''); 
                                            }
                                            ?>
                                        </td>
                                        <?php
                                    }
                                }
                        
                                for ($i = 0; $i < $pax_row_num+1; $i++) {
                                    echo '<td></td>';
                                }
                                ?>
                                <?php endif; ?>
                            </tr>
                            <?php 
                        }

                        $sql_invoice_add_products = "SELECT * FROM vtiger_invoice_add_products WHERE quoteid='$quoteid';";
                        $result_invoice_add_products = mysqli_query($conn, $sql_invoice_add_products);
                        $adjust_total_amount = 0;
                        if(mysqli_num_rows($result_invoice_add_products) > 0) {
                            while ($row_invoice_add_products = mysqli_fetch_assoc($result_invoice_add_products)) {
                                $count += 1;
                                $price_field = (float) $row_invoice_add_products['price_field'];
                                $quantity = (int) $row_invoice_add_products['quantity'];
                                $adjust_total_amount += $price_field*$quantity;
                                ?>
                                <tr style="background-color: lightyellow;">
                                    <td><?php echo $count; ?></td>
                                    <td><i class="fa-solid fa-folder-plus" style="font-size: 24px;" title="Added after Invoice Generated"></i></td>
                                    <td><?php echo $row_invoice_add_products['day_field']; ?></td>
                                    <td>
                                        <?php 
                                        if (isset($date_of_travel) && $date_of_travel != '') {
                                            echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row_invoice_add_products['day_field']-1 . ' days')); 
                                        } else {
                                            echo '-';
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo $row_invoice_add_products['cf_928']; ?></td>
                                    <?php
                                    if($mode != 'group') {
                                        echo '<td style="width: 5%;"></td>';
                                    }
                                    ?>
                                    <td style="text-align: left; font-size: 12px; width: 40%;">
                                        <p style="font-size: 16px;">
                                            <?php 
                                            echo htmlspecialchars($row_invoice_add_products['product_field'] ?? ''); 
                                            ?>
                                        </p>
                                        <strong style="font-size: 13px;"><?php echo htmlspecialchars($row_invoice_add_products['vendor_field'] ?? ''); ?></strong><br>
                                    </td>
                                    <td style="color: green;">+<?php echo $row_invoice_add_products['price_field']; ?></td>
                                    <td colspan="4"></td>
                                </tr>
                                <?php
                            }
                        }
                        ?>
                        <script>
                            // Open the sequence_no popup
                            document.querySelectorAll('.open-sequence-popup').forEach(function(button) {
                                button.addEventListener('click', function() {
                                    var sequenceNo = button.getAttribute('data-sequence-no');
                                    document.getElementById('sequencePopupForm_' + sequenceNo).style.display = 'block';
                                });
                            });
                        
                            // Close the sequence_no popup
                            document.querySelectorAll('.close').forEach(function(closeButton) {
                                closeButton.addEventListener('click', function() {
                                    var sequenceNo = closeButton.getAttribute('data-sequence-no');
                                    document.getElementById('sequencePopupForm_' + sequenceNo).style.display = 'none';
                                });
                            });
                        
                            // Close popup when clicking outside
                            window.addEventListener('click', function(event) {
                                if (event.target.classList.contains('popup')) {
                                    event.target.style.display = 'none';
                                }
                            });
                        </script>
                    </table>
                    <?php 
                    if($quoteid_history == '') {
                        if($edit_price) {
                            echo '<button type="submit" style="margin:0 10px;" name="submit_sale_price">Save All</button>';
                            echo '<button type="button" onclick="confirmCancel2()">Cancel</button>';
                        }
                    }
                    ?>
                </form>

                <script>
                    document.getElementById('main-quote-form').addEventListener('submit', function (e) {
                        const dayInputs = Array.from(this.querySelectorAll('input.day-input'));

                        const dayValues = dayInputs.map(input => ({
                            value: parseInt(input.value, 10),
                            name: input.name
                        }));

                        for (let i = 1; i < dayValues.length; i++) {
                            if (dayValues[i].value < dayValues[i - 1].value) {
                                e.preventDefault();
                                alert("Day values must be in ascending order.");
                                this.querySelector(`[name="${dayValues[i].name}"]`).focus();
                                return false;
                            }
                        }
                    });
                </script>
                <?php
            } else if($mode != 'standard') {
                echo '<h1 style="text-align: center; margin-top: 20px;">Please add at least 1 CRM/CUSTOM Transfers products to allow adding Pax Range</h1><br>';
                echo '<h1 style="text-align: center;">Please create <a href="quote.php?opt=create-standard">New Standard Group Quote</a> if you do not need pax range</h1>';
            }
            ?>

            <!-- Alternative Vendors Modal -->
            <div id="altVendorModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background: #fff; border-radius: 8px; border: 1px solid #ccc; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2); padding: 20px; z-index: 1000; max-height: 80vh; overflow-y: auto;">
                <span id="closeModal" style="float: right; cursor: pointer; font-size: 20px; color: #555;">
                    <i class="fa-solid fa-xmark"></i>
                </span>

                <h3 style="margin-top: 0; color: #333; text-align: center; font-size: 20px;">Alternative Vendor</h3>
                <table id="altVendorTable" 
                    style="width: 100%; border-collapse: collapse; margin-top: 15px;">
                    <thead>
                        <tr style="background: #f5f5f5; border-bottom: 2px solid #ddd;">
                            <th style="padding: 10px; text-align: left;">Product</th>
                            <th style="padding: 10px; text-align: left;">Vendor</th>
                            <th style="padding: 10px; text-align: left;">Single Price</th>
                            <th style="padding: 10px; text-align: left;">Double Price</th>
                            <th style="padding: 10px; text-align: left;">Triple Price</th>
                            <th style="padding: 10px; text-align: left;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Vendor list will be appended here dynamically -->
                    </tbody>
                </table>
                <button type="button" id="addVendorCustomRow" style="margin: 10px;">+ Alternative Vendor</button>
            </div>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                let alt_vendor_sequence = 0;
                let alt_cf_928_sequence = '';

                $(document).ready(function() {
                    let quoteid = <?php echo json_encode($quoteid); ?>;

                    $("#addVendorCustomRow").click(function() {
                        let newRow = ""; // Declare variable before the condition

                        if (alt_cf_928_sequence == 'Transfers') {
                            newRow = `<tr>
                                        <td style='padding: 10px;'>
                                            <input type='hidden' class='productidcustom'>
                                            <input type='hidden' class='productnamecustom' style='width: 80%;'>
                                        </td>
                                        <td style='padding: 10px;'>
                                            <input type='hidden' class='vendoridcustom'>
                                            <input type='text' class='vendornamecustom' style='width: 80%;'>
                                            <button type='button' class='searchVendor'><i class='fa-solid fa-magnifying-glass'></i></button>
                                            <div class='vendorSearchBox' style='display: none; margin-top: 10px; z-index: 1000;'>
                                                <input type='text' class='vendorSearchInput' style='width: 80%;' placeholder='Search vendor...'>
                                                <ul class='vendorSearchResults' style='list-style: none; padding: 0; margin: 0; max-height: 150px; overflow-y: auto;'></ul>
                                            </div>
                                        </td>
                                        <td style='padding: 10px;'><input type='number' class='price1' style='width: 100%;'></td>
                                        <td style='padding: 10px;'><input type='hidden' class='price2' style='width: 100%;'></td>
                                        <td style='padding: 10px;'><input type='hidden' class='price3' style='width: 100%;'></td>
                                        <td style='text-align: center; padding: 10px;'>
                                            <button type='button' class='saveVendorCustom'>+</button>
                                        </td>
                                    </tr>
                                    <tr><td></td><td style="color: red;">*Please use the <i class="fa-solid fa-magnifying-glass"></i> button if you want to add product in Dashboard</td></tr>`;
                        } else {
                            newRow = `<tr>
                                        <td style='padding: 10px;'>
                                            <input type='hidden' class='productidcustom'>
                                            <input type='text' class='productnamecustom' style='width: 80%;'>
                                            <button type='button' class='searchProduct'><i class='fa-solid fa-magnifying-glass'></i></button>
                                            <div class='productSearchBox' style='display: none; margin-top: 10px; z-index: 1000;'>
                                                <input type='text' class='productSearchInput' style='width: 80%;' placeholder='Search product...'>
                                                <ul class='productSearchResults' style='list-style: none; padding: 0; margin: 0; max-height: 150px; overflow-y: auto;'></ul>
                                            </div>
                                        </td>
                                        <td style='padding: 10px;'>
                                            <input type='hidden' class='vendoridcustom'>
                                            <input type='text' class='vendornamecustom' style='width: 80%;'>
                                            <button type='button' class='searchVendor'><i class='fa-solid fa-magnifying-glass'></i></button>
                                            <div class='vendorSearchBox' style='display: none; margin-top: 10px; z-index: 1000;'>
                                                <input type='text' class='vendorSearchInput' style='width: 80%;' placeholder='Search vendor...'>
                                                <ul class='vendorSearchResults' style='list-style: none; padding: 0; margin: 0; max-height: 150px; overflow-y: auto;'></ul>
                                            </div>
                                        </td>
                                        <td style='padding: 10px;'><input type='number' class='price1' style='width: 100%;'></td>
                                        <td style='padding: 10px;'><input type='number' class='price2' style='width: 100%;'></td>
                                        <td style='padding: 10px;'><input type='number' class='price3' style='width: 100%;'></td>
                                        <td style='text-align: center; padding: 10px;'>
                                            <button type='button' class='saveVendorCustom'>+</button>
                                        </td>
                                    </tr>
                                    <tr><td></td><td style="color: red;">*Please use the <i class="fa-solid fa-magnifying-glass"></i> button if you want to add product in Dashboard</td></tr>`;
                        }

                        $("#altVendorTable tbody").append(newRow);
                        document.getElementById('addVendorCustomRow').style.display = 'none';
                    });

                    $(document).on("click", ".searchProduct", function() {
                        let searchBox = $(this).siblings(".productSearchBox");
                        searchBox.toggle();
                    });

                    $(document).on("keyup", ".productSearchInput", function() {
                        let query = $(this).val();
                        let resultBox = $(this).siblings(".productSearchResults");

                        if (query.length > 1) {
                            $.ajax({
                                url: "ajax_search_products.php",
                                type: "GET",
                                data: { query: query },
                                success: function(response) {
                                    let products = JSON.parse(response);
                                    let html = "";
                                    products.forEach(product => {
                                        html += `<li data-id="${product.productid}" data-name="${product.productName}" style='padding: 5px; cursor: pointer;'>${product.productName}</li>`;
                                    });
                                    resultBox.html(html);
                                }
                            });
                        } else {
                            resultBox.html("");
                        }
                    });

                    $(document).on("click", ".productSearchResults li", function() {
                        let productName = $(this).data("name");
                        let productId = $(this).data("id");
                        let row = $(this).closest("td");
                        
                        row.find(".productnamecustom").val(productName).prop("readonly", true);
                        row.find(".productidcustom").val(productId);
                        row.find(".productSearchBox").hide();
                    });

                    $(document).on("click", ".searchVendor", function() {
                        let searchBox = $(this).siblings(".vendorSearchBox");
                        searchBox.toggle();
                    });

                    $(document).on("keyup", ".vendorSearchInput", function() {
                        let query = $(this).val();
                        let resultBox = $(this).siblings(".vendorSearchResults");

                        if (query.length > 1) {
                            $.ajax({
                                url: "ajax_search_vendors.php",
                                type: "GET",
                                data: { query: query },
                                success: function(response) {
                                    let vendors = JSON.parse(response);
                                    let html = "";
                                    vendors.forEach(vendor => {
                                        html += `<li data-id="${vendor.vendorid}" data-name="${vendor.vendorName}" style='padding: 5px; cursor: pointer;'>${vendor.vendorName}</li>`;
                                    });
                                    resultBox.html(html);
                                }
                            });
                        } else {
                            resultBox.html("");
                        }
                    });

                    $(document).on("click", ".vendorSearchResults li", function() {
                        let vendorName = $(this).data("name");
                        let vendorId = $(this).data("id");
                        let row = $(this).closest("td");
                        
                        row.find(".vendornamecustom").val(vendorName).prop("readonly", true);
                        row.find(".vendoridcustom").val(vendorId);
                        row.find(".vendorSearchBox").hide();
                    });

                    $(document).on("click", ".saveVendorCustom", function() {
                        let row = $(this).closest("tr");
                        let data = {
                            quoteid: quoteid,
                            sequence_no: alt_vendor_sequence,
                            productid: row.find(".productidcustom").val(),
                            productnamecustom: row.find(".productnamecustom").val(),
                            vendorid: row.find(".vendoridcustom").val(),
                            vendornamecustom: row.find(".vendornamecustom").val(),
                            cf_928: alt_cf_928_sequence,
                            price1: row.find(".price1").val(),
                            price2: row.find(".price2").val(),
                            price3: row.find(".price3").val()
                        };

                        $.ajax({
                            url: "ajax_save_alt_custom_vendor.php",
                            type: "POST",
                            data: data,
                            success: function(response) {
                                alert("Vendor saved successfully!");
                                document.getElementById('altVendorModal').style.display = 'none';
                            },
                            error: function() {
                                alert("Error saving vendor.");
                            }
                        });
                    });

                    $(document).on("click", function(event) {
                        if (!$(event.target).closest(".productSearchBox, .searchProduct, .vendorSearchBox, .searchVendor").length) {
                            $(".productSearchBox, .vendorSearchBox").hide();
                        }
                    });
                });
            </script>
            <script>
                $(document).on('click', '.reject-all-alt-btn', function () {
                    const quoteId = $(this).data('quoteid');
                    const sequenceNo = $(this).data('sequence_no');

                    $.ajax({
                        url: 'ajax_reject_all_alt_vendor.php',
                        type: 'POST',
                        data: {
                            quoteid: quoteId,
                            sequence_no: sequenceNo
                        },
                        success: function (response) {
                            alert('Successfully rejected all items.');
                            location.reload();
                        },
                        error: function (xhr, status, error) {
                            alert('An error occurred. Please try again.');
                            console.error(error);
                        }
                    });
                });
            </script>
            <script>
                $(document).ready(function() {
                    $(".select-alt-vendor").click(function() {
                        let quoteid = $(this).data("quoteid");
                        let sequence_no = $(this).data("sequence_no");
                        alt_vendor_sequence = sequence_no;
                        alt_cf_928_sequence = $(this).data("cf_928");

                        $("#altVendorModal").show();
                        $("#addVendorCustomRow").show();

                        $.ajax({
                            url: "ajax_fetch_alt_product_vendors.php",
                            type: "POST",
                            data: { quoteid: quoteid, sequence_no: sequence_no },
                            success: function(response) {
                                $("#altVendorTable tbody").html(response);
                            }
                        });
                    });

                    $("#closeModal").click(function() {
                        document.getElementById('addVendorCustomRow').style.display = 'block';
                        $("#altVendorModal").hide();
                    });

                    $(document).ready(function() {
                        // Approve Button Click Handler
                        $(document).on("click", ".save-alt-price-btn", function() {
                            let button = $(this);
                            let tpavid = button.data("tpavid");

                            $.ajax({
                                url: "ajax_approve_alt_product_vendors.php",
                                type: "POST",
                                data: { tpavid: tpavid },
                                success: function(response) {
                                    if (response.trim() === "success") {
                                        alert("Vendor price approved successfully!");
                                        location.reload();
                                    } else {
                                        alert("Approval failed: " + response);
                                    }
                                }
                            });
                        });
                    });

                    $(document).ready(function() {
                        // Approve Button Click Handler
                        $(document).on("click", ".revert-alt-price-btn", function() {
                            let button = $(this);
                            let tpavid = button.data("tpavid");

                            $.ajax({
                                url: "ajax_void_alt_product_vendors.php",
                                type: "POST",
                                data: { tpavid: tpavid },
                                success: function(response) {
                                    if (response.trim() === "success") {
                                        alert("Vendor price void successfully!");
                                        $("#altVendorModal").hide();
                                    } else {
                                        alert("Void failed " + response);
                                    }
                                }
                            });
                        });
                    });
                });
            </script>
            <?php endif; ?>
        </div>
        <script>
            let draggedRow;

            function handleDragStart(event) {
                draggedRow = event.target;
                event.dataTransfer.effectAllowed = 'move';
                event.target.style.opacity = '0.5'; // Visual feedback for the dragged row
            }

            function handleDragOver(event) {
                event.preventDefault(); // Necessary for the drop event to fire
                event.dataTransfer.dropEffect = 'move'; // Visual feedback

                // Auto-scroll functionality
                const scrollThreshold = 50;
                const scrollSpeed = 20;

                if (event.clientY < scrollThreshold) {
                    window.scrollBy(0, -scrollSpeed);
                } else if (window.innerHeight - event.clientY < scrollThreshold) {
                    window.scrollBy(0, scrollSpeed);
                }
            }

            function handleDrop(event) {
                event.preventDefault();
                if (draggedRow && draggedRow !== event.target.closest('tr')) {
                    const targetRow = event.target.closest('tr');
                    const tbody = targetRow.parentNode;

                    // Get the bounding box of the target row
                    const rect = targetRow.getBoundingClientRect();
                    const offsetY = event.clientY - rect.top; // Mouse Y position relative to the row

                    // If the user drops near the top of the row, insert before; otherwise, insert after
                    if (offsetY < rect.height / 2) {
                        tbody.insertBefore(draggedRow, targetRow);
                    } else {
                        tbody.insertBefore(draggedRow, targetRow.nextSibling);
                    }

                    // Reset opacity after drop
                    draggedRow.style.opacity = '1';
                }
            }

            document.addEventListener('DOMContentLoaded', function () {
                document.querySelectorAll('tr[draggable="true"]').forEach(row => {
                    row.addEventListener('dragstart', handleDragStart);
                    row.addEventListener('dragover', handleDragOver);
                    row.addEventListener('drop', handleDrop);
                });

                document.querySelectorAll('.delete-product').forEach(button => {
                    button.addEventListener('click', function () {
                        if (confirm('Are you sure you want to delete this product?')) {
                            const deleteKey = this.dataset.deleteKey;
                            const rowId = `product_row_${deleteKey.split('_')[2]}`; // Assuming sequence_no is unique in deleteKey
                            
                            fetch('ajax_delete_product_row.php', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                body: JSON.stringify({ delete_key: deleteKey })
                            })
                            .then(response => response.json())
                            .then(data => {
                                if (data.success) {
                                    document.getElementById(rowId).remove();
                                } else {
                                    alert('Failed to delete the product.');
                                }
                            })
                            .catch(error => console.error('Error:', error));
                        }
                    });
                });
            });
        </script>
        <style>
            tr[draggable="true"] {
                cursor: grab;
            }

            tr[draggable="true"]:active {
                cursor: grabbing;
                opacity: 0.5;
            }
        </style>
        <div id="modal-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 99;"></div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <style>
            #modal-table-associated input[type="text"], #modal-table-associated select {
                width: 100%;
                height: 30px;
                margin: 0;
            }
        </style>
        <!-- script to approve/deny custom products -->
        <script>
            $(document).ready(function() {
                // Approve button click handler
                $('.approve-btn').on('click', function() {
                    const quoteId = $(this).data('quoteid');
                    const sequenceNo = $(this).data('seq');
                    
                    $.ajax({
                        url: 'ajax_update_margin.php', // Path to your PHP script
                        type: 'POST',
                        data: {
                            quoteid: quoteId,
                            sequence_no: sequenceNo,
                            action: 'approve'
                        },
                        success: function(response) {
                            alert(response); // Handle the response
                            location.reload();
                        },
                        error: function() {
                            alert('Error processing request.');
                        }
                    });
                });

                // Deny button click handler
                $('.deny-btn').on('click', function() {
                    const quoteId = $(this).data('quoteid');
                    const sequenceNo = $(this).data('seq');
                    
                    $.ajax({
                        url: 'ajax_update_margin.php',
                        type: 'POST',
                        data: {
                            quoteid: quoteId,
                            sequence_no: sequenceNo,
                            action: 'deny'
                        },
                        success: function(response) {
                            alert(response); // Handle the response
                            location.reload();
                        },
                        error: function() {
                            alert('Error processing request.');
                        }
                    });
                });
            });
        </script>
        <div id="associated-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 100; max-height: 90vh; overflow-y: auto;">
            <div id="modal-content">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <h2>Add Products</h2>
                    <button id="close-modal-associated" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
                </div>
                <div style="margin: 20px 0;">
                    City: 
                    <select id="filter-city" name="city" style="width: 100px;">
                        <option value="">SELECT</option>
                        <?php
                        $sql = "SELECT DISTINCT TRIM(city) AS city FROM tdu_products WHERE city IS NOT NULL AND city != '' AND country = '$country' GROUP BY city ORDER BY COUNT(city) DESC";
                        $result = $conn->query($sql);
                        while ($row = $result->fetch_assoc()) {
                            echo '<option value="' . htmlspecialchars($row['city']) . '">' . htmlspecialchars($row['city']) . '</option>';
                        }
                        ?>
                    </select> 
                    Day: 
                    <input type="number" min="1" step="1" id="filter-day" style="width: 50px; height: 30px;" value="1">
                    Date: 
                    <input type="date" id="filter-date" style="width: 150px; height: 30px;" value="<?php echo htmlspecialchars($date_of_travel); ?>" min="<?php echo htmlspecialchars($date_of_travel); ?>">
                </div>

                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const dayInput = document.getElementById('filter-day');
                        const dateInput = document.getElementById('filter-date');

                        // Default base date
                        const baseDate = new Date('<?php echo htmlspecialchars($date_of_travel); ?>');

                        // Synchronize day with date based on $date_of_travel
                        dayInput.addEventListener('input', function () {
                            const dayOffset = parseInt(dayInput.value, 10) - 1; // Day 1 corresponds to baseDate
                            const updatedDate = new Date(baseDate);
                            updatedDate.setDate(baseDate.getDate() + dayOffset);
                            dateInput.value = updatedDate.toISOString().split('T')[0];
                        });

                        // Synchronize date with day
                        dateInput.addEventListener('change', function () {
                            const selectedDate = new Date(dateInput.value);
                            const dayOffset = Math.ceil((selectedDate - baseDate) / (1000 * 60 * 60 * 24)) + 1;
                            dayInput.value = dayOffset;
                        });
                    });
                </script>
                <div style="display: flex; gap: 10px; margin: 20px 0;">
                    <button type="button" class="category-filter-btn" data-category="Attraction" style="background-color: #5bc0de;">Attraction</button>
                    <button type="button" class="category-filter-btn" data-category="Hotel">Hotel</button>
                    <button type="button" class="category-filter-btn" data-category="Restaurant">Restaurant</button>
                    <button type="button" class="category-filter-btn" data-category="Tour">Tour</button>
                    <button type="button" class="category-filter-btn" data-category="Transfers">Transfers</button>
                    <button type="button" class="category-filter-btn" data-category="SIC">SIC</button>
                    <button type="button" class="category-filter-btn" data-category="Guide">Guide</button>
                </div>

                <div style="display: flex;">
                    <div style="flex: 1; margin-right: 20px;">
                        <table style="width: 100%;">
                            <tr>
                                <td><br><br>Product Name:</td>
                            </tr>
                            <tr>
                                <td><input type="text" id="filter-productname" name="productname" style="width: 100%; height: 30px;"></td>
                            </tr>
                            <tr>
                                <td><br><br>Vendor Name:</td>
                            </tr>
                            <tr>
                                <td><input type="text" id="filter-vendorname" name="vendorname" style="width: 100%; height: 30px;"></td>
                            </tr>
                            <tr>
                                <div id="seat-filters" style="margin: 20px 0; padding: 10px; display: none; gap: 10px; flex-wrap: wrap; border: 1px solid #000;">
                                    <!-- Content will be populated via AJAX -->
                                </div>
                                <div id="keyword-filters" style="margin: 20px 0; padding: 10px; display: flex; gap: 10px; flex-wrap: wrap; border: 1px solid #000;">
                                    <!-- Keywords will be dynamically populated here -->
                                </div>
                            </tr>
                            <tr>
                                <td>
                                    <br><br>
                                    <label><input type="checkbox" id="filter-preferred"> <i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i> Preferred</label>
                                    <br><br><br>
                                    <label><input type="checkbox" id="filter-featured"> <i class="fa-solid fa-fire" style="color: red;" title="Popular"></i> Popular</label>
                                    <br><br><br>
                                </td>
                            </tr>
                            <tr>
                                <td><button type="button" id="apply-filters" style="padding: 5px 10px; width: 100%;">Search</button></td>
                            </tr>
                        </table>
                    </div>

                    <div style="flex: 5;">
                        <table id="modal-table-associated" class="styled-table" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th style="text-align: left;">Product Name</th>
                                    <th style="text-align: left;">Vendor Name</th>
                                    <th style="text-align: left;"></th>
                                </tr>
                            </thead>
                            <tbody id="added-products-table">
                                <!-- Content will be populated via AJAX -->
                            </tbody>
                            <tbody id="associated-products-table">
                                <!-- Content will be populated via AJAX -->
                            </tbody>
                            <tr>
                                <td colspan="3">
                                    <button id="load-more" style="padding: 10px; display: none; margin: auto;">Load More</button>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- Show add tdu product modal -->
        <script>
            // Show the modal
            let insert_sequence = 0;
            let replace_sequence = 0;
            let replace_productid = 0;
            let replace_from_operation = 0;
            let replace_from_operation_checkin = '';
            let replace_from_operation_checkout = '';
            document.getElementById('add-product-btn').addEventListener('click', function () {
                // Display the modal and overlay
                document.getElementById('associated-modal').style.display = 'block';
                document.getElementById('modal-overlay').style.display = 'block';

                // fetchAddedProducts();
                // fetchFilteredData();
            });

            document.querySelectorAll('.insert-product').forEach(button => {
                button.addEventListener('click', function () {
                    let dataKey = this.getAttribute('data-insert-key'); 
                    let keyParts = dataKey.split('_');
                    
                    if (keyParts.length === 3) {
                        insert_sequence = keyParts[1]; 
                        document.getElementById('associated-modal').style.display = 'block';
                        document.getElementById('modal-overlay').style.display = 'block';
                    }
                });
            });

            document.querySelectorAll('.replace-product').forEach(button => {
                button.addEventListener('click', function () {
                    let dataKey = this.getAttribute('data-replace-key'); 
                    let keyParts = dataKey.split('_');
                    
                    if (keyParts.length === 6) {
                        insert_sequence = keyParts[1]; 
                        replace_sequence = keyParts[2]; 
                        replace_productid = keyParts[3];
                        document.getElementById('filter-city').value = keyParts[4];
                        document.getElementById('filter-day').value = keyParts[5];
                        document.getElementById('associated-modal').style.display = 'block';
                        document.getElementById('modal-overlay').style.display = 'block';

                        fetchAddedProducts();
                        fetchFilteredData();
                    }
                });
            });

            // Close the modal
            document.getElementById('close-modal-associated').addEventListener('click', function () {
                document.getElementById('associated-modal').style.display = 'none';
                document.getElementById('modal-overlay').style.display = 'none';

                const currentUrl = new URL(window.location.href);
                window.location.href = currentUrl;
            });
        </script>
        <!-- TDU products filter -->
        <script>
            let currentPage = 1;
            let selectedCategory = 'Attraction';
            let selectedKeyword = '';
            let selectedDay = '';
            let selectedSeat = '';

            <?php
            if (substr($quote_number, -1) === 'G') {
                ?>
                let seatLimit = 0;
                <?php
            } else {
                ?>
                let seatLimit = 48;
                <?php
            }
            ?>

            // Handle keyword button click
            document.querySelectorAll('.keyword-filter-btn').forEach(button => {
                button.addEventListener('click', function () {
                    selectedKeyword = this.dataset.keyword;
                    fetchFilteredData();
                    if(selectedCategory == 'Transfers') {
                        fetchFilteredSeats();
                    }
                });
            });

            // Handle button click to set category filter
            document.querySelectorAll('.category-filter-btn').forEach(button => {
                button.addEventListener('click', function () {
                    handleCategoryClick(this);
                });
            });

            function handleCategoryClick(button) {
                selectedCategory = button.dataset.category;
                selectedKeyword = '';
                selectedSeat = '';

                toggleSeatFilters(selectedCategory);
                const city = document.getElementById('filter-city').value;

                fetchKeywords(selectedCategory, city);

                highlightSelectedButton(button, '.category-filter-btn');

                fetchAddedProducts();
                fetchFilteredData();

                if (selectedCategory === 'Transfers') {
                    fetchFilteredSeats();
                }
            }

            function toggleSeatFilters(category) {
                const seatFilters = document.getElementById('seat-filters');
                seatFilters.style.display = category === 'Transfers' ? 'flex' : 'none';
            }

            function fetchKeywords(category, city) {
                fetch(`ajax_fetch_keywords.php?category=${encodeURIComponent(category)}&city=${encodeURIComponent(city)}`)
                    .then(response => response.json())
                    .then(keywords => {
                        updateKeywordFilters(keywords);
                    })
                    .catch(error => console.error('Error fetching keywords:', error));
            }

            function updateKeywordFilters(keywords) {
                const keywordFilters = document.getElementById('keyword-filters');
                keywordFilters.innerHTML = '';

                if (keywords.length > 0) {
                    const select = document.createElement('select');
                    select.className = 'keyword-filter-select';
                    select.style.margin = '0';
                    select.style.width = '100%';

                    // Default option
                    const defaultOption = document.createElement('option');
                    defaultOption.value = '';
                    defaultOption.textContent = 'Select a keyword';
                    select.appendChild(defaultOption);

                    keywords.forEach(keyword => {
                        const option = document.createElement('option');
                        option.value = keyword;
                        option.textContent = keyword;
                        select.appendChild(option);
                    });

                    select.addEventListener('change', function () {
                        handleKeywordClick(this.value);
                    });

                    keywordFilters.appendChild(select);
                } else {
                    keywordFilters.innerHTML = '<p>No keywords available for this category.</p>';
                }
            }

            function handleKeywordClick(selectedValue) {
                selectedKeyword = selectedValue;
                fetchFilteredData();

                setTimeout(() => {
                    // After data is fetched, update the dropdown selection
                    const selectElement = document.querySelector(".keyword-filter-select");
                    if (selectElement) {
                        selectElement.value = selectedKeyword; // Set the selected value
                    }
                }, 500);
            }

            function highlightSelectedButton(button, selector) {
                document.querySelectorAll(selector).forEach(btn => btn.style.background = '');
                button.style.background = '#5bc0de';
            }

            // Update fetchFilteredData function to include the keyword parameter
            function fetchFilteredData(loadMore = false) {
                const productid = '<?php echo $productid; ?>';
                const quoteid = '<?php echo $quoteid; ?>';
                const country = '<?php echo $country; ?>';
                const productname = document.getElementById('filter-productname').value;
                const vendorname = document.getElementById('filter-vendorname').value;
                const daynum = document.getElementById('filter-day').value;
                const city = document.getElementById('filter-city').value;

                fetchKeywords(selectedCategory, city);

                // Checkbox values
                const preferred = document.getElementById('filter-preferred').checked ? 1 : 0;
                const featured = document.getElementById('filter-featured').checked ? 1 : 0;

                // Increment or reset page count
                if (loadMore) {
                    currentPage++;
                } else {
                    currentPage = 1;
                }
                const params = new URLSearchParams({ quoteid, daynum, productname, vendorname, city, country, productid, category: selectedCategory, 
                                                        keyword: selectedKeyword, seats: selectedSeat, preferred, featured, page: currentPage });

                fetch('ajax_fetch_tdu_products.php?' + params.toString())
                    .then(response => response.text())
                    .then(data => {
                        const tableBody = document.querySelector('#associated-products-table');

                        if (loadMore) {
                            tableBody.insertAdjacentHTML('beforeend', data); // Append data for Load More
                        } else {
                            tableBody.innerHTML = data; // Replace data for initial load
                        }

                        // Show or hide "Load More" button based on response content
                        const loadMoreButton = document.getElementById('load-more');
                        if (data.trim() === '' || data.includes('No More records')) {
                            loadMoreButton.style.display = 'none'; // Hide if no more data
                        } else {
                            loadMoreButton.style.display = 'block'; // Show if more data is available
                        }
                    })
                    .catch(error => console.error('Error fetching data:', error));
            }

            function fetchAddedProducts() {
                const quoteid = '<?php echo $quoteid; ?>';
                const daynum = document.getElementById('filter-day').value;

                fetch(`ajax_fetch_added_products.php?quoteid=${quoteid}&daynum=${daynum}&category=${encodeURIComponent(selectedCategory)}`)
                    .then(response => response.text())
                    .then(data => {
                        const tableBody = document.querySelector('#added-products-table');
                        tableBody.innerHTML = data;
                    })
                    .catch(error => console.error('Error fetching added products:', error));
            }

            function fetchFilteredSeats() {
                const country = '<?php echo $country; ?>';
                const pax_no_seat = parseInt('<?php echo (int) $adults_no + (int) $children_no; ?>', 10);
                const productname = document.getElementById('filter-productname').value;
                const vendorname = document.getElementById('filter-vendorname').value;
                const city = document.getElementById('filter-city').value;

                const params = new URLSearchParams({
                    country,
                    pax_no_seat,
                    productname,
                    vendorname,
                    city,
                    seatLimit
                });

                fetch('ajax_fetch_seats.php?' + params.toString())
                    .then(response => response.text())
                    .then(data => {
                        const seatFiltersDiv = document.getElementById('seat-filters');
                        seatFiltersDiv.innerHTML = data; // Populate seat buttons dynamically
                        seatFiltersDiv.style.display = 'flex'; // Show seat filters

                        // Attach event listeners to the dynamically created buttons
                        document.querySelectorAll('.seat-filter-btn').forEach(button => {
                            button.addEventListener('click', function () {
                                selectedSeat = this.dataset.seat;

                                // Call your filtering function or logic here
                                fetchFilteredData();
                            });
                        });
                    })
                    .catch(error => console.error('Error fetching seat filters:', error));
            }

            // Event listener for "Load More" button
            document.getElementById('load-more').addEventListener('click', function () {
                fetchFilteredData(true);
            });

            // Apply filters
            document.getElementById('apply-filters').addEventListener('click', function () {
                fetchFilteredData();
                if(selectedCategory == 'Transfers') {
                    fetchFilteredSeats();
                }
            });

            function applyFilters() {
                fetchAddedProducts();
                fetchFilteredData();
                
                if (selectedCategory === 'Transfers') {
                    fetchFilteredSeats();
                }

                const daynum = document.getElementById('filter-day').value;
                // alert('Switch to Day ' + daynum);
            }

            // Add event listeners to trigger the function when any of the input fields change
            document.getElementById('filter-city').addEventListener('change', applyFilters);
            document.getElementById('filter-day').addEventListener('input', applyFilters);
            document.getElementById('filter-date').addEventListener('change', applyFilters);
        </script>
        <!-- Add TDU products to quote -->
        <script>
            $(document).on('click', '.associate-btn', function () {
                const productid = $(this).data('productid');
                const quoteid = '<?php echo $quoteid; ?>';
                const row = $(this).closest('tr');

                // Retrieve the inputs for the current row
                const dayInput = $(`#day-${productid}`);
                const nightsInput = $(`#nights-${productid}`);

                let day = '';
                let nights = '';

                const daynum = document.getElementById('filter-day').value;
                // Determine which fields to use based on their existence
                if (dayInput.length) {
                    day = dayInput.val();
                    selectedDay = day;
                    if (!day) {
                        alert('Day is required!');
                        return;
                    }
                } else if (nightsInput.length) {
                    nights = nightsInput.val();
                    if (!nights || nights <= 0) {
                        alert('Number of nights is required and must be greater than 0');
                        return;
                    }
                } else {
                    alert('Unable to retrieve the required inputs.');
                    return;
                }

                // AJAX request
                $.ajax({
                    url: 'ajax_quote_products.php',
                    method: 'POST',
                    data: { 
                        quoteid: quoteid, 
                        productid: productid, 
                        day: daynum, 
                        nights: nights,
                        checkin: daynum,
                        category: selectedCategory,
                        insert_sequence: insert_sequence,
                        replace_sequence: replace_sequence,
                        replace_productid: replace_productid,
                        replace_from_operation: replace_from_operation,
                        replace_from_operation_checkin: replace_from_operation_checkin,
                        replace_from_operation_checkout: replace_from_operation_checkout
                    },
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.status === 'success') {
                            fetchLinkedProducts(quoteid, productid);
                            fetchSuggestedProducts(productid);

                            if(replace_from_operation > 0) {
                                alert('Product has been replaced');
                                let url = new URL(window.location.href);
                                url.searchParams.set("edit", "div-hotel");
                                window.location.href = url.toString();
                            }
                            else if(insert_sequence > 0) {
                                alert('Product has been inserted');
                                location.reload();
                            }
                        } else {
                            alert(result.message || 'Failed to add the product.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while adding the product.');
                    }
                });
            });

            function fetchLinkedProducts(quoteid, productid) {
                $.ajax({
                    url: 'ajax_get_linked_products.php',
                    method: 'POST',
                    data: { quoteid: quoteid, productid: productid },
                    success: function (response) {
                        try {
                            const result = JSON.parse(response);

                            if (result.status === 'success') {
                                let modalBody = '';
                                if (Array.isArray(result.products)) {
                                    if (result.products.length > 0) {
                                        modalBody += '<h4>Associated products below will be automatically added to the quote</h4>';
                                        result.products.forEach(product => {
                                            modalBody += `
                                                <div class="product-card" style="border: 1px solid #ccc; padding: 10px; margin: 10px 0; border-radius: 8px; cursor: pointer;" data-productid="${product.productid}">
                                                    <h5>${product.productName}</h5>
                                                    <p>Vendor: ${product.vendorName}</p>
                                                </div>
                                            `;
                                        });
                                    } else {
                                        modalBody = '';
                                    }
                                } else {
                                    modalBody = '<p>Error: No product data returned.</p>';
                                }

                                $('#linkedProductsModal .modal-body').html(modalBody); // Update the modal ID
                                $('#linkedProductsModal').css('display', 'block'); // Ensure the modal ID matches
                            } else {
                                alert(result.message || 'Failed to fetch linked products.');
                            }
                        } catch (e) {
                            console.error('Error parsing response:', e);
                            alert('An error occurred while processing the response.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while fetching linked products.');
                    }
                });
            }

            // Function to fetch and display suggested products
            function fetchSuggestedProducts(productid) {
                $.ajax({
                    url: 'ajax_get_suggested_products.php',
                    method: 'POST',
                    data: { productid: productid },
                    success: function (response) {
                        try {
                            const result = JSON.parse(response);

                            if (result.status === 'success') {
                                let modalBody = '';
                                if (Array.isArray(result.products)) {
                                    if (result.products.length > 0) {
                                        result.products.forEach(product => {
                                            modalBody += `
                                                <div class="product-card" style="border: 1px solid #ccc; padding: 10px; margin: 10px 0; border-radius: 8px; cursor: pointer;" data-productid="${product.productid}">
                                                    <h5>${product.productName}</h5>
                                                    <p>Vendor: ${product.vendorName}</p>
                                                </div>
                                            `;
                                        });
                                    } else {
                                        modalBody = '<p>No suggestions for this product.</p>';
                                    }
                                } else {
                                    modalBody = '<p>Error: No product data returned.</p>';
                                }

                                $('#suggestedProductsModal .modal-body').html(modalBody);
                            } else {
                                alert(result.message || 'Failed to fetch suggested products.');
                            }
                        } catch (e) {
                            console.error('Error parsing response:', e);
                            alert('An error occurred while processing the response.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while fetching suggested products.');
                    }
                });
            }

            $(document).on('click', '.product-card', function () {
                var productid = $(this).data('productid');
                var quoteid = <?php echo $quoteid; ?>; // PHP variable injected into JS
                sendQuoteRequest(productid, quoteid);
            });

            // Function to send the quote request
            function sendQuoteRequest(productid, quoteid) {
                $.ajax({
                    url: 'ajax_quote_suggested_products.php',
                    method: 'POST',
                    data: { productid: productid, quoteid: quoteid, day: selectedDay, insert_sequence: insert_sequence },
                    success: function (response) {
                        alert('Suggested product added successfully!');

                        var selectedCard = $('div[data-productid="' + productid + '"]');
                        selectedCard.css({'pointer-events': 'none', 'background-color': 'lightgreen'});
                    },
                    error: function () {
                        alert('An error occurred while sending the quote request.');
                    }
                });
            }

            // Close modal
            $(document).on('click', '#closeLinkedProductsModal', function () {
                $('#linkedProductsModal').css('display', 'none');
                $('#suggestedProductsModal').css('display', 'block');
            });
            
            $(document).on('click', '#closeSuggestedProductsModal', function () {
                $('#suggestedProductsModal').css('display', 'none');
                fetchAddedProducts();
                fetchFilteredData();
            });

            function showSuggestedProductsIndividual(day, sequence_no, productid) {
                selectedDay = day;
                insert_sequence = sequence_no;
                fetchSuggestedProducts(productid);
                document.getElementById('suggestedProductsModal').style.display = 'block';
                document.getElementById('modalBackdrop').style.display = 'block';

                // Hide the original close button
                let closeButton = document.getElementById('closeSuggestedProductsModal');
                if (closeButton) {
                    closeButton.style.display = 'none';
                }

                // Show the new close button
                let newCloseButton = document.getElementById('closeSuggestedProductsModalIndividual');
                if (newCloseButton) {
                    newCloseButton.style.display = 'block';

                    // Close modal when clicking the new button
                    newCloseButton.onclick = function () {
                        location.reload();
                    };
                }
            }
        </script>
        <!-- TDU Suggested products Modal -->
        <div id="linkedProductsModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background-color: white; padding: 20px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); z-index: 1000;">
            <div>
                <h2>Products Saved</h2>
                <div class="modal-body" style="pointer-events: none;">
                    <!-- Content will be dynamically added here -->
                </div>
                <button id="closeLinkedProductsModal" style="margin-top: 10px; background-color: #334155; color: white; border: none; padding: 10px 20px; border-radius: 4px;">Close</button>
            </div>
        </div>
        <div id="suggestedProductsModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background-color: white; padding: 20px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); z-index: 1000;">
            <div>
                <h2>Suggested Products</h2>
                <div class="modal-body">
                    <!-- Content will be dynamically added here -->
                </div>
                <button id="closeSuggestedProductsModal" style="margin-top: 10px; background-color: #334155; color: white; border: none; padding: 10px 20px; border-radius: 4px;">Close</button>
                <button id="closeSuggestedProductsModalIndividual" style="display: none; margin-top: 10px; background-color: #334155; color: white; border: none; padding: 10px 20px; border-radius: 4px;">Close</button>
            </div>
        </div>
        <div id="modalBackdrop" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.75); z-index: 999;"></div>

        <!-- Modal for entering addCoach details -->
        <div id="addCoachModal" class="modal" style="display:none;">
            <!-- Hidden inputs to pass data to PHP -->
            <input type="hidden" id="quoteid_coach" value="<?php echo $quoteid; ?>">
            <div class="modal-content">
                <span class="close-addCoach-modal">&times;</span>
                <table id="addCoachDetailsTable">
                    <thead>
                        <tr>
                            <th>No of Seaters</th>
                            <th>No of Coach</th>
                            <th>Unit Price</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Rows will be dynamically populated -->
                    </tbody>
                </table>
                <button type="button" id="saveAddCoachDetails" style="margin: 10px;">Apply</button>
            </div>
        </div>

        <script>
            // Open modal on button click
            document.addEventListener('click', function (e) {
                if (e.target && e.target.classList.contains('open-addCoach-modal')) {
                    const rowId = e.target.getAttribute('data-row-id');
                    const [quoteid, , sequence_no] = rowId.split('_'); // Assuming `rowId` is `quoteid_productid_sequence_no`

                    // Store the row ID in the modal
                    document.getElementById('addCoachModal').setAttribute('data-row-id', rowId);

                    // Fetch data from the backend
                    fetch(`ajax_fetch_coach_info.php?quoteid=${quoteid}&sequence_no=${sequence_no}`)
                        .then(response => response.json())
                        .then(data => {
                            const modalBody = document.querySelector('#addCoachDetailsTable tbody');
                            modalBody.innerHTML = ''; // Clear previous rows

                            if (data.error) {
                                alert(data.error);
                                return;
                            }

                            // If no coach data is returned, add a row with empty input fields
                            if (data.length === 0) {
                                const emptyRow = `
                                    <tr>
                                        <td><input type="number" class="seaters-number" min="1" value="" required></td>
                                        <td><input type="number" class="addCoach-number" min="1" value="" required></td>
                                        <td><input type="number" class="price-input" step="0.01" min="0" value="" required></td>
                                    </tr>
                                `;
                                modalBody.insertAdjacentHTML('beforeend', emptyRow);
                            } else {
                                // Populate the table with fetched data
                                data.forEach(item => {
                                    const row = `
                                        <tr>
                                            <td><input type="number" class="seaters-number" min="1" value="${item.seaters_number}" readonly></td>
                                            <td><input type="number" class="addCoach-number" min="1" value="${item.coach_number}" required></td>
                                            <td><input type="number" class="price-input" step="0.01" min="0" value="${item.price}" required></td>
                                        </tr>
                                    `;
                                    modalBody.insertAdjacentHTML('beforeend', row);
                                });
                            }

                            // Show the modal
                            document.getElementById('addCoachModal').style.display = 'block';
                        })
                        .catch(error => console.error('Error fetching data:', error));
                }
            });

            // Close modal
            document.querySelector('.close-addCoach-modal').addEventListener('click', function() {
                document.getElementById('addCoachModal').style.display = 'none';
            });

            // Save button logic
            document.getElementById('saveAddCoachDetails').addEventListener('click', function () {
                const modal = document.getElementById('addCoachModal');
                const rowId = modal.getAttribute('data-row-id');
                const salePriceInput = document.querySelector(`input[name="sale_price[${rowId}_0]"]`);

                // Collect updated data from modal inputs
                const rows = Array.from(document.querySelectorAll('#addCoachDetailsTable tbody tr'));
                const coachData = rows.map(row => ({
                    seaters_number: row.querySelector('.seaters-number').value,
                    coach_number: row.querySelector('.addCoach-number').value,
                    price: row.querySelector('.price-input').value
                }));

                // Send the updated coach data to the server via AJAX
                fetch('ajax_save_coach_info.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        rowId: rowId,
                        coachData: coachData
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.error) {
                        alert(data.error);
                        return;
                    }

                    // Update the sale price input field with the new calculated value
                    const newSalePrice = data.new_sale_price;
                    salePriceInput.value = newSalePrice.toFixed(2);

                    // Close the modal
                    modal.style.display = 'none';
                })
                .catch(error => {
                    console.error('Error updating coach info:', error);
                });
            });
        </script>

        <style>
            .modal {
                position: fixed;
                z-index: 1000;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
            }

            .modal-content {
                background-color: #fefefe;
                margin: 25% auto;
                padding: 20px;
                border: 1px solid #888;
                width: 50%;
            }
            
            .modal-content input {
                height: 30px;
                margin: 10px;
            }
            .close-addCoach-modal {
                color: #aaa;
                float: right;
                font-size: 28px;
                font-weight: bold;
            }

            .close-addCoach-modal:hover, .close-addCoach-modal:focus {
                color: black;
                text-decoration: none;
                cursor: pointer;
            }
        </style>

        <!-- Script to auto update travel dates based on day input -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const dayInputs = document.querySelectorAll('.day-input');

                dayInputs.forEach(input => {
                    input.addEventListener('input', function() {
                        const dayValue = parseInt(this.value);
                        const dateOfTravel = new Date(this.getAttribute('data-date-of-travel'));
                        const targetId = this.getAttribute('data-target');
                        const productId = this.name.split('[')[1].split('_')[1];
                        const cf928 = this.getAttribute('data-cf928');

                        if (!isNaN(dayValue)) {
                            // Calculate new travel date based on day input
                            const newDate = new Date(dateOfTravel);
                            newDate.setDate(newDate.getDate() + (dayValue - 1));

                            // Format the new date (d-M-Y, l format)
                            const formattedDate = newDate.toLocaleDateString('en-GB', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric',
                                weekday: 'long'
                            });

                            // Update the corresponding travel date cell
                            document.getElementById(targetId).textContent = formattedDate;

                            // fetch pricebook information
                            const formattedDateForBackend = newDate.toISOString().split('T')[0];
                                fetch('ajax_dynamic_pricebook.php', {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/x-www-form-urlencoded'
                                    },
                                    body: `productid=${productId}&newDate=${formattedDateForBackend}`
                                })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success) {
                                        const getValidFloat = (value) => isNaN(parseFloat(value)) ? '0.00' : parseFloat(value).toFixed(2);

                                        if (cf928 == 'Attraction' || cf928 == 'Restaurant' || cf928 == 'SIC' || cf928 == 'Tour') {
                                            const salePriceInput = document.querySelector(`input[name="sale_price[${input.name.split('[')[1].split(']')[0]}_1]"]`);
                                            const salePriceChildInput = document.querySelector(`input[name="sale_price_child[${input.name.split('[')[1].split(']')[0]}_1]"]`);
                                            const salePriceInfantInput = document.querySelector(`input[name="sale_price_infant[${input.name.split('[')[1].split(']')[0]}_1]"]`);

                                            if (salePriceInput) salePriceInput.value = getValidFloat(data.unitPrice);
                                            if (salePriceChildInput) salePriceChildInput.value = getValidFloat(data.childPrice);
                                            if (salePriceInfantInput) salePriceInfantInput.value = getValidFloat(data.infantPrice);
                                        } else if (cf928 == 'Guide') {
                                            const salePriceInput = document.querySelector(`input[name="sale_price[${input.name.split('[')[1].split(']')[0]}_1]"]`);
                                            if (salePriceInput) salePriceInput.value = getValidFloat(data.unitPrice);
                                        } else if (cf928 == 'Transfers') {
                                            const salePriceInput = document.querySelector(`input[name="sale_price[${input.name.split('[')[1].split(']')[0]}_0]"]`);
                                            if (salePriceInput) salePriceInput.value = getValidFloat(data.unitPrice);
                                        }
                                    } else {
                                        console.error("Failed to update prices:", data.message);
                                    }
                                })
                                .catch(error => console.error('Error fetching price data:', error));
                        }
                    });
                });
            });
        </script>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                function confirmChange(event) {
                    const userConfirmed = confirm("Are you sure you want to change the price?");
                    if (!userConfirmed) {
                        event.target.value = event.target.dataset.oldValue; // Revert if canceled
                    } else {
                        event.target.dataset.oldValue = event.target.value; // Update stored value
                    }
                }

                function storeOldValue(event) {
                    event.target.dataset.oldValue = event.target.value;
                }

                // Select all inputs related to sale prices dynamically
                const priceInputs = document.querySelectorAll("input[name^='sale_price']");
                priceInputs.forEach(input => {
                    input.addEventListener("focus", storeOldValue);
                    input.addEventListener("change", confirmChange);
                });
            });
        </script>

        <?php
        $sql_approved = "SELECT margin AS approved 
                        FROM vtiger_inventoryproductrel vi 
                        JOIN vtiger_products_custom vpc ON vi.productid = vpc.productid
                        WHERE vi.id = '$quoteid'";
        $result_approved = $conn->query($sql_approved);
        $allApprovedNotNull = true;
        if ($result_approved->num_rows > 0) {
            while ($row_approved = $result_approved->fetch_assoc()) {
                if (!isset($row_approved['approved'])) {
                    $allApprovedNotNull = false;
                    break;
                }
            }
        }

        if($non_operation_product) {
            ?>
            <!-- download quote -->
            <div id="div5" class="content-div" style="margin-top: 20px;">
                <button type="button" disabled>Download Quote</button>
                <button type="button" disabled>Download Sale Order</button>
                <button type="button" disabled>Generate Initial Invoice</button>
                <h2 style="padding: 20px 0;">You have products fall within a non-operation period, Please check</h2>
            </div>
            <?php
        } 
        else if($hasMultipleVendorPending) {
            ?>
            <!-- download quote -->
            <div id="div5" class="content-div" style="margin-top: 20px;">
                <button type="button" disabled>Download Quote</button>
                <button type="button" disabled>Download Sale Order</button>
                <button type="button" disabled>Generate Initial Invoice</button>
                <h2 style="padding: 20px 0;">You have products multiple vendors not approved, Please check</h2>
            </div>
            <?php
        }
        else if($allApprovedNotNull) {
            ?>
            <!-- download quote -->
            <div id="div5" class="content-div" style="margin-top: 20px;">
                <form id="form1" action="export_quote.php" method="post">
                    <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
                    <input type="hidden" name="quoteNumber" value="<?php echo htmlspecialchars($quote_number); ?>">
                    <input type="hidden" name="dateoftravel" value="<?php echo htmlspecialchars($date_of_travel); ?>">
                    <input type="hidden" name="mode" value="<?php echo htmlspecialchars($mode); ?>">

                    <?php
                    $sql_markup_check = "SELECT MAX(markup) AS max_markup, MAX(markup_child) AS max_markup_child FROM vtiger_markup WHERE quoteid='$quoteid';";
                    $result_markup_check = mysqli_query($conn, $sql_markup_check);
                    if ($result_markup_check) {
                        $row_markup_check = mysqli_fetch_assoc($result_markup_check);
                        $max_markup = (int) $row_markup_check['max_markup'] ?? 0;
                        $max_markup_child = (int) $row_markup_check['max_markup_child'] ?? 0;
                    }

                    $disable_due_to_child = false;
                    $sql_markup_check = "SELECT sale_price, sale_price_child
                                        FROM vtiger_products_saleprice 
                                        WHERE quoteid='$quoteid' AND subquoteid='1' AND (cf_928='Attraction' OR cf_928='Restaurant' OR cf_928='Tour' OR cf_928='SIC');";
                    $result_markup_check = mysqli_query($conn, $sql_markup_check);
                    if ($result_markup_check) {
                        while ($row_markup_check = mysqli_fetch_assoc($result_markup_check)) {
                            if((float) $row_markup_check['sale_price'] > 0 && (float) $row_markup_check['sale_price_child'] > 0) {
                                continue;
                            }
                            $disable_due_to_child = true;
                            break;
                        }
                    }
                    if ($pax_no <= 0) {
                        ?>
                        <button type="submit" name="quote" class="tooltip" disabled>Download Quote
                            <span class="tooltiptext">Number of Passengers cannot be 0</span>
                        </button>
                        <?php
                    } else if ($total_people != $total_capacity) {
                        ?>
                        <button type="submit" name="quote" class="tooltip" disabled>Download Quote
                            <span class="tooltiptext">The room allocation is incorrect. Please check in Operation->Hotel</span>
                        </button>
                        <?php
                    } else if ($disable_due_to_child) {
                        ?>
                        <button type="submit" name="quote" class="tooltip" disabled>Download Quote
                            <span class="tooltiptext">Product Price must be greater than zero. Please check in Quote</span>
                        </button>
                        <?php
                    } else {
                        ?>
                        <button type="submit" name="quote" <?= $final_path ? 'class="tooltip" disabled' : '' ?>>Download Quote
                            <?php if ($final_path) { ?>
                                <span class="tooltiptext">Final Invoice is already generated.</span>
                            <?php } ?>
                        </button>
                        <?php
                    }

                    $enable_download_so = 'disabled';
                    $so_tooltip = "To be able to download SO:<br>
                                    - The initial invoice status should be green.<br>
                                    - All status for attraction, hotel, restaurant, transfers, and tour should be green / grey.<br>
                                    - Quote stage is after Accepted";
                    if ($title == 'admin' && $username != 'Kunjan') {
                        $enable_download_so = '';
                        $so_tooltip = '';
                    }
                    $stagesToEnableDownload = [
                        'Created', 'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                        'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
                    ];
                    if (in_array($quotestage, $stagesToEnableDownload) &&
                        $initial_invoice_condition == 'green' &&
                        in_array($condition_for_attraction, ['grey', 'green']) &&
                        in_array($condition_for_hotel, ['grey', 'green']) &&
                        in_array($condition_for_restaurant, ['grey', 'green']) &&
                        in_array($condition_for_transfers, ['grey', 'green']) &&
                        in_array($condition_for_sic, ['grey', 'green']) &&
                        in_array($condition_for_guide, ['grey', 'green']) &&
                        in_array($condition_for_tour, ['grey', 'green'])) {
                        $enable_download_so = '';
                        $so_tooltip = '';
                    }
                    ?>
                    <button type="submit" name="so" class="tooltip" <?= $enable_download_so ?> <?= $condition_for_naming ? 'disabled' : '' ?>>Download Sale Order
                        <?php if ($enable_download_so === 'disabled') { ?>
                            <p class="tooltiptext"><?= $so_tooltip; ?></p>
                        <?php } elseif ($condition_for_naming) { ?>
                            <p class="tooltiptext">Rooming List Incomplete</p>
                        <?php } ?>
                    </button>

                    <!-- New Display Sale Order Button -->
                    <?php if ($title == 'admin') : ?>
                        <button type="button" onclick="loadSaleOrder()">Display Sale Order</button>
                    <?php endif; ?>

                    <?php 
                    if ($initial_path) {
                        if ($final_path && substr($quote_number, -1) != 'G') {  // FIT quotes
                            ?>
                            <button type="button" onclick="downloadInvoice('<?php echo $final_path . '.pdf'; ?>', '<?= $quoteid ?>', 'download-final')">Download Invoice</button>
                            <?php
                        } else {
                            ?>
                            <button type="button" onclick="downloadInvoice('<?php echo $initial_path . '.pdf'; ?>', '<?= $quoteid ?>', 'download-initial')">Download <?= substr($quote_number, -1) === 'G' ? 'Initial' : '' ?> Invoice</button>
                            <?php
                        }
                    } else {
                        if ($total_people != $total_capacity) {
                            ?>
                            <button type="submit" name="invoice" value="initial" class="tooltip" disabled>Generate <?= substr($quote_number, -1) === 'G' ? 'Initial' : '' ?> Invoice
                                <span class="tooltiptext">The room allocation is incorrect. Please check in Operation->Hotel</span>
                            </button>
                            <?php
                        } else if (!in_array($quotestage, $stagesToEnableDownload)) {
                            ?>
                            <button type="submit" name="invoice" value="initial" class="tooltip" disabled>Generate <?= substr($quote_number, -1) === 'G' ? 'Initial' : '' ?> Invoice
                                <span class="tooltiptext">Quote stage - <?= $quotestage ?> is not allowed to generate invoice</span>
                            </button>
                            <?php
                        } else {
                            ?>
                            <button type="submit" name="invoice" value="initial">Generate <?= substr($quote_number, -1) === 'G' ? 'Initial' : '' ?> Invoice</button>
                            <?php
                        }
                    }

                    $sql_download_history = "SELECT created_at, created_by, type FROM vtiger_invoice WHERE quoteid='$quoteid' ORDER BY created_at DESC;";
                    $result_download_history = $conn->query($sql_download_history);
                    $going_to_download = false;
                    $going_to_generate = false;

                    while ($row = mysqli_fetch_assoc($result_download_history)) {
                        if ($row['type'] == 'final') {
                            $going_to_download = true;
                            break;
                        }
                        if ($row['type'] == 'initial' || $row['type'] == 'adjust') {
                            $going_to_generate = true;
                            break;
                        }
                    }

                    if ($initial_path && substr($quote_number, -1) === 'G') {
                        $can_generate_final = 'disabled';
                        $final_tooltip = "All Status should be green / grey to generate final invoice:\n- attraction\n- hotel\n- restaurant\n- transfers\n- tour";

                        if (in_array($condition_for_attraction, ['grey', 'green']) &&
                            in_array($condition_for_hotel, ['grey', 'green']) &&
                            in_array($condition_for_restaurant, ['grey', 'green']) &&
                            in_array($condition_for_transfers, ['grey', 'green']) &&
                            in_array($condition_for_sic, ['grey', 'green']) &&
                            in_array($condition_for_guide, ['grey', 'green']) &&
                            in_array($condition_for_tour, ['grey', 'green'])) {

                            $can_generate_final = '';
                            $final_tooltip = "";
                        }

                        if ($going_to_generate) {
                            ?>
                            <button type="submit" name="invoice" value="final" class="tooltip" <?= $can_generate_final ?>>Generate New Final Invoice
                                <?php if ($can_generate_final === 'disabled') { ?>
                                    <span class="tooltiptext"><?= htmlspecialchars($final_tooltip); ?></span>
                                <?php } ?>
                            </button>
                            <?php
                        }
                        if ($final_path && $going_to_download) {
                            ?>
                            <button type="button" onclick="downloadInvoice('<?php echo $final_path . '.pdf'; ?>', '<?= $quoteid ?>', 'download-final')" <?= $can_generate_final ?>>Download Latest Final Invoice</button>
                            <?php
                        }
                    } else {
                        if (substr($quote_number, -1) != 'G') {
                            ?>
                            <button type="submit" name="invoice" value="final" class="tooltip">Regenerate Invoice</button>
                            <?php
                        }
                    }
                    ?>

                    <div style="border: 3px solid #334155; padding: 5px; display: inline-block;">
                        <button type="button" onclick="openVisaModal()">Upload Passports List</button>
                        <button type="submit" name="visa" <?= empty($visa_pax_path) ? 'disabled style="cursor: not-allowed;" title="Please upload Passports List"' : '' ?>>
                            Download Visa Letter
                        </button>
                    </div>
                </form>
            </div>

            <!-- visa start -->
            <div id="csvModal" style="display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.4); padding-top: 60px;">
                <div style="background-color: white; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 10px;">
                    <span onclick="closeVisaModal()" style="color: #aaa; font-size: 28px; font-weight: bold; position: absolute; top: 10px; right: 20px; cursor: pointer;">&times;</span> 
                    <h2 style="text-align: center;">Upload Passports List</h2>
                    <form action="ajax_visa_handler.php" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                        <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">

                        <div style="max-width: 400px; margin: 15px; padding: 20px; border: 1px solid #ccc; border-radius: 8px;">
                            <label for="file" style="display: block; margin-bottom: 5px; font-weight: bold;">Download Template:</label>
                            <button type="submit" name="download">Download</button>
                        </div>

                        <div style="max-width: 400px; margin: 15px; padding: 20px; border: 1px solid #ccc; border-radius: 8px;">
                            <label for="file" style="display: block; margin-bottom: 5px; font-weight: bold;">Upload CSV File:</label>
                            <input type="file" name="csv_file" id="file" accept=".csv" onchange="toggleVisaUploadButton()" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;"> 
                            <div id="buttonVisaContainer" style="display: none; margin-top: 10px;">
                                <button type="submit" name="upload">Upload</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <script>
                function openVisaModal() {
                    document.getElementById('csvModal').style.display = 'block';
                }

                function closeVisaModal() {
                    document.getElementById('csvModal').style.display = 'none';
                }

                // Optional: close modal when clicking outside of it
                window.onclick = function(event) {
                    var modal = document.getElementById('csvModal');
                    if (event.target == modal) {
                        modal.style.display = "none";
                    }
                }

                function toggleVisaUploadButton() {
                    const fileInput = document.getElementById('file');
                    const buttonContainer = document.getElementById('buttonVisaContainer');
                    buttonContainer.style.display = fileInput.files.length > 0 ? 'block' : 'none';
                }
            </script>
            <!-- visa end -->
            <?php
        }
        else {
            ?>
            <!-- download quote -->
            <div id="div5" class="content-div" style="margin-top: 20px;">
                <button type="button" disabled>Download Quote</button>
                <button type="button" disabled>Download Sale Order</button>
                <button type="button" disabled>Generate Initial Invoice</button>
                <h2 style="padding: 20px 0;">You have customised products not approved, Please contact Admin</h2>
            </div>
            <?php
        }
        ?>
        
        <!-- Itinerary Table Container (initially empty) -->
        <div id="saleOrderContainer" style="display: none; margin: 20px;"></div>

        <!-- edit trip details -->
        <div id="div6" class="content-div">
            <form method="post" style="margin-top: 20px; margin: 20px;" onsubmit="return checkTotalPeople();">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">

                <!-- Hidden inputs for original values -->
                <input type="hidden" id="original_no_of_adults" name="original_no_of_adults" value="<?php echo $adults_no; ?>">
                <input type="hidden" id="original_no_of_children" name="original_no_of_children" value="<?php echo $children_no; ?>">
                
                <input type="hidden" id="organization_name" name="organization_name" value="<?php echo $accountname; ?>">
                <input type="hidden" id="assigned_to_region" name="assigned_to_region" value="<?php echo $assigned_to_region; ?>">
                

                <div class="form-container">
                    <div class="form-column">
                        <div class="form-row">
                            <label for="quote_stage">*Quote Stage:</label>
                            <select id="quote_stage" name="quote_stage" required>
                                <?php 
                                $quoteStages = fetchAllowedQuoteStages($conn, $title, $quotestage); 
                                $shouldDisableAccepted = shouldDisableAccepted($conn, $quoteid); 
                                $isPaymentReceivedToAccepted = isPaymentReceivedToAccepted($conn, $quoteid); 
                                if(substr($quote_number, -1) === 'G' || $title == 'admin') {
                                    $shouldDisableAccepted = false;
                                }
                                ?>
                                <script>
                                    var quoteStages = <?php echo json_encode($quoteStages); ?>;
                                    var shouldDisableAccepted = <?php echo json_encode($shouldDisableAccepted); ?>;
                                    var isPaymentReceivedToAccepted = <?php echo json_encode($isPaymentReceivedToAccepted); ?>;
                                    var selectElement = document.getElementById('quote_stage');

                                    var quotestagenow = "<?php echo $quotestage; ?>";
                                    var titlenow = "<?php echo $title; ?>";

                                    quoteStages.forEach(function(stage) {
                                        var option = document.createElement('option');
                                        option.value = stage.quotestage;
                                        option.textContent = stage.quotestage;

                                        // Disable all options that are not enabled
                                        if (!stage.enabled) {
                                            option.disabled = true; 
                                        }

                                        // Specifically disable "Accepted" and add tooltip if required
                                        if (stage.quotestage === 'Accepted' && isPaymentReceivedToAccepted) {
                                            option.disabled = true;
                                            option.setAttribute("title", "Cannot Accept - Payment Not Received and Travel date is within 15 days");
                                        } else if (stage.quotestage === 'Accepted' && shouldDisableAccepted) {
                                            option.disabled = true;
                                            option.setAttribute("title", "Cannot Accept - Rooming list incomplete");
                                        } else if (stage.quotestage === 'Accepted' && quotestagenow === 'Created' && titlenow === 'qa') {
                                            option.disabled = true;
                                        }

                                        selectElement.appendChild(option);
                                    });
                                </script>
                            </select>
                            <script>document.getElementById('quote_stage').value = "<?php echo $quotestage; ?>";</script>
                        </div>

                        <div class="form-row">
                            <label for="priority">Priority:</label>
                            <select id="priority" name="priority">
                                <option value="" disabled>Select priority</option>
                                <option value="not connected" <?php echo $priority === 'not connected' ? 'selected' : ''; ?>>Not connected</option>
                                <option value="low" <?= $priority == 'low' ? 'selected' : '' ?>>Low</option>
                                <option value="high" <?= $priority == 'high' ? 'selected' : '' ?>>High</option>
                            </select>
                        </div>

                        <div class="form-row">
                            <label for="assigned_to_ops">Assigned To Ops Person:</label>
                            <select name="assigned_to_ops">
                                <option value=""></option>
                                <?php
                                if (substr($quote_number, -1) === 'G') {
                                    $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                             WHERE title IN ('group', 'admin') 
                                             ORDER BY title ASC;";
                                } else {
                                    $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                             WHERE title IN ('fit', 'admin') 
                                             ORDER BY title ASC;";
                                }
                                $resultr = $conn->query($sqlr);
                                $current_title = '';

                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        if ($rowr['title'] !== $current_title) {
                                            $current_title = $rowr['title'];
                                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                                        }

                                        $selected = (isset($assigned_to_ops) && $assigned_to_ops == $rowr['name']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-row">
                            <label for="assigned_to_qa">Assigned To QA Person:</label>
                            <select name="assigned_to_qa">
                                <option value=""></option>
                                <?php
                                $sqlqa = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                        WHERE title IN ('qa', 'admin') 
                                        ORDER BY title ASC;";

                                $resultqa = $conn->query($sqlqa);
                                $current_title = '';

                                if ($resultqa->num_rows > 0) {
                                    while ($rowqa = $resultqa->fetch_assoc()) {
                                        if ($rowqa['title'] !== $current_title) {
                                            $current_title = $rowqa['title'];
                                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                                        }

                                        $selected = (isset($assigned_to_qa) && $assigned_to_qa == $rowqa['name']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowqa['name']) . "\" $selected>" . htmlspecialchars($rowqa['name']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>

                        <?php if ($ref_quote_no == '') : ?>
                            <button type="submit" name="update_quote">Save</button>
                        <?php endif; ?>
                    </div>

                    <div class="form-column">
                        <div class="form-row">
                            <label for="date_of_travel">*Date Of Travel:</label>
                            <input type="date" id="date_of_travel" name="date_of_travel" value="<?php echo $date_of_travel; ?>" required>
                        </div>
                        <div class="form-row">
                            <label for="payment_deadline">Payment-Cancellation Deadline:</label>
                            <input type="date" id="payment_deadline" name="payment_deadline" value="<?php echo $payment_deadline; ?>" max="<?php echo $date_of_travel; ?>" <?= !empty($payment_deadline_pending) ? 'readonly' : ''; ?> >
                            <input type="hidden" id="payment_deadline_pending" name="payment_deadline_pending" value="0">
                        </div>
                        <div id="deadline-warning" style="color: red; display: none; margin-bottom: 10px; white-space: nowrap;"></div>
                        <?php if (!empty($payment_deadline_pending)) : ?>
                            <div class="form-row">
                                <label style="color: red;" for="payment_deadline_pending">Payment-Cancellation Deadline<br>Pending Approval:</label>
                                <?php if ($title== 'admin') : ?>
                                    <button type="button" id="approve-deadline-btn" title="Approve Deadline">
                                        <i class="fa-solid fa-check"></i>
                                    </button>
                                <?php endif; ?>
                                <input style="color: red;" type="date" value="<?php echo $payment_deadline_pending; ?>" disabled>
                            </div>
                            <script>
                                document.getElementById('approve-deadline-btn').addEventListener('click', function () {
                                    if (!confirm('You may be responsible for the loss if Payment-Cancellation Deadline is set within 15 days. Are you sure you want to approve this payment deadline change?')) return;

                                    fetch('ajax_approve_payment_deadline_change.php', {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/x-www-form-urlencoded'
                                        },
                                        body: 'quoteid=<?php echo $quoteid; ?>&payment_deadline_pending=<?php echo urlencode($payment_deadline_pending); ?>&username=<?php echo urlencode($username); ?>'
                                    })
                                    .then(response => response.text())
                                    .then(data => {
                                        alert(data); // or use a toast/message system
                                        location.reload(); // reload to reflect the approved change
                                    })
                                    .catch(error => {
                                        console.error('Error:', error);
                                        alert('Something went wrong. Please try again.');
                                    });
                                });
                            </script>
                        <?php endif; ?>
                        <div class="form-row">
                            <label for="accepted_date">Accepted Date:</label>
                            <input type="date" id="accepted_date" name="accepted_date" value="<?php echo $accepted_date; ?>">
                        </div>
                    </div>
                    
                    <div class="form-column">
                        <div class="form-row">
                            <label for="no_of_single">No of Single Rooms:</label>
                            <input type="number" id="no_of_single" name="no_of_single" min="0" value="<?= $nsingle_room; ?>" required>
                        </div>
                        <div class="form-row">
                            <label for="no_of_double">No of Double Rooms:</label>
                            <input type="number" id="no_of_double" name="no_of_double" min="0" value="<?= $ndouble_room; ?>" required>
                        </div>
                        <div class="form-row">
                            <label for="no_of_triple">No of Triple Rooms:</label>
                            <input type="number" id="no_of_triple" name="no_of_triple" min="0" value="<?= $ntriple_room; ?>" required>
                        </div>
                        <div class="form-row">
                            <label for="no_of_children_without_bed">No of Children without Bed:</label>
                            <input type="number" id="no_of_children_without_bed" name="no_of_children_without_bed" min="0" value="<?= $nchild_without_bed; ?>" required>
                        </div>

                        <hr style="width: 100%; border: 1px solid #334155; margin: 20px 0;">

                        <div class="form-row">
                            <label for="no_of_adults">No of Adults:</label>
                            <input type="number" id="no_of_adults" name="no_of_adults" min="1" value="<?= $adults_no; ?>" required>
                        </div>
                        <div class="form-row">
                            <label for="no_of_children">No of Children:</label>
                            <input type="number" id="no_of_children" name="no_of_children" min="0" value="<?= $children_no; ?>" required onchange="updateChildrenAges()">
                        </div>
                        <div class="form-row">
                            <label for="no_of_infants">No of Infants:</label>
                            <input type="number" id="no_of_infants" name="no_of_infants" min="0" value="<?= $infants_no; ?>" required>
                        </div>
                        <div id="children_ages_container">
                            <?php 
                            $ages = !empty($child_ages) ? explode(',', $child_ages) : [];
                            foreach ($ages as $index => $age) {
                                echo '<div class="form-row child-age-row">
                                        <label>Child ' . ($index + 1) . ' Age:</label>
                                        <input type="number" name="child_ages[]" min="0" value="' . htmlspecialchars($age) . '" required>
                                    </div>';
                            }
                            ?>
                        </div>
                        <script>
                            function updateChildrenAges() {
                                var childrenCount = document.getElementById('no_of_children').value;
                                var container = document.getElementById('children_ages_container');
                                container.innerHTML = '';

                                for (var i = 0; i < childrenCount; i++) {
                                    var ageRow = document.createElement('div');
                                    ageRow.classList.add('form-row', 'child-age-row');

                                    var label = document.createElement('label');
                                    label.textContent = 'Child ' + (i + 1) + ' Age:';

                                    var input = document.createElement('input');
                                    input.type = 'number';
                                    input.name = 'child_ages[]';
                                    input.min = '0';
                                    input.required = true;

                                    ageRow.appendChild(label);
                                    ageRow.appendChild(input);
                                    container.appendChild(ageRow);
                                }
                            }
                        </script>
                    </div>
                </div>
        
                <script>
                    function confirmCancel() {
                        if (confirm('Are you sure you want to cancel?')) {
                            window.location.href = '?opt=search';
                        }
                    }
                    document.getElementById('addOrganizationBtn').addEventListener('click', function() {
                        document.getElementById('organizationPopup').style.display = 'block';
                    });
                    function closePopup() {
                        document.getElementById('organizationPopup').style.display = 'none';
                    }
                </script>
            </form>
            <style>
                .form-container {
                    display: grid;
                    width: 80%;
                    grid-template-columns: 1fr 1fr 1fr;
                }
        
                .form-column {
                    padding: 20px;
                    border-radius: 5px;
                }
        
                .form-row {
                    margin-bottom: 10px;
                }
            
                .form-row label {
                    margin-right: 10px;
                }
                .form-row {
                    display: flex;
                    justify-content: space-between;
                    margin-bottom: 10px;
                }
                .form-row label {
                    width: 45%;
                }
                .form-row input, .form-row select, .form-row textarea {
                    width: 300px !important;
                    padding: 5px;
                    border: 1px solid #ccc;
                    border-radius: 5px;
                }
            </style>
            <script>
                function checkTotalPeople() {
                    const single = parseInt(document.getElementById("no_of_single").value) || 0;
                    const double = parseInt(document.getElementById("no_of_double").value) || 0;
                    const triple = parseInt(document.getElementById("no_of_triple").value) || 0;
                    const childrenWithoutBed = parseInt(document.getElementById("no_of_children_without_bed").value) || 0;

                    const adults = parseInt(document.getElementById("no_of_adults").value) || 0;
                    const children = parseInt(document.getElementById("no_of_children").value) || 0;

                    const totalBeds = single + (double * 2) + (triple * 3);
                    const totalPeople = adults + children - childrenWithoutBed;

                    if (totalBeds != totalPeople || childrenWithoutBed > children) {
                        alert(`Mismatch detected: Single + Double*2 + Triple*3 = Adults + Children - Children without bed`);
                        return false;
                    }
                    
                    var originalAdults = parseInt(document.getElementById('original_no_of_adults').value) || 0;
                    var originalChildren = parseInt(document.getElementById('original_no_of_children').value) || 0;
                    var originalTotal = originalAdults + originalChildren;
                    
                    var newAdults = parseInt(document.getElementById('no_of_adults').value) || 0;
                    var newChildren = parseInt(document.getElementById('no_of_children').value) || 0;
                    var newTotal = newAdults + newChildren;

                    var quoteNumber = "<?php echo $quote_number; ?>";
                    
                    if (!quoteNumber.endsWith("G") && newTotal > 10) {
                        return confirm('The total number of people has increased above 10. This quote will be converted to Group Quote. Are you sure you want to proceed?');
                    }
                    return true;
                }
            </script>
        </div>
        
        <div id="div7" class="content-div">
            <h2 style="margin: 10px 25%; padding: 10px;">New Adjustment</h2>

            <select id="adjustment_type" name="adjustment_type" style="margin: 10px 25%; width: 50%;" onchange="showAdjustDiv(this.value)">
                <option value="">Select Adjustment Type</option>
                <option value="add_product">Add Product</option>
                <option value="adjust_product_price">Adjust Product Price</option>
                <option value="adjust_overall_pax">Adjust Number of Pax</option>
                <option value="refund_section">Product Reduction</option>
            </select>

            <!-- Adjust: add new product -->
            <div id="add_product" class="toggle-div" style="display: none;">
                <form id="add_product_form">
                    <table class="adjustment-table">
                        <tr>
                            <th>Category</th>
                            <td>
                                <select name="category" id="add_product_category" style="width: 100%; margin: 0;" required>
                                    <option value="">Select Category</option>
                                    <option value="Attraction">Attraction</option>
                                    <option value="Hotel">Hotel</option>
                                    <option value="Restaurant">Restaurant</option>
                                    <option value="Tour">Tour</option>
                                    <option value="Transfers">Transfers</option>
                                    <option value="SIC">SIC</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>Day</th>
                            <td>
                                <input type="number" min="1" value="1" name="day" id="add_product_day" style="width: 100%; margin: 0;" required>
                            </td>
                        </tr>
                        <tr>
                            <th>Date</th>
                            <td>
                                <input type="date" name="date" id="add_product_date" style="width: 100%; margin: 0;" value="<?php echo $date_of_travel; ?>" min="<?php echo $date_of_travel; ?>" required>
                            </td>
                        </tr>
                        <tr>
                            <th>Vendor</th>
                            <td>
                                <input type="text" name="vendor" id="add_product_vendor" style="width: 100%; margin: 0;" required>
                            </td>
                        </tr>
                        <tr>
                            <th>Product</th>
                            <td>
                                <input type="text" name="product" id="add_product_product" style="width: 100%; margin: 0;" required>
                            </td>
                        </tr>
                        <tr>
                            <th>Price</th>
                            <td>
                                <input type="number" name="price" id="add_product_price" style="width: 100%; margin: 0;" min="0" step="0.01" required>
                            </td>
                        </tr>
                        <tr>
                            <th>No of Pax</th>
                            <td>
                                <input type="number" name="no_of_pax" id="add_product_quantity" style="width: 100%; margin: 0;" min="1" required>
                            </td>
                        </tr>
                        <tr>
                            <th>Remark</th>
                            <td>
                                <textarea name="remark" id="add_product_remark" style="width: 100%; height: 100px;" required></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <button type="button" id="submit_add_product" style="padding: 10px 20px;">Save Product</button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <script>
                const dayInput = document.getElementById('add_product_day');
                const dateInput = document.getElementById('add_product_date');
                const initialDate = new Date(dateInput.value);

                dayInput.addEventListener('input', () => {
                    const dayOffset = parseInt(dayInput.value) - 1;
                    const newDate = new Date(initialDate);
                    newDate.setDate(initialDate.getDate() + dayOffset);
                    dateInput.value = newDate.toISOString().split('T')[0];
                });

                dateInput.addEventListener('input', () => {
                    const selectedDate = new Date(dateInput.value);
                    const dayDifference = Math.floor((selectedDate - initialDate) / (1000 * 60 * 60 * 24)) + 1;
                    dayInput.value = dayDifference;
                });

                const quoteid = "<?php echo $quoteid; ?>";
                document.getElementById('submit_add_product').addEventListener('click', function () {
                    document.getElementById('submit_add_product').style.display = 'none';
                    document.getElementById('processing_message').style.display = 'block';

                    // Gather form data
                    const formData = {
                        quoteid: quoteid,
                        adjustment_type: 'add_product',
                        category: document.getElementById('add_product_category').value,
                        day: document.getElementById('add_product_day').value,
                        date: document.getElementById('add_product_date').value,
                        vendor: document.getElementById('add_product_vendor').value,
                        product: document.getElementById('add_product_product').value,
                        price: document.getElementById('add_product_price').value,
                        quantity: document.getElementById('add_product_quantity').value,
                        remark: document.getElementById('add_product_remark').value,
                    };

                    // Perform an AJAX POST request
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_invoice_adjust.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            const response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                alert('Product added successfully!');
                                // Optionally, clear the form
                                document.getElementById('add_product_form').reset();

                                const url = new URL(window.location.href);
                                const params = url.searchParams;

                                // Add or update the 'edit' parameter
                                params.set('edit', 'adjustment');

                                // Redirect to the updated URL
                                window.location.href = url.toString();
                            } else {
                                alert('Failed to add product: ' + response.error);
                            }
                        } else {
                            alert('An error occurred: ' + xhr.statusText);
                        }
                    };

                    // Serialize form data for x-www-form-urlencoded format
                    const urlEncodedData = Object.keys(formData)
                        .map(key => encodeURIComponent(key) + '=' + encodeURIComponent(formData[key]))
                        .join('&');

                    xhr.send(urlEncodedData);
                });
            </script>

            <!-- Adjust: product price -->
            <div id="adjust_product_price" class="toggle-div" style="display: none;">
                <form id="adjust_product_price_form">
                    <table class="adjustment-table">
                        <tr>
                            <th>Category</th>
                            <td>
                                <select name="category" id="adjust_product_category" style="width: 100%; margin: 0;" required onchange="loadProductsByCategory()">
                                    <option value="">Select Category</option>
                                    <option value="Attraction">Attraction</option>
                                    <option value="Hotel">Hotel</option>
                                    <option value="Restaurant">Restaurant</option>
                                    <option value="Tour">Tour</option>
                                    <option value="SIC">SIC</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>Product</th>
                            <td>
                                <select name="product" id="adjust_product_select" style="width: 100%; margin: 0;" required onchange="showAdjustmentFields()">
                                    <option value="">Select Product</option>
                                    <!-- Products will be populated here -->
                                </select>
                            </td>
                        </tr>
                        <tr id="adjustment_row" style="display: none;">
                            <th>Adjustment Amount</th>
                            <td>
                                <select name="adjustment_sign" id="adjustment_sign" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                $ <input type="number" name="adjustment_amount" id="adjustment_amount" style="width: 85%;" min="0" required />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <button type="button" id="submit_adjust_product_price" style="padding: 10px 20px;">Save Adjustment</button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <script>
                document.getElementById('submit_adjust_product_price').addEventListener('click', function () {
                    document.getElementById('submit_adjust_product_price').style.display = 'none';
                    document.getElementById('processing_message').style.display = 'block';

                    // Gather form data
                    const formData = {
                        quoteid: quoteid,
                        adjustment_type: 'adjust_product_price',
                        category: document.getElementById('adjust_product_category').value,
                        product: document.getElementById('adjust_product_select').value,
                        adjustment_sign: document.getElementById('adjustment_sign').value,
                        adjustment_amount: document.getElementById('adjustment_amount').value,
                    };

                    // Perform an AJAX POST request
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_invoice_adjust.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            const response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                alert('Price adjusted successfully!');
                                // Optionally, clear the form
                                document.getElementById('adjust_product_price_form').reset();

                                const url = new URL(window.location.href);
                                const params = url.searchParams;

                                // Add or update the 'edit' parameter
                                params.set('edit', 'adjustment');

                                // Redirect to the updated URL
                                window.location.href = url.toString();
                            } else {
                                alert('Failed to adjust price: ' + response.error);
                            }
                        } else {
                            alert('An error occurred: ' + xhr.statusText);
                        }
                    };

                    // Serialize form data for x-www-form-urlencoded format
                    const urlEncodedData = Object.keys(formData)
                        .map(key => encodeURIComponent(key) + '=' + encodeURIComponent(formData[key]))
                        .join('&');

                    xhr.send(urlEncodedData);
                });

                function loadProductsByCategory() {
                    var category = document.getElementById("adjust_product_category").value;
                    var quoteid = "<?php echo $quoteid; ?>";
                    if (category) {
                        // Create the AJAX request to fetch products based on the selected category and quoteid
                        var xhr = new XMLHttpRequest();
                        xhr.open("GET", "ajax_fetch_adjust_products.php?category=" + category + "&quoteid=" + quoteid, true);
                        xhr.onload = function() {
                            if (xhr.status === 200) {
                                // Populate the product dropdown with the returned product options
                                var products = JSON.parse(xhr.responseText);
                                var productSelect = document.getElementById("adjust_product_select");
                                productSelect.innerHTML = '<option value="">Select Product</option>'; // Reset options
                                products.forEach(function(product) {
                                    // Format option as 'Day X: name'
                                    var optionText = 'Day ' + product.day + ': ' + product.name;
                                    var option = document.createElement("option");
                                    option.value = product.sequence_no;
                                    option.textContent = optionText;
                                    productSelect.appendChild(option);
                                });
                            } else {
                                alert("Error fetching products.");
                            }
                        };
                        xhr.send();
                    }
                }

                function showAdjustmentFields() {
                    var productSelect = document.getElementById("adjust_product_select");
                    var adjustmentRow = document.getElementById("adjustment_row");

                    // Show the adjustment fields if a product is selected
                    if (productSelect.value !== "") {
                        adjustmentRow.style.display = "table-row";
                    } else {
                        adjustmentRow.style.display = "none";
                    }
                }
            </script>

            <!-- Refund Section -->
            <div id="refund_section" class="toggle-div" style="display: none;">
                <form id="refund_form">
                    <table class="adjustment-table">
                        <tr>
                            <th>Category</th>
                            <td>
                                <select name="refund_category" id="refund_category" style="width: 100%; margin: 0;" required onchange="loadProductsByCategory2()">
                                    <option value="">Select Category</option>
                                    <option value="Attraction">Attraction</option>
                                    <option value="Hotel">Hotel</option>
                                    <option value="Restaurant">Restaurant</option>
                                    <option value="Tour">Tour</option>
                                    <option value="Transfers">Transfers</option>
                                    <option value="Guide">Guide</option>
                                    <option value="SIC">SIC</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>Product</th>
                            <td>
                                <select name="refund_product" id="refund_product_select" style="width: 100%; margin: 0;" required onchange="updateProductPrice()">
                                    <option value="">Select Product</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>Product Price</th>
                            <td>
                                <input type="text" name="product_price_each" id="product_price_each" style="width: 100%;" readonly />
                            </td>
                        </tr>
                        <tr>
                            <th>Number of Pax Deduction</th>
                            <td>
                                <input type="number" name="pax_deduction" id="pax_deduction" style="width: 100%;" min="0" required oninput="calculateRefundAmount()" />
                            </td>
                        </tr>
                        <tr>
                            <th>Reduction Amount in AUD/NZD</th>
                            <td>
                                <input type="number" name="refund_amount" id="refund_amount" style="width: 100%;" min="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Reduction Category</th>
                            <td>
                                <select name="reduction_category" id="reduction_category" style="width: 100%;" required>
                                    <option value="suppliers">Suppliers</option>
                                    <option value="other">Other</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th>Reference Email ID</th>
                            <td>
                                <input type="text" name="reference_email_id" id="reference_email_id" style="width: 100%;" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Reduction Reason</th>
                            <td>
                                <textarea name="refund_reason" id="refund_reason" style="width: 100%;" required></textarea>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <button type="button" id="submit_refund" style="padding: 10px 20px;">Process</button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <script>
                document.getElementById('submit_refund').addEventListener('click', function () {
                    document.getElementById('submit_refund').style.display = 'none';
                    document.getElementById('processing_message').style.display = 'block';

                    const formData = {
                        quoteid: quoteid,
                        adjustment_type: 'refund',
                        category: document.getElementById('refund_category').value,
                        product: document.getElementById('refund_product_select').value,
                        refund_amount: document.getElementById('refund_amount').value,
                        refund_reason: document.getElementById('refund_reason').value,
                        pax_deduction: document.getElementById('pax_deduction').value,
                        reduction_category: document.getElementById('reduction_category').value,
                        reference_email_id: document.getElementById('reference_email_id').value
                    };

                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_invoice_adjust.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            const response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                alert('Refund processed successfully!');
                                document.getElementById('refund_form').reset();
                                window.location.reload();
                            } else {
                                alert('Failed to process refund: ' + response.error);
                            }
                        } else {
                            alert('An error occurred: ' + xhr.statusText);
                        }
                    };

                    const urlEncodedData = Object.keys(formData)
                        .map(key => encodeURIComponent(key) + '=' + encodeURIComponent(formData[key]))
                        .join('&');

                    xhr.send(urlEncodedData);
                });

                function loadProductsByCategory2() {
                    var category = document.getElementById("refund_category").value;
                    var quoteid = "<?php echo $quoteid; ?>";
                    if (category) {
                        var xhr = new XMLHttpRequest();
                        xhr.open("GET", "ajax_fetch_adjust_products.php?category=" + category + "&quoteid=" + quoteid, true);
                        xhr.onload = function() {
                            if (xhr.status === 200) {
                                var products = JSON.parse(xhr.responseText);
                                var productSelect = document.getElementById("refund_product_select");
                                productSelect.innerHTML = '<option value="">Select Product</option>';
                                
                                productSelect.dataset.products = JSON.stringify(products);
                                
                                products.forEach(function(product) {
                                    var optionText = 'Day ' + product.day + ': ' + product.name;
                                    var option = document.createElement("option");
                                    option.value = product.sequence_no;
                                    option.dataset.price = product.sale_price;
                                    option.textContent = optionText;
                                    productSelect.appendChild(option);
                                });
                            } else {
                                alert("Error fetching products.");
                            }
                        };
                        xhr.send();
                    }
                }

                function updateProductPrice() {
                    var productSelect = document.getElementById("refund_product_select");
                    var selectedOption = productSelect.options[productSelect.selectedIndex];
                    var productPriceInput = document.getElementById("product_price_each");
                    productPriceInput.value = selectedOption.dataset.price || "";
                }

                function calculateRefundAmount() {
                    var paxDeduction = document.getElementById("pax_deduction").value;
                    var productPrice = document.getElementById("product_price_each").value;
                    var refundAmount = document.getElementById("refund_amount");
                    
                    if (paxDeduction && productPrice) {
                        refundAmount.value = (parseFloat(paxDeduction) * parseFloat(productPrice)).toFixed(2);
                    } else {
                        refundAmount.value = "";
                    }
                }
            </script>

            <!-- Adjust: number of pax -->
            <div id="adjust_overall_pax" class="toggle-div" style="display: none;">
                <form id="adjust_overall_pax_form">
                    <table class="adjustment-table">
                        <tr>
                            <th>Adults</th>
                            <td>
                                <select name="adjustment_sign_adults" id="adjustment_sign_adults" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_adults" id="adjustment_amount_adults" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Children</th>
                            <td>
                                <select name="adjustment_sign_children" id="adjustment_sign_children" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_children" id="adjustment_amount_children" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Infants</th>
                            <td>
                                <select name="adjustment_sign_infants" id="adjustment_sign_infants" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_infants" id="adjustment_amount_infants" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Single Room</th>
                            <td>
                                <select name="adjustment_sign_single" id="adjustment_sign_single" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_single" id="adjustment_amount_single" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Double Room</th>
                            <td>
                                <select name="adjustment_sign_double" id="adjustment_sign_double" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_double" id="adjustment_amount_double" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <th>Triple Room</th>
                            <td>
                                <select name="adjustment_sign_triple" id="adjustment_sign_triple" style="width: 12%;" required>
                                    <option value="+">+</option>
                                    <option value="-">-</option>
                                </select>
                                <input type="number" name="adjustment_amount_triple" id="adjustment_amount_triple" style="width: 85%;" min="0" value="0" required />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <button type="button" id="submit_adjust_overall_pax" style="padding: 10px 20px;">Save Adjustment</button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
            <script>
                document.getElementById('submit_adjust_overall_pax').addEventListener('click', function () {
                    document.getElementById('adjust_overall_pax').style.display = 'none';
                    document.getElementById('processing_message').style.display = 'block';

                    const adultsSign = document.getElementById('adjustment_sign_adults').value;
                    const adultsAmount = parseInt(document.getElementById('adjustment_amount_adults').value) || 0;
                    const childrenSign = document.getElementById('adjustment_sign_children').value;
                    const childrenAmount = parseInt(document.getElementById('adjustment_amount_children').value) || 0;

                    const singleRoomSign = document.getElementById('adjustment_sign_single').value;
                    const singleRoomAmount = parseInt(document.getElementById('adjustment_amount_single').value) || 0;
                    const doubleRoomSign = document.getElementById('adjustment_sign_double').value;
                    const doubleRoomAmount = parseInt(document.getElementById('adjustment_amount_double').value) || 0;
                    const tripleRoomSign = document.getElementById('adjustment_sign_triple').value;
                    const tripleRoomAmount = parseInt(document.getElementById('adjustment_amount_triple').value) || 0;

                    // Apply signs to values
                    const totalAdults = adultsSign === "+" ? adultsAmount : -adultsAmount;
                    const totalChildren = childrenSign === "+" ? childrenAmount : -childrenAmount;

                    const totalSingleRooms = singleRoomSign === "+" ? singleRoomAmount : -singleRoomAmount;
                    const totalDoubleRooms = doubleRoomSign === "+" ? doubleRoomAmount : -doubleRoomAmount;
                    const totalTripleRooms = tripleRoomSign === "+" ? tripleRoomAmount : -tripleRoomAmount;

                    // Calculate total capacity and guests
                    const totalCapacity = totalSingleRooms + 2 * totalDoubleRooms + 3 * totalTripleRooms;
                    const totalGuests = totalAdults + totalChildren;

                    // Validate if total room capacity matches the total number of adults and children
                    if (totalCapacity !== totalGuests) {
                        alert(
                            `Total room capacity does not match the total number of adults and children.`
                        );
                        return;
                    }
                    
                    // Gather form data
                    const formData = {
                        quoteid: quoteid,
                        adjustment_type: 'adjust_overall_pax',
                        adults_sign: document.getElementById('adjustment_sign_adults').value,
                        adults_amount: document.getElementById('adjustment_amount_adults').value,
                        children_sign: document.getElementById('adjustment_sign_children').value,
                        children_amount: document.getElementById('adjustment_amount_children').value,
                        infants_sign: document.getElementById('adjustment_sign_infants').value,
                        infants_amount: document.getElementById('adjustment_amount_infants').value,
                        single_room_sign: document.getElementById('adjustment_sign_single').value,
                        single_room_amount: document.getElementById('adjustment_amount_single').value,
                        double_room_sign: document.getElementById('adjustment_sign_double').value,
                        double_room_amount: document.getElementById('adjustment_amount_double').value,
                        triple_room_sign: document.getElementById('adjustment_sign_triple').value,
                        triple_room_amount: document.getElementById('adjustment_amount_triple').value,
                    };

                    // Perform an AJAX POST request
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_invoice_adjust.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            const response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                alert('Overall Pax adjusted successfully!');
                                document.getElementById('adjust_overall_pax_form').reset();
                                const url = new URL(window.location.href);
                                const params = url.searchParams;

                                // Add or update the 'edit' parameter
                                params.set('edit', 'adjustment');

                                // Redirect to the updated URL
                                window.location.href = url.toString();
                            } else {
                                alert('Failed to adjust pax: ' + response.error);
                            }
                        } else {
                            alert('An error occurred: ' + xhr.statusText);
                        }
                    };

                    // Serialize form data for x-www-form-urlencoded format
                    const urlEncodedData = Object.keys(formData)
                        .map(key => encodeURIComponent(key) + '=' + encodeURIComponent(formData[key]))
                        .join('&');

                    xhr.send(urlEncodedData);
                });
            </script>

            <div id="processing_message" style="display: none; text-align: center; margin-top: 20px;">
                <p>Processing... Please wait.</p>
            </div>
        </div>
        <script>
            function showAdjustDiv(selectedValue) {
                // Hide all divs inside div7
                const allDivs = document.querySelectorAll('#div7 .toggle-div');
                allDivs.forEach(div => div.style.display = 'none');

                // Show the selected div
                if (selectedValue) {
                    const selectedDiv = document.getElementById(selectedValue);
                    if (selectedDiv) {
                        selectedDiv.style.display = 'block';
                    }
                }
            }
        </script>

        <div id="div8" class="content-div">
            <h2 style="margin: 10px 25%; padding: 10px;">Invoice Adjustment History
                <?php if ($ref_quote_no == '') : ?>
                <button type="button" style="padding: 10px 20px; margin-left: 5px;" onclick="toggleDivs78()">Add</button>
                <?php endif; ?>
            </h2>
            <?php
            $sql_adjust_history = "SELECT auto_id, details, created_at, created_by, voided FROM vtiger_invoice_adjustment_history WHERE quoteid='$quoteid' ORDER BY created_at DESC;";
            $result_adjust_history = mysqli_query($conn, $sql_adjust_history);
            ?>

            <table class="adjustment-table">
                <tr>
                    <th>Time</th>
                    <td></td>
                </tr>
                <?php if (mysqli_num_rows($result_adjust_history) > 0): ?>
                    <?php while ($row_adjust_history = mysqli_fetch_assoc($result_adjust_history)): ?>
                        <tr <?= ($row_adjust_history['voided'] == 1) ? 'style="background-color: #f8d7da;"' : ''; ?>>
                            <td>
                                <?= htmlspecialchars($row_adjust_history['created_at']); ?>  
                                <?= !empty($row_adjust_history['created_by']) ? 'by' : '' ?>
                                <?= htmlspecialchars($row_adjust_history['created_by']); ?><br><br>

                                <?php if ($row_adjust_history['voided'] == 1): ?>
                                    <div style="display: inline-flex; align-items: center; justify-content: center; width: 100px; height: 100px; border: 3px solid red; border-radius: 50%; color: red; font-weight: bold; font-family: sans-serif;">Voided</div>
                                <?php elseif ($title == 'admin'): ?>
                                    <button class="revert-btn" data-id="<?= $row_adjust_history['auto_id']; ?>" style="background-color: orange;"><i class="fa-solid fa-clock-rotate-left" title="Void"></i></button>
                                <?php endif; ?>
                            </td>
                            <td><?= nl2br(htmlspecialchars($row_adjust_history['details'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="2">No adjustment history available.</td>
                    </tr>
                <?php endif; ?>
            </table>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                document.querySelectorAll('.revert-btn').forEach(function (btn) {
                    btn.addEventListener('click', function () {
                        const autoId = this.dataset.id;
                        if (confirm("Are you sure you want to revert this adjustment?")) {
                            fetch('ajax_revert_adjustment.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: 'auto_id=' + encodeURIComponent(autoId)
                            })
                            .then(response => response.json())
                            .then(data => {
                                if (data.success) {
                                    alert('Adjustment reverted successfully.');
                                    location.reload();
                                } else {
                                    alert('Error: ' + data.error);
                                }
                            })
                            .catch(error => {
                                alert('AJAX error: ' + error);
                            });
                        }
                    });
                });
            });
        </script>

        <script>
            function toggleDivs78() {
                const div7 = document.getElementById('div7');
                const div8 = document.getElementById('div8');

                if (div7.style.display === 'none') {
                    div7.style.display = 'block';
                    div8.style.display = 'none';
                } else {
                    div7.style.display = 'none';
                    div8.style.display = 'block';
                }
            }
        </script>

        <style>
            .adjustment-table {
                width: 50%;
                margin: 20px auto;
                border-collapse: collapse;
                border: 1px solid #ddd;
            }

            .adjustment-table td, .adjustment-table th {
                padding: 12px;
                border: 1px solid #ddd;
                vertical-align: top;
            }

            .adjustment-table th {
                text-align: left;
                font-weight: bold;
                width: 30%;
            }

            .adjustment-container {
                margin-bottom: 20px;
            }

            .adjustment-container h2 {
                text-align: center;
                color: #333;
            }
        </style>

        <script>
            function checkPaymentDeadlineWarning() {
                var quoteStage = document.getElementById('quote_stage').value;
                var paymentDeadline = document.getElementById('payment_deadline').value;
                var warningDiv = document.getElementById('deadline-warning');

                if ((quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') && paymentDeadline) {
                    var travel = new Date("<?= $date_of_travel ?>");
                    var deadlineDate = new Date(paymentDeadline);
                    var diffTime = travel - deadlineDate;
                    var diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)); // Difference in days

                    if (diffDays <= 15) {
                        document.getElementById('payment_deadline_pending').value = 1;
                        warningDiv.style.display = 'block';
                        warningDiv.innerHTML = "<i class='fa-solid fa-triangle-exclamation'></i> You may be responsible for the loss if Payment-Cancellation Deadline is set within 15 days.<br><i class='fa-solid fa-triangle-exclamation'></i> Please check with your admin.";
                        return;
                    }
                }

                document.getElementById('payment_deadline_pending').value = 0;
                warningDiv.style.display = 'none';
                warningDiv.innerHTML  = '';
            }

            document.getElementById('quote_stage').addEventListener('change', function () {
                var quoteStage = this.value;
                var today = new Date();

                if (quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') {
                    document.getElementById('accepted_date').value = today.toISOString().split('T')[0];
                    document.getElementById('payment_deadline').required = true;

                    // Calculate 15 days before date_of_travel
                    var dateOfTravel = new Date("<?php echo $date_of_travel; ?>");
                    var paymentDeadline = new Date(dateOfTravel);
                    paymentDeadline.setDate(paymentDeadline.getDate() - 35);

                    // If 35 days before is in the past, set paymentDeadline to tomorrow
                    if (paymentDeadline < today) {
                        paymentDeadline = new Date();
                        paymentDeadline.setDate(today.getDate() + 1);
                    }

                    // Format paymentDeadline as YYYY-MM-DD
                    var year = paymentDeadline.getFullYear();
                    var month = String(paymentDeadline.getMonth() + 1).padStart(2, '0');
                    var day = String(paymentDeadline.getDate()).padStart(2, '0');
                    var formattedDeadline = `${year}-${month}-${day}`;

                    // Set the payment_deadline value
                    document.getElementById('payment_deadline').value = formattedDeadline;
                } else if (quoteStage === 'Created') {
                    document.getElementById('accepted_date').value = '';
                    document.getElementById('payment_deadline').required = false;
                } else {
                    document.getElementById('payment_deadline').required = false;
                }

                checkPaymentDeadlineWarning();
            });

            document.getElementById('payment_deadline').addEventListener('change', function () {
                checkPaymentDeadlineWarning();
            });
        </script>

        <div id="div9" class="content-div">
            <?php
            $sql = "SELECT *
                    FROM vtiger_payment_history
                    WHERE quoteid='$quoteid'
                    ORDER BY added_on ASC;";
            $result = $conn->query($sql);
            $initial_amount = 0;
            $total_amount = 0;
            $trams_received_amount = 0;

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    if (isset($row['total_amount']) && !empty($row['total_amount'])) {
                        if (isset($row['source']) && $row['source'] == 'initial') {
                            $initial_amount = (float) $row['total_amount'];
                        }
                        if (isset($row['source']) && $row['source'] == 'final') {
                            $total_amount = (float) $row['total_amount'];
                        }
                    }
                    if (isset($row['trams_received_amount']) && !empty($row['trams_received_amount'])) {
                        $trams_received_amount += (float) $row['trams_received_amount'];
                    }
                }
                $result->data_seek(0);
            }

            if($initial_amount > 0) {
                $initial_amount -= 30;
            }

            if($total_amount == 0) {
                $total_amount = $initial_amount;
            }
            ?>
            <div class="table-wrapper">
                <p>Initial Invoice Amount: $ <?php echo number_format($initial_amount, 2); ?></p>
                <p>Amount Received: $ <?php echo number_format($trams_received_amount, 2); ?></p>
                <p><a href="?opt=summary&quoteNumber=<?php echo $quote_number; ?>&edit=adjustment">Adjust Amount</a>: $ <?php echo number_format($total_amount-$initial_amount, 2); ?></p>
                <p>Final Invoice Balance: $ <?php echo number_format($total_amount - $trams_received_amount, 2); ?></p>
            </div>

            <?php if ($title == 'admin' || $title == 'account'): ?>
                <?php if ($ref_quote_no == '') : ?>
                <button type="button" style="padding: 10px 20px; margin-left: 20px;" onclick="toggleDivs910()">Add Payment</button>
                <?php endif; ?>
            <?php endif; ?>

            <div class="table-container" style="width: 100%; margin: auto;">
                <div class="table-wrapper">
                    <table border="1" style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <th>Process Date</th>
                            <th>Payment Type</th>
                            <th>Received Amount</th>
                            <th>Reference No</th>
                            <th>Remarks</th>
                            <th>Payment Method</th>
                            <th></th>
                        </tr>
                        <?php if ($result->num_rows > 0) : ?>
                            <?php while ($row = $result->fetch_assoc()) :
                                if (!isset($row['trams_received_amount']) || $row['trams_received_amount'] == '') {
                                    continue;
                                }
                            ?>
                                <tr id="row-<?php echo $row['auto_id']; ?>">
                                    <td><?php echo $row['process_date']; ?></td>
                                    <td><?php echo $row['pay_type']; ?></td>
                                    <td>$ <?php echo $row['trams_received_amount']; ?></td>
                                    <td><?php echo $row['reference_no']; ?></td>
                                    <td><?php echo $row['trams_remarks']; ?></td>
                                    <td><?php echo $row['payment_method']; ?></td>
                                    <td>
                                        <button class="delete-btn" style='border: unset; background-color: unset;' data-id="<?php echo $row['auto_id']; ?>"><i class='fa-solid fa-trash-can' style='color: red;'></i></button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="7">No records found</td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function () {
                $('.delete-btn').on('click', function () {
                    var autoId = $(this).data('id');
                    var rowId = '#row-' + autoId;

                    if (confirm('Are you sure you want to delete this record?')) {
                        $.ajax({
                            url: 'ajax_delete_payment.php', // Endpoint to handle deletion
                            type: 'POST',
                            data: { auto_id: autoId },
                            success: function (response) {
                                if (response === 'success') {
                                    $(rowId).remove();
                                    alert('Record deleted successfully.');
                                } else {
                                    alert('Failed to delete the record. Please try again.');
                                }
                            },
                            error: function () {
                                alert('An error occurred while processing the request.');
                            }
                        });
                    }
                });
            });
        </script>

        <div id="div10" class="content-div" style="display: none;">
            <h2 style="margin: 10px 25%; padding: 20px;">
                Add New Payment <a href="?opt=import-payment">[Bulk Import]</a>
            </h2>
            <form method="POST" action="">
                <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
                <div class="table-container" style="width: 50%; margin: auto;">
                    <div class="table-wrapper">
                        <table class="operation-table" style="width: 100%; margin: auto; border-collapse: collapse; border: 1px solid #ddd; padding: 20px;">
                            <tr>
                                <td><label for="process_date">Process Date:</label></td>
                                <td><input type="date" id="process_date" name="process_date" required></td>
                            </tr>
                            <tr>
                                <td><label for="pay_type">Payment Type:</label></td>
                                <td><input type="text" id="pay_type" name="pay_type"></td>
                            </tr>
                            <tr>
                                <td><label for="received_amount">Received Amount:</label></td>
                                <td><input type="number" id="received_amount" name="received_amount" step="0.01" required></td>
                            </tr>
                            <tr>
                                <td><label for="reference_no">Reference No:</label></td>
                                <td><input type="text" id="reference_no" name="reference_no"></td>
                            </tr>
                            <tr>
                                <td><label for="remarks">Remarks:</label></td>
                                <td><textarea id="remarks" name="remarks" rows="4"></textarea></td>
                            </tr>
                            <tr>
                                <td><label for="payment_method">Payment Method:</label></td>
                                <td>
                                    <select id="payment_method" name="payment_method" style="width: 100%; height: 30px; margin: 0;">
                                        <option value="12">12 CBA</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: center;">
                                    <button type="submit" style="padding: 10px 20px;" name="add-payment">Save</button>
                                    <button type="button" style="padding: 10px 20px; margin-left: 5px;" onclick="toggleDivs910()">Cancel</button>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </form>
        </div>

        <script>
            function toggleDivs910() {
                const div9 = document.getElementById('div9');
                const div10 = document.getElementById('div10');

                if (div9.style.display === 'none') {
                    div9.style.display = 'block';
                    div10.style.display = 'none';
                } else {
                    div9.style.display = 'none';
                    div10.style.display = 'block';
                }
            }
        </script>

        <?php
    }

    // if (isset($_GET['alert']) && $pax_no > 50) {
    //     echo "<script type='text/javascript'>alert('Please update Transfers price using calculator');</script>";
    // }

    if ($ref_quote_no) {
        ?>
        <div id="editHotelModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: center; z-index: 1000;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 50%; text-align: center; box-shadow: 0px 0px 10px rgba(0,0,0,0.3);">
                <h1 style="margin-bottom: 15px; color: red;">Quote is Deactived</h1>
                <h2 style="margin-bottom: 15px;">Please Edit in 
                    <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($ref_quote_no); ?>">
                        <?= htmlspecialchars($ref_quote_no); ?>
                    </a>
                </h2>
                <button onclick="document.getElementById('editHotelModal').style.display='none';" 
                    style="background: #334155; color: white; border: none; padding: 10px 15px; border-radius: 5px; cursor: pointer;">
                    Close
                </button>
            </div>
        </div>
        <?php 
    } else if ($hotel_to_edit) {
        ?>
        <div id="editHotelModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: center; z-index: 1000;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 50%; text-align: center; box-shadow: 0px 0px 10px rgba(0,0,0,0.3);">
                <h1 style="margin-bottom: 15px;">Notice</h1>
                <h2 style="margin-bottom: 15px; color: red;">Hotel checkin checkout date is incomplete</h2>
                <h2 style="margin-bottom: 15px;">Please edit in Operation -> Hotel</h2>
                <button onclick="document.getElementById('editHotelModal').style.display='none';" 
                    style="background: #334155; color: white; border: none; padding: 10px 15px; border-radius: 5px; cursor: pointer;">
                    Close
                </button>
            </div>
        </div>
        <?php 
    } 
    ?>

    <script>
        // Get the popup
        var popup = document.getElementById("popupForm-range");
        
        // Get the button that opens the popup
        var btn = document.getElementById("openPopup");
        
        // Get the <span> element that closes the popup
        var span = document.getElementsByClassName("close1")[0];
        
        // When the user clicks the button, open the popup 
        btn.onclick = function() {
            popup.style.display = "block";
        }
        
        // When the user clicks on <span> (x), close the popup
        span.onclick = function() {
            popup.style.display = "none";
        }
        
        // When the user clicks anywhere outside of the popup, close it
        window.onclick = function(event) {
            if (event.target == popup) {
                popup.style.display = "none";
            }
        }

    </script>
    
    <style>
        /* Popup container */
        .popup {
            display: none; /* Hidden by default */
            position: fixed;
            z-index: 1; /* Sit on top */
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto; /* Enable scroll if needed */
            background-color: rgba(0, 0, 0, 0.4); /* Black w/ opacity */
        }
        
        /* Popup content */
        .popup-content {
            background-color: #fefefe;
            margin: 15% auto; /* 15% from the top and centered */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* Could be more or less, depending on screen size */
        }
        
        /* The close button */
        .close, .close1 {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        
        .close:hover, 
        .close1:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

    </style>
    
    <!-- markup -->
    <div id="div2" class="content-div" style='width: 80%; margin: auto;'>
        <?php
        if(mysqli_num_rows($result_new_quote_check) > 0) {
            // Total price for each category (except Transfers)
            $pricing_data = getPricingDetails($conn, $quoteid);
            if($pricing_data) {
                $pricing_attraction = $pricing_data['Attraction']['adult'];
                $pricing_attraction_child = $pricing_data['Attraction']['child'];
                $pricing_attraction_infant = $pricing_data['Attraction']['infant'];

                $pricing_sic = $pricing_data['SIC']['adult'];
                $pricing_sic_child = $pricing_data['SIC']['child'];
                $pricing_sic_infant = $pricing_data['SIC']['infant'];

                $pricing_single = $pricing_data['Hotel']['single'];
                $pricing_double = $pricing_data['Hotel']['double'];
                $pricing_triple = $pricing_data['Hotel']['triple'];
                $pricing_child_with_bed = $pricing_data['Hotel']['child_with_bed'];
                $pricing_child_no_bed = $pricing_data['Hotel']['child_no_bed'];

                $pricing_restaurant = $pricing_data['Restaurant']['adult'];
                $pricing_restaurant_child = $pricing_data['Restaurant']['child'];
                $pricing_restaurant_infant = $pricing_data['Restaurant']['infant'];

                $pricing_transfers = $pricing_data['Transfers']['adult'];
                $pricing_guide = $pricing_data['Guide']['adult'];

                $pricing_tour = $pricing_data['Tour']['adult'];
                $pricing_tour_child = $pricing_data['Tour']['child'];
                $pricing_tour_infant = $pricing_data['Tour']['infant'];
            }

            if(substr($quote_number, -1) === 'G') {
                $quote_type_mup = 'Group';
            } else {
                $quote_type_mup = 'FIT';
            }
            
            $fixed_sum_th = '<th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Hotel">Hotel</a></th>
                            <th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Attraction">Attraction</a></th>
                            <th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Restaurant">Restaurant</a></th>
                            <th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Tour">Tour</a></th>
                            <th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=SIC">SIC</a></th>
                            <th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Guide">Guide</a></th>';
            $fixed_sum_td = '';
            $fixed_sum_td .= '<td>' . 
                            'Single Room: $' . $pricing_single . '<br>' .
                            'Double Room: $' . $pricing_double . '<br>' .
                            'Triple Room: $' . $pricing_triple . '<br>' .
                            'Child with Bed: $' . $pricing_child_with_bed . '<br>' .
                            'Child No Bed: $' . $pricing_child_no_bed . 
                            '</td>';
            $fixed_sum_td .= '<td>' . 
                            'Adult: $' . $pricing_attraction . '<br><br>' .
                            'Child: $' . $pricing_attraction_child . '<br><br>' .
                            'Infant: $' . $pricing_attraction_infant .
                            '</td>';
            $fixed_sum_td .= '<td>' . 
                            'Adult: $' . $pricing_restaurant . '<br><br>' .
                            'Child: $' . $pricing_restaurant_child . '<br><br>' .
                            'Infant: $' . $pricing_restaurant_infant .
                            '</td>';
            $fixed_sum_td .= '<td>' . 
                            'Adult: $' . $pricing_tour . '<br><br>' .
                            'Child: $' . $pricing_tour_child . '<br><br>' .
                            'Infant: $' . $pricing_tour_infant .
                            '</td>';
            $fixed_sum_td .= '<td>' . 
                            'Adult: $' . $pricing_sic . '<br><br>' .
                            'Child: $' . $pricing_sic_child . '<br><br>' .
                            'Infant: $' . $pricing_sic_infant .
                            '</td>';
        
            // pricing - Transfers
            $mode_sql = '=0';
            if($mode == 'group') {
                $mode_sql = '>1';
            }
            $sql_group_sum = "SELECT vps.subquoteid, SUM(vps.sale_price) AS total_sale_price, MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                            FROM vtiger_products_saleprice vps
                            WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                            GROUP BY vps.subquoteid
                            ORDER BY pax_min ASC;";
            $result_group_sum = mysqli_query($conn, $sql_group_sum);

            $total_double_cost = '';
            ?>
            <div style="border: 1px solid black; border-collapse: collapse; padding: 10px; margin: 10px; <?= $global_pricing_access != 1 ? 'display: none;' : '' ?>"><form method="post" action="">
                <h2 style="margin: 10px; text-align: center;">Subtotal and Markup per person</h2>
                <table class="styled-table">
                    <?php
                    $title_th = "<th style='width:30%'>Slabs based on minimum number of travelling passengers</th>";
                    $highlight_pax_range = '';

                    if (mysqli_num_rows($result_group_sum) > 0) {
                        $transfers_th = '<th><a href="quote.php?opt=summary&quoteNumber=' . $quote_number . '&cf_928=Transfers">Transfers</a></th><th>MUP</th>';
                        echo '<tr>' . $title_th . $fixed_sum_th . $transfers_th . '</tr>';

                        $pax_no_pax_range = $pax_no;
                        while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
                            if($mode == 'group') {
                                $highlight_pax_range = '';
                                if ($row_group_sum['pax_min'] <= $pax_no_pax_range && $pax_no_pax_range <= $row_group_sum['pax_max']) {
                                    $highlight_pax_range = 'style="background-color: lightyellow;"';
                                    $pax_no_fall_in_range = $row_group_sum['pax_min'];
                                    $subquoteid_supplier = $row_group_sum['subquoteid'];
                                    $pricing_transfers_total = ceil((float) $row_group_sum['total_sale_price'] / $row_group_sum['pax_min']) * $pax_no_pax_range;
                                }
                                $pax_no = $row_group_sum['pax_min'];
                                $title_td = "<td>Minimum " . $row_group_sum['pax_min'] . " - " . $row_group_sum['pax_max'] . " paying travelling passengers</td>";
                                $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $row_group_sum['pax_max']);
                            }
                            else {
                                $title_td = "<td>Based on " . $pax_no . " travelling passengers</td>";
                                $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $pax_no);
                            }

                            if(!isset($pax_no) || $pax_no == 0) {
                                $pax_no = 1;
                            }
                            $transfers_td = '<td>' . 
                                            '$' . ceil($pricing_guide / $pax_no) .
                                            '</td>';
                            $pricing_transfers = $row_group_sum['total_sale_price'];
                            $transfers_td .= '<td>$' . ceil($pricing_transfers / $pax_no) . '</td>';

                            if($quote_type_mup == 'FIT') {
                                if($country == 'Australia') {
                                    $markup_td = '<td>' . $markups['markup1'] . '%</td>';
                                    $markup_percent = (float) $markups['markup1'] / 100 + 1;
                                } else {
                                    $markup_td = '<td>' . $markups['markup2'] . '%</td>';
                                    $markup_percent = (float) $markups['markup2'] / 100 + 1;
                                }
                            } else {
                                if($markups['markup_type'] == 'ratio') {
                                    $markup_td = '<td>Adult: ' . $markups['markup1'] . '%<br><br>';
                                    $markup_td .= 'Child: ' . $markups['markup2'] . '%</td>';
                                    $markup_amt_adult = $markups['markup1'] / 100 + 1;
                                    $markup_amt_child = $markups['markup2'] / 100 + 1;
                                } else {
                                    $markup_td = '<td>Adult: $' . $markups['markup1'] . '<br><br>';
                                    $markup_td .= 'Child: $' . $markups['markup2'] . '</td>';
                                    $markup_amt_adult = $markups['markup1'];
                                    $markup_amt_child = $markups['markup2'];
                                }
                            }
                            $pricing = getQuotePricing($conn, $quoteid, $pax_no);
                            $single_room = $pricing['single_room'];
                            $double_room = $pricing['double_room'];
                            $triple_room = $pricing['triple_room'];
                            $child_with_bed = $pricing['child_with_bed'];
                            $child_no_bed = $pricing['child_no_bed'];
                            $infant = $pricing['infant'];

                            $total_double_cost .= '<tr ' . $highlight_pax_range . '>' . $title_td . '<td>$ ' . $single_room . '</td><td>$ ' . $double_room . '</td><td>$ ' . $triple_room . '</td><td>$ ' . $child_with_bed . '</td><td>$ ' . $child_no_bed . '</td><td>$ ' . $infant . '</td>' . '<td>$ ' . $extra_mup . '</td>' . '</tr>';

                            echo '<tr ' . $highlight_pax_range . '>' . $title_td . $fixed_sum_td . $transfers_td . $markup_td . '</tr>';
                        }
                    } else {
                        $transfers_th = '<th>MUP</th>';
                        echo '<tr>' . $title_th . $fixed_sum_th . $transfers_th . '</tr>';
                        $title_td = "<td>1 paying travelling passengers</td>";
                        $transfers_td = '<td>' . 
                                        '$' . ceil($pricing_guide / $pax_no) .
                                        '</td>';
                        
                        $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $pax_no);
                        if($quote_type_mup == 'FIT') {
                            if($country == 'Australia') {
                                $markup_td = '<td>' . $markups['markup1'] . '%</td>';
                                $markup_percent = (float) $markups['markup1'] / 100 + 1;
                            } else {
                                $markup_td = '<td>' . $markups['markup2'] . '%</td>';
                                $markup_percent = (float) $markups['markup2'] / 100 + 1;
                            }
                        } else {
                            if($markups['markup_type'] == 'ratio') {
                                $markup_td = '<td>Adult: ' . $markups['markup1'] . '%<br><br>';
                                $markup_td .= 'Child: ' . $markups['markup2'] . '%</td>';
                                $markup_amt_adult = $markups['markup1'] / 100 + 1;
                                $markup_amt_child = $markups['markup2'] / 100 + 1;
                            } else {
                                $markup_td = '<td>Adult: $' . $markups['markup1'] . '<br><br>';
                                $markup_td .= 'Child: $' . $markups['markup2'] . '</td>';
                                $markup_amt_adult = $markups['markup1'];
                                $markup_amt_child = $markups['markup2'];
                            }
                        }
                        $pricing = getQuotePricing($conn, $quoteid, $pax_no);
                        $single_room = $pricing['single_room'];
                        $double_room = $pricing['double_room'];
                        $triple_room = $pricing['triple_room'];
                        $child_with_bed = $pricing['child_with_bed'];
                        $child_no_bed = $pricing['child_no_bed'];
                        $infant = $pricing['infant'];

                        $total_double_cost .= '<tr ' . $highlight_pax_range . '>' . $title_td . '<td>$ ' . $single_room . '</td><td>$ ' . $double_room . '</td><td>$ ' . $triple_room . '</td><td>$ ' . $child_with_bed . '</td><td>$ ' . $child_no_bed . '</td><td>$ ' . $infant . '</td>' . '<td>$ ' . $extra_mup . '</td>' . '</tr>';

                        echo '<tr ' . $highlight_pax_range . '>' . $title_td . $fixed_sum_td . $transfers_td . $markup_td . '</tr>';
                    }
                    ?>
                </table>
                <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
            </form></div>
            <div style="border: 1px solid black; border-collapse: collapse; padding: 10px; margin: 10px; margin-top: 20px;">
                <table class="styled-table">
                    <h2 style="margin: 10px; text-align: center;">Total Pricing per person</h2>
                    <tr>
                        <th style="width: 30%;"></th>
                        <th>Adult Single Room</th>
                        <th>Adult Double Room</th>
                        <th>Adult Triple Room</th>
                        <th>Child with Bed</th>
                        <th>Child No Bed</th>
                        <th>Infant</th>
                        <th>Extra MUP <button type="button" id="editMupBtn"><i class="fa-solid fa-pencil"></i></button></th>
                    </tr>
                    <?php echo $total_double_cost; ?>
                </table>
            </div>
            <div style="border: 1px solid black; padding: 10px; margin: 10px; margin-top: 20px;">
                <h2 style="text-align: center;">Invoice Preview</h2>
                <table class="styled-table" style="width: 100%; border-collapse: collapse; text-align: right;">
                    <thead>
                        <tr style="border-bottom: 2px solid black;">
                            <th style="text-align: left; padding: 10px;"></th>
                            <th style="padding: 10px;">Unit Price</th>
                            <th style="padding: 10px;">Quantity</th>
                            <th style="padding: 10px;">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        if($pax_no_fall_in_range) {
                            $pricing = getQuotePricing($conn, $quoteid, $pax_no_fall_in_range);
                            $single_room = $pricing['single_room'];
                            $double_room = $pricing['double_room'];
                            $triple_room = $pricing['triple_room'];
                            $child_with_bed = $pricing['child_with_bed'];
                            $child_no_bed = $pricing['child_no_bed'];
                            $infant = $pricing['infant'];
                        }
                        
                        $total_amount_invoice = 0;

                        if ($single_rooms1 > 0) {
                            $totalsub = $single_room * $single_rooms1;
                            $total_amount_invoice += $totalsub;
                            echo "<tr>
                                    <td style='text-align: left; padding: 10px;'>Package Cost Per Adult on Single Occupancy</td>
                                    <td>\$ {$single_room}</td>
                                    <td>{$single_rooms1}</td>
                                    <td>\$ {$totalsub}</td>
                                </tr>";
                        }

                        if ($double_rooms1 > 0) {
                            $totalsub = $double_room * $double_rooms1 * 2;
                            $total_amount_invoice += $totalsub;
                            echo "<tr>
                                    <td style='text-align: left; padding: 10px;'>Package Cost Per Adult on Double Occupancy</td>
                                    <td>\$ {$double_room}</td>
                                    <td>" . ($double_rooms1 * 2) . "</td>
                                    <td>\$ {$totalsub}</td>
                                </tr>";
                        }

                        if ($triple_rooms1 > 0) {
                            $totalsub = $triple_room * ($triple_rooms1*3-($children_no-$child_without_bed));
                            $total_amount_invoice += $totalsub;
                            echo "<tr>
                                    <td style='text-align: left; padding: 10px;'>Package Cost Per Adult on Triple Occupancy</td>
                                    <td>\$ {$triple_room}</td>
                                    <td>" . ($triple_rooms1*3-($children_no-$child_without_bed)) . "</td>
                                    <td>\$ {$totalsub}</td>
                                </tr>";
                        }

                        if ($single_rooms1 == 0 && $double_rooms1 == 0 && $triple_rooms1 == 0) {
                            if ($adults_no > 0) {
                                $totalsub = $single_room * $adults_no;
                                $total_amount_invoice += $totalsub;
                                echo "<tr>
                                        <td style='text-align: left; padding: 10px;'>Package Cost Per Adult No Hotel</td>
                                        <td>\$ {$single_room}</td>
                                        <td>{$adults_no}</td>
                                        <td>\$ {$totalsub}</td>
                                    </tr>";
                            }

                            if ($children_no > 0) {
                                $totalsub = $child_no_bed * $children_no;
                                $total_amount_invoice += $totalsub;
                                echo "<tr>
                                        <td style='text-align: left; padding: 10px;'>Package Cost Per Child No Hotel</td>
                                        <td>\$ {$child_no_bed}</td>
                                        <td>{$children_no}</td>
                                        <td>\$ {$totalsub}</td>
                                    </tr>";
                            }
                        } else {
                            if (($children_no-$child_without_bed) > 0) {
                                $totalsub = ($children_no-$child_without_bed) * $child_with_bed;
                                $total_amount_invoice += $totalsub;
                                echo "<tr>
                                        <td style='text-align: left; padding: 10px;'>Package Cost Per Child with Bed</td>
                                        <td>\$ {$child_with_bed}</td>
                                        <td>" . ($children_no-$child_without_bed) . "</td>
                                        <td>\$ {$totalsub}</td>
                                    </tr>";
                            }

                            if ($child_without_bed > 0) {
                                $totalsub = $child_no_bed * $child_without_bed;
                                $total_amount_invoice += $totalsub;
                                echo "<tr>
                                        <td style='text-align: left; padding: 10px;'>Package Cost Per Child without Bed</td>
                                        <td>\$ {$child_no_bed}</td>
                                        <td>{$child_without_bed}</td>
                                        <td>\$ {$totalsub}</td>
                                    </tr>";
                            }
                        }

                        if ($infants_no > 0) {
                            $totalsub = $infant * $infants_no;
                            $total_amount_invoice += $totalsub;
                            echo "<tr>
                                    <td style='text-align: left; padding: 10px;'>Package Cost Per Infant</td>
                                    <td>\$ {$infant}</td>
                                    <td>{$infants_no}</td>
                                    <td>\$ {$totalsub}</td>
                                </tr>";
                        }

                        if($adjust_total_amount > 0) {
                            echo "<tr>
                                    <td style='text-align: left; padding: 10px;'>Adjustments</td>
                                    <td></td>
                                    <td></td>
                                    <td>{$adjust_total_amount}</td>
                                </tr>";
                        }

                        ?>
                        <tr style="border-top: 2px solid black; font-weight: bold;">
                            <td colspan="3" style="text-align: right; padding: 10px;">Total Amount</td>
                            <td style="padding: 10px;">$ <?= $total_amount_invoice + $adjust_total_amount ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <?php 
            if(true) {
                if($mode == 'group') {
                    $pricing_transfers = $pricing_transfers_total;
                } else {
                    $pricing_guide = ceil($pricing_guide / $pax_no) * $pax_no;
                    $pricing_transfers = ceil($pricing_transfers / $pax_no) * $pax_no;
                }
                ?>
                <div style="border: 1px solid black; border-collapse: collapse; padding: 10px; margin: 10px; margin-top: 20px; <?= $global_pricing_access != 1 ? 'display: none;' : '' ?>">
                    <table class="styled-table">
                        <h2 style="margin: 10px; text-align: center;">Quote Price</h2>
                        <tr>
                            <th>Hotel</th>
                            <th>Attraction</th>
                            <th>Restaurant</th>
                            <th>Tour</th>
                            <th>SIC</th>
                            <th>Guide</th>
                            <th>Transfers</th>
                            <th>Adjustment</th>
                            <th>Infant</th>
                            <th>Markup</th>
                            <th>Total</th>
                        </tr>
                        <?php
                        $hotel_quote_total = $single_rooms1*$pricing_single + $double_rooms1*$pricing_double*2 + ($triple_rooms1*3-($children_no-$child_without_bed))*$pricing_triple + $child_without_bed*$pricing_child_no_bed + ($children_no-$child_without_bed)*$pricing_child_with_bed;
                        ?>
                        <tr>
                            <td>$<?= ceil($hotel_quote_total) ?></td>
                            <td>$<?= ceil($adults_no*$pricing_attraction + $children_no*$pricing_attraction_child) ?></td>
                            <td>$<?= ceil($adults_no*$pricing_restaurant + $children_no*$pricing_restaurant_child) ?></td>
                            <td>$<?= ceil($adults_no*$pricing_tour + $children_no*$pricing_tour_child) ?></td>
                            <td>$<?= ceil($adults_no*$pricing_sic + $children_no*$pricing_sic_child) ?></td>
                            <td>$<?= $pricing_guide ?></td>
                            <td>$<?= $pricing_transfers ?></td>
                            <td>$<?= ceil($adjust_total_amount) ?></td>
                            <?php 
                            if($single_rooms1 == 0 && $double_rooms1 == 0 && $triple_rooms1 == 0) {
                                $quote_total = $single_room*$adults_no + $child_no_bed*$children_no + ceil($adjust_total_amount);
                            } else {
                                $quote_total = $single_room*$single_rooms1 + $double_room*$double_rooms1*2 + $triple_room*($triple_rooms1*3-($children_no-$child_without_bed)) + ($children_no-$child_without_bed)*$child_with_bed + $child_without_bed*$child_no_bed + ceil($adjust_total_amount);
                            }
                            $actual_quote_amount = $hotel_quote_total + $adults_no*$pricing_attraction + $children_no*$pricing_attraction_child + $adults_no*$pricing_restaurant + $children_no*$pricing_restaurant_child
                                                + $adults_no*$pricing_tour + $children_no*$pricing_tour_child + $adults_no*$pricing_sic + $children_no*$pricing_sic_child + $pricing_guide + $pricing_transfers + ceil($adjust_total_amount);
                            ?>
                            <td>$<?= $infant * $infants_no ?></td>
                            <td>$<?= $quote_total - $actual_quote_amount ?></td>
                            <td>$<?= $quote_total + $infant * $infants_no ?></td>
                        </tr>
                    </table>
                </div>
                <?php
            }
        }
        ?>
        <!-- Extra MUP Modal -->
        <div id="mupModal" style="display: none; position: absolute; background: white; border: 1px solid #ccc; padding: 10px; box-shadow: 0 2px 6px rgba(0,0,0,0.2); z-index: 1000;">
            <input type="number" id="mupAmount" min="0" step="0.01" style="max-width: 100px;" />
            <button type="button" id="confirmMup"><i class="fa-solid fa-check"></i></button>
        </div>
        <script>
            const quoteId = <?= json_encode($quoteid) ?>;

            // Show modal near the button
            $('#editMupBtn').on('click', function (e) {
                const $btn = $(this);
                const offset = $btn.offset();
                const btnWidth = $btn.outerWidth();
                const modalWidth = $('#mupModal').outerWidth();

                const top = offset.top + $btn.outerHeight() + 5; // below button
                const left = offset.left + (btnWidth / 2) - (modalWidth / 2); // center horizontally

                $('#mupModal').css({
                    top: top,
                    left: left,
                    position: 'absolute'
                }).fadeIn();
            });

            // Send data via AJAX
            $('#confirmMup').on('click', function () {
                const markup = $('#mupAmount').val();

                $.ajax({
                    url: 'ajax_update_extra_mup.php',
                    type: 'POST',
                    data: {
                        quoteid: quoteId,
                        markup: markup
                    },
                    success: function (response) {
                        alert('Markup updated successfully!');
                        $('#mupModal').fadeOut();
                        location.reload();
                    },
                    error: function () {
                        alert('Failed to update markup.');
                    }
                });
            });

            // Optional: click outside to close modal
            $(document).on('click', function(e) {
                if (!$(e.target).closest('#mupModal, #editMupBtn').length) {
                    $('#mupModal').fadeOut();
                }
            });
        </script>
    </div>

    <div id="div11" class="content-div" style="display: none;">
        <?php
        // SQL to fetch vendor and product details
        $sql_supplier = "SELECT DISTINCT vv.vendorName AS vendorname, vv.vendorid
                        FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
                        LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
                        LEFT JOIN tdu_products vp ON vi.productid = vp.productid
                        LEFT JOIN tdu_vendors vv ON vp.vendorid = vv.vendorid
                        ORDER BY vv.vendorname, vi.sequence_no ASC;";
        $result_supplier = mysqli_query($conn, $sql_supplier);
        ?>
        
        <h2 style="margin: 10px 25%; padding: 20px;">Make Payment to Supplier</h2>
        <form method="POST" action="">
            <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($quoteid); ?>">
            <div class="table-container" style="width: 50%; margin: auto;">
                <div class="table-wrapper">
                    <table class="operation-table" style="width: 100%; margin: auto; border-collapse: collapse; border: 1px solid #ddd; padding: 20px;">
                        <tr>
                            <td><label for="vendor">Select Vendor:</label></td>
                            <td>
                                <select id="vendor" name="vendor" required style="width: 100%;">
                                    <option value="" disabled selected>Select a vendor</option>
                                    <?php 
                                    // Initialize an array to keep track of added vendors
                                    $added_vendors = [];
                                    while ($row = mysqli_fetch_assoc($result_supplier)):
                                        // Check if the vendor is already added to avoid duplicates
                                        if (!in_array($row['vendorname'], $added_vendors)):
                                            $added_vendors[] = $row['vendorname']; // Track added vendor ID
                                        ?>
                                        <option value="<?php echo htmlspecialchars($row['vendorid']); ?>"><?php echo htmlspecialchars($row['vendorname']); ?></option>
                                        <?php 
                                        endif; 
                                    endwhile; 
                                    ?>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td><label for="process_date">Process Date:</label></td>
                            <td><input type="date" id="process_date" name="process_date" required></td>
                        </tr>
                        <tr>
                            <td><label for="pay_type">Payment Type:</label></td>
                            <td><input type="text" id="pay_type" name="pay_type"></td>
                        </tr>
                        <tr>
                            <td><label for="paid_amount">Paid Amount:</label></td>
                            <td><input type="number" id="paid_amount" name="paid_amount" step="0.01" required></td>
                        </tr>
                        <tr>
                            <td><label for="reference_no">Reference No:</label></td>
                            <td><input type="text" id="reference_no" name="reference_no"></td>
                        </tr>
                        <tr>
                            <td><label for="remarks">Remarks:</label></td>
                            <td><textarea id="remarks" name="remarks" rows="4"></textarea></td>
                        </tr>
                        <tr>
                            <td><label for="payment_method">Payment Method:</label></td>
                            <td>
                                <select id="payment_method" name="payment_method" style="width: 100%; height: 30px; margin: 0;">
                                    <option value="12">12 CBA</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <button type="submit" style="padding: 10px 20px;" name="supplier-payment">Save</button>
                                <button type="button" style="padding: 10px 20px; margin-left: 5px;" onclick="toggleDivs1112()">Cancel</button>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </form>
    </div>

    <!-- Payment to Supplier button switch -->
    <script>
        function toggleDivs1112() {
            const div11 = document.getElementById('div11');
            const div12 = document.getElementById('div12');

            if (div11.style.display === 'none') {
                div11.style.display = 'block';
                div12.style.display = 'none';
            } else {
                div11.style.display = 'none';
                div12.style.display = 'block';
            }
        }
    </script>
    
    <div id="div12" class="content-div" style="display: none;">
        <?php
            $invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'initial'";
            $invoice_initial_result = mysqli_query($conn, $invoice_initial_query);
            $invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
            $created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;
            if($created_at_query) {
                $created_at_query = " AND created_at < '$created_at_query' ";
            }
            else { 
                $created_at_query = "";
            }

            $sql_pax_no = "SELECT meta_key, meta_value 
                            FROM vtiger_itinerary 
                            WHERE quoteid = '$quoteid' 
                            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
                            AND (meta_key, created_at) IN (
                                SELECT meta_key, MAX(created_at)
                                FROM vtiger_itinerary
                                WHERE quoteid = '$quoteid' $created_at_query
                                AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
                                GROUP BY meta_key);";
            $result_pax_no = mysqli_query($conn, $sql_pax_no);

            $single_rooms = $double_rooms = $triple_rooms = $child_without_bed = 0;
            if(mysqli_num_rows($result_pax_no) > 0) {
                while($row_pax_no = mysqli_fetch_assoc($result_pax_no)) {
                    switch($row_pax_no['meta_key']) {
                        case 'single_rooms':
                            $single_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                        case 'double_rooms':
                            $double_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                        case 'triple_rooms':
                            $triple_rooms = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                        case 'child_without_bed':
                            $child_without_bed = (int)$row_pax_no['meta_value'] ?? 0;
                            break;
                    }
                }
            }

            // SQL to fetch vendor and product details
            $sql_supplier = "SELECT DISTINCT 
                                vq.adults, vq.children, vq.infants,
                                vv.vendorname, vv.vendorid, 
                                vi.productid, vi.day, vi.cf_928, vi.sequence_no, vi.checkin, vi.checkout,
                                vp.productname, 
                                vps.sale_price, vps.sale_price_child, vps.sale_price_infant, 
                                vps.sale_price_single, vps.sale_price_double, vps.sale_price_triple, 
                                vps.sale_price_child_with_bed, vps.sale_price_child_no_bed
                            FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
                            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
                            LEFT JOIN ( SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description FROM vtiger_products_custom
                                        UNION ALL
                                        SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description FROM tdu_products
                                        ) vp ON vi.productid = vp.productid
                            LEFT JOIN ( SELECT vendorid, vendorname FROM vtiger_vendor_custom
                                        UNION ALL
                                        SELECT vendorid, vendorName AS vendorname FROM tdu_vendors
                                        ) vv ON vi.vendorid=vv.vendorid
                            LEFT JOIN vtiger_products_saleprice vps ON vq.quoteid=vps.quoteid AND vi.sequence_no=vps.sequence_no AND (vps.subquoteid='1' OR vps.subquoteid='$subquoteid_supplier')
                            ORDER BY vv.vendorname ASC, vi.sequence_no ASC;";
            $result_supplier = mysqli_query($conn, $sql_supplier);
            $vendors = [];
            $vendor_totals = [];

            // Group products by vendor
            while ($row = mysqli_fetch_assoc($result_supplier)) {
                if($row['cf_928'] == 'Hotel') {
                    $total_sale_price_each = $single_rooms*(float)$row['sale_price_single'] 
                                            + $double_rooms*(float)$row['sale_price_double'] 
                                            + $triple_rooms*(float)$row['sale_price_triple']
                                            + $child_without_bed*(float)$row['sale_price_child_no_bed'];
                    
                    $checkin_date = new DateTime($row['checkin']);
                    $checkout_date = new DateTime($row['checkout']);
                    $total_nights = $checkin_date->diff($checkout_date)->days;
                    $total_sale_price_each *= $total_nights;

                    $vendor_totals[$row['vendorname']] = isset($vendor_totals[$row['vendorname']])
                        ? $vendor_totals[$row['vendorname']] + $total_sale_price_each : $total_sale_price_each;
                } else if ($row['cf_928'] == 'Transfers' || $row['cf_928'] == 'Guide') {
                    $total_sale_price_each = (float) $row['sale_price'];
                    $vendor_totals[$row['vendorname']] = isset($vendor_totals[$row['vendorname']])
                        ? $vendor_totals[$row['vendorname']] + (float) $row['sale_price'] : (float) $row['sale_price'];
                } else {
                    $total_sale_price_each = $adults_no*(float) $row['sale_price'] 
                                            + $children_no*(float) $row['sale_price_child'] 
                                            + $infants_no*(float) $row['sale_price_infant'];

                    $vendor_totals[$row['vendorname']] = isset($vendor_totals[$row['vendorname']])
                        ? $vendor_totals[$row['vendorname']] + $total_sale_price_each : $total_sale_price_each;
                }
                $row['total_sale_price_each'] = $total_sale_price_each;
                $vendors[$row['vendorname']][] = $row;
            }

            // Fetch payment history for each vendor
            $vendorPayments = [];
            $sql_payment = "SELECT quoteid, vendorid, total_amount AS payable, paid_amount AS paid, payment_deadline, created_at, remark, invoice_path
                            FROM vtiger_supplier_payment 
                            WHERE quoteid = '$quoteid'";
            $result_payment = mysqli_query($conn, $sql_payment);

            while ($payment = mysqli_fetch_assoc($result_payment)) {
                $vendorId = $payment['vendorid'];
                if (!isset($vendorPayments[$vendorId])) {
                    $vendorPayments[$vendorId] = ['payable' => 0, 'paid' => 0, 'deadline' => $payment['payment_deadline']];
                }
                $vendorPayments[$vendorId]['payable'] += (float) $payment['payable'];
                $vendorPayments[$vendorId]['paid'] += (float) $payment['paid'];
                if($payment['paid'] > 0) {
                    if (isset($payment['created_at']) && $payment['created_at'] != '0000-00-00') {
                        $date = new DateTime($payment['created_at']);
                        $vendorPayments[$vendorId]['created_at'] = $date->format('d-M-Y');
                    }
                }
                $vendorPayments[$vendorId]['remark'] = $payment['remark'] ?? '';
                $vendorPayments[$vendorId]['invoice_path'] = $payment['invoice_path'] ?? '';
            }
        ?>

        <div class="table-container" style="display: block; width: 95%; margin: 20px auto;">
            <form method="POST" enctype="multipart/form-data">
                <table border="1" style="width: 100%; text-align: left;">
                    <thead>
                        <tr>
                            <td>
                                <input type="text" id="vendorFilter" placeholder="Search Vendor..." style="margin: 10px 0; width: 100%; padding: 10px;">
                            </td>
                            <td>
                                <input type="text" id="payment_date_range" name="payment_date_range" class="flatpickr-input" placeholder="Filter Payment Deadline..." readonly="readonly"  style="margin: 10px 0; width: 100%; padding: 10px;">
                            </td>
                            <td colspan="5"></td>
                            <td colspan="2">
                                <?php if ($ref_quote_no == '') : ?>
                                <button type="button" style="padding: 10px 20px; width: 100%;" onclick="toggleDivs1112()">Payment to Vendor</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Vendor</th>
                            <th>Supplier Invoice Amount</th>
                            <th>Quote Amount</th>
                            <th>Paid Amount</th>
                            <th>Difference</th>
                            <th>Remark</th>
                            <th>Paid Date</th>
                            <th>Payment Deadline</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="vendorTableBody">
                        <?php foreach ($vendors as $vendor => $products): 
                            $vendorId = $products[0]['vendorid'] ?? null;
                            $quote_amount = $vendor_totals[$vendor];
                            $paymentData = $vendorPayments[$vendorId] ?? ['payable' => 0, 'paid' => 0, 'deadline' => '', 'invoice_path' => ''];
                            $totalAmount = $paymentData['payable'];
                            $amountPaid = $paymentData['paid'];
                            $amountPayable = $totalAmount - $amountPaid;
                            $remark = $paymentData['remark'];
                            ?>
                            <tr class="vendor-row" style="background-color: <?= !empty($paymentData['invoice_path']) ? 'lightgreen' : 'transparent' ?>;" data-vendor="<?= htmlspecialchars($vendor) ?>" data-deadline="<?= $paymentData['deadline'] ?>">
                                <td><?= htmlspecialchars($vendor) ?></td>
                                <td>
                                    <input type="number" style="width: 250px; height: 30px;" name="total_amount[<?= $vendorId ?>]" value="<?= ($totalAmount == 0 ? '' : $totalAmount) ?>" step="0.01" min="0" oninput="calculatePayable('<?= $vendorId ?>')">
                                </td>
                                <td><?= number_format($quote_amount, 2) ?></td>
                                <td>
                                    <input type="number" id="amount_paid_<?= $vendorId ?>" name="amount_paid[<?= $vendorId ?>]" value="<?= ($amountPaid == 0 ? '' : $amountPaid) ?>" step="0.01" min="0" style="width: 250px; height: 30px;">
                                </td>
                                <td style="background-color: <?= ($quote_amount - $amountPaid) < 0 ? 'lightcoral' : '' ?>;">
                                    <p><?= number_format($quote_amount - $amountPaid, 2) ?></p>
                                </td>
                                <td>
                                    <textarea name="remark[<?= $vendorId ?>]" rows="3" style="width: 100%;"><?= htmlspecialchars($remark) ?></textarea>
                                </td>
                                <td><?= htmlspecialchars($paymentData['created_at']) ?></td>
                                <td>
                                    <input type="date" style="height: 30px;" name="payment_deadline[<?= $vendorId ?>]" value="<?= $paymentData['deadline'] ?>">
                                </td>
                                <td style="width: 20%;">
                                    <button type="button" onclick="toggleTable('vendor_<?= md5($vendor) ?>')"><i class="fa-solid fa-caret-down"></i></button>
                                    <!-- Upload Invoice Button -->
                                    <input type="file" name="invoice[<?= $vendorId ?>]" accept="application/pdf" style="display: none;" id="invoiceUpload_<?= $vendorId ?>" onchange="handleFileUpload(this, 'fileNameDisplay_<?= $vendorId ?>')">
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" onclick="document.getElementById('invoiceUpload_<?= $vendorId ?>').click();"><i class="fa-solid fa-arrow-up-from-bracket"></i></button>
                                    <?php endif; ?>
                                    <?php if (!empty($paymentData['invoice_path'])): ?>
                                        <?php
                                            $invoicePaths = explode(',', $paymentData['invoice_path']);
                                        ?>
                                        <?php foreach ($invoicePaths as $index => $path): ?>
                                            <?php $fileName = basename($path); ?>
                                            <span class="invoice-wrapper" data-path="<?= htmlspecialchars($path) ?>" style="border: 2px solid; padding: 5px 8px; margin-left: 4px; display: inline-block;">
                                                <!-- Download Button -->
                                                <button type="button" class="download-btn-vendor-<?= $vendorId ?>" onclick='window.open("<?= rawurlencode($path) ?>", "_blank")' title="<?= htmlspecialchars($fileName) ?>">
                                                    <i class="fa-solid fa-file-arrow-down"></i>
                                                </button>

                                                <!-- Individual Delete Button -->
                                                <?php if ($title == 'admin') : ?>
                                                    <button type="button" style="background-color: red;" onclick="deleteSingleInvoice('<?= $quoteid ?>', '<?= $vendorId ?>', '<?= addslashes($path) ?>', this)">
                                                        <i class="fa-solid fa-trash-can"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </span>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                    <span id="fileNameDisplay_<?= $vendorId ?>" style="font-size: 0.9em; color: green;"></span>
                                </td>
                            </tr>
                            <tr class="vendor-row" data-vendor="<?= htmlspecialchars($vendor) ?>">
                                <td colspan="9" style="padding: 0;">
                                    <div class="table-wrapper" id="vendor_<?= md5($vendor) ?>" style="display: none;">
                                        <table border="1" style="width: 100%; text-align: left;">
                                            <thead>
                                                <tr>
                                                    <th>Day</th>
                                                    <th>Travel Date</th>
                                                    <th>Category</th>
                                                    <th>Product Name</th>
                                                    <th>Single Price (Amount)</th>
                                                    <th>Double Price (Amount)</th>
                                                    <th>Triple Price (Amount)</th>
                                                    <th>Child No Bed</th>
                                                    <th>Checkin</th>
                                                    <th>Checkout</th>
                                                    <th>Adult Price (Amount)</th>
                                                    <th>Child Price (Amount)</th>
                                                    <th>Infant Price (Amount)</th>
                                                    <th>Total Quote Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($products as $product): ?>
                                                    <tr>
                                                        <td><?= htmlspecialchars($product['day']) ?></td>
                                                        <td>
                                                            <?php
                                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $product['day']-1 . ' days')); 
                                                            } else {
                                                                echo '-';
                                                            }
                                                            ?>
                                                        </td>
                                                        <td><?= htmlspecialchars($product['cf_928']) ?></td>
                                                        <td><?= htmlspecialchars($product['productname']) ?></td>
                                                        <?php
                                                        if($product['cf_928'] == 'Hotel') {
                                                            ?>
                                                            <td>$<?= htmlspecialchars($product['sale_price_single']) ?> (<?= $single_rooms ?>)</td>
                                                            <td>$<?= htmlspecialchars($product['sale_price_double']) ?> (<?= $double_rooms ?>)</td>
                                                            <td>$<?= htmlspecialchars($product['sale_price_triple']) ?> (<?= $triple_rooms ?>)</td>
                                                            <td>$<?= htmlspecialchars($product['sale_price_child_no_bed']) ?> (<?= $child_without_bed ?>)</td>
                                                            <td><?= htmlspecialchars($product['checkin']) ?></td>
                                                            <td><?= htmlspecialchars($product['checkout']) ?></td>
                                                            <td colspan="3"></td>
                                                            <?php
                                                        } else if ($product['cf_928'] == 'Transfers' || $product['cf_928'] == 'Guide') {
                                                            ?>
                                                            <td colspan="6"></td>
                                                            <td colspan="3"></td>
                                                            <?php
                                                        } else {
                                                            ?>
                                                            <td colspan="6"></td>
                                                            <td>$<?= htmlspecialchars($product['sale_price']) ?> (<?= $product['adults'] ?>)</td>
                                                            <td>$<?= htmlspecialchars($product['sale_price_child']) ?> (<?= $product['children'] ?>)</td>
                                                            <td>$<?= htmlspecialchars($product['sale_price_infant']) ?> (<?= $product['infants'] ?>)</td>
                                                            <?php
                                                        }
                                                        ?>
                                                        <td>$<?= $product['total_sale_price_each'] ?></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" name="update_supplier_payable" style="padding: 10px 20px; margin: 20px 0;">Save</button>
                <?php endif; ?>
            </form>
        </div>

        <script>
            function deleteSingleInvoice(quoteId, vendorId, filePath, btnElement) {
                if (!confirm("Are you sure you want to delete this invoice?")) return;

                fetch('ajax_delete_vendor_payment_invoice.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `quoteid=${encodeURIComponent(quoteId)}&vendorid=${encodeURIComponent(vendorId)}&filepath=${encodeURIComponent(filePath)}`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Hide the parent span containing download + delete buttons
                        const wrapper = btnElement.closest('.invoice-wrapper');
                        wrapper.remove();
                    } else {
                        alert("Failed to delete invoice: " + (data.message || "Unknown error."));
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("An error occurred while deleting the invoice.");
                });
            }
        </script>

        <script>
            function handleFileUpload(input, displayId) {
                const file = input.files[0];
                const displayElement = document.getElementById(displayId);
                if (file) {
                    displayElement.textContent = `Selected: ${file.name}`;
                } else {
                    displayElement.textContent = '';
                }
            }
        </script>

        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        <script>
            // Toggle vendor product details
            function toggleTable(id) {
                const element = document.getElementById(id);
                element.style.display = element.style.display === 'none' ? 'block' : 'none';
            }

            // Calculate payable amount dynamically
            function calculatePayable(vendorId) {
                const totalAmount = parseFloat(document.querySelector(`input[name="total_amount[${vendorId}]"]`).value) || 0;
                const amountPaid = parseFloat(document.querySelector(`input[name="amount_paid[${vendorId}]"]`).value) || 0;
                // const amountPaid = parseFloat(document.getElementById(`amount_paid_${vendorId}`).textContent) || 0;
                const payableField = document.getElementById(`amount_payable_${vendorId}`);
                payableField.textContent = (totalAmount - amountPaid).toFixed(2);
            }

            // Vendor search filter
            document.getElementById('vendorFilter').addEventListener('input', function () {
                const filter = this.value.toLowerCase();
                const rows = document.querySelectorAll('.vendor-row');
                rows.forEach(row => {
                    const vendorName = row.getAttribute('data-vendor').toLowerCase();
                    row.style.display = vendorName.includes(filter) ? '' : 'none';
                });
            });

            // Date range filter using flatpickr
            flatpickr("#payment_date_range", {
                mode: "range",
                dateFormat: "Y-m-d",
                onChange: function(selectedDates) {
                    const [start, end] = selectedDates;
                    const rows = document.querySelectorAll('.vendor-row');
                    rows.forEach(row => {
                        const deadline = row.getAttribute('data-deadline');
                        const deadlineDate = new Date(deadline);
                        if (!start || !end) {
                            row.style.display = '';
                        } else {
                            row.style.display = (deadlineDate >= start && deadlineDate <= end) ? '' : 'none';
                        }
                    });
                }
            });
        </script>
    </div>
    <?php
    
    $sql_sequence_check = "SELECT * FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
    $result_sequence_check = mysqli_query($conn, $sql_sequence_check);

    // Fetch Booking Statuses
    $bookingStatusQuery = "SELECT status FROM vtiger_booking_status";
    $bookingStatusResult = mysqli_query($conn, $bookingStatusQuery);
    $bookingStatuses = [];
    while ($row = mysqli_fetch_assoc($bookingStatusResult)) {
        $bookingStatuses[] = $row['status'];
    }

    // Fetch Supplier Payment Statuses
    $supplierPaymentQuery = "SELECT status FROM vtiger_supplier_payment_status";
    $supplierPaymentResult = mysqli_query($conn, $supplierPaymentQuery);
    $supplierPaymentStatuses = [];
    while ($row = mysqli_fetch_assoc($supplierPaymentResult)) {
        $supplierPaymentStatuses[] = $row['status'];
    }

    ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <?php

    $sql = "SELECT auto_id, day, tour_time, event_name FROM vtiger_itinerary_new_event
            WHERE quoteid='$quoteid'
            ORDER BY day ASC, tour_time ASC;";
    $result = mysqli_query($conn, $sql);
    $eventsArray = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $day = $row['day'];
        if (!isset($eventsArray[$day])) {
            $eventsArray[$day] = [];
        }
        $eventsArray[$day][] = [
            'auto_id' => $row['auto_id'],
            'tour_time' => $row['tour_time'],
            'event_name' => $row['event_name']
        ];
    }

    $sql = "SELECT 
                vq.quoteid, vq.quote_no, 
                vi.productid, vi.sequence_no, vi.day, vi.cf_928, vi.comment, vi.families, vi.tourtime, vi.show_in_so, vdo.display_order,
                vp.productName AS productname, vp.description, vp.keywords, vp.duration, vp.city,
                vv.vendorName AS vendorname
            FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
            LEFT JOIN ( SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description, '' AS keywords, '' AS duration, '' AS city FROM vtiger_products_custom
                        UNION ALL
                        SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description, keywords, duration, city FROM tdu_products
                        ) vp ON vi.productid = vp.productid
            LEFT JOIN tdu_vendors vv ON vp.vendor_id = vv.vendorid
            LEFT JOIN vtiger_display_order vdo ON vi.id=vdo.id AND vi.sequence_no=vdo.sequence_no
            ORDER BY 
                vi.day ASC,
                CASE 
                    WHEN vi.tourtime IS NULL OR vi.tourtime = '' THEN 1
                    ELSE 0
                END ASC,
                vi.tourtime ASC,
                vdo.display_order ASC, 
                vi.sequence_no ASC;";
    $attractions_operations = $hotels_operations = $restaurants_operations = $tours_operations = $transfers_operations = $sic_operations = $guide_operations = [];

    // Execute the query
    $result = mysqli_query($conn, $sql);
    
    $transfers_tourtime_by_day = array();
    $transfers_duration_by_day = array();

    // Check if the query returns rows
    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            if($row['cf_928'] == 'Hotel') {
                $hotels_operations[] = $row;
            } else {
                $attractions_operations[] = $row;
                $restaurants_operations[] = $row;
                $tours_operations[] = $row;
                $transfers_operations[] = $row;
                $sic_operations[] = $row;
                $guide_operations[] = $row;
            }

            if ($row['cf_928'] == 'Transfers' && stripos($row['keywords'], 'inbound') === false && stripos($row['keywords'], 'outbound') === false) {
                $day = $row['day'];
                if (trim($row['duration']) != '') {
                    $duration = (int) $row['duration'];
                    if (!isset($transfers_duration_by_day[$day])) {
                        $transfers_duration_by_day[$day] = 0;
                    }
                    $transfers_duration_by_day[$day] += $duration;
                }

                // Store the earliest tourtime if 'keywords' does not contain 'inbound' or 'outbound'
                if (!isset($transfers_tourtime_by_day[$day]) || strtotime($row['tourtime']) < strtotime($transfers_tourtime_by_day[$day])) {
                    if ($row['tourtime'] != '') {
                        $transfers_tourtime_by_day[$day] = $row['tourtime'];
                    }
                }
            }
        }
    }

    usort($hotels_operations, function($a, $b) {
        return $a['display_order'] <=> $b['display_order'];
    });
    
    $result = $hotels_operations;

    $sql_room_pricing = "SELECT sequence_no, 
                                sale_price_single, 
                                sale_price_double, 
                                sale_price_triple, 
                                sale_price_child_with_bed,
                                sale_price_child_no_bed
                        FROM vtiger_products_saleprice
                        WHERE quoteid = '$quoteid' AND cf_928 = 'Hotel' AND subquoteid = 1";
    $result_room_pricing = mysqli_query($conn, $sql_room_pricing);

    $data_room_pricing = [];
    while ($row_room_pricing = mysqli_fetch_assoc($result_room_pricing)) {
        $data_room_pricing[$row_room_pricing['sequence_no']] = $row_room_pricing; // Store all room prices in the array
    }
    ?>
    <div id="div-hotel" class="content-div">
        <?= $condition_for_naming ? "<h2 style='color: red; text-align: left; margin: 10px; cursor: pointer; text-decoration: underline;' onclick='confirmRedirectPaxList()'>Pax List Mismatching, click here to fix</h2>" : "" ?>
        <?php 
        if (mysqli_num_rows($result_sequence_check) > 0 && $num_hotel > 0) { 
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateForm();">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Hotel">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th style="width: 20%;">Hotel Name</th>
                        <th>Confirmation number</th>
                        <th>No of Single Rooms</th>
                        <th>No of Double Rooms</th>
                        <th>No of Triple Rooms</th>
                        <th>No of Children without bed</th>
                        <th>Total Rooms</th>
                        <th>Check-in Date</th>
                        <th>Check-out Date</th>
                        <th>Single Room Price</th>
                        <th>Double Room Price</th>
                        <th>Triple Room Price</th>
                        <th>Child with Bed Price</th>
                        <th>Child No Bed Charge</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                        <th>Total</th>
                    </tr>
                    <?php 
                    $prev_sequence_no = null; // to keep track of the previous row's sequence number
                    foreach ($result as $row) {
                        $sequence_no = $row['sequence_no'];

                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr>
                        <td>
                            <?php if ($title == 'admin') : ?>
                                <button
                                    type="button"
                                    class="replace-product"
                                    data-replace-key="<?php echo htmlspecialchars($quoteid . '_' . $row['display_order'] . '_' . $row['sequence_no'] . '_' . $row['productid'] . '_' . $row['city'] . '_' . $metaData['check_in'] . '_' . $metaData['check_out']); ?>"
                                    onclick="handleReplaceClick(this)"
                                    style="background-color: orange; color: white;"
                                    <?= $metaData['booking_status'] == 'Confirmation received' ? 'disabled' : '' ?>
                                >
                                    <i class="fa-solid fa-sync-alt"></i>
                                </button>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo htmlspecialchars($row['productname']); ?><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea><br>
                        </td>
                        <td>
                            <textarea name="hotel_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'hotel')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td><input type="number" id="single_rooms_<?php echo $sequence_no; ?>" name="single_rooms[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['single_rooms'] ?? ''); ?>" min="0" oninput="updateRooms(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['single_rooms'] ?? ''); ?></td>
                        <td><input type="number" id="double_rooms_<?php echo $sequence_no; ?>" name="double_rooms[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['double_rooms'] ?? ''); ?>" min="0" oninput="updateRooms(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['double_rooms'] ?? ''); ?></td>
                        <td><input type="number" id="triple_rooms_<?php echo $sequence_no; ?>" name="triple_rooms[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['triple_rooms'] ?? ''); ?>" min="0" oninput="updateRooms(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['triple_rooms'] ?? ''); ?></td>
                        <td>
                            <input 
                                type="number" 
                                id="child_without_bed_<?php echo $sequence_no; ?>" 
                                name="child_without_bed[<?php echo $sequence_no; ?>]" 
                                value="<?php echo htmlspecialchars($metaData['child_without_bed'] ?? ''); ?>" 
                                min="0" max="<?= $children_no ?>"
                                oninput="updateRooms(<?php echo $sequence_no; ?>)"
                            >
                            <?php echo ($clockIcons['child_without_bed'] ?? ''); ?>
                        </td>
                        <td>
                            <p id="total_rooms_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['single_rooms'] ?? 0) + ((int) $metaData['double_rooms'] ?? 0) + ((int) $metaData['triple_rooms'] ?? 0)); ?>
                            </p>
                        </td>
                        <td><input type="date" name="check_in[<?php echo $sequence_no; ?>]" min="<?= $date_of_travel ?>" value="<?php echo htmlspecialchars($metaData['check_in'] ?? ''); ?>"><?php echo ($clockIcons['check_in'] ?? ''); ?></td>
                        <td><input type="date" name="check_out[<?php echo $sequence_no; ?>]" min="<?= $date_of_travel ?>" value="<?php echo htmlspecialchars($metaData['check_out'] ?? ''); ?>"><?php echo ($clockIcons['check_out'] ?? ''); ?></td>
                        <td>
                            <input type="number" name="single_room_price[<?php echo $sequence_no; ?>]" min="0" step="0.01" 
                                value="<?php echo htmlspecialchars($data_room_pricing[$sequence_no]['sale_price_single'] ?? ''); ?>"
                                oninput="updateRoomPrices(<?php echo $sequence_no; ?>, 'single')">
                        </td>
                        <td>
                            <input type="number" name="double_room_price[<?php echo $sequence_no; ?>]" min="0" step="0.01" oninput="updateTripleRoomPrice(<?php echo $sequence_no; ?>)"
                                value="<?php echo htmlspecialchars($data_room_pricing[$sequence_no]['sale_price_double'] ?? ''); ?>">
                        </td>
                        <td>
                            Room Price: <input type="number" name="triple_room_price[<?php echo $sequence_no; ?>]" min="0" step="0.01" 
                                value="<?php echo htmlspecialchars($data_room_pricing[$sequence_no]['sale_price_triple'] ?? ''); ?>" readonly>
                            Charges: <input type="number" name="room_price_difference[<?php echo $sequence_no; ?>]" oninput="updateTripleRoomPrice(<?php echo $sequence_no; ?>)" min="0" step="0.01" 
                                value="<?php echo htmlspecialchars(((float) $data_room_pricing[$sequence_no]['sale_price_triple'] ?? 0) - ((float) $data_room_pricing[$sequence_no]['sale_price_double'] ?? 0)); ?>">
                        </td>
                        <td>
                            <input type="number" name="child_with_bed_price[<?php echo $sequence_no; ?>]" min="0" step="0.01" 
                                value="<?php echo htmlspecialchars($data_room_pricing[$sequence_no]['sale_price_child_with_bed'] ?? ''); ?>" readonly>
                        </td>
                        <td>
                            <input type="number" name="child_no_bed_price[<?php echo $sequence_no; ?>]" min="0" step="0.01" 
                                value="<?php echo htmlspecialchars($data_room_pricing[$sequence_no]['sale_price_child_no_bed'] ?? ''); ?>">
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0) + ((int) $metaData['tour_manager'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <?php if ($title != 'admin') : ?>
                                <?php echo htmlspecialchars($metaData['booking_status'] ?? ''); ?>
                                <input type="hidden" name="booking_status[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['booking_status'] ?? ''); ?>">
                            <?php else : ?>
                                <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                    <?php foreach ($bookingStatuses as $status) : ?>
                                        <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($status); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            <?php endif; ?>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                        <?php
                        // Calculate total price based on the values available for each sequence
                        $totalPrice = 0;

                        if (isset($metaData['single_rooms']) && isset($data_room_pricing[$sequence_no]['sale_price_single'])) {
                            $totalPrice += (float)$metaData['single_rooms'] * (float)$data_room_pricing[$sequence_no]['sale_price_single'];
                        }
                        if (isset($metaData['double_rooms']) && isset($data_room_pricing[$sequence_no]['sale_price_double'])) {
                            $totalPrice += (float)$metaData['double_rooms'] * (float)$data_room_pricing[$sequence_no]['sale_price_double'];
                        }
                        if (isset($metaData['triple_rooms']) && isset($data_room_pricing[$sequence_no]['sale_price_triple'])) {
                            $totalPrice += (float)$metaData['triple_rooms'] * (float)$data_room_pricing[$sequence_no]['sale_price_triple'];
                        }
                        // You can also add child with bed pricing if needed
                        if (isset($metaData['child_without_bed']) && isset($data_room_pricing[$sequence_no]['sale_price_child_no_bed'])) {
                            $totalPrice += (float)$metaData['child_without_bed'] * (float)$data_room_pricing[$sequence_no]['sale_price_child_no_bed'];
                        }
                        // if (isset($data_room_pricing[$sequence_no]['sale_price_child_no_bed'])) {
                        //     $tmp_child_without_bed = $metaData['child_without_bed'] ? (float) $metaData['child_without_bed'] : 0;
                        //     $totalPrice += ($children_no - $tmp_child_without_bed) * (float)$data_room_pricing[$sequence_no]['sale_price_child_with_bed'];
                        // }
                        $checkIn_row = new DateTime($metaData['check_in']);
                        $checkOut_row = new DateTime($metaData['check_out']);

                        $interval = $checkIn_row->diff($checkOut_row);
                        $nights = $interval->days;
                        $totalPrice *= $nights;
                        ?>
                        <td><p id="total_price_<?php echo $sequence_no; ?>"><?php echo number_format($totalPrice, 2); ?></p></td>
                    </tr>
                    <?php 
                        $prev_sequence_no = $sequence_no; // store the current row's sequence number to be used for the next row
                    } ?>
                </table>
                <script>
                    function updateRoomPrices(sequence, changedField) {
                        let singleInput = document.querySelector(`[name="single_room_price[${sequence}]"]`);
                        let doubleInput = document.querySelector(`[name="double_room_price[${sequence}]"]`);

                        if (changedField === 'single') {
                            doubleInput.value = singleInput.value; 
                            updateTripleRoomPrice(sequence);
                        } else {
                            singleInput.value = doubleInput.value; 
                        }
                    }

                    function updateTripleRoomPrice(sequence_no) {
                        // Fetch the values of double room price and price difference
                        const doubleRoomPrice = parseFloat(document.querySelector(`input[name="double_room_price[${sequence_no}]"]`).value) || 0;
                        const priceDifference = parseFloat(document.querySelector(`input[name="room_price_difference[${sequence_no}]"]`).value) || 0;

                        // Calculate the triple room price and update its field
                        const tripleRoomField = document.querySelector(`input[name="triple_room_price[${sequence_no}]"]`);
                        tripleRoomField.value = doubleRoomPrice + priceDifference;

                        const child_with_bed_priceField = document.querySelector(`input[name="child_with_bed_price[${sequence_no}]"]`);
                        child_with_bed_priceField.value = Math.ceil((doubleRoomPrice + priceDifference) / 3);

                        updateRoomPrices(sequence_no, 'double');
                    }
                </script>
                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        document.querySelectorAll("input[type='date']").forEach(input => {
                            input.addEventListener("change", function () {
                                if (this.name.startsWith("check_out")) {
                                    let currentRow = this.closest("tr");
                                    let nextRow = currentRow.nextElementSibling;
                                    
                                    if (nextRow) {
                                        let nextCheckIn = nextRow.querySelector("input[name^='check_in']");
                                        if (nextCheckIn) {
                                            nextCheckIn.value = this.value;
                                            nextCheckIn.min = this.value; // Ensure min value is updated
                                        }
                                    }
                                }
                            });
                        });
                    });
                </script>
                <table id="validationMessages" class="operation-table"></table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
            <?php 
        } 
        else {
            $sql_self_booked_hotels = "SELECT auto_id, hotel_name, city, checkin_date, checkout_date FROM tdu_self_booked_hotels WHERE quoteid = '$quoteid'";
            $result_self_booked_hotels = mysqli_query($conn, $sql_self_booked_hotels);

            ?>
            <table class="operation-table">
                <tr>
                    <th>
                        <?php if ($ref_quote_no == '') : ?>
                        <button id="addSelfBookedHotelBtn">+ Self-Booked</button>
                        <?php endif; ?>
                    </th>
                    <th>Hotel Name</th>
                    <th>Check-in Date</th>
                    <th>Check-out Date</th>
                    <th>City</th>
                </tr>

                <?php
                if (mysqli_num_rows($result_self_booked_hotels) > 0) {
                    while ($row_sbh = mysqli_fetch_assoc($result_self_booked_hotels)) {
                        ?>
                        <tr id="row-<?php echo $row_sbh['auto_id']; ?>">
                            <td>
                                <button class="deleteSelfBookedHotelBtn" data-autoid="<?php echo $row_sbh['auto_id']; ?>" style="background-color: red;">
                                    <i class="fa-solid fa-trash-can"></i>
                                </button>
                            </td>
                            <td><?php echo htmlspecialchars($row_sbh['hotel_name']); ?></td>
                            <td><?php echo htmlspecialchars($row_sbh['checkin_date']); ?></td>
                            <td><?php echo htmlspecialchars($row_sbh['checkout_date']); ?></td>
                            <td><?php echo htmlspecialchars($row_sbh['city']); ?></td>
                        </tr>
                        <?php
                    }
                }
                ?>
            </table>

            <div id="selfBookedHotelModal" style="display:none; position:fixed; top:25%; left:50%; transform:translate(-50%, 0); padding:20px; background:#fff; border:1px solid #ccc; z-index:1000;">
                <h3>Add Self-Booked Hotel</h3>
                <form id="selfBookedHotelForm">
                    <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                    <label>Hotel Name:</label>
                    <input type="text" name="hotel_name" style="width: 100%; height: 30px;" required><br><br>
                    <label>City:</label>
                    <select name="city" style="width: 100%; height: 30px;" required>
                        <option value="">SELECT</option>
                        <?php
                        $sqlsbh2 = "SELECT DISTINCT TRIM(city) AS city FROM tdu_products WHERE city IS NOT NULL AND city != '' GROUP BY city ORDER BY COUNT(city) DESC";
                        $resultsbh2 = $conn->query($sqlsbh2);
                        while ($rowsbh2 = $resultsbh2->fetch_assoc()) {
                            echo '<option value="' . htmlspecialchars($rowsbh2['city']) . '">' . htmlspecialchars($rowsbh2['city']) . '</option>';
                        }
                        ?>
                    </select><br><br>
                    <label>Check-in Date:</label>
                    <input type="date" name="checkin_date" style="width: 100%; height: 30px;" min="<?= $date_of_travel ?>" required><br><br>
                    <label>Check-out Date:</label>
                    <input type="date" name="checkout_date" style="width: 100%; height: 30px;" min="<?= $date_of_travel ?>" required><br><br>
                    <button type="button" id="saveSelfBookedHotelBtn">Save</button>
                    <button type="button" id="closeSelfBookedHotelModal">Cancel</button>
                </form>
            </div>
            <script>
                $(document).ready(function() {
                    // Show modal on button click
                    $('#addSelfBookedHotelBtn').click(function() {
                        $('#selfBookedHotelModal').show();
                    });

                    // Close modal
                    $('#closeSelfBookedHotelModal').click(function() {
                        $('#selfBookedHotelModal').hide();
                    });

                    // Save new hotel via AJAX
                    $('#saveSelfBookedHotelBtn').click(function() {
                        var form = document.getElementById('selfBookedHotelForm');
                        if (form.checkValidity()) {
                            var formData = $('#selfBookedHotelForm').serialize();

                            $.ajax({
                                url: 'ajax_add_self_booked_hotel.php',
                                type: 'POST',
                                data: formData,
                                success: function(response) {
                                    if (response == 'success') {
                                        alert('Hotel added successfully!');
                                        location.reload();
                                    } else {
                                        alert('Error adding hotel: ' + response);
                                    }
                                },
                                error: function() {
                                    alert('AJAX error occurred');
                                }
                            });
                        } else {
                            form.reportValidity(); // This will show the native validation messages
                        }
                    });

                    // Handle delete button click
                    $('.deleteSelfBookedHotelBtn').click(function() {
                        var auto_id = $(this).data('autoid');

                        if (confirm('Are you sure you want to delete this hotel?')) {
                            $.ajax({
                                url: 'ajax_delete_self_booked_hotel.php',
                                type: 'POST',
                                data: { auto_id: auto_id },
                                success: function(response) {
                                    if (response == 'success') {
                                        alert('Hotel deleted successfully!');
                                        $('#row-' + auto_id).remove(); // Remove the row from the table
                                    } else {
                                        alert('Error deleting hotel: ' + response);
                                    }
                                },
                                error: function() {
                                    alert('AJAX error occurred');
                                }
                            });
                        }
                    });
                });
            </script>
            <?php
        }
        ?>
    </div>

    <script>
        function handleReplaceClick(button) {
            let dataKey = button.getAttribute('data-replace-key'); 
            let keyParts = dataKey.split('_');

            if (keyParts.length === 7) {
                replace_from_operation = 1;
                replace_from_operation_checkin = keyParts[5];
                replace_from_operation_checkout = keyParts[6];

                selectedCategory = 'Hotel';
                const buttons = document.querySelectorAll('.category-filter-btn[data-category="Hotel"]');
                highlightSelectedButton(buttons[0], '.category-filter-btn');

                insert_sequence = keyParts[1]; 
                replace_sequence = keyParts[2]; 
                replace_productid = keyParts[3];
                document.getElementById('filter-city').value = keyParts[4];
                document.getElementById('filter-date').value = keyParts[5];
                document.getElementById('associated-modal').style.display = 'block';
                document.getElementById('modal-overlay').style.display = 'block';

                const baseDate = new Date('<?php echo htmlspecialchars($date_of_travel); ?>');
                const selectedDate = new Date(keyParts[5]);
                const dayOffset = Math.ceil((selectedDate - baseDate) / (1000 * 60 * 60 * 24)) + 1;
                document.getElementById('filter-day').value = dayOffset;

                fetchAddedProducts();
                fetchFilteredData();
            }
        }
    </script>

    <!-- Highlight Hotel Mismatched Rows -->
    <script>
        function highlightMismatchedRows() {
            const rows = document.querySelectorAll('#div-hotel table.operation-table tr');
            let isValid = true;

            <?php if ($initial_path) { echo 'return true;'; } ?>

            for (const row of rows) {
                const sequenceNo = row.querySelector('[name^="single_rooms"]')?.name.match(/\[(\d+)\]/)?.[1];
                if (!sequenceNo) continue;

                const singleRooms = parseInt(row.querySelector(`#single_rooms_${sequenceNo}`)?.value) || 0;
                const doubleRooms = parseInt(row.querySelector(`#double_rooms_${sequenceNo}`)?.value) || 0;
                const tripleRooms = parseInt(row.querySelector(`#triple_rooms_${sequenceNo}`)?.value) || 0;
                const child_without_bed = parseInt(row.querySelector(`#child_without_bed_${sequenceNo}`)?.value) || 0;

                const totalRoomCapacity = singleRooms + (2 * doubleRooms) + (3 * tripleRooms);

                const adultsNo = parseInt(row.querySelector(`#adults_${sequenceNo}`)?.value) || 0;
                const childrenNo = parseInt(row.querySelector(`#children_${sequenceNo}`)?.value) || 0;

                if (totalRoomCapacity != (adultsNo + childrenNo - child_without_bed)) {
                    row.style.backgroundColor = '#f8d7da';
                    isValid = false;
                } else if (doubleRooms + tripleRooms < childrenNo - child_without_bed) {
                    row.style.backgroundColor = 'lightyellow';
                    // isValid = false;
                } else {
                    row.style.backgroundColor = ''; // Reset the row background if it matches
                }

                // Check-in < Check-out Validation
                const checkInInput = row.querySelector(`[name="check_in[${sequenceNo}]"]`);
                const checkOutInput = row.querySelector(`[name="check_out[${sequenceNo}]"]`);

                if (checkInInput && checkOutInput) {
                    const checkInDate = new Date(checkInInput.value);
                    const checkOutDate = new Date(checkOutInput.value);

                    if (checkInDate >= checkOutDate) {
                        checkInInput.parentElement.style.backgroundColor = 'red';
                        checkOutInput.parentElement.style.backgroundColor = 'red';
                        isValid = false;
                    } else {
                        checkInInput.parentElement.style.backgroundColor = '';
                        checkOutInput.parentElement.style.backgroundColor = '';
                    }
                }
            }

            return isValid;
        }

        function validateForm() {
            const isValid = highlightMismatchedRows();

            // Clear previous messages
            const validationTable = document.getElementById('validationMessages');
            validationTable.innerHTML = '';

            if (!isValid) {
                // Add the first message row
                const row1 = validationTable.insertRow();
                const cell1 = row1.insertCell(0);
                cell1.colSpan = 19; // Adjust this based on your table column count
                cell1.style.backgroundColor = '#f8d7da';
                cell1.style.textAlign = 'center';
                cell1.textContent = 'Total room capacity does not match the number of passengers';

                // Add the second message row
                const row2 = validationTable.insertRow();
                const cell2 = row2.insertCell(0);
                cell2.colSpan = 19; // Adjust this based on your table column count
                cell2.style.backgroundColor = 'lightyellow';
                cell2.style.textAlign = 'center';
                cell2.textContent = 'Number of children with bed is more than number of double/triple rooms';

                alert('There are some problems in some rows, please check');
            }

            const singleRoomInputs = document.querySelectorAll('input[name^="single_room_price"]');
            for (let i = 0; i < singleRoomInputs.length; i++) {
                const singleInput = singleRoomInputs[i];
                const sequenceNo = singleInput.name.match(/\d+/)[0]; // Extract sequence number
                const singlePrice = parseFloat(singleInput.value) || 0;
                const doublePriceInput = document.querySelector(`input[name="double_room_price[${sequenceNo}]"]`);
                const doublePrice = parseFloat(doublePriceInput.value) || 0;

                if (doublePrice < singlePrice) {
                    alert('Double room price should be greater than or equal to single room price');
                    return false; // Stop form submission
                }
            }

            return isValid;
        }

        // Highlight mismatched rows on page load
        document.addEventListener('DOMContentLoaded', highlightMismatchedRows);
    </script>

    <style>
        input[readonly], textarea[readonly], select[readonly] {
            background-color: #f9f9f9;
            cursor: not-allowed;
        }
    </style>

    <?php $result = $attractions_operations; $usedEvents = []; ?>
    <div id="div-attraction" class="content-div">
        <?php
        if (mysqli_num_rows($result_sequence_check) > 0) {
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Attraction">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 20%;">Activity</th>
                        <th>Confirmation number</th>
                        <th>Address</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                    </tr>
                    <?php foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if ($day_prev_row != -1 && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="10"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="16" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'Attraction') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];

                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <td><?php echo htmlspecialchars($row['day']) . ($clockIcons['day'] ?? ''); ?></td>
                        <td>
                            <?php 
                            if (isset($date_of_travel) && $date_of_travel != '') {
                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')) . ($clockIcons['date_of_travel'] ?? ''); 
                            } else {
                                echo '-' . ($clockIcons['date_of_travel'] ?? '');
                            }
                            ?>
                        </td>
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                        </td>
                        <td>
                            <?= $row['families'] > 0 ? '<i class="fa-solid fa-house-chimney-user tooltip-family-price"></i>' : '' ?>
                            <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['comment'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'attraction')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_address[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['attraction_address'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['attraction_address'] ?? ''); ?>
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                <?php foreach ($bookingStatuses as $status) : ?>
                                    <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($status); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
            <?php
        }
        ?>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Add New SO event -->
    <script>
        $(document).ready(function() {
            $(".add-event-btn").on("click", function() {
                $(".new-event-row").remove();

                let sequenceNo = $(this).data('sequence');
                let day = $(this).data('day');

                // Check if a new event row already exists and remove it
                $(this).closest('tr').next('.new-event-row').remove();

                // Create new row HTML
                let newRow = `
                    <tr class="new-event-row">
                        <td></td>
                        <td colspan="2">${day}</td>
                        <td>
                            <input type="text" style="width: 100px;" class="new-event-time">
                        </td>
                        <td>
                            <textarea style="width: 100%;" class="new-event-name"></textarea>
                        </td>
                        <td colspan="10">
                            <button type="button" class="save-event-btn" data-sequence="${sequenceNo}" data-day="${day}">Save</button>
                        </td>
                    </tr>
                `;

                // Insert after the current row
                $(this).closest('tr').after(newRow);

                flatpickr(".new-event-time", {
                    enableTime: true,
                    noCalendar: true,
                    time_24hr: true
                });
            });

            $(document).on("click", ".save-event-btn", function() {
                let sequenceNo = $(this).data('sequence');
                let day = $(this).data('day');
                let eventName = $(this).closest('tr').find('.new-event-name').val();
                let tourTime = $(this).closest('tr').find('.new-event-time').val();

                if (eventName === '' || tourTime === '') {
                    alert('Please fill both Event Name and Tour Time.');
                    return;
                }

                $.ajax({
                    url: 'ajax_save_itinerary_event.php',
                    type: 'POST',
                    data: {
                        quoteid: '<?php echo $quoteid; ?>', // Ensure this PHP value is echoed at runtime
                        sequence_no: sequenceNo,
                        day: day,
                        event_name: eventName,
                        tour_time: tourTime
                    },
                    success: function(response) {
                        alert(response);

                        // Replace the new-event-row with a normal row displaying saved values
                        let newRow = `
                            <tr>
                                <td></td>
                                <td colspan="2">${day}</td>
                                <td><p style="width: 100px;">${tourTime}</p></td>
                                <td><p style="width: 100%;">${eventName}</p></td>
                                <td colspan="10"></td>
                            </tr>
                        `;

                        $(".new-event-row").replaceWith(newRow);
                    },
                    error: function() {
                        alert('Failed to save event. Please try again.');
                    }
                });
            });
        });
    </script>
    <!-- Delete New SO event -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Handle delete button click
            document.querySelectorAll('.delete-row-btn').forEach(function (button) {
                button.addEventListener('click', function () {
                    const autoId = this.getAttribute('data-auto-id');
                    const row = this.closest('tr');

                    if (confirm('Are you sure you want to delete this row?')) {
                        deleteRowItinerary(autoId, row);
                    }
                });
            });
        });

        function deleteRowItinerary(autoId, row) {
            fetch('ajax_delete_itinerary_row.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `auto_id=${autoId}`
            })
            .then(response => response.text())
            .then(responseText => {
                if (responseText.trim() === 'SUCCESS') {
                    row.remove();
                } else {
                    alert('Failed to delete row: ' + responseText);
                }
            })
            .catch(err => {
                console.error('AJAX error:', err);
                alert('AJAX error occurred.');
            });
        }
    </script>

    <?php $result = $guide_operations; $usedEvents = []; ?>
    <div id="div-guide" class="content-div">
        <?php
        if (mysqli_num_rows($result_sequence_check) > 0) {
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Guide">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 20%;">Activity</th>
                        <th>Confirmation number</th>
                        <th>Address</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                    </tr>
                    <?php foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $day_prev_row-1 . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="10"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="16" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'Guide') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];

                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <td><?php echo htmlspecialchars($row['day']) . ($clockIcons['day'] ?? ''); ?></td>
                        <td>
                            <?php 
                            if (isset($date_of_travel) && $date_of_travel != '') {
                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')) . ($clockIcons['date_of_travel'] ?? ''); 
                            } else {
                                echo '-' . ($clockIcons['date_of_travel'] ?? '');
                            }
                            ?>
                        </td>
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                        </td>
                        <td>
                            <?= $row['families'] > 0 ? '<i class="fa-solid fa-house-chimney-user tooltip-family-price"></i>' : '' ?>
                            <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['comment'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'attraction')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_address[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['attraction_address'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['attraction_address'] ?? ''); ?>
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                <?php foreach ($bookingStatuses as $status) : ?>
                                    <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($status); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
            <?php
        }
        ?>
    </div>

    <?php $result = $sic_operations; $usedEvents = []; ?>
    <div id="div-sic" class="content-div">
        <?php
        if (mysqli_num_rows($result_sequence_check) > 0) {
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="SIC">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 20%;">Activity</th>
                        <th>Confirmation number</th>
                        <th>Address</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                    </tr>
                    <?php foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $day_prev_row-1 . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="10"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="16" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'SIC') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];

                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <td><?php echo htmlspecialchars($row['day']) . ($clockIcons['day'] ?? ''); ?></td>
                        <td>
                            <?php 
                            if (isset($date_of_travel) && $date_of_travel != '') {
                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')) . ($clockIcons['date_of_travel'] ?? ''); 
                            } else {
                                echo '-' . ($clockIcons['date_of_travel'] ?? '');
                            }
                            ?>
                        </td>
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                        </td>
                        <td>
                            <?= $row['families'] > 0 ? '<i class="fa-solid fa-house-chimney-user tooltip-family-price"></i>' : '' ?>
                            <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['comment'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'attraction')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_address[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['attraction_address'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['attraction_address'] ?? ''); ?>
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                <?php foreach ($bookingStatuses as $status) : ?>
                                    <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($status); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
            <?php
        }
        ?>
    </div>
    
    <?php $result = $tours_operations; $usedEvents = []; ?>
    <div id="div-tour" class="content-div">
        <?php if (mysqli_num_rows($result_sequence_check) > 0) { 
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Tour">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 20%;">Activity</th>
                        <th>Confirmation number</th>
                        <th>Address</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                    </tr>
                    <?php foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $day_prev_row-1 . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="10"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="16" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'Tour') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];
                        
                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <td><?php echo htmlspecialchars($row['day']) . ($clockIcons['day'] ?? ''); ?></td>
                        <td>
                            <?php 
                            if (isset($date_of_travel) && $date_of_travel != '') {
                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')) . ($clockIcons['date_of_travel'] ?? '');
                            } else {
                                echo '-' . ($clockIcons['date_of_travel'] ?? '');
                            }
                            ?>
                        </td>
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                        </td>
                        <td>
                            <?= $row['families'] > 0 ? '<i class="fa-solid fa-house-chimney-user tooltip-family-price"></i>' : '' ?>
                            <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea>
                        </td>
                        <td>
                            <textarea name="attraction_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'attraction')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="attraction_address[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['attraction_address'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['attraction_address'] ?? ''); ?>
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                <?php foreach ($bookingStatuses as $status) : ?>
                                    <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($status); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
        <?php } ?>
    </div>
    
    <?php $result = $restaurants_operations; $usedEvents = []; ?>
    <div id="div-restaurant" class="content-div">
        <?php
        if (mysqli_num_rows($result_sequence_check) > 0) {
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Restaurant">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 20%;">Restaurant</th>
                        <th>Confirmation number</th>
                        <th>Address</th>
                        <th>Cancellation Deadline</th>
                        <th>No of Adults</th>
                        <th>No of Children</th>
                        <th>No of Infants</th>
                        <th>No of Tour Managers</th>
                        <th>Total Pax</th>
                        <th>Booking Status</th>
                    </tr>
                    <?php foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $day_prev_row-1 . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="10"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="16" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'Restaurant') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];
                        
                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare to check for multiple created_at timestamps for each meta_key
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <td><?php echo htmlspecialchars($row['day']) . ($clockIcons['day'] ?? ''); ?></td>
                        <td>
                            <?php 
                            if (isset($date_of_travel) && $date_of_travel != '') {
                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')) . ($clockIcons['date_of_travel'] ?? ''); 
                            } else {
                                echo '-' . ($clockIcons['date_of_travel'] ?? '');
                            }
                            ?>
                        </td>
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                        </td>
                        <td>
                            <?= $row['families'] > 0 ? '<i class="fa-solid fa-house-chimney-user tooltip-family-price"></i>' : '' ?>
                            <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                            <textarea name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($row['comment'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['comment'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="restaurant_confirmation[<?php echo $sequence_no; ?>]" oninput="validateRequiredFields('<?php echo $sequence_no; ?>', 'restaurant')"><?php echo htmlspecialchars($metaData['confirmation_number'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['confirmation_number'] ?? ''); ?>
                        </td>
                        <td>
                            <textarea name="restaurant_address[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['restaurant_address'] ?? ''); ?></textarea>
                            <?php echo ($clockIcons['restaurant_address'] ?? ''); ?>
                        </td>
                        <td><input type="date" name="cancellation_deadline[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['cancellation_deadline'] ?? ''); ?>"><?php echo ($clockIcons['cancellation_deadline'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="adults_<?php echo $sequence_no; ?>" name="adults[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['adults'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['adults'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="children_<?php echo $sequence_no; ?>" name="children[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['children'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['children'] ?? ''); ?></td>
                        <td><input type="number" readOnly id="infants_<?php echo $sequence_no; ?>" name="infants[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['infants'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['infants'] ?? ''); ?></td>
                        <td><input type="number" id="tour_manager_<?php echo $sequence_no; ?>" name="tour_manager[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tour_manager'] ?? ''); ?>" min="0" oninput="updatePax(<?php echo $sequence_no; ?>)"><?php echo ($clockIcons['tour_manager'] ?? ''); ?></td>
                        <td>
                            <p id="total_pax_<?php echo $sequence_no; ?>">
                                <?php echo htmlspecialchars(((int) $metaData['adults'] ?? 0) + ((int) $metaData['children'] ?? 0) + ((int) $metaData['infants'] ?? 0) + ((int) $metaData['tour_manager'] ?? 0)); ?>
                            </p>
                        </td>
                        <td>
                            <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                <?php foreach ($bookingStatuses as $status) : ?>
                                    <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($status); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
            <?php
        }
        ?>
    </div>
    <script>
        function updateRooms(sequence_no) {
            const singleRooms = parseInt(document.getElementById('single_rooms_' + sequence_no).value) || 0;
            const doubleRooms = parseInt(document.getElementById('double_rooms_' + sequence_no).value) || 0;
            const tripleRooms = parseInt(document.getElementById('triple_rooms_' + sequence_no).value) || 0;
            const totalRooms = singleRooms + doubleRooms + tripleRooms;
            document.getElementById('total_rooms_' + sequence_no).innerText = totalRooms;
        }

        function updatePax(sequence_no) {
            const adults = parseInt(document.getElementById('adults_' + sequence_no).value) || 0;
            const children = parseInt(document.getElementById('children_' + sequence_no).value) || 0;
            const infants = parseInt(document.getElementById('infants_' + sequence_no).value) || 0;
            const tourManager = parseInt(document.getElementById('tour_manager_' + sequence_no).value) || 0;
            const totalPax = adults + children + infants;
            document.getElementById('total_pax_' + sequence_no).innerText = totalPax;
        }

        // Initialize values on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateRooms(<?php echo $sequence_no; ?>);
            updatePax(<?php echo $sequence_no; ?>);
        });
    </script>

    <?php $result = $transfers_operations; $usedEvents = []; ?>
    <div id="div-transfer" class="content-div">
        <?php if (mysqli_num_rows($result_sequence_check) > 0) { 
            $day_prev_row = -1;
            ?>
            <form action="export_quote.php" method="POST" onsubmit="return validateConfirmationReceivedForm(event)">
                <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">
                <input type="hidden" name="operation_type" value="Transfer">
                <table class="operation-table">
                    <tr>
                        <th></th>
                        <th>Show in SO</th>
                        <th style="width: 1%;">Day</th>
                        <th>Travel Date</th>
                        <th>Tour Time</th>
                        <th style="width: 25%;">Item Name</th>
                        <th>Options</th>
                        <th style="width: 20%;">Pick up location</th>
                        <th style="width: 20%;">Drop off location</th>
                        <!-- <th>Hourly Charter</th> -->
                        <th>Driver name</th>
                        <th>Driver Contact number</th>
                        <th>Booking Status</th>
                        <?php
                        if(false && !$initial_path) {
                            echo '<th></th>';
                        }
                        ?>
                    </tr>
                    <?php 
                    $sequenceCount = [];
                    foreach ($result as $row) {
                        if($day_prev_row != $row['day']) {
                            if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                                foreach ($eventsArray[$day_prev_row] as $event) {
                                    if (!in_array($event['auto_id'], $usedEvents)) {
                                        ?>
                                        <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                            <td>
                                                <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                                <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                    <i class="fa-solid fa-circle-minus"></i>
                                                </button>
                                            </td>
                                            <td></td>
                                            <td><?= htmlspecialchars($day_prev_row); ?></td>
                                            <td>
                                                <?php 
                                                if (isset($date_of_travel) && $date_of_travel != '') {
                                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($day_prev_row - 1) . ' days')); 
                                                } else {
                                                    echo '-';
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                                <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                            </td>
                                            <td>
                                                <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                                <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                            </td>
                                            <td colspan='10'>
                                                <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                            </td>
                                        </tr>
                                        <?php
                                        $usedEvents[] = $event['auto_id']; // Mark event as used
                                    }
                                }
                            }
                        
                            // Display the end time for transfers before moving to the next day
                            if ($day_prev_row != -1 && isset($transfers_tourtime_by_day[$day_prev_row]) && isset($transfers_duration_by_day[$day_prev_row])) {
                                $start_time = $transfers_tourtime_by_day[$day_prev_row]; // e.g., 13:00
                                $duration_hrs = $transfers_duration_by_day[$day_prev_row];

                                $start_time_obj = DateTime::createFromFormat('H:i', $start_time);
                                if ($start_time_obj) {
                                    $start_time_obj->modify("+$duration_hrs hours");
                                    $end_time = $start_time_obj->format('H:i');
                                    ?>
                                    <tr style="background-color: lightgrey;">
                                        <td></td>
                                        <td><?= $day_prev_row ?></td>
                                        <td><?= date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $day_prev_row-1 . ' days')) ?></td>
                                        <td><?= $end_time ?></td>
                                        <td>Private Transfers Hiring Hours End</td>
                                        <td colspan="9"></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            <tr><td colspan="14" style="background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%), linear-gradient(-45deg, rgba(0, 0, 0, 0.1) 25%, transparent 25%); background-size: 10px 10px; background-position: 0 0, 0 0; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);"></td></tr>
                            <?php
                            $day_prev_row = $row['day'];
                        }
                        if (!empty($day_prev_row) && isset($eventsArray[$day_prev_row])) {
                            foreach ($eventsArray[$day_prev_row] as $event) {
                                if (!in_array($event['auto_id'], $usedEvents) && (empty($row['tourtime']) || $event['tour_time'] < $row['tourtime'])) {
                                    ?>
                                    <tr data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>">
                                        <td>
                                            <button type="button" class="edit-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>"><i class="fa-solid fa-pen"></i></button>
                                            <button type="button" class="delete-row-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="color: white; background: red;">
                                                <i class="fa-solid fa-circle-minus"></i>
                                            </button>
                                        </td>
                                        <td></td>
                                        <td><?= htmlspecialchars($row['day']); ?></td>
                                        <td>
                                            <?php 
                                            if (isset($date_of_travel) && $date_of_travel != '') {
                                                echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); 
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <span class="tour-time-text"><?= htmlspecialchars($event['tour_time']) ?></span>
                                            <input type="time" class="tour-time-input" value="<?= htmlspecialchars($event['tour_time']) ?>" style="display: none;">
                                        </td>
                                        <td>
                                            <strong class="event-name-text"><?= htmlspecialchars($event['event_name']); ?></strong>
                                            <input type="text" class="event-name-input" value="<?= htmlspecialchars($event['event_name']); ?>" style="display: none;">
                                        </td>
                                        <td colspan='10'>
                                            <button type="button" class="save-btn" data-auto-id="<?= htmlspecialchars($event['auto_id']) ?>" style="display: none;"><i class="fa-solid fa-check"></i></button>
                                        </td>
                                    </tr>
                                    <?php
                                    $usedEvents[] = $event['auto_id']; // Mark event as used
                                }
                            }
                        }
                        if($row['cf_928'] != 'Transfers') {
                            ?>
                            <tr>
                                <td>
                                    <?php if ($ref_quote_no == '') : ?>
                                    <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                                    <?php endif; ?>
                                </td>
                                <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                                <td><?php echo htmlspecialchars($row['day']); ?></td>
                                <td>
                                    <?php 
                                    if (isset($date_of_travel) && $date_of_travel != '') {
                                        echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . $row['day']-1 . ' days')); 
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($row['tourtime']); ?></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($row['productname']); ?></strong><br><br>
                                    <?php echo nl2br(htmlspecialchars($row['comment'] ?? '')); ?>
                                </td>
                                <td colspan='10'></td>
                            <tr>
                            <?php
                            continue;
                        }

                        $sequence_no = $row['sequence_no'];
                        if (!isset($sequenceCount[$sequence_no])) {
                            $sequenceCount[$sequence_no] = 0; // First time
                        }
                        $sequenceCount[$sequence_no]++;
                        $sub_seq_no = ($sequenceCount[$sequence_no] - 1) * 10000;
                        $remaining = $sequence_no;
                        $sequence_no += $sub_seq_no;

                        $sqlMeta = "SELECT meta_key, meta_value, created_at, created_by FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$remaining' AND sub_seq_no='$sub_seq_no' ORDER BY created_at DESC;";
                        $resultMeta = mysqli_query($conn, $sqlMeta);
                        $metaData = [];
                        $createdAtData = [];

                        $maxCreatedAtQuery = "SELECT MIN(created_at) AS created_at FROM vtiger_invoice WHERE quoteid='$quoteid';";
                        $maxResult = mysqli_query($conn, $maxCreatedAtQuery);
                        $maxCreatedAt = null;

                        if ($maxRow = mysqli_fetch_assoc($maxResult)) {
                            $maxCreatedAt = $maxRow['created_at'];
                        }
                        $addedRecordsLessThanMax = [];

                        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
                            if (!isset($metaData[$metaRow['meta_key']])) {
                                $metaData[$metaRow['meta_key']] = $metaRow['meta_value'];
                            }

                            if ($metaRow['created_at'] >= $maxCreatedAt) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                            } elseif (!isset($addedRecordsLessThanMax[$metaRow['meta_key']])) {
                                $createdAtData[$metaRow['meta_key']][] = [
                                    'created_at' => $metaRow['created_at'],
                                    'meta_value' => $metaRow['meta_value'],
                                    'created_by' => $metaRow['created_by']
                                ];
                                $addedRecordsLessThanMax[$metaRow['meta_key']] = true;
                            }
                        }

                        // Prepare clock icons for fields with multiple timestamps
                        $clockIcons = [];
                        foreach ($createdAtData as $key => $data) {
                            if (count($data) > 1) {
                                $clockIcons[$key] = '<i class="fa-solid fa-clock-rotate-left" onclick="showPopup(' . htmlspecialchars(json_encode($data)) . ', \'' . htmlspecialchars($key) . '\')"></i>';
                            }
                        }

                        // Determine which clock icons to show based on selected option
                        $showDriverIcons = isset($metaData['transfer_option']) && $metaData['transfer_option'] === 'a';
                        $showLocationIcons = isset($metaData['transfer_option']) && $metaData['transfer_option'] === 'b';
                    ?>
                    <tr style="background-color: lightyellow;">
                        <td>
                            <?php if ($ref_quote_no == '') : ?>
                            <button type="button" class="add-event-btn" data-sequence="<?php echo $row['sequence_no']; ?>" data-day="<?php echo $row['day']; ?>"><i class="fa-solid fa-calendar-plus"></i></button>
                            <?php endif; ?>
                        </td>
                        <td><input type="checkbox" class="visibility-toggle" data-quoteid="<?php echo $quoteid; ?>" data-sequence="<?php echo $row['sequence_no']; ?>" <?php echo ($row['show_in_so'] ?? 0) ? 'checked' : ''; ?> /></td>
                        <?php if($sequence_no > 10000) { ?>
                            <td></td>
                            <td></td>
                        <?php } else { ?>
                            <td><?php echo htmlspecialchars($row['day']); ?></td>
                            <td>
                                <?php 
                                if (isset($date_of_travel) && $date_of_travel != '') {
                                    echo date('d-M-Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')) . ($clockIcons['date_of_travel'] ?? '');
                                } else {
                                    echo '-' . ($clockIcons['date_of_travel'] ?? '');
                                }
                                ?>
                            </td>
                        <?php } ?>
                        
                        <td>
                            <input type="text" style="width: 100px;" id="timePicker_<?php echo $sequence_no; ?>" name="tourtime[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['tourtime'] ?? ''); ?>">
                            <?php
                            if(true) {
                                ?>
                                <script>
                                    flatpickr("#timePicker_<?php echo $sequence_no; ?>", {
                                        enableTime: true,
                                        noCalendar: true,
                                        time_24hr: true
                                    });
                                </script>
                                <?php
                            }
                            ?>
                            <?php echo ($clockIcons['tourtime'] ?? ''); ?>
                            <?php if (strpos(strtolower($row['keywords']), 'inbound') !== false || strpos(strtolower($row['keywords']), 'outbound') !== false) : ?>
                                <br><br>
                                <button type="button" class="dropdown-btn" 
                                    onclick="toggleFlightDetails('<?php echo $sequence_no; ?>', '<?php echo date('Y-m-d', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days')); ?>')">
                                    Flight Details <i class="fa-solid fa-angle-down"></i>
                                </button>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($sequence_no < 10000) { ?>
                                <strong style="margin: 0;">
                                    <?php if (strpos(strtolower($row['keywords']), 'outbound') !== false) : ?>
                                        <i class="fa-solid fa-plane-departure"></i>
                                    <?php elseif (strpos(strtolower($row['keywords']), 'inbound') !== false) : ?>
                                        <i class="fa-solid fa-plane-arrival"></i>
                                    <?php endif;?>
                                    <?php echo htmlspecialchars($row['productname']); ?> 
                                </strong><br><br>
                            <?php } ?>
                            <textarea placeholder="comment" style="height: 60px;" name="comment[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['comment'] ?? ''); ?></textarea>
                        </td>
                        <td>
                            <select style="width: 100px;" name="transfer_option[<?php echo $sequence_no; ?>]" id="transfer_option_<?php echo $sequence_no; ?>" onchange="toggleInputs('<?php echo $sequence_no; ?>', this.value)">
                                <option value="b" <?php echo ($metaData['transfer_option'] == 'b') ? 'selected' : ''; ?>>Location</option>    
                                <option value="a" <?php echo ($metaData['transfer_option'] == 'a') ? 'selected' : ''; ?>>Driver</option>
                            </select>
                        </td>
                        <td>
                            <textarea id="pickup_<?php echo $sequence_no; ?>" style="height: 60px;" name="pickup_location[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['pickup_location'] ?? ''); ?></textarea>
                            <?php echo ($showLocationIcons ? $clockIcons['pickup_location'] : ''); ?>
                        </td>
                        <td>
                            <textarea id="dropoff_<?php echo $sequence_no; ?>" style="height: 60px;" name="dropoff_location[<?php echo $sequence_no; ?>]"><?php echo htmlspecialchars($metaData['dropoff_location'] ?? ''); ?></textarea>
                            <?php echo ($showLocationIcons ? $clockIcons['dropoff_location'] : ''); ?>
                        </td>
                        <td style="display:none;">
                            <input type="text" id="hourly_<?php echo $sequence_no; ?>" name="hourly_charter[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['hourly_charter'] ?? ''); ?>">
                            <?php echo ($showDriverIcons ? $clockIcons['hourly_charter'] : ''); ?>
                        </td>
                        <td>
                            <input type="text" id="drivername_<?php echo $sequence_no; ?>" name="driver_name[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['driver_name'] ?? ''); ?>">
                            <?php echo ($showDriverIcons ? $clockIcons['driver_name'] : ''); ?>
                        </td>
                        <td>
                            <input type="text" id="drivercontact_<?php echo $sequence_no; ?>" name="driver_contact[<?php echo $sequence_no; ?>]" value="<?php echo htmlspecialchars($metaData['driver_contact'] ?? ''); ?>">
                            <?php echo ($showDriverIcons ? $clockIcons['driver_contact'] : ''); ?>
                        </td>
                        <?php if($sequence_no > 10000 && !$initial_path) { ?>
                            <td></td>
                            <td><button type="submit" style="background-color: red; color: white;" name="itinerary-del-transfer" class="button" value="<?php echo $sequence_no; ?>">Del</button></td>
                        <?php } else { ?>
                            <td>
                                <select style="width: 200px;" name="booking_status[<?php echo $sequence_no; ?>]">
                                    <?php foreach ($bookingStatuses as $status) : ?>
                                        <option value="<?php echo htmlspecialchars($status); ?>" <?php echo (isset($metaData['booking_status']) && $metaData['booking_status'] === $status) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($status); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <?php echo ($clockIcons['booking_status'] ?? ''); ?>
                            </td>
                            <?php
                            if(false && !$initial_path) {
                                ?>
                                <td><button type="submit" name="itinerary-add-transfer" class="button" value="<?php echo $row['sequence_no']; ?>">+</button></td>
                                <?php
                            }
                            ?>
                        <?php } ?>
                    </tr>
                    <?php if (strpos(strtolower($row['keywords']), 'inbound') !== false || strpos(strtolower($row['keywords']), 'outbound') !== false) : ?>
                        <tr id="flight_details_<?php echo $sequence_no; ?>" class="flight-details-row" style="display: none;">
                            <td colspan="12">
                                <table class="sub-table" style="border-collapse: collapse;">
                                    <tr>
                                        <th>Flight Number</th>
                                        <th>From City</th>
                                        <th>Departure Time</th>
                                        <th>To City</th>
                                        <th>Arrival Time</th>
                                        <th>Type</th>
                                        <th><button type="button" style="width: 100%; height: 30px;" onclick="openFlightSearchModal('<?php echo $sequence_no; ?>')">Search Flight</button></th>
                                    </tr>
                                    <tr>
                                        <?php 
                                        if (strpos(strtolower($row['keywords']), 'outbound') !== false) {
                                            $inbound_outbound = 'outbound';
                                        } else {
                                            $inbound_outbound = 'inbound'; 
                                        }
                                        ?>
                                        <input type="hidden" id="inbound_outbound_<?php echo $sequence_no; ?>" value="<?= $inbound_outbound ?>">
                                        <td><input type="text" id="flight_no_<?php echo $sequence_no; ?>" value=""></td>
                                        <td><input type="text" id="from_city_<?php echo $sequence_no; ?>" value=""></td>
                                        <td><input style="height: 30px;" type="datetime-local" id="from_datetime_<?php echo $sequence_no; ?>" value=""></td>
                                        <td><input type="text" id="to_city_<?php echo $sequence_no; ?>" value=""></td>
                                        <td><input style="height: 30px;" type="datetime-local" id="to_datetime_<?php echo $sequence_no; ?>" value=""></td>
                                        <td>
                                            <select id="flight_type_<?php echo $sequence_no; ?>" style="height: 30px;">
                                                <option value=""></option>
                                                <option value="Domestic">Domestic</option>
                                                <option value="International">International</option>
                                            </select>
                                        </td>
                                        <td>
                                            <button type="button" style="width: 100%; height: 30px;" onclick="saveFlightDetails('<?php echo $sequence_no; ?>')">Save</button>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    <?php endif; ?>

                    <!-- Automatically call toggleInputs for this row on page load -->
                    <script>
                        document.addEventListener('DOMContentLoaded', function () {
                            toggleInputs('<?php echo $sequence_no; ?>', document.getElementById('transfer_option_<?php echo $sequence_no; ?>').value);
                        });
                    </script>
                    <?php } ?>
                </table>
                <?php if ($ref_quote_no == '') : ?>
                    <button type="submit" style="margin:0 10px;" name="itinerary" class="button">Save</button>
                <?php endif; ?>
            </form>
        <?php } ?>
    </div>

    <!-- validateConfirmationReceivedForm -->
    <script>
        function validateConfirmationReceivedForm(event) {
            let form = event.target; // Get the form that triggered submission
            let rows = form.querySelectorAll('.operation-table tr'); // Find tables within this form
            let hasError = false;

            // Reset all row backgrounds first
            rows.forEach(row => row.style.backgroundColor = '');
            for (let row of rows) {
                let bookingStatusSelect = row.querySelector('select[name^="booking_status"]');
                let tourTimeInput = row.querySelector('input[name^="tourtime"]');

                if (bookingStatusSelect && tourTimeInput) {
                    let bookingStatus = bookingStatusSelect.value;
                    let tourTime = tourTimeInput.value.trim();

                    if (bookingStatus === 'Confirmation received' && tourTime === '') {
                        row.style.backgroundColor = '#f7d7da';
                        hasError = true;
                    }
                }
            }

            if (hasError) {
                alert('Please fill Time when Booking Status changes to Confirmation received');
                return false;
            }
            return true;
        }
    </script>

    <!-- Show/Hide product in SO -->
    <script>
        $(document).ready(function () {
            $('.visibility-toggle').on('change', function () {
                const checkbox = $(this);
                const originalState = checkbox.is(':checked'); // store new state
                const sequence = checkbox.data('sequence');
                const quoteid = checkbox.data('quoteid');
                const visible = originalState ? 1 : 0;

                $.ajax({
                    url: 'ajax_update_so_visibility.php',
                    method: 'POST',
                    data: {
                        quoteid: quoteid,
                        sequence_no: sequence,
                        visible: visible
                    },
                    success: function (response) {
                        try {
                            const res = JSON.parse(response);
                            if (res.status !== 'success') {
                                throw new Error(res.message || 'Unknown error');
                            }
                        } catch (e) {
                            alert('Failed to update status');
                            checkbox.prop('checked', !originalState);
                        }
                    },
                    error: function () {
                        alert('Failed to update status');
                        checkbox.prop('checked', !originalState);
                    }
                });
            });
        });
    </script>

    <!-- Edit Event time and event -->
    <script>
        $(document).ready(function () {
            $(".edit-btn").on("click", function () {
                var row = $(this).closest("tr");
                row.find(".tour-time-text, .event-name-text").hide();
                row.find(".tour-time-input, .event-name-input, .save-btn").show();
                $(this).hide(); // Hide Edit button
            });

            $(".save-btn").on("click", function () {
                var row = $(this).closest("tr");
                var autoId = $(this).data("auto-id");
                var newTourTime = row.find(".tour-time-input").val();
                var newEventName = row.find(".event-name-input").val();

                $.ajax({
                    url: "ajax_update_one_event.php",
                    type: "POST",
                    data: {
                        auto_id: autoId,
                        tour_time: newTourTime,
                        event_name: newEventName
                    },
                    success: function (response) {
                        if (response.trim() === "success") {
                            row.find(".tour-time-text").text(newTourTime).show();
                            row.find(".event-name-text").text(newEventName).show();
                            row.find(".tour-time-input, .event-name-input, .save-btn").hide();
                            row.find(".edit-btn").show();
                        } else {
                            alert("Failed to update event.");
                        }
                    },
                    error: function () {
                        alert("Error updating event.");
                    }
                });
            });
        });
    </script>

    <!-- flight API - CIRIUM start -->
    <div id="flightApiModal" style="display: none; position: fixed; top: 30%; left: 50%; transform: translate(-50%, -20%); background: white; padding: 20px; border: 1px solid #ccc; z-index: 1000;">
        <h3>Search Flight</h3>
        <label>Flight Number: </label>
        <input style="height: 30px;" type="text" id="modal_flight_number"><br><br>
        <label>Departure Date: </label>
        <input style="height: 30px;" type="date" id="modal_departure_date"><br><br>
        <label>Arrival Date: </label>
        <input style="height: 30px;" type="date" id="modal_arrival_date"><br><br>
        <p>*Please fill either Departure or Arrival Date</p><br><br>
        <button type="button" onclick="searchFlight()">Search</button>
        <button type="button" onclick="closeFlightSearchModal()">Close</button>

        <div id="flightSearchResults" style="margin-top: 15px; max-height: 300px; overflow-y: auto;"></div>
    </div>
    <script>
        let currentSequenceNo = null;
        let activity_date = '';

        function openFlightSearchModal(sequenceNo) {
            currentSequenceNo = sequenceNo;
            
            // Parse activity_date into a Date object
            let activityDateObj = new Date(activity_date);
            let minDepartureDate = new Date(activityDateObj);
            minDepartureDate.setDate(minDepartureDate.getDate() - 1); // activity_date - 1 day

            let minArrivalDate = new Date(activityDateObj); // activity_date

            // Format the dates as YYYY-MM-DD for input fields
            let formattedMinDeparture = minDepartureDate.toISOString().split('T')[0];
            let formattedMinArrival = minArrivalDate.toISOString().split('T')[0];

            document.getElementById('modal_flight_number').value = '';

            document.getElementById('modal_departure_date').min = formattedMinDeparture;
            document.getElementById('modal_arrival_date').min = formattedMinArrival;
            document.getElementById('modal_arrival_date').value = formattedMinArrival;

            document.getElementById('flightApiModal').style.display = 'block';
        }

        function closeFlightSearchModal() {
            document.getElementById('flightApiModal').style.display = 'none';
            document.getElementById('flightSearchResults').innerHTML = ''; // Clear results
        }

        function searchFlight() {
            const flightNumber = document.getElementById('modal_flight_number').value;
            const departureDate = document.getElementById('modal_departure_date').value;
            const arrivalDate = document.getElementById('modal_arrival_date').value;

            if (!flightNumber || (!departureDate && !arrivalDate)) {
                alert('Please enter flight number and either departure or arrival date.');
                return;
            }

            const flightParts = flightNumber.match(/^([A-Z]+)(\d+)$/);
            if (!flightParts) {
                alert('Invalid flight number format (e.g., AA100)');
                return;
            }

            const carrier = flightParts[1];
            const flightNo = flightParts[2];
            const date = departureDate || arrivalDate;
            const type = departureDate ? 'departing' : 'arriving';

            const apiUrl = `search_flight_cirium_api.php?carrier=${carrier}&flightNo=${flightNo}&date=${date}&type=${type}`;

            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    const resultsDiv = document.getElementById('flightSearchResults');
                    resultsDiv.innerHTML = ''; // Clear old results

                    if (data.scheduledFlights && data.scheduledFlights.length > 0) {
                        data.scheduledFlights.forEach(flight => {
                            const fromAirport = getAirportName(data.appendix.airports, flight.departureAirportFsCode);
                            const toAirport = getAirportName(data.appendix.airports, flight.arrivalAirportFsCode);

                            const flightRow = document.createElement('div');
                            flightRow.style.border = '1px solid #ccc';
                            flightRow.style.padding = '5px';
                            flightRow.style.marginBottom = '5px';

                            flightRow.innerHTML = `
                                <strong>${flight.carrierFsCode}${flight.flightNumber}</strong><br>
                                From: ${fromAirport} (${flight.departureAirportFsCode})<br>
                                To: ${toAirport} (${flight.arrivalAirportFsCode})<br>
                                Departure: ${formatDateTime(flight.departureTime)}<br>
                                Arrival: ${formatDateTime(flight.arrivalTime)}<br><br>
                                <button type="button" onclick="selectFlight(${currentSequenceNo}, ${JSON.stringify(flight).replace(/"/g, '&quot;')}, ${JSON.stringify(data.appendix.airports).replace(/"/g, '&quot;')})">Select</button>
                            `;

                            resultsDiv.appendChild(flightRow);
                        });
                    } else {
                        resultsDiv.innerHTML = '<p>No flights found.</p>';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Failed to fetch flight details');
                });
        }

        function getAirportName(airports, fsCode) {
            const airport = airports.find(a => a.fs === fsCode);
            return airport ? airport.name : fsCode;
        }

        function formatDateTime(dateTimeString) {
            return dateTimeString.slice(0, 16);  // "YYYY-MM-DDTHH:MM"
        }

        function selectFlight(sequenceNo, flight, airports) {
            const fromAirport = getAirportName(airports, flight.departureAirportFsCode);
            const toAirport = getAirportName(airports, flight.arrivalAirportFsCode);

            document.getElementById(`flight_no_${sequenceNo}`).value = flight.carrierFsCode + flight.flightNumber;
            document.getElementById(`from_city_${sequenceNo}`).value = fromAirport;
            document.getElementById(`to_city_${sequenceNo}`).value = toAirport;
            document.getElementById(`from_datetime_${sequenceNo}`).value = formatDateTime(flight.departureTime);
            document.getElementById(`to_datetime_${sequenceNo}`).value = formatDateTime(flight.arrivalTime);

            closeFlightSearchModal();
        }
    </script>
    <!-- flight API - CIRIUM end -->

    <!-- Save Flight Details -->
    <script>
        function toggleFlightDetails(sequence_no, date) {
            activity_date = date;
            var detailsRow = document.getElementById("flight_details_" + sequence_no);
            if (detailsRow.style.display === "none") {
                detailsRow.style.display = "table-row";
                fetchFlightDetails(sequence_no);
            } else {
                detailsRow.style.display = "none";
            }
        }

        function fetchFlightDetails(sequence_no) {
            $.ajax({
                url: "ajax_fetch_flight_details.php",
                type: "POST",
                data: { quoteid: "<?php echo $quoteid; ?>", sequence_no: sequence_no },
                dataType: "json",
                success: function(response) {
                    if (response) {
                        $("#flight_no_" + sequence_no).val(response.flight_number);
                        $("#from_city_" + sequence_no).val(response.from_city);
                        $("#from_datetime_" + sequence_no).val(response.from_datetime);
                        $("#to_city_" + sequence_no).val(response.to_city);
                        $("#to_datetime_" + sequence_no).val(response.to_datetime);
                        $("#flight_type_" + sequence_no).val(response.flight_type);
                    }
                }
            });
        }

        function saveFlightDetails(sequence_no) {
            var quoteid = "<?php echo $quoteid; ?>";
            var inbound_outbound = $("#inbound_outbound_" + sequence_no).val();
            var flight_number = $("#flight_no_" + sequence_no).val();
            var from_city = $("#from_city_" + sequence_no).val();
            var from_datetime = $("#from_datetime_" + sequence_no).val();
            var to_city = $("#to_city_" + sequence_no).val();
            var to_datetime = $("#to_datetime_" + sequence_no).val();
            var flight_type = $("#flight_type_" + sequence_no).val();

            // Validation check - ensure all fields have values
            if (quoteid === "" || inbound_outbound === "" || flight_number === "" || from_city === "" || from_datetime === "" 
                || to_city === "" || to_datetime === "" || flight_type === "") {
                alert("Please fill in all flight details before saving.");
                return;
            }

            var flightDetails = {
                quoteid: quoteid,
                sequence_no: sequence_no,
                inbound_outbound: inbound_outbound,
                flight_number: flight_number,
                from_city: from_city,
                from_datetime: from_datetime,
                to_city: to_city,
                to_datetime: to_datetime,
                flight_type: flight_type
            };

            $.ajax({
                url: "ajax_save_flight_details.php",
                type: "POST",
                data: flightDetails,
                success: function(response) {
                    $('#timePicker_' + sequence_no).val(response);
                    alert("Flight details saved successfully!");

                    // Fetch and update pickup and dropoff locations
                    fetchPickupDropoffLocations(quoteid, sequence_no);
                }
            });
        }

        function fetchPickupDropoffLocations(quoteid, sequence_no) {
            $.ajax({
                url: "ajax_get_pickup_dropoff.php",
                type: "POST",
                data: { quoteid: quoteid, sequence_no: sequence_no },
                dataType: "json",
                success: function(data) {
                    if (data.success) {
                        $('#pickup_' + sequence_no).val(data.pickup_location);
                        $('#dropoff_' + sequence_no).val(data.dropoff_location);
                    } else {
                        alert("Failed to fetch pickup/dropoff locations.");
                    }
                },
                error: function() {
                    alert("Error fetching pickup/dropoff locations.");
                }
            });
        }
    </script>

    <!-- Transfers pickup / driverName switch -->
    <script>
        function toggleInputs(sequenceNo, option) {
            var pickup = document.getElementById('pickup_' + sequenceNo);
            var dropoff = document.getElementById('dropoff_' + sequenceNo);
            var hourly = document.getElementById('hourly_' + sequenceNo);
            var driverName = document.getElementById('drivername_' + sequenceNo);
            var driverContact = document.getElementById('drivercontact_' + sequenceNo);

            if (option === 'a') {
                // Disable Pickup and Dropoff, enable others
                pickup.value = '';
                pickup.disabled = true;
                dropoff.value = '';
                dropoff.disabled = true;

                hourly.disabled = false;
                driverName.disabled = false;
                driverContact.disabled = false;
            } else if (option === 'b') {
                // Disable others, enable Pickup and Dropoff
                pickup.disabled = false;
                dropoff.disabled = false;

                hourly.value = '';
                hourly.disabled = true;
                driverName.value = '';
                driverName.disabled = true;
                driverContact.value = '';
                driverContact.disabled = true;
            }
        }
    </script>
    <style>
        .tooltip-family-price {
            position: relative;
            display: inline-block;
        }
        .tooltip-family-price:hover::after {
            content: "Family Price Available";
            position: absolute;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            background-color: black;
            color: white;
            padding: 5px;
            border-radius: 5px;
            white-space: nowrap;
            font-size: 24px;
            opacity: 0.8;
            text-transform: none !important;
        }
        @keyframes flash {
            0% { color: red; }
            50% { color: black; }
            100% { color: red; }
        }
        .tooltip-family-price {
            animation: flash 2s infinite;
        }
    </style>

    <script>
        function validateRequiredFields(sequence_no, type) {
            var confirmationField = document.querySelector('textarea[name="' + type + '_confirmation[' + sequence_no + ']"]').value;
            var paymentDeadline = document.querySelector('input[name="payment_deadline[' + sequence_no + ']"]');
            var cancellationDeadline = document.querySelector('input[name="cancellation_deadline[' + sequence_no + ']"]');

            if (confirmationField.trim() !== '') {
                paymentDeadline.setAttribute('required', 'required');
                cancellationDeadline.setAttribute('required', 'required');
            } else {
                paymentDeadline.removeAttribute('required');
                cancellationDeadline.removeAttribute('required');
            }
        }
    </script>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function () {
            <?php if ($initial_path != null) : ?>
                const selectors = [
                    "#div-hotel input, #div-hotel textarea",
                    "#div-attraction input, #div-attraction textarea",
                    "#div-guide input, #div-guide textarea",
                    "#div-sic input, #div-sic textarea",
                    "#div-tour input, #div-tour textarea",
                    "#div-restaurant input, #div-restaurant textarea",
                    "#div-transfer input, #div-transfer textarea"
                ];

                selectors.forEach(function (selector) {
                    document.querySelectorAll(selector).forEach(function (field) {
                        if (field.name && !field.name.includes("comment") && !field.name.includes("_confirmation") 
                            && !field.name.includes("pickup_location") && !field.name.includes("dropoff_location")) {
                            field.readOnly = true;
                        }
                    });
                });
            <?php endif; ?>
        });
    </script>

    <div id="popup" style="display:none; width: 30%; position:fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background-color: white; border: 1px solid #ccc; padding: 20px; z-index: 1000;">
        <div id="popup-content"></div>
        <button onclick="document.getElementById('popup').style.display='none'">Close</button>
    </div>

    <script>
        function showPopup(data, key) {
            let content = '<table style="width: 100%; border-collapse: separate; border-spacing: 10px;">';
            content += '<tr style="text-align: center;"><th>Update Time</th><th>Previous Value</th><th>by</th></tr>';
            data.forEach(item => {
                content += '<tr style="text-align: center;"><td>' + item.created_at + '</td><td>' + item.meta_value + '</td><td>' + item.created_by + '</td></tr>';
            });
            content += '</table>';
            document.getElementById('popup-content').innerHTML = content;
            document.getElementById('popup').style.display = 'block';
        }
    </script>

    <div id="div-notes" class="content-div">
        <?php
        $sql_notes = "SELECT * FROM vtiger_notes WHERE quoteid='$quoteid' ORDER BY created_at DESC";
        $result_notes = $conn->query($sql_notes);
        ?>
        <h2 style="margin: 10px 10%; padding: 10px;">Notes</h2>
        <?php if ($result_notes->num_rows > 0): ?>
            <?php while ($row_notes = $result_notes->fetch_assoc()): ?>
                <div class="note-container">
                    <table class="note-table">
                        <tr style="background-color: #f9f9f9;">
                            <th colspan="2">Added at <?php echo $row_notes['created_at']; ?> by <?php echo $row_notes['created_by']; ?></th>
                        </tr>
                        <tr>
                            <th>Category</th>
                            <td><?php echo $row_notes['category']; ?></td>
                        </tr>
                        <?php
                        if($row_notes['category'] == 'Internal') {
                            ?>
                            <tr>
                                <th>Subcategory</th>
                                <td><?php echo $row_notes['subcategory'] ?? 'N/A'; ?></td>
                            </tr>
                            <?php
                        }
                        ?>
                        <tr>
                            <th>Notes</th>
                            <td><?php echo nl2br($row_notes['notes']); ?></td>
                        </tr>
                        <?php if (!empty($row_notes['attachment_path'])): ?>
                            <tr>
                                <th>Attachment</th>
                                <td>
                                    <?php 
                                        $filename = basename($row_notes['attachment_path']);
                                    ?>
                                    <i class="fa-solid fa-file-lines"></i> <a href="<?php echo $row_notes['attachment_path']; ?>" target="_blank"><?php echo $filename; ?></a>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </table>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="note-container">
                <table class="note-table">
                    <tr>
                        <td colspan="2">No notes found</td>
                    </tr>
                </table>
            </div>
        <?php endif; ?>

        <?php if ($ref_quote_no == '') : ?>
        <form action="" method="post" enctype="multipart/form-data">
            <h2 style="margin: 10px 10%; padding: 10px;">Add Notes</h2>
            <table class="note-table">
                <tr>
                    <th>Category</th>
                    <td>
                        <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                        <?php
                        $sql_category_option = "SELECT note_category FROM tdu_note_categories";
                        $result_category_option = $conn->query($sql_category_option);
                        ?>
                        <select id="category" name="category" style="width: 100%; margin: 0;" required>
                            <option value="">Select Category</option>
                            <?php while ($row_category_option = $result_category_option->fetch_assoc()): ?>
                                <option value="<?php echo htmlspecialchars($row_category_option['note_category']); ?>">
                                    <?php echo htmlspecialchars($row_category_option['note_category']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </td>
                </tr>
                <tr id="subcategory-row" style="display: none;">
                    <th>Subcategory</th>
                    <td>
                        <select id="subcategory" name="subcategory" style="width: 100%; margin: 0;">
                            <option value="">Select Subcategory</option>
                            <option value="Sales">Sales</option>
                            <option value="Operation">Operation</option>
                            <option value="QA">QA</option>
                            <option value="Account">Account</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th>Notes</th>
                    <td>
                        <textarea name="notes" style="width: 100%; height: 200px;" required></textarea>
                    </td>
                </tr>
                <tr>
                    <th>Attachment</th>
                    <td>
                        <input type="file" name="attachment" accept=".pdf,.doc,.docx,.jpg,.png,.jpeg,.xls,.xlsx">
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align: center;">
                        <button type="submit" style="padding: 10px 20px;" name="save_notes">Save</button>
                    </td>
                </tr>
            </table>
        </form>
        <?php endif; ?>

        <style>
            .note-table {
                width: 80%;
                margin: 20px auto;
                border-collapse: collapse;
                border: 1px solid #ddd;
            }

            .note-table td, .note-table th {
                padding: 12px;
                border: 1px solid #ddd;
                vertical-align: top;
            }

            .note-table th {
                text-align: left;
                font-weight: bold;
                width: 30%;
            }

            .note-container {
                margin-bottom: 20px;
            }

            .note-container h2 {
                text-align: center;
                color: #333;
            }
        </style>

        <script>
            document.getElementById('category').addEventListener('change', function () {
                const subcategoryRow = document.getElementById('subcategory-row');
                if (this.value === 'Internal') {
                    subcategoryRow.style.display = '';
                } else {
                    subcategoryRow.style.display = 'none';
                    document.getElementById('subcategory').value = '';
                }
            });
        </script>
    </div>
    
    <style>
        .operation-table {
            margin: 10px;
            width: 99%;
            border-collapse: collapse;
        }
        
        .operation-table th, .operation-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }

        .operation-table td input[type="text"],
        .operation-table td input[type="number"],
        .operation-table td input[type="date"],
        .operation-table td textarea,
        .operation-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>

    <div id="div13" class="content-div">
        <?php
        $sql13 = "SELECT te.received_datetime, te.sender_name, te.subject, vs.status, te.conversation_id
                FROM tdu_emails te
                LEFT JOIN vtiger_support vs ON vs.ticketid = te.conversation_id
                WHERE vs.quote_no='$quote_number'";
        $sql13 .= " AND te.received_datetime IN (
            SELECT MAX(received_datetime) 
            FROM tdu_emails
            GROUP BY conversation_id, mailbox
        )";
        $sql13 .= " ORDER BY te.received_datetime DESC";
        $result13 = mysqli_query($conn, $sql13);

        if (mysqli_num_rows($result13) > 0) :
            ?>
            <table class="styled-table">
                <tr>
                    <th style="padding: 0; text-align: center;">
                        <?php if ($ref_quote_no == '') : ?>
                        <button type="button" id="composeButton">Compose <i class="fa-solid fa-angles-down"></i></button>
                        <?php endif; ?>
                        <div id="emailOptions" style="display: none; position: absolute; background: white; border: 1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
                            <?php if(substr($quote_number, -1) === 'G') : ?>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groupsales@turtledownunder.com.au">Group Sales</button><br>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groups@turtledownunder.com.au">Group AU</button><br>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groups@turtledownunder.co.nz">Group NZ</button>
                            <?php else : ?>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="sales@turtledownunder.com.au">Sales</button><br>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="operations@turtledownunder.com.au">OPS AU</button><br>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="operations@turtledownunder.co.nz">OPS NZ</button>
                                <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="asia@turtledownunder.com.au">Asia</button>
                            <?php endif; ?>
                        </div>
                    </th>
                    <th>Received Time</th>
                    <th>Subject</th>
                    <th>From</th>
                    <th>Status</th>
                </tr>
                <?php while ($row = mysqli_fetch_assoc($result13)) : ?>
                    <tr>
                        <td></td>
                        <td><?php echo htmlspecialchars($row['received_datetime']); ?></td>
                        <td>
                            <a href="quote.php?opt=email-content&conversation_id=<?php echo urlencode($row['conversation_id']); ?>">
                                <?php echo htmlspecialchars($row['subject']); ?>
                            </a>
                        </td>
                        <td><?php echo htmlspecialchars($row['sender_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['status'] ?? 'New'); ?></td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>
                No records found. 
                <?php if ($ref_quote_no == '') : ?>
                <button type="button" id="composeButton">Compose <i class="fa-solid fa-angles-down"></i></button>
                <?php endif; ?>
                <div id="emailOptions" style="display: none; position: absolute; background: white; border: 1px solid #ccc; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
                    <?php if(substr($quote_number, -1) === 'G') : ?>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groupsales@turtledownunder.com.au">Group Sales</button><br>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groups@turtledownunder.com.au">Group AU</button><br>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="groups@turtledownunder.co.nz">Group NZ</button>
                    <?php else : ?>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="sales@turtledownunder.com.au">Sales</button><br>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="operations@turtledownunder.com.au">OPS AU</button><br>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="operations@turtledownunder.co.nz">OPS NZ</button>
                        <button type="button" class="email-option" style="width: 100%; height: 30px;" data-email="asia@turtledownunder.com.au">Asia</button>
                    <?php endif; ?>
                </div>
            </p>
        <?php endif; ?>

        <!-- Compose Mail Start -->
        <div id="statusMessage" style="display:none; margin-top:10px; text-align: center;"></div>

        <div id="composeFormContainer" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
            <h2 style="text-align: center;">Compose Email</h2>
            <form id="emailComposeForm" enctype="multipart/form-data">
                <input type="hidden" name="quoteid_compose" value="<?php echo $quoteid;?>">
                <input type="hidden" name="quote_type_compose" value="ops">
                <input type="hidden" name="email_sender_compose" value="<?= $username_ajax ?>">
                <div>
                    <label for="from">From:</label>
                    <input type="text" name="from" id="from" value="" style="width: 100%;" required readonly>
                </div>
                <div>
                    <label for="to">To:</label>
                    <div style="display: flex; gap: 5px;">
                        <input type="text" name="to" id="to" required style="flex: 1;">
                        <button type="button" onclick="openAddEmailModal('to')">+</button>
                    </div>
                </div>
                <div>
                    <?php
                    $cc_emails = '';
                    if (!empty($assigned_to_region)) {
                        $safe_region = mysqli_real_escape_string($conn, $assigned_to_region);
                        $cc_type = substr($quote_number, -1) === 'G' ? 'Group' : 'FIT';
                        $email_query = "SELECT email, email_type FROM tdu_email_auto_cc WHERE region = '$safe_region'";
                        $result = mysqli_query($conn, $email_query);

                        $emailList = [];
                        while ($row = mysqli_fetch_assoc($result)) {
                            if ($row['email_type'] === $cc_type || $row['email_type'] === 'All') {
                                $emailList[] = $row['email'];
                            }
                            // $emailList[] = $row['email'];
                        }
                        $cc_emails = implode(', ', $emailList);
                    }
                    ?>
                    <label for="cc">CC:</label>
                    <div style="display: flex; gap: 5px;">
                        <input type="text" name="cc" id="cc" style="flex: 1;" value="<?= htmlspecialchars($cc_emails); ?>">
                        <button type="button" onclick="openAddEmailModal('cc')">+</button>
                    </div>
                </div>
                <div>
                    <label for="subject">Subject:</label>
                    <input type="text" name="subject" id="subject" value="<?= htmlspecialchars($quote_number . ' - ' . $subject) ?>" required style="width: 100%;">
                </div>
                <div>
                    <label for="content">Content:</label>
                    <textarea name="content" id="content" rows="10" style="display: none;"></textarea>
                </div>
                <div id="attachments-container" style="margin-bottom: 10px;">
                    <label>Attachments:</label>
                    <div class="attachment-row" style="margin-bottom: 10px;">
                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                    </div>
                </div>
                <div>
                    <button type="submit">Send</button>
                    <button type="button" onclick="closeComposeForm()">Cancel</button>
                </div>
            </form>
        </div>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function(){
                $("#emailComposeForm").on("submit", function(e){
                    e.preventDefault();
                    $("#composeFormContainer").hide();

                    let formData = new FormData(this);
                    formData.append("compose", "1");

                    $.ajax({
                        url: "email_sender.php",
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response){
                            if (response.includes("Email has been sent successfully")) {
                                $("#statusMessage").html('<p style="color: green;">Email sent successfully! It will appear here after 1-2 minutes</p>').fadeIn();
                                setTimeout(function () { $("#statusMessage").fadeOut(); }, 5000);
                                $("#emailComposeForm")[0].reset();
                                if (editorInstance) {
                                    editorInstance.setData(''); // Reset CKEditor content
                                }
                                $("#attachments-container").html(`
                                    <label>Attachments:</label>
                                    <div class="attachment-row" style="margin-bottom: 10px;">
                                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                                    </div>
                                `);
                            } else {
                                $("#statusMessage").html('<p style="color: red;">Failed to send email.</p>').fadeIn();
                            }
                        },
                        error: function(){
                            $("#statusMessage").html('<p style="color: red;">Failed to send email.</p>').fadeIn();
                        }
                    });
                });
            });
        </script>
        <style>
            .ck-editor__editable {
                height: 300px;
                overflow-y: auto;
            }
        </style>
        <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
        <script>
            let editorInstance; // Store the CKEditor instance

            ClassicEditor
                .create(document.querySelector('#content'), {
                    toolbar: {
                        items: ['heading', 'bold', 'italic', 'link', 'insertTable', 'undo', 'redo']
                    }
                })
                .then(editor => {
                    editorInstance = editor; // Store editor instance
                })
                .catch(error => {
                    console.error(error);
                });
        </script>
        <script>
            function handleAttachmentChange(containerId, input) {
                const container = document.getElementById(containerId);

                // If the input has a file, display the file name
                if (input.files.length > 0) {
                    // Hide the input field
                    input.style.display = "none";

                    // Create a span to display the file name
                    const fileName = document.createElement("span");
                    fileName.textContent = input.files[0].name;
                    fileName.style.marginLeft = "10px";
                    fileName.style.fontSize = "0.9em";

                    // Add a remove icon
                    const removeButton = document.createElement("button");
                    removeButton.type = "button";
                    removeButton.style.marginLeft = "10px";
                    removeButton.style.border = "none";
                    removeButton.style.background = "none";
                    removeButton.style.color = "red";
                    removeButton.style.cursor = "pointer";
                    removeButton.style.fontSize = "1.2em";
                    removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                    removeButton.onclick = function () {
                        // Remove the parent row
                        input.parentElement.remove();
                    };

                    // Append the file name and remove button to the current row
                    input.parentElement.appendChild(fileName);
                    input.parentElement.appendChild(removeButton);

                    // Add a new file input for future attachments
                    const newField = document.createElement("div");
                    newField.className = "attachment-row";
                    newField.style.marginBottom = "10px";
                    newField.innerHTML = `
                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('${containerId}', this)">
                    `;

                    container.appendChild(newField);
                }
            }
        </script>
        <script>
            const composeButton = document.getElementById('composeButton');
            const emailOptions = document.getElementById('emailOptions');
            const fromField = document.getElementById('from');

            // Show options when hovering over the button
            composeButton.addEventListener('mouseenter', () => {
                emailOptions.style.display = 'block';
                const rect = composeButton.getBoundingClientRect();
                emailOptions.style.top = rect.bottom + 'px';
                emailOptions.style.left = rect.left + 'px';
            });

            // Hide options when mouse leaves both the button and the options menu
            emailOptions.addEventListener('mouseleave', () => {
                emailOptions.style.display = 'none';
            });

            composeButton.addEventListener('mouseleave', () => {
                setTimeout(() => {
                    if (!emailOptions.matches(':hover')) {
                        emailOptions.style.display = 'none';
                    }
                }, 200);
            });

            // Update "From" field when hovering over an option
            document.querySelectorAll('.email-option').forEach(option => {
                option.addEventListener('mouseenter', function() {
                    fromField.value = this.getAttribute('data-email');
                });

                option.addEventListener('click', function() {
                    emailOptions.style.display = 'none';
                    openComposeForm();
                });
            });

            function openComposeForm() {
                document.getElementById('composeFormContainer').style.display = 'block';
            }

            function closeComposeForm() {
                document.getElementById('composeFormContainer').style.display = 'none';
            }
        </script>
        <!-- Compose Mail End -->
        
        <!-- Modal for adding email start -->
        <div id="emailModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; justify-content: center; align-items: center;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 600px; text-align: center;">
                <h4>Search Email</h4>
                <input type="text" id="emailModalInput" placeholder="Enter email address" style="width: 100%; margin-bottom: 15px; height: 30px;" onkeyup="searchEmail(this.value)">
                <ul id="emailSuggestions" style="list-style: none; padding: 0; margin: 0;"></ul>
                <div style="margin-top: 10px; display: flex; gap: 10px; justify-content: center;">
                    <button onclick="confirmAddEmail()" style="padding: 5px 10px;">Add</button>
                    <button onclick="closeEmailModal()" style="padding: 5px 10px;">Cancel</button>
                </div>
            </div>
        </div>
        <script>
            function searchEmail(query) {
                const suggestions = document.getElementById('emailSuggestions');
                suggestions.innerHTML = ''; // Clear previous suggestions

                if (query.trim().length === 0) {
                    return;
                }
                
                const mailboxFilter = document.getElementById('from').value;
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_outlook_contacts.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        const results = JSON.parse(xhr.responseText);
                        results.forEach(emailData => {
                            const li = document.createElement('li');
                            li.textContent = `${emailData.sender_name} (${emailData.email})`;
                            li.style.cursor = 'pointer';
                            li.style.padding = '5px 10px';
                            li.style.borderBottom = '1px solid #ddd';
                            li.onclick = function () {
                                document.getElementById('emailModalInput').value = emailData.email;
                                suggestions.innerHTML = ''; // Clear suggestions
                            };
                            suggestions.appendChild(li);
                        });
                    }
                };
                xhr.send(`query=${encodeURIComponent(query)}&mailboxFilter=${mailboxFilter}`);
            }

            let currentFieldId = null;

            function openAddEmailModal(fieldId) {
                currentFieldId = fieldId; // Store the current field ID
                document.getElementById('emailModalInput').value = ''; // Clear the input field
                document.getElementById('emailModal').style.display = 'flex'; // Show the modal
            }

            function closeEmailModal() {
                document.getElementById('emailModal').style.display = 'none'; // Hide the modal
                currentFieldId = null; // Reset the current field ID
            }

            function confirmAddEmail() {
                const emailInput = document.getElementById('emailModalInput').value.trim();
                if (emailInput && currentFieldId) {
                    const field = document.getElementById(currentFieldId);
                    const currentValue = field.value.trim();
                    field.value = currentValue ? `${currentValue}, ${emailInput}` : emailInput;
                }
                closeEmailModal(); // Close the modal after adding
            }
        </script>
        <!-- Modal for adding email end -->
    </div>

    <script>
        function addCustomRow(country) {
            var table = document.getElementById("productTable");
            var header = document.getElementById("productTableHeader");
            var tbody = table.getElementsByTagName('tbody')[0];

            if (header.style.display === "none") {
                header.style.display = "table-header-group";
            }

            var rowCount = tbody.rows.length;
            var row = tbody.insertRow(rowCount);
            var cell1 = row.insertCell(0);
            var cell2 = row.insertCell(1);
            var cell3 = row.insertCell(2);
            var cell4 = row.insertCell(3);
            var cell5 = row.insertCell(4);
            var cell6 = row.insertCell(5);
            var cell9 = row.insertCell(6); // New cell for child price
            var cell7 = row.insertCell(7);
            var cell8 = row.insertCell(8);

            cell1.innerHTML = '<button type="button" style="background-color: red; color: white;" onclick="deleteRow(this)">DEL</button>';
            cell2.innerHTML = 'CUSTOM';
            cell3.innerHTML = '<input type="number" min="1" name="day[]" required>';
            cell4.innerHTML = '<input type="text" style="width: 300px;" name="vendor[]" required>';
            cell5.innerHTML = '<input type="text" style="width: 300px;" name="product[]" required>';
            cell6.innerHTML = '<input type="number" step="0.01" min="0" name="price[]" value="0">';
            cell9.innerHTML = '<input type="number" step="0.01" min="0" name="child_price[]" value="0">'; // Child price

            // Category dropdown
            cell7.innerHTML = '<select name="category[]" style="margin: 0;" required>' +
                '<option value="Attraction">Attraction</option>' +
                '<option value="Restaurant">Restaurant</option>' +
                '<option value="Tour">Tour</option>' +
                '<option value="Transfers">Transfers</option>' +
                '<option value="Guide">Guide</option>' +
                '<option value="SIC">SIC</option>' +
                '</select>';

             // Add event listener for the category dropdown
            var categorySelect = cell7.getElementsByTagName('select')[0];
            categorySelect.addEventListener('change', function () {
                if (categorySelect.value != 'Attraction' && categorySelect.value != 'Restaurant' && categorySelect.value != 'Tour' && categorySelect.value != 'SIC') {
                    cell9.innerHTML = '<input type="hidden" name="child_price[]" value="0">';
                } else {
                    cell9.innerHTML = '<input type="number" step="0.01" min="0" name="child_price[]" value="0">';
                }
            });

            // Datalist for cities
            var australianCities = [];
            if (country === 'Australia') {
                australianCities = <?php echo json_encode(citiesAU()); ?>;
            } else if (country === 'New Zealand') {
                australianCities = <?php echo json_encode(citiesNZ()); ?>;
            }

            var datalistId = 'cityList' + rowCount;
            var datalist = '<datalist id="' + datalistId + '">';
            for (var i = 0; i < australianCities.length; i++) {
                datalist += '<option value="' + australianCities[i] + '">';
            }
            datalist += '</datalist>';
            cell8.innerHTML = '<input type="text" name="city[]" style="width: 100px;" list="' + datalistId + '" required>' + datalist;

            toggleSaveButton();
        }

        function deleteRow(button) {
            var row = button.parentNode.parentNode;
            var tbody = row.parentNode;
            tbody.removeChild(row);
            if (tbody.rows.length === 0) {
                document.getElementById("productTableHeader").style.display = "none";
            }
            toggleSaveButton();
        }

        function toggleSaveButton() {
            var tbody = document.getElementById("productTable").getElementsByTagName('tbody')[0];
            var saveButton = document.getElementById("saveButton");
            if (tbody.rows.length > 0) {
                saveButton.style.display = "inline";
            } else {
                saveButton.style.display = "none";
            }
        }
    </script>
    
    <script>
        function confirmFinish() {
            return confirm('Are you sure you want to finish editing and save the quote?');
        }
    
        function confirmCancel() {
            if (confirm('Are you sure you want to leave? All unsaved changes will lose!')) {
                window.location.href = '?opt=search';
            }
        }
        function confirmCancel2() {
            if (confirm('Are you sure you want to cancel?')) {
                window.location.href = '?opt=summary&quoteNumber=<?php echo $quote_number; ?>';
            }
        }
    </script>
    <script>
        document.querySelectorAll('.editButton').forEach(button => {
            button.addEventListener('click', function() {
                const td = this.closest('td');
                const commentText = td.querySelector('.comment-text');
                const commentForm = td.querySelector('.commentForm');
                
                commentText.style.display = 'none';
                this.style.display = 'none';
                commentForm.style.display = 'block';
            });
        });

        document.querySelectorAll('.closeButton').forEach(button => {
            button.addEventListener('click', function() {
                const td = this.closest('td');
                const commentText = td.querySelector('.comment-text');
                const commentForm = td.querySelector('.commentForm');
                const editButton = td.querySelector('.editButton');
                
                commentText.style.display = 'block';
                editButton.style.display = 'block';
                commentForm.style.display = 'none';
            });
        });
    </script>

    <div id="div14" class="content-div">
        <form id="templateForm">
            <table style="width: 40%; margin: 20px auto;">
                <h2 style="text-align: center; margin: 20px auto;">Create New Template</h2>
                <input type="hidden" name="template_pax_num" value="<?php echo $adults_no+$children_no; ?>">
                <tr>
                    <td><label for="templateType">Template Type:</label></td>
                    <td>
                        <?php 
                            $templateType = (substr($quote_number, -1) === 'G') ? 'Group' : 'FIT';
                        ?>
                        <input type="text" id="templateType" name="templateType" value="<?= $templateType ?>" style="margin: 10px 0;" readonly>
                    </td>
                </tr>
                <tr>
                    <td><label for="templateName">Template Name:</label></td>
                    <td><input type="text" id="templateName" name="templateName" style="margin: 10px 0;" required></td>
                </tr>
                <tr>
                    <td><label for="templateCategory">Template Category:</label></td>
                    <td>
                        <select id="templateCategory" name="templateCategory" style="margin: 10px 0;" required>
                            <option value="SIC">SIC</option>
                            <option value="Private">Private</option>
                            <option value="SIC+Private">SIC+Private</option>
                            <option value="Group">Group</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td><label for="templateCity">Template City:</label></td>
                    <td>
                        <select id="templateCity" name="templateCity" style="margin: 10px 0;">
                            <option value="">All</option>
                            <?php
                            $sql_template_city = "SELECT DISTINCT tp.city FROM vtiger_inventoryproductrel vi 
                                                LEFT JOIN tdu_products tp ON vi.productid=tp.productid
                                                WHERE vi.id='$quoteid' AND tp.city IS NOT NULL";
                            $result_template_city = mysqli_query($conn, $sql_template_city);

                            if ($result_template_city && mysqli_num_rows($result_template_city) > 0) {
                                while ($row = mysqli_fetch_assoc($result_template_city)) {
                                    echo "<option value=\"" . htmlspecialchars(trim($row['city'])) . "\">" . htmlspecialchars($row['city']) . "</option>";
                                }
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td><label for="templateHighlights">Highlights:</label></td>
                    <td>
                        <textarea id="templateHighlights" name="templateHighlights" rows="8" style="margin: 10px 0; width: 500px;"></textarea>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align: center;">
                        <button id="makeTemplateButton" <?= $has_customised ? 'class="tooltip-template-disable" disabled' : '' ?> type="submit" style="height: 30px;" onclick="disableButton()">Make as Template</button>
                        <p id="processingMessage" style="display:none;">Processing, please wait...</p>

                        <script>
                            function disableButton() {
                                var button = document.getElementById('makeTemplateButton');
                                var message = document.getElementById('processingMessage');
                                
                                message.style.display = 'block';
                                setTimeout(function() {
                                    button.disabled = true;
                                }, 100);
                            }
                        </script>
                    </td>
                </tr>
            </table>
        </form>
    </div>
    <style>
        .tooltip-template-disable {
            position: relative;
            display: inline-block;
        }
        .tooltip-template-disable:hover::after {
            content: "Customized products are not allowed in template";
            position: absolute;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            background-color: black;
            color: white;
            padding: 5px;
            border-radius: 5px;
            white-space: nowrap;
            font-size: 24px;
            opacity: 0.8;
            text-transform: none !important;
        }
    </style>
    <script>
        document.getElementById('templateForm').addEventListener('submit', function(event) {
            event.preventDefault(); // Prevent default form submission

            // Collect form data
            let formData = new FormData(this);
            formData.append('quoteid', '<?php echo $quoteid; ?>'); // Add quote ID from PHP variable
            formData.append('country', '<?php echo $country; ?>'); // Add country from PHP variable

            // Send AJAX request
            fetch('ajax_process_template.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                alert(data); // Display server response
                document.getElementById('processingMessage').innerHTML = 'Template Saved!';
            })
            .catch(error => {
                console.error('Error:', error);
            });
        });
    </script>

    <div id="div17" class="content-div">
        <?php
        $sql = "SELECT task_id, subject, quote_no, assigned_to_region, assigned_to_user, category, status, priority, deadline, created_at 
                FROM tdu_tasks_management WHERE quote_no = '$quote_number'
                ORDER BY 
                    CASE WHEN deadline IS NULL THEN 1 ELSE 0 END ASC, 
                    deadline ASC, created_at DESC";
        $result = mysqli_query($conn, $sql);

        if ($result && mysqli_num_rows($result) > 0) {
            ?>
            <table class="styled-table" style="width: 100%; margin: 20px auto;">
                <tr>
                    <th style="text-align: center;"><button onclick="window.location.href='task.php?opt=add-new-tasks&quoteNumber=<?= $quote_number ?>'"><i class="fa-solid fa-plus"></i></button></th>
                    <th>ID</th>
                    <th style="text-align: left;">Subject</th>
                    <th>Quote No</th>
                    <th>Assigned Region</th>
                    <th>Assigned User</th>
                    <th>Category</th>
                    <th>Status</th>
                    <th>Priority</th>
                    <th>Deadline</th>
                    <th>Created At</th>
                </tr>

                <?php while ($row = $result->fetch_assoc()): ?>
                    <?php
                    $iconColor = ''; 
                    if (isset($row['deadline']) && ($row['status'] == 'Open' || $row['status'] == 'In Progress')) {
                        $deadline_r = strtotime($row['deadline']);
                        $today = strtotime(date('Y-m-d'));
                        $threeDaysLater = strtotime('+3 days', $today);

                        if ($deadline_r <= $today) {
                            $iconColor = 'red'; // Past deadline
                        } elseif ($deadline_r <= $threeDaysLater) {
                            $iconColor = 'orange'; // Within 3 days
                        }
                    }
                    ?>
                    <tr>
                        <td></td>
                        <td><?= htmlspecialchars($row['task_id']); ?></td>
                        <td style="text-align: left;">
                            <?php if ($iconColor): ?>
                                <i class="fa-solid fa-circle-exclamation" style="color: <?= $iconColor; ?>"></i>
                            <?php endif; ?>
                            <a href="task.php?opt=task-details&id=<?php echo urlencode($row['task_id']); ?>"><?php echo htmlspecialchars($row['subject']); ?></a>
                        </td>
                        <td>
                            <?php echo htmlspecialchars($row['quote_no']); ?>
                            <a href="quote.php?opt=quote-product-faq&quoteNumber=<?php echo urlencode($row['quote_no']); ?>" target="_blank"><i class="fa-solid fa-circle-question"></i></a>
                        </td>
                        <td><?= htmlspecialchars($row['assigned_to_region']); ?></td>
                        <td><?= htmlspecialchars($row['assigned_to_user']); ?></td>
                        <td><?= htmlspecialchars($row['category']); ?></td>
                        <td><?= htmlspecialchars($row['status']); ?></td>
                        <td><?= htmlspecialchars($row['priority']); ?></td>
                        <td><?= $row['deadline'] ? date('d-M-Y', strtotime($row['deadline'])) : ''; ?></td>
                        <td><?= date('d-M-Y', strtotime($row['created_at'])); ?></td>
                    </tr>
                <?php endwhile; ?>
            </table>
            <?php
        } else {
            echo "<p style='margin: 20px;'>No tasks found</p>";
        }
        ?>
    </div>
    <?php
}
else if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'products-csv-analysis') {
    include "products_csv_analysis.php";
}
else if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'hotel-pax') {
    $quote_id = $_GET['quoteid'];
    $quote_number = $_GET['quoteNumber'];
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $sql = "DELETE FROM vtiger_pax_in_hotel WHERE quoteid='$quote_id';";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        
        $room_count = isset($_POST['room_count']) ? (int)$_POST['room_count'] : 0;
        $roomTypeMap = ['Single' => 1, 'Double' => 2, 'Twin' => 2, 'Triple' => 3, 'Quad' => 4, 'Self Booking' => 1];
    
        // Loop through rooms based on room_count
        for ($sequence_no = 1; $sequence_no <= $room_count; $sequence_no++) {
            if (isset($_POST["room_type_$sequence_no"])) {
                $room_type = $_POST["room_type_$sequence_no"];
                $num_children = $_POST["num_children_$sequence_no"] ?? 0;
                $child_type = $_POST["child_type_$sequence_no"];
                $phone = $_POST["phone_$sequence_no"];
                $country_code = $_POST["country_code_$sequence_no"];

                $totalOccupants = $roomTypeMap[$room_type] + (int)$num_children;
                if($child_type == 'child_with_bed') {
                    $totalOccupants -= (int)$num_children;
                }
    
                for ($i = 1; $i <= $totalOccupants; $i++) {
                    $title = $_POST["title_{$sequence_no}_{$i}"] ?? '';
                    $surname = $_POST["surname_{$sequence_no}_{$i}"] ?? '';
                    $given_name = $_POST["given_name_{$sequence_no}_{$i}"] ?? '';
                    $child_age = $_POST["child_age_{$sequence_no}"] ?? '';  // Get child age
        
                    $title = $conn->real_escape_string($title);
                    $surname = $conn->real_escape_string($surname);
                    $given_name = $conn->real_escape_string($given_name);
                    $child_age = $conn->real_escape_string($child_age);
                    $phone = $conn->real_escape_string($phone);
        
                    // Insert into the vtiger_pax_in_hotel table
                    $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_seq_no, title, surname, given_name, phone_code, phone, room_type, num_child, child_type, child_age) 
                            VALUES ($quote_id, $sequence_no, '$title', '$surname', '$given_name', '$country_code', '$phone', '$room_type', '$num_children', '$child_type', '$child_age')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }
        }        
    
        $referrer = $_POST['referrer'] ?? '';
        if($referrer) {
            header("Location: $referrer");
            exit();
        }
    }
    
    include "header.php";
    $sql = "SELECT child_ages FROM vtiger_quotes WHERE quoteid='$quote_id'";
    $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));
    $child_ages = '';
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $child_ages = $row['child_ages']?? '';
    }

    // Fetch existing data from the vtiger_pax_in_hotel table
    $sql = "SELECT * FROM vtiger_pax_in_hotel WHERE quoteid='$quote_id' ORDER BY room_seq_no ASC";
    $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

    $existing_rooms = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $existing_rooms[] = $row;
    }
    
    ?>
    <form method="POST" action="">
        <h2 style="margin: 15px;">
            <a style="margin-right: 15px;" href="javascript:window.history.back();" class="back-icon"><i class="fas fa-arrow-left"></i></a>
            <?php echo $quote_number; ?> - Pax List
        </h2>
        <input type="hidden" name="referrer" value="<?= htmlspecialchars($_SERVER['HTTP_REFERER'] ?? '') ?>">
        <table class="styled-table">
            <thead>
                <tr>
                    <th style="width:3%;">Room NO</th>
                    <th style="width:3%;">Room Type</th>
                    <th style="width:3%;">Additional residents</th>
                    <th style="width:3%;">Child Type</th>
                    <th>Phone Number</th>
                    <th style="width:5%;"></th>
                    <th></th>
                    <th></th>
                    <th>Child Age</th>
                    <th></th>
                </tr>
            </thead>
            <tbody id="room_container">
                <?php 
                $count = 0;
                // Populate existing rooms if data is available
                foreach ($existing_rooms as $index => $room) {
                    $sequence_no = $room['room_seq_no'];
                    if($count == $sequence_no) {
                        continue;
                    }
                    $count = $sequence_no;
                    $room_type = $room['room_type'];
                    $num_children = $room['num_child'] ?? 0;
                    $child_type = $room['child_type'];
                    $child_age = $room['child_age'];
                    $phone = $room['phone'];
                    $country_code = $room['phone_code'];
                
                    $ages_array = explode(',', $child_ages);
                    $child_age_field = '<td></td>';
                    if ($child_type == 'child_with_bed' || $child_type == 'child_without_bed') {
                        $child_age_field = "<td>
                                                <select name='child_age_$sequence_no'>";
                        
                        // Add an empty option as default
                        $child_age_field .= "<option value=''></option>";
                    
                        foreach ($ages_array as $age) {
                            // Check if the current age matches the selected child_age
                            $selected = ($age == $child_age) ? 'selected' : '';
                            $child_age_field .= "<option value='$age' $selected>$age</option>";
                        }
                    
                        $child_age_field .= "</select>
                                            </td>";
                    }

                    $del_rooming = "";
                    if($title != 'sales' && $title != 'external') {
                        $del_rooming = "<button type='button' style='background-color: red; color: white;' onclick='deleteRoom($sequence_no)'>Del</button>";
                    }
                
                    echo "
                    <tr id='room_row_$sequence_no'>
                        <td>$sequence_no</td>
                        <td>
                            <select name='room_type_$sequence_no' onchange='handleRoomSelection($sequence_no)' required>
                                <option value=''>Select Room Type</option>
                                <option value='Single' " . ($room_type == 'Single' ? 'selected' : '') . ">Single</option>
                                <option value='Double' " . ($room_type == 'Double' ? 'selected' : '') . ">Double</option>
                                <option value='Twin' " . ($room_type == 'Twin' ? 'selected' : '') . ">Twin</option>
                                <option value='Triple' " . ($room_type == 'Triple' ? 'selected' : '') . ">Triple</option>
                                <option value='Quad' " . ($room_type == 'Quad' ? 'selected' : '') . ">Quad</option>
                                <option value='Self Booking' " . ($room_type == 'Self Booking' ? 'selected' : '') . ">Self Booking</option>
                            </select>
                        </td>
                        <td><input type='number' name='num_children_$sequence_no' value='$num_children' min='0' onchange='handleRoomSelection($sequence_no)'></td>
                        <td>
                            <select name='child_type_$sequence_no' onchange='handleRoomSelection($sequence_no)'>
                                <option value=''>No Child</option>
                                <option value='child_with_bed' " . ($child_type == 'child_with_bed' ? 'selected' : '') . ">Child with Bed</option>
                                <option value='child_without_bed' " . ($child_type == 'child_without_bed' ? 'selected' : '') . ">Child without Bed</option>
                                <option value='infant' " . ($child_type == 'infant' ? 'selected' : '') . ">Infant</option>
                            </select>
                        </td>
                        <td>
                            <input type='text' id='country_code_$sequence_no' name='country_code_$sequence_no' value='{$country_code}' placeholder='+91' pattern='\+\d{1,4}' style='width: 15%;'>
                            <input type='tel' id='phone_$sequence_no' name='phone_$sequence_no' value='{$phone}' placeholder='Phone' pattern='[0-9]{6,15}' style='width: 75%;'>
                            <button type='button' onclick='copyPhone({$sequence_no})'><i class='fa-regular fa-copy' title='Same as Above'></i></button>
                        </td>
                        <td colspan='3'>
                            <table id='occupants_table_$sequence_no' style='width: 100%; border: 1px solid black;'>
                                <tbody id='occupants_table_body_$sequence_no'>
                                    " . generateOccupantsRows($conn, $quote_id, $quote_sequence_no, $sequence_no) . "
                                </tbody>
                            </table>
                        </td>
                        $child_age_field
                        <td>$del_rooming</td>
                    </tr>";
                }
                ?>
            </tbody>
        </table>
        <input type="hidden" id="room_count" name="room_count" value="<?php echo $count; ?>">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <?php if(true) : ?>
                <div style="margin: 20px 0;">
                    <button type="submit" style="display: inline; margin: 0 15px;">Save</button>
                    <button type="button" onclick="addRoom()" style="margin-left: 15px;">Add Room</button>
                    <button type="button" onclick="openModal()">CSV Import/Export</button>
                </div>
            <?php endif;?>
        </div>
    </form>
    <script>
        function copyPhone(sequence) {
            sequence -= 1;
            let prevPhoneField = document.getElementById('phone_' + sequence);
            let prevPhoneCodeField = document.getElementById('country_code_' + sequence);
            sequence += 1;
            let currentPhoneField = document.getElementById('phone_' + sequence);
            let currentPhoneCodeField = document.getElementById('country_code_' + sequence);
            if (prevPhoneField && currentPhoneField) {
                currentPhoneField.value = prevPhoneField.value;
            }
            if (prevPhoneCodeField && currentPhoneCodeField) {
                currentPhoneCodeField.value = prevPhoneCodeField.value;
            }
        }
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.querySelectorAll("select[name^='child_age_']").forEach(select => {
                select.addEventListener("change", function () {
                    updateChildAgeOptions();
                });
            });
        });

        function updateChildAgeOptions() {
            let selectedAges = new Set();

            // Collect all selected child ages (excluding empty selections)
            document.querySelectorAll("select[name^='child_age_']").forEach(select => {
                if (select.value !== "") {
                    selectedAges.add(select.value);
                }
            });

            // Update all dropdowns
            document.querySelectorAll("select[name^='child_age_']").forEach(select => {
                let currentSelection = select.value;
                let options = Array.from(select.options);

                // To track if we have already hidden an option value in the current dropdown
                let hiddenValues = new Set();

                options.forEach(option => {
                    if (option.value !== "") {
                        // Only hide the option if it is selected in another dropdown and hasn't been hidden yet
                        if (selectedAges.has(option.value) && option.value !== currentSelection && !hiddenValues.has(option.value)) {
                            option.hidden = true;
                            hiddenValues.add(option.value);
                        } else {
                            option.hidden = false;
                        }
                    }
                });
            });
        }
    </script>

    <!-- The Modal -->
    <div id="csvModal" style="display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.4); padding-top: 60px;">
        <div style="background-color: #fefefe; margin: 5% auto; padding: 20px; border: 1px solid #888; width: 80%; max-width: 500px; border-radius: 10px;">
            <span onclick="closeModal()" style="color: #aaa; font-size: 28px; font-weight: bold; position: absolute; top: 10px; right: 20px; cursor: pointer;">&times;</span>
            
            <form action="ajax_hotel_handler.php" method="post" enctype="multipart/form-data">
                <input type="hidden" name="quoteid" value="<?php echo $quote_id; ?>">
                <input type="hidden" name="quoteNumber" value="<?php echo $quote_number; ?>">

                <div style="max-width: 400px; margin: 15px; padding: 20px; border: 1px solid #ccc; border-radius: 8px;">
                    <label for="file" style="display: block; margin-bottom: 5px; font-weight: bold;">Import CSV File:</label>
                    <input type="file" name="csv_file" id="file" accept=".csv" onchange="toggleUploadButton()" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                    <div id="buttonContainer" style="display: none; margin-top: 10px;">
                        <button type="submit" name="upload">Upload</button>
                    </div>
                </div>

                <div style="max-width: 400px; margin: 15px; padding: 20px; border: 1px solid #ccc; border-radius: 8px;">
                    <label for="file" style="display: block; margin-bottom: 5px; font-weight: bold;">Export CSV File:</label>
                    <button type="submit" name="download">Download</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Get modal element
        var modal = document.getElementById("csvModal");

        function openModal() {
            modal.style.display = "block";
        }

        function closeModal() {
            modal.style.display = "none";
        }

        window.onclick = function(event) {
            if (event.target === modal) {
                modal.style.display = "none";
            }
        }
    </script>

    <script>
        function toggleUploadButton() {
            const fileInput = document.getElementById('file');
            const buttonContainer = document.getElementById('buttonContainer');
            buttonContainer.style.display = fileInput.files.length > 0 ? 'block' : 'none';
        }
    </script>

    <style>
        #room_container td{
            border-bottom: 1px solid #ddd;
        }
        #room_container td input{
            width: 100%;
            padding: 5px;
        }
        #room_container select {
            margin-bottom: 0;
        }
    </style>
    <script>
        function generateRows(sequence, roomType, numChildren) {
            const roomTypeMap = {
                'Single': 1,
                'Double': 2,
                'Twin': 2,
                'Triple': 3,
                'Quad': 4,
                'Self Booking': 1
            };

            const tableBody = document.getElementById(`occupants_table_body_${sequence}`);
            tableBody.innerHTML = ''; // Clear previous rows

            // Number of adults based on room type
            let totalOccupants = roomTypeMap[roomType] || 0;
            totalOccupants += parseInt(numChildren) || 0;

            // Generate rows
            for (let i = 1; i <= totalOccupants; i++) {
                const row = document.createElement('tr');

                // Title
                const titleCell = document.createElement('td');
                titleCell.style = 'width: 10%;';
                const titleSelect = document.createElement('select');
                titleSelect.name = `title_${sequence}_${i}`;

                const titles = ['Mr', 'Mrs', 'Miss', 'Ms', 'MSTR'];

                titles.forEach(title => {
                    const option = document.createElement('option');
                    option.value = title;
                    option.textContent = title;
                    titleSelect.appendChild(option);
                });

                titleCell.appendChild(titleSelect);
                row.appendChild(titleCell);

                // Given Name
                const givenNameCell = document.createElement('td');
                const givenNameInput = document.createElement('input');
                givenNameInput.type = 'text';
                givenNameInput.placeholder = 'Given Name';
                givenNameInput.name = `given_name_${sequence}_${i}`;
                givenNameCell.appendChild(givenNameInput);
                row.appendChild(givenNameCell);

                // Surname
                const surnameCell = document.createElement('td');
                const surnameInput = document.createElement('input');
                surnameInput.type = 'text';
                surnameInput.placeholder = 'Surname';
                surnameInput.name = `surname_${sequence}_${i}`;
                surnameCell.appendChild(surnameInput);
                row.appendChild(surnameCell);

                tableBody.appendChild(row);
            }
        }

        function handleRoomSelection(sequence) {
            const roomType = document.querySelector(`select[name="room_type_${sequence}"]`).value;
            const childType = document.querySelector(`select[name="child_type_${sequence}"]`).value;
            const numChildren = document.querySelector(`input[name="num_children_${sequence}"]`).value;
            if (childType == 'child_with_bed') {
                generateRows(sequence, roomType, 0);
            } else {
                generateRows(sequence, roomType, numChildren);
            }
        }

        function addRoom() {
            let roomCount = parseInt(document.getElementById('room_count').value);
            roomCount++;
            document.getElementById('room_count').value = roomCount;
            const roomContainer = document.getElementById('room_container');

            const roomRow = document.createElement('tr');
            roomRow.id = `room_row_${roomCount}`;

            roomRow.innerHTML = `
                <td>${roomCount}</td>
                <td>
                    <select name="room_type_${roomCount}" onchange="handleRoomSelection(${roomCount})" required>
                        <option value="">Select Room Type</option>
                        <option value="Single">Single</option>
                        <option value="Double">Double</option>
                        <option value="Twin">Twin</option>
                        <option value="Triple">Triple</option>
                        <option value="Quad">Quad</option>
                        <option value="Self Booking">Self Booking</option>
                    </select>
                </td>
                <td>
                    <input type="number" name="num_children_${roomCount}" value="0" min="0" onchange="handleRoomSelection(${roomCount})">
                </td>
                <td>
                    <select name="child_type_${roomCount}" onchange="handleRoomSelection(${roomCount})">
                        <option value="">No Child</option>
                        <option value="child_with_bed">Child with Bed</option>
                        <option value="child_without_bed">Child without Bed</option>
                        <option value="infant">Infant</option>
                    </select>
                </td>
                <td>
                    <input type="text" id="country_code_${roomCount}" name="country_code_${roomCount}" placeholder="+91" pattern="\\+\\d{1,4}" style="width: 15%;">
                    <input type="tel" id="phone_${roomCount}" name="phone_${roomCount}" placeholder="Phone" pattern="[0-9]{6,15}" style="width: 75%;">
                    <button type="button" onclick="copyPhone(${roomCount})">
                        <i class="fa-regular fa-copy" title="Same as Above"></i>
                    </button>
                </td>
                <td colspan="3">
                    <table id="occupants_table_${roomCount}" style="width: 100%; border: 1px solid black;">
                        <tbody id="occupants_table_body_${roomCount}">
                            <!-- Occupants rows will be dynamically added here -->
                        </tbody>
                    </table>
                </td>
                <td></td>
                <td>
                    <button type="button" style="background-color: red; color: white;" onclick="deleteRoom(${roomCount})">Del</button>
                </td>
            `;

            roomContainer.appendChild(roomRow);
        }

        function deleteRoom(sequence) {
            const roomRow = document.getElementById(`room_row_${sequence}`);
            if (roomRow) {
                roomRow.remove();
            }
        }
    </script>
    <?php
}
else if(($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'rezdy-booking') {
    include "header.php";
    include "rezdyconn.php";

    $quote_number = $_GET['quoteNumber'];
    $sql = "SELECT vq.quoteid, vq.adults, vqcf.cf_1162 FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            WHERE quote_no = '$quote_number'
            ORDER BY vq.quoteid ASC;";
    $result = mysqli_query($conn, $sql);
    if ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'] ?? '';
        $date_of_travel = $row['cf_1162'] ?? '';
        $adults_no = $row['adults'] ?? 0;
    } 
    if (empty($quoteid) || empty($date_of_travel)) {
        echo "Quote not found.";
        exit;
    }

    // Fetch NEGOTIATED products (cash)
    $sql_negotiated = "SELECT vi.day, vi.tourtime, vi.sequence_no, tp.city, tp.productName, tp.rezdy_uni_code, tp.rezdy_uni_category 
                    FROM vtiger_inventoryproductrel vi
                    LEFT JOIN tdu_products tp ON vi.productid=tp.productid
                    WHERE vi.id = '$quoteid' AND booking_status = 'Pending'
                        AND tp.rezdy_uni_category = 'negotiated'
                        AND tp.rezdy_uni_code IS NOT NULL AND tp.rezdy_uni_code != '';";
    $result_negotiated = mysqli_query($conn, $sql_negotiated);

    // Fetch MARKETPLACE products (card)
    $sql_marketplace = "SELECT vi.day, vi.tourtime, vi.sequence_no, tp.city, tp.productName, tp.rezdy_uni_code, tp.rezdy_uni_category 
                        FROM vtiger_inventoryproductrel vi
                        LEFT JOIN tdu_products tp ON vi.productid=tp.productid
                        WHERE vi.id = '$quoteid' AND booking_status = 'Pending'
                        AND tp.rezdy_uni_category = 'marketplace'
                        AND tp.rezdy_uni_code IS NOT NULL AND tp.rezdy_uni_code != '';";
    $result_marketplace = mysqli_query($conn, $sql_marketplace);
    ?>

    <style>
        .operation-table {
            margin: 10px;
            width: 99%;
            border-collapse: collapse;
        }
        
        .operation-table th, .operation-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }

        .operation-table td input[type="text"],
        .operation-table td input[type="number"],
        .operation-table td input[type="date"],
        .operation-table td textarea,
        .operation-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>

    <h1 style="text-align: center; margin: 20px 0;">Rezdy Booking</h1>
    <h2 style="text-align: left; margin: 20px;">
        <a href="quote.php?opt=summary&quoteNumber=<?= $quote_number ?>">
            <?= $quote_number ?>
        </a>
    </h2>

    <hr>

    <!-- NEGOTIATED TABLE -->
    <h3 style="margin: 20px;">Negotiated Rate Products</h3>
    <table class="operation-table" style="width: 95%; margin: 20px;">
        <tr>
            <th></th>
            <th>Tour Time</th>
            <th>Rezdy session</th>
            <th>Adult Price</th>
            <th>Child Price</th>
            <th>Rezdy Code</th>
            <th style="width: 25%;">Dashboard Product Name</th>
            <th style="width: 25%;">Rezdy Product Name</th>
            <th>Type</th>
            <th>City</th>
        </tr>
        <?php if ($result_negotiated && mysqli_num_rows($result_negotiated) > 0): ?>
            <?php while ($row = mysqli_fetch_assoc($result_negotiated)): ?>
                <tr>
                    <td class="rezdy-checked-icon" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>-cash">
                        <i class="fa-solid fa-circle-xmark" style="color: red;"></i>
                    </td>
                    <td>
                        <?php
                        $day = (int) $row['day'] - 1;
                        $startDate = new DateTime($date_of_travel);
                        $startDate->modify("+" . $day . " days");
                        $formattedDate = $startDate->format('Y-m-d');
                        echo $startDate->format('d-M-Y') . ' ' . $row['tourtime'];
                        ?>
                    </td>
                    <td>
                        <select class="rezdy-times" 
                            data-seq="<?= htmlspecialchars($row['sequence_no']) ?>-cash"
                            data-code="<?= htmlspecialchars($row['rezdy_uni_code']) ?>" 
                            data-date="<?= $formattedDate ?>"
                            data-expected-time="<?= htmlspecialchars($row['tourtime']) ?>">
                            <option value="">Select time</option>
                        </select>
                    </td>
                    <td class="adult-price" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>-cash"></td>
                    <td class="child-price" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>-cash"></td>
                    <td><?= htmlspecialchars($row['rezdy_uni_code']); ?></td>
                    <td><?= htmlspecialchars($row['productName']); ?></td>
                    <td>
                        <?php
                        $rezdyProductCode = $row['rezdy_uni_code'];
                        $rezdy_sql = "SELECT name AS rezdy_productname FROM products WHERE productCode = '$rezdyProductCode'";
                        $rezdy_result = mysqli_query($rezdyconn, $rezdy_sql);
                        if ($rezdy_result && mysqli_num_rows($rezdy_result) > 0) {
                            $rezdy_row = mysqli_fetch_assoc($rezdy_result);
                            echo htmlspecialchars($rezdy_row['rezdy_productname']);
                        } else {
                            echo "N/A";
                        }
                        ?>
                    </td>
                    <td><?= htmlspecialchars(strtoupper($row['rezdy_uni_category'])); ?></td>
                    <td><?= htmlspecialchars($row['city']); ?></td>
                </tr>
            <?php endwhile; ?>
            <tr><td colspan="10">
                <input type="text" id="special-request-negotiated" placeholder="Special Requirements to supplier" style="width: 100%; height: 30px; padding: 5px;">
            </td></tr>
        <?php else: ?>
            <tr><td colspan="10">No negotiated rate bookings pending.</td></tr>
        <?php endif; ?>
    </table>

    <?php if (mysqli_num_rows($result_negotiated) > 0): ?>
        <button type="button" id="rezdy-cash-submit" style="margin: 20px; padding: 10px 20px; margin-top: 0;">Place Order</button>
    <?php endif; ?>

    <hr>

    <!-- MARKETPLACE TABLE -->
    <h3 style="margin: 20px;">Marketplace Rate Products</h3>
    <table class="operation-table" style="width: 95%; margin: 20px;">
        <tr>
            <th></th>
            <th>Tour Time</th>
            <th>Rezdy session</th>
            <th>Adult Price</th>
            <th>Child Price</th>
            <th>Rezdy Code</th>
            <th style="width: 25%;">Dashboard Product Name</th>
            <th style="width: 25%;">Rezdy Product Name</th>
            <th>Type</th>
            <th>City</th>
        </tr>
        <?php if ($result_marketplace && mysqli_num_rows($result_marketplace) > 0): ?>
            <?php while ($row = mysqli_fetch_assoc($result_marketplace)): ?>
                <tr>
                    <td class="rezdy-checked-icon" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>">
                        <i class="fa-solid fa-circle-xmark" style="color: red;"></i>
                    </td>
                    <td>
                        <?php
                        $day = (int) $row['day'] - 1;
                        $startDate = new DateTime($date_of_travel);
                        $startDate->modify("+" . $day . " days");
                        $formattedDate = $startDate->format('Y-m-d');
                        echo $startDate->format('d-M-Y') . ' ' . $row['tourtime'];
                        ?>
                    </td>
                    <td>
                        <select class="rezdy-times" 
                            data-seq="<?= htmlspecialchars($row['sequence_no']) ?>"
                            data-code="<?= htmlspecialchars($row['rezdy_uni_code']) ?>" 
                            data-date="<?= $formattedDate ?>"
                            data-expected-time="<?= htmlspecialchars($row['tourtime']) ?>">
                            <option value="">Select time</option>
                        </select>
                    </td>
                    <td class="adult-price" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>"></td>
                    <td class="child-price" data-seq="<?= htmlspecialchars($row['sequence_no']) ?>"></td>
                    <td><?= htmlspecialchars($row['rezdy_uni_code']); ?></td>
                    <td><?= htmlspecialchars($row['productName']); ?></td>
                    <td>
                        <?php
                        $rezdyProductCode = $row['rezdy_uni_code'];
                        $rezdy_sql = "SELECT name AS rezdy_productname FROM products WHERE productCode = '$rezdyProductCode'";
                        $rezdy_result = mysqli_query($rezdyconn, $rezdy_sql);
                        if ($rezdy_result && mysqli_num_rows($rezdy_result) > 0) {
                            $rezdy_row = mysqli_fetch_assoc($rezdy_result);
                            echo htmlspecialchars($rezdy_row['rezdy_productname']);
                        } else {
                            echo "N/A";
                        }
                        ?>
                    </td>
                    <td><?= htmlspecialchars(strtoupper($row['rezdy_uni_category'])); ?></td>
                    <td><?= htmlspecialchars($row['city']); ?></td>
                </tr>
            <?php endwhile; ?>
            <tr><td colspan="10">
                <input type="text" id="special-request-marketplace" placeholder="Special Requirements to supplier" style="width: 100%; height: 30px; padding: 5px;">
            </td></tr>
        <?php else: ?>
            <tr><td colspan="10">No marketplace rate bookings pending.</td></tr>
        <?php endif; ?>
    </table>

    <!-- STRIPE CARD PAYMENT FORM -->
    <form id="rezdy-payment-form" style="width: 25%; border: 1px solid black; padding: 20px; margin: 20px; <?= mysqli_num_rows($result_marketplace) > 0 ? '' : 'display: none;' ?>">
        <h3 style="text-align: center;">Stripe Card Payment</h3>
        <div id="card-element" style="margin: 20px 0; border: 1px solid #ccc; padding: 10px;">
            <!-- A Stripe Element will be inserted here. -->
        </div>
        <div id="card-errors" role="alert" style="color: red; margin-bottom: 20px;"></div>
        <button id="rezdy-card-submit" type="submit" style="width: 100%; height: 30px;">Place Order</button>
    </form>

    <hr>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        const stripe = Stripe('pk_test_51KW8A8ItvA6u4On8YM6AE95ytcqBr0LeRBEEFw4f5MDQPTDBWVt2TAWXhfynCn7NUVwaGc2eP431DNCkmfMaB0AF00firEVJ58');
        const elements = stripe.elements();
        const card = elements.create('card');
        card.mount('#card-element');

        const form = document.getElementById('rezdy-payment-form');
        const errorDiv = document.getElementById('card-errors');

        form.addEventListener('submit', async (event) => {
            event.preventDefault();
            document.getElementById('rezdy-card-submit').disabled = true;
            document.getElementById('rezdy-card-submit').innerHTML = 'Processing...';

            const { token, error } = await stripe.createToken(card);

            if (error) {
                errorDiv.textContent = error.message;
                return;
            }

            errorDiv.textContent = '';
            const timeSelections = {};
            document.querySelectorAll('.rezdy-times').forEach(select => {
                const seq = select.getAttribute('data-seq');
                if (seq.endsWith('-cash')) return; // Skip negotiated rows
                const selectedTime = select.value;
                if (selectedTime) {
                    const adult = document.querySelector(`.adult-price[data-seq="${seq}"]`);
                    const child = document.querySelector(`.child-price[data-seq="${seq}"]`);
                    timeSelections[seq] = {
                        time: selectedTime,
                        adultPrice: adult?.textContent.trim(),
                        childPrice: child?.textContent.trim()
                    };
                }
            });

            // Block if all selectedTime values are empty
            const hasValidSelection = Object.keys(timeSelections).length > 0;
            if (!hasValidSelection) {
                alert('Please select time session before submitting.');
                document.querySelectorAll('.rezdy-times').forEach(select => {
                    const seq = select.getAttribute('data-seq');
                    if (seq.endsWith('-cash')) return; // Skip negotiated rows

                    if (select.value) {
                        hasValidSelection = true;
                    } else {
                        select.style.backgroundColor = '#f8d7da';
                        setTimeout(() => {
                            select.style.backgroundColor = '';
                        }, 5000);
                    }
                });
                document.getElementById('rezdy-card-submit').disabled = false;
                document.getElementById('rezdy-card-submit').innerHTML = 'Place Order';
                return;
            }

            const quoteid = <?= json_encode($quoteid); ?>;
            const specialRequirementsMarketplace = document.getElementById('special-request-marketplace').value;
            const postData = `quoteid=${encodeURIComponent(quoteid)}&cardToken=${encodeURIComponent(token.id)}&timeSelections=${encodeURIComponent(JSON.stringify(timeSelections))}&specialRequirements=${encodeURIComponent(specialRequirementsMarketplace)}`;
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_rezdy_booking.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = () => {
                if (xhr.status === 200) {
                    const res = JSON.parse(xhr.responseText);
                    alert(res.message);
                    window.location = 'quote.php?opt=summary&quoteNumber=<?= $quote_number ?>&edit=div-rezdy';
                } else {
                    alert('Failed to process.');
                }
            };
            xhr.send(postData);
        });

        // Handle cash booking submit
        document.getElementById('rezdy-cash-submit')?.addEventListener('click', function () {
            document.getElementById('rezdy-cash-submit').disabled = true;
            document.getElementById('rezdy-cash-submit').innerHTML = 'Processing...';

            const timeSelections = {};
            document.querySelectorAll('.rezdy-times').forEach(select => {
                const seq = select.getAttribute('data-seq');
                if (!seq.endsWith('-cash')) return;
                const selectedTime = select.value;
                if (selectedTime) {
                    const adult = document.querySelector(`.adult-price[data-seq="${seq}"]`);
                    const child = document.querySelector(`.child-price[data-seq="${seq}"]`);
                    timeSelections[seq.replace('-cash', '')] = {
                        time: selectedTime,
                        adultPrice: adult?.textContent.trim(),
                        childPrice: child?.textContent.trim()
                    };
                }
            });

            const hasValidSelection = Object.keys(timeSelections).length > 0;
            if (!hasValidSelection) {
                alert('Please select time session before submitting.');
                document.querySelectorAll('.rezdy-times').forEach(select => {
                    const seq = select.getAttribute('data-seq');
                    if (!seq.endsWith('-cash')) return; // Skip marketplace rows

                    if (select.value) {
                        hasValidSelection = true;
                    } else {
                        select.style.backgroundColor = '#f8d7da';
                        setTimeout(() => {
                            select.style.backgroundColor = '';
                        }, 5000);
                    }
                });
                document.getElementById('rezdy-cash-submit').disabled = false;
                document.getElementById('rezdy-cash-submit').innerHTML = 'Place Order';
                return;
            }

            const quoteid = <?= json_encode($quoteid); ?>;
            const specialRequirementsNegotiated = document.getElementById('special-request-negotiated').value;
            const postData = `quoteid=${encodeURIComponent(quoteid)}&paymentType=cash&timeSelections=${encodeURIComponent(JSON.stringify(timeSelections))}&specialRequirements=${encodeURIComponent(specialRequirementsNegotiated)}`;
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_rezdy_booking.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = () => {
                if (xhr.status === 200) {
                    const res = JSON.parse(xhr.responseText);
                    alert(res.message);
                    window.location.reload();
                } else {
                    alert('Failed to process.');
                }
            };
            xhr.send(postData);
        });

        // Load times for all selects
        const adultsNoAvail = <?= json_encode($adults_no) ?>;
        document.querySelectorAll('.rezdy-times').forEach(select => {
            const code = select.getAttribute('data-code');
            const date = select.getAttribute('data-date');
            const expectedTime = select.getAttribute('data-expected-time');
            const seq = select.getAttribute('data-seq');

            select.innerHTML = '<option>Loading...</option>';

            fetch('ajax_rezdy_availability.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `productCode=${encodeURIComponent(code)}&startDate=${encodeURIComponent(date)}&adultsNo=${encodeURIComponent(adultsNoAvail)}`
            })
            .then(response => response.json())
            .then(data => {
                select.innerHTML = '';
                if (data.success && data.options.length) {
                    select.innerHTML = '<option value="">Select time</option>';
                    let matched = false;

                    data.options.forEach(opt => {
                        const option = document.createElement('option');
                        option.value = opt.time;
                        option.textContent = opt.time;
                        option.dataset.adultPrice = opt.adultPrice;
                        option.dataset.childPrice = opt.childPrice;

                        if (expectedTime && opt.time === expectedTime) {
                            option.selected = true;
                            matched = true;
                        }

                        select.appendChild(option);
                    });

                    if (matched) {
                        // Trigger change to update price + icon
                        const event = new Event('change');
                        select.dispatchEvent(event);
                    }
                } else {
                    select.innerHTML = '<option value="">No times available</option>';
                }
            })
            .catch(error => {
                console.error('Availability fetch error:', error);
                select.innerHTML = '<option>Error loading times</option>';
            });

            // Listen for changes to update prices & icon
            select.addEventListener('change', function () {
                const selected = this.options[this.selectedIndex];
                if (!selected || !selected.dataset.adultPrice || this.value === '') {
                    document.querySelector(`.adult-price[data-seq="${seq}"]`).textContent = '';
                    document.querySelector(`.child-price[data-seq="${seq}"]`).textContent = '';
                    document.querySelector(`.rezdy-checked-icon[data-seq="${seq}"]`).innerHTML = '<i class="fa-solid fa-circle-xmark" style="color: red;"></i>';
                    return;
                }

                this.style.backgroundColor = '';
                document.querySelector(`.adult-price[data-seq="${seq}"]`).textContent = selected.dataset.adultPrice;
                document.querySelector(`.child-price[data-seq="${seq}"]`).textContent = selected.dataset.childPrice;
                document.querySelector(`.rezdy-checked-icon[data-seq="${seq}"]`).innerHTML = '<i class="fa-solid fa-circle-check" style="color: green;"></i>';
            });
        });
    </script>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
