<?php
// Organizations
if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'organizations') {
    include "header.php";

    // Filters
    $orgIdsFilter = isset($_GET['id']) ? $_GET['id'] : '';
    $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
    $orgNameFilter = isset($_GET['organizationname']) ? $_GET['organizationname'] : '';
    $emailFilter = isset($_GET['email']) ? $_GET['email'] : '';
    $phoneFilter = isset($_GET['phone']) ? $_GET['phone'] : '';
    $websiteFilter = isset($_GET['website']) ? $_GET['website'] : '';
    $addressFilter = isset($_GET['address']) ? $_GET['address'] : '';
    $regionFilter = isset($_GET['region']) ? $_GET['region'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';
    $membershipNameFilter = isset($_GET['membership']) ? $_GET['membership'] : '';
    $activeFilter = isset($_GET['active']) ? (int) $_GET['active'] : 1;
    if($title != 'admin') {
        $activeFilter = 1;
    }

    if($title == 'external') {
        $sql = "SELECT department FROM vtiger_users WHERE id = '$global_user_id';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        $external_department = $row['department'] ?? '';
    }

    // Base query
    $sql = "SELECT 
                o.organizationid, 
                o.organization_name, 
                o.email, 
                o.phone, 
                o.website, 
                o.address, 
                o.region, 
                o.country, 
                o.preferred, 
                o.active, 
                m.membershipName,
                m.color, 
                toc.org_category
            FROM tdu_organisation o 
            LEFT JOIN tdu_membership m ON o.membershipid = m.membershipid
            LEFT JOIN tdu_organisation_category toc ON o.preferred = toc.cid
            WHERE o.active = $activeFilter 
    ";

    // Apply filters
    if ($orgNameFilter) {
        $sql .= " AND o.organization_name LIKE '%" . $conn->real_escape_string($orgNameFilter) . "%'";
    }
    if ($categoryFilter != '') {
        $sql .= " AND o.preferred = '" . $conn->real_escape_string($categoryFilter) . "'";
    }
    if ($emailFilter) {
        $sql .= " AND o.email LIKE '%" . $conn->real_escape_string($emailFilter) . "%'";
    }
    if ($phoneFilter) {
        $sql .= " AND o.phone LIKE '%" . $conn->real_escape_string($phoneFilter) . "%'";
    }
    if ($websiteFilter) {
        $sql .= " AND o.website LIKE '%" . $conn->real_escape_string($websiteFilter) . "%'";
    }
    if ($addressFilter) {
        $sql .= " AND o.address LIKE '%" . $conn->real_escape_string($addressFilter) . "%'";
    }
    if ($regionFilter) {
        $sql .= " AND o.region LIKE '%" . $conn->real_escape_string($regionFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND o.country LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }
    if ($orgIdsFilter) {
        $sql .= " AND o.organizationid IN (" . $conn->real_escape_string($orgIdsFilter) . ")";
    }
    if ($membershipNameFilter) {
        $sql .= " AND m.membershipName LIKE '%" . $conn->real_escape_string($membershipNameFilter) . "%'";
    }
    if ($title == 'external' && !empty($external_department)) {
        $departments = array_map('trim', explode(',', $external_department));
        $escaped_departments = array_map(function($dep) use ($conn) {
            return "'" . $conn->real_escape_string($dep) . "'";
        }, $departments);
        $sql .= " AND o.region IN (" . implode(',', $escaped_departments) . ")";
    }

    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY o.organization_name ASC LIMIT $limit OFFSET $offset";

    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Organizations</h1>

    <table class="styled-table" style="width: 95%; margin: 20px auto;">
        <tr>
            <th><button onclick="window.location.href='quote.php?opt=add-new-organization'">+ Org</button></th>
            <?php if ($title == 'admin') : ?>
            <th style="text-align: center; white-space: nowrap;">Category <button id="openCategoryModal">+</button></th>
            <?php endif; ?>
            <th style="text-align: left;">Organization Name</th>
            <th style="text-align: left;">Email</th>
            <th style="text-align: left;">Phone</th>
            <th style="text-align: left;">Website</th>
            <th style="text-align: left;">Address</th>
            <th style="text-align: left;">Region</th>
            <th style="text-align: left;">Country</th>
            <th style="text-align: left;">Tier</th>
            <th style="text-align: left;"></th>
        </tr>

        <form method="GET">
            <input type="hidden" name="opt" value="organizations">
            <tr>
                <td><button type="submit">Search</button></td>
                <?php if ($title == 'admin') : ?>
                <td>
                    <select name="category" style="width: 100%; margin: 0;">
                        <option value="">All</option>
                        <option value="0" <?= $categoryFilter == 0 ? 'selected' : '' ?>>None</option>
                        <?php
                        // Query to get the categories from the database
                        $sqlCat = "SELECT cid, org_category FROM tdu_organisation_category";
                        $resultCat = $conn->query($sqlCat);

                        if ($resultCat->num_rows > 0) {
                            while ($cat = $resultCat->fetch_assoc()) {
                                $selected = ($categoryFilter == $cat['cid']) ? 'selected' : '';
                                echo "<option value=\"" . (int)$cat['cid'] . "\" $selected>" . htmlspecialchars($cat['org_category']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </td>
                <?php endif; ?>
                <td>
                    <button type="button" class="mobile-search-btn" onclick="window.location.href='quote.php?opt=add-new-organization'">+</button>
                    <input type="text" class="org-mobile-input" name="organizationname" value="<?= htmlspecialchars($orgNameFilter); ?>">
                    <button type="submit" class="mobile-search-btn"><i class="fa-solid fa-magnifying-glass"></i></button>
                </td>
                <td><input type="text" name="email" value="<?= htmlspecialchars($emailFilter); ?>"></td>
                <td><input type="text" name="phone" value="<?= htmlspecialchars($phoneFilter); ?>"></td>
                <td><input type="text" name="website" value="<?= htmlspecialchars($websiteFilter); ?>"></td>
                <td><input type="text" name="address" value="<?= htmlspecialchars($addressFilter); ?>"></td>
                <td><input type="text" name="region" value="<?= htmlspecialchars($regionFilter); ?>"></td>
                <td><input type="text" name="country" value="<?= htmlspecialchars($countryFilter); ?>"></td>
                <td>
                    <select name="membership" style="width: 100px; margin: 0;">
                        <option value="" <?= ($membershipNameFilter === '') ? 'selected' : ''; ?>>All</option>
                        <?php
                        $membershipQuery = "SELECT membershipid, membershipName FROM tdu_membership";
                        $membershipResult = $conn->query($membershipQuery);
                        while ($membership = $membershipResult->fetch_assoc()):
                        ?>
                            <option value="<?= htmlspecialchars($membership['membershipName']); ?>" <?= ($membershipNameFilter === $membership['membershipName']) ? 'selected' : ''; ?>>
                                <?= htmlspecialchars($membership['membershipName']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </td>
                <td>
                    <?php if ($title == 'admin') : ?>
                    <select name="active" style="width: 100px; margin: 0;">
                        <option value="1" <?= ($activeFilter == '1') ? 'selected' : ''; ?>>Active</option>
                        <option value="0" <?= ($activeFilter == '0') ? 'selected' : ''; ?>>Inactive</option>
                    </select>
                    <?php endif; ?>
                </td>
            </tr>
        </form>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td>
                        <?php
                        if($title == 'admin') {
                            ?>
                            <input type="checkbox" class="row-checkbox" value="<?= $row['organizationid']; ?>">
                            <?php
                        }
                        ?>
                    </td>
                    <?php if ($title == 'admin') : ?>
                    <td style="text-align: center;"><?= ($row['preferred'] == 1) ? '<i class="fa-solid fa-key"></i>' : '' ?> <?= htmlspecialchars($row['org_category']); ?></td>
                    <?php endif; ?>
                    <td class="org-name" style="text-align: left; max-width: 20vw;">
                        <a href="quote.php?opt=organization-details&id=<?= urlencode($row['organizationid']); ?>">
                            <?= htmlspecialchars($row['organization_name'] == '' ? '[Untitled]' : $row['organization_name']); ?>
                        </a>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['email']); ?></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['phone']); ?></td>
                    <td style="text-align: left;">
                        <?php if (!empty($row['website'])): ?>
                            <a href="<?= htmlspecialchars($row['website']); ?>" target="_blank">
                                <?= htmlspecialchars($row['website']); ?>
                            </a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['address']); ?></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['region']); ?></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['country']); ?></td>
                    <td style="text-align: left; background-color: <?= $row['color'] ?>;"><?= htmlspecialchars($row['membershipName']); ?></td>
                    <td style="text-align: center;">
                        <?php if($row['active'] == 1) { ?>
                            <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                        <?php } else { ?>
                            <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                        <?php } ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            <?php
            if($title == 'admin') {
                ?>
                <tr>
                    <td><input type="checkbox" id="select-all" onclick="toggleSelectAll(this)"> All</td>
                    <td colspan="11" style="text-align: left;">
                        <button type="button" id="bulk-edit" onclick="openBulkEditModal()">Bulk Edit Tier</button>
                        <button type="button" id="bulk-status-edit" onclick="openBulkStatusModal()">Bulk Active/Inactive</button>
                        <button type="button" id="bulk-category-edit" onclick="openBulkCategoryModal()">Bulk Edit Category</button>
                    </td>
                </tr>
                <?php
            }
            ?>
            <tr>
                <td></td>
                <td colspan="12" style="text-align: left;">Number of results: <?= $totalRecords ?></td>
            </tr>
        <?php endif; ?>
    </table>

    <!-- Bulk edit Tier Modal start -->
    <div id="bulk-edit-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <h2>Bulk Edit Tiers:</h2>
        <select id="membership-select" style="width: 80%;">
            <?php
            $membershipQuery = "SELECT membershipid, membershipName FROM tdu_membership";
            $membershipResult = $conn->query($membershipQuery);
            while ($membership = $membershipResult->fetch_assoc()):
            ?>
                <option value="<?= $membership['membershipid']; ?>"><?= htmlspecialchars($membership['membershipName']); ?></option>
            <?php endwhile; ?>
        </select><br>
        <button onclick="applyBulkEdit()">Apply</button>
        <button onclick="closeModal()">Cancel</button>
    </div>
    <script>
        function toggleSelectAll(checkbox) {
            const checkboxes = document.querySelectorAll('.row-checkbox');
            checkboxes.forEach(cb => cb.checked = checkbox.checked);
        }

        function openBulkEditModal() {
            const modal = document.getElementById('bulk-edit-modal');
            modal.style.display = 'block';
        }

        function closeModal() {
            const modal = document.getElementById('bulk-edit-modal');
            modal.style.display = 'none';
        }

        function applyBulkEdit() {
            const selectedIds = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.value);
            const membershipId = document.getElementById('membership-select').value;

            if (selectedIds.length === 0 || !membershipId) {
                alert('Please select rows and membership.');
                return;
            }

            fetch('ajax_associate_membership.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ organizationIds: selectedIds, membershipId })
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    location.reload();
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>
    <!-- Bulk edit Tier Modal end -->

    <!-- Bulk del Modal Modal start -->
    <div id="bulk-status-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <h2>Bulk Edit:</h2>
        <select id="status-select" style="width: 80%;">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
        </select><br>
        <button onclick="applyBulkStatusEdit()">Apply</button>
        <button onclick="closeStatusModal()">Cancel</button>
    </div>
    <script>
        function openBulkStatusModal() {
            document.getElementById('bulk-status-modal').style.display = 'block';
        }

        function closeStatusModal() {
            document.getElementById('bulk-status-modal').style.display = 'none';
        }

        function applyBulkStatusEdit() {
            const selectedIds = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.value);
            const status = document.getElementById('status-select').value;

            if (selectedIds.length === 0 || !status) {
                alert('Please select rows and status.');
                return;
            }

            fetch('ajax_bulk_delete_org.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ organizationIds: selectedIds, status })
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    location.reload();
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>
    <!-- Bulk del Modal end -->

    <!-- Bulk ORG category Modal start -->
    <div id="bulk-category-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: auto; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <h2>Bulk Edit Organisation Category:</h2>
        <select id="category-select" style="width: 100%; margin: 20px 0;">
            <option value="">Select Category</option>
            <?php
            // Populate categories from the database
            $sqlCat = "SELECT cid, org_category FROM tdu_organisation_category";
            $resultCat = $conn->query($sqlCat);
            if ($resultCat->num_rows > 0) {
                while ($cat = $resultCat->fetch_assoc()) {
                    echo "<option value=\"" . (int)$cat['cid'] . "\">" . htmlspecialchars($cat['org_category']) . "</option>";
                }
            }
            ?>
        </select><br>
        <button onclick="applyBulkCategoryEdit()">Apply</button>
        <button onclick="closeCategoryModal()">Cancel</button>
    </div>
    <script>
        // Open the modal
        function openBulkCategoryModal() {
            document.getElementById('bulk-category-modal').style.display = 'block';
        }

        // Close the modal
        function closeCategoryModal() {
            document.getElementById('bulk-category-modal').style.display = 'none';
        }

        // Apply bulk category update
        function applyBulkCategoryEdit() {
            const selectedIds = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.value);
            const category = document.getElementById('category-select').value;

            if (selectedIds.length === 0 || !category) {
                alert('Please select rows and category.');
                return;
            }

            // Send selected rows and new category to the server
            fetch('ajax_bulk_update_org_category.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ organizationIds: selectedIds, category })
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    location.reload();
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>
    <!-- Bulk ORG category end -->

    <!-- New ORG Category Modal start -->
    <div id="quoteCategoryModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
        <div style="background: white; width: 30%; margin: 10% auto; padding: 20px; border-radius: 5px; position: relative;">
            <h3>Add New Organisation Category</h3>
            <button id="closeCategoryModal" style="position: absolute; top: 10px; right: 10px; background: red; color: white; border: none; padding: 5px;">
                <i class="fa-solid fa-xmark"></i>
            </button>
            <form id="add-category-form">
                <input type="text" id="newCategory" name="category" required style="width: 100%; padding: 5px;">
                <button type="submit" style="margin-top: 10px; cursor: pointer;">Save</button>
            </form>
        </div>
    </div>
    <script>
        // Open the modal
        document.getElementById('openCategoryModal').addEventListener('click', function () {
            document.getElementById('quoteCategoryModal').style.display = 'block';
        });

        // Close the modal
        document.getElementById('closeCategoryModal').addEventListener('click', function () {
            document.getElementById('quoteCategoryModal').style.display = 'none';
        });

        // Handle form submission to add a new category
        document.getElementById('add-category-form').addEventListener('submit', function (e) {
            e.preventDefault();

            let formData = new FormData(this);

            fetch('ajax_save_new_org_category.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                alert('Organisation category added successfully!');
                location.reload();
            })
            .catch(error => console.error('Error:', error));
        });
    </script>
    <!-- New ORG Category Modal end -->

    <script>
        function togglePreferred(organizationId, iconElement, newPreferredValue) {
            fetch('ajax_org_preferred.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ organizationId: organizationId, preferred: newPreferredValue })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    if (newPreferredValue === 1) {
                        iconElement.classList.remove('fa-regular', 'fa-heart');
                        iconElement.classList.add('fa-solid', 'fa-heart');
                        iconElement.style.color = 'red';
                        iconElement.setAttribute('onclick', `togglePreferred(${organizationId}, this, 0)`);
                        alert('Marked as Preferred successfully.');
                    } else {
                        iconElement.classList.remove('fa-solid', 'fa-heart');
                        iconElement.classList.add('fa-regular', 'fa-heart');
                        iconElement.style.color = '';
                        iconElement.setAttribute('onclick', `togglePreferred(${organizationId}, this, 1)`);
                        alert('Unmarked successfully.');
                    }
                } else {
                    alert('Failed to update preferred status.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
            });
        }
    </script>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>

        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>

    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"] {
            width: 100%;
            height: 30px;
            margin: 0;
        }

        .styled-table td {
            width: 12%;
        }

        .styled-table td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 10vw;
            z-index: 1;
        }
    </style>

    <?php $visibleColumn = ($title == 'admin') ? 3 : 2; ?>

    <style>
        .mobile-search-btn {
            display: none;
        }
        /* Mobile View */
        @media (max-width: 768px) {
            html, body {
                width: 100%;
                overflow-x: hidden;
            }

            .styled-table th:not(:nth-child(<?php echo $visibleColumn; ?>)),
            .styled-table td:not(:nth-child(<?php echo $visibleColumn; ?>)),
            .bulk-actions, #tai_cb_toggle_button,
            form tr td:not(:nth-child(<?php echo $visibleColumn; ?>)) {
                display: none !important;
            }

            .mobile-search-btn {
                display: inline-block;
            }
            .org-mobile-input {
                width: 80% !important;
            }

            .styled-table th:nth-child(<?php echo $visibleColumn; ?>) {
                text-align: center;
            }

            .styled-table td:nth-child(<?php echo $visibleColumn; ?>) {
                max-width: 100%;
            }

            .styled-table {
                max-width: 100%;
            }
        }
    </style>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'add-new-organization') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $organizationName = $conn->real_escape_string($_POST['organizationName']);
        $phone = $conn->real_escape_string($_POST['phone']);
        $email = $conn->real_escape_string($_POST['email']);
        $website = $conn->real_escape_string($_POST['website']);
        $address = $conn->real_escape_string($_POST['address']);
        $region = $conn->real_escape_string($_POST['region']);
        $country = $conn->real_escape_string($_POST['country']);
    
        // Insert the new organization first
        $sql = "INSERT INTO tdu_organisation (organization_name, phone, email, website, address, region, country)
                VALUES ('$organizationName', '$phone', '$email', '$website', '$address', '$region', '$country')";

        if ($conn->query($sql)) {
            $lastInsertedId = $conn->insert_id;
            
            // Close connection
            $conn->close();

            header("Location: quote.php?opt=organization-details&id=$lastInsertedId");
            exit();
        }
    }
    
    include "header.php";
    ?>
    <form method="POST" action="" style="margin-bottom: 20px;">
        <h2>Organization Information</h2>
        <div class="form-row">
            <label for="autocomplete">Search Organization:</label>
            <input type="text" id="autocomplete" name="autocomplete">
        </div>
        <div class="form-row" id="edit-fields-link" style="display: none; margin-top: 10px;">
            <a href="javascript:void(0);" id="toggle-edit">Cannot Find? Click here to enter manually</a>
        </div>
        <div class="form-row">
            <label for="organizationName">Organization Name:</label>
            <span id="org-check-result"></span>
            <input type="text" id="organizationName" name="organizationName" readonly required>
        </div>
        <div class="form-row">
            <label for="phone">Phone:</label>
            <input type="tel" id="phone" name="phone" readonly required>
        </div>
        <div class="form-row">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>
        </div>
        <div class="form-row">
            <label for="website">Website:</label>
            <input type="url" id="website" name="website" readonly>
        </div>
        <div class="form-row">
            <label for="address">Address:</label>
            <textarea id="address" name="address" rows="4" readonly></textarea>
        </div>
        <div class="form-row">
            <label for="region">Region:</label>
            <select id="region" name="region">
                <option value=""></option>
                <?php
                // Query to get group names from the vtiger_groups table
                $sqlr = "SELECT groupname FROM vtiger_groups";
                $resultr = $conn->query($sqlr);

                // Populate the select dropdown with group names
                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        $selected = '';
                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        <div class="form-row">
            <label for="country">Country:</label>
            <input type="text" id="country" name="country" readonly required>
        </div>

        <input type="hidden" id="similar_org_found" name="similar_org_found" value="0">

        <button type="submit">Save</button>
    </form>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCFiTkztZiUQpgWkLq4cSDJpO60hGuh5L4&libraries=places"></script>
    <script>
        let autocomplete;

        function initAutocomplete() {
            autocomplete = new google.maps.places.Autocomplete(
                document.getElementById('autocomplete'),
                { types: ['establishment'] } // Limit to establishments (you can adjust as needed)
            );
            autocomplete.addListener('place_changed', fillInFields);
        }

        function fillInFields() {
            const place = autocomplete.getPlace();

            // Fill fields with data from the autocomplete result
            document.getElementById('organizationName').value = place.name || '';
            document.getElementById('phone').value = place.formatted_phone_number || '';
            document.getElementById('website').value = place.website || '';
            document.getElementById('address').value = place.formatted_address || '';
            document.getElementById('country').value = place.address_components?.find(c => c.types.includes('country'))?.long_name || '';

            checkOrganizationName();
        }

        document.addEventListener("DOMContentLoaded", () => {
            initAutocomplete();

            const autocompleteInput = document.getElementById('autocomplete');
            const editFieldsLink = document.getElementById('edit-fields-link');
            const fields = document.querySelectorAll('#organizationName, #phone, #website, #address, #country');

            // Show the link when any character is entered into the autocomplete input
            autocompleteInput.addEventListener('input', () => {
                if (autocompleteInput.value.trim().length > 0) {
                    editFieldsLink.style.display = 'block';
                } else {
                    editFieldsLink.style.display = 'none';
                }
            });

            // Make fields editable when the link is clicked
            document.getElementById('toggle-edit').addEventListener('click', () => {
                fields.forEach(field => field.readOnly = false);
            });
        });

        function checkOrganizationName() {
            const orgName = document.getElementById('organizationName').value.trim();
            const checkIndicator = document.getElementById('org-check-result');

            if (orgName === '') {
                checkIndicator.innerHTML = '';
                return;
            }

            fetch('ajax_check_duplicate_organization.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'organizationName=' + encodeURIComponent(orgName)
            })
            .then(response => response.json())
            .then(data => {
                checkIndicator.innerHTML = '';

                // Apply centering styles to the container
                checkIndicator.style.display = 'flex';
                checkIndicator.style.alignItems = 'center';
                checkIndicator.style.justifyContent = 'center';

                if (data.exists) {
                    document.getElementById('similar_org_found').value = '1';

                    // Create the orange icon
                    const icon = document.createElement('i');
                    icon.className = 'fa-solid fa-circle-exclamation';
                    icon.title = 'Similar Organization found';
                    icon.style.color = 'orange';
                    icon.style.cursor = 'pointer';

                    // Add event listener to redirect on click
                    icon.addEventListener('click', function() {
                        window.location.href = 'quote.php?opt=organizations&id=' + data.similar_ids.join(',');
                    });

                    checkIndicator.appendChild(icon);
                } else {
                    document.getElementById('similar_org_found').value = '0';

                    const validCheck = document.createElement('i');
                    validCheck.className = 'fa-solid fa-circle-check';
                    validCheck.style.color = 'green';
                    checkIndicator.appendChild(validCheck);
                }
            })
            .catch(error => console.error('Error:', error));
        }

        document.addEventListener("DOMContentLoaded", () => {
            document.getElementById('organizationName').addEventListener('blur', checkOrganizationName);
        });

        document.addEventListener("DOMContentLoaded", () => {
            document.querySelector("form").addEventListener("submit", function (event) {
                const similarOrgFound = document.getElementById("similar_org_found").value;

                if (similarOrgFound === "1") {
                    const confirmProceed = confirm("Similar organizations have been found. Do you still want to proceed?");
                    if (!confirmProceed) {
                        event.preventDefault();
                    }
                }
            });
        });
    </script>

    <style>
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin: 20px 0;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
            margin-right: 10px;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-row input[readonly], .form-row textarea[readonly] {
            background-color: #f9f9f9;
            cursor: not-allowed;
        }
    </style>

    <style>
        /* Mobile View */
        @media (max-width: 768px) {
            html, body {
                width: 100%;
                overflow-x: hidden;
            }
            #tai_cb_toggle_button {
                display: none !important;
            }

            form {
                width: 90%;
                margin: 0 auto;
            }

            .form-row {
                flex-direction: column;
            }

            .form-row label,
            .form-row input,
            .form-row select,
            .form-row textarea {
                width: 100%;
                margin-right: 0;
            }

            .form-row input,
            .form-row select,
            .form-row textarea {
                margin-top: 5px;
            }
        }
    </style>
    <?php
}
else if (($title=='admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'organization-details') {
    include "header.php";
    include "portaldbconn.php";

    $organisation_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    if ($organisation_id > 0) {
        $sql = "SELECT * FROM tdu_organisation o
                LEFT JOIN tdu_membership m ON o.membershipid = m.membershipid
                LEFT JOIN tdu_organisation_category toc ON o.preferred = toc.cid
                WHERE o.organizationid = $organisation_id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $organisation = $result->fetch_assoc();
        } else {
            echo "Organisation not found.";
            exit;
        }
    }
    ?>
    <div style="padding: 20px; background-color: <?= $organisation['membershipName'] ?>;">
        <div class="org-info-wrapper" style="display: flex; justify-content: space-between; margin: 0;">
            <div style="flex: 2; padding-right: 20px;">
                <h1 style="text-align: left;">
                    <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                    <?php if($organisation['active'] == 1) { ?>
                        <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                    <?php } else { ?>
                        <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                    <?php } ?>
                    <?php echo htmlspecialchars($organisation['organization_name']); ?>
                    <button id="editBtn" onclick="toggleEditMode()"><i class="fa-solid fa-pen-to-square"></i></button>
                </h1>
                <div style="margin-top: 20px; text-align: center;">
                    <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                    <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                </div>
            </div>
            <div style="flex: 2; padding-right: 20px;">
                <h3>Organisation Information</h3>
                <p>Name:
                    <span id="name-display"><?php echo htmlspecialchars($organisation['organization_name']); ?></span>
                    <input id="name-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($organisation['organization_name']); ?>">
                </p>
                <p>Email:
                    <span id="email-display"><?php echo htmlspecialchars($organisation['email']); ?></span>
                    <input id="email-edit" style="display:none;" type="email" value="<?php echo htmlspecialchars($organisation['email']); ?>">
                </p>
                <p>Phone:
                    <span id="phone-display"><?php echo htmlspecialchars($organisation['phone']); ?></span>
                    <input id="phone-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($organisation['phone']); ?>">
                </p>
                <p>Organisation Category:
                    <span id="org-category-display"><?php echo htmlspecialchars($organisation['org_category']); ?></span>
                    <select id="org-category-edit" name="org_category" style="display:none; width: 100%;">
                        <option value=""></option>
                        <?php
                        $sqlCat = "SELECT cid, org_category FROM tdu_organisation_category";
                        $resultCat = $conn->query($sqlCat);

                        if ($resultCat->num_rows > 0) {
                            while ($cat = $resultCat->fetch_assoc()) {
                                $selected = ($organisation['preferred'] == $cat['cid']) ? 'selected' : '';
                                echo "<option value=\"" . (int)$cat['cid'] . "\" $selected>" . htmlspecialchars($cat['org_category']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </p>
            </div>
            <div style="flex: 2; padding-right: 20px;">
                <h3>Additional Details</h3>
                <p>Website:
                    <span id="website-display"><a href="<?php echo htmlspecialchars($organisation['website']); ?>" target="_blank"><?php echo htmlspecialchars($organisation['website']); ?></a></span>
                    <input id="website-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($organisation['website']); ?>">
                </p>
                <p>Address:
                    <span id="address-display"><?php echo nl2br(htmlspecialchars($organisation['address'])); ?></span>
                    <textarea id="address-edit" style="display:none;"><?php echo htmlspecialchars($organisation['address']); ?></textarea>
                </p>
                <p>Region:
                    <span id="region-display"><?php echo htmlspecialchars($organisation['region']); ?></span>
                    <select id="region-edit" name="region" style="display:none; width: 100%;" onchange="updateCountry()">
                        <option value=""></option>
                        <?php
                        // Query to get group names from the vtiger_groups table
                        $sqlr = "SELECT groupname FROM vtiger_groups";
                        $resultr = $conn->query($sqlr);

                        // Populate the select dropdown with group names
                        if ($resultr->num_rows > 0) {
                            while ($rowr = $resultr->fetch_assoc()) {
                                $selected = ($organisation['region'] == $rowr['groupname']) ? 'selected' : '';
                                echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </p>
                <p>Country:
                    <span id="country-display"><?php echo htmlspecialchars($organisation['country']); ?></span>
                    <input id="country-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($organisation['country']); ?>">
                </p>

                <script>
                    function updateCountry() {
                        var region = document.getElementById("region-edit").value;
                        var countryInput = document.getElementById("country-edit");

                        var regionCountryMap = {
                            "North": "India",
                            "South": "India",
                            "East": "India",
                            "West": "India",
                            "Gujarat": "India",
                            "Malaysia": "Malaysia"
                        };

                        if (regionCountryMap[region]) {
                            countryInput.value = regionCountryMap[region];
                        }
                    }
                </script>
            </div>
            <?php
            // =========================================================================
            // ==              START: QBO CUSTOMER SUMMARY FEATURE                    ==
            // =========================================================================
            
            // This block fetches and displays the customer's balance summary from QuickBooks Online.
            // It is designed to be self-contained and easily integrated into a larger dashboard.
            
            // --- Step 1: Initialize variables and include the QBO bootstrap file ---
            $financialData = [
                'summary' => ['total_balance' => 0.00, 'overdue_balance' => 0.00]
            ];
            $qboErrorMessage = null; // Used to hold a friendly error message if something fails.
            
            // The bootstrap file handles the entire QBO connection and provides the $qboUtil object.
            require_once __DIR__ . '/../qbo_bootstrap.php';
            
            try {
                // --- Step 2: Validate the connection and input data ---
                if (!$qboUtil) {
                    throw new Exception("QuickBooks connection could not be established.");
                }
                
                $customerNameToSearch = $organisation['organization_name'] ?? null;
                
                if (!$customerNameToSearch) {
                    throw new Exception("Organization name is not available.");
                }
            
                // --- Step 3: Fetch the data from QuickBooks ---
                
                // Find the customer in QBO to get their ID. This is a quick operation.
                $customer = $qboUtil->queryEntityByField('Customer', 'DisplayName', $customerNameToSearch);
                if (!$customer) {
                    echo "<p><i>Exact match not found, attempting fuzzy search...</i></p>";
                    $customer = $qboUtil->findEntityByFuzzyName('Customer', $customerNameToSearch);
                }
                
                // If the customer exists, fetch their detailed financial data.
                if ($customer) {
                    // This single, reliable function gets all the necessary numbers.
                    $financialData = $qboUtil->getFinancialDetailData($customer->Id);
                } else {
                    // Log a warning for admins, but don't show a breaking error on the dashboard.
                    error_log("Dashboard Warning: Could not find a QBO customer with DisplayName: " . $customerNameToSearch);
                    // The card will safely display 0.00 for the balances.
                }
            
            } catch (Exception $e) {
                // Catch any exception during the process and log it for debugging.
                // This prevents the entire dashboard from crashing if QBO is unavailable.
                error_log("QBO Customer Summary Feature Error: " . $e->getMessage());
                $qboErrorMessage = "Could not load summary data at this time.";
            }
            
            // =========================================================================
            // ==           END: QBO CUSTOMER SUMMARY FEATURE (LOGIC)                 ==
            // =========================================================================
            ?>
            
            <!-- ======================================================================= -->
            <!-- ==        START: QBO CUSTOMER SUMMARY FEATURE (HTML & CSS)           == -->
            <!-- ======================================================================= -->
            
            <!-- Customer Balance Summary Card -->
            <div class="balance-card">
                <div class="card-body">
                    <?php if ($qboErrorMessage): ?>
                        <div class="balance-item">
                            <span class="balance-label error-message"><?= htmlspecialchars($qboErrorMessage) ?></span>
                        </div>
                    <?php else: ?>
                        <div class="balance-item">
                            <span class="balance-label">Total Balance Due</span>
                            <span class="balance-value">
                                <?= htmlspecialchars(number_format($financialData['summary']['total_balance'], 2)) ?>
                                <span class="currency">AUD</span>
                            </span>
                        </div>
                        <div class="balance-item">
                            <span class="balance-label">Amount Overdue</span>
                            <span class="balance-value overdue">
                                <?= htmlspecialchars(number_format($financialData['summary']['overdue_balance'], 2)) ?>
                                <span class="currency">AUD</span>
                            </span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <style>
                /* Minimal and clean CSS for the Customer Balance Summary Card */
                .balance-card {
                    background-color: #ffffff;
                    border-radius: 12px;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
                    border: 1px solid #e9ecef;
                    max-width: 400px;
                    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
                    margin: 1.5rem 0; /* Provides spacing within a dashboard layout */
                }
                
                .balance-card .card-body {
                    padding: 12px 24px; /* Reduced padding for a more compact look */
                }
                
                .balance-card .balance-item {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    padding: 14px 0;
                }
                
                .balance-card .balance-item:not(:last-child) {
                    border-bottom: 1px solid #f1f3f5;
                }
                
                .balance-card .balance-label {
                    font-size: 1rem;
                    color: #495057;
                    font-weight: 500;
                    flex-basis: 40%; 
                }
                
                .balance-card .balance-value {
                    font-size: 1.5rem;
                    font-weight: 700;
                    color: #343a40;
                }
                
                .balance-card .balance-value .currency {
                    font-size: 0.8rem;
                    font-weight: 500;
                    color: #6c757d;
                    margin-left: 4px;
                }
                
                .balance-card .balance-value.overdue {
                    color: #d93025; /* A strong but not jarring red */
                }
                .balance-card .error-message {
                    color: #6c757d;
                    width: 100%;
                    text-align: center;
                }
            </style>
            
            <!-- ======================================================================= -->
            <!-- ==         END: QBO CUSTOMER SUMMARY FEATURE (HTML & CSS)            == -->
            <!-- ======================================================================= -->
        </div>
    </div>
    <script>
        function cancelEdit() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => {
                el.style.display = 'inline';
            });
            document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => {
                el.style.display = 'none';
            });

            document.getElementById('editBtn').style.display = 'inline';
            document.getElementById('saveBtn').style.display = 'none';
            document.getElementById('cancelBtn').style.display = 'none';
        }

        function toggleEditMode() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
            document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
            
            document.getElementById('editBtn').style.display = document.getElementById('editBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('saveBtn').style.display = document.getElementById('saveBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('cancelBtn').style.display = document.getElementById('cancelBtn').style.display === 'none' ? 'inline' : 'none';
        }

        function saveChanges() {
            const data = {
                organization_name: document.getElementById('name-edit').value,
                email: document.getElementById('email-edit').value,
                phone: document.getElementById('phone-edit').value,
                website: document.getElementById('website-edit').value,
                address: document.getElementById('address-edit').value,
                region: document.getElementById('region-edit').value,
                country: document.getElementById('country-edit').value,
                org_category: document.getElementById('org-category-edit').value,
                organisation_id: <?php echo $organisation_id; ?>
            };

            fetch('ajax_update_organisation.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data),
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    // Reload the page after a successful update
                    window.location.reload();
                } else {
                    alert('Failed to update organisation information.');
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>

    <div class="button-container">
        <button type="button" onclick="showDiv('div-org7', this)">New Followup</button>
        <button type="button" onclick="showDiv('div-org2', this)">Contacts</button>
        <button type="button" onclick="showDiv('div-org1', this)">View Quotes</button>
        <button type="button" onclick="showDiv('div-org3', this)">Mailbox</button>
        <?php if ($title == 'admin') : ?>
            <button type="button" onclick="showDiv('div-org5', this)">Merge</button>
        <?php endif; ?>
        <button type="button" onclick="showDiv('div-org6', this)">History</button>
        <button type="button" onclick="showDiv('div-org8', this)">API</button>
        <!--qbo customer transaction list start -->
        <button type="button" onclick="showDiv('div-org-transactionlist', this)">Transaction List</button>
        <!--qbo customer transaction list end-->
    </div>

    <div id="div-org1" class="content-div">
        <?php
        $sql = "SELECT vq.quote_no, vq.subject, vq.adults, vq.children, vqcf.cf_1162, vq.country
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vq.accountid = $organisation_id 
                AND vq.quoteid = (
                    SELECT MIN(quoteid) AS quoteid 
                    FROM vtiger_quotes AS sub 
                    WHERE sub.quote_no = vq.quote_no
                ) 
                ORDER BY vq.quote_no DESC
        ";

        $result = mysqli_query($conn, $sql);

        if (mysqli_num_rows($result) > 0) :
            ?>
            <table class="styled-table">
                <tr>
                    <th>Travel Date</th>
                    <th>Quote No</th>
                    <th>No Pax</th>
                    <th style="text-align:left;">Subject</th>
                    <th>Country</th>
                </tr>
                <?php
                while ($row = mysqli_fetch_assoc($result)) :
                ?>
                    <tr>
                        <td><?php echo !empty($row['cf_1162']) ? (new DateTime($row['cf_1162']))->format('d-M-y') : ''; ?></td>
                        <td><?php echo htmlspecialchars($row['quote_no']); ?></td>
                        <td><?php echo (int) $row['adults'] + (int) $row['children']; ?></td>
                        <td style="text-align:left;">
                            <a href="quote.php?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>">
                                <?php echo htmlspecialchars($row['subject']); ?>
                            </a>
                        </td>
                        <td><?php echo htmlspecialchars($row['country']);?></td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>No records found.</p>
        <?php endif; ?>
    </div>

    <div id="div-org2" class="content-div">
        <?php
        $sqlContacts = "SELECT 
                            tc.name, tc.email, tc.mobile, tc.auto_id AS id,
                            tt.templateref, tt.country, tt.id AS ai_id
                        FROM tdu_contacts tc
                        LEFT JOIN 
                            (
                                SELECT id, sender, country, templateref 
                                FROM tdu_temp_ai_quotes 
                                WHERE created_at = (
                                    SELECT MAX(created_at) 
                                    FROM tdu_temp_ai_quotes 
                                    WHERE sender = tdu_temp_ai_quotes.sender
                                )
                            ) tt ON tc.email = tt.sender
                        WHERE tc.organizationid = $organisation_id
        ";

        $resultContacts = mysqli_query($conn, $sqlContacts);
        ?>

        <!-- Contact Modal -->
        <div id="contact-modal" class="modal" style="display: none;">
            <div class="modal-content" style="width: 400px; padding: 20px; box-sizing: border-box;">
                <span class="close" style="font-size: 30px; font-weight: bold; position: relative; top: 0px; right: 0px; cursor: pointer;">&times;</span>
                <h2 style="text-align: center;">Add New Contact</h2><br>
                <form id="add-contact-form" style="display: flex; flex-direction: column; gap: 10px;">
                    <input type="hidden" name="organizationid" value="<?php echo $organisation_id; ?>">

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="name" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Name:</label>
                        <input type="text" id="name" name="name" required style="width: 70%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="email" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Email:</label>
                        <input type="email" id="email" name="email" required style="width: 70%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="mobile" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Mobile:</label>
                        <input type="tel" id="mobile" name="mobile" required style="width: 100%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>

                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">
                    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
                    <script>
                        var input = document.querySelector("#mobile");
                        var iti = window.intlTelInput(input, {
                            initialCountry: "au", // Auto-detect based on IP
                            separateDialCode: true, // Show country code separately
                            nationalMode: false, // Full number with country code
                            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js",
                            preferredCountries: ["in", "au", "nz"]
                        });
                    </script>
                    <button type="submit" style="padding: 10px 20px; border: none; cursor: pointer; width: 100%;">Save Contact</button>
                </form>
            </div>
        </div>

        <?php if (mysqli_num_rows($resultContacts) > 0) : ?>
            <table class="styled-table" id="contacts-table">
                <tr>
                    <th><button id="add-contact-btn">+ Contact</button></th>
                    <th style="text-align: left;">Name</th>
                    <th style="text-align: left;">Email</th>
                    <th style="text-align: left;">Mobile</th>
                    <th></th>
                    <th></th>
                </tr>
                <?php while ($row = mysqli_fetch_assoc($resultContacts)) : ?>
                    <tr>
                        <td>
                            <?php
                            if(trim($organisation['region'] ?? '') == '' || trim($organisation['country'] ?? '') == '') {
                                ?>
                                <button type="button" onclick="toggleEditMode(); showDiv('div-org4', this);">Make Quote</button>
                                <?php
                                if(isset($row['templateref']) && $row['templateref'] != '') {
                                    ?>
                                    <button type="button" onclick="toggleEditMode(); showDiv('div-org4', this);">Make Quote with AI Ref <?= $row['ai_id'] ?></button>
                                    <?php
                                }
                            } else {
                                ?>
                                <button type="button" onclick="window.location.href='?opt=templates&organisationid=<?php echo $organisation_id; ?>&contactid=<?php echo $row['id']; ?>'">Make Quote</button>
                                <button type="button" onclick="window.location.href='?opt=create-group&organisationid=<?php echo $organisation_id; ?>&contactid=<?php echo $row['id']; ?>'">Make Pax Range Quote</button>
                                <?php
                                if(isset($row['templateref']) && $row['templateref'] != '') {
                                    $values = explode(',', $row['templateref']);
                                    $filteredValues = array_filter($values, function ($value) {
                                        return trim($value) !== "N/A";
                                    });
                                    $cleanedTemplateRef = implode(',', $filteredValues);

                                    if($cleanedTemplateRef) {
                                        ?>
                                        <button type="button" onclick="window.location.href='?opt=create-fit&organisationid=<?php echo $organisation_id; ?>&contactid=<?php echo $row['id']; ?>&templateid=<?php echo $cleanedTemplateRef; ?>&country=<?php echo $row['country']; ?>&airef=<?php echo $row['ai_id']; ?>'">Make Quote with AI Ref <?= $row['ai_id'] ?></button>
                                        <?php
                                    }
                                }
                                ?>
                                <button type="button" class="link-quote-btn" data-contactid="<?php echo htmlspecialchars($row['id']); ?>">
                                    <i class="fa-solid fa-link"></i> Link Quote
                                </button>
                                <?php
                            }
                            ?>
                        </td>
                        <td style="text-align: left;"><span class="contact-name"><?php echo htmlspecialchars($row['name']); ?></span></td>
                        <td style="text-align: left;"><span class="contact-email"><?php echo htmlspecialchars($row['email']); ?></span></td>
                        <td style="text-align: left;"><span class="contact-mobile"><?php echo htmlspecialchars($row['mobile']); ?></span></td>
                        <td>
                            <button type="button" class="edit-contact-btn" style="color: white;" data-id="<?php echo htmlspecialchars($row['id']); ?>">
                                <i class="fa-solid fa-pencil"></i>
                            </button>
                            <button type="button" class="delete-contact-btn" style="background-color: red; color: white;" data-id="<?php echo htmlspecialchars($row['id']); ?>">
                                <i class="fa-solid fa-trash-can"></i>
                            </button>
                        </td>
                        <td>
                            <?php
                            $sql_external_user_role = "SELECT role FROM users WHERE email = '" . mysqli_real_escape_string($portaldbconn, $row['email']) . "'";
                            $result_external_user_role = mysqli_query($portaldbconn, $sql_external_user_role);
                            if (mysqli_num_rows($result_external_user_role) > 0) {
                                $external_user_role = mysqli_fetch_assoc($result_external_user_role)['role'] ?? '';
                                ?>
                                <select class="external-role-dropdown" style="margin: 0;" data-email="<?php echo htmlspecialchars($row['email']); ?>">
                                    <option value="admin" <?= $external_user_role == 'admin' ? 'selected' : '' ?>>Admin</option>
                                    <option value="staff" <?= $external_user_role == 'staff' ? 'selected' : '' ?>>Staff</option>
                                    <option value="block" <?= $external_user_role == 'block' ? 'selected' : '' ?>>Blocked</option>
                                </select>
                                <?php
                            }
                            ?>
                            <button type="button" class="reset-password-btn" style="background-color: #ffc107; color: black;" data-id="<?php echo htmlspecialchars($row['id']); ?>">
                                <i class="fa-solid fa-key"></i> Create/Reset Password
                            </button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>No contacts found for this organization.</p>
            <p><button id="add-contact-btn">Add Contact</button></p>
        <?php endif; ?>

        <!-- script to create/reset password for portal user -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                document.querySelectorAll('.reset-password-btn').forEach(function (button) {
                    button.addEventListener('click', function () {
                        const contactId = this.getAttribute('data-id');

                        if (!confirm("Are you sure you want to create/reset the password for this contact?")) return;

                        fetch('ajax_portal_user_admin.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: new URLSearchParams({
                                action: 'reset_password',
                                contactid: contactId
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('Password reset successfully!');
                                window.location.reload();
                            } else {
                                alert('Error: ' + (data.message || 'Failed to reset password.'));
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('An error occurred.');
                        });
                    });
                });
            });
        </script>
        <!-- script to change user rolw -->
        <script>
            document.querySelectorAll('.external-role-dropdown').forEach(function(select) {
                select.addEventListener('change', function() {
                    const email = this.dataset.email;
                    const role = this.value;

                    if (role === 'block') {
                        const confirmed = confirm('Are you sure you want to block this user?');
                        if (!confirmed) {
                            // Revert to previous value if canceled
                            this.value = this.getAttribute('data-current-role');
                            return;
                        }
                    }

                    fetch('ajax_update_external_user_role.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                        body: new URLSearchParams({email: email, role: role})
                    })
                    .then(response => response.text())
                    .then(result => {
                        if (result.trim() === 'success') {
                            alert('Role updated successfully.');
                            window.location.reload();
                        } else {
                            alert('Failed to update role.');
                            this.value = this.getAttribute('data-current-role'); // Revert on failure
                        }
                    });
                });

                // Store initial role for potential revert
                select.setAttribute('data-current-role', select.value);
            });
        </script>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Enable editing when the Edit button is clicked
        $(document).on('click', '.edit-contact-btn', function() {
            var contactId = $(this).data('id');
            var row = $(this).closest('tr');
            
            // Toggle the input fields
            row.find('.contact-name').replaceWith('<input type="text" class="contact-name" value="' + row.find('.contact-name').text() + '">');
            row.find('.contact-email').replaceWith('<input type="email" class="contact-email" value="' + row.find('.contact-email').text() + '">');
            row.find('.contact-mobile').replaceWith('<input type="tel" class="contact-mobile" value="' + row.find('.contact-mobile').text() + '">');
            
            // Change the button to save
            row.find('.edit-contact-btn').html('<i class="fa-solid fa-check"></i>').removeClass('edit-contact-btn').addClass('save-contact-btn');
        });

        // Save the updated contact details
        $(document).on('click', '.save-contact-btn', function() {
            var contactId = $(this).data('id');
            var row = $(this).closest('tr');
            
            // Get the updated values from the input fields
            var updatedName = row.find('.contact-name').val();
            var updatedEmail = row.find('.contact-email').val();
            var updatedMobile = row.find('.contact-mobile').val();
            
            // Make AJAX request to update the contact
            $.ajax({
                url: 'ajax_update_vendor_contact.php',
                type: 'POST',
                data: {
                    id: contactId,
                    name: updatedName,
                    email: updatedEmail,
                    mobile: updatedMobile
                },
                success: function(response) {
                    if(response === 'success') {
                        // On success, replace input fields with updated text
                        row.find('.contact-name').replaceWith('<span class="contact-name">' + updatedName + '</span>');
                        row.find('.contact-email').replaceWith('<span class="contact-email">' + updatedEmail + '</span>');
                        row.find('.contact-mobile').replaceWith('<span class="contact-mobile">' + updatedMobile + '</span>');
                        
                        // Change the button back to "Edit"
                        row.find('.save-contact-btn').text('Edit').removeClass('save-contact-btn').addClass('edit-contact-btn');
                    } else {
                        alert('Update failed');
                    }
                }
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            // Open modal
            $('#add-contact-btn').click(function () {
                $('#contact-modal').show();
            });

            // Close modal
            $('.close').click(function () {
                $('#contact-modal').hide();
            });

            // Add new contact using AJAX
            $('#add-contact-form').submit(function (e) {
                e.preventDefault();

                // Get full international number (with country code)
                const fullMobile = iti.getNumber();
                
                // Get just the country dial code (e.g., "+1")
                const countryCode = iti.getSelectedCountryData().dialCode;

                // Get the number without country code
                const nationalNumber = input.value.trim();

                // Append the extracted values to the form data
                const formData = $(this).serialize() + 
                                '&mobile=' + encodeURIComponent(fullMobile) +
                                '&mobile_code=' + encodeURIComponent(countryCode) +
                                '&mobile_number=' + encodeURIComponent(nationalNumber);

                $.ajax({
                    type: 'POST',
                    url: 'ajax_contact.php',
                    data: formData,
                    success: function (response) {
                        const result = JSON.parse(response);

                        if (result.success) {
                            alert('Contact added successfully!');
                            location.reload();
                        } else {
                            alert('Failed to add contact: ' + result.message);
                        }
                    },
                    error: function () {
                        alert('An error occurred while adding the contact.');
                    }
                });
            });

            // Delete contact using AJAX
            $('.delete-contact-btn').click(function () {
                const id = $(this).data('id'); // Get the `auto_id`

                if (confirm('Are you sure you want to delete this contact?')) {
                    $.ajax({
                        type: 'POST',
                        url: 'ajax_contact.php', // Replace with actual PHP script
                        data: { action: 'delete', id: id },
                        success: function (response) {
                            const result = JSON.parse(response);

                            if (result.success) {
                                alert('Contact deleted successfully!');
                                location.reload();
                            } else {
                                alert('Failed to delete contact: ' + result.message);
                            }
                        },
                        error: function () {
                            alert('An error occurred while deleting the contact.');
                        }
                    });
                }
            });
        });
    </script>
    <style>
        select, input, textarea {
            width: 100%;
            height: 30px;
            margin: 0;
        }
        
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            width: 400px;
        }

        .close {
            float: right;
            cursor: pointer;
            font-size: 24px;
        }
    </style>

    <!-- modal to link quote no start -->
    <div id="contactQuoteModal" style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%); background:white; padding:20px; border:1px solid #ccc; border-radius:8px; z-index:9999; max-height:80vh; overflow:auto; width: 400px;">
        <input type="text" id="contactQuoteSearch" placeholder="Search quote number..." style="width:100%; padding:8px; margin-bottom:10px;" oninput="filterContactQuotes()">
        <select id="contactQuoteSelect" size="10" style="width:100%; padding:8px; margin-bottom:10px; height: 25vh;"></select>
        <input type="hidden" id="modalContactID">
        <div style="text-align: left;">
            <button onclick="linkContactQuote()" style="background: green; color: white;">Link</button>
            <button onclick="closeContactQuoteModal()">Cancel</button>
        </div>
    </div>
    <div id="contactModalBackdrop" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:9998;" onclick="closeContactQuoteModal()"></div>
    <script>
        let allContactQuotes = [];
        const organisationId = <?= json_encode($organisation_id) ?>;

        function closeContactQuoteModal() {
            document.getElementById('contactQuoteModal').style.display = 'none';
            document.getElementById('contactModalBackdrop').style.display = 'none';
        }

        function openContactQuoteModal(contactId) {
            document.getElementById('modalContactID').value = contactId;

            fetch('ajax_fetch_distinct_quotes.php')
                .then(res => res.json())
                .then(data => {
                    allContactQuotes = data;
                    renderContactQuoteOptions(data);
                    document.getElementById('contactQuoteSearch').value = '';
                    document.getElementById('contactQuoteModal').style.display = 'block';
                    document.getElementById('contactModalBackdrop').style.display = 'block';
                })
                .catch(err => {
                    console.error(err);
                    alert("Failed to fetch quote numbers.");
                });
        }

        function renderContactQuoteOptions(quotes) {
            const select = document.getElementById('contactQuoteSelect');
            select.innerHTML = quotes.map(q => `<option value="${q}">${q}</option>`).join('');
        }

        function filterContactQuotes() {
            const term = document.getElementById('contactQuoteSearch').value.toLowerCase();
            const filtered = allContactQuotes.filter(q => q.toLowerCase().includes(term));
            renderContactQuoteOptions(filtered);
        }

        function linkContactQuote() {
            const quoteNo = document.getElementById('contactQuoteSelect').value;
            const contactId = document.getElementById('modalContactID').value;

            if (!quoteNo) {
                alert("Please select a quote.");
                return;
            }

            fetch('ajax_link_quote_to_contact.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ contactId, quoteNo, organisationId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert("Quote linked successfully.");
                    closeContactQuoteModal();
                    location.reload();
                } else {
                    alert("Failed to link quote: " + data.message);
                }
            })
            .catch(err => {
                console.error(err);
                alert("Error linking quote.");
            });
        }

        // Attach modal open event to contact buttons
        $(document).on('click', '.link-quote-btn', function () {
            const contactId = $(this).data('contactid');
            openContactQuoteModal(contactId);
        });
    </script>
    <!-- modal to link quote no end -->

    <div id="div-org3" class="content-div"></div>

    <div id="div-org4" class="content-div"><h2 style="margin: 20px;">Please fill in the region and country before Making a Quote</h2></div>

    <div id="div-org5" class="content-div" style="margin: 20px;">
        <input type="text" id="org-search" placeholder="Search organization..." />
        <table id="org-results">
            <tbody>
                <!-- Results will be appended here -->
            </tbody>
        </table>

        <script>
            $(document).ready(function() {
                $('#org-search').on('keyup', function() {
                    let searchQuery = $(this).val();
                    if (searchQuery.length > 0) {
                        $.ajax({
                            url: 'ajax_search_organisation.php',
                            type: 'POST',
                            data: { query: searchQuery },
                            success: function(response) {
                                $('#org-results tbody').html(response);
                            }
                        });
                    } else {
                        $('#org-results tbody').html('');
                    }
                });

                $(document).on('click', '.merge-btn', function() {
                    let targetOrganizationId = $(this).data('id');
                    let organizationId = <?= $organisation_id ?>;

                    let confirmMerge = confirm("Are you sure you want to merge current organization?");
                    if (confirmMerge) {
                        $.ajax({
                            url: 'ajax_merge_organisation.php',
                            type: 'POST',
                            data: { organization_id: organizationId, target_id: targetOrganizationId },
                            success: function(response) {
                                alert(response);
                                location.reload();
                            }
                        });
                    }
                });
            });
        </script>
    </div>

    <div id="div-org6" class="content-div">
        <?php
        $sql = "SELECT * FROM tdu_organisation_followup WHERE organizationid = '$organisation_id' ORDER BY created_at DESC;";
        $result = mysqli_query($conn, $sql);
        ?>
        <div class="table-container">
            <div class="table-wrapper" style="border: none;">
                <table border="1" cellspacing="0" cellpadding="8">
                    <tr>
                        <th>User</th>
                        <th>Visit Time</th>
                        <th>Mode</th>
                        <th>Designation</th>
                        <th>Contact Person</th>
                        <th>Contact No</th>
                        <th>Email ID</th>
                        <th>Current ITO (DMC)</th>
                        <th>Meeting Notes</th>
                        <th>Action</th>
                        <th>Next Follow-up Date</th>
                        <th>Upload Date</th>
                    </tr>
                    <?php
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['created_by']); ?></td>
                                <td><?php echo date("d-M-Y H:i", strtotime($row['visit_time'])); ?></td>
                                <td><?php echo htmlspecialchars($row['mode']); ?></td>
                                <td><?php echo htmlspecialchars($row['designation']); ?></td>
                                <td><?php echo htmlspecialchars($row['contact_person']); ?></td>
                                <td><?php echo htmlspecialchars($row['contact_no']); ?></td>
                                <td><?php echo htmlspecialchars($row['contact_email']); ?></td>
                                <td><?php echo htmlspecialchars($row['current_ito']); ?></td>
                                <td><?php echo nl2br(htmlspecialchars($row['meeting_notes'])); ?></td>
                                <td><?php echo htmlspecialchars($row['action']); ?></td>
                                <td><?php echo date("d-M-Y H:i", strtotime($row['next_follow_up_date'])); ?></td>
                                <td><?php echo date("d-M-Y", strtotime($row['created_at'])); ?></td>
                            </tr>
                            <?php
                        }
                    } else {
                        echo "<tr><td colspan='12'>No results found</td></tr>";
                    }
                    ?>
                </table>
            </div>
        </div>
    </div>

    <div id="div-org7" class="content-div">
        <div class="followup-form">
            <h2>Add New Organization Follow-Up</h2><br>
            <form id="org-followup-form">
                <input type="hidden" name="organizationid" value="<?php echo $organisation_id; ?>" />

                <label for="visit_time">Visit Time:</label>
                <input type="datetime-local" name="visit_time" style="width: 500px;" required><br><br>

                <label for="mode">Mode:</label>
                <select name="mode" style="width: 500px; padding: 0;" required>
                    <option value=""></option>
                    <option value="In person">In Person</option>
                    <option value="Phone">Phone</option>
                </select><br><br>

                <label for="designation">Designation:</label>
                <input type="text" name="designation"><br><br>

                <label for="contact_select">Select Contact:</label>
                <select id="contact_select" style="width: 500px; padding: 0;" required>
                    <option value="">-- Select Contact --</option>
                    <?php
                        $sqlContacts = "SELECT name, email, mobile, auto_id AS id 
                                        FROM tdu_contacts 
                                        WHERE organizationid = $organisation_id";
                        $resultContacts = mysqli_query($conn, $sqlContacts);
                        while ($row = mysqli_fetch_assoc($resultContacts)) {
                            echo '<option value="' . htmlspecialchars(json_encode($row)) . '">' . htmlspecialchars($row['name']) . '</option>';
                        }
                    ?>
                </select><br><br>

                <label>Contact Person:</label>
                <input type="text" name="contact_person" id="contact_person" readonly><br><br>

                <label>Contact No:</label>
                <input type="text" name="contact_no" id="contact_no" readonly><br><br>

                <label>Email ID:</label>
                <input type="text" name="contact_email" id="contact_email" readonly><br><br>

                <label>Current ITO (DMC):</label>
                <input type="text" name="current_ito"><br><br>

                <label>Meeting Notes:</label>
                <textarea name="meeting_notes" style="width: 500px;" rows="6"></textarea><br><br>

                <label>Action:</label>
                <input type="text" name="action"><br><br>

                <label>Next Follow-up Date:</label>
                <input type="datetime-local" name="next_follow_up_date" style="width: 500px;" required><br><br>

                <button type="submit">Add Organization Follow-Up</button>
            </form>
        </div>

        <script>
            document.getElementById('contact_select').addEventListener('change', function () {
                const selected = this.value;
                if (selected) {
                    const contact = JSON.parse(selected);
                    document.getElementById('contact_person').value = contact.name || '';
                    document.getElementById('contact_no').value = contact.mobile || '';
                    document.getElementById('contact_email').value = contact.email || '';
                } else {
                    document.getElementById('contact_person').value = '';
                    document.getElementById('contact_no').value = '';
                    document.getElementById('contact_email').value = '';
                }
            });

            document.getElementById('org-followup-form').addEventListener('submit', function (e) {
                e.preventDefault();

                const formData = new FormData(this);

                fetch('ajax_add_org_followup.php', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        alert("Follow-up added successfully");
                        location.reload();
                    } else {
                        alert("Error: " + data.error);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("Unexpected error occurred");
                });
            });
        </script>

        <style>
            .followup-form {
                padding: 20px;
                border-radius: 8px;
                max-width: 500px;
                margin: 20px;
            }

            .followup-form .form-group {
                margin-bottom: 20px;
            }

            .followup-form input[type="datetime-local"], 
            .followup-form select,
            .followup-form textarea {
                width: 100%;
                padding: 10px;
                font-size: 16px;
                border: 1px solid #ddd;
                border-radius: 4px;
                outline: none;
                transition: border-color 0.3s ease;
            }

            .followup-form input[type="datetime-local"]:focus, 
            .followup-form textarea:focus {
                border-color: #007bff;
                box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
            }

            .followup-form textarea {
                resize: vertical;
                min-height: 100px;
            }
        </style>
    </div>

    <style>
        /* Mobile View */
        @media (max-width: 768px) {
            html, body {
                width: 100%;
                overflow-x: hidden;
            }
            #tai_cb_toggle_button {
                display: none !important;
            }

            .org-info-wrapper {
                flex-direction: column !important;
            }
            .button-container {
                flex-direction: column;
                align-items: stretch;
            }
            .button-container button {
                width: 100%;
            }
            .followup-form input,
            .followup-form select,
            .followup-form textarea {
                width: 100% !important;
            }
        }
    </style>

    <div id="div-org8" class="content-div">
        <h2 style="margin: 20px;" id="api-key-display"><?= $organisation['external_api_key'] ?></h2>
        <button id="generate-api-key" style="margin-left: 20px;">Generate New API Key</button>
        <button id="copy-api-key" style="margin-left: 10px;">Copy API Key</button>
    </div>

    <script>
        document.getElementById('generate-api-key').addEventListener('click', function () {
            if (!confirm("Are you sure you want to generate a new API key? This may replace the existing one.")) return;

            fetch('ajax_generate_external_api_key.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ action: 'generate', organizationid: <?= $organisation_id ?> })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.api_key) {
                    document.getElementById('api-key-display').textContent = data.api_key;
                } else {
                    alert('Failed to generate API key');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred.');
            });
        });

        document.getElementById('copy-api-key').addEventListener('click', function () {
            const apiKeyText = document.getElementById('api-key-display').textContent.trim();
            if (!apiKeyText) {
                alert('No API key to copy');
                return;
            }

            navigator.clipboard.writeText(apiKeyText).then(() => {
                alert('API key copied to clipboard');
            }).catch(err => {
                console.error('Failed to copy text: ', err);
                alert('Failed to copy API key');
            });
        });
    </script>
    
    <div id="div-org-transactionlist" class="content-div">
        <?php
        // =========================================================================
        // ==            START: QBO TRANSACTION HISTORY FEATURE                   ==
        // =========================================================================
        
        // This block fetches and displays the customer's full transaction history.
        // It is designed to be self-contained and easily integrated into a larger dashboard.
        
        // --- Step 1: Initialize variables and ensure the QBO connection is ready ---
        $allTransactions = [];
        $financialData = [];
        $qboTransErrorMessage = null; // Used to hold a friendly error message.
        $totalAmount = 0.0; 
        
        // The $qboUtil object is assumed to be available from the 'qbo_bootstrap.php' include.
        
        try {
            // --- Step 2: Validate the connection and input data ---
            if (!$qboUtil) {
                throw new Exception("QuickBooks connection is not available.");
            }
            
            $customerNameToSearch = $organisation['organization_name'] ?? null;
            
            if (!$customerNameToSearch) {
                throw new Exception("Organization name is not available.");
            }
        
            // --- Step 3: Fetch the data from QuickBooks using our proven hybrid method ---
            
            // Find the customer in QBO to get their ID.
            $customer = $qboUtil->queryEntityByField('Customer', 'DisplayName', $customerNameToSearch);
            
            if ($customer) {
                // Get the full history (Invoices AND Payments) for building the table.
                $allTransactions = $qboUtil->getFullTransactionHistory($customer->Id);
                
                // Get the detailed financial data (Open Balances and Due Dates) to determine the status of each invoice.
                $financialData = $qboUtil->getFinancialDetailData($customer->Id);
            } else {
                error_log("Dashboard Warning: Could not find QBO customer to fetch transaction history: " . $customerNameToSearch);
            }
        
        } catch (Exception $e) {
            // Catch any exception and prevent the dashboard from crashing.
            error_log("QBO Transaction History Feature Error: " . $e->getMessage());
            $qboTransErrorMessage = "Could not load transaction history.";
        }
        
        // =========================================================================
        // ==        END: QBO TRANSACTION HISTORY FEATURE (LOGIC)                 ==
        // =========================================================================
        ?>
        
        <!-- ======================================================================= -->
        <!-- ==     START: QBO TRANSACTION HISTORY FEATURE (HTML & CSS)           == -->
        <!-- ======================================================================= -->
        
        <!-- Transaction History Card -->
        <div class="transaction-card">
            <div class="card-header">
                <h3 class="card-title">Transaction History</h3>
            </div>
            <div class="card-body">
                <?php if ($qboTransErrorMessage): ?>
                    <p class="error-message"><?= htmlspecialchars($qboTransErrorMessage) ?></p>
                <?php elseif (empty($allTransactions)): ?>
                    <p class="no-results">No transaction history found for this customer.</p>
                <?php else: ?>
                    <table class="transaction-table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>No.</th>
                                <th>Due Date</th>
                                <th style="text-align: right;">Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($allTransactions as $txn):
                                $isPayment = (stripos($txn['transaction_type'] ?? '', 'payment') !== false);
                                $isInvoice = (stripos($txn['transaction_type'] ?? '', 'invoice') !== false);
                                
                                // Make payment amount negative for display.
                                $displayAmount = $isPayment ? -1 * abs(floatval($txn['amount'] ?? 0)) : floatval($txn['amount'] ?? 0);
                                $totalAmount += $displayAmount;
                                $invoiceNum = $txn['no_'] ?? null;
                                // Look up this invoice's details from our financial data.
                                $invoiceDetails = ($isInvoice && isset($invoiceNum)) ? ($financialData['invoice_details'][$invoiceNum] ?? null) : null;
                                $openBalance = $invoiceDetails['open_balance'] ?? null;
                                $dueDateStr = $invoiceDetails['due_date'] ?? null;
                            ?>
                            <tr class="<?= $isPayment ? 'payment-row' : '' ?>">
                                <td><?= htmlspecialchars($txn['date'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($txn['transaction_type'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($invoiceNum ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($dueDateStr ?? 'N/A') ?></td>
                                <td style="text-align: right;"><?= htmlspecialchars(number_format($displayAmount, 2)) ?></td>
                                <td>
                                    <?php
                                        if ($isPayment) {
                                            echo '<span class="status-paid">Closed</span>';
                                        } else if ($isInvoice) {
                                            // If an invoice is not in the financial details list, it means its open balance is zero.
                                            $isPaid = !isset($invoiceDetails) || (isset($openBalance) && $openBalance <= 0.01);
        
                                            if ($isPaid) {
                                                echo '<span class="status-paid">Paid</span>';
                                            } else {
                                                if (!empty($dueDateStr)) {
                                                    try {
                                                        $dueDate = new DateTime($dueDateStr);
                                                        $today = new DateTime('today');
                                                        if ($dueDate < $today) {
                                                            $diff = $today->diff($dueDate);
                                                            echo '<span class="status-overdue">Overdue ' . $diff->days . ' days</span>';
                                                        } else {
                                                            $diff = $today->diff($dueDate);
                                                            $days = $diff->days;
                                                            if ($days == 0) echo '<span class="status-open">Due today</span>';
                                                            else echo '<span class="status-open">Due in ' . $days . ' days</span>';
                                                        }
                                                    } catch (Exception $e) { echo '<span class="status-open">Open</span>'; }
                                                } else { echo '<span class="status-open">Open</span>'; }
                                            }
                                        }
                                    ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" style="text-align: right;">Total Balance</td>
                                <td style="text-align: right;"><?= htmlspecialchars(number_format($totalAmount, 2)) ?></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                <?php endif; ?>
            </div>
        </div>
        
        <style>
            /* Minimal and clean CSS for the Transaction History Card */
            .transaction-card {
                background-color: #ffffff;
                border-radius: 12px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
                border: 1px solid #e9ecef;
                margin-top: 2rem;
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            }
        
            .transaction-card .card-header {
                padding: 16px 24px;
                border-bottom: 1px solid #e9ecef;
            }
        
            .transaction-card .card-title {
                margin: 0;
                font-size: 1.25rem;
                font-weight: 600;
                color: #212529;
            }
            
            .transaction-card .card-body {
                padding: 8px 0 0; /* Padding for top, no padding for table */
            }
            
            .transaction-card .transaction-table {
                width: 100%;
                border-collapse: collapse;
            }
        
            .transaction-card th, .transaction-card td {
                text-align: left;
                padding: 14px 24px;
                border-bottom: 1px solid #f1f3f5;
            }
            
            .transaction-card thead th {
                color: #868e96;
                font-weight: 600;
                font-size: 0.8rem;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                border-bottom: 2px solid #e9ecef;
            }
        
            .transaction-card tbody tr:last-child td {
                border-bottom: none;
            }
            
            .transaction-card .no-results, .transaction-card .error-message {
                padding: 24px;
                text-align: center;
                color: #6c757d;
            }
            
            .transaction-card tfoot td {
            font-weight: bold;
            font-size: 1.1rem;
            color: #212529;
            border-top: 2px solid #dee2e6;
            }
        
            .status-overdue { font-weight: bold; color: #d93025; }
            .status-open { color: #0077c5; }
            .status-paid { color: #2d8a32; }
            .payment-row td { color: #495057; font-style: italic; }
        </style>
        
        <!-- ======================================================================= -->
        <!-- ==          END: QBO TRANSACTION HISTORY FEATURE (HTML & CSS)        == -->
        <!-- ======================================================================= -->
    <?php
}

// Vendors
else if (($title=='admin' || $title == 'account') && isset($_GET['opt']) && $_GET['opt'] == 'vendors') {
    include "header.php";
    
    $vendorNameFilter = isset($_GET['vendorname']) ? $_GET['vendorname'] : '';
    $rezdyCodeFilter = isset($_GET['rezdy_uni_vendor']) ? $_GET['rezdy_uni_vendor'] : '';
    $fareharborCodeFilter = isset($_GET['fareharbor_vendor']) ? $_GET['fareharbor_vendor'] : '';
    $emailFilter = isset($_GET['email']) ? $_GET['email'] : '';
    $phoneFilter = isset($_GET['phone']) ? $_GET['phone'] : '';
    $websiteFilter = isset($_GET['website']) ? $_GET['website'] : '';
    $vendorCountryFilter = isset($_GET['vendorcountry']) ? $_GET['vendorcountry'] : '';
    $vendorActiveFilter = isset($_GET['vendoractive']) ? $_GET['vendoractive'] : '';
    $hasContractFilter = isset($_GET['hasContract']) ? $_GET['hasContract'] : '';

    // Base query
    $sql = "SELECT vendorid, vendorName, rezdy_uni_vendor, email, phone, website, vendorCountry, preferred, vendorActive, rezdy_auto_add, fareharbor_auto_add, fareharbor_vendor FROM tdu_vendors WHERE 1=1";

    // Apply filters
    if ($vendorNameFilter) {
        $sql .= " AND vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
    }
    if ($rezdyCodeFilter) {
        if($rezdyCodeFilter == 'Yes') {
            $sql .= " AND rezdy_uni_vendor != ''";
        } else if ($rezdyCodeFilter == 'No') {
            $sql .= " AND rezdy_uni_vendor = ''";
        }
    }
    if ($fareharborCodeFilter) {
        if($fareharborCodeFilter == 'Yes') {
            $sql .= " AND fareharbor_vendor != ''";
        } else if ($fareharborCodeFilter == 'No') {
            $sql .= " AND fareharbor_vendor = ''";
        }
    }
    if ($emailFilter) {
        $sql .= " AND email LIKE '%" . $conn->real_escape_string($emailFilter) . "%'";
    }
    if ($phoneFilter) {
        $sql .= " AND phone LIKE '%" . $conn->real_escape_string($phoneFilter) . "%'";
    }
    if ($websiteFilter) {
        $sql .= " AND website LIKE '%" . $conn->real_escape_string($websiteFilter) . "%'";
    }
    if ($vendorCountryFilter) {
        $sql .= " AND vendorCountry = '" . $conn->real_escape_string($vendorCountryFilter) . "'";
    }
    if ($vendorActiveFilter) {
        $sql .= " AND vendorActive = '$vendorActiveFilter'";
    }
    if ($hasContractFilter) {
        if ($hasContractFilter == 'Uploaded') {
            $sql .= " AND vendorid IN (SELECT vendorid FROM tdu_vendors_contracts WHERE CURDATE() <= end_time)";
        } else if ($hasContractFilter == 'Inactive') {
            $sql .= " AND vendorid NOT IN (SELECT vendorid FROM tdu_vendors_contracts WHERE CURDATE() <= end_time)";
        }
    }

    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY vendorName ASC LIMIT $limit OFFSET $offset";

    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Vendor</h1>

    <table class="styled-table" style="width: 90%; margin: 20px auto;">
        <tr>
            <th><button onclick="window.location.href='quote.php?opt=add-new-vendors'">Add Vendors</button></th>
            <th style="text-align: left;">Vendor Name</th>
            <th></th>
            <th style="text-align: center;">Rezdy</th>
            <th style="text-align: center;">FareHarbor</th>
            <th style="text-align: left;">Email</th>
            <th style="text-align: left;">Phone</th>
            <th style="text-align: left;">Website</th>
            <th style="text-align: left;">Country</th>
            <th></th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="vendors">
                <td>
                    <button type="submit">Search</button>
                </td>
                <td style="padding-right: 0;">
                    <input type="text" name="vendorname" value="<?= htmlspecialchars($vendorNameFilter); ?>">
                </td>
                <td style="padding-left: 0;">
                    <i class="fa-solid fa-file-invoice-dollar"></i>
                    <select name="hasContract" style="margin: 0; width: 75px;">
                        <option value="">All</option>
                        <option value="Uploaded" <?= $hasContractFilter == 'Uploaded' ? 'selected' : ''; ?>>Uploaded</option>
                        <option value="Inactive" <?= $hasContractFilter == 'Inactive' ? 'selected' : ''; ?>>None</option>
                    </select>
                </td>
                <td>
                    <select name="rezdy_uni_vendor" style="margin: 0; width: 75px;">
                        <option value="">All</option>
                        <option value="Yes" <?= $rezdyCodeFilter == 'Yes' ? 'selected' : ''; ?>>Linked</option>
                        <option value="No" <?= $rezdyCodeFilter == 'No' ? 'selected' : ''; ?>>Unlinked</option>
                    </select>
                </td>
                <td>
                    <select name="fareharbor_vendor" style="margin: 0; width: 75px;">
                        <option value="">All</option>
                        <option value="Yes" <?= $fareharborCodeFilter == 'Yes' ? 'selected' : ''; ?>>Linked</option>
                        <option value="No" <?= $fareharborCodeFilter == 'No' ? 'selected' : ''; ?>>Unlinked</option>
                    </select>
                </td>
                <td>
                    <input type="text" name="email" value="<?= htmlspecialchars($emailFilter); ?>">
                </td>
                <td>
                    <input type="text" name="phone" value="<?= htmlspecialchars($phoneFilter); ?>">
                </td>
                <td>
                    <input type="text" name="website" value="<?= htmlspecialchars($websiteFilter); ?>">
                </td>
                <td>
                    <select name="vendorcountry" style="margin: 0; width: 100%;">
                        <option value="">All</option>
                        <option value="Australia" <?= $vendorCountryFilter == 'Australia' ? 'selected' : ''; ?>>Australia</option>
                        <option value="New Zealand" <?= $vendorCountryFilter == 'New Zealand' ? 'selected' : ''; ?>>New Zealand</option>
                    </select>
                </td>
                <td>
                    <select name="vendoractive" style="margin: 0; width: 100%;">
                        <option value="">All</option>
                        <option value="Yes" <?= $vendorActiveFilter == 'Yes' ? 'selected' : ''; ?>>Active</option>
                        <option value="No" <?= $vendorActiveFilter == 'No' ? 'selected' : ''; ?>>Inactive</option>
                    </select>
                </td>
            </form>
        </tr>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td>
                        <?php if ($row['preferred'] == 1): ?>
                            <i class="fa-solid fa-heart" 
                            style="color: red; cursor: pointer;" 
                            onclick="togglePreferred(<?= $row['vendorid']; ?>, this, 0)"
                            title="Unmark"></i>
                        <?php else: ?>
                            <i class="fa-regular fa-heart" 
                            style="cursor: pointer;" 
                            onclick="togglePreferred(<?= $row['vendorid']; ?>, this, 1)"
                            title="Mark as Preferred"></i>
                        <?php endif; ?>
                    </td>
                    <td colspan="2" style="text-align: left;">
                        <?php
                        $vendor_id_row = $row['vendorid'];
                        $sql_logo = "SELECT start_time, end_time FROM tdu_vendors_contracts WHERE vendorid='$vendor_id_row' AND CURDATE() BETWEEN start_time AND end_time ORDER BY start_time ASC";
                        $result_logo = $conn->query($sql_logo);
                        $hasLogo = $result_logo->num_rows > 0;

                        $sql_logo2 = "SELECT start_time, end_time FROM tdu_vendors_contracts WHERE vendorid='$vendor_id_row' AND CURDATE() < start_time AND CURDATE() < end_time ORDER BY start_time ASC";
                        $result_logo2 = $conn->query($sql_logo2);
                        $hasLogo2 = $result_logo2->num_rows > 0;

                        $tooltipText = '';

                        if ($hasLogo) {
                            $row_logo = $result_logo->fetch_assoc();
                            $tooltipText = "Active: " . $row_logo['start_time'] . " to " . $row_logo['end_time'];
                        } elseif ($hasLogo2) {
                            $row_logo2 = $result_logo2->fetch_assoc();
                            $tooltipText = "Upcoming: " . $row_logo2['start_time'] . " to " . $row_logo2['end_time'];
                        }
                        ?>

                        <?php if ($hasLogo) : ?>
                            <i class="fa-solid fa-file-invoice-dollar" style="color: green;" title="<?= htmlspecialchars($tooltipText) ?>"></i>
                        <?php elseif ($hasLogo2) : ?>
                            <i class="fa-solid fa-file-invoice-dollar" style="color: orange;" title="<?= htmlspecialchars($tooltipText) ?>"></i>
                        <?php endif; ?>

                        <a href="quote.php?opt=vendor-details&id=<?= urlencode($row['vendorid']); ?>&product_active=Yes">
                            <?= htmlspecialchars($row['vendorName']); ?>
                        </a>
                    </td>
                    <td style="text-align: center;">                        
                        <?php if (empty($row['rezdy_uni_vendor'])): ?>
                            <i class="fa-solid fa-link-slash" style="color: red; cursor: pointer;" onclick="openRezdyLinkModal(<?= $row['vendorid']; ?>)"></i>
                        <?php else: ?>
                            <i <?= $row['rezdy_auto_add'] == 1 ? 'class="fa-solid fa-download"' : 'class="fa-solid fa-link"'; ?> style="color: green; cursor: pointer;" onclick="openRezdyLinkModal(<?= $row['vendorid']; ?>)" title="<?= htmlspecialchars($row['rezdy_uni_vendor']) ?>"></i>
                        <?php endif; ?>
                    </td>
                    <td style="text-align: center;">
                        <?php if (empty($row['fareharbor_vendor'])): ?>
                            <i class="fa-solid fa-link-slash" style="color: red; cursor: pointer;" onclick="openFareharborLinkModal(<?= $row['vendorid']; ?>)"></i>
                        <?php else: ?>
                            <i <?= $row['fareharbor_auto_add'] == 1 ? 'class="fa-solid fa-download"' : 'class="fa-solid fa-link"'; ?> style="color: green; cursor: pointer;" onclick="openFareharborLinkModal(<?= $row['vendorid']; ?>)" title="<?= htmlspecialchars($row['fareharbor_vendor']) ?>"></i>
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['email']); ?></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['phone']); ?></td>
                    <td style="text-align: left; max-width: 200px; overflow: hidden;">
                        <?php if (!empty($row['website'])): ?>
                            <a href="<?= htmlspecialchars($row['website']); ?>" target="_blank">
                                <?= htmlspecialchars($row['website']); ?>
                            </a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['vendorCountry']); ?></td>
                    <td style="text-align: center;">
                        <?php if($row['vendorActive'] == 'Yes') { ?>
                            <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                        <?php } else { ?>
                            <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                        <?php } ?>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php endif; ?>
        <tr>
            <td></td>
            <td colspan="10" style="text-align: left;">Number of results: <?= $totalRecords ?></td>
        </tr>
    </table>
    <script>
        function togglePreferred(vendorId, iconElement, newPreferredValue) {
            fetch('ajax_vendor_preferred.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ vendorId: vendorId, preferred: newPreferredValue })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    if (newPreferredValue === 1) {
                        iconElement.classList.remove('fa-regular', 'fa-heart');
                        iconElement.classList.add('fa-solid', 'fa-heart');
                        iconElement.style.color = 'red';
                        iconElement.setAttribute('onclick', `togglePreferred(${vendorId}, this, 0)`);
                        alert('Marked as Preferred successfully.');
                    } else {
                        iconElement.classList.remove('fa-solid', 'fa-heart');
                        iconElement.classList.add('fa-regular', 'fa-heart');
                        iconElement.style.color = '';
                        iconElement.setAttribute('onclick', `togglePreferred(${vendorId}, this, 1)`);
                        alert('Unmarked successfully.');
                    }
                } else {
                    alert('Failed to update preferred status.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred. Please try again.');
            });
        }
    </script>
    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"] {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>

    <!-- Rezdy Link Modal start -->
    <div id="rezdyLinkModal" class="modal" style="display:none; position: fixed; z-index: 9999; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5);">
        <div style="background: #fff; margin: 5% auto; padding: 20px; width: 80%; max-height: 80%; overflow-y: auto;">
            <h2 style="margin: 20px 0;">Rezdy</h2>
            <input type="text" id="rezdySearch" placeholder="Search..." oninput="loadRezdyVendors()" style="width: 100%; padding: 8px; margin-bottom: 10px;">
            <div id="rezdyResults">Loading...</div>
            <button onclick="closeRezdyModal()">Close</button>
        </div>
    </div>
    <script>
        let selectedRezdyVendorId = null;

        function openRezdyLinkModal(vendorId) {
            selectedRezdyVendorId = vendorId;
            document.getElementById('rezdyLinkModal').style.display = 'block';
            loadRezdyVendors();
        }

        function closeRezdyModal() {
            document.getElementById('rezdyLinkModal').style.display = 'none';
        }

        function loadRezdyVendors() {
            const search = document.getElementById('rezdySearch').value;
            fetch('ajax_rezdy_lookup_vendor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({ search })
            })
            .then(response => response.text())
            .then(html => {
                document.getElementById('rezdyResults').innerHTML = html;
            });
        }

        function updateRezdyVendor(rezdyShortname) {
            fetch('ajax_update_rezdy_vendor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ vendorId: selectedRezdyVendorId, rezdyShortname })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("Rezdy vendor linked successfully.");
                    location.reload();
                } else {
                    alert("Failed to link Rezdy vendor.");
                }
            });
        }
    </script>
    <!-- Rezdy Link Modal end -->

    <!-- Fareharbor Link Modal start -->
    <div id="fareharborLinkModal" class="modal" style="display:none; position: fixed; z-index: 9999; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5);">
        <div style="background: #fff; margin: 5% auto; padding: 20px; width: 80%; max-height: 80%; overflow-y: auto;">
            <h2 style="margin: 20px 0;">FareHarbor</h2>
            <input type="text" id="fareharborSearch" placeholder="Search..." oninput="loadFareharborCompanies()" style="width: 100%; padding: 8px; margin-bottom: 10px;">
            <div id="fareharborResults">Loading...</div>
            <button onclick="closeFareharborModal()">Close</button>
        </div>
    </div>
    <script>
        let selectedVendorId = null;

        function openFareharborLinkModal(vendorId) {
            selectedVendorId = vendorId;
            document.getElementById('fareharborLinkModal').style.display = 'block';
            loadFareharborCompanies();
        }

        function closeFareharborModal() {
            document.getElementById('fareharborLinkModal').style.display = 'none';
        }

        function loadFareharborCompanies() {
            const search = document.getElementById('fareharborSearch').value;
            fetch('ajax_fareharbor_lookup_vendor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({ search })
            })
            .then(response => response.text())
            .then(html => {
                document.getElementById('fareharborResults').innerHTML = html;
            });
        }

        function updateFareharborVendor(shortname) {
            fetch('ajax_update_fareharbor_vendor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ vendorId: selectedVendorId, shortname })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("FareHarbor vendor linked successfully.");
                    location.reload();
                } else {
                    alert("Failed to link vendor.");
                }
            });
        }
    </script>
    <!-- Fareharbor Link Modal end -->
    <?php
}
else if (($title=='admin' || $title == 'account') && isset($_GET['opt']) && $_GET['opt'] == 'add-new-vendors') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $vendorName = $conn->real_escape_string($_POST['vendorName']);
        $email = $conn->real_escape_string($_POST['email']);
        $paymentType = $conn->real_escape_string($_POST['paymentType']);
        $vendorCountry = $conn->real_escape_string($_POST['vendorCountry']);
        $voucherRequired = $conn->real_escape_string($_POST['voucherRequired']);
        $description = $conn->real_escape_string($_POST['description']);
        $contactName = $conn->real_escape_string($_POST['contactName']);
        $phone = $conn->real_escape_string($_POST['phone']);
        $contactEmail = $conn->real_escape_string($_POST['contactEmail']);
        $ratings = isset($_POST['ratings']) ? $conn->real_escape_string($_POST['ratings']) : NULL;
        $openingHours = isset($_POST['openingHours']) ? $conn->real_escape_string($_POST['openingHours']) : NULL;
        $address = isset($_POST['address']) ? $conn->real_escape_string($_POST['address']) : NULL;
        $locationPhone = isset($_POST['locationPhone']) ? $conn->real_escape_string($_POST['locationPhone']) : NULL;
        $types = isset($_POST['types']) ? $conn->real_escape_string($_POST['types']) : NULL;
        $website = isset($_POST['website']) ? $conn->real_escape_string($_POST['website']) : NULL;
    
        // Insert query
        $sql = "INSERT INTO tdu_vendors (vendorName, email, paymentType, vendorCountry, voucherRequired, description, 
                                      contactName, phone, contactEmail, ratings, openingHours, address, locationPhone, types, website)
                VALUES ('$vendorName', '$email', '$paymentType', '$vendorCountry', '$voucherRequired', '$description',
                        '$contactName', '$phone', '$contactEmail', '$ratings', '$openingHours', '$address', '$locationPhone', '$types', '$website')";
    
        // Execute query
        if ($conn->query($sql) === TRUE) {
            $lastInsertedId = $conn->insert_id;
            
            if(isset($_GET['tpavid']) && $_GET['tpavid'] != '') {
                $tpavid = $_GET['tpavid'];
                $sql = "UPDATE tdu_product_alt_vendors_in_quote SET vendorid = '$lastInsertedId' WHERE auto_id = '$tpavid';";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));

                // Call the AJAX file after updating
                echo "<script>
                        fetch('ajax_approve_alt_product_vendors.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: 'tpavid=' + $tpavid
                        })
                        .then(response => response.text())
                        .then(data => {
                            console.log('Response:', data);
                            window.location.href = 'quote.php?opt=vendor-details&id=$lastInsertedId'; // Redirect after AJAX completes
                        })
                        .catch(error => console.error('Error:', error));
                    </script>";
                exit();
            }

            header("Location: quote.php?opt=vendor-details&id=$lastInsertedId");
            exit();
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
    
        // Close connection
        $conn->close();
    }

    include "header.php";
    ?>
    <form method="POST" action="" style="margin-bottom: 20px;">
        <h2>Vendor Information</h2>
        <div class="form-row">
            <label for="autocomplete">Search Vendor:</label>
            <input type="text" id="autocomplete" name="autocomplete">
        </div>
        <div class="form-row">
            <label for="vendorName">Vendor Name:</label>
            <input type="text" id="vendorName" name="vendorName" required>
        </div>
        <div class="form-row">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>
        </div>
        <div class="form-row">
            <label for="paymentType">Payment Type:</label>
            <select id="paymentType" name="paymentType" required>
                <option value="Credit">Credit</option>
                <option value="Prepaid">Prepaid</option>
            </select>
        </div>
        <div class="form-row">
            <label for="vendorCountry">Vendor Country:</label>
            <select id="vendorCountry" name="vendorCountry" required>
                <option value="Australia">Australia</option>
                <option value="New Zealand">New Zealand</option>
            </select>
        </div>
        <div class="form-row">
            <label for="voucherRequired">Voucher Required:</label>
            <select id="voucherRequired" name="voucherRequired" required>
                <option value="Yes">Yes</option>
                <option value="No">No</option>
            </select>
        </div>
        <div class="form-row">
            <label for="description">Description:</label>
            <textarea id="description" name="description" rows="4" required></textarea>
        </div>

        <!-- Contact Information -->
        <h2>Contact Information</h2>
        <div class="form-row">
            <label for="contactName">Contact Name:</label>
            <input type="text" id="contactName" name="contactName" required>
        </div>
        <div class="form-row">
            <label for="phone">Contact Phone:</label>
            <input type="tel" id="phone" name="phone" required>
        </div>
        <div class="form-row">
            <label for="contactEmail">Email ID:</label>
            <input type="email" id="contactEmail" name="contactEmail" required>
        </div>

        <!-- from Google -->
        <h2>Vendor Details</h2>
        <div class="form-row">
            <label for="ratings">Ratings:</label>
            <input type="number" id="ratings" name="ratings" step="0.1" min="0" max="5">
        </div>
        <div class="form-row">
            <label for="openingHours">Opening Hours:</label>
            <input type="text" id="openingHours" name="openingHours">
        </div>
        <div class="form-row">
            <label for="address">Address:</label>
            <textarea id="address" name="address" rows="4"></textarea>
        </div>
        <div class="form-row">
            <label for="locationPhone">Phone Number:</label>
            <input type="tel" id="locationPhone" name="locationPhone">
        </div>
        <div class="form-row">
            <label for="types">Types:</label>
            <input type="text" id="types" name="types">
        </div>
        <div class="form-row">
            <label for="website">Website:</label>
            <input type="url" id="website" name="website">
        </div>

        <button type="submit">Submit</button>
    </form>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCFiTkztZiUQpgWkLq4cSDJpO60hGuh5L4&libraries=places"></script>
    <script>
        let autocomplete;

        function initAutocomplete() {
            autocomplete = new google.maps.places.Autocomplete(
                document.getElementById('autocomplete'),
                { types: ['establishment'] } // Limit to establishments (you can adjust as needed)
            );
            autocomplete.addListener('place_changed', fillInFields);
        }

        function fillInFields() {
            const place = autocomplete.getPlace();
            document.getElementById('vendorName').value = place.name || '';
            document.getElementById('ratings').value = place.rating || '';
            document.getElementById('openingHours').value = place.opening_hours?.weekday_text.join(', ') || '';
            document.getElementById('address').value = place.formatted_address || '';
            document.getElementById('locationPhone').value = place.formatted_phone_number || '';
            document.getElementById('types').value = place.types?.join(', ') || '';
            document.getElementById('website').value = place.website || '';
        }

        document.addEventListener("DOMContentLoaded", initAutocomplete);
    </script>

    <style>
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin: 20px 0;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
            margin-right: 10px;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
    <?php
}
else if (($title=='admin' || $title == 'account') && isset($_GET['opt']) && $_GET['opt'] == 'vendor-details') {
    include "header.php";

    $vendor_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    if ($vendor_id > 0) {
        $sql = "SELECT * FROM tdu_vendors WHERE vendorid = $vendor_id";
        $result = $conn->query($sql);
        
        if ($result->num_rows > 0) {
            $vendor = $result->fetch_assoc();
            $rezdy_uni_vendor = $vendor['rezdy_uni_vendor'];
            $fareharbor_vendor = $vendor['fareharbor_vendor'];
        } else {
            echo "Vendor not found.";
            exit;
        }
    }

    $sql_logo = "SELECT 1 FROM tdu_vendors_contracts WHERE vendorid='$vendor_id' AND CURDATE() BETWEEN start_time AND end_time";
    $result_logo = $conn->query($sql_logo);
    $hasLogo = $result_logo->num_rows > 0;

    $sql_logo2 = "SELECT 1 FROM tdu_vendors_contracts WHERE vendorid='$vendor_id' AND CURDATE() < start_time AND CURDATE() < end_time";
    $result_logo2 = $conn->query($sql_logo2);
    $hasLogo2 = $result_logo2->num_rows > 0;

    ?>
    <div style="padding: 20px; background-color: #c5c5c5;">
        <div>
            <h1 style="text-align: left;">
                <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                <?php if($vendor['vendorActive'] == 'Yes') { ?>
                    <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                <?php } else { ?>
                    <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                <?php } ?>
                <span id="vendorName-display"><?php echo htmlspecialchars($vendor['vendorName']); ?></span>
                <input id="vendorName-edit" style="display: none; width: 80%; height: 40px;" value="<?php echo htmlspecialchars($vendor['vendorName']); ?>" />
            </h1>
        </div>
        <div style="display: flex; justify-content: space-between; margin: 0;">
            <div style="flex: 2; padding-right: 20px;">
                <h3>Basic Information</h3>
                <p>Reservation Email:
                    <span id="email-display"><?php echo htmlspecialchars($vendor['email']); ?></span>
                    <input id="email-edit" style="display:none;" type="email" value="<?php echo htmlspecialchars($vendor['email']); ?>">
                </p>
                <p>Reservation Phone:
                    <span id="reservationPhone-display"><?php echo htmlspecialchars($vendor['phone']); ?></span>
                    <input id="reservationPhone-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($vendor['phone']); ?>" />
                </p>
                <p>Payment Account:
                    <span id="paymentType-display"><?php echo htmlspecialchars($vendor['paymentType']); ?></span>
                    <select id="paymentType-edit" style="display:none;">
                        <option value="Prepaid" <?php echo $vendor['paymentType'] == 'Prepaid' ? 'selected' : ''; ?>>Prepaid</option>
                        <option value="Credit" <?php echo $vendor['paymentType'] == 'Credit' ? 'selected' : ''; ?>>Credit</option>
                    </select>
                </p>
                <p>Booking Method:
                    <span id="bookingMethod-display"><?php echo htmlspecialchars($vendor['bookingMethod']); ?></span>
                    <select id="bookingMethod-edit" style="display:none;">
                        <option value="Email" <?php echo $vendor['bookingMethod'] == 'Email' ? 'selected' : ''; ?>>Email</option>
                        <option value="Online" <?php echo $vendor['bookingMethod'] == 'Online' ? 'selected' : ''; ?>>Online</option>
                        <option value="Rezdy" <?php echo $vendor['bookingMethod'] == 'Rezdy' ? 'selected' : ''; ?>>Rezdy</option>
                        <option value="Fareharbor" <?php echo $vendor['bookingMethod'] == 'Fareharbor' ? 'selected' : ''; ?>>Fareharbor</option>
                    </select>
                </p>
                <p>Vendor Country:
                    <span id="vendorCountry-display"><?php echo htmlspecialchars($vendor['vendorCountry']); ?></span>
                    <input id="vendorCountry-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($vendor['vendorCountry']); ?>">
                </p>
                <p>Voucher Required:
                    <span id="voucherRequired-display"><?php echo htmlspecialchars($vendor['voucherRequired'] == 'Yes' ? 'Yes' : 'No'); ?></span>
                    <select id="voucherRequired-edit" style="display:none;">
                        <option value="Yes" <?php echo $vendor['voucherRequired'] == 'Yes' ? 'selected' : ''; ?>>Yes</option>
                        <option value="No" <?php echo $vendor['voucherRequired'] == 'No' ? 'selected' : ''; ?>>No</option>
                    </select>
                </p>
                <p>Description:
                    <span id="description-display"><?php echo nl2br(htmlspecialchars($vendor['description'])); ?></span>
                    <textarea id="description-edit" style="display:none;"><?php echo htmlspecialchars($vendor['description']); ?></textarea>
                </p>
                <p>Cancellation Hours (Group):  
                    <span id="cancelHoursGroup-display"><?php echo htmlspecialchars($vendor['cancelHoursGroup']); ?></span>
                    <input id="cancelHoursGroup-edit" style="display:none;" type="number" value="<?php echo htmlspecialchars($vendor['cancelHoursGroup']); ?>" />
                </p>
                <p>Cancellation Hours (FIT):  
                    <span id="cancelHoursFIT-display"><?php echo htmlspecialchars($vendor['cancelHoursFIT']); ?></span>
                    <input id="cancelHoursFIT-edit" style="display:none;" type="number" value="<?php echo htmlspecialchars($vendor['cancelHoursFIT']); ?>" />
                </p>
                <p>Show in Products Booking Status Report:
                    <span id="showWithin35Days-display"><?php echo htmlspecialchars($vendor['show_within_35_days'] == 'Yes' ? 'Within 35 Days Only' : 'Always'); ?></span>
                    <select id="showWithin35Days-edit" style="display:none;">
                        <option value="No" <?php echo $vendor['show_within_35_days'] == 'No' ? 'selected' : ''; ?>>Always</option>
                        <option value="Yes" <?php echo $vendor['show_within_35_days'] == 'Yes' ? 'selected' : ''; ?>>Within 35 Days Only</option>
                    </select>
                </p>
                <p>
                    <select id="vendorActive-edit" style="display:none; width: 100%;">
                        <option value="Yes" <?php echo $vendor['vendorActive'] == 'Yes' ? 'selected' : ''; ?>>Active</option>
                        <option value="No" <?php echo $vendor['vendorActive'] == 'No' ? 'selected' : ''; ?>>Inactive</option>
                    </select>
                </p>
                <p>
                    <button id="editBtn" onclick="toggleEditMode()"><i class="fa-solid fa-pen-to-square"></i></button>
                    <div style="margin-left: 10px; text-align: left;">
                        <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                        <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                    </div>
                </p>
            </div>
            <div style="flex: 2; padding-right: 20px;">
                <h3>Additional Information</h3>
                <p><button id="showMoreBtn" type="button" onclick="toggleDetails()"><i class="fa-solid fa-ellipsis" title="More"></i></button></p>
                <div id="vendor-details" style="display:none;">
                    <p>Ratings: <?php echo htmlspecialchars($vendor['ratings']); ?></p>
                    <p>Opening Hours: <br><?php echo str_replace(',', '<br>', $vendor['openingHours']); ?></p>
                    <p>Address: <?php echo nl2br(htmlspecialchars($vendor['address'])); ?></p>
                    <p>Location Phone: <?php echo htmlspecialchars($vendor['locationPhone']); ?></p>
                    <p>Types: <?php echo htmlspecialchars($vendor['types']); ?></p>
                    <p>Website: <a href="<?php echo htmlspecialchars($vendor['website']); ?>" target="_blank"><?php echo htmlspecialchars($vendor['website']); ?></a></p>
                </div>
            </div>
            <!-- QBO VENDOR SUMMARY START-->
            <div class="balance-card">
                <div class="card-header">
                    <h3 class="card-title">QuickBooks Summary</h3>
                </div>
                <div class="card-body">
                    <?php
                    // --- QBO VENDOR SUMMARY LOGIC ---
                    $qboVendor = null;
                    $qboErrorMessage = null;
                    $vendorFinancialData = ['summary' => ['total_balance' => 0.0, 'overdue_balance' => 0.0], 'bill_details' => []]; // Default structure
                    
                    require_once __DIR__ . '/../qbo_bootstrap.php';
                    
                    try {
                        if (!$qboUtil) {
                            throw new Exception("QuickBooks connection could not be established.");
                        }
                        
                        $vendorNameToSearch = $vendor['vendorName'] ?? null;
                        
                        if (!$vendorNameToSearch) {
                            throw new Exception("Local vendor name is not available.");
                        }

                        // Use the robust fuzzy search to find the vendor in QBO
                        $qboVendor = $qboUtil->findEntityByFuzzyName('Vendor', $vendorNameToSearch);

                        // --- CHANGE 1: If vendor is found, get their detailed financial data ---
                        if ($qboVendor) {
                            $vendorFinancialData = $qboUtil->getVendorFinancialDetailData($qboVendor->Id);
                        }

                    } catch (Exception $e) {
                        error_log("QBO Vendor Summary Feature Error: " . $e->getMessage());
                        $qboErrorMessage = "Could not load summary data.";
                    }
                    // --- END LOGIC ---
                    
                    if ($qboErrorMessage): ?>
                        <div class="balance-item">
                            <span class="balance-label error-message"><?= htmlspecialchars($qboErrorMessage) ?></span>
                        </div>
                    <?php elseif ($qboVendor): ?>
                        <div class="balance-item">
                            <span class="balance-label">Total Open Balance</span>
                            <span class="balance-value">
                                <!-- Use the value from the more detailed report for consistency -->
                                <?= htmlspecialchars(number_format($vendorFinancialData['summary']['total_balance'], 2)) ?>
                                <span class="currency">AUD</span>
                            </span>
                        </div>
                        <!-- CHANGE 2: Add the new "Amount Overdue" row -->
                        <div class="balance-item">
                            <span class="balance-label">Amount Overdue</span>
                            <span class="balance-value overdue">
                                <?= htmlspecialchars(number_format($vendorFinancialData['summary']['overdue_balance'], 2)) ?>
                                <span class="currency">AUD</span>
                            </span>
                        </div>
                    <?php else: ?>
                        <div class="balance-item">
                            <span class="balance-label">QBO Status</span>
                            <span class="balance-label" style="color: #6c757d;">Vendor not found in QuickBooks.</span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <style>
                /* Minimal and clean CSS for the Balance Summary Card */
                .balance-card { background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.07); border: 1px solid #e9ecef; max-width: 400px; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; margin: 1rem 0; }
                .balance-card .card-header { padding: 12px 20px; border-bottom: 1px solid #e9ecef; }
                .balance-card .card-title { margin: 0; font-size: 1.1rem; font-weight: 600; color: #343a40;}
                .balance-card .card-body { padding: 8px 20px; }
                .balance-card .balance-item { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; }
                .balance-card .balance-item:not(:last-child) { border-bottom: 1px solid #f1f3f5; }
                .balance-card .balance-label { font-size: 0.9rem; color: #495057; font-weight: 500; }
                .balance-card .balance-value { font-size: 1.4rem; font-weight: 700; color: #212529; }
                .balance-card .balance-value .currency { font-size: 0.8rem; font-weight: 500; color: #6c757d; margin-left: 4px; }
                .balance-card .balance-value.overdue { color: #d93025; } /* Style for overdue amount */
                .balance-card .error-message { color: #d93025; width: 100%; }
            </style>
            <!-- QBO VENDOR SUMMARY END-->
            
            <div style="flex: 4; padding-right: 20px;"></div>
            <?php if ($hasLogo) : ?>
                <div style="flex: 2; padding-right: 20px;">
                    <h3 style="text-align: center; color: green;">
                        <i class="fa-solid fa-file-invoice-dollar" style="font-size: 200px;"></i><br><br>
                        Contract Uploaded
                    </h3>
                </div>
            <?php elseif ($hasLogo2) : ?>
                <div style="flex: 2; padding-right: 20px;">
                    <h3 style="text-align: center; color: orange;">
                        <i class="fa-solid fa-file-invoice-dollar" style="font-size: 200px;"></i><br><br>
                        Contract Uploaded but Inactive
                    </h3>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <script>
        function toggleDetails() {
            var details = document.getElementById('vendor-details');
            var button = document.getElementById('showMoreBtn');

            if (details.style.display === 'none') {
                details.style.display = 'block';
            } else {
                details.style.display = 'none';
            }
        }

        function cancelEdit() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => {
                el.style.display = 'inline';
            });
            document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => {
                el.style.display = 'none';
            });

            document.getElementById('editBtn').style.display = 'inline';
            document.getElementById('saveBtn').style.display = 'none';
            document.getElementById('cancelBtn').style.display = 'none';
        }

        function toggleEditMode() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
            document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
            
            document.getElementById('editBtn').style.display = document.getElementById('editBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('saveBtn').style.display = document.getElementById('saveBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('cancelBtn').style.display = document.getElementById('cancelBtn').style.display === 'none' ? 'inline' : 'none';
        }

        function saveChanges() {
            const data = {
                vendorName: document.getElementById('vendorName-edit').value,
                email: document.getElementById('email-edit').value,
                paymentType: document.getElementById('paymentType-edit').value,
                vendorCountry: document.getElementById('vendorCountry-edit').value,
                voucherRequired: document.getElementById('voucherRequired-edit').value,
                description: document.getElementById('description-edit').value,
                cancelHoursGroup: document.getElementById('cancelHoursGroup-edit').value,
                cancelHoursFIT: document.getElementById('cancelHoursFIT-edit').value,
                vendorActive: document.getElementById('vendorActive-edit').value,
                bookingMethod: document.getElementById('bookingMethod-edit').value,
                reservationPhone: document.getElementById('reservationPhone-edit').value,
                show_within_35_days: document.getElementById('showWithin35Days-edit').value,
                vendorID: <?php echo $vendor_id; ?>
            };

            fetch('ajax_update_vendor.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data),
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    // Reload the page after a successful update
                    window.location.reload();
                } else {
                    alert('Failed to update vendor information.');
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>

    <div class="button-container">
        <button type="button" onclick="showDiv('div-ven1', this)">Products</button>
        <button type="button" onclick="showDiv('div-ven2', this)">Contacts</button>
        <button type="button" onclick="showDiv('div-ven3', this)">MailBox</button>
        <button type="button" onclick="showDiv('div-ven4', this)">Contracts</button>
        <button type="button" onclick="showDiv('div-ven5', this)">Bank Info</button>
        <button type="button" onclick="showDiv('div-ven6', this)">Vendor Surcharge</button>
        <?php if ($rezdy_uni_vendor != '') : ?>
            <button type="button" onclick="showDiv('div-ven7', this)">Rezdy</button>
        <?php endif; ?>
        <?php if ($fareharbor_vendor != '') : ?>
            <button type="button" onclick="showDiv('div-ven8', this)">Fareharbor</button>
        <?php endif; ?>
        <!--QBO TRANSACTION LIST START-->
        <button type="button" onclick="showDiv('div-ven-transactionlist', this)">Transaction List</button>
        <!--QBO TRANSACTION LIST END-->
    </div>

    <div id="div-ven1" class="content-div">
        <?php
        $productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
        $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
        $cityFilter = isset($_GET['city']) ? $_GET['city'] : '';
        $productActiveFilter = isset($_GET['product_active']) ? $_GET['product_active'] : '';

        // Base query
        $sql = "SELECT productid, productName, category, city, productActive, preferred, 
                        sharingPrice, triplePrice, unitPrice, childPrice
                FROM tdu_products p WHERE vendorid=$vendor_id";

        // Apply filters
        if ($productNameFilter) {
            $sql .= " AND productName LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
        }
        if ($categoryFilter) {
            $sql .= " AND category LIKE '%" . $conn->real_escape_string($categoryFilter) . "%'";
        }
        if ($cityFilter) {
            $sql .= " AND city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
        }
        if ($productActiveFilter !== '') {
            $sql .= " AND productActive = '" . $conn->real_escape_string($productActiveFilter) . "'";
        }

        // Pagination
        $limit = 2000;
        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $page = max($page, 1);
        $offset = ($page - 1) * $limit;

        $sql_total = $sql;
        $total_result = mysqli_query($conn, $sql_total);
        $totalRecords = mysqli_num_rows($total_result);
        $totalPages = ceil($totalRecords / $limit);

        $sql .= " ORDER BY productName ASC LIMIT $limit OFFSET $offset";

        $result = $conn->query($sql);
        ?>

        <table class="styled-table" style="width: 100%;">
            <tr>
                <td><button onclick="window.location.href='quote.php?opt=add-new-products&vendorid=<?= $vendor_id ?>&vendorname=<?= $vendor['vendorName'] ?>'">Add Product</button></td>
                <td style="text-align: left;">
                    <button id="importBtn" onclick="openImportModal()">Import CSV</button>
                    <button onclick="window.location.href='quote.php?opt=vendor-products-bulk-edit&vendorid=<?= $vendor_id ?>&vendorname=<?= $vendor['vendorName'] ?>'">Bulk Edit Product</button>
                </td>
                <td colspan="8"></td>
            </tr>
            <tr>
                <th></th>
                <th style="text-align: left;">Product Name</th>
                <th style="text-align: left;">Category</th>
                <th style="text-align: left;">City</th>
                <th style="text-align: center;">Adult Price</th>
                <th style="text-align: center;">Child Price</th>
                <th style="text-align: center;">Double Room</th>
                <th style="text-align: center;">Triple Room</th>
                <th style="text-align: center;">Surcharge</th>
                <th style="text-align: left;">Active</th>
            </tr>
            <tr>
                <form method="GET">
                    <input type="hidden" name="opt" value="vendor-details">
                    <input type="hidden" name="id" value="<?= $vendor_id ?>">
                    <td>
                        <button type="submit">Search</button>
                    </td>
                    <td>
                        <input type="text" name="productname" value="<?= htmlspecialchars($productNameFilter); ?>">
                    </td>
                    <td>
                        <input type="text" name="category" value="<?= htmlspecialchars($categoryFilter); ?>">
                    </td>
                    <td>
                        <input type="text" name="city" value="<?= htmlspecialchars($cityFilter); ?>">
                    </td>
                    <td colspan="5"></td>
                    <td>
                        <select name="product_active">
                            <option value="" <?= $productActiveFilter === '' ? 'selected' : ''; ?>>All</option>
                            <option value="Yes" <?= $productActiveFilter === 'Yes' ? 'selected' : ''; ?>>Yes</option>
                            <option value="No" <?= $productActiveFilter === 'No' ? 'selected' : ''; ?>>No</option>
                        </select>
                    </td>
                </form>
            </tr>

            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <?php
                    $productid_b = $row['productid'];
                    $sqlb = "SELECT 1 FROM tdu_pricebook WHERE productid = '$productid_b' AND CURDATE() BETWEEN start_date AND end_date";
                    $resultb = mysqli_query($conn, $sqlb);
                    $isWithinDateRange = mysqli_num_rows($resultb) > 0;
                    ?>
                    <tr>
                        <td><input type="checkbox" class="product-checkbox" style="width: unset;" value="<?= $row['productid'] ?>"></td>
                        <td style="text-align: left;">
                            <?php if ($row['preferred'] == 1): ?>
                                <i class="fa-solid fa-heart" 
                                style="color: red; cursor: pointer;" 
                                onclick="togglePreferred(<?= $row['productid']; ?>, this, 0)"
                                title="Unmark"></i>
                            <?php else: ?>
                                <i class="fa-regular fa-heart" 
                                style="cursor: pointer;" 
                                onclick="togglePreferred(<?= $row['productid']; ?>, this, 1)"
                                title="Mark as Preferred"></i>
                            <?php endif; ?>
                            <?= $isWithinDateRange ? '<i class="fa-solid fa-money-check-dollar" style="color: green;" title="PriceBook UP-TO-DATE"></i>' : ''?>
                            <a href="quote.php?opt=product-details&productid=<?= htmlspecialchars($row['productid']); ?>">
                                <?= htmlspecialchars($row['productName']); ?>
                            </a>
                        </td>
                        <td style="text-align: left;"><?= htmlspecialchars($row['category']); ?></td>
                        <td style="text-align: left;"><?= htmlspecialchars($row['city']); ?></td>
                        <td style="text-align: center;"><?= empty($row['unitPrice']) ? '' : '$' ?> <?= htmlspecialchars($row['unitPrice']); ?></td>
                        <td style="text-align: center;"><?= empty($row['childPrice']) ? '' : '$' ?> <?= htmlspecialchars($row['childPrice']); ?></td>
                        <td style="text-align: center;"><?= empty($row['sharingPrice']) ? '' : '$' ?> <?= htmlspecialchars($row['sharingPrice']); ?></td>
                        <td style="text-align: center;"><?= empty($row['triplePrice']) ? '' : '$' ?> <?= htmlspecialchars($row['triplePrice']); ?></td>
                        <td style="text-align: center;">
                            <?php
                            $monthNames = ["1" => "Jan", "2" => "Feb", "3" => "Mar", "4" => "Apr", "5" => "May", "6" => "Jun", "7" => "Jul", "8" => "Aug", "9" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec"];
                            $sql3 = "SELECT * FROM tdu_products_surcharge ps 
                                     LEFT JOIN tdu_vendors_surcharge s ON ps.surcharge_id = s.auto_id
                                     WHERE ps.productid = '$productid_b';";
                            $result3 = $conn->query($sql3);
                            while ($row3 = $result3->fetch_assoc()) {
                                $period_text = $monthNames[(int)$row3["start_m"]] . "-" . $row3["start_d"] . " - " . $monthNames[(int)$row3["end_m"]] . "-" . $row3["end_d"];
                                ?>
                                <span style="display: inline-block; background-color: #c5c5c5; padding: 5px 10px; margin: 2px; border-radius: 10px; position: relative;">
                                    <?php echo $period_text . ": $" . number_format($row3["surcharge"], 2); ?>
                                    <button onclick="deleteProductSurchargeRow(<?php echo $row3['id']; ?>)" style="border: none; background: none; color: red; font-weight: bold; position: absolute; top: -5px; right: -5px; cursor: pointer;"><i class="fa-solid fa-xmark"></i></button>
                                </span>
                                <?php
                            }
                            ?>
                        </td>
                        <td style="text-align: left;"><?= $row['productActive']=='Yes' ? 'Yes' : 'No'; ?></td>
                    </tr>
                <?php endwhile; ?>
                <tr>
                    <td><input type="checkbox" id="selectAll" style="width: unset; vertical-align: middle;" onclick="toggleAllCheckboxes(this)"> All</td><td colspan="9" style="text-align: left;"><button type="button" id="bulkEditBtn" onclick="openSurchargeModal()">Bulk Apply Surcharge</button></td>
                </tr>
            <?php else: ?>
                <tr>
                    <td></td><td colspan="9" style="text-align: left;">No results found</td>
                </tr>
            <?php endif; ?>
        </table>
        <script>
            function togglePreferred(productId, iconElement, newPreferredValue) {
                fetch('ajax_product_preferred.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ productId: productId, preferred: newPreferredValue })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        if (newPreferredValue === 1) {
                            iconElement.classList.remove('fa-regular', 'fa-heart');
                            iconElement.classList.add('fa-solid', 'fa-heart');
                            iconElement.style.color = 'red';
                            iconElement.setAttribute('onclick', `togglePreferred(${productId}, this, 0)`);
                            alert('Marked as Preferred successfully.');
                        } else {
                            iconElement.classList.remove('fa-solid', 'fa-heart');
                            iconElement.classList.add('fa-regular', 'fa-heart');
                            iconElement.style.color = '';
                            iconElement.setAttribute('onclick', `togglePreferred(${productId}, this, 1)`);
                            alert('Unmarked successfully.');
                        }
                    } else {
                        alert('Failed to update preferred status.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred. Please try again.');
                });
            }

            function deleteProductSurchargeRow(id) {
                if (!confirm("Are you sure you want to delete this product surcharge?")) return;

                fetch("ajax_delete_product_surcharge.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    body: `id=${id}`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("Deleted!");
                        location.reload();
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error("Error:", error);
                    alert("Something went wrong!");
                });
            }
        </script>

        <!-- surcharge modal start -->
        <div id="surchargeModal" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); background:white; padding:20px; border:1px solid #ccc; z-index:1001;">
            <h3>Select Surcharge Rule</h3>
            <form id="bulkSurchargeForm">
                <input type="hidden" name="product_ids" id="product_ids">
                
                <div id="surcharge-options">
                    <?php
                    // Get all surcharge rules for this vendor
                    $surcharge_sql = "SELECT * FROM tdu_vendors_surcharge WHERE vendorid = $vendor_id ORDER BY start_m, start_d";
                    $surcharge_result = mysqli_query($conn, $surcharge_sql);

                    // Helper function to format date
                    function format_day_month($day, $month) {
                        $date = DateTime::createFromFormat('!j-n', "$day-$month");
                        return $date ? $date->format('d/M') : "$day/$month";
                    }

                    if (mysqli_num_rows($surcharge_result) > 0) {
                        while ($s = mysqli_fetch_assoc($surcharge_result)) {
                            $start = format_day_month($s['start_d'], $s['start_m']);
                            $end = format_day_month($s['end_d'], $s['end_m']);
                            $rule = "$start - $end: \${$s['surcharge']}";
                            echo "<label style='vertical-align: middle;'><input type='radio' name='surcharge_id' value='{$s['auto_id']}' style='width: unset; vertical-align: middle;'> $rule</label><br>";
                        }
                    } else {
                        echo "<em>No surcharge rules available.</em>";
                    }
                    ?>
                </div>
                <br>
                <button type="button" onclick="submitBulkSurcharge()">Apply</button>
                <button type="button" onclick="closeSurchargeModal()">Cancel</button>
            </form>
        </div>
        <div id="modalOverlaySurcharge" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000;" onclick="closeSurchargeModal()"></div>
        <script>
            function toggleAllCheckboxes(source) {
                document.querySelectorAll('.product-checkbox').forEach(cb => cb.checked = source.checked);
            }

            function openSurchargeModal() {
                // Collect selected product IDs
                const checkboxes = document.querySelectorAll('.product-checkbox:checked');
                const productIds = Array.from(checkboxes).map(cb => cb.value);

                if (productIds.length === 0) {
                    alert('Please select at least one product.');
                    return;
                }

                document.getElementById('product_ids').value = productIds.join(',');
                document.getElementById('surchargeModal').style.display = 'block';
                document.getElementById('modalOverlaySurcharge').style.display = 'block';
            }

            function closeSurchargeModal() {
                document.getElementById('surchargeModal').style.display = 'none';
                document.getElementById('modalOverlaySurcharge').style.display = 'none';
            }

            function submitBulkSurcharge() {
                const formData = new FormData(document.getElementById('bulkSurchargeForm'));

                fetch('ajax_bulk_update_surcharge.php', {
                    method: 'POST',
                    body: formData,
                })
                .then(res => res.text())
                .then(data => {
                    alert(data);
                    closeSurchargeModal();
                    location.reload(); // reload page to refresh changes
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred.');
                });
            }
        </script>
        <!-- surcharge modal end -->

        <div id="importModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; border: 1px solid #ccc; padding: 20px; z-index: 1000;">
            <h2>Import Products</h2>
            <form id="importForm">
                <input type="hidden" name="vendor_id" value="<?= $vendor_id ?>"><br>
                <label for="csvFile">Upload CSV File:</label>
                <a href="vendor_uploads/products-import-template.csv" download>Download Template</a><br><br>
                <input type="file" name="csv_file" id="csvFile" accept=".csv" required>
                <br><br>
                <button type="button" onclick="uploadCSV()">Upload</button>
                <button type="button" onclick="closeImportModal()">Cancel</button>
            </form>
        </div>

        <!-- Modal Overlay -->
        <div id="modalOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999;" onclick="closeImportModal()"></div>

        <script>
            function openImportModal() {
                document.getElementById('importModal').style.display = 'block';
                document.getElementById('modalOverlay').style.display = 'block';
            }

            function closeImportModal() {
                document.getElementById('importModal').style.display = 'none';
                document.getElementById('modalOverlay').style.display = 'none';
            }

            function uploadCSV() {
                const formData = new FormData(document.getElementById('importForm'));
                const fileInput = document.getElementById('csvFile');

                if (!fileInput.files.length) {
                    alert("Please select a CSV file.");
                    return;
                }

                formData.append('csv_file', fileInput.files[0]);

                fetch('ajax_import_products_csv.php', {
                    method: 'POST',
                    body: formData,
                })
                    .then(response => response.text())
                    .then(data => {
                        alert(data); // Show the server response
                        closeImportModal();
                        location.reload(); // Reload the page to reflect new data
                    })
                    .catch(error => console.error('Error:', error));
            }
        </script>

        <div class="pagination" style="margin-top: 0;">
            <div>
                <?php if ($page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                <?php endif; ?>

                <?php
                $max_pages = min($totalPages, $page + 2);
                for ($i = $page; $i <= $max_pages; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>

                <?php if ($page < $totalPages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                <?php endif; ?>
            </div>
            
            <form method="GET" action="" style="display:inline;">
                <?php
                foreach ($_GET as $key => $value) {
                    if ($key != 'page') {
                        echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                    }
                }
                ?>
                <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
                <button type="submit">Jump</button>
            </form>
        </div>
        <style>
            .pagination {
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 20px 0;
            }
            
            .pagination div {
                display: flex;
                align-items: center;
            }
            
            .pagination a {
                text-decoration: none;
                padding: 8px 12px;
                margin: 0 5px;
                border: 1px solid #334155;
                color: #334155;
                border-radius: 4px;
                transition: background-color 0.3s, color 0.3s;
            }
            
            .pagination a:hover {
                background-color: #334155;
                color: white;
            }
            
            .pagination input[type="number"] {
                width: 50px;
                padding: 10px;
                margin-left: 10px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            
            .pagination button {
                padding: 10px 10px;
                margin-left: 5px;
                border: none;
                border-radius: 4px;
                background-color: #334155;
                color: white;
                cursor: pointer;
                transition: background-color 0.3s;
            }
            
            .pagination button:hover {
                background-color: #334155;
            }
            
            tr:nth-child(odd) {
                background-color: #f9f9f9;
            }

            .styled-table td input[type="text"], .styled-table td select, input, textarea {
                width: 100%;
                height: 30px;
                margin: 0;
            }
        </style>
    </div>

    <div id="div-ven2" class="content-div">
        <?php
        $sqlContacts = "
            SELECT 
                name, 
                email, 
                mobile,
                auto_id AS id
            FROM tdu_contacts 
            WHERE vendorid = $vendor_id
        ";

        $resultContacts = mysqli_query($conn, $sqlContacts);
        ?>

        <!-- Contact Modal -->
        <div id="contact-modal" class="modal" style="display: none;">
            <div class="modal-content" style="width: 400px; padding: 20px; box-sizing: border-box;">
                <span class="close" style="font-size: 30px; font-weight: bold; position: relative; top: 0px; right: 0px; cursor: pointer;">&times;</span>
                <h2 style="text-align: center;">Add New Contact</h2><br>
                <form id="add-contact-form" style="display: flex; flex-direction: column; gap: 10px;">
                    <input type="hidden" name="vendor_id" value="<?php echo $vendor_id; ?>">

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="name" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Name:</label>
                        <input type="text" id="name" name="name" required style="width: 70%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="email" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Email:</label>
                        <input type="email" id="email" name="email" required style="width: 70%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>

                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <label for="mobile" style="flex: 0 0 30%; margin-bottom: 5px; font-weight: bold;">Mobile:</label>
                        <input type="tel" id="mobile" name="mobile" required style="width: 100%; padding: 8px; text-align: left; box-sizing: border-box;">
                    </div>
                    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">
                    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
                    <script>
                        var input = document.querySelector("#mobile");
                        var iti = window.intlTelInput(input, {
                            initialCountry: "au", // Auto-detect based on IP
                            separateDialCode: true, // Show country code separately
                            nationalMode: false, // Full number with country code
                            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js",
                            preferredCountries: ["in", "au", "nz"]
                        });
                    </script>

                    <button type="submit" style="padding: 10px 20px; border: none; cursor: pointer; width: 100%;">Save Contact</button>
                </form>
            </div>
        </div>

        <?php if (mysqli_num_rows($resultContacts) > 0) : ?>
            <table class="styled-table" id="contacts-table">
                <tr>
                    <th><button id="add-contact-btn">+</button></th>
                    <th style="text-align: left;">Name</th>
                    <th style="text-align: left;">Email</th>
                    <th style="text-align: left;">Mobile</th>
                </tr>
                <?php while ($row = mysqli_fetch_assoc($resultContacts)) : ?>
                    <tr>
                        <td>
                            <button class="delete-contact-btn" style="background-color: red; color: white;" data-id="<?php echo htmlspecialchars($row['id']); ?>">
                                Del
                            </button>
                        </td>
                        <td style="text-align: left;"><?php echo htmlspecialchars($row['name']); ?></td>
                        <td style="text-align: left;">
                            <a href="mailto:<?php echo htmlspecialchars($row['email']); ?>">
                                <?php echo htmlspecialchars($row['email']); ?>
                            </a>
                        </td>
                        <td style="text-align: left;"><?php echo htmlspecialchars($row['mobile']); ?></td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>No contacts found for this organization. <button id="add-contact-btn">+</button></p>
        <?php endif; ?>
    </div>

    <div id="div-ven3" class="content-div">
        <?php
        $sql13 = "SELECT te.received_datetime, te.sender_name, te.subject, vs.status, te.conversation_id
                FROM tdu_emails te
                LEFT JOIN vtiger_support vs ON vs.ticketid = te.conversation_id
                WHERE vs.vendorid='$vendor_id'";
        $sql13 .= " AND te.received_datetime IN (
            SELECT MAX(received_datetime) 
            FROM tdu_emails WHERE folder='Inbox'
            GROUP BY conversation_id, mailbox
        )";
        $sql13 .= " ORDER BY te.received_datetime DESC";
        $result13 = mysqli_query($conn, $sql13);

        if (mysqli_num_rows($result13) > 0) :
            ?>
            <table class="styled-table">
                <tr>
                    <th>Received Time</th>
                    <th>Subject</th>
                    <th>From</th>
                    <th>Status</th>
                </tr>
                <?php
                while ($row = mysqli_fetch_assoc($result13)) :
                ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['received_datetime']); ?></td>
                        <td>
                            <a href="quote.php?opt=email-content&conversation_id=<?php echo urlencode($row['conversation_id']); ?>">
                                <?php echo htmlspecialchars($row['subject']); ?>
                            </a>
                        </td>
                        <td><?php echo htmlspecialchars($row['sender_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['status']); ?></td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>No records found.</p>
        <?php endif; ?>
    </div>

    <div id="div-ven4" class="content-div">
        <div id="contractModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
            <div>
                <span class="close" onclick="closeContractModal()">×</span>
                <h2>Add Contract</h2>
                <form id="contractForm">
                    <input type="hidden" name="vendorid" value="<?php echo $vendor_id; ?>">
                    <label for="contractname">Contract Name:</label>
                    <input type="text" id="contractname" name="contractname" style="width: 100%;" required><br><br>
    
                    <label for="start_time">Period:</label><br>
                    <input type="date" id="start_time" name="start_time" style="width: 47%;" required> to <input type="date" id="end_time" name="end_time" style="width: 47%;" required><br><br>
    
                    <label for="attachment">Attachment:</label>
                    <input type="file" id="attachment" name="attachment"><br><br>
    
                    <button type="button" onclick="saveContract()">Add Contract</button>
                </form>
            </div>
        </div>

        <script>
            function openContractModal() {
                document.getElementById("contractModal").style.display = "block";
            }
            function closeContractModal() {
                document.getElementById("contractModal").style.display = "none";
            }
            function saveContract() {
                var formData = new FormData(document.getElementById("contractForm"));
                var xhr = new XMLHttpRequest();
                xhr.open("POST", "ajax_add_vendor_contract.php", true);
                xhr.onload = function () {
                    if (xhr.status === 200) {
                        alert("Contract saved successfully");
                        location.reload();
                    } else {
                        alert("Error saving contract");
                    }
                };
                xhr.send(formData);
            }
            function deleteContract(auto_id) {
                if (confirm("Are you sure you want to delete this contract?")) {
                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "ajax_delete_vendor_contract.php", true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            var response = xhr.responseText.trim(); // Get the response text and trim whitespace
                            if (response === "Success") {
                                // Remove the contract row from the table
                                document.getElementById("contract-row-" + auto_id).remove();
                                alert("Contract deleted successfully");
                            } else {
                                alert("Error deleting contract: " + response); // Show error message returned from PHP
                            }
                        } else {
                            alert("Error deleting contract");
                        }
                    };

                    xhr.send("auto_id=" + auto_id); // Send the auto_id parameter to PHP
                }
            }
        </script>

        <!-- TAI CODE START: CSS for Loading Spinner and Modal -->
        <style>
            /* Simple CSS Spinner */
            #taiCompareLoadingSpinner {
                border: 4px solid #f3f3f3; /* Light grey */
                border-top: 4px solid #3498db; /* Blue */
                border-radius: 50%;
                width: 40px;
                height: 40px;
                animation: tai-spin 1s linear infinite;
                margin-bottom: 10px; /* Space between spinner and text */
            }
        
            @keyframes tai-spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
        
            /* --- General Modal Styles --- */
            #taiCompareModal { /* Overlay */
                display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
                background: rgba(0, 0, 0, 0.6); z-index: 1001; align-items: center; justify-content: center;
            }
            #taiCompareModalContentBox { /* Content Box */
                width: 85%; /* Adjust as needed */
                background: white; border: 1px solid #ccc; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
                padding: 20px; max-height: 90vh; /* Limit height */
                display: flex; flex-direction: column; /* Use flexbox for layout */
                min-height: 300px; /* Ensure minimum size */
            }
            #taiCompareModalContentBox .close { /* Close Button */
                cursor: pointer; position: absolute; top: 10px; right: 15px; font-size: 1.8em; line-height: 1; z-index: 11;
                color: #555;
            }
             #taiCompareModalContentBox .close:hover {
                color: #000;
             }
            #taiCompareModalHeader { /* Header area for title and buttons */
                margin-bottom: 15px;
                padding-bottom: 10px;
                border-bottom: 1px solid #ddd;
                flex-shrink: 0; /* Prevent header from shrinking */
            }
            #taiCompareModalHeader h2 { /* Modal Title */
                 margin-top: 0;
                 margin-bottom: 10px;
                 display: inline-block;
                 font-size: 1.5em;
            }
            #taiCompareModalHeader .modal-controls { /* Container for nav/action buttons */
                margin-bottom: 5px;
                display: flex;
                gap: 10px;
                flex-wrap: wrap;
            }
            #taiCompareModalHeader button { /* General buttons in header */
                padding: 6px 12px;
                cursor: pointer;
                border: 1px solid #ccc;
                background-color: #f0f0f0;
                border-radius: 4px;
                font-size: 0.9em;
            }
             #taiCompareModalHeader button.active-nav { /* Style for active nav button */
                font-weight: bold;
                border-color: #999;
                background-color: #e0e0e0;
            }
             #taiCompareModalHeader button:disabled { /* Style for disabled buttons */
                opacity: 0.6;
                cursor: not-allowed;
             }
             #taiCompareModalHeader button#taiRegenerateBtn { /* Regenerate button style */
                background-color: #ffc107; border-color: #ffc107; color: #333;
             }
              #taiCompareModalHeader button#taiRegenerateBtn:hover:not(:disabled) {
                background-color: #e0a800; border-color: #e0a800;
             }
        
            #taiCompareModalContentArea { /* Main content area - grows and scrolls */
                flex-grow: 1; /* Allow this area to fill space */
                overflow-y: auto; /* Enable vertical scrolling */
                position: relative; /* Needed for absolute positioned overlay */
                min-height: 150px; /* Ensure minimum height */
            }
        
            #taiCompareLoadingOverlay { /* Loading overlay - covers content area */
                 display: none; /* Hidden by default */
                 position: absolute; top: 0; left: 0; width: 100%; height: 100%;
                 background: rgba(255, 255, 255, 0.95);
                 z-index: 10; /* Above content, below header/close button */
                 flex-direction: column; align-items: center; justify-content: center; text-align: center;
                 padding: 20px; box-sizing: border-box;
            }
            #taiCompareLoadingOverlay p { font-weight: bold; font-size: 1.1em; margin-top: 10px; }
        
            /* ============================================ */
            /* Styles for Page 2 (Select Changes)           */
            /* ============================================ */
            #taiComparePage2 {
                height: 100%; /* Fill the content area height */
                display: flex; flex-direction: column; /* Column layout for content + footer */
            }
            #taiComparePage2 .page2-content-scroll {
                flex-grow: 1; /* Allow content to take available space */
                overflow-y: auto; /* Scroll content independently */
                padding-bottom: 80px; /* Space for sticky footer */
            }
            #taiComparePage2 .data-section { /* Style for Vendor, Product, Pricebook sections */
                margin-bottom: 20px; padding: 15px; border: 1px solid #e0e0e0; border-radius: 4px; background-color: #fdfdfd;
            }
            #taiComparePage2 h2 { /* Section headers */
                margin-top: 0; margin-bottom: 15px; padding-bottom: 5px; border-bottom: 1px solid #ccc; font-size: 1.3em;
            }
            /* Vendor specific styles */
            #taiComparePage2 .vendor-section .field-group { display: flex; align-items: flex-start; margin-bottom: 8px; padding: 4px 0; border-bottom: 1px dotted #eee; }
            #taiComparePage2 .vendor-section .field-group:last-child { border-bottom: none; }
            #taiComparePage2 .vendor-section .field-group input[type="checkbox"] { margin-right: 10px; margin-top: 2px; flex-shrink: 0; width: 16px; height: 16px; }
            #taiComparePage2 .vendor-section .field-group .data-label { font-weight: bold; min-width: 170px; flex-shrink: 0; margin-right: 10px; padding-top: 1px; }
            #taiComparePage2 .vendor-section .field-group .data-values { flex-grow: 1; word-break: break-word; line-height: 1.4; }
            /* General value display styles */
            #taiComparePage2 .suggested-value { display: inline; font-weight: normal; }
            #taiComparePage2 .original-value { font-size: 0.85em; color: #555; margin-left: 5px; display: inline; font-style: italic; }
            /* Mismatch highlighting */
            #taiComparePage2 .value-mismatch .suggested-value { font-weight: bold; color: #c7254e; } /* Highlight suggested value on mismatch */
            #taiComparePage2 .value-mismatch .original-value { color: #333; font-weight: normal; } /* Ensure original is normal weight */
            /* Table specific value styles */
            #taiComparePage2 table .original-value { display: block; margin-left: 0; margin-top: 2px; }
            #taiComparePage2 th.select-col, #taiComparePage2 td.select-col { width: 40px; text-align: center; vertical-align: middle; }
            #taiComparePage2 table input[type="checkbox"] { margin: 0 auto; display: block; vertical-align: middle; width: 16px; height: 16px; }
            /* New entry highlighting */
            #taiComparePage2 .new-row-highlight td { background-color: #eaf7ea !important; } /* Use !important if needed to override other background styles */
            #taiComparePage2 .new-row-highlight .original-value { color: #1a7a1a; font-style: italic; font-weight: bold; }
            /* Link styling */
            #taiComparePage2 .data-values a { color: #007bff; text-decoration: none; }
            #taiComparePage2 .data-values a:hover { text-decoration: underline; }
            /* Table basic styles */
            #taiComparePage2 table { width: 100%; border-collapse: collapse; margin-bottom: 15px; font-size: 0.9em; } /* Slightly smaller table font */
            #taiComparePage2 th, #taiComparePage2 td { border: 1px solid #ddd; padding: 6px 8px; text-align: left; vertical-align: top;} /* Adjust padding */
            #taiComparePage2 th { background-color: #f2f2f2; font-weight: bold; }
            #taiComparePage2 tbody tr:nth-child(odd) { background-color: #f9f9f9; }
            #taiComparePage2 tbody tr:hover { background-color: #f1f1f1; }
        
            /* --- Apply Changes Footer (Page 2) --- */
            #taiComparePage2 #apply-changes-footer {
                padding: 15px 20px; /* Match content box padding */
                background-color: #f8f9fa;
                border-top: 1px solid #dee2e6;
                text-align: right;
                position: sticky; bottom: -20px; /* Stick to bottom of content box (adjust padding) */
                z-index: 5; flex-shrink: 0; /* Prevent footer shrinking */
                margin-left: -20px; margin-right: -20px; /* Extend to box edges */
            }
            #taiComparePage2 #apply-changes-footer button { padding: 10px 20px; font-size: 1em; cursor: pointer; background-color: #28a745; color: white; border: none; border-radius: 4px; transition: background-color 0.2s ease; }
            #taiComparePage2 #apply-changes-footer button:hover:not(:disabled) { background-color: #218838; }
            #taiComparePage2 #apply-changes-footer button:disabled { background-color: #a0a0a0; cursor: not-allowed; }
        
        </style>
        <!-- TAI CODE END: CSS for Loading Spinner and Modal -->
        
        <!-- TAI CODE START: Compare Modal HTML -->
        <!-- Modal Background/Overlay -->
        <div id="taiCompareModal" onclick="handleTaiModalOverlayClick(event)">
            <!-- Modal Content Box -->
            <div id="taiCompareModalContentBox">
                <!-- Close Button -->
                <span class="close" onclick="closeTaiCompareModal()" title="Close">×</span>
        
                <!-- Modal Header (Title & Buttons) -->
                <div id="taiCompareModalHeader">
                    <h2>Contract Comparison</h2>
                    <div class="modal-controls">
                        <button type="button" id="taiCompareNavBtn1" onclick="showTaiComparePage('taiComparePage1')">Comparison Report</button>
                        <button type="button" id="taiCompareNavBtn2" onclick="showTaiComparePage('taiComparePage2')" disabled>Select Changes</button>
                        <button type="button" id="taiRegenerateBtn" onclick="regenerateComparison()" style="margin-left: auto;" title="Clear results and re-queue for processing" disabled>Regenerate</button>
                    </div>
                </div>
        
                <!-- Content Area for Modal Pages -->
                <div id="taiCompareModalContentArea">
                    <!-- Loading Overlay (covers content area) -->
                    <div id="taiCompareLoadingOverlay"> <!-- Initially hidden -->
                        <div id="taiCompareLoadingSpinner"></div>
                        <p id="taiCompareLoadingText">Loading...</p>
                    </div>
                    <!-- End Loading Overlay -->
        
                    <!-- Page 1: Comparison Report (Populated by JS) -->
                    <div id="taiComparePage1" style="display: block;">
                        <!-- Status/Report content dynamically loaded here -->
                        <p>Click "Get Comparison" on the previous page to load data.</p>
                    </div>
        
                    <!-- Page 2: Select Changes (Populated by JS) -->
                    <div id="taiComparePage2" style="display: none;">
                        <!-- This outer div allows content scrolling independent of the sticky footer -->
                        <div class="page2-content-scroll">
                            <!-- Vendor Details Section -->
                            <div class="data-section vendor-section">
                                <h2>Vendor Details (Select fields to update)</h2>
                                <!-- Vendor fields will be populated by JS -->
                                <div class="field-group" data-field="vendorid"><input type="checkbox" class="vendor-field-selector" data-field-name="vendorid" disabled><span class="data-label">Vendor ID:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="vendorName"><input type="checkbox" class="vendor-field-selector" data-field-name="vendorName"><span class="data-label">Vendor Name:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="email"><input type="checkbox" class="vendor-field-selector" data-field-name="email"><span class="data-label">General Email:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="phone"><input type="checkbox" class="vendor-field-selector" data-field-name="phone"><span class="data-label">Phone:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="website"><input type="checkbox" class="vendor-field-selector" data-field-name="website"><span class="data-label">Website:</span><div class="data-values"><a href="#" target="_blank" class="suggested-link"><span class="suggested-value"></span></a><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="address"><input type="checkbox" class="vendor-field-selector" data-field-name="address"><span class="data-label">Address:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="vendorCountry"><input type="checkbox" class="vendor-field-selector" data-field-name="vendorCountry"><span class="data-label">Country:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <hr style="border-top: 1px solid #ccc; margin: 10px 0;">
                                <!--<div class="field-group" data-field="contactName"><input type="checkbox" class="vendor-field-selector" data-field-name="contactName"><span class="data-label">Contact Name:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>-->
                                <!--<div class="field-group" data-field="contactEmail"><input type="checkbox" class="vendor-field-selector" data-field-name="contactEmail"><span class="data-label">Contact Email:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>-->
                                <hr style="border-top: 1px solid #ccc; margin: 10px 0;">
                                <div class="field-group" data-field="paymentType"><input type="checkbox" class="vendor-field-selector" data-field-name="paymentType"><span class="data-label">Payment Type:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="bookingMethod"><input type="checkbox" class="vendor-field-selector" data-field-name="bookingMethod"><span class="data-label">Booking Method:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="voucherRequired"><input type="checkbox" class="vendor-field-selector" data-field-name="voucherRequired"><span class="data-label">Voucher Required:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="vendorActive"><input type="checkbox" class="vendor-field-selector" data-field-name="vendorActive"><span class="data-label">Vendor Active:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <!--<div class="field-group" data-field="ratings"><input type="checkbox" class="vendor-field-selector" data-field-name="ratings"><span class="data-label">Ratings:</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>-->
                                <hr style="border-top: 1px solid #ccc; margin: 10px 0;">
                                <div class="field-group" data-field="cancelHoursFIT"><input type="checkbox" class="vendor-field-selector" data-field-name="cancelHoursFIT"><span class="data-label">Cancel Hours (FIT):</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                <div class="field-group" data-field="cancelHoursGroup"><input type="checkbox" class="vendor-field-selector" data-field-name="cancelHoursGroup"><span class="data-label">Cancel Hours (Group):</span><div class="data-values"><span class="suggested-value"></span><span class="original-value"></span></div></div>
                                 <hr style="border-top: 1px solid #ccc; margin: 10px 0;">
                                <div class="field-group" data-field="openingHours"><input type="checkbox" class="vendor-field-selector" data-field-name="openingHours"><span class="data-label">Opening Hours:</span><div class="data-values"><div class="suggested-value" style="white-space: pre-wrap;"></div><span class="original-value"></span></div></div>
                                <hr style="border-top: 1px solid #ccc; margin: 10px 0;">
                                <div class="field-group" data-field="description"><input type="checkbox" class="vendor-field-selector" data-field-name="description"><span class="data-label">Description:</span><div class="data-values"><div class="suggested-value" style="white-space: pre-wrap;"></div><span class="original-value"></span></div></div>
                            </div>
        
                            <!-- Products Table Section -->
                            <div class="data-section">
                                <h2>Products (Select rows to update/create)</h2>
                                <table id="products-table">
                                    <thead>
                                        <tr>
                                            <th class="select-col"><input type="checkbox" class="product-selector-all" title="Select/Deselect All Products" onclick="toggleAllRowCheckboxes(this, 'product-selector')"></th>
                                            <th>Prod ID</th>
                                            <th>Name</th>
                                            <th>Category</th>
                                            <th>City</th>
                                            <th>Country</th>
                                            <!--<th>Active</th>-->
                                            <th>Unit Price</th>
                                            <th>Child Price</th>
                                            <th>Infant Price</th>
                                            <th>Family Price</th>
                                            <th>Child Age</th>
                                            <!--<th>Featured</th>-->
                                            <!--<th>Preferred</th>-->
                                            <th>Duration</th>
                                        </tr>
                                    </thead>
                                    <tbody id="products-table-body">
                                        <tr><td colspan="11" style="text-align: center;">Loading...</td></tr> <!-- Adjusted colspan -->
                                    </tbody>
                                </table>
                            </div>
        
                            <!-- Price Books Table Section (HTML Structure Added) -->
                            <div class="data-section">
                                <h2>Price Books (Select suggested rows to apply)</h2>
                                <p style="font-size: 0.9em; color: #555;">These are suggestions based on the contract. Select rows to create new or update existing price book entries.</p>
                                <table id="pricebooks-table">
                                    <thead>
                                        <tr>
                                            <th class="select-col"><input type="checkbox" class="pricebook-selector-all" title="Select/Deselect All Price Books" onclick="toggleAllRowCheckboxes(this, 'pricebook-selector')"></th>
                                            <!-- Headers match keys in correctedPriceBooks value objects -->
                                            <th>Key / ID</th> <!-- Show original key (auto_id or new_*) -->
                                            <th>Product ID</th>
                                            <th>Name</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Unit Price</th>
                                            <th>Child Price</th>
                                            <th>Infant Price</th>
                                            <th>Currency</th>
                                            <!--<th>Active</th>-->
                                            <th>Day Of Week</th>
                                            <!-- Add other relevant pricebook fields here if needed (e.g., sharing_price) -->
                                        </tr>
                                    </thead>
                                    <tbody id="pricebooks-table-body">
                                         <!-- Placeholder updated, JS will replace this -->
                                         <tr><td colspan="12" style="text-align: center;">Loading price book suggestions...</td></tr>
                                    </tbody>
                                </table>
                            </div>
                            <!-- END Price Books Table Section -->
        
                        </div> <!-- End scrollable content -->
        
                        <!-- Footer with Apply Button (Sticky Footer for Page 2) -->
                        <div id="apply-changes-footer">
                           <button type="button" id="apply-selected-changes-btn" onclick="applySelectedChanges()" disabled>Apply Selected Changes</button>
                        </div>
        
                    </div> <!-- End Page 2 -->
                </div> <!-- End Modal Content Area -->
            </div> <!-- End Modal Content Box -->
        </div> <!-- End Modal Background -->
        <!-- TAI CODE END: Compare Modal HTML -->
        
        <!-- TAI CODE START: Compare Modal JS -->
        <script>
            // --- Global Variables ---
            var isTaiCompareModalOpen = false;
            var originalDbData = null;       // Stores { vendor: {}, products: [], pricebooks: {} } fetched from DB
            var suggestedAiData = null;      // Stores { vendor: {}, products: [], pricebooks: {} } suggested by AI
            var currentContractAutoId = null;
        
            /**
             * Opens the modal, resets UI, fetches status/results for the specific contract.
             * @param {number|string} contract_auto_id - The auto_id from tdu_vendors_contracts.
             */
            function openTaiCompareModal(contract_auto_id) {
                // Get references to modal elements
                var modal = document.getElementById("taiCompareModal");
                var page1Div = document.getElementById("taiComparePage1");
                var page2Div = document.getElementById("taiComparePage2");
                var loadingOverlay = document.getElementById("taiCompareLoadingOverlay");
                var loadingText = document.getElementById("taiCompareLoadingText");
                var page1NavBtn = document.getElementById("taiCompareNavBtn1");
                var page2NavBtn = document.getElementById("taiCompareNavBtn2");
                var applyBtn = document.getElementById("apply-selected-changes-btn");
                var regenBtn = document.getElementById("taiRegenerateBtn");
        
                // Basic check for element existence
                if (!modal || !page1Div || !page2Div || !loadingOverlay || !loadingText || !page1NavBtn || !page2NavBtn || !applyBtn || !regenBtn) { console.error("Modal elements missing!"); alert("Error: Modal components missing."); return; }
        
                currentContractAutoId = contract_auto_id; // Store the ID for later use
        
                // --- Reset UI & State ---
                modal.style.display = "flex"; // Show modal using flex display
                isTaiCompareModalOpen = true;
                document.addEventListener('keydown', handleTaiModalKeyDown); // Add Escape key listener
                originalDbData = null; suggestedAiData = null; // Clear previous data
                page1Div.innerHTML = '<p>Fetching data...</p>'; // Clear previous report on Page 1
                clearPage2Content();     // Clear previous comparison data on Page 2
                showTaiComparePage('taiComparePage1'); // Default view to Page 1
                page1NavBtn.classList.add('active-nav'); // Style Page 1 nav button as active
                page2NavBtn.disabled = true; page2NavBtn.classList.remove('active-nav'); // Disable Page 2 nav
                applyBtn.disabled = true;    // Disable Apply button initially
                regenBtn.disabled = true;   // Disable Regenerate button initially
        
                // Show loading indicator overlay
                loadingText.textContent = 'Fetching comparison status...';
                loadingOverlay.style.display = 'flex'; // Show loading overlay
        
                // --- Fetch Status and Results via AJAX ---
                var xhrFetchStatus = new XMLHttpRequest();
                var ajaxUrl = "ContractCompare/ajax_get_comparison_status_and_results.php"; // Endpoint to get status/results
                xhrFetchStatus.open("POST", ajaxUrl, true);
                xhrFetchStatus.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        
                xhrFetchStatus.onload = function () {
                    if (xhrFetchStatus.status >= 200 && xhrFetchStatus.status < 300) {
                        try {
                            var responseData = JSON.parse(xhrFetchStatus.responseText);
                            console.log("Status/Result Response:", responseData); // Log response for debugging
        
                            // Handle response based on job status from backend
                            switch (responseData.status) {
                                case 'DONE':
                                    loadingOverlay.style.display = 'none'; // Hide loading overlay
                                    // Display the HTML report from AI
                                    page1Div.innerHTML = responseData.reportHtml || '<p>Comparison complete, but no HTML report provided.</p>';
        
                                    // Store original DB data and AI suggestions separately
                                    originalDbData = responseData.currentDbData || { vendor: null, products: [], pricebooks: {} };
                                    suggestedAiData = responseData.suggestedAiData || { vendor: {}, products: [], pricebooks: {} };
        
                                    // Populate Page 2 with comparison data
                                    fillPage2(originalDbData, suggestedAiData);
        
                                    // Enable navigation and action buttons
                                    page2NavBtn.disabled = false;
                                    // Enable Apply button only if there are actual suggestions to apply
                                     applyBtn.disabled = !(
                                        (suggestedAiData.vendor && Object.keys(suggestedAiData.vendor).length > 0 && !(Object.keys(suggestedAiData.vendor).length === 1 && 'vendorid' in suggestedAiData.vendor)) || // Vendor changes beyond just ID
                                        (suggestedAiData.products && suggestedAiData.products.length > 0) || // Product suggestions exist
                                        (suggestedAiData.pricebooks && Object.keys(suggestedAiData.pricebooks).length > 0) // Pricebook suggestions exist
                                    );
                                    regenBtn.disabled = false;
                                    break;
                                case 'PENDING':
                                    loadingText.textContent = 'Comparison is PENDING. The system will process it soon. Please check back later.';
                                    page1Div.innerHTML = '<p>Status: PENDING</p>';
                                    // Keep loading overlay visible for PENDING status
                                    regenBtn.disabled = false; // Allow regenerating a pending job
                                    break;
                                case 'PROCESSING':
                                    loadingText.textContent = 'Comparison is PROCESSING. Please wait...';
                                    page1Div.innerHTML = '<p>Status: PROCESSING</p>';
                                    // Keep loading overlay visible for PROCESSING status
                                    // All actions should be disabled while processing
                                    break;
                                case 'ERROR':
                                    loadingOverlay.style.display = 'none'; // Hide loading overlay
                                    const errorMsg = responseData.message || 'An unknown error occurred during comparison.';
                                    page1Div.innerHTML = `<p style='color:red; font-weight:bold;'>Error:</p><p style='color:red;'>${escapeHtml(errorMsg)}</p>`;
                                    regenBtn.disabled = false; // Allow regenerating after error
                                    break;
                                default: // Unexpected status
                                    loadingOverlay.style.display = 'none';
                                    page1Div.innerHTML = `<p style='color:orange;'>Received unexpected status: ${escapeHtml(responseData.status || 'Unknown')}</p>`;
                                    console.warn("Unexpected status received:", responseData);
                                    regenBtn.disabled = false; // Allow regenerate maybe?
                            }
                        } catch (e) {
                            // Handle JSON parsing errors
                            loadingOverlay.style.display = 'none';
                            page1Div.innerHTML = "<p style='color:red;'>Error processing server response.</p>";
                            console.error("JSON Parse Error:", e, xhrFetchStatus.responseText);
                            regenBtn.disabled = false; // Allow regenerate on parse error
                        }
                    } else {
                        // Handle HTTP errors (e.g., 404, 500)
                        loadingOverlay.style.display = 'none';
                        page1Div.innerHTML = `<p style='color:red;'>Error loading status (HTTP: ${xhrFetchStatus.status}).</p>`;
                        console.error("HTTP Error:", xhrFetchStatus.status, xhrFetchStatus.statusText);
                        regenBtn.disabled = false; // Allow regenerate on HTTP error
                    }
                }; // end onload
        
                xhrFetchStatus.onerror = function () {
                    // Handle network errors
                    loadingOverlay.style.display = 'none';
                    page1Div.innerHTML = "<p style='color:red;'>Network error occurred.</p>";
                    console.error("Network error");
                    regenBtn.disabled = false; // Allow regenerate on network error
                };
        
                // Send the request with the contract ID
                console.log("Fetching status/results for contract_auto_id:", contract_auto_id);
                xhrFetchStatus.send("contract_id=" + contract_auto_id);
            }
        
            /** Clears Page 2 content to default/empty state. */
            function clearPage2Content(){
                // Clear vendor fields
                document.querySelectorAll('#taiComparePage2 .vendor-section .field-group').forEach(group => {
                    const checkbox = group.querySelector('.vendor-field-selector');
                    const valuesDiv = group.querySelector('.data-values');
                    const suggestedSpan = valuesDiv?.querySelector('.suggested-value');
                    const originalSpan = valuesDiv?.querySelector('.original-value');
                    const link = valuesDiv?.querySelector('a.suggested-link');
                    if(suggestedSpan) suggestedSpan.textContent = '';
                    if(originalSpan) originalSpan.textContent = '';
                    if(link) link.href = '#';
                    if(checkbox) { checkbox.checked = false; checkbox.dataset.suggestedValue = 'null'; checkbox.disabled = (checkbox.dataset.fieldName === 'vendorid'); } // Keep vendorid disabled
                    if(valuesDiv) valuesDiv.classList.remove('value-mismatch');
                });
        
                // Clear products table
                const productsTbody = document.getElementById('products-table-body');
                if (productsTbody) productsTbody.innerHTML = `<tr><td colspan="11" style="text-align: center;">No product data loaded.</td></tr>`; // Adjust colspan
                const prodSelectAll = document.querySelector('#products-table thead input.product-selector-all'); // Use specific class
                if (prodSelectAll) prodSelectAll.checked = false;
        
                // Clear pricebooks table
                const pricebooksTbody = document.getElementById('pricebooks-table-body');
                 if (pricebooksTbody) pricebooksTbody.innerHTML = `<tr><td colspan="12" style="text-align: center;">No price book suggestions loaded.</td></tr>`; // Adjusted colspan
                const pbSelectAll = document.querySelector('#pricebooks-table thead input.pricebook-selector-all'); // Use specific class
                if (pbSelectAll) pbSelectAll.checked = false;
        
                // Disable apply button
                const applyBtn = document.getElementById("apply-selected-changes-btn");
                if(applyBtn) applyBtn.disabled = true;
            }
        
            /** Fills Page 2 with comparison view based on DONE status data. */
            function fillPage2(originalData, suggestedData) {
                console.log("Populating Page 2 with data. Original:", originalData, "Suggested:", suggestedData);
                if (!originalData || !suggestedData) { console.error("Missing data for fillPage2"); clearPage2Content(); return; }
        
                // --- Data Preparation ---
                // Use empty objects/arrays as fallback for robustness
                const currentVendor = originalData?.vendor || {};
                const currentProducts = originalData?.products || [];
                const currentPricebooks = originalData?.pricebooks || {}; // Is an object keyed by auto_id string
        
                const proposedVendor = suggestedData?.vendor || {};
                const proposedProducts = suggestedData?.products || [];
                const proposedPricebooks = suggestedData?.pricebooks || {}; // Is an object keyed by auto_id or new_* string
        
                // --- Helpers ---
                // Safely gets a value from an object
                const getSimpleValue = (obj, key) => (obj && typeof obj === 'object' && key in obj) ? obj[key] : undefined;
                // Normalizes values for comparison (handles null, boolean, numbers, strings)
                const normalizeForCompare = (val) => { if (val === null || val === undefined) return ''; if (typeof val === 'boolean') return val ? 'true' : 'false'; if(typeof val === 'number') return String(val); return String(val).trim(); };
                // Formats values for display (handles null, boolean, converts others to string)
                const formatDisplay = (val) => { if (val === null || val === undefined || val === '') return 'N/A'; if (typeof val === 'boolean') return val ? 'Yes' : 'No'; return String(val); };
                // Compares current and proposed values, returns display info
                const getValue = (currentObj, proposedObj, key) => {
                     let ov = getSimpleValue(currentObj, key); // Original Value
                     let pv = getSimpleValue(proposedObj, key); // Proposed Value
                     let isSuggestionPresent = (pv !== undefined); // Check if AI provided *any* value (even null)
                     let displayVal = isSuggestionPresent ? pv : ov; // Show proposed if present, else current
                     let originalVal = ov;
                     let compO = normalizeForCompare(ov);
                     let compP = normalizeForCompare(pv);
                     // Different if suggestion exists AND normalized values are different
                     let isDifferent = isSuggestionPresent && (compO !== compP);
                     return {
                         display: formatDisplay(displayVal),         // Formatted value to show
                         originalFormatted: formatDisplay(originalVal), // Formatted original value
                         isDifferent: isDifferent,                 // Boolean flag for mismatch
                         suggestedRaw: pv                         // Raw proposed value (for storing in checkbox)
                     };
                 };
        
        
                // --- 1. Fill Vendor Section ---
                document.querySelectorAll('#taiComparePage2 .vendor-section .field-group').forEach(group => {
                    const checkbox = group.querySelector('.vendor-field-selector');
                    const valuesDiv = group.querySelector('.data-values');
                    const suggestedSpan = valuesDiv?.querySelector('.suggested-value');
                    const originalSpan = valuesDiv?.querySelector('.original-value');
                    if (!checkbox || !valuesDiv || !suggestedSpan || !originalSpan) return;
        
                    const fieldName = checkbox.dataset.fieldName; if (!fieldName) return;
                    const result = getValue(currentVendor, proposedVendor, fieldName);
        
                    // Specific display logic (HTML for description/hours, links for website)
                    if (fieldName === 'description' || fieldName === 'openingHours') {
                        suggestedSpan.innerHTML = result.display === 'N/A' ? 'N/A' : result.display.replace(/\n/g, '<br>'); // Handle newlines
                    } else if (fieldName === 'website') {
                        const linkElement = suggestedSpan.closest('a');
                        if (linkElement) {
                            const url = result.suggestedRaw ?? currentVendor?.website; // Use raw suggested or current for link target
                            const displayUrl = url || 'N/A';
                            linkElement.href = url && url !== 'N/A' && String(url).trim() !== '' ? (String(url).startsWith('http') ? url : '//' + url) : '#'; // Create valid link or #
                            suggestedSpan.textContent = displayUrl; // Display the URL text
                            linkElement.style.pointerEvents = (linkElement.href === '#') ? 'none' : 'auto'; // Disable click if no valid URL
                            linkElement.style.opacity = (linkElement.href === '#') ? '0.6' : '1';
                        }
                    } else {
                        suggestedSpan.textContent = result.display; // Default: display formatted text
                    }
        
                    // Show current value for comparison
                    originalSpan.textContent = `(Current: ${result.originalFormatted})`;
                    valuesDiv.classList.toggle('value-mismatch', result.isDifferent); // Add class if different
        
                    // Store raw suggested value and manage checkbox state
                    checkbox.dataset.suggestedValue = JSON.stringify(result.suggestedRaw); // Store raw value
                    checkbox.checked = false; // Uncheck initially
                    // Disable checkbox if it's the vendor ID OR if AI didn't suggest a value for this field
                    checkbox.disabled = (fieldName === 'vendorid' || result.suggestedRaw === undefined);
                });
        
        
               // --- 2. Fill Product Table ---
                const productsTableBody = document.getElementById('products-table-body');
                if (productsTableBody) {
                    productsTableBody.innerHTML = ''; // Clear loading/previous
                    const productsTable = productsTableBody.closest('table');
                    const selectAllProdCheckbox = productsTable?.querySelector('thead input.product-selector-all');
                    if (selectAllProdCheckbox) selectAllProdCheckbox.checked = false;
        
                    const currentProductsMap = new Map(currentProducts.map(p => [String(p.productid), p]));
                    const productIdsProcessed = new Set();
                    const combinedProducts = [];
        
                    // Add all proposed products (AI might suggest new ones with null ID)
                     (proposedProducts || []).forEach(p => {
                        const id = p?.productid;
                        combinedProducts.push({ proposed: p, current: currentProductsMap.get(String(id)) });
                        if (id !== null && id !== undefined) productIdsProcessed.add(String(id));
                     });
                     // Add current products that were NOT suggested by AI
                     currentProducts.forEach(p => {
                         const idStr = String(p.productid);
                         if (!productIdsProcessed.has(idStr)) {
                             combinedProducts.push({ proposed: undefined, current: p }); // Mark as no AI suggestion
                             productIdsProcessed.add(idStr);
                         }
                     });
        
                    if (combinedProducts.length === 0) { productsTableBody.innerHTML = `<tr><td colspan="11" style="text-align: center;">No product data available or suggested.</td></tr>`; }
                    else {
                        combinedProducts.forEach(item => {
                            const currentProduct = item.current;
                            const proposedProduct = item.proposed;
                            // A product is "new" if AI proposed it AND it has no current counterpart OR AI gave it a null productid
                            const isNew = proposedProduct && (!currentProduct || proposedProduct.productid === null);
                            // Determine the ID for the row (use current if exists, else proposed ID which might be null)
                             const rowProductId = currentProduct?.productid ?? proposedProduct?.productid;
                             const displayProductId = formatDisplay(rowProductId);
        
                            // Data for checkbox: Use the proposed data if it exists, otherwise current. Ensure correct ID.
                             const checkboxData = proposedProduct ? { ...proposedProduct } : { ...(currentProduct || {}) };
                             if(rowProductId !== null && rowProductId !== undefined) checkboxData.productid = rowProductId;
        
                            const row = productsTableBody.insertRow();
                            if (isNew) row.classList.add('new-row-highlight');
        
                            // Checkbox cell
                            const selectCell = row.insertCell(); selectCell.className = 'select-col';
                            const checkboxDataString = JSON.stringify(checkboxData).replace(/'/g, '&apos').replace(/"/g, '"'); // Escaped data
                            // Disable checkbox if no suggestion exists for this product
                            const checkboxDisabled = !proposedProduct;
                            selectCell.innerHTML = `<input type="checkbox" class="product-selector" data-product-id="${rowProductId ?? 'new'}" data-product-data='${checkboxDataString}' ${checkboxDisabled ? 'disabled' : ''}>`;
        
                            // Helper to add table cells for products
                            const addProdCell = (dbKey, formatAs = 'text') => {
                                 const cell = row.insertCell();
                                 const result = getValue(currentProduct, proposedProduct, dbKey); // Compare current vs proposed
                                 let displayHtml = '';
                                 let suggestedDisplayFormatted = result.display; // Use pre-formatted display value
        
                                 // Apply specific formatting overrides if needed (e.g., bool as 0/1)
                                 if (formatAs === 'bool_int') { // e.g., featured, preferred (INT 0/1)
                                      suggestedDisplayFormatted = (result.suggestedRaw == 1) ? '1' : '0';
                                      if(result.suggestedRaw === undefined && currentProduct) suggestedDisplayFormatted = (currentProduct[dbKey] == 1) ? '1' : '0'; // Fallback display
                                      result.originalFormatted = (currentProduct?.[dbKey] == 1) ? '1' : '0';
                                 }
                                  // Add other formatAs cases if needed (e.g., currency formatting)
        
                                 // Build cell content: Display formatted value + original if different/new/no suggestion
                                 displayHtml = `<span class="suggested-value">${suggestedDisplayFormatted}</span>`;
                                 if (isNew) {
                                     displayHtml += `<br><small class="original-value">(New Entry Suggestion)</small>`;
                                 } else if (result.isDifferent) {
                                     displayHtml += `<br><small class="original-value">(Current: ${result.originalFormatted})</small>`;
                                     cell.classList.add('value-mismatch');
                                 } else if (!proposedProduct) { // Existing product, no changes suggested by AI
                                     displayHtml += `<br><small class="original-value">(No AI Suggestion)</small>`;
                                     cell.style.opacity = '0.7'; // Dim cell slightly
                                 }
                                 cell.innerHTML = displayHtml;
                             };
        
                            // Add product data cells
                            addProdCell('productid'); 
                            addProdCell('productName'); 
                            addProdCell('category'); 
                            addProdCell('city');
                            addProdCell('country');
                            //addProdCell('productActive', 'bool_yes_no'); 
                            addProdCell('unitPrice', 'price'); 
                            addProdCell('childPrice', 'price');
                            addProdCell('infantPrice', 'price');
                            addProdCell('familyPrice', 'price');
                            addProdCell('childAge');
                            //addProdCell('featured', 'bool_int'); 
                            //addProdCell('preferred', 'bool_int'); 
                            addProdCell('duration');
                        });
                    }
                } else { console.error("Products table body not found."); }
        
        
                // --- 3. Fill Price Book Table ---
                const pricebooksTableBody = document.getElementById('pricebooks-table-body');
                if (pricebooksTableBody) {
                    pricebooksTableBody.innerHTML = ''; // Clear loading/previous
                    const pricebooksTable = pricebooksTableBody.closest('table');
                    const selectAllPbCheckbox = pricebooksTable?.querySelector('thead input.pricebook-selector-all');
                    if (selectAllPbCheckbox) selectAllPbCheckbox.checked = false;
        
                    const suggestedKeys = Object.keys(proposedPricebooks); // Get keys from AI suggestions object
        
                    if (suggestedKeys.length === 0) {
                        pricebooksTableBody.innerHTML = `<tr><td colspan="12" style="text-align: center;">No price book suggestions provided by AI.</td></tr>`; // Adjusted colspan
                    } else {
                        suggestedKeys.forEach(key => {
                            const proposedPb = proposedPricebooks[key]; // The suggested pricebook object
                            if (!proposedPb || typeof proposedPb !== 'object') { console.warn("Skipping invalid pricebook suggestion for key:", key); return; }
        
                            const isNew = key.startsWith('new_'); // Check if it's a new suggestion
                            // Get the current pricebook data if this key represents an existing auto_id
                            const currentPb = !isNew ? (currentPricebooks[key] || null) : null;
        
                            const row = pricebooksTableBody.insertRow();
                            if (isNew) row.classList.add('new-row-highlight'); // Highlight new suggestions
        
                            // Checkbox cell: always enabled for suggestions
                            const selectCell = row.insertCell(); selectCell.className = 'select-col';
                            const pbCheckboxDataString = JSON.stringify(proposedPb).replace(/'/g, '&apos').replace(/"/g, '"'); // Store data, escape quotes
                            selectCell.innerHTML = `<input type="checkbox" class="pricebook-selector" data-pricebook-key="${key}" data-pricebook-data='${pbCheckboxDataString}'>`;
        
                            // Helper to add table cells for pricebooks
                            const addPbCell = (dbKey, formatAs = 'text', isKeyCol = false) => {
                                 const cell = row.insertCell();
                                 // Special handling for the first column to show the comparison key
                                 if (isKeyCol) {
                                     cell.innerHTML = `<span class="suggested-value">${escapeHtml(key)}</span>`; // Display the key (e.g., "32" or "new_123_1")
                                     if (isNew) {
                                          cell.innerHTML += `<br><small class="original-value">(New Suggestion)</small>`;
                                     } else {
                                          cell.innerHTML += `<br><small class="original-value">(Existing ID)</small>`;
                                     }
                                     return;
                                 }
        
                                 // Use getValue helper to compare current vs proposed
                                 const result = getValue(currentPb, proposedPb, dbKey);
                                 let displayHtml = '';
                                 let suggestedDisplayFormatted = result.display; // Already formatted
        
                                 // Specific formatting for pricebook fields
                                  if (formatAs === 'bool_yes_no') { // e.g., active (TINYINT(1) -> Yes/No)
                                      // Assuming AI sends true/false
                                      suggestedDisplayFormatted = formatDisplay(result.suggestedRaw === true || String(result.suggestedRaw).toLowerCase() === 'true');
                                      result.originalFormatted = formatDisplay(currentPb?.[dbKey] === true || String(currentPb?.[dbKey]).toLowerCase() === 'true' || currentPb?.[dbKey] == 1); // Handle DB 1/0 too
                                  } else if (formatAs === 'price') {
                                       // Optionally format as currency e.g., `$${suggestedDisplayFormatted}` if needed
                                  } else if (formatAs === 'date') {
                                       // Format date if needed, though YYYY-MM-DD is usually fine
                                  }
        
                                 // Build cell content: Display suggested value + original if different/existing
                                 displayHtml = `<span class="suggested-value">${suggestedDisplayFormatted}</span>`;
                                 if (!isNew) { // Only show original comparison for existing entries
                                     if (result.isDifferent) {
                                         displayHtml += `<br><small class="original-value">(Current: ${result.originalFormatted})</small>`;
                                         cell.classList.add('value-mismatch');
                                     }
                                     // Optionally indicate if it matches current:
                                     // else { displayHtml += `<br><small style="color: green;">(Matches Current)</small>`; }
                                 }
                                 cell.innerHTML = displayHtml;
                             };
        
                            // Add pricebook data cells based on thead order
                            addPbCell('key', 'text', true); // Special column for the key
                            addPbCell('productid');
                            addPbCell('name');
                            addPbCell('start_date', 'date');
                            addPbCell('end_date', 'date');
                            addPbCell('unit_price', 'price');
                            addPbCell('child_price', 'price');
                            addPbCell('infant_price', 'price');
                            addPbCell('currency');
                            //addPbCell('active', 'bool_yes_no');
                            addPbCell('dayOfWeek');
                            // Add calls for other pricebook columns if present (sharing_price, etc.)
                        });
                    }
                } else { console.error("Pricebooks table body not found."); }
        
                console.log("Page 2 population complete.");
            } // End fillPage2
        
        
            /** Handles switching between Page 1 (Report) and Page 2 (Select Changes) */
            function showTaiComparePage(pageIdToShow) {
                var page1 = document.getElementById("taiComparePage1");
                var page2 = document.getElementById("taiComparePage2");
                var btn1 = document.getElementById("taiCompareNavBtn1");
                var btn2 = document.getElementById("taiCompareNavBtn2");
                // Hide both pages first
                if(page1) page1.style.display = "none";
                if(page2) page2.style.display = "none";
                // Deactivate both nav buttons
                if(btn1) btn1.classList.remove('active-nav');
                if(btn2) btn2.classList.remove('active-nav');
                // Show the selected page
                var pageElement = document.getElementById(pageIdToShow);
                if (pageElement) {
                    // Use 'flex' for page 2 because it uses flexbox layout for the sticky footer
                    pageElement.style.display = (pageIdToShow === 'taiComparePage2') ? "flex" : "block";
                    // Activate the corresponding nav button if it's not disabled
                    var btn = (pageIdToShow === 'taiComparePage1') ? btn1 : btn2;
                    if (btn && !btn.disabled) btn.classList.add('active-nav');
                }
            }
        
            /** Toggles all enabled checkboxes within a specific table body */
            function toggleAllRowCheckboxes(selectAllCheckbox, rowCheckboxClass) {
                const tableBody = selectAllCheckbox.closest('table')?.querySelector('tbody');
                if (tableBody) {
                     // Only toggle checkboxes that are NOT disabled
                    tableBody.querySelectorAll(`input[type="checkbox"].${rowCheckboxClass}:not(:disabled)`).forEach(checkbox => {
                         checkbox.checked = selectAllCheckbox.checked;
                     });
                }
            }
        
            /** Collects selected changes from Page 2 and sends them to the backend */
            function applySelectedChanges() {
                // Initialize payload structure
                const selectedUpdates = { vendor: {}, products: [], pricebooks: [] };
                let vendorUpdatesExist = false, productUpdatesExist = false, pricebookUpdatesExist = false;
                let baseVendorId = null;
        
                // Get Vendor ID robustly
                baseVendorId = originalDbData?.vendor?.vendorid;
                if (!baseVendorId) {
                     // Fallback: Try getting it from the (disabled) vendor ID field's data attribute
                    try {
                        const vendorIdCheckbox = document.querySelector('#taiComparePage2 .field-group[data-field="vendorid"] input.vendor-field-selector');
                        if (vendorIdCheckbox && vendorIdCheckbox.dataset.suggestedValue && vendorIdCheckbox.dataset.suggestedValue !== 'null') {
                            baseVendorId = JSON.parse(vendorIdCheckbox.dataset.suggestedValue);
                        }
                    } catch(e){ console.error("Error parsing fallback vendorid", e); }
                }
                baseVendorId = parseInt(String(baseVendorId), 10); // Ensure it's an integer
                if (isNaN(baseVendorId) || baseVendorId <= 0) {
                    alert("Critical Error: Could not determine a valid Vendor ID. Cannot apply changes.");
                    console.error("Failed to determine baseVendorId. Original:", originalDbData?.vendor?.vendorid);
                    return;
                }
                selectedUpdates.vendor['vendorid'] = baseVendorId; // Always include base vendorid for context
        
                // Collect selected vendor fields (enabled and checked)
                document.querySelectorAll('#taiComparePage2 .vendor-field-selector:checked:not(:disabled)').forEach(checkbox => {
                    const fieldName = checkbox.dataset.fieldName; if (!fieldName || fieldName === 'vendorid') return;
                    try { selectedUpdates.vendor[fieldName] = JSON.parse(checkbox.dataset.suggestedValue ?? 'null'); vendorUpdatesExist = true; }
                    catch (e) { console.error(`Error parsing vendor field '${fieldName}':`, e); }
                });
                // Remove vendor key if only vendorid is present
                if (Object.keys(selectedUpdates.vendor).length <= 1) { delete selectedUpdates.vendor; vendorUpdatesExist = false;}
        
                // Collect selected product rows (enabled and checked)
                document.querySelectorAll('#products-table-body .product-selector:checked:not(:disabled)').forEach(checkbox => {
                    const productDataString = checkbox.dataset.productData;
                    if (!productDataString) { console.warn("Skipping product row: missing data attribute."); return; }
                    try {
                        // Parse the data first
                        const productData = JSON.parse(productDataString.replace(/'/g, "'").replace(/"/g, '"'));
        
                        // *** CORRECTED LOGIC: Add vendorid if it's a new product ***
                        if ((productData.productid === null || productData.productid === 'new') && !productData.vendorid) {
                            if (baseVendorId) {
                                productData.vendorid = baseVendorId; // Assign the determined base vendor ID
                                console.log(`Added baseVendorId (${baseVendorId}) to new product data:`, productData);
                            } else {
                                // This case should ideally not happen if baseVendorId check above passed
                                console.error("Cannot add new product - baseVendorId is missing when processing products!");
                                alert("Error: Cannot process new product suggestion because the vendor ID could not be determined.");
                                return; // Stop processing this specific checkbox
                            }
                        }
                        // *** END CORRECTION ***
        
                        selectedUpdates.products.push(productData); // Push the (potentially modified) product data
                        productUpdatesExist = true;
                    } catch (e) {
                        console.error(`Error parsing product data:`, productDataString, e);
                        alert("Error processing selected product data. Check console for details.");
                    }
                });
        
        
                // Collect selected pricebook rows (enabled and checked)
                document.querySelectorAll('#pricebooks-table-body .pricebook-selector:checked:not(:disabled)').forEach(checkbox => {
                    const pricebookKey = checkbox.dataset.pricebookKey; // The original key (e.g., "32" or "new_123_1")
                    const pricebookDataString = checkbox.dataset.pricebookData;
                    if (!pricebookKey || !pricebookDataString) { console.warn("Skipping selected pricebook row: missing key/data."); return; }
                    try {
                         const decodedString = pricebookDataString.replace(/'/g, "'").replace(/"/g, '"'); // Decode
                         const pricebookData = JSON.parse(decodedString);
                         // Add the original key so the backend knows if it's an INSERT or UPDATE
                         pricebookData._comparison_key = pricebookKey;
                         selectedUpdates.pricebooks.push(pricebookData);
                         pricebookUpdatesExist = true;
                     } catch (e) { console.error(`Error parsing pricebook data for key '${pricebookKey}':`, e); alert(`Error processing pricebook: ${pricebookKey}`); }
                });
        
                // --- Check if any updates were selected ---
                const anyUpdatesSelected = vendorUpdatesExist || productUpdatesExist || pricebookUpdatesExist; // Include pricebook check
                if (!anyUpdatesSelected) { alert("No changes selected to apply."); return; }
        
                // Clean up empty sections before sending
                if (!vendorUpdatesExist) delete selectedUpdates.vendor;
                if (!productUpdatesExist) delete selectedUpdates.products;
                if (!pricebookUpdatesExist) delete selectedUpdates.pricebooks; // Remove pricebooks array if empty
        
                console.log("Sending selected changes:", JSON.stringify(selectedUpdates)); // Log the final payload
                showUpdateLoadingIndicator(true); // Show loading on button
        
                // --- AJAX Call to Apply Updates ---
                const ajaxEndpoint = 'ContractCompare/ajax_apply_selected_updates_for_contracts.php'; // Backend must handle pricebooks now
                const formData = new FormData();
                formData.append('updates', JSON.stringify(selectedUpdates)); // Send all selected updates
                formData.append('contract_auto_id', currentContractAutoId); // Send contract ID for context/reset
        
                fetch(ajaxEndpoint, { method: 'POST', body: formData })
                    .then(response => { // Improved error handling for non-JSON responses
                         if (!response.ok) { return response.text().then(text => { throw new Error(`HTTP error ${response.status}: ${text}`); }); }
                         // Check content type before parsing JSON
                         const contentType = response.headers.get("content-type");
                         if (contentType && contentType.indexOf("application/json") !== -1) {
                             return response.json();
                         } else {
                             return response.text().then(text => { throw new Error(`Expected JSON response but received ${contentType}: ${text}`); });
                         }
                     })
                    .then(data => { // Handle backend response
                        console.log("Update response received:", data);
                        showUpdateLoadingIndicator(false);
                        // Process response message (handle potential arrays/objects)
                        let message = '';
                        if (typeof data.message === 'string') {
                             message = data.message;
                        } else if (data.message) { // Handle cases where message might be object/array unexpectedly
                            message = JSON.stringify(data.message);
                        } else {
                            message = (data.status === 'success' ? 'Updates applied.' : 'An unknown issue occurred.');
                        }
        
                        if (data.warnings?.length > 0) message += "\n\nWarnings:\n- " + data.warnings.join("\n- ");
                        if (data.errors?.length > 0) message += "\n\nErrors:\n- " + data.errors.join("\n- ");
        
                        alert(message); // Display combined message
        
                        if (data.status === 'success' || data.status === 'warning') {
                            closeTaiCompareModal(); // Close modal on success/warning
                            location.reload(); // Force refresh the main page data
                        } else { // Handle specific errors from backend
                            console.error("Update failed:", data);
                        }
                    })
                    .catch(error => { // Handle network/fetch/parse errors
                        showUpdateLoadingIndicator(false);
                        console.error('Error during apply/update operation:', error);
                        alert('An error occurred while applying updates.\nPlease check the browser console for details.\n\nError: ' + error.message);
                    });
            }
        
             /** Resets the comparison job to PENDING via AJAX */
            function regenerateComparison() {
                if (!currentContractAutoId) { alert("Error: Cannot regenerate, contract ID is missing."); return; }
                if (!confirm("Are you sure you want to regenerate this comparison?\nThe current results will be cleared and the job will be re-queued.")) { return; }
        
                // Get UI elements
                var loadingOverlay = document.getElementById("taiCompareLoadingOverlay");
                var loadingText = document.getElementById("taiCompareLoadingText");
                var regenBtn = document.getElementById("taiRegenerateBtn");
                var page1Div = document.getElementById("taiComparePage1");
                var page2NavBtn = document.getElementById("taiCompareNavBtn2");
                var applyBtn = document.getElementById("apply-selected-changes-btn");
        
                // Show loading state and disable controls
                if(loadingText) loadingText.textContent = 'Requesting regeneration...';
                if(loadingOverlay) loadingOverlay.style.display = 'flex';
                if(regenBtn) regenBtn.disabled = true;
                if(page2NavBtn) page2NavBtn.disabled = true;
                if(applyBtn) applyBtn.disabled = true;
                if(page1Div) page1Div.innerHTML = ''; // Clear page 1
                clearPage2Content(); // Also clear page 2
        
                // AJAX call to regenerate endpoint
                var xhrRegen = new XMLHttpRequest();
                var ajaxUrl = "ContractCompare/ajax_regenerate_comparison.php"; // Backend endpoint for regeneration
                xhrRegen.open("POST", ajaxUrl, true);
                xhrRegen.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        
                xhrRegen.onload = function () {
                    let success = false; let message = "An unknown error occurred.";
                    if (xhrRegen.status >= 200 && xhrRegen.status < 300) {
                        try {
                            var responseData = JSON.parse(xhrRegen.responseText);
                            message = responseData.message || (responseData.status === 'success' ? "Job reset to PENDING." : "Failed to reset job.");
                            if (responseData.status === 'success') {
                                success = true;
                                // Update UI to show PENDING status
                                if(loadingText) loadingText.textContent = 'Comparison is PENDING. The system will process it soon.';
                                if(page1Div) page1Div.innerHTML = `<p>${escapeHtml(message)}</p><p>Status: PENDING</p>`;
                                if(loadingOverlay) loadingOverlay.style.display = 'flex'; // Keep overlay shown
                                // Keep most buttons disabled, but re-enable regenerate
                                if(regenBtn) regenBtn.disabled = false;
                            }
                        } catch (e) { message = "Error processing regeneration response."; console.error("Regen JSON Parse Error:", e, xhrRegen.responseText); }
                    } else { message = `Error requesting regeneration (HTTP Status: ${xhrRegen.status})`; console.error("Regen HTTP Error:", xhrRegen.statusText); }
        
                    if (!success) { // Handle regeneration failure
                         if(loadingOverlay) loadingOverlay.style.display = 'none'; // Hide loading on error
                         if(page1Div) page1Div.innerHTML = `<p style='color:red;'>Regeneration Failed:</p><p style='color:red;'>${escapeHtml(message)}</p>`;
                         alert("Regeneration failed: " + message);
                         // Re-enable buttons to allow retry or closing
                         if(regenBtn) regenBtn.disabled = false;
                         // Re-enable page 2 nav/apply buttons as the old data wasn't cleared server-side
                          if(originalDbData && suggestedAiData) { // Re-enable if old data exists
                            if(page2NavBtn) page2NavBtn.disabled = false;
                             const applyBtn = document.getElementById("apply-selected-changes-btn");
                             if (applyBtn) {
                                 applyBtn.disabled = !(
                                     (suggestedAiData.vendor && Object.keys(suggestedAiData.vendor).length > 0 && !(Object.keys(suggestedAiData.vendor).length === 1 && 'vendorid' in suggestedAiData.vendor)) ||
                                     (suggestedAiData.products && suggestedAiData.products.length > 0) ||
                                     (suggestedAiData.pricebooks && Object.keys(suggestedAiData.pricebooks).length > 0)
                                 );
                             }
                          }
                    }
                    // On success, UI already updated to show PENDING
                }; // end onload
        
                xhrRegen.onerror = function () {
                     alert("Network error during regeneration request.");
                     if(loadingOverlay) loadingOverlay.style.display = 'none';
                     if(regenBtn) regenBtn.disabled = false; // Re-enable on network error
                     // Re-enable page 2 nav/apply if applicable
                     if(originalDbData && suggestedAiData) { /* ... re-enable buttons ... */ }
                };
                xhrRegen.send("contract_id=" + currentContractAutoId);
            }
        
        
            /** Closes the modal and cleans up */
            function closeTaiCompareModal() {
                var modal = document.getElementById("taiCompareModal");
                var loadingOverlay = document.getElementById("taiCompareLoadingOverlay");
                if (modal) modal.style.display = "none";
                isTaiCompareModalOpen = false;
                document.removeEventListener('keydown', handleTaiModalKeyDown); // Remove listener
                if (loadingOverlay) loadingOverlay.style.display = 'none'; // Ensure loading is hidden
                // Clear global state
                currentContractAutoId = null;
                originalDbData = null;
                suggestedAiData = null;
                // Optionally reset Page 1 content
                var page1Div = document.getElementById("taiComparePage1");
                if(page1Div) page1Div.innerHTML = '<p>Click "Get Comparison" on the previous page to load data.</p>';
            }
        
            /** Closes modal if overlay background is clicked */
            function handleTaiModalOverlayClick(event) {
                // Close only if the click is directly on the overlay, not its children
                if (event.target.id === "taiCompareModal") {
                    closeTaiCompareModal();
                }
            }
        
            /** Closes modal if Escape key is pressed */
            function handleTaiModalKeyDown(event) {
                if (isTaiCompareModalOpen && event.key === 'Escape') {
                    closeTaiCompareModal();
                }
            }
        
            /** Shows/hides loading state on the Apply button */
            function showUpdateLoadingIndicator(show) {
                const applyButton = document.getElementById('apply-selected-changes-btn');
                if (applyButton) {
                    applyButton.disabled = show;
                    applyButton.textContent = show ? 'Applying...' : 'Apply Selected Changes';
                }
            }
        
            /** Simple HTML escaping function */
            function escapeHtml(unsafe) {
                if (unsafe === null || unsafe === undefined) return '';
                // More robust escaping
                return String(unsafe)
                     .replace(/&/g, "&") // Must be first
                     .replace(/</g, "<")
                     .replace(/>/g, ">")
                     .replace(/"/g, "&quot")
                     .replace(/'/g, "'"); // Use numeric entity for single quote
             }
        
        </script>
        <!-- TAI CODE END: Compare Modal JS -->
    
        <?php
        $sqlContracts = "SELECT auto_id, contractname, DATE(start_time) as start_time, DATE(end_time) as end_time, attachment_path
                        FROM tdu_vendors_contracts
                        WHERE vendorid='$vendor_id'
                        ORDER BY start_time DESC";
        $resultContracts = mysqli_query($conn, $sqlContracts);
    
        if (mysqli_num_rows($resultContracts) > 0) :
            ?>
            <table class="styled-table">
                <tr>
                    <th><button onclick="openContractModal()">+</button></th>
                    <th style="text-align: left;">Contract Name</th>
                    <th style="text-align: left;">Contract Period</th>
                    <th></th> <!-- Column for Compare Button -->
                    <th></th> <!-- Column for Attachment Icon -->
                </tr>
                <?php
                while ($row = mysqli_fetch_assoc($resultContracts)) :
                    ?>
                    <tr id="contract-row-<?php echo $row['auto_id']; ?>">
                        <td><button type="button" onclick="deleteContract(<?php echo $row['auto_id']; ?>)" style="background-color: red; color: white;">Del</button></td>
                        <td style="text-align: left;"><?php echo htmlspecialchars($row['contractname']); ?></td>
                        <td style="text-align: left;"><?php echo htmlspecialchars($row['start_time']); ?> to <?php echo htmlspecialchars($row['end_time']); ?></td>
                        <td>
                            <!-- TAI CODE START: Compare Button -->
                            <button type="button" onclick="openTaiCompareModal(<?php echo $row['auto_id']; ?>)">Get Comparison</button>
                            <!-- TAI CODE END: Compare Button -->
                        </td>
                        <td>
                            <?php if (!empty($row['attachment_path'])) : ?>
                                <a href="<?php echo rawurlencode($row['attachment_path']); ?>" target="_blank"><i class="fa-solid fa-file-contract"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </table>
        <?php else : ?>
            <p>No contracts found. <button onclick="openContractModal()">+</button></p>
        <?php endif; ?>
    </div>

    <?php
    $sql = "SELECT * FROM tdu_vendor_bank_details WHERE vendorid = '$vendor_id'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);

    $accountname = $row['accountname'] ?? '';
    $bank_account = $row['bank_account'] ?? '';
    $bsb = $row['bsb'] ?? '';
    $swift = $row['swift'] ?? '';
    ?>

    <div id="div-ven5" class="content-div">
        <div class="form-container">
            <!-- Display Mode -->
            <div id="display-mode">
                <p><strong>Account Name:</strong> <?php echo htmlspecialchars($accountname); ?></p>
                <p><strong>Bank Account:</strong> <?php echo htmlspecialchars($bank_account); ?></p>
                <p><strong>BSB:</strong> <?php echo htmlspecialchars($bsb); ?></p>
                <p><strong>SWIFT Code:</strong> <?php echo htmlspecialchars($swift); ?></p>
                <button type="button" onclick="toggleEditMode2()" style="margin: 0 20px;">Edit</button>
            </div>

            <!-- Edit Mode -->
            <form id="edit-mode" style="display: none; margin: 20px;">
                <input type="hidden" id="vendor_id" name="vendor_id" value="<?php echo $vendor_id; ?>">
                <div class="form-column">
                    <div class="form-row">
                        <label for="accountname">Account Name:</label><br>
                        <input type="text" id="accountname" name="accountname" value="<?php echo htmlspecialchars($accountname); ?>" required><br>
                    </div>
                    <div class="form-row">
                        <label for="bank_account">Bank Account:</label><br>
                        <input type="text" id="bank_account" name="bank_account" value="<?php echo htmlspecialchars($bank_account); ?>"><br>
                    </div>
                </div>
                <div class="form-column">
                    <div class="form-row">
                        <label for="bsb">BSB:</label><br>
                        <input type="text" id="bsb" name="bsb" value="<?php echo htmlspecialchars($bsb); ?>"><br>
                    </div>
                    <div class="form-row">
                        <label for="swift">SWIFT Code:</label><br>
                        <input type="text" id="swift" name="swift" value="<?php echo htmlspecialchars($swift); ?>"><br><br>
                    </div>
                </div>
                <div class="form-column">
                    <button type="button" onclick="updateBankDetails()">Update Bank Details</button>
                    <button type="button" onclick="toggleEditMode2()">Cancel</button>
                </div>
            </form>
        </div>
    </div>
    <script>
        function toggleEditMode2() {
            var displayMode = document.getElementById("display-mode");
            var editMode = document.getElementById("edit-mode");

            if (displayMode.style.display === "none") {
                displayMode.style.display = "block";
                editMode.style.display = "none";
            } else {
                displayMode.style.display = "none";
                editMode.style.display = "block";
            }
        }

        function updateBankDetails() {
            var vendor_id = document.getElementById("vendor_id").value;
            var accountname = document.getElementById("accountname").value;
            var bank_account = document.getElementById("bank_account").value;
            var bsb = document.getElementById("bsb").value;
            var swift = document.getElementById("swift").value;

            var formData = new FormData();
            formData.append("vendor_id", vendor_id);
            formData.append("accountname", accountname);
            formData.append("bank_account", bank_account);
            formData.append("bsb", bsb);
            formData.append("swift", swift);

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_update_bank_details.php", true);

            xhr.onload = function () {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        alert("Bank details updated successfully!");
                        location.reload();
                    } else {
                        alert("Error updating bank details: " + response.error);
                    }
                } else {
                    alert("An error occurred while updating.");
                }
            };

            xhr.send(formData);
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            // Open modal
            $('#add-contact-btn').click(function () {
                $('#contact-modal').show();
            });

            // Close modal
            $('.close').click(function () {
                $('#contact-modal').hide();
            });

            // Add new contact using AJAX
            $('#add-contact-form').submit(function (e) {
                e.preventDefault();
                // Get full international number (with country code)
                const fullMobile = iti.getNumber();
                
                // Get just the country dial code (e.g., "+1")
                const countryCode = iti.getSelectedCountryData().dialCode;

                // Get the number without country code
                const nationalNumber = input.value.trim();

                // Append the extracted values to the form data
                const formData = $(this).serialize() + 
                                '&mobile=' + encodeURIComponent(fullMobile) +
                                '&mobile_code=' + encodeURIComponent(countryCode) +
                                '&mobile_number=' + encodeURIComponent(nationalNumber);

                $.ajax({
                    type: 'POST',
                    url: 'ajax_contact.php', // Replace with actual PHP script
                    data: formData,
                    success: function (response) {
                        const result = JSON.parse(response);

                        if (result.success) {
                            alert('Contact added successfully!');
                            location.reload();
                        } else {
                            alert('Failed to add contact: ' + result.message);
                        }
                    },
                    error: function () {
                        alert('An error occurred while adding the contact.');
                    }
                });
            });

            // Delete contact using AJAX
            $('.delete-contact-btn').click(function () {
                const id = $(this).data('id'); // Get the `auto_id`

                if (confirm('Are you sure you want to delete this contact?')) {
                    $.ajax({
                        type: 'POST',
                        url: 'ajax_contact.php', // Replace with actual PHP script
                        data: { action: 'delete', id: id },
                        success: function (response) {
                            const result = JSON.parse(response);

                            if (result.success) {
                                alert('Contact deleted successfully!');
                                location.reload();
                            } else {
                                alert('Failed to delete contact: ' + result.message);
                            }
                        },
                        error: function () {
                            alert('An error occurred while deleting the contact.');
                        }
                    });
                }
            });
        });
    </script>
    <style>
        select, input, textarea {
            width: 100%;
            height: 30px;
            margin: 0;
        }
        
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            width: 400px;
        }

        .close {
            float: right;
            cursor: pointer;
            font-size: 24px;
        }
    </style>

    <div id="div-ven6" class="content-div" style="margin: 20px;">
        <?php
        $monthNames = ["1" => "Jan", "2" => "Feb", "3" => "Mar", "4" => "Apr", "5" => "May", "6" => "Jun", "7" => "Jul", "8" => "Aug", "9" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec"];
        $sql3 = "SELECT * FROM tdu_vendors_surcharge WHERE vendorid = '$vendor_id';";
        $result3 = $conn->query($sql3);
        while ($row3 = $result3->fetch_assoc()) {
            $period_text = $monthNames[(int)$row3["start_m"]] . "-" . $row3["start_d"] . " - " . $monthNames[(int)$row3["end_m"]] . "-" . $row3["end_d"];
            ?>
            <span style="display: inline-block; background-color: #c5c5c5; padding: 5px 10px; margin: 2px; border-radius: 10px; position: relative;">
                <?php echo $period_text . ": $" . number_format($row3["surcharge"], 2); ?>
                <button onclick="deleteVendorSurchargeRow(<?php echo $row3['auto_id']; ?>)" style="border: none; background: none; color: red; font-weight: bold; position: absolute; top: -5px; right: -5px; cursor: pointer;"><i class="fa-solid fa-xmark"></i></button>
            </span>
            <?php
        }
        ?>
        <button id="openSurchargeModal" style="padding: 5px 10px; margin: 2px; border-radius: 10px; background-color: #c5c5c5; border: none; color: black;">
            <i class="fa-solid fa-plus"></i>
        </button>
    </div>
    <div id="addSurchargeModal" style="display: none; position: fixed; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
        <div style="background: white; margin: 10% auto; padding: 20px; width: 30%; text-align: left; position: relative;">
            <h2 style="margin-bottom: 20px;">New Surcharge Rule</h2>
            <label>Start Date: <br>
                <select id="surcharge_start_month" onchange="updateDays('surcharge_start_month', 'surcharge_start_day')" style="width: 48%; padding: 5px;">
                    <option value=""></option>
                    <option value="01">January</option>
                    <option value="02">February</option>
                    <option value="03">March</option>
                    <option value="04">April</option>
                    <option value="05">May</option>
                    <option value="06">June</option>
                    <option value="07">July</option>
                    <option value="08">August</option>
                    <option value="09">September</option>
                    <option value="10">October</option>
                    <option value="11">November</option>
                    <option value="12">December</option>
                </select> -
                <select id="surcharge_start_day" style="width: 48%; padding: 5px;"></select>
            </label><br>

            <label>End Date: <br>
                <select id="surcharge_end_month" onchange="updateDays('surcharge_end_month', 'surcharge_end_day')" style="width: 48%; padding: 5px;">
                    <option value=""></option>
                    <option value="01">January</option>
                    <option value="02">February</option>
                    <option value="03">March</option>
                    <option value="04">April</option>
                    <option value="05">May</option>
                    <option value="06">June</option>
                    <option value="07">July</option>
                    <option value="08">August</option>
                    <option value="09">September</option>
                    <option value="10">October</option>
                    <option value="11">November</option>
                    <option value="12">December</option>
                </select> -
                <select id="surcharge_end_day" style="width: 48%; padding: 5px;"></select>
            </label><br>

            <label>Surcharge Amount ($): <br>
                <input type="number" id="surcharge_amount" min="0" step="0.01" style="width: 99%;">
            </label><br><br>
            
            <label>Apply To: <br>
                <select id="surcharge_apply_to" style="width: 99%;">
                    <option value="all">All</option>
                    <option value="custom">Custom</option>
                </select>
            </label><br><br>

            <button onclick="saveVendorSurcharge()" style="padding: 8px 15px; background-color: #334155; color: white; border: none; border-radius: 5px; cursor: pointer;">Save</button>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const addSurchargeModal = document.getElementById("addSurchargeModal");
            const openSurchargeModal = document.getElementById("openSurchargeModal");

            openSurchargeModal.addEventListener("click", function () {
                addSurchargeModal.style.display = "block";
            });

            window.addEventListener("click", function (event) {
                if (event.target === addSurchargeModal) {
                    addSurchargeModal.style.display = "none";
                }
            });

            updateDays('surcharge_start_month', 'surcharge_start_day');
            updateDays('surcharge_end_month', 'surcharge_end_day');
        });

        function updateDays(monthSelectId, daySelectId) {
            const monthSelect = document.getElementById(monthSelectId);
            const daySelect = document.getElementById(daySelectId);
            const month = monthSelect.value;
            
            const daysInMonth = {
                "01": 31, "02": 29, "03": 31, "04": 30,
                "05": 31, "06": 30, "07": 31, "08": 31,
                "09": 30, "10": 31, "11": 30, "12": 31
            };
            
            daySelect.innerHTML = "";
            for (let i = 1; i <= daysInMonth[month]; i++) {
                let option = document.createElement("option");
                option.value = i < 10 ? "0" + i : i;
                option.textContent = i;
                daySelect.appendChild(option);
            }
        }

        function saveVendorSurcharge() {
            let vendorid = <?= $vendor_id ?>;
            let startMonth = document.getElementById("surcharge_start_month").value;
            let startDay = document.getElementById("surcharge_start_day").value;
            let endMonth = document.getElementById("surcharge_end_month").value;
            let endDay = document.getElementById("surcharge_end_day").value;
            let amount = document.getElementById("surcharge_amount").value;
            let applyTo = document.getElementById("surcharge_apply_to").value;

            if (!startMonth || !startDay || !endMonth || !endDay || !amount || !applyTo) {
                alert("Please complete all fields.");
                return;
            }

            let data = `vendorid=${vendorid}&start_m=${startMonth}&start_d=${startDay}&end_m=${endMonth}&end_d=${endDay}&amount=${amount}&apply_to=${applyTo}`;

            fetch("ajax_save_vendor_surcharge.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: data
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("Surcharge saved!");
                    location.reload();
                } else {
                    alert("Error: " + data.message);
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Something went wrong!");
            });
        }

        function deleteVendorSurchargeRow(id) {
            if (!confirm("Are you sure you want to delete this surcharge?")) return;

            fetch("ajax_delete_vendor_surcharge.php", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: `id=${id}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert("Deleted!");
                    location.reload();
                } else {
                    alert("Error: " + data.message);
                }
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Something went wrong!");
            });
        }
    </script>

    <div id="div-ven7" class="content-div">
        <?php
        $sqlDashboard = "SELECT productid, productName, city, rezdy_uni_code, productActive FROM tdu_products WHERE vendorid = $vendor_id";
        $resultDashboard = mysqli_query($conn, $sqlDashboard);

        include 'rezdyconn.php';
        // Handle multiple aliases
        $aliases = array_filter(array_map('trim', explode(';;', $rezdy_uni_vendor)));

        if (!empty($aliases)) {
            // Escape each alias safely for use in the query
            $escapedAliases = array_map(function($alias) use ($conn) {
                return "'" . mysqli_real_escape_string($conn, $alias) . "'";
            }, $aliases);

            $aliasList = implode(',', $escapedAliases);

            $sqlRezdy = "SELECT name, city, productCode, supplierName FROM products 
                        WHERE supplierAlias IN ($aliasList)";
            $resultRezdy = mysqli_query($rezdyconn, $sqlRezdy);
        } else {
            $resultRezdy = false; // No valid aliases to query
        }
        ?>

        <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
            <!-- Dashboard Products Table -->
            <div style="flex: 1; margin: 20px; padding: 20px; border: 1px solid #ccc; border-radius: 5px;">                
                <h3>Dashboard Products (Rezdy)</h3>
                <div style="display: flex; gap: 10px; margin-bottom: 10px;">
                    <input type="text" id="dashboardFilter" placeholder="Filter Dashboard Products ..." style="flex: 1; padding: 5px;" />
                    <select id="statusFilter" style="padding: 5px; width: 20%;">
                        <option value="All">All Products</option>
                        <option value="Yes">Active</option>
                        <option value="No">Inactive</option>
                    </select>
                </div>

                <div id="add-product-drop" 
                    style="margin-top: 20px; padding: 10px; text-align: center; border: 2px dashed #aaa; cursor: pointer; border-radius: 5px; background-color: #f9f9f9;">
                    <i class="fa fa-plus" style="color: green;"></i> New Product from Rezdy
                </div>

                <!-- Hidden Form for Adding Product -->
                <div id="add-form" style="display:none; padding: 15px; border: 1px solid #ccc; margin-top: 20px; border-radius: 5px;">
                    <span id="selectedProductDisplay" style="color: green;"></span><br>
                    <select id="category" name="category" style="margin: 10px 0; padding: 5px; width: 100%;">
                        <option value="">Select Category</option>
                        <option value="Attraction">Attraction</option>
                        <option value="Restaurant">Restaurant</option>
                        <option value="Transfers">Transfers</option>
                        <option value="Guide">Guide</option>
                        <option value="Tour">Tour</option>
                        <option value="SIC">SIC</option>
                    </select><br>
                    <button id="submitAddProduct" style="padding: 5px 10px;">Add Product</button>
                </div>

                <?php if (mysqli_num_rows($resultDashboard) > 0) : ?>
                    <table class="styled-table" id="dashboardTable">
                        <thead>
                            <tr>
                                <th style="text-align: left;">Rezdy Code</th>
                                <th style="text-align: left;">Product Name</th>
                                <th style="text-align: center;">City</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($resultDashboard)) : ?>
                                <tr class="dashboard-row" data-org-id="<?php echo $row['productid']; ?>" data-active="<?php echo $row['productActive']; ?>">
                                    <td style="text-align: left;" class="filter-rezdy-by-code" data-rezdy-code="<?php echo htmlspecialchars($row['rezdy_uni_code']); ?>">
                                        <span class="rezdy-code" style="color: blue; cursor: pointer;">
                                            <?php echo htmlspecialchars($row['rezdy_uni_code']); ?>
                                        </span>
                                        <?php if (!empty($row['rezdy_uni_code'])): ?>
                                            <i class="fa-solid fa-link-slash unlink-icon" 
                                            title="Unlink Rezdy Code" 
                                            data-product-id="<?php echo $row['productid']; ?>" 
                                            style="color: red; cursor: pointer;"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td style="text-align: left;">
                                        <?= $row['productActive'] == 'Yes' ? '<i class="fa-solid fa-circle-check" style="color: green;"></i>' : '<i class="fa-solid fa-circle-xmark" style="color: red;"></i>'; ?>
                                        <?php echo htmlspecialchars($row['productName']); ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['city']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else : ?>
                    <p>No dashboard products found.</p>
                <?php endif; ?>
            </div>

            <!-- Rezdy Products Table -->
            <div style="flex: 1; margin: 20px; padding: 20px; border: 1px solid #ccc; border-radius: 5px;">
                <h3>Rezdy Products (Drag & Drop)</h3>
                <input type="text" id="rezdyFilter" placeholder="Filter Rezdy Products ..." style="width: 100%; margin-bottom: 10px; padding: 5px;" />
                <?php if ($resultRezdy && mysqli_num_rows($resultRezdy) > 0) : ?>
                    <table class="styled-table" id="rezdyTable">
                        <thead>
                            <tr>
                                <th style="text-align: left;">Rezdy Code</th>
                                <th style="text-align: left;">Product Name</th>
                                <th style="text-align: left;">Rezdy Supplier</th>
                                <th style="text-align: center;">City</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($resultRezdy)) : ?>
                                <tr class="rezdy-draggable" draggable="true" data-rezdy-code="<?php echo htmlspecialchars($row['productCode']); ?>">
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['productCode']); ?></td>
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['supplierName']); ?></td>
                                    <td><?php echo htmlspecialchars($row['city']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else : ?>
                    <p>No Rezdy products found.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Script: Drag & Drop + Filters + unlink -->
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                let draggedRezdyCode = null;
                let droppedRezdyCode = null;

                // Drag events for Rezdy rows
                document.querySelectorAll('.rezdy-draggable').forEach(row => {
                    row.addEventListener('dragstart', e => {
                        draggedRezdyCode = row.getAttribute('data-rezdy-code');
                        row.style.opacity = '0.6';
                    });
                    row.addEventListener('dragend', () => {
                        row.style.opacity = '';
                    });
                });

                // Drop on existing dashboard rows (to update rezdy code)
                document.querySelectorAll('.dashboard-row').forEach(row => {
                    row.addEventListener('dragover', e => {
                        e.preventDefault();
                        row.style.backgroundColor = '#e0ffe0';
                    });
                    row.addEventListener('dragleave', () => {
                        row.style.backgroundColor = '';
                    });
                    row.addEventListener('drop', e => {
                        e.preventDefault();
                        row.style.backgroundColor = '';
                        const orgId = row.getAttribute('data-org-id');
                        if (draggedRezdyCode && orgId) {
                            fetch('ajax_rezdy_update_rezdy_code.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: `org_id=${encodeURIComponent(orgId)}&rezdy_code=${encodeURIComponent(draggedRezdyCode)}`
                            })
                            .then(response => response.text())
                            .then(data => {
                                const cells = row.getElementsByTagName('td');
                                if (cells.length > 0) {
                                    cells[0].textContent = draggedRezdyCode;
                                }

                                // Optional: briefly highlight the updated row
                                row.style.backgroundColor = 'lightgreen';
                                setTimeout(() => {
                                    row.style.backgroundColor = '';
                                }, 5000);
                            })
                            .catch(err => {
                                console.error('Error:', err);
                                alert('Failed to update. See console for details.');
                            });
                        }
                    });
                });

                // Unlink rezdy code on icon click
                document.querySelectorAll('.unlink-icon').forEach(icon => {
                    icon.addEventListener('click', function () {
                        const productId = this.getAttribute('data-product-id');

                        if (confirm('Are you sure you want to unlink this Rezdy code?')) {
                            fetch('ajax_rezdy_unlink_rezdy_code.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: `product_id=${encodeURIComponent(productId)}`
                            })
                            .then(response => response.text())
                            .then(data => {
                                if (data.trim() === 'success') {
                                    const td = this.closest('td');
                                    td.querySelector('.rezdy-code').textContent = '';
                                    this.remove();
                                } else {
                                    alert('Failed to unlink. Server response: ' + data);
                                }
                            })
                            .catch(err => {
                                console.error('AJAX error:', err);
                                alert('AJAX request failed.');
                            });
                        }
                    });
                });

                // Filter tables
                function filterDashboardTable() {
                    const textFilter = document.getElementById('dashboardFilter').value.toLowerCase();
                    const statusFilter = document.getElementById('statusFilter').value;
                    const rows = document.querySelectorAll('#dashboardTable tbody tr');

                    rows.forEach(row => {
                        const text = row.textContent.toLowerCase();
                        const activeStatus = row.getAttribute('data-active');

                        const textMatch = text.includes(textFilter);
                        const statusMatch = (statusFilter === 'All' || activeStatus === statusFilter);

                        row.style.display = (textMatch && statusMatch) ? '' : 'none';
                    });
                }

                function filterRezdyTable() {
                    const filter = document.getElementById('rezdyFilter').value.toLowerCase();
                    const rows = document.querySelectorAll('#rezdyTable tbody tr');

                    rows.forEach(row => {
                        const text = row.textContent.toLowerCase();
                        row.style.display = text.includes(filter) ? '' : 'none';
                    });
                }

                // Attach event listeners
                document.getElementById('dashboardFilter').addEventListener('input', filterDashboardTable);
                document.getElementById('statusFilter').addEventListener('change', filterDashboardTable);
                document.getElementById('rezdyFilter').addEventListener('input', filterRezdyTable);

                // Handle "+" drop zone for creating new products
                const dropZone = document.getElementById('add-product-drop');
                const addForm = document.getElementById('add-form');
                const submitBtn = document.getElementById('submitAddProduct');

                dropZone.addEventListener('dragover', e => {
                    e.preventDefault();
                    dropZone.style.backgroundColor = '#e0ffe0';
                });

                dropZone.addEventListener('dragleave', () => {
                    dropZone.style.backgroundColor = '#f9f9f9';
                });

                dropZone.addEventListener('drop', e => {
                    e.preventDefault();
                    dropZone.style.backgroundColor = '#f9f9f9';
                    if (draggedRezdyCode) {
                        droppedRezdyCode = draggedRezdyCode;

                        // Get the dragged row and its product name
                        const draggedRow = document.querySelector(`.rezdy-draggable[data-rezdy-code="${draggedRezdyCode}"]`);
                        const nameCell = draggedRow ? draggedRow.cells[1].textContent : '';
                        const displayText = `${draggedRezdyCode}: ${nameCell}`;

                        // Update the display span in the form
                        document.getElementById('selectedProductDisplay').textContent = displayText;

                        // Show the form
                        addForm.style.display = 'block';
                    }
                });

                submitBtn.addEventListener('click', () => {
                    const category = document.getElementById('category').value;
                    if (!category || !droppedRezdyCode) {
                        alert('Please select a category.');
                        return;
                    }

                    fetch('ajax_create_dashboard_product_from_rezdy.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: `vendor_id=<?php echo $vendor_id; ?>&product_code=${encodeURIComponent(droppedRezdyCode)}&category=${encodeURIComponent(category)}`
                    })
                    .then(response => response.text())
                    .then(data => {
                        if (data.trim() === 'success') {
                            alert('Product added successfully.');
                            location.reload(); // Reload to show new product
                        } else {
                            alert('Failed to add product: ' + data);
                        }
                    })
                    .catch(err => {
                        console.error('AJAX error:', err);
                        alert('AJAX request failed.');
                    });
                });
            });

            let activeRezdyFilterCode = null;
            document.querySelectorAll('.filter-rezdy-by-code').forEach(cell => {
                cell.addEventListener('click', function (e) {
                    // Avoid triggering if unlink icon is clicked
                    if (e.target.classList.contains('unlink-icon')) return;

                    const rezdyCode = this.getAttribute('data-rezdy-code');
                    if (!rezdyCode) return;
                    document.getElementById('rezdyFilter').value = rezdyCode;
                    activeRezdyFilterCode = rezdyCode;

                    // Filter Rezdy Table
                    document.querySelectorAll('#rezdyTable tbody tr').forEach(row => {
                        const rowCode = row.getAttribute('data-rezdy-code');
                        row.style.display = (!activeRezdyFilterCode || rowCode === activeRezdyFilterCode) ? '' : 'none';
                    });
                });
            });
        </script>

        <style>
            .styled-table tr.rezdy-draggable:hover {
                cursor: grab;
                background-color: lightyellow;
            }
            .dashboard-row {
                transition: background-color 0.2s;
            }
        </style>
    </div>

    <div id="div-ven8" class="content-div">
        <?php
        include 'fareharborconn.php';
        $linked_products = [];

        $sqlDashboardFH = "SELECT productid, productName, fareharbor_product_code, productActive FROM tdu_products WHERE vendorid = $vendor_id";
        $resultDashboardFH = mysqli_query($conn, $sqlDashboardFH);

        $escapedVendors = array_map(function($vendor) use ($conn) {
            return "'" . mysqli_real_escape_string($conn, $vendor) . "'";
        }, explode(';;', $fareharbor_vendor));

        // Join into a comma-separated list
        $vendorList = implode(',', $escapedVendors);

        // Now build the query
        $sqlFH = "
            SELECT p.pk, p.name AS productName, c.name AS companyName 
            FROM fareharbor_products p
            LEFT JOIN fareharbor_companies c ON p.company_shortname = c.shortname
            WHERE p.company_shortname IN ($vendorList)
        ";

        $resultFH = mysqli_query($fareharborconn, $sqlFH);
        ?>

        <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
            <!-- Dashboard Products -->
            <div style="flex: 1; margin: 20px; padding: 20px; border: 1px solid #ccc; border-radius: 5px;">
                <h3>Dashboard Products (FareHarbor)</h3>
                <div style="display: flex; gap: 10px; margin-bottom: 10px;">
                    <input type="text" id="fhDashboardFilter" placeholder="Filter Dashboard Products ..." style="flex: 1; padding: 5px;" />
                    <select id="fhStatusFilter" style="padding: 5px; width: 20%;">
                        <option value="All">All Products</option>
                        <option value="Yes">Active</option>
                        <option value="No">Inactive</option>
                    </select>
                </div>

                <div id="fh-add-product-drop" 
                    style="margin-top: 20px; padding: 10px; text-align: center; border: 2px dashed #aaa; cursor: pointer; border-radius: 5px; background-color: #f9f9f9;">
                    <i class="fa fa-plus" style="color: green;"></i> New Product from FareHarbor
                </div>

                <div id="fh-add-form" style="display:none; padding: 15px; border: 1px solid #ccc; margin-top: 20px; border-radius: 5px;">
                    <span id="fhSelectedProductDisplay" style="color: green;"></span><br>
                    <select id="fhCategory" name="category" style="margin: 10px 0; padding: 5px; width: 100%;">
                        <option value="">Select Category</option>
                        <option value="Attraction">Attraction</option>
                        <option value="Restaurant">Restaurant</option>
                        <option value="Transfers">Transfers</option>
                        <option value="Guide">Guide</option>
                        <option value="Tour">Tour</option>
                        <option value="SIC">SIC</option>
                    </select><br>
                    <button id="fhSubmitAddProduct" style="padding: 5px 10px;">Add Product</button>
                </div>

                <?php if (mysqli_num_rows($resultDashboardFH) > 0) : ?>
                    <table class="styled-table" id="fhDashboardTable">
                        <thead>
                            <tr>
                                <th style="text-align: left;">FH Code</th>
                                <th style="text-align: left;">Product Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($resultDashboardFH)) : ?>
                                <tr class="fh-dashboard-row" data-org-id="<?php echo $row['productid']; ?>" data-active="<?php echo $row['productActive']; ?>">
                                    <td style="text-align: left;" class="filter-fh-by-code" data-fh-code="<?php echo htmlspecialchars($row['fareharbor_product_code']); ?>">
                                        <span class="fh-code" style="color: blue; cursor: pointer;">
                                            <?php echo htmlspecialchars($row['fareharbor_product_code']); ?>
                                        </span>
                                        <?php if (!empty($row['fareharbor_product_code'])): 
                                            $linked_products[] = $row['fareharbor_product_code'];
                                            ?>
                                            <i class="fa-solid fa-link-slash unlink-icon-fh" 
                                            title="Unlink FH Code"
                                            data-product-id="<?php echo $row['productid']; ?>"
                                            style="color: red; cursor: pointer;"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td style="text-align: left;">
                                        <?= $row['productActive'] == 'Yes' ? '<i class="fa-solid fa-circle-check" style="color: green;"></i>' : '<i class="fa-solid fa-circle-xmark" style="color: red;"></i>'; ?>
                                        <?php echo htmlspecialchars($row['productName']); ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else : ?>
                    <p>No dashboard products found.</p>
                <?php endif; ?>
            </div>

            <!-- FareHarbor Products Table -->
            <div style="flex: 1; margin: 20px; padding: 20px; border: 1px solid #ccc; border-radius: 5px;">
                <h3>FareHarbor Products (Drag & Drop)</h3>
                <input type="text" id="fhFilter" placeholder="Filter FareHarbor Products ..." style="width: 100%; margin-bottom: 10px; padding: 5px;" />
                <?php if ($resultFH && mysqli_num_rows($resultFH) > 0) : ?>
                    <table class="styled-table" id="fhTable">
                        <thead>
                            <tr>
                                <th style="text-align: left;">FH Code</th>
                                <th style="text-align: left;">Product Name</th>
                                <th style="text-align: left;">Company</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($resultFH)) : ?>
                                <tr class="fh-draggable" draggable="true" data-fh-code="<?php echo htmlspecialchars($row['pk']); ?>" <?= in_array($row['pk'], $linked_products) ? 'style="background-color: lightgreen;"' : '' ?>>
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['pk']); ?></td>
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['productName']); ?></td>
                                    <td style="text-align: left;"><?php echo htmlspecialchars($row['companyName']); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                <?php else : ?>
                    <p>No FareHarbor products found.</p>
                <?php endif; ?>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                let draggedFHCode = null;
                let droppedFHCode = null;

                document.querySelectorAll('.fh-draggable').forEach(row => {
                    row.addEventListener('dragstart', e => {
                        draggedFHCode = row.getAttribute('data-fh-code');
                        row.style.opacity = '0.6';
                    });
                    row.addEventListener('dragend', () => {
                        row.style.opacity = '';
                    });
                });

                document.querySelectorAll('.fh-dashboard-row').forEach(row => {
                    row.addEventListener('dragover', e => {
                        e.preventDefault();
                        row.style.backgroundColor = '#e0ffe0';
                    });
                    row.addEventListener('dragleave', () => {
                        row.style.backgroundColor = '';
                    });
                    row.addEventListener('drop', e => {
                        e.preventDefault();
                        row.style.backgroundColor = '';
                        const orgId = row.getAttribute('data-org-id');
                        if (draggedFHCode && orgId) {
                            fetch('ajax_fareharbor_update_fh_code.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: `org_id=${encodeURIComponent(orgId)}&fh_code=${encodeURIComponent(draggedFHCode)}`
                            })
                            .then(res => res.text())
                            .then(data => {
                                const cells = row.getElementsByTagName('td');
                                if (cells.length > 0) cells[0].textContent = draggedFHCode;
                                row.style.backgroundColor = 'lightgreen';
                                setTimeout(() => row.style.backgroundColor = '', 5000);
                            });
                        }
                    });
                });

                // Unlink FH code
                document.querySelectorAll('.unlink-icon-fh').forEach(icon => {
                    icon.addEventListener('click', function () {
                        const productId = this.getAttribute('data-product-id');
                        if (confirm('Unlink this FH code?')) {
                            fetch('ajax_fareharbor_unlink_fh_code.php', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                                body: `product_id=${encodeURIComponent(productId)}`
                            })
                            .then(res => res.text())
                            .then(data => {
                                if (data.trim() === 'success') {
                                    const td = this.closest('td');
                                    td.querySelector('.fh-code').textContent = '';
                                    this.remove();
                                } else {
                                    alert('Failed to unlink: ' + data);
                                }
                            });
                        }
                    });
                });

                // Filters
                function filterDashboardFHTable() {
                    const textFilter = document.getElementById('fhDashboardFilter').value.toLowerCase();
                    const statusFilter = document.getElementById('fhStatusFilter').value;
                    document.querySelectorAll('#fhDashboardTable tbody tr').forEach(row => {
                        const text = row.textContent.toLowerCase();
                        const status = row.getAttribute('data-active');
                        row.style.display = (text.includes(textFilter) && (statusFilter === 'All' || status === statusFilter)) ? '' : 'none';
                    });
                }

                function filterFHTable() {
                    const filter = document.getElementById('fhFilter').value.toLowerCase();
                    document.querySelectorAll('#fhTable tbody tr').forEach(row => {
                        const text = row.textContent.toLowerCase();
                        row.style.display = text.includes(filter) ? '' : 'none';
                    });
                }

                document.getElementById('fhDashboardFilter').addEventListener('input', filterDashboardFHTable);
                document.getElementById('fhStatusFilter').addEventListener('change', filterDashboardFHTable);
                document.getElementById('fhFilter').addEventListener('input', filterFHTable);

                // Drop to create new product
                const dropZone = document.getElementById('fh-add-product-drop');
                const addForm = document.getElementById('fh-add-form');
                dropZone.addEventListener('dragover', e => {
                    e.preventDefault();
                    dropZone.style.backgroundColor = '#e0ffe0';
                });
                dropZone.addEventListener('dragleave', () => {
                    dropZone.style.backgroundColor = '#f9f9f9';
                });
                dropZone.addEventListener('drop', e => {
                    e.preventDefault();
                    dropZone.style.backgroundColor = '#f9f9f9';
                    if (draggedFHCode) {
                        droppedFHCode = draggedFHCode;
                        const draggedRow = document.querySelector(`.fh-draggable[data-fh-code="${draggedFHCode}"]`);
                        const nameCell = draggedRow ? draggedRow.cells[1].textContent : '';
                        document.getElementById('fhSelectedProductDisplay').textContent = `${draggedFHCode}: ${nameCell}`;
                        addForm.style.display = 'block';
                    }
                });

                document.getElementById('fhSubmitAddProduct').addEventListener('click', () => {
                    const category = document.getElementById('fhCategory').value;
                    if (!category || !droppedFHCode) {
                        alert('Please select a category.');
                        return;
                    }

                    fetch('ajax_create_dashboard_product_from_fareharbor.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: `vendor_id=<?php echo $vendor_id; ?>&product_code=${encodeURIComponent(droppedFHCode)}&category=${encodeURIComponent(category)}`
                    })
                    .then(res => res.text())
                    .then(data => {
                        if (data.trim() === 'success') {
                            alert('Product added successfully.');
                            location.reload();
                        } else {
                            alert('Failed to add product: ' + data);
                        }
                    });
                });
            });

            let activeFhFilterCode = null;
            document.querySelectorAll('.filter-fh-by-code').forEach(cell => {
                cell.addEventListener('click', function (e) {
                    // Avoid triggering if unlink icon is clicked
                    if (e.target.classList.contains('unlink-icon-fh')) return;

                    const fhCode = this.getAttribute('data-fh-code');
                    if (!fhCode) return;
                    document.getElementById('fhFilter').value = fhCode;
                    activeFhFilterCode = fhCode;

                    // Filter FH Table
                    document.querySelectorAll('#fhTable tbody tr').forEach(row => {
                        const rowCode = row.getAttribute('data-fh-code');
                        row.style.display = (!activeFhFilterCode || rowCode === activeFhFilterCode) ? '' : 'none';
                    });
                });
            });
        </script>

        <style>
            .styled-table tr.fh-draggable:hover {
                cursor: grab;
                background-color: lightyellow;
            }
            .fh-dashboard-row {
                transition: background-color 0.2s;
            }
        </style>
    </div>
    
        <!--QBO TRANSACTION LIST START-->
    <div id="div-ven-transactionlist" class="content-div">
        <?php
        // =========================================================================
        // ==            START: QBO VENDOR TRANSACTION HISTORY FEATURE            ==
        // =========================================================================
        $allVendorTransactions = [];
        $qboTransErrorMessage = null;
        $totalVendorBalance = 0.0;
        
        // We reuse variables from the summary block: $qboUtil, $qboVendor, and $vendorFinancialData
        
        try {
            if (!$qboUtil) {
                throw new Exception("QuickBooks connection is not available.");
            }
            
            if ($qboVendor && !empty($qboVendor->Id)) {
                $allVendorTransactions = $qboUtil->getVendorTransactionHistory($qboVendor->Id);
            }
        
        } catch (Exception $e) {
            error_log("QBO Vendor Transaction History Feature Error: " . $e->getMessage());
            $qboTransErrorMessage = "Could not load transaction history.";
        }
        ?>
        
        <!-- Transaction History Card -->
        <div class="transaction-card">
            <div class="card-header">
                <h3 class="card-title">QuickBooks Transaction History</h3>
            </div>
            <div class="card-body">
                <?php if ($qboTransErrorMessage): ?>
                    <p class="error-message"><?= htmlspecialchars($qboTransErrorMessage) ?></p>
                <?php elseif (!$qboVendor): ?>
                     <p class="no-results">This vendor was not found in QuickBooks.</p>
                <?php elseif (empty($allVendorTransactions)): ?>
                    <p class="no-results">No transaction history found for this vendor in QuickBooks.</p>
                <?php else: ?>
                    <table class="transaction-table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>No.</th>
                                <th>Due Date</th>
                                <th style="text-align: right;">Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($allVendorTransactions as $txn):
                                $txnType = $txn['transaction_type'] ?? 'N/A';
                                $isBill = (stripos($txnType, 'bill') !== false && stripos($txnType, 'payment') === false);
                                $isPayment = (stripos($txnType, 'payment') !== false);
                                
                                $displayAmount = $isPayment ? -1 * abs(floatval($txn['amount'] ?? 0)) : floatval($txn['amount'] ?? 0);
                                $totalVendorBalance += $displayAmount;
                                
                                $billNum = $txn['no_'] ?? null;
                                $billDetails = ($isBill && isset($billNum)) ? ($vendorFinancialData['bill_details'][$billNum] ?? null) : null;
                                $openBalance = $billDetails['open_balance'] ?? null;
                                
                                // --- REFINED DUE DATE LOGIC ---
                                // Prioritize the accurate due date from the financial detail report (for open bills).
                                // For paid bills, this will be null, and that's an expected limitation for performance.
                                $dueDateStr = $billDetails['due_date'] ?? null;
                            ?>
                            <tr class="<?= $isPayment ? 'payment-row' : '' ?>">
                                <td><?= htmlspecialchars($txn['date'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($txnType) ?></td>
                                <td><?= htmlspecialchars($txn['no_'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($dueDateStr ?? 'N/A') ?></td>
                                <td style="text-align: right;"><?= htmlspecialchars(number_format($displayAmount, 2)) ?></td>
                                <td>
                                    <?php
                                    if ($isPayment) {
                                        echo '<span class="status-paid">Closed</span>';
                                    } elseif ($isBill) {
                                        $isConsideredPaid = (isset($openBalance) && $openBalance <= 0.01) || !isset($billDetails);

                                        if ($isConsideredPaid) {
                                            echo '<span class="status-paid">Paid</span>';
                                        } else {
                                            if (!empty($dueDateStr)) {
                                                try {
                                                    $dueDate = new DateTime($dueDateStr);
                                                    $today = new DateTime('today');
                                                    if ($dueDate < $today) {
                                                        $diff = $today->diff($dueDate);
                                                        echo '<span class="status-overdue">Overdue ' . $diff->days . ' days</span>';
                                                    } else {
                                                        echo '<span class="status-open">Open</span>';
                                                    }
                                                } catch (Exception $e) { echo '<span class="status-open">Open</span>'; }
                                            } else {
                                                echo '<span class="status-open">Open</span>';
                                            }
                                        }
                                    }
                                    ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" style="text-align: right;">Current Balance</td>
                                <td style="text-align: right;"><?= htmlspecialchars(number_format($totalVendorBalance, 2)) ?></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                <?php endif; ?>
            </div>
        </div>
        
        <style>
            /* This CSS can remain the same */
            .transaction-card { background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.07); border: 1px solid #e9ecef; margin-top: 1rem; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; }
            .transaction-card .card-header { padding: 12px 20px; border-bottom: 1px solid #e9ecef; }
            .transaction-card .card-title { margin: 0; font-size: 1.1rem; font-weight: 600; color: #343a40; }
            .transaction-card .card-body { padding: 8px 0 0; }
            .transaction-card .transaction-table { width: 100%; border-collapse: collapse; }
            .transaction-card th, .transaction-card td { text-align: left; padding: 12px 20px; border-bottom: 1px solid #f1f3f5; }
            .transaction-card thead th { color: #868e96; font-weight: 600; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.5px; border-bottom: 2px solid #e9ecef; }
            .transaction-card tbody tr:last-child td { border-bottom: none; }
            .transaction-card .no-results, .transaction-card .error-message { padding: 24px; text-align: center; color: #6c757d; }
            .transaction-card tfoot td { font-weight: bold; font-size: 1.05rem; color: #212529; border-top: 2px solid #dee2e6; }
            .status-overdue { font-weight: bold; color: #d93025; }
            .status-open { color: #0077c5; }
            .status-paid { color: #2d8a32; }
            .payment-row td { color: #495057; font-style: italic; }
        </style>
        <!-- ======================================================================= -->
        <!-- ==          END: QBO VENDOR TRANSACTION HISTORY FEATURE            == -->
        <!-- ======================================================================= -->
    </div>
    <!--QBO TRANSACTION LIST END-->
    <?php
}
else if (($title=='admin' || $title == 'account') && isset($_GET['opt']) && $_GET['opt'] == 'vendor-products-bulk-edit') {
    $vendorid = $_GET['vendorid'] ?? '';
    $vendorname = $_GET['vendorname'] ?? '';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $today = date('Y-m-d');
    
        foreach ($_POST['productid'] as $index => $productid) {
            $productName = mysqli_real_escape_string($conn, $_POST['productName'][$index]);
            $category = mysqli_real_escape_string($conn, $_POST['category'][$index]);
            $city = mysqli_real_escape_string($conn, $_POST['city'][$index]);
            $country = mysqli_real_escape_string($conn, $_POST['country'][$index]);
            $description = mysqli_real_escape_string($conn, $_POST['description'][$index]);
    
            $start_date = !empty($_POST['start_date'][$index]) ? mysqli_real_escape_string($conn, $_POST['start_date'][$index]) : null;
            $end_date = !empty($_POST['end_date'][$index]) ? mysqli_real_escape_string($conn, $_POST['end_date'][$index]) : null;
    
            // Numeric fields
            $duration = !empty($_POST['duration'][$index]) ? (int)$_POST['duration'][$index] : '';
            $seats = !empty($_POST['seats'][$index]) ? (int)$_POST['seats'][$index] : '';
            $unitPrice = !empty($_POST['unitPrice'][$index]) ? (float)$_POST['unitPrice'][$index] : '';
            $childPrice = !empty($_POST['childPrice'][$index]) ? (float)$_POST['childPrice'][$index] : '';
            $infantPrice = !empty($_POST['infantPrice'][$index]) ? (float)$_POST['infantPrice'][$index] : '';
            $sharingPrice = !empty($_POST['sharingPrice'][$index]) ? (float)$_POST['sharingPrice'][$index] : '';
            $triplePrice = !empty($_POST['triplePrice'][$index]) ? (float)$_POST['triplePrice'][$index] : '';
            $childWithBedPrice = !empty($_POST['childWithBedPrice'][$index]) ? (float)$_POST['childWithBedPrice'][$index] : '';
            $childNoBedPrice = !empty($_POST['childNoBedPrice'][$index]) ? (float)$_POST['childNoBedPrice'][$index] : '';
    
            // Check if today is within start_date and end_date
            $isWithinDateRange = ($start_date && $end_date && $today >= $start_date && $today <= $end_date);
    
            // Update `tdu_products`
            $updateFields = [
                "productName='$productName'",
                "category='$category'",
                "city='$city'",
                "country='$country'",
                "description='$description'",
                "duration='$duration'",
                "seats='$seats'"
            ];
            if ($isWithinDateRange || ($start_date == null && $end_date == null)) {
                if ($unitPrice != '') $updateFields[] = "unitPrice='$unitPrice'";
                if ($childPrice != '') $updateFields[] = "childPrice='$childPrice'";
                if ($infantPrice != '') $updateFields[] = "infantPrice='$infantPrice'";
                if ($sharingPrice != '') $updateFields[] = "sharingPrice='$sharingPrice'";
                if ($triplePrice != '') $updateFields[] = "triplePrice='$triplePrice'";
                if ($childWithBedPrice != '') $updateFields[] = "childWithBedPrice='$childWithBedPrice'";
                if ($childNoBedPrice != '') $updateFields[] = "childNoBedPrice='$childNoBedPrice'";
            }
            $sql = "UPDATE tdu_products SET " . implode(", ", $updateFields) . " WHERE productid='$productid'";
            mysqli_query($conn, $sql);
    
            // Insert into `tdu_pricebook` only if both start_date and end_date are set
            if ($start_date && $end_date) {
                $sql_pricebook = "INSERT INTO tdu_pricebook 
                    (productid, name, start_date, end_date, unit_price, child_price, infant_price, sharing_price, triple_price, child_with_bed_price, child_no_bed_price) 
                    VALUES 
                    ('$productid', 'Pricebook', '$start_date', '$end_date', '$unitPrice', '$childPrice', '$infantPrice', '$sharingPrice', '$triplePrice', '$childWithBedPrice', '$childNoBedPrice')";
    
                mysqli_query($conn, $sql_pricebook);
            }
        }
    
        echo "<script>alert('Products updated successfully!'); window.location.href='quote.php?opt=vendor-details&id=$vendorid&product_active=Yes';</script>";
    }    
    
    include "header.php";

    $sql = "SELECT * FROM tdu_products WHERE vendorid='$vendorid' AND productActive='Yes'";
    $result = mysqli_query($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) { 
        ?>
        <h2 style="text-align: center; margin: 20px 0;"><?= $vendorname ?></h2>
        <form action="" method="post">
            <table class="styled-table" style="width: 100%; margin: 20px auto;">
                <thead>
                    <tr>
                        <th></th>
                        <th></th>
                        <th>Product Name</th>
                        <th>Category</th>
                        <th>City</th>
                        <th>Country</th>
                        <th>Start Date<br><input type="date" id="globalStartDate" style="height: 30px;"></th>
                        <th>End Date<br><input type="date" id="globalEndDate" style="height: 30px;"></th>
                        <th>Duration</th>
                        <th>Seats</th>
                        <th>Unit Price</th>
                        <th>Child Price</th>
                        <th>Infant Price</th>
                        <th>Sharing Price</th>
                        <th>Triple Price</th>
                        <th>Child With Bed</th>
                        <th>Child No Bed</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                        <tr id="row-<?php echo $row['productid']; ?>">
                            <td>
                                <button type="button" onclick="deleteProduct('<?php echo $row['productid']; ?>')" style="background-color: red; color: white; border: none; cursor: pointer;"><i class="fa-solid fa-trash-can"></i></button>
                            </td>
                            <td><input type="hidden" name="productid[]" value="<?php echo $row['productid']; ?>"></td>
                            <td><textarea name="productName[]"><?php echo $row['productName']; ?></textarea></td>
                            <td>
                                <select name="category[]" onchange="toggleFields(this)">
                                    <option value="Hotel" <?php echo ($row['category'] == 'Hotel') ? 'selected' : ''; ?>>Hotel</option>
                                    <option value="Restaurant" <?php echo ($row['category'] == 'Restaurant') ? 'selected' : ''; ?>>Restaurant</option>
                                    <option value="Attraction" <?php echo ($row['category'] == 'Attraction') ? 'selected' : ''; ?>>Attraction</option>
                                    <option value="Transfers" <?php echo ($row['category'] == 'Transfers') ? 'selected' : ''; ?>>Transfers</option>
                                    <option value="Guide" <?php echo ($row['category'] == 'Guide') ? 'selected' : ''; ?>>Guide</option>
                                    <option value="Tour" <?php echo ($row['category'] == 'Tour') ? 'selected' : ''; ?>>Tour</option>
                                    <option value="SIC" <?php echo ($row['category'] == 'SIC') ? 'selected' : ''; ?>>SIC</option>
                                </select>
                            </td>
                            <td><input type="text" name="city[]" value="<?php echo $row['city']; ?>"></td>
                            <td>
                                <select name="country[]">
                                    <option value="Australia" <?php echo ($row['country'] == 'Australia') ? 'selected' : ''; ?>>Australia</option>
                                    <option value="New Zealand" <?php echo ($row['country'] == 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                                </select>
                            </td>
                            <td colspan="2"><span class="long-term">Long Term</span><br><input type="date" name="start_date[]" class="start-date" style="height: 30px;"> - <input type="date" name="end_date[]" class="end-date" style="height: 30px;"></td>
                            <td><input type="number" min="0" name="duration[]" value="<?php echo $row['duration']; ?>"></td>
                            <td><input type="number" step="1" min="0" name="seats[]" value="<?php echo $row['seats']; ?>"></td>
                            <td><input type="number" step="0.01" min="0" name="unitPrice[]" value="<?php echo $row['unitPrice']; ?>" class="unit-price"></td>
                            <td><input type="number" step="0.01" min="0" name="childPrice[]" value="<?php echo $row['childPrice']; ?>" class="unit-price"></td>
                            <td><input type="number" step="0.01" min="0" name="infantPrice[]" value="<?php echo $row['infantPrice']; ?>" class="unit-price"></td>
                            <td><input type="number" step="0.01" min="0" name="sharingPrice[]" value="<?php echo $row['sharingPrice']; ?>" class="sharing-price"></td>
                            <td><input type="number" step="0.01" min="0" name="triplePrice[]" value="<?php echo $row['triplePrice']; ?>" class="sharing-price"></td>
                            <td><input type="number" step="0.01" min="0" name="childWithBedPrice[]" value="<?php echo $row['childWithBedPrice']; ?>" class="sharing-price"></td>
                            <td><input type="number" step="0.01" min="0" name="childNoBedPrice[]" value="<?php echo $row['childNoBedPrice']; ?>" class="sharing-price"></td>
                            <td><textarea name="description[]"><?php echo $row['description']; ?></textarea></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <div style="text-align: center; margin: 20px;">
                <input type="submit" value="Save All" style="padding: 10px 20px; font-size: 16px; background-color: #334155; color: white; border: none; cursor: pointer;">
                <button type="button" onclick="history.back()" style="padding: 10px 20px; font-size: 16px; background-color: #334155; color: white; border: none; cursor: pointer;">Cancel</button>
            </div>
        </form>

        <script>
            function deleteProduct(productid) {
                if (confirm('Are you sure you want to delete this product? This action cannot be undone.')) {
                    fetch('ajax_delete_vendor_product.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: new URLSearchParams({ 'productid': productid })
                    })
                    .then(response => response.text())
                    .then(response => {
                        if (response === 'success') {
                            document.getElementById('row-' + productid).remove();
                        } else {
                            alert('Failed to delete product.');
                        }
                    })
                    .catch(() => alert('Error occurred while deleting product.'));
                }
            }
        </script>
    
        <script>
            function checkLongTermText(row) {
                let startDate = row.querySelector(".start-date").value;
                let endDate = row.querySelector(".end-date").value;
                let longTermText = row.querySelector(".long-term");

                if (startDate && endDate) {
                    longTermText.style.display = "none"; // Hide "Long Term"
                } else {
                    longTermText.style.display = "inline"; // Show "Long Term"
                }
            }

            function syncDates(event, className) {
                let newValue = event.target.value; // Get the new date value
                document.querySelectorAll("." + className).forEach(input => {
                    input.value = newValue;
                    let row = input.closest("tr");
                    checkLongTermText(row);
                });
            }

            // Listen for changes in global date inputs
            document.getElementById("globalStartDate").addEventListener("input", function(event) {
                syncDates(event, "start-date");
            });

            document.getElementById("globalEndDate").addEventListener("input", function(event) {
                syncDates(event, "end-date");
            });

            // Attach event listeners to individual start and end date inputs
            document.querySelectorAll(".start-date, .end-date").forEach(input => {
                input.addEventListener("input", function () {
                    let row = this.closest("tr"); // Get the current row
                    checkLongTermText(row);
                });
            });
        </script>
    <?php } else { ?>
        <p style="text-align: center;">No products found.</p>
    <?php } ?>        

    <style>
        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <script>
        function toggleFields(selectElement) {
            var row = selectElement.closest("tr");
            var unitPriceFields = row.querySelectorAll(".unit-price");
            var sharingPriceFields = row.querySelectorAll(".sharing-price");

            if (selectElement.value === "Hotel") {
                unitPriceFields.forEach(field => field.type = "hidden");
                sharingPriceFields.forEach(field => field.type = "number");
            } else {
                unitPriceFields.forEach(field => field.type = "number");
                sharingPriceFields.forEach(field => field.type = "hidden");
            }
        }

        // Run the function on page load to apply changes to existing rows
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll('select[name="category[]"]').forEach(select => {
                toggleFields(select);
            });
        });
    </script>
    <?php
}

// Products
else if (($title=='admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'add-new-products') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_FILES['productImage']) && $_FILES['productImage']['error'] === UPLOAD_ERR_OK) {
            // Ensure the `product_image` folder exists
            $targetDir = "product_image/";
            if (!is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }
        
            // Handle the uploaded file
            $fileName = basename($_FILES['productImage']['name']);
            $targetFilePath = $targetDir . time() . $fileName;
            $uploadOk = 1;
        
            // Validate file type
            $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));
            $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
            if (!in_array($fileType, $allowedTypes)) {
                echo "Only JPG, JPEG, PNG, and GIF files are allowed.";
                $uploadOk = 0;
            }
        
            if ($uploadOk && move_uploaded_file($_FILES['productImage']['tmp_name'], $targetFilePath)) {
                $productImagePath = $conn->real_escape_string($targetFilePath);
            } else {
                echo "File upload failed.";
                exit();
            }
        }
    
        // Sanitize other form inputs
        $productName = $conn->real_escape_string($_POST['productName']);
        $country = $conn->real_escape_string($_POST['country']);
        $productActive = $conn->real_escape_string($_POST['productActive']);
        $category = $conn->real_escape_string($_POST['category']);
        $vendorid = $conn->real_escape_string($_POST['vendorId']);
        $city = $conn->real_escape_string($_POST['city']);
        $unitPrice = $conn->real_escape_string($_POST['unitPrice']);
        $childPrice = $conn->real_escape_string($_POST['childPrice']);
        $infantPrice = $conn->real_escape_string($_POST['infantPrice']);
        $triplePrice = $conn->real_escape_string($_POST['triplePrice']);
        $sharingPrice = $conn->real_escape_string($_POST['sharingPrice']);
        $childWithBedPrice = $conn->real_escape_string($_POST['childWithBedPrice']);
        $childNoBedPrice = $conn->real_escape_string($_POST['childNoBedPrice']);
    
        // Insert query
        $sql = "INSERT INTO tdu_products (productName, country, productActive, category, vendorid, city, 
                                          unitPrice, childPrice, infantPrice, triplePrice, sharingPrice, childWithBedPrice, childNoBedPrice, productImage)
                VALUES ('$productName', '$country', '$productActive', '$category', '$vendorid', '$city',
                        '$unitPrice', '$childPrice', '$infantPrice', '$triplePrice', '$sharingPrice', '$childWithBedPrice', '$childNoBedPrice', '$productImagePath')";
    
        // Execute query
        if ($conn->query($sql) === TRUE) {
            header("Location: quote.php?opt=vendor-details&id=$vendorid");
            exit();
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
    
        // Close connection
        $conn->close();
    }

    include "header.php";
    $vendorid = isset($_GET['vendorid']) ? htmlspecialchars($_GET['vendorid']) : '';
    $vendorname = isset($_GET['vendorname']) ? htmlspecialchars($_GET['vendorname']) : '';
    ?>
    <form method="POST" action="" enctype="multipart/form-data">
        <h2>Product Information</h2>
        <div class="form-row">
            <label for="productName">Product Name:</label>
            <input type="text" id="productName" name="productName" required>
        </div>
        <div class="form-row">
            <label for="country">Country:</label>
            <input type="text" id="country" name="country" required>
        </div>
        <div class="form-row">
            <label for="productActive">Product Active:</label>
            <select id="productActive" name="productActive" required>
                <option value="Yes">Yes</option>
                <option value="No">No</option>
            </select>
        </div>
        <div class="form-row">
            <label for="category">Category:</label>
            <select id="category" name="category" required onchange="togglePricingFields()">
                <option value="">Select</option>
                <option value="Hotel">Hotel</option>
                <option value="Restaurant">Restaurant</option>
                <option value="Attraction">Attraction</option>
                <option value="Transfers">Transfers</option>
                <option value="Guide">Guide</option>
                <option value="Tour">Tour</option>
                <option value="SIC">SIC</option>
            </select>
        </div>
        <div class="form-row">
            <label for="vendorName">Vendor Name:</label>
            <button type="button" id="searchVendorBtn"><i class="fa-solid fa-magnifying-glass"></i></button>
            <input type="hidden" id="vendorId" name="vendorId" value="<?= $vendorid ?>">
            <input type="text" id="vendorName" name="vendorName" required readonly placeholder="Click button left to add vendor" value="<?= $vendorname ?>">
        </div>
        <div class="form-row">
            <label for="city">City:</label>
            <input type="text" id="city" name="city" required>
        </div>
    
        <div id="hotelFields" style="display:none;">
            <h2>Hotel Pricing</h2>
            <div class="form-row">
                <label for="sharingPrice">Double Price:</label>
                <input type="number" id="sharingPrice" name="sharingPrice" step="0.01">
            </div>
            <div class="form-row">
                <label for="triplePrice">Triple Price:</label>
                <input type="number" id="triplePrice" name="triplePrice" step="0.01">
            </div>
            <div class="form-row">
                <label for="childWithBedPrice">Child with Bed Price:</label>
                <input type="number" id="childWithBedPrice" name="childWithBedPrice" step="0.01">
            </div>
            <div class="form-row">
                <label for="childNoBedPrice">Child No Bed Price:</label>
                <input type="number" id="childNoBedPrice" name="childNoBedPrice" step="0.01">
            </div>
        </div>

        <!-- Pricing fields for other categories -->
        <div id="otherFields" style="display:none;">
            <h2>General Pricing</h2>
            <div class="form-row">
                <label for="unitPrice">Unit Price:</label>
                <input type="number" id="unitPrice" name="unitPrice" step="0.01">
            </div>
            <div class="form-row">
                <label for="childPrice">Child Price:</label>
                <input type="number" id="childPrice" name="childPrice" step="0.01">
            </div>
            <div class="form-row">
                <label for="infantPrice">Infant Price:</label>
                <input type="number" id="infantPrice" name="infantPrice" step="0.01">
            </div>
        </div>
    
        <h2>Product Image</h2>
        <div class="form-row">
            <label for="productImage">Product Image:</label>
            <input type="file" id="productImage" name="productImage" accept="image/*">
        </div>
    
        <button type="submit">Submit</button>
    </form>
    <script>
        function togglePricingFields() {
            var category = document.getElementById('category').value;
            
            // Show the fields for Hotel category
            if (category === 'Hotel') {
                document.getElementById('hotelFields').style.display = 'block';
                document.getElementById('otherFields').style.display = 'none';
            } else {
                document.getElementById('hotelFields').style.display = 'none';
                document.getElementById('otherFields').style.display = 'block';
            }
        }
    </script>
    <style>
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin: 20px 0;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
            margin-right: 10px;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>

    <div id="vendorModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" id="closeModal">&times;</span>            
            <table id="vendorResultsTable" class="vendor-results-table">
                <thead>
                    <tr>
                        <td colspan="2"><input type="text" id="searchVendorInput" placeholder="Search by Vendor Name" style="width: 100%; height: 30px;"></td>
                    </tr>
                    <tr>
                        <th>Vendor Name</th>
                        <th>Select</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Show the modal
        document.getElementById('searchVendorBtn').addEventListener('click', function() {
            document.getElementById('vendorModal').style.display = 'block';
        });

        // Close the modal
        document.getElementById('closeModal').addEventListener('click', function() {
            document.getElementById('vendorModal').style.display = 'none';
        });

        // Fetch vendors using AJAX
        document.getElementById('searchVendorInput').addEventListener('input', function() {
            var searchQuery = this.value;
            
            // Use AJAX to search for vendors
            $.ajax({
                url: 'ajax_search_vendors.php',  // Create this PHP file for fetching vendors
                type: 'GET',
                data: { query: searchQuery },
                success: function(response) {
                    var vendors = JSON.parse(response);
                    var vendorTableBody = document.getElementById('vendorResultsTable').getElementsByTagName('tbody')[0];
                    vendorTableBody.innerHTML = '';  // Clear previous results
                    
                    vendors.forEach(function(vendor) {
                        var row = document.createElement('tr');
                        var vendorCell = document.createElement('td');
                        vendorCell.textContent = vendor.vendorName;
                        
                        var selectCell = document.createElement('td');
                        var selectButton = document.createElement('button');
                        selectButton.textContent = 'Select';
                        selectButton.onclick = function() {
                            document.getElementById('vendorName').value = vendor.vendorName;  // Set the Vendor Name field
                            document.getElementById('vendorId').value = vendor.vendorid;  // Set the hidden Vendor ID field
                            document.getElementById('vendorModal').style.display = 'none';  // Close the modal
                        };

                        selectCell.appendChild(selectButton);
                        row.appendChild(vendorCell);
                        row.appendChild(selectCell);
                        vendorTableBody.appendChild(row);
                    });
                }
            });
        });
    </script>
    <style>
        /* Modal Style */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0, 0, 0);
            background-color: rgba(0, 0, 0, 0.4);
            padding-top: 60px;
        }

        .modal-content {
            background-color: #fff;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 600px;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

        .vendor-results-table {
            width: 100%;
            border-collapse: collapse;
        }

        .vendor-results-table th, .vendor-results-table td {
            padding: 8px;
            border: 1px solid #ddd;
        }

        .vendor-results-table th {
            background-color: #f2f2f2;
        }

        .vendor-results-table button {
            padding: 5px 10px;
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }

        .vendor-results-table button:hover {
            background-color: #45a049;
        }

        button {
            color: white;
            background-color: #334155;
            padding: 3px 6px;
            cursor: pointer;
        }
    </style>
    <?php
}
else if (($title=='admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'product-details') {
    include "header.php";
    $productid = $conn->real_escape_string($_GET['productid'] ?? 0);

    $sql = "SELECT 1 FROM tdu_pricebook WHERE productid = '$productid' AND CURDATE() BETWEEN start_date AND end_date";
    $result = mysqli_query($conn, $sql);
    $isWithinDateRange = mysqli_num_rows($result) > 0;

    // Query to fetch product details
    $sql = "SELECT * FROM tdu_products WHERE productid = '$productid'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $product = $result->fetch_assoc();
        $main_vendor = $product['vendorid'];
        ?>
        <div style="padding: 20px; background-color: #c5c5c5;">
            <div>
                <h1 style="text-align: left;">
                    <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                    <?php if($product['productActive'] == 'Yes') { ?>
                        <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                    <?php } else { ?>
                        <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                    <?php } ?>
                    <span id="productName-display"><?php echo htmlspecialchars($product['productName']); ?></span>
                    <input id="productName-edit" style="display: none; width: 80%; height: 40px;" value="<?php echo htmlspecialchars($product['productName']); ?>" />
                </h1>
            </div>
            <div style="display: flex; justify-content: space-between; margin: 0;">
                <!-- Basic Information -->
                <div style="flex: 4; padding-right: 20px;">
                    <h3>Basic Information</h3>
                    <?php if ($product['category'] == 'Transfers') { ?>
                        <p>Car Type: 
                            <span id="subcategory-display"><?php echo htmlspecialchars($product['subcategory']); ?></span>
                            <input id="subcategory-edit" style="display:none;" value="<?php echo htmlspecialchars($product['subcategory']); ?>" />
                        </p>
                    <?php } ?>
                    <p>Category: 
                        <span id="category-display"><?php echo htmlspecialchars($product['category']); ?></span>
                        <select id="category-edit" style="display: none; width: 100%;">
                            <option value="Hotel" <?php echo ($product['category'] === 'Hotel') ? 'selected' : ''; ?>>Hotel</option>
                            <option value="Restaurant" <?php echo ($product['category'] === 'Restaurant') ? 'selected' : ''; ?>>Restaurant</option>
                            <option value="Attraction" <?php echo ($product['category'] === 'Attraction') ? 'selected' : ''; ?>>Attraction</option>
                            <option value="Transfers" <?php echo ($product['category'] === 'Transfers') ? 'selected' : ''; ?>>Transfers</option>
                            <option value="Guide" <?php echo ($product['category'] === 'Guide') ? 'selected' : ''; ?>>Guide</option>
                            <option value="Tour" <?php echo ($product['category'] === 'Tour') ? 'selected' : ''; ?>>Tour</option>
                            <option value="SIC" <?php echo ($product['category'] === 'SIC') ? 'selected' : ''; ?>>SIC</option>
                        </select>
                    </p>
                    <p>City: 
                        <span id="city-display"><?php echo htmlspecialchars($product['city']); ?></span>
                        <input id="city-edit" style="display:none;" value="<?php echo htmlspecialchars($product['city']); ?>" />
                    </p>
                    <p>Country: 
                        <span id="country-display"><?php echo htmlspecialchars($product['country']); ?></span>
                        <input id="country-edit" style="display:none;" value="<?php echo htmlspecialchars($product['country']); ?>" />
                    </p>
                    <p>Keywords: 
                        <span id="keywords-display"><?php echo htmlspecialchars($product['keywords']); ?></span>
                        <input id="keywords-edit" style="display:none;" value="<?php echo htmlspecialchars($product['keywords']); ?>" />
                    </p>
                    <p><?= $product['ai_description'] == 1 ? '<i class="fa-solid fa-robot"></i>' : '' ?> Description: <button id="showMoreBtn" type="button" onclick="toggleDetails()"><i class="fa-solid fa-ellipsis" title="More"></i></button>
                    </p>
                    <p id="descript-details" style="display:none;">
                        <span id="description-display"><?php echo nl2br(htmlspecialchars($product['description'])); ?></span>
                        <textarea id="description-edit" style="display:none;"><?php echo htmlspecialchars($product['description']); ?></textarea>
                    </p>
                    <p>
                        <select id="productActive-edit" style="display:none; width: 100%;">
                            <option value="Yes" <?php echo $product['productActive'] == 'Yes' ? 'selected' : ''; ?>>Active</option>
                            <option value="No" <?php echo $product['productActive'] == 'No' ? 'selected' : ''; ?>>Inactive</option>
                        </select>
                    </p>
                    <p>Child Only: 
                        <span id="childOnly-display"><?php echo $product['childOnly'] == 1 ? 'Yes' : 'No'; ?></span>
                        <input id="childOnly-edit" type="checkbox" style="display:none;" <?php echo ($product['childOnly'] == 1) ? 'checked' : ''; ?> onchange="toggleChildOnlyFields()" />
                    </p>
                    <!-- Child Age Range Fields Wrapped in a Div -->
                    <div id="childOnlyAgeRange" style="display: <?php echo ($product['childOnly'] == 1) ? 'block' : 'none'; ?>;">
                        <p>Child Only Age Range: 
                            <span id="childOnlyAgeMin-display"><?php echo htmlspecialchars($product['childOnlyAgeMin']); ?></span>
                            <input id="childOnlyAgeMin-edit" type="number" style="display:none; width: 50px;" 
                                value="<?php echo htmlspecialchars($product['childOnlyAgeMin']); ?>" />
                            -
                            <span id="childOnlyAgeMax-display"><?php echo htmlspecialchars($product['childOnlyAgeMax']); ?></span>
                            <input id="childOnlyAgeMax-edit" type="number" style="display:none; width: 50px;" 
                                value="<?php echo htmlspecialchars($product['childOnlyAgeMax']); ?>" />
                        </p>
                    </div>
                    <script>
                        function toggleChildOnlyFields() {
                            var isChecked = document.getElementById('childOnly-edit').checked;
                            var childOnlyAgeRange = document.getElementById('childOnlyAgeRange');

                            // Show or hide the age range fields based on the checkbox state
                            childOnlyAgeRange.style.display = isChecked ? 'block' : 'none';
                        }
                    </script>
                    <p>
                        <button type="button" id="editBtn" onclick="toggleEditMode()"><i class="fa-solid fa-pen-to-square"></i></button>
                        <div style="margin-left: 10px; text-align: left;">
                            <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                            <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                        </div>
                    </p>
                </div>
                <div style="flex: 4; padding-right: 20px;">
                    <h3>Non-operation Days</h3>
                    <?php
                    $monthNames = ["1" => "Jan", "2" => "Feb", "3" => "Mar", "4" => "Apr", "5" => "May", "6" => "Jun", "7" => "Jul", "8" => "Aug", "9" => "Sep", "10" => "Oct", "11" => "Nov", "12" => "Dec"];
                    $sql2 = "SELECT * FROM tdu_products_non_operation WHERE productid = '$productid';";
                    $result2 = $conn->query($sql2);
                    while ($row2 = $result2->fetch_assoc()) {
                        if($row2["day_week"] != '') {
                            $period_text = $row2["day_week"];
                        } else {
                            $period_text = $monthNames[$row2["start_m"]] . "-" . $row2["start_d"] . " - " . $monthNames[$row2["end_m"]] . "-" . $row2["end_d"];
                        }
                        ?>
                        <span style="display: inline-block; background-color: #f8d7da; padding: 5px 10px; margin: 2px; border-radius: 10px; position: relative;">
                            <?php echo $period_text; ?>
                            <button onclick="deleteNonOperationRow(<?php echo $row2['auto_id']; ?>)" style="border: none; background: none; color: red; font-weight: bold; position: absolute; top: -5px; right: -5px; cursor: pointer;"><i class="fa-solid fa-xmark"></i></button>
                        </span>
                        <?php
                    }
                    ?>
                    <button id="openModalButton" style="padding: 5px 10px; margin: 2px; border-radius: 10px; background-color: #f8d7da; border: none; color: black;">
                        <i class="fa-solid fa-plus"></i>
                    </button>
                </div>
                <div style="flex: 8; padding-right: 20px;">
                    <h3>Product Image</h3>
                    <?php if (!empty($product['productImage'])) { ?>
                        <img src="<?php echo htmlspecialchars($product['productImage']); ?>" alt="Product Image" style="max-width: 25%;">
                    <?php } ?>
                    <input type="file" id="productImageInput" accept="image/*">
                    <button type="button" onclick="uploadProductImage()">Upload Image</button>
                </div>

                <?php if ($isWithinDateRange) : ?>
                    <div style="flex: 2; padding-right: 20px;">
                        <h3 style="text-align: center;">
                            <i class="fa-solid fa-money-check-dollar" style="font-size: 200px;"></i><br>
                            Price UP-TO-DATE
                        </h3>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <script>
            function toggleDetails() {
                var details = document.getElementById('descript-details');
                var button = document.getElementById('showMoreBtn');

                if (details.style.display === 'none') {
                    details.style.display = 'block';
                } else {
                    details.style.display = 'none';
                }
            }

            function cancelEdit() {
                document.querySelectorAll('span[id$="-display"]').forEach(el => {
                    el.style.display = 'inline';
                });
                document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => {
                    el.style.display = 'none';
                });

                document.getElementById('editBtn').style.display = 'inline';
                document.getElementById('saveBtn').style.display = 'none';
                document.getElementById('cancelBtn').style.display = 'none';
            }

            function toggleEditMode() {
                document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
                document.querySelectorAll('input[id$="-edit"], textarea[id$="-edit"], select[id$="-edit"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');

                document.getElementById('editBtn').style.display = document.getElementById('editBtn').style.display === 'none' ? 'inline' : 'none';
                document.getElementById('saveBtn').style.display = document.getElementById('saveBtn').style.display === 'none' ? 'inline' : 'none';
                document.getElementById('cancelBtn').style.display = document.getElementById('cancelBtn').style.display === 'none' ? 'inline' : 'none';
            }

            function saveChanges() {
                const childOnly = document.getElementById('childOnly-edit').checked ? 1 : 0;
                const data = {
                    productName: document.getElementById('productName-edit').value,
                    category: document.getElementById('category-edit').value,
                    city: document.getElementById('city-edit').value,
                    country: document.getElementById('country-edit').value,
                    description: document.getElementById('description-edit').value,
                    keywords: document.getElementById('keywords-edit').value,
                    productActive: document.getElementById('productActive-edit')?.value,
                    childOnly: childOnly,
                    productID: <?php echo $productid; ?>
                };

                // Only include age range fields if childOnly is enabled
                if (childOnly === 1) {
                    data.childOnlyAgeMin = document.getElementById('childOnlyAgeMin-edit').value;
                    data.childOnlyAgeMax = document.getElementById('childOnlyAgeMax-edit').value;
                }

                // Send the data to the server
                fetch('ajax_update_product_details.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(data),
                })
                .then(response => response.json())
                .then(result => {
                    if (result.success) {
                        window.location.reload();
                    } else {
                        alert('Failed to update product information.');
                    }
                })
                .catch(error => console.error('Error:', error));
            }
        </script>
        <script>
            function deleteNonOperationRow(autoId) {
                if (!confirm("Are you sure you want to delete this non-operation day?")) {
                    return;
                }

                // Send AJAX request
                fetch('ajax_delete_non_operation.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: 'auto_id=' + autoId
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("Deleted successfully!");
                        location.reload(); // Refresh the page to update UI
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error("Error:", error);
                    alert("Something went wrong!");
                });
            }
        </script>
        <style>
            input, select, textarea {
                width: 100%;
                height: 30px;
                margin: 0;
            }
        </style>

        <div id="addNonOperationModal" style="display: none; position: fixed; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
            <div style="background: white; margin: 10% auto; padding: 20px; width: 30%; text-align: left; position: relative;">

                <label>Type: <br>
                    <select id="nonOperationType" onchange="toggleNonOperationFields()" style="width: 100%; padding: 5px;">
                        <option value="date_range">Date Range</option>
                        <option value="day_of_week">Day of Week</option>
                    </select>
                </label><br>

                <div id="dateRangeFields">
                    <label>Start Date: <br>
                        <select id="start_month" onchange="updateDays('start_month', 'start_day')" style="width: 48%; padding: 5px;">
                            <option value=""></option>
                            <option value="01">January</option>
                            <option value="02">February</option>
                            <option value="03">March</option>
                            <option value="04">April</option>
                            <option value="05">May</option>
                            <option value="06">June</option>
                            <option value="07">July</option>
                            <option value="08">August</option>
                            <option value="09">September</option>
                            <option value="10">October</option>
                            <option value="11">November</option>
                            <option value="12">December</option>
                        </select> -
                        <select id="start_day" style="width: 48%; padding: 5px;"></select>
                    </label><br>

                    <label>End Date: <br>
                        <select id="end_month" onchange="updateDays('end_month', 'end_day')" style="width: 48%; padding: 5px;">
                            <option value=""></option>
                            <option value="01">January</option>
                            <option value="02">February</option>
                            <option value="03">March</option>
                            <option value="04">April</option>
                            <option value="05">May</option>
                            <option value="06">June</option>
                            <option value="07">July</option>
                            <option value="08">August</option>
                            <option value="09">September</option>
                            <option value="10">October</option>
                            <option value="11">November</option>
                            <option value="12">December</option>
                        </select> -
                        <select id="end_day" style="width: 48%; padding: 5px;"></select>
                    </label><br>
                </div>

                <div id="dayOfWeekField" style="display: none;">
                    <label>Day of Week: <br>
                        <select id="day_of_week" style="width: 100%; padding: 5px;">
                            <option value="">Select Day</option>
                            <option value="Monday">Monday</option>
                            <option value="Tuesday">Tuesday</option>
                            <option value="Wednesday">Wednesday</option>
                            <option value="Thursday">Thursday</option>
                            <option value="Friday">Friday</option>
                            <option value="Saturday">Saturday</option>
                            <option value="Sunday">Sunday</option>
                        </select>
                    </label><br>
                </div>

                <button onclick="saveNonOperationDay()" style="padding: 8px 15px; background-color: #334155; color: white; border: none; border-radius: 5px; cursor: pointer;">Save</button>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                const addNonOperationModal = document.getElementById("addNonOperationModal");
                const openModalButton = document.getElementById("openModalButton"); // Plus button

                openModalButton.addEventListener("click", function () {
                    addNonOperationModal.style.display = "block";
                });

                window.addEventListener("click", function (event) {
                    if (event.target === addNonOperationModal) {
                        addNonOperationModal.style.display = "none";
                    }
                });

                // Initialize days for default view
                updateDays('start_month', 'start_day');
                updateDays('end_month', 'end_day');
            });

            function toggleNonOperationFields() {
                const type = document.getElementById('nonOperationType').value;
                const dateRangeFields = document.getElementById('dateRangeFields');
                const dayOfWeekField = document.getElementById('dayOfWeekField');

                if (type === 'date_range') {
                    dateRangeFields.style.display = 'block';
                    dayOfWeekField.style.display = 'none';
                } else {
                    dateRangeFields.style.display = 'none';
                    dayOfWeekField.style.display = 'block';
                }
            }

            function updateDays(monthSelectId, daySelectId) {
                const monthSelect = document.getElementById(monthSelectId);
                const daySelect = document.getElementById(daySelectId);
                const month = monthSelect.value;
                
                const daysInMonth = {
                    "01": 31, "02": 29, "03": 31, "04": 30,
                    "05": 31, "06": 30, "07": 31, "08": 31,
                    "09": 30, "10": 31, "11": 30, "12": 31
                };
                
                daySelect.innerHTML = "";
                for (let i = 1; i <= daysInMonth[month]; i++) {
                    let option = document.createElement("option");
                    option.value = i < 10 ? "0" + i : i;
                    option.textContent = i;
                    daySelect.appendChild(option);
                }
            }

            function saveNonOperationDay() {
                let productid = <?= $productid ?>;
                let type = document.getElementById("nonOperationType").value;

                let data = `productid=${productid}&type=${type}`;

                if (type === 'date_range') {
                    let startMonth = document.getElementById("start_month").value;
                    let startDay = document.getElementById("start_day").value;
                    let endMonth = document.getElementById("end_month").value;
                    let endDay = document.getElementById("end_day").value;

                    if (!startMonth || !startDay || !endMonth || !endDay) {
                        alert("Please select all date fields.");
                        return;
                    }

                    data += `&start_m=${startMonth}&start_d=${startDay}&end_m=${endMonth}&end_d=${endDay}`;
                } else if (type === 'day_of_week') {
                    let dayOfWeek = document.getElementById("day_of_week").value;
                    if (!dayOfWeek) {
                        alert("Please select a day of the week.");
                        return;
                    }
                    data += `&day_of_week=${dayOfWeek}`;
                }

                fetch("ajax_save_non_operation.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    body: data
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert("Saved successfully!");
                        location.reload();
                    } else {
                        alert("Error: " + data.message);
                    }
                })
                .catch(error => {
                    console.error("Error:", error);
                    alert("Something went wrong!");
                });
            }
        </script>

        <!-- upload Product Image function -->
        <script>
            function uploadProductImage() {
                const fileInput = document.getElementById('productImageInput');
                const file = fileInput.files[0];

                if (!file) {
                    alert('Please select an image to upload.');
                    return;
                }

                const formData = new FormData();
                formData.append('productImage', file);
                formData.append('productid', '<?php echo $productid; ?>');

                fetch('ajax_upload_product_image.php', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        alert('Image uploaded successfully!');
                        window.location.reload();
                    } else {
                        alert(data.message || 'Upload failed.');
                    }
                })
                .catch(err => {
                    console.error('Upload error:', err);
                    alert('An error occurred.');
                });
            }
        </script>
        <?php
    } else {
        echo "<p>Product not found.</p>";
    }
    ?>
    <div class="button-container">
        <button type="button" onclick="showDiv('div-pro5', this)">Price</button>
        <button type="button" onclick="showDiv('div-pro7', this)" style="display: none;">Vendors</button>
        <button type="button" onclick="showDiv('div-pro1', this)">PriceBook</button>
        <button type="button" onclick="showDiv('div-pro2', this)">Associated Products</button>
        <button type="button" onclick="showDiv('div-pro3', this)">Suggested Products</button>
        <button type="button" onclick="showDiv('div-pro6', this)">Non-Allowed Products</button>
        <button type="button" onclick="showDiv('div-pro4', this)" style="display: none;">Sub Products</button>
        <button type="button" onclick="showDiv('div-pro8', this)">FAQ</button>
        <?php if ($title == 'admin') : ?>
        <button type="button" onclick="showDiv('div-pro9', this)">Replace in Template</button>
        <?php endif; ?>
    </div>

    <div id="div-pro5" class="content-div" style="margin: 20px;">
        <h3>Pricing Information</h3>
        <?php if ($product['category'] == 'Hotel') { ?>
            <!-- Display Mode -->
            <div id="display-mode">
                <table style="width: 30%; border-collapse: collapse; border: 1px solid #ddd; margin: 10px;">
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Double Price:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="sharingPrice-display"><?= ($product['sharingPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['sharingPrice']); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Triple Price:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="triplePrice-display"><?= ($product['triplePrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['triplePrice']); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Child with Bed:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="childWithBedPrice-display"><?= ($product['childWithBedPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['childWithBedPrice']); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Child without Bed:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="childNoBedPrice-display"><?= ($product['childNoBedPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['childNoBedPrice']); ?></span>
                        </td>
                    </tr>
                </table>
                <button type="button" onclick="toggleEditMode2()" style="margin: 0 10px;">Edit</button>
            </div>

            <!-- Edit Mode -->
            <form id="edit-mode" style="display: none; margin: 20px;">
                <input type="hidden" id="product_id" name="product_id" value="<?php echo $productid; ?>">
                <div class="form-column">
                    <table style="width: 30%; border-collapse: collapse; border: 1px solid #ddd; margin: 10px;">
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Double Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="sharingPrice" name="sharingPrice" value="<?php echo htmlspecialchars($product['sharingPrice']); ?>" required>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Triple Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="triplePrice" name="triplePrice" value="<?php echo htmlspecialchars($product['triplePrice']); ?>">
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Child with Bed Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="childWithBedPrice" name="childWithBedPrice" value="<?php echo htmlspecialchars($product['childWithBedPrice']); ?>">
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Child without Bed Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="childNoBedPrice" name="childNoBedPrice" value="<?php echo htmlspecialchars($product['childNoBedPrice']); ?>">
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="form-column">
                    <button type="button" onclick="updatePricing()">Update Pricing</button>
                    <button type="button" onclick="toggleEditMode2()">Cancel</button>
                </div>
            </form>
        <?php } else { ?>
            <!-- Display Mode -->
            <div id="display-mode">
                <table style="width: 30%; border-collapse: collapse; border: 1px solid #ddd; margin: 10px;">
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Unit Price:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="unitPrice-display"><?= ($product['unitPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['unitPrice']); ?></span>
                        </td>
                    </tr>
                    <?php if ($product['category'] != 'Transfers' && $product['category'] != 'Guide') { ?>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Child Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <span id="childPrice-display"><?= ($product['childPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['childPrice']); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Child Age Range:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <span id="childAge-display"><?php echo htmlspecialchars($product['childAge']); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Infant Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <span id="infantPrice-display"><?= ($product['infantPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['infantPrice']); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Family Price (2 Adult+2 Child):</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <span id="familyPrice-display"><?= ($product['familyPrice'] != '') ? '$' : '' ?> <?php echo htmlspecialchars($product['familyPrice']); ?></span>
                            </td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td style="padding: 10px; border: 1px solid #ddd;">Duration:</td>
                        <td style="padding: 10px; border: 1px solid #ddd;">
                            <span id="duration-display"><?php echo htmlspecialchars($product['duration'] ?? 0); ?> <?= $product['duration'] == '' ? '' : 'Hours' ?></span>
                        </td>
                    </tr>
                    <?php if ($product['category'] == 'Transfers') { ?>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Number of Seats:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <span id="seats-display"><?php echo htmlspecialchars($product['seats']); ?></span>
                            </td>
                        </tr>
                    <?php } ?>
                </table>
                <button type="button" onclick="toggleEditMode2()" style="margin: 0 10px;">Edit</button>
            </div>

            <!-- Edit Mode -->
            <form id="edit-mode" style="display: none; margin: 20px;">
                <input type="hidden" id="product_id" name="product_id" value="<?php echo $productid; ?>">
                <div class="form-column">
                    <table style="width: 30%; border-collapse: collapse; border: 1px solid #ddd; margin: 10px;">
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Unit Price:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="unitPrice" name="unitPrice" value="<?php echo htmlspecialchars($product['unitPrice']); ?>" required>
                            </td>
                        </tr>
                        <?php if ($product['category'] != 'Transfers' && $product['category'] != 'Guide') { ?>
                            <tr>
                                <td style="padding: 10px; border: 1px solid #ddd;">Child Price:</td>
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <input type="text" id="childPrice" name="childPrice" value="<?php echo htmlspecialchars($product['childPrice']); ?>">
                                </td>
                            </tr>
                            <?php
                            list($childAgeMin, $childAgeMax) = explode('-', $product['childAge']);
                            list($infantAgeMin, $infantAgeMax) = explode('-', $product['infantAge']);
                            ?>
                            <tr>
                                <td style="padding: 10px; border: 1px solid #ddd;">Child Age Range:</td>
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <input type="text" id="childAgeMin" name="childAgeMin" value="<?php echo htmlspecialchars($childAgeMin); ?>" style="width: 100px;"> -  
                                    <input type="text" id="childAgeMax" name="childAgeMax" value="<?php echo htmlspecialchars($childAgeMax); ?>" style="width: 100px;">
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border: 1px solid #ddd;">Infant Price:</td>
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <input type="text" id="infantPrice" name="infantPrice" value="<?php echo htmlspecialchars($product['infantPrice']); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 10px; border: 1px solid #ddd;">Family Price (2 Adult+2 Child):</td>
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <input type="text" id="familyPrice" name="familyPrice" value="<?php echo htmlspecialchars($product['familyPrice']); ?>">
                                </td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td style="padding: 10px; border: 1px solid #ddd;">Duration:</td>
                            <td style="padding: 10px; border: 1px solid #ddd;">
                                <input type="text" id="duration" name="duration" value="<?php echo htmlspecialchars($product['duration']); ?>">
                            </td>
                        </tr>
                        <?php if ($product['category'] == 'Transfers') { ?>
                            <tr>
                                <td style="padding: 10px; border: 1px solid #ddd;">Number of Seats:</td>
                                <td style="padding: 10px; border: 1px solid #ddd;">
                                    <input type="text" id="seats" name="seats" value="<?php echo htmlspecialchars($product['seats']); ?>">
                                </td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <div class="form-column">
                    <button type="button" onclick="updatePricing()">Update Pricing</button>
                    <button type="button" onclick="toggleEditMode2()">Cancel</button>
                </div>
            </form>
        <?php } ?>
    </div>
    <script>
        function toggleEditMode2() {
            var displayMode = document.getElementById("display-mode");
            var editMode = document.getElementById("edit-mode");

            if (displayMode.style.display === "none") {
                displayMode.style.display = "block";
                editMode.style.display = "none";
            } else {
                displayMode.style.display = "none";
                editMode.style.display = "block";
            }
        }

        function updatePricing() {
            var product_id = document.getElementById("product_id").value;
            var unitPrice = document.getElementById("unitPrice") ? document.getElementById("unitPrice").value : null;
            var childPrice = document.getElementById("childPrice") ? document.getElementById("childPrice").value : null;
            var infantPrice = document.getElementById("infantPrice") ? document.getElementById("infantPrice").value : null;
            var familyPrice = document.getElementById("familyPrice") ? document.getElementById("familyPrice").value : null; // Added familyPrice
            var duration = document.getElementById("duration") ? document.getElementById("duration").value : null;
            var seats = document.getElementById("seats") ? document.getElementById("seats").value : null;
            var sharingPrice = document.getElementById("sharingPrice") ? document.getElementById("sharingPrice").value : null;
            var triplePrice = document.getElementById("triplePrice") ? document.getElementById("triplePrice").value : null;
            var childWithBedPrice = document.getElementById("childWithBedPrice") ? document.getElementById("childWithBedPrice").value : null;
            var childNoBedPrice = document.getElementById("childNoBedPrice") ? document.getElementById("childNoBedPrice").value : null;

            var formData = new FormData();
            formData.append("product_id", product_id);
            if (unitPrice) formData.append("unitPrice", unitPrice);
            if (childPrice) formData.append("childPrice", childPrice);
            if (infantPrice) formData.append("infantPrice", infantPrice);
            if (familyPrice) formData.append("familyPrice", familyPrice);
            if (duration) formData.append("duration", duration);
            if (seats) formData.append("seats", seats);
            if (sharingPrice) formData.append("sharingPrice", sharingPrice);
            if (triplePrice) formData.append("triplePrice", triplePrice);
            if (childWithBedPrice) formData.append("childWithBedPrice", childWithBedPrice);
            if (childNoBedPrice) formData.append("childNoBedPrice", childNoBedPrice);

            var childAgeMin = document.getElementById("childAgeMin") ? document.getElementById("childAgeMin").value : "";
            var childAgeMax = document.getElementById("childAgeMax") ? document.getElementById("childAgeMax").value : "";
            var infantAgeMin = document.getElementById("infantAgeMin") ? document.getElementById("infantAgeMin").value : "";
            var infantAgeMax = document.getElementById("infantAgeMax") ? document.getElementById("infantAgeMax").value : "";

            var childAge = (childAgeMin !== "" && childAgeMax !== "") ? childAgeMin + "-" + childAgeMax : "";
            var infantAge = (infantAgeMin !== "" && infantAgeMax !== "") ? infantAgeMin + "-" + infantAgeMax : "";

            formData.append("childAge", childAge);
            formData.append("infantAge", infantAge);

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_update_product_pricing.php", true);

            xhr.onload = function () {
                if (xhr.status === 200) {
                    if (xhr.responseText.includes("SUCCESS")) {
                        alert("Pricing updated successfully!");
                        const currentUrl = new URL(window.location.href);
                        currentUrl.searchParams.set('edit', 'product-price');
                        window.location.href = currentUrl;
                    } else {
                        alert("Error updating pricing: " + xhr.responseText);
                    }
                } else {
                    alert("An error occurred while updating.");
                }
            };

            xhr.send(formData);
        }
    </script>

    <!-- PriceBook -->
    <div id="div-pro1" class="content-div">
        <table class="styled-table" style="width: 100%;">
            <tr>
                <th style="width: 8%;"><button id="openPricebookModalNew">+</button></th>
                <th>Name</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Day of Week</th>
                <?php
                if($product['category'] == 'Hotel') {
                    ?>
                    <th>Double Price</th>
                    <th>Triple Price</th>
                    <th>Child with Bed Price</th>
                    <th>Child No Bed Price</th>
                    <?php
                } else {
                    ?>
                    <th>Unit Price</th>
                    <th>Child Price</th>
                    <th>Infant Price</th>
                    <?php
                }
                ?>
                <th>Active</th>
            </tr>
            <?php
            $sql = "SELECT auto_id, name, start_date, end_date, unit_price, child_price, infant_price, 
                        sharing_price, triple_price, child_with_bed_price, child_no_bed_price, 
                        currency, active, dayOfWeek
                    FROM tdu_pricebook 
                    WHERE productid = $productid";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    if($row['dayOfWeek'] == '') {
                        echo "<td>
                        <button class='openPricebookModal' data-name='" . htmlspecialchars($row['name']) . "' data-start_date='" . htmlspecialchars($row['start_date']) . "' data-end_date='" . htmlspecialchars($row['end_date']) . "'>+</button>
                        <button class='delete-pricebook-rule' data-id='" . htmlspecialchars($row['auto_id']) . "' style='background-color: red; color: white;'><i class='fa-solid fa-trash-can'></i></button>
                        </td>";
                    } else {
                        echo "<td><button class='delete-pricebook-rule' data-id='" . htmlspecialchars($row['auto_id']) . "' style='background-color: red;'><i class='fa-solid fa-trash-can'></i></button></td>";
                    }
                    echo "<td>" . htmlspecialchars($row['name']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['start_date']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['end_date']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['dayOfWeek'] == '' ? 'Whole Week' : $row['dayOfWeek']) . "</td>";
                    if($product['category'] != 'Hotel') {
                        echo "<td>" . htmlspecialchars($row['unit_price']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['child_price']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['infant_price']) . "</td>";
                    } else {
                        echo "<td>" . htmlspecialchars($row['sharing_price']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['triple_price']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['child_with_bed_price']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['child_no_bed_price']) . "</td>";
                    }
                    echo "<td>" . htmlspecialchars($row['active']) . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='10'>No records found</td></tr>";
            }
            ?>
        </table>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function() {
                // Handle delete button click
                $(".delete-pricebook-rule").click(function() {
                    var rowId = $(this).data("id");
                    
                    if (confirm("Are you sure you want to delete this pricebook rule?")) {
                        $.ajax({
                            url: "ajax_delete_pricebook_rule.php",
                            type: "POST",
                            data: { id: rowId },
                            success: function(response) {
                                if(response == "success") {
                                    alert("Pricebook rule deleted successfully.");
                                    location.reload();
                                } else {
                                    alert("Failed to delete pricebook rule.");
                                }
                            },
                            error: function() {
                                alert("An error occurred.");
                            }
                        });
                    }
                });
            });
        </script>

        <div id="pricebookModal" class="modal" style="display:none;">
            <div class="modal-content">
                <span id="closeModal" class="close">&times;</span>
                <h2 style="text-align: center;">Add New Pricebook</h2>
                <form id="pricebookForm" action="ajax_handle_pricebook.php" method="POST">
                    <input type="hidden" name="productid" value="<?php echo $productid; ?>">
                    <div>
                        <label for="name">Name:</label>
                        <input type="text" name="name" id="name" style="width: 100%;" required>
                    </div>
                    <div>
                        <label for="start_date">Start Date:</label>
                        <input type="date" name="start_date" id="modalStartDate" required>
                    </div>
                    <div>
                        <label for="end_date">End Date:</label>
                        <input type="date" name="end_date" id="modalEndDate" required>
                    </div>
                    <div>
                        <label for="dayOfWeek">Day of Week:</label>
                        <select name="dayOfWeek" id="dayOfWeek">
                            <option value="Monday">Monday</option>
                            <option value="Tuesday">Tuesday</option>
                            <option value="Wednesday">Wednesday</option>
                            <option value="Thursday">Thursday</option>
                            <option value="Friday">Friday</option>
                            <option value="Saturday">Saturday</option>
                            <option value="Sunday">Sunday</option>
                        </select>
                    </div>
                    <div>
                        <label for="currency">Currency:</label>
                        <select name="currency" id="currency" required>
                            <option value="AUD">AUD</option>
                            <option value="NZD">NZD</option>
                        </select>
                    </div>
                    <?php
                    if($product['category'] == 'Hotel') {
                        ?>
                        <div>
                            <label for="sharingPrice">Double Price:</label>
                            <input type="number" style="width: 100%;" name="sharingPrice" id="sharingPrice" step="0.01">
                        </div>
                        <div>
                            <label for="triplePrice">Triple Price:</label>
                            <input type="number" style="width: 100%;" name="triplePrice" id="triplePrice" step="0.01">
                        </div>
                        <div>
                            <label for="childWithBedPrice">Child with Bed Price:</label>
                            <input type="number" style="width: 100%;" name="childWithBedPrice" id="childWithBedPrice" step="0.01">
                        </div>
                        <div>
                            <label for="childNoBedPrice">Child No Bed Price:</label>
                            <input type="number" style="width: 100%;" name="childNoBedPrice" id="childNoBedPrice" step="0.01">
                        </div>
                        <?php
                    } else {
                        ?>
                        <div>
                            <label for="unitPrice">Unit Price:</label>
                            <input type="number" style="width: 100%;" name="unitPrice" id="unitPrice" step="0.01">
                        </div>
                        <div>
                            <label for="childPrice">Child Price:</label>
                            <input type="number" style="width: 100%;" name="childPrice" id="childPrice" step="0.01">
                        </div>
                        <div>
                            <label for="infantPrice">Infant Price:</label>
                            <input type="number" style="width: 100%;" name="infantPrice" id="infantPrice" step="0.01">
                        </div>
                        <?php
                    }
                    ?>                
                    <div>
                        <label for="active">Active:</label>
                        <select name="active" id="active" required>
                            <option value="Yes">Yes</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success">Submit</button>
                </form>
            </div>
        </div>
        <style>
            .modal {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
                display: none;
                justify-content: center;
                align-items: center;
            }
            .modal-content {
                background: white;
                padding: 20px;
                border-radius: 8px;
                width: 30%;
                text-align: left;
            }
            .close {
                float: right;
                cursor: pointer;
                font-size: 20px;
            }
            .modal-content input, .modal-content select {
                width: 100%;
                height: 30px;
            }
            .modal-content textarea {
                width: 100%;
                height: 90px;
            }
        </style>
        <script>
            document.getElementById('openPricebookModalNew').addEventListener('click', function () {
                document.getElementById('dayOfWeek').parentElement.style.display = 'none';
                document.getElementById('dayOfWeek').value = '';

                // Set modal fields
                document.getElementById('name').value = '';
                document.getElementById('modalStartDate').value = '';
                document.getElementById('modalEndDate').value = '';
                
                // Remove readonly attributes if they exist
                document.getElementById('name').removeAttribute('readonly');
                document.getElementById('modalStartDate').removeAttribute('readonly');
                document.getElementById('modalEndDate').removeAttribute('readonly');
                
                document.getElementById('pricebookModal').style.display = 'flex';
            });

            document.querySelectorAll('.openPricebookModal').forEach(function(button) {
                button.addEventListener('click', function() {
                    document.getElementById('dayOfWeek').parentElement.style.display = 'block';

                    // Get data from the clicked row
                    const name = this.getAttribute('data-name');
                    const startDate = this.getAttribute('data-start_date');
                    const endDate = this.getAttribute('data-end_date');

                    // Set modal fields
                    const nameInput = document.getElementById('name');
                    const startDateInput = document.getElementById('modalStartDate');
                    const endDateInput = document.getElementById('modalEndDate');

                    nameInput.value = name;
                    startDateInput.value = startDate;
                    endDateInput.value = endDate;

                    // Make the inputs read-only
                    nameInput.setAttribute('readonly', true);
                    startDateInput.setAttribute('readonly', true);
                    endDateInput.setAttribute('readonly', true);

                    // Show the modal
                    document.getElementById('pricebookModal').style.display = 'flex';
                });
            });

            document.getElementById('closeModal').addEventListener('click', function () {
                document.getElementById('pricebookModal').style.display = 'none';
            });

            // Optional: Close modal when clicking outside the content
            window.addEventListener('click', function (event) {
                if (event.target === document.getElementById('pricebookModal')) {
                    document.getElementById('pricebookModal').style.display = 'none';
                }
            });
        </script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            $(document).ready(function () {
                $("#pricebookForm").on("submit", function (e) {
                    e.preventDefault();
                    var formData = $(this).serialize();

                    $.ajax({
                        url: $(this).attr('action'),
                        type: 'POST',
                        data: formData,
                        success: function (response) {
                            alert('Pricebook added successfully!');
                            console.log(response);
                            $('#pricebookModal').hide();
                            $('#pricebookForm')[0].reset();
                            const currentUrl = new URL(window.location.href); // Get the current URL
                            currentUrl.searchParams.set('edit', 'pricebook'); // Add or update the parameter
                            window.location.href = currentUrl; // Navigate to the updated URL
                        },
                        error: function (xhr, status, error) {
                            alert('An error occurred: ' + error);
                        }
                    });
                });
            });
        </script>
    </div>
    
    <div id="modal-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999;"></div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Associated Products -->
    <div id="div-pro2" class="content-div">
        <table class="styled-table" style="width: 100%;">
            <tr>
                <th><button id="add-product-btn">+</button></th>
                <th style="text-align: left;">Product Name</th>
                <th style="text-align: left;">Vendor Name</th>
                <th style="text-align: left;">Category</th>
                <th style="text-align: left;">City</th>
                <th style="text-align: left;">Keywords</th>
            </tr>
            <?php
            $sql = "SELECT p.productName, v.vendorName, p.category, p.city, p.keywords, a.associated
                    FROM tdu_products_associated a
                    LEFT JOIN tdu_products p ON a.associated = p.productid
                    LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                    WHERE a.productid = $productid";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td><button class='delete-associate-btn' style='border: unset; background-color: unset;' data-associated='" . htmlspecialchars($row['associated']) . "'><i class='fa-solid fa-trash-can' style='color: red;'></i></button></td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['productName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['vendorName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['category']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['city']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['keywords']) . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6'>No records found</td></tr>";
            }
            ?>
        </table>
    </div>
    <div id="associated-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <div id="modal-content">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Associated Products</h2>
                <button id="close-modal-associated" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <table id="modal-table-associated" class="styled-table" style="width: 100%;">
                <thead>
                    <tr>
                        <th style='text-align: left;'>Product Name</th>
                        <th style='text-align: left;'>Vendor Name</th>
                        <th style='text-align: left;'>Category</th>
                        <th style='text-align: left;'>City</th>
                        <th style='text-align: left;'>Keywords</th>
                        <th style='text-align: left;'></th>
                    </tr>
                    <tr>
                        <td><input type="text" id="filter-productname" name="productname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-vendorname" name="vendorname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-category" name="category" style="width: 100%;"></td>
                        <td><input type="text" id="filter-city" name="city" style="width: 100%;"></td>
                        <td colspan="2"><button type="button" id="apply-filters" style="padding: 5px 10px; width: 100%;">Search</button></td>
                    </tr>
                </thead>
                <tbody id="associated-products-table">
                    <!-- Content will be populated via AJAX -->
                </tbody>
                <tr>
                    <td colspan="6">
                        <button id="load-more" style="padding: 10px; display: none; margin: auto;">Load More</button>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        // Show the modal
        document.getElementById('add-product-btn').addEventListener('click', function () {
            // Display the modal and overlay
            document.getElementById('associated-modal').style.display = 'block';
            document.getElementById('modal-overlay').style.display = 'block';

            // Fetch initial content
            fetchFilteredData();
        });

        // Close the modal
        document.getElementById('close-modal-associated').addEventListener('click', function () {
            document.getElementById('associated-modal').style.display = 'none';
            document.getElementById('modal-overlay').style.display = 'none';
            const currentUrl = new URL(window.location.href); // Get the current URL
            currentUrl.searchParams.set('edit', 'associated-products'); // Add or update the parameter
            window.location.href = currentUrl; // Navigate to the updated URL
        });

        // Apply filters
        document.getElementById('apply-filters').addEventListener('click', function () {
            fetchFilteredData();
        });

        let currentPage = 1;
        function fetchFilteredData(loadMore = false) {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname').value;
            const vendorname = document.getElementById('filter-vendorname').value;
            const category = document.getElementById('filter-category').value;
            const city = document.getElementById('filter-city').value;

            // Increment the page count if loading more
            if (loadMore) {
                currentPage++;
            } else {
                currentPage = 1; // Reset to the first page
            }

            // Build query parameters
            const params = new URLSearchParams({productname, vendorname, category, city, page: currentPage, productid});

            // Fetch filtered data using AJAX
            fetch('ajax_fetch_associated_products.php?' + params.toString())
                .then(response => response.text())
                .then(data => {
                    const tableBody = document.querySelector('#modal-table-associated tbody');

                    if (loadMore) {
                        tableBody.insertAdjacentHTML('beforeend', data); // Append new rows
                    } else {
                        tableBody.innerHTML = data; // Replace rows
                    }

                    // Show or hide "Load More" button based on the response
                    if (data.trim() === '' || data.includes('No More records')) {
                        document.getElementById('load-more').style.display = 'none';
                    } else {
                        document.getElementById('load-more').style.display = 'block';
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Add event listener for "Load More" button
        document.getElementById('load-more').addEventListener('click', function () {
            fetchFilteredData(true);
        });
    </script>
    <script>
        $(document).on('click', '.associate-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const associated = $(this).data('productid');
            const row = $(this).closest('tr');

            $.ajax({
                url: 'ajax_associated_products.php',
                method: 'POST',
                data: { productid: productid, associated: associated },
                success: function (response) {
                    const result = JSON.parse(response);
                    if (result.status === 'success') {
                        fetchTableDataAssociated();
                    } else {
                        alert(result.message || 'Failed to associate the product.');
                    }
                },
                error: function () {
                    alert('An error occurred while associating the product.');
                }
            });
        });

        $(document).on('click', '.delete-associate-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const associated = $(this).data('associated');
            const row = $(this).closest('tr');

            if (confirm('Are you sure you want to delete this product?')) {
                $.ajax({
                    url: 'ajax_delete_associated_product.php',
                    method: 'POST',
                    data: { productid: productid, associated: associated },
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.status === 'success') {
                            row.remove();
                        } else {
                            alert(result.message || 'Failed to delete the product.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while deleting the product.');
                    }
                });
            }
        });

        function fetchTableDataAssociated() {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname').value;
            const vendorname = document.getElementById('filter-vendorname').value;
            const category = document.getElementById('filter-category').value;
            const city = document.getElementById('filter-city').value;

            $.ajax({
                url: 'ajax_fetch_associated_products.php',
                method: 'GET',
                data: { productid: productid, productname: productname, vendorname: vendorname, category: category, city: city },
                success: function (response) {
                    $('#associated-products-table').html(response);
                },
                error: function () {
                    alert('An error occurred while fetching table data.');
                }
            });
        }
    </script>

    <!-- Suggested Products -->
    <div id="div-pro3" class="content-div">
        <table class="styled-table" style="width: 100%;">
            <tr>
                <th><button id="add-product-btn-suggest">+</button></th>
                <th style="text-align: left;">Product Name</th>
                <th style="text-align: left;">Vendor Name</th>
                <th style="text-align: left;">Category</th>
                <th style="text-align: left;">City</th>
                <th style="text-align: left;">Keywords</th>
            </tr>
            <?php
            $sql = "SELECT p.productName, v.vendorName, p.category, p.city, p.keywords, s.suggested
                    FROM tdu_products_suggested s
                    LEFT JOIN tdu_products p ON s.suggested = p.productid
                    LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                    WHERE s.productid = $productid";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td><button class='delete-suggested-btn' style='border: unset; background-color: unset;' data-suggested='" . htmlspecialchars($row['suggested']) . "'><i class='fa-solid fa-trash-can' style='color: red;'></i></button></td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['productName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['vendorName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['category']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['city']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['keywords']) . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6'>No records found</td></tr>";
            }
            ?>
        </table>
    </div>
    <div id="suggested-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <div id="modal-content">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Suggested Products</h2>
                <button id="close-modal-suggested" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <table id="modal-table-suggested" class="styled-table" style="width: 100%;">
                <thead>
                    <tr>
                        <th style='text-align: left;'>Product Name</th>
                        <th style='text-align: left;'>Vendor Name</th>
                        <th style='text-align: left;'>Category</th>
                        <th style='text-align: left;'>City</th>
                        <th style='text-align: left;'>Keywords</th>
                        <th style='text-align: left;'></th>
                    </tr>
                    <tr>
                        <td><input type="text" id="filter-productname-suggest" name="productname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-vendorname-suggest" name="vendorname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-category-suggest" name="category" style="width: 100%;"></td>
                        <td><input type="text" id="filter-city-suggest" name="city" style="width: 100%;"></td>
                        <td colspan="2"><button type="button" id="apply-filters-suggest" style="padding: 5px 10px; width: 100%;">Search</button></td>
                    </tr>
                </thead>
                <tbody id="suggested-products-table">
                    <!-- Content will be populated via AJAX -->
                </tbody>
                <tr>
                    <td colspan="6">
                        <button id="load-more-s" style="padding: 10px; display: none; margin: auto;">Load More</button>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        // Show the modal
        document.getElementById('add-product-btn-suggest').addEventListener('click', function () {
            // Display the modal and overlay
            document.getElementById('suggested-modal').style.display = 'block';
            document.getElementById('modal-overlay').style.display = 'block';

            // Fetch initial content
            fetchFilteredDataS();
        });

        // Close the modal
        document.getElementById('close-modal-suggested').addEventListener('click', function () {
            document.getElementById('suggested-modal').style.display = 'none';
            document.getElementById('modal-overlay').style.display = 'none';
            const currentUrl = new URL(window.location.href); // Get the current URL
            currentUrl.searchParams.set('edit', 'suggested-products'); // Add or update the parameter
            window.location.href = currentUrl; // Navigate to the updated URL
        });

        // Apply filters
        document.getElementById('apply-filters-suggest').addEventListener('click', function () {
            fetchFilteredDataS();
        });

        // Function to fetch filtered data
        let currentPages = 1;
        function fetchFilteredDataS(loadMore = false) {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname-suggest').value;
            const vendorname = document.getElementById('filter-vendorname-suggest').value;
            const category = document.getElementById('filter-category-suggest').value;
            const city = document.getElementById('filter-city-suggest').value;

            // Increment the page count if loading more
            if (loadMore) {
                currentPages++;
            } else {
                currentPages = 1; // Reset to the first page
            }

            // Build query parameters
            const params = new URLSearchParams({productname, vendorname, category, city, page: currentPages, productid});

            // Fetch filtered data using AJAX
            fetch('ajax_fetch_suggested_products.php?' + params.toString())
                .then(response => response.text())
                .then(data => {
                    const tableBody = document.querySelector('#modal-table-suggested tbody');

                    if (loadMore) {
                        tableBody.insertAdjacentHTML('beforeend', data); // Append new rows
                    } else {
                        tableBody.innerHTML = data; // Replace rows
                    }

                    // Show or hide "Load More" button based on the response
                    if (data.trim() === '' || data.includes('No More records')) {
                        document.getElementById('load-more-s').style.display = 'none';
                    } else {
                        document.getElementById('load-more-s').style.display = 'block';
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Add event listener for "Load More" button
        document.getElementById('load-more-s').addEventListener('click', function () {
            fetchFilteredDataS(true);
        });
    </script>
    <script>
        $(document).on('click', '.suggest-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const suggested = $(this).data('productid');
            const row = $(this).closest('tr');

            $.ajax({
                url: 'ajax_suggested_products.php',
                method: 'POST',
                data: { productid: productid, suggested: suggested },
                success: function (response) {
                    const result = JSON.parse(response);
                    if (result.status === 'success') {
                        fetchTableDataSuggested();
                    } else {
                        alert(result.message || 'Failed to suggest the product.');
                    }
                },
                error: function () {
                    alert('An error occurred while suggesting the product.');
                }
            });
        });

        $(document).on('click', '.delete-suggested-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const suggested = $(this).data('suggested');
            const row = $(this).closest('tr');

            if (confirm('Are you sure you want to delete this product?')) {
                $.ajax({
                    url: 'ajax_delete_suggested_product.php',
                    method: 'POST',
                    data: { productid: productid, suggested: suggested },
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.status === 'success') {
                            row.remove();
                        } else {
                            alert(result.message || 'Failed to delete the product.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while deleting the product.');
                    }
                });
            }
        });
        function fetchTableDataSuggested() {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname-suggest').value;
            const vendorname = document.getElementById('filter-vendorname-suggest').value;
            const category = document.getElementById('filter-category-suggest').value;
            const city = document.getElementById('filter-city-suggest').value;

            $.ajax({
                url: 'ajax_fetch_suggested_products.php',
                method: 'GET',
                data: { productid: productid, productname: productname, vendorname: vendorname, category: category, city: city },
                success: function (response) {
                    $('#suggested-products-table').html(response);
                },
                error: function () {
                    alert('An error occurred while fetching table data.');
                }
            });
        }
    </script>

    <!-- Non-Allowed Products -->
    <div id="div-pro6" class="content-div">
        <table class="styled-table" style="width: 100%;">
            <tr>
                <th><button id="add-product-btn-non-allowed">+</button></th>
                <th style="text-align: left;">Product Name</th>
                <th style="text-align: left;">Vendor Name</th>
                <th style="text-align: left;">Category</th>
                <th style="text-align: left;">City</th>
                <th style="text-align: left;">Keywords</th>
            </tr>
            <?php
            // Query for non-allowed products
            $sql = "SELECT p.productName, v.vendorName, p.category, p.city, p.keywords, n.non_allowed_productid
                    FROM tdu_products_non_allowed n
                    LEFT JOIN tdu_products p ON n.non_allowed_productid = p.productid
                    LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                    WHERE n.productid = $productid";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td><button class='delete-non-allowed-btn' style='border: unset; background-color: unset;' data-non-allowed='" . htmlspecialchars($row['non_allowed_productid']) . "'><i class='fa-solid fa-trash-can' style='color: red;'></i></button></td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['productName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['vendorName']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['category']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['city']) . "</td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['keywords']) . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6'>No records found</td></tr>";
            }
            ?>
        </table>
    </div>
    <div id="non-allowed-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <div id="modal-content">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Non-Allowed Products</h2>
                <button id="close-modal-non-allowed" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <table id="modal-table-non-allowed" class="styled-table" style="width: 100%;">
                <thead>
                    <tr>
                        <th style='text-align: left;'>Product Name</th>
                        <th style='text-align: left;'>Vendor Name</th>
                        <th style='text-align: left;'>Category</th>
                        <th style='text-align: left;'>City</th>
                        <th style='text-align: left;'>Keywords</th>
                        <th style='text-align: left;'></th>
                    </tr>
                    <tr>
                        <td><input type="text" id="filter-productname-non-allowed" name="productname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-vendorname-non-allowed" name="vendorname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-category-non-allowed" name="category" style="width: 100%;"></td>
                        <td><input type="text" id="filter-city-non-allowed" name="city" style="width: 100%;"></td>
                        <td colspan="2"><button type="button" id="apply-filters-non-allowed" style="padding: 5px 10px; width: 100%;">Search</button></td>
                    </tr>
                </thead>
                <tbody id="non-allowed-products-table">
                    <!-- Content will be populated via AJAX -->
                </tbody>
                <tr>
                    <td colspan="6">
                        <button id="load-more-na" style="padding: 10px; display: none; margin: auto;">Load More</button>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        // Show the non-allowed products modal
        document.getElementById('add-product-btn-non-allowed').addEventListener('click', function () {
            document.getElementById('non-allowed-modal').style.display = 'block';
            document.getElementById('modal-overlay').style.display = 'block';
            fetchFilteredDataNA();
        });

        // Close the non-allowed products modal
        document.getElementById('close-modal-non-allowed').addEventListener('click', function () {
            document.getElementById('non-allowed-modal').style.display = 'none';
            document.getElementById('modal-overlay').style.display = 'none';
            const currentUrl = new URL(window.location.href);
            currentUrl.searchParams.set('edit', 'non-allowed-products');
            window.location.href = currentUrl;
        });

        // Apply filters for non-allowed products
        document.getElementById('apply-filters-non-allowed').addEventListener('click', function () {
            fetchFilteredDataNA();
        });

        // Function to fetch filtered data for non-allowed products
        let currentPagesNA = 1;
        function fetchFilteredDataNA(loadMore = false) {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname-non-allowed').value;
            const vendorname = document.getElementById('filter-vendorname-non-allowed').value;
            const category = document.getElementById('filter-category-non-allowed').value;
            const city = document.getElementById('filter-city-non-allowed').value;

            if (loadMore) {
                currentPagesNA++;
            } else {
                currentPagesNA = 1;
            }

            const params = new URLSearchParams({productname, vendorname, category, city, page: currentPagesNA, productid});

            fetch('ajax_fetch_non_allowed_products.php?' + params.toString())
                .then(response => response.text())
                .then(data => {
                    const tableBody = document.querySelector('#modal-table-non-allowed tbody');

                    if (loadMore) {
                        tableBody.insertAdjacentHTML('beforeend', data);
                    } else {
                        tableBody.innerHTML = data;
                    }

                    if (data.trim() === '' || data.includes('No More records')) {
                        document.getElementById('load-more-na').style.display = 'none';
                    } else {
                        document.getElementById('load-more-na').style.display = 'block';
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Load more non-allowed products
        document.getElementById('load-more-na').addEventListener('click', function () {
            fetchFilteredDataNA(true);
        });

        // Handle adding non-allowed product
        $(document).on('click', '.link-na-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const non_allowed_productid = $(this).data('productid');
            const row = $(this).closest('tr');

            $.ajax({
                url: 'ajax_link_non_allowed_product.php',
                method: 'POST',
                data: { productid: productid, non_allowed_productid: non_allowed_productid },
                success: function (response) {
                    const result = JSON.parse(response);
                    if (result.status === 'success') {
                        fetchTableDataNonAllowed();
                    } else {
                        alert(result.message || 'Failed to link the product.');
                    }
                },
                error: function () {
                    alert('An error occurred while linking the product.');
                }
            });
        });

        // Handle deleting non-allowed product
        $(document).on('click', '.delete-non-allowed-btn', function () {
            const productid = '<?php echo $productid; ?>';
            const non_allowed_productid = $(this).data('non-allowed');
            const row = $(this).closest('tr');

            if (confirm('Are you sure you want to remove this non-allowed product?')) {
                $.ajax({
                    url: 'ajax_delete_non_allowed_product.php',
                    method: 'POST',
                    data: { productid: productid, non_allowed_productid: non_allowed_productid },
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.status === 'success') {
                            row.remove();
                        } else {
                            alert(result.message || 'Failed to delete the non-allowed product.');
                        }
                    },
                    error: function () {
                        alert('An error occurred while deleting the product.');
                    }
                });
            }
        });

        function fetchTableDataNonAllowed() {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname-non-allowed').value;
            const vendorname = document.getElementById('filter-vendorname-non-allowed').value;
            const category = document.getElementById('filter-category-non-allowed').value;
            const city = document.getElementById('filter-city-non-allowed').value;

            $.ajax({
                url: 'ajax_fetch_non_allowed_products.php',
                method: 'GET',
                data: { productid: productid, productname: productname, vendorname: vendorname, category: category, city: city },
                success: function (response) {
                    $('#non-allowed-products-table').html(response);
                },
                error: function () {
                    alert('An error occurred while fetching table data.');
                }
            });
        }
    </script>

    <!-- Sub Products -->
    <div id="div-pro4" class="content-div">
        <table class="styled-table" style="width: 100%;">
            <tr>
                <th><button id="openSubproductModal" class="btn btn-primary">+</button></th>
                <th style='text-align: left;'>Subproduct Name</th>
                <th>Seats</th>
                <th>Unit Price</th>
                <th>Overtime Price (per hour)</th>
                <th>Vehicle Type</th>
                <th></th>
            </tr>
            <?php
            $sql = "SELECT subproductid, subproductname, seats, unitPrice, overtimePrice, type FROM tdu_products_sub WHERE productid = $productid";
            $result = mysqli_query($conn, $sql);

            if ($result && mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td></td>";
                    echo "<td style='text-align: left;'>" . htmlspecialchars($row['subproductname']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['seats']) . "</td>";
                    echo "<td>$ " . htmlspecialchars($row['unitPrice']) . "</td>";
                    echo "<td>$ " . htmlspecialchars($row['overtimePrice']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['type']) . "</td>";
                    echo "<td><button class='btn btn-warning editBtn' 
                                data-id='" . $row['subproductid'] . "' 
                                data-subproductname='" . htmlspecialchars($row['subproductname']) . "' 
                                data-seats='" . htmlspecialchars($row['seats']) . "' 
                                data-unitprice='" . htmlspecialchars($row['unitPrice']) . "' 
                                data-overtimeprice='" . htmlspecialchars($row['overtimePrice']) . "' 
                                data-type='" . htmlspecialchars($row['type']) . "'><i class='fa-solid fa-pen'></i></button>
                                <button class='btn btn-danger deleteBtn' style='background-color: red;' data-id='" . $row['subproductid'] . "'><i class='fa-solid fa-trash-can'></i></button></td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='7'>No records found</td></tr>";
            }
            ?>
        </table>

        <!-- Add/Edit Modal -->
        <div id="subproductModal" class="modal" style="display:none;">
            <div class="modal-content">
                <span id="closeSubproductModal" class="close">&times;</span>
                <h2 style="text-align: center;" id="modalTitle">Add New Subproduct</h2>
                <form id="subproductForm" action="ajax_handle_subproduct.php" method="POST">
                    <input type="hidden" name="id" id="id" value="">
                    <input type="hidden" name="productid" value="<?php echo $productid; ?>">
                    <div>
                        <label for="subproductname">Subproduct Name:</label>
                        <input type="text" name="subproductname" id="subproductname" style="width: 100%;" required>
                    </div>
                    <div>
                        <label for="seats">Seats:</label>
                        <input type="number" name="seats" id="seats" required>
                    </div>
                    <div>
                        <label for="unitPrice">Unit Price:</label>
                        <input type="number" name="unitPrice" id="unitPrice-sub" step="0.01" required>
                    </div>
                    <div>
                        <label for="overtimePrice">Overtime Price:</label>
                        <input type="number" name="overtimePrice" id="overtimePrice" step="0.01" required>
                    </div>
                    <div>
                        <label for="type">Vehicle Type:</label>
                        <input type="text" name="type" id="type" style="width: 100%;" required>
                    </div>
                    <button type="submit" class="btn btn-success" style="margin-top: 20px;">Save</button>
                </form>
            </div>
        </div>

        <script>
            document.getElementById('openSubproductModal').addEventListener('click', function () {
                // Reset form for new entry
                document.getElementById('subproductForm').reset();
                document.getElementById('id').value = ''; // Clear hidden ID
                document.getElementById('modalTitle').textContent = 'Add New Subproduct';
                document.getElementById('subproductModal').style.display = 'flex';
            });

            document.getElementById('closeSubproductModal').addEventListener('click', function () {
                document.getElementById('subproductModal').style.display = 'none';
            });

            // Open edit modal with prefilled data
            document.querySelectorAll('.editBtn').forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    const subproductname = this.getAttribute('data-subproductname');
                    const seats = this.getAttribute('data-seats');
                    const unitPrice = this.getAttribute('data-unitprice');
                    const overtimePrice = this.getAttribute('data-overtimeprice');
                    const type = this.getAttribute('data-type');

                    // Fill the form with existing data
                    document.getElementById('id').value = id;
                    document.getElementById('subproductname').value = subproductname;
                    document.getElementById('seats').value = seats;
                    document.getElementById('unitPrice-sub').value = unitPrice;
                    document.getElementById('overtimePrice').value = overtimePrice;
                    document.getElementById('type').value = type;

                    document.getElementById('modalTitle').textContent = 'Edit Subproduct';
                    document.getElementById('subproductModal').style.display = 'flex';
                });
            });

            window.addEventListener('click', function (event) {
                if (event.target === document.getElementById('subproductModal')) {
                    document.getElementById('subproductModal').style.display = 'none';
                }
            });

            // AJAX form submission for add/edit
            $(document).ready(function () {
                $("#subproductForm").on("submit", function (e) {
                    e.preventDefault();
                    var formData = $(this).serialize();

                    $.ajax({
                        url: $(this).attr('action'),
                        type: 'POST',
                        data: formData,
                        success: function (response) {
                            alert('Operation successful!');
                            console.log(response);
                            $('#subproductModal').hide();
                            $('#subproductForm')[0].reset();
                            location.reload(); // Reload the page to see changes
                        },
                        error: function (xhr, status, error) {
                            alert('An error occurred: ' + error);
                        }
                    });
                });
            });

            document.querySelectorAll('.deleteBtn').forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    
                    if (confirm("Are you sure you want to delete this subproduct?")) {
                        // AJAX request to delete the subproduct
                        $.ajax({
                            url: 'ajax_delete_subproduct.php', // This PHP file will handle the delete operation
                            type: 'POST',
                            data: { id: id },
                            success: function (response) {
                                alert('Subproduct deleted successfully!');
                                location.reload(); // Reload the page to update the table
                            },
                            error: function (xhr, status, error) {
                                alert('An error occurred while deleting: ' + error);
                            }
                        });
                    }
                });
            });
        </script>
    </div>

    <!-- Multiple Vendors -->
    <div id="div-pro7" class="content-div" style="margin: 20px;">
        <?php
        $sql = "SELECT tpv.vendorid, tv.vendorName FROM tdu_product_vendors tpv
                LEFT JOIN tdu_vendors tv ON tpv.vendorid=tv.vendorid
                WHERE tpv.productid = '$productid';";
        $result = mysqli_query($conn, $sql);
        ?>

        <h3>
            Product Vendors
            <button id="openVendorModal" style="cursor: pointer;">+</button>
        </h3>

        <table style="width: 30%; border-collapse: collapse; border: 1px solid #ddd; margin: 10px;">
            <?php
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    echo "<tr>";
                    echo "<td style='padding: 10px; border: 1px solid #ddd;'>" . $row['vendorName'] . "</td>";
                    if ($main_vendor == $row['vendorid']) {
                        echo "<td></td>";
                    } else {
                        echo "<td style='padding: 10px; border: 1px solid #ddd; text-align: center; cursor: pointer;' class='delete-vendor' data-vendorid='" . $row['vendorid'] . "' data-productid='" . $productid . "'>"
                            . "<i class='fa-solid fa-trash-can' style='color: red;'></i></td>";
                    }
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='2'>No records found</td></tr>";
            }
            ?>
        </table>
    </div>
    <div id="link-vendor-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 50%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <h3>Add Vendor <button id="closeVendorModal" style="float: right;">X</button></h3>
        <input type="text" id="vendor-search" placeholder="Search vendor..." style="width: 100%; padding: 5px; margin: 10px 0;">
        <div id="vendor-results" style="max-height: 70%; overflow-y: auto; padding: 5px;"></div>
    </div>
    <script>
        document.getElementById("openVendorModal").addEventListener("click", function() {
            document.getElementById("link-vendor-modal").style.display = "block";
        });

        document.getElementById("closeVendorModal").addEventListener("click", function() {
            document.getElementById("link-vendor-modal").style.display = "none";
        });

        document.getElementById("vendor-search").addEventListener("input", function() {
            let searchQuery = this.value.trim();
            if (searchQuery.length > 0) {
                fetch("ajax_search_product_vendor.php?query=" + encodeURIComponent(searchQuery))
                    .then(response => response.text())
                    .then(data => {
                        document.getElementById("vendor-results").innerHTML = data;
                    });
            } else {
                document.getElementById("vendor-results").innerHTML = "";
            }
        });
        
        document.getElementById("vendor-results").addEventListener("click", function(event) {
            if (event.target.classList.contains("vendor-item")) {
                let vendorId = event.target.getAttribute("data-vendorid");
                let vendorName = event.target.textContent.trim();

                fetch("ajax_link_product_vendor.php", {
                    method: "POST",
                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                    body: "productid=<?php echo $productid; ?>&vendorid=" + encodeURIComponent(vendorId)
                })
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    const currentUrl = new URL(window.location.href);
                    currentUrl.searchParams.set('edit', 'product-vendors');
                    window.location.href = currentUrl;
                });
            }
        });

        document.querySelectorAll(".delete-vendor").forEach(button => {
            button.addEventListener("click", function() {
                let vendorId = this.getAttribute("data-vendorid");
                let productId = this.getAttribute("data-productid");
                
                if (confirm("Are you sure you want to remove this vendor?")) {
                    fetch("ajax_delete_product_vendor.php", {
                        method: "POST",
                        headers: { "Content-Type": "application/x-www-form-urlencoded" },
                        body: "productid=" + encodeURIComponent(productId) + "&vendorid=" + encodeURIComponent(vendorId)
                    })
                    .then(response => response.text())
                    .then(data => {
                        alert(data);
                        const currentUrl = new URL(window.location.href);
                        currentUrl.searchParams.set('edit', 'product-vendors');
                        window.location.href = currentUrl;
                    });
                }
            });
        });
    </script>

    <!-- FAQ Section -->
    <div id="div-pro8" class="content-div">
        <?php
        $sql = "SELECT question, answer FROM tdu_products_faq WHERE productid = '$productid';";
        $result = mysqli_query($conn, $sql);
        
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                ?>
                <div style="margin: 20px;">
                    <button onclick="toggleAnswer(this)" 
                        style="background-color: #334155; color: white; padding: 10px; width: 100%; text-align: left; font-size: 16px; cursor: pointer;">
                        <?php echo htmlspecialchars($row['question']); ?>
                        <i class="fa-solid fa-caret-down" style="float: right;"></i>
                    </button>
                    <div style="display: none; padding: 10px; background: white; border: 2px solid #334155;">
                        <?php echo nl2br(htmlspecialchars($row['answer'])); ?>
                    </div>
                </div>
                <?php
            }
            echo '<button id="openFaqModal" style="padding: 10px 15px; background: #334155; color: white; border: none; cursor: pointer; margin: 0 20px;">Add FAQ</button>';
        } else {
            echo '<p>No FAQs available for this product. 
            <button id="openFaqModal" style="padding: 10px 15px; background: #334155; color: white; border: none; cursor: pointer;">Add FAQ</button></p>';
        }
        ?>

        <script>
            function toggleAnswer(button) {
                let answer = button.nextElementSibling;
                answer.style.display = (answer.style.display === "block") ? "none" : "block";
            }
        </script>
    </div>
    <div id="faq-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 50%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <h3>Add FAQ <button id="closeFaqModal" style="float: right;"><i class="fa-solid fa-xmark"></i></button></h3>
        <input type="text" id="faq-question" placeholder="Enter question..." style="width: 100%; padding: 5px; margin: 10px 0;">
        <textarea id="faq-answer" placeholder="Enter answer..." style="width: 100%; padding: 5px; height: 40vh; margin-bottom: 10px;"></textarea>
        <button id="saveFaq" style="width: 100%; padding: 10px; background: #334155; color: white; border: none; cursor: pointer;">Save FAQ</button>
    </div>
    <script>
        document.getElementById("openFaqModal").addEventListener("click", function() {
            document.getElementById("faq-modal").style.display = "block";
        });

        document.getElementById("closeFaqModal").addEventListener("click", function() {
            document.getElementById("faq-modal").style.display = "none";
            const currentUrl = new URL(window.location.href);
            currentUrl.searchParams.set('edit', 'product-faq');
            window.location.href = currentUrl;
        });

        // Save FAQ via AJAX
        document.getElementById("saveFaq").addEventListener("click", function() {
            let question = document.getElementById("faq-question").value.trim();
            let answer = document.getElementById("faq-answer").value.trim();

            if (question === "" || answer === "") {
                alert("Please fill in both fields.");
                return;
            }

            fetch("ajax_add_product_faq.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: "productid=<?php echo $productid; ?>&question=" + encodeURIComponent(question) + "&answer=" + encodeURIComponent(answer)
            })
            .then(response => response.text())
            .then(data => {
                alert(data);
                const currentUrl = new URL(window.location.href);
                currentUrl.searchParams.set('edit', 'product-faq');
                window.location.href = currentUrl;
            });
        });
    </script>

    <div id="div-pro9" class="content-div">
        <div style="margin: 20px;">
            <input type="text" id="product-search-input" placeholder="Search Product Name...">
            <button type="button" onclick="searchProducts()"><i class="fa-solid fa-magnifying-glass"></i></button>
            <div id="product-results"></div>
        </div>

        <script>
            const originalProductId = "<?= htmlspecialchars($productid) ?>";

            function searchProducts() {
                const query = document.getElementById('product-search-input').value;

                fetch('ajax_search_active_products.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'q=' + encodeURIComponent(query)
                })
                .then(response => response.text())
                .then(html => {
                    document.getElementById('product-results').innerHTML = html;
                });
            }

            function selectProduct(newProductId) {
                fetch('ajax_replace_product_in_template.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'original=' + encodeURIComponent(originalProductId) + '&replacement=' + encodeURIComponent(newProductId)
                })
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    // Optional: reload or update UI
                });
            }
        </script>
    </div>
    <?php
}
else if (($title=='admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'products-list') {
    include "header.php";

    if ($title != 'admin' && $title != 'account') {
        $_GET['active'] = 'Yes';
    }
    
    $productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
    $vendorNameFilter = isset($_GET['vendorname']) ? $_GET['vendorname'] : '';
    $linkCategoryFilter = isset($_GET['linkcategory']) ? $_GET['linkcategory'] : '';
    $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
    $cityFilter = isset($_GET['city']) ? $_GET['city'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';
    $activeFilter = isset($_GET['active']) ? $_GET['active'] : '';

    // Base query
    $sql = "SELECT 
                COALESCE(pp.parent_name, p.productName) AS productName, 
                p.productid,
                v.vendorName, 
                v.vendorid, 
                p.category, 
                p.city, 
                p.keywords, 
                p.preferred, 
                p.featured, 
                p.productActive, 
                p.parentid,
                p.description,
                p.ai_description,
                p.rezdy_uni_code,
                p.fareharbor_product_code,
                v.vendorCountry, 
                CASE 
                    WHEN p.category = 'Hotel' THEN p.sharingPrice 
                    ELSE p.unitPrice 
                END AS price,
                CASE 
                    WHEN p.category = 'Hotel' THEN p.triplePrice 
                    ELSE p.childPrice 
                END AS child_price
            FROM tdu_products p
            LEFT JOIN tdu_vendors v ON p.vendorid=v.vendorid 
            LEFT JOIN tdu_products_parent pp ON p.parentid=pp.parentid
            WHERE 1=1 ";

    // Apply filters
    if ($productNameFilter) {
        $sql .= " AND (CONCAT(p.productName, p.keywords) LIKE '%" . $conn->real_escape_string($productNameFilter) . "%' 
                        OR pp.parent_name LIKE '%" . $conn->real_escape_string($productNameFilter) . "%')";
    }
    if ($vendorNameFilter) {
        $sql .= " AND v.vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
    }
    if ($linkCategoryFilter) {
        if ($linkCategoryFilter == 'rezdy') {
            $sql .= " AND p.rezdy_uni_code != ''";
        }
        else if ($linkCategoryFilter == 'fareharbor') {
            $sql .= " AND p.fareharbor_product_code != ''";
        }
    }
    if ($categoryFilter) {
        $sql .= " AND p.category LIKE '%" . $conn->real_escape_string($categoryFilter) . "%'";
    }
    if ($cityFilter) {
        $sql .= " AND p.city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND v.vendorCountry LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }
    if ($activeFilter) {
        $sql .= " AND p.productActive LIKE '%" . $conn->real_escape_string($activeFilter) . "%'";
    }
    $sql .= " GROUP BY COALESCE(pp.parent_name, p.productid)";

    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $priceSort = isset($_GET['sort']) ? $_GET['sort'] : '';

    // Append sorting logic to SQL query
    if ($priceSort === 'asc') {
        $sql .= " ORDER BY CAST(REPLACE(price, ',', '') AS FLOAT) ASC";
    } elseif ($priceSort === 'desc') {
        $sql .= " ORDER BY CAST(REPLACE(price, ',', '') AS FLOAT) DESC";
    } else {
        $sql .= " ORDER BY p.preferred DESC, p.featured DESC, p.productName ASC";
    }    
    $sql .= " LIMIT $limit OFFSET $offset";
    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Products</h1>
    <table class="styled-table" style="width: 90%; margin: 20px auto;">
        <tr>
            <th>
                <?php if ($title == 'admin') { ?>
                    <button onclick="window.location.href='quote.php?opt=add-new-products'">Add Product</button>
                <?php } ?>
            </th>
            <th colspan='3' style="text-align: left;">Product Name</th>
            <th style="text-align: left;">Vendor Name</th>
            <th style="text-align: center;">Source</th>
            <th style="text-align: left;">Category</th>
            <th style="text-align: left;">City</th>
            <th style="text-align: left;">Country</th>
            <?php if ($categoryFilter == 'Hotel') { ?>
                <th style="text-align: left;">Double Price</th>
                <th style="text-align: left;">Triple Price</th>
            <?php } else { ?>
                <th style="text-align: left;">Adult Price</th>
                <th style="text-align: left;">Child Price</th>
            <?php } ?>
            <?php
            if($title == 'admin' || $title == 'account') {
                ?>
                <th style="text-align: left;">Keywords</th>
                <th style="text-align: left;"></th>
                <?php
            }
            ?>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="products-list">
                <td>
                    <button type="submit">Search</button>
                </td>
                <td colspan='3'>
                    <input type="text" name="productname" value="<?= htmlspecialchars($productNameFilter); ?>">
                </td>
                <td>
                    <input type="text" name="vendorname" value="<?= htmlspecialchars($vendorNameFilter); ?>">
                </td>
                <td>
                    <select name="linkcategory">
                        <option value="" <?= $linkCategoryFilter === '' ? 'selected' : '' ?>>All</option>
                        <option value="rezdy" <?= $linkCategoryFilter === 'rezdy' ? 'selected' : '' ?>>Rezdy</option>
                        <option value="fareharbor" <?= $linkCategoryFilter === 'fareharbor' ? 'selected' : '' ?>>FareHarbor</option>
                    </select>
                </td>
                <td>
                    <select name="category">
                        <option value="">All</option>
                        <option value="Hotel" <?php if ($categoryFilter == "Hotel") echo "selected"; ?>>Hotel</option>
                        <option value="Restaurant" <?php if ($categoryFilter == "Restaurant") echo "selected"; ?>>Restaurant</option>
                        <option value="Attraction" <?php if ($categoryFilter == "Attraction") echo "selected"; ?>>Attraction</option>
                        <option value="Transfers" <?php if ($categoryFilter == "Transfers") echo "selected"; ?>>Transfers</option>
                        <option value="Guide" <?php if ($categoryFilter == "Guide") echo "selected"; ?>>Guide</option>
                        <option value="Tour" <?php if ($categoryFilter == "Tour") echo "selected"; ?>>Tour</option>
                        <option value="SIC" <?php if ($categoryFilter == "SIC") echo "selected"; ?>>SIC</option>
                    </select>
                </td>
                <td>
                    <input type="text" name="city" value="<?= htmlspecialchars($cityFilter); ?>">
                </td>
                <td>
                    <select name="country">
                        <option value="">All</option>
                        <option value="Australia" <?= $countryFilter === 'Australia' ? 'selected' : ''; ?>>Australia</option>
                        <option value="New Zealand" <?= $countryFilter === 'New Zealand' ? 'selected' : ''; ?>>New Zealand</option>
                    </select>
                </td>
                <td>
                    <button type="button" onclick="window.location.href='?opt=products-list<?= '&' . http_build_query($_GET); ?>&sort=asc'"><i class="fa-solid fa-sort-up"></i></button>
                    <button type="button" onclick="window.location.href='?opt=products-list<?= '&' . http_build_query($_GET); ?>&sort=desc'"><i class="fa-solid fa-sort-down"></i></button>
                </td>
                <td></td>
                <?php
                if($title == 'admin' || $title == 'account') {
                    ?>
                    <td></td>
                    <td>
                        <select name="active">
                            <option value="">All</option>
                            <option value="Yes" <?php echo $activeFilter === 'Yes' ? 'selected' : ''; ?>>Active</option>
                            <option value="No" <?php echo $activeFilter === 'No' ? 'selected' : ''; ?>>Inactive</option>
                        </select>
                    </td>
                    <?php
                }
                ?>
            </form>
        </tr>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr data-parentid="<?= htmlspecialchars($row['parentid']); ?>" data-productid="<?= htmlspecialchars($row['productid']); ?>">
                    <td>
                        <?php if (($title == 'admin' || $title == 'account') && $row['parentid'] == 0) : ?>
                            <input type="checkbox" class="product-checkbox" value="<?= htmlspecialchars($row['productid']); ?>">
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;">
                        <p style="margin-left: 0;">
                            <?= $row['preferred'] > 0 ? '<i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i>' : '' ?>
                            <?= $row['featured'] > 0 ? '<i class="fa-solid fa-fire" style="color: red;" title="Popular"></i>' : '' ?>
                            <?php if (($title == 'admin' || $title == 'account') && $row['parentid'] == 0) : ?>
                                <a href="quote.php?opt=product-details&productid=<?= urlencode($row['productid']); ?>">
                                    <?= htmlspecialchars($row['productName']); ?>
                                </a>
                            <?php else : ?>
                                <?= htmlspecialchars($row['productName']); ?>
                            <?php endif; ?>
                        </p>
                    </td>
                    <td>
                        <?php if ($row['ai_description'] > 0 && trim($row['description'] != '')) : ?>
                            <i class="fa-solid fa-robot"></i>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($row['parentid'] > 0) : ?>
                            <button class="toggle-children" data-productid="<?= htmlspecialchars($row['parentid']); ?>">▼</button>
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;">
                        <?php if ($title == 'admin' || $title == 'account') : ?>
                            <a href="quote.php?opt=vendor-details&id=<?= urlencode($row['vendorid']); ?>">
                                <?= ($row['parentid'] == 0) ? htmlspecialchars($row['vendorName']) : '' ?>
                            </a>
                        <?php else : ?>
                            <?= ($row['parentid'] == 0) ? htmlspecialchars($row['vendorName']) : '' ?>
                        <?php endif; ?>
                    </td>
                    <td style="text-align: center;">
                        <?= $row['rezdy_uni_code'] != '' ? 'Rezdy' : '' ?> 
                        <?= $row['fareharbor_product_code'] != '' ? 'Fareharbor' : '' ?>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['category']); ?></td>
                    <?php if ($row['parentid'] == 0) : ?>
                        <td style="text-align: left;"><?= htmlspecialchars($row['city']); ?></td>
                        <td style="text-align: left;"><?= htmlspecialchars($row['vendorCountry']); ?></td>
                        <td style="text-align: center;">
                            <?= empty($row['price']) ? 'N/A' : '$' . htmlspecialchars($row['price']); ?>
                        </td>
                        <td style="text-align: center;">
                            <?= empty($row['child_price']) ? 'N/A' : '$' . htmlspecialchars($row['child_price']); ?>
                        </td>
                        <?php if ($title == 'admin' || $title == 'account') : ?>
                            <td style="text-align: left;"><?= htmlspecialchars($row['keywords']); ?></td>
                            <td style="text-align: left;">
                                <?php if ($row['productActive'] == 'Yes') : ?>
                                    <i class="fa-solid fa-circle-check" style="color: green;" title="Active"></i>
                                <?php else : ?>
                                    <i class="fa-solid fa-circle-xmark" style="color: red;" title="Inactive"></i>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                    <?php else : ?>
                        <td></td>
                        <td style="text-align: left;"><?= htmlspecialchars($row['vendorCountry']); ?></td>
                        <td></td>
                        <td></td>
                        <?php if ($title == 'admin' || $title == 'account') : ?>
                            <td></td>
                            <td></td>
                        <?php endif; ?>
                    <?php endif; ?>
                </tr>
            <?php endwhile; ?>
            <?php
            if($title == 'admin' || $title == 'account') {
                ?>
                <tr>
                    <td><input type="checkbox" id="select-all"> All</td>
                    <td colspan="12" style="text-align: left;">
                        <button id="add-keywords-btn">Add Keywords</button> 
                        <button id="add-product-btn">Add Associated Products</button> 
                        <button id="add-product-btn-suggest">Add Suggested Products</button> 
                        <button id="mark-inactive-btn">Active/Inactive Products</button>
                        <button id="mark-category-btn">Change Category</button>
                        <button id="add-parent-product-btn">Assign Parent Product</button>
                    </td>
                </tr>
                <?php
            }
            ?>
        <?php endif; ?>
        <tr>
            <td></td>
            <td colspan="12" style="text-align: left;">Number of results: <?= $totalRecords ?></td>
        </tr>
    </table>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.querySelectorAll(".toggle-children").forEach(button => {
                button.addEventListener("click", function () {
                    let productId = this.getAttribute("data-productid");
                    let row = this.closest("tr");

                    let queryParams = new URLSearchParams({
                        parentid: productId,
                        vendorNameFilter: "<?= addslashes($vendorNameFilter) ?>",
                        categoryFilter: "<?= addslashes($categoryFilter) ?>",
                        cityFilter: "<?= addslashes($cityFilter) ?>",
                        countryFilter: "<?= addslashes($countryFilter) ?>",
                        activeFilter: "<?= addslashes($activeFilter) ?>"
                    });

                    if (this.classList.contains("expanded")) {
                        this.classList.remove("expanded");
                        this.innerText = "▼";
                        document.querySelectorAll(`tr[data-parentid='${productId}']:not([data-productid])`).forEach(childRow => childRow.remove());
                    } else {
                        this.classList.add("expanded");
                        this.innerText = "▲";

                        fetch(`ajax_fetch_child_products.php?${queryParams.toString()}`)
                            .then(response => response.json())
                            .then(data => {
                                data.forEach(child => {
                                    let childRow = document.createElement("tr");
                                    childRow.setAttribute("data-parentid", productId);
                                    childRow.style.borderLeft = "5px solid #334155";
                                    childRow.innerHTML = `
                                        <td>
                                            <?php if ($title == 'admin') : ?>
                                                <input type="checkbox" class="product-checkbox" value="${child.productid}">
                                            <?php endif; ?>
                                        </td>
                                        <td style="text-align: left;">
                                            <?php if ($title == 'admin') : ?>
                                                <a href="quote.php?opt=product-details&productid=${child.productid}">
                                                    ${child.productName}
                                                </a>
                                            <?php else : ?>
                                                ${child.productName}
                                            <?php endif; ?>
                                        </td>
                                        <td></td>
                                        <td style="text-align: left;">
                                            <?php if ($title == 'admin') : ?>
                                                <a href="quote.php?opt=vendor-details&id=${child.vendorid}">
                                                    ${child.vendorName}
                                                </a>
                                            <?php else : ?>
                                                ${child.vendorName}
                                            <?php endif; ?>
                                        </td>
                                        <td style="text-align: left;">${child.category}</td>
                                        <td style="text-align: left;">${child.city}</td>
                                        <td style="text-align: left;">${child.vendorCountry}</td>
                                        <td style="text-align: center;">${child.price ? '$' + child.price : 'N/A'}</td>
                                        <td style="text-align: center;">${child.child_price ? '$' + child.child_price : 'N/A'}</td>
                                        <?php if ($title == 'admin') : ?>
                                            <td style="text-align: left;">${child.keywords}</td>
                                            <td></td>
                                        <?php endif; ?>
                                    `;
                                    row.after(childRow);
                                });
                            })
                            .catch(error => console.error("Error fetching child products:", error));
                    }
                });
            });
        });
    </script>
    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>

    <input type="hidden" name="product_ids" id="product-ids">
    <div id="modal-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999;"></div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- keywords start -->
    <div id="keywords-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Add Keywords</h2>
            <form id="keywords-form">
                <input type="text" id="new-keywords" name="new_keywords">
                <button type="submit">Add</button>
            </form>
        </div>
    </div>
    <style>
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
            padding-top: 60px;
        }

        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 25%;
        }

        .close, .close-inactive, .close-category {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

        #keywords-form input[type="text"], #parent-product-form input[type="text"] {
            width: 100%;
            height: 30px;
            margin: 20px 0;
        }
    </style>
    <script>
        document.getElementById('select-all').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.product-checkbox');
            checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        });

        document.getElementById('add-keywords-btn').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            if (productIds.length > 0) {
                document.getElementById('product-ids').value = productIds.join(',');
                document.getElementById('keywords-modal').style.display = 'block';
            } else {
                alert('Please select at least one product.');
            }
        });

        document.querySelector('.close').addEventListener('click', function() {
            document.getElementById('keywords-modal').style.display = 'none';
        });

        window.onclick = function(event) {
            if (event.target == document.getElementById('keywords-modal')) {
                document.getElementById('keywords-modal').style.display = 'none';
            }
        };

        document.getElementById('keywords-form').addEventListener('submit', function(event) {
            event.preventDefault();
            var productIds = document.getElementById('product-ids').value;
            var newKeywords = document.getElementById('new-keywords').value;

            fetch('ajax_update_product_keywords.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    product_ids: productIds,
                    new_keywords: newKeywords
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload(); // Refresh the page to see updates
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An unexpected error occurred.');
            });

            document.getElementById('keywords-modal').style.display = 'none';
        });
    </script>
    <!-- keywords end -->

    <!-- bulk add associated products start -->
    <div id="associated-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <div id="modal-content">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Associated Products</h2>
                <button id="close-modal-associated" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <table id="modal-table-associated" class="styled-table" style="width: 100%;">
                <thead>
                    <tr>
                        <th style='text-align: left;'>Product Name</th>
                        <th style='text-align: left;'>Vendor Name</th>
                        <th style='text-align: left;'>Category</th>
                        <th style='text-align: left;'>City</th>
                        <th style='text-align: left;'>Keywords</th>
                        <th style='text-align: left;'></th>
                    </tr>
                    <tr>
                        <td><input type="text" id="filter-productname" name="productname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-vendorname" name="vendorname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-category" name="category" style="width: 100%;"></td>
                        <td><input type="text" id="filter-city" name="city" style="width: 100%;"></td>
                        <td colspan="2"><button type="button" id="apply-filters" style="padding: 5px 10px; width: 100%;">Search</button></td>
                    </tr>
                </thead>
                <tbody id="associated-products-table">
                    <!-- Content will be populated via AJAX -->
                </tbody>
                <tr>
                    <td colspan="6">
                        <button id="load-more" style="padding: 10px; display: none; margin: auto;">Load More</button>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        // Show the modal
        document.getElementById('add-product-btn').addEventListener('click', function () {
            // Display the modal and overlay
            document.getElementById('associated-modal').style.display = 'block';
            document.getElementById('modal-overlay').style.display = 'block';

            // Fetch initial content
            fetchFilteredData();
        });

        // Close the modal
        document.getElementById('close-modal-associated').addEventListener('click', function () {
            document.getElementById('associated-modal').style.display = 'none';
            document.getElementById('modal-overlay').style.display = 'none';
            const currentUrl = new URL(window.location.href); // Get the current URL
            // currentUrl.searchParams.set('edit', 'associated-products'); // Add or update the parameter
            window.location.href = currentUrl; // Navigate to the updated URL
        });

        // Apply filters
        document.getElementById('apply-filters').addEventListener('click', function () {
            fetchFilteredData();
        });

        // Function to fetch filtered data
        let currentPage = 1;
        function fetchFilteredData(loadMore = false) {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname').value;
            const vendorname = document.getElementById('filter-vendorname').value;
            const category = document.getElementById('filter-category').value;
            const city = document.getElementById('filter-city').value;

            // Increment the page count if loading more
            if (loadMore) {
                currentPage++;
            } else {
                currentPage = 1; // Reset to the first page
            }

            // Build query parameters
            const params = new URLSearchParams({productname, vendorname, category, city, page: currentPage, productid});

            // Fetch filtered data using AJAX
            fetch('ajax_fetch_associated_products.php?' + params.toString())
                .then(response => response.text())
                .then(data => {
                    const tableBody = document.querySelector('#modal-table-associated tbody');

                    if (loadMore) {
                        tableBody.insertAdjacentHTML('beforeend', data); // Append new rows
                    } else {
                        tableBody.innerHTML = data; // Replace rows
                    }

                    // Show or hide "Load More" button based on the response
                    if (data.trim() === '' || data.includes('No More records')) {
                        document.getElementById('load-more').style.display = 'none';
                    } else {
                        document.getElementById('load-more').style.display = 'block';
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Add event listener for "Load More" button
        document.getElementById('load-more').addEventListener('click', function () {
            fetchFilteredData(true);
        });
    </script>
    <script>
        $(document).on('click', '.associate-btn', function () {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            document.getElementById('product-ids').value = productIds.join(',');
            var productIds = document.getElementById('product-ids').value;
            const associated = $(this).data('productid');
            const row = $(this).closest('tr');

            $.ajax({
                url: 'ajax_associated_products.php',
                method: 'POST',
                data: { productIds: productIds, associated: associated },
                success: function (response) {
                    const result = JSON.parse(response);
                    if (result.status === 'success') {
                        alert('Associated product added successfully!');
                        row.hide();
                    } else {
                        alert(result.message || 'Failed to associate the product.');
                    }
                },
                error: function () {
                    alert('An error occurred while associating the product.');
                }
            });
        });

        function fetchTableDataAssociated() {
            const productname = document.getElementById('filter-productname').value;
            const vendorname = document.getElementById('filter-vendorname').value;
            const category = document.getElementById('filter-category').value;
            const city = document.getElementById('filter-city').value;

            $.ajax({
                url: 'ajax_fetch_associated_products.php',
                method: 'GET',
                data: { productname: productname, vendorname: vendorname, category: category, city: city },
                success: function (response) {
                    $('#associated-products-table').html(response);
                },
                error: function () {
                    alert('An error occurred while fetching table data.');
                }
            });
        }
    </script>
    <!-- bulk add associated products end -->

    <!-- bulk add suggested products start -->
    <div id="suggested-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 80%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
        <div id="modal-content">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <h2>Suggested Products</h2>
                <button id="close-modal-suggested" style="margin-top: 0;"><i class="fa-solid fa-xmark"></i></button>
            </div>
            <table id="modal-table-suggested" class="styled-table" style="width: 100%;">
                <thead>
                    <tr>
                        <th style='text-align: left;'>Product Name</th>
                        <th style='text-align: left;'>Vendor Name</th>
                        <th style='text-align: left;'>Category</th>
                        <th style='text-align: left;'>City</th>
                        <th style='text-align: left;'>Keywords</th>
                        <th style='text-align: left;'></th>
                    </tr>
                    <tr>
                        <td><input type="text" id="filter-productname-suggest" name="productname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-vendorname-suggest" name="vendorname" style="width: 100%;"></td>
                        <td><input type="text" id="filter-category-suggest" name="category" style="width: 100%;"></td>
                        <td><input type="text" id="filter-city-suggest" name="city" style="width: 100%;"></td>
                        <td colspan="2"><button type="button" id="apply-filters-suggest" style="padding: 5px 10px; width: 100%;">Search</button></td>
                    </tr>
                </thead>
                <tbody id="suggested-products-table">
                    <!-- Content will be populated via AJAX -->
                </tbody>
                <tr>
                    <td colspan="6">
                        <button id="load-more-s" style="padding: 10px; display: none; margin: auto;">Load More</button>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <script>
        // Show the modal
        document.getElementById('add-product-btn-suggest').addEventListener('click', function () {
            // Display the modal and overlay
            document.getElementById('suggested-modal').style.display = 'block';
            document.getElementById('modal-overlay').style.display = 'block';

            // Fetch initial content
            fetchFilteredDataS();
        });

        // Close the modal
        document.getElementById('close-modal-suggested').addEventListener('click', function () {
            document.getElementById('suggested-modal').style.display = 'none';
            document.getElementById('modal-overlay').style.display = 'none';
            const currentUrl = new URL(window.location.href); // Get the current URL
            // currentUrl.searchParams.set('edit', 'suggested-products'); // Add or update the parameter
            window.location.href = currentUrl; // Navigate to the updated URL
        });

        // Apply filters
        document.getElementById('apply-filters-suggest').addEventListener('click', function () {
            fetchFilteredDataS();
        });

        // Function to fetch filtered data
        let currentPages = 1;
        function fetchFilteredDataS(loadMore = false) {
            const productid = '<?php echo $productid; ?>';
            const productname = document.getElementById('filter-productname-suggest').value;
            const vendorname = document.getElementById('filter-vendorname-suggest').value;
            const category = document.getElementById('filter-category-suggest').value;
            const city = document.getElementById('filter-city-suggest').value;

            // Increment the page count if loading more
            if (loadMore) {
                currentPages++;
            } else {
                currentPages = 1; // Reset to the first page
            }

            // Build query parameters
            const params = new URLSearchParams({productname, vendorname, category, city, page: currentPages, productid});

            // Fetch filtered data using AJAX
            fetch('ajax_fetch_suggested_products.php?' + params.toString())
                .then(response => response.text())
                .then(data => {
                    const tableBody = document.querySelector('#modal-table-suggested tbody');

                    if (loadMore) {
                        tableBody.insertAdjacentHTML('beforeend', data); // Append new rows
                    } else {
                        tableBody.innerHTML = data; // Replace rows
                    }

                    // Show or hide "Load More" button based on the response
                    if (data.trim() === '' || data.includes('No More records')) {
                        document.getElementById('load-more-s').style.display = 'none';
                    } else {
                        document.getElementById('load-more-s').style.display = 'block';
                    }
                })
                .catch(error => console.error('Error fetching data:', error));
        }

        // Add event listener for "Load More" button
        document.getElementById('load-more-s').addEventListener('click', function () {
            fetchFilteredDataS(true);
        });
    </script>
    <script>
        $(document).on('click', '.suggest-btn', function () {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            document.getElementById('product-ids').value = productIds.join(',');
            var productIds = document.getElementById('product-ids').value;
            const suggested = $(this).data('productid');
            const row = $(this).closest('tr');

            $.ajax({
                url: 'ajax_suggested_products.php',
                method: 'POST',
                data: { productIds: productIds, suggested: suggested },
                success: function (response) {
                    const result = JSON.parse(response);
                    if (result.status === 'success') {
                        alert('Suggested product added successfully!');
                        row.hide();
                    } else {
                        alert(result.message || 'Failed to suggest the product.');
                    }
                },
                error: function () {
                    alert('An error occurred while suggesting the product.');
                }
            });
        });

        function fetchTableDataSuggested() {
            const productname = document.getElementById('filter-productname-suggest').value;
            const vendorname = document.getElementById('filter-vendorname-suggest').value;
            const category = document.getElementById('filter-category-suggest').value;
            const city = document.getElementById('filter-city-suggest').value;

            $.ajax({
                url: 'ajax_fetch_suggested_products.php',
                method: 'GET',
                data: { productname: productname, vendorname: vendorname, category: category, city: city },
                success: function (response) {
                    $('#suggested-products-table').html(response);
                },
                error: function () {
                    alert('An error occurred while fetching table data.');
                }
            });
        }
    </script>
    <!-- bulk add suggested products end -->

    <!-- bulk inactive products start -->
    <div id="inactive-products-modal" class="modal">
        <div class="modal-content">
            <span class="close-inactive">&times;</span>
            <h2 style="margin: 20px 0;">Change Products Status</h2>
            <form id="inactive-products-form">
                <input type="hidden" id="inactive-product-ids" name="inactive_product_ids">
                <select id="product-status-selection" name="status" style="width: 100%;" required>
                    <option value="Yes">Active</option>
                    <option value="No">Inactive</option>
                </select>
                <button type="submit">Confirm</button>
            </form>
        </div>
    </div>
    <script>
        // Show Inactive Products Modal
        document.getElementById('mark-inactive-btn').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            if (productIds.length > 0) {
                document.getElementById('inactive-product-ids').value = productIds.join(',');
                document.getElementById('inactive-products-modal').style.display = 'block';
            } else {
                alert('Please select at least one product.');
            }
        });

        // Close Inactive Products Modal
        document.querySelector('.close-inactive').addEventListener('click', function() {
            document.getElementById('inactive-products-modal').style.display = 'none';
        });

        // Close modal if clicking outside of it
        window.onclick = function(event) {
            if (event.target == document.getElementById('inactive-products-modal')) {
                document.getElementById('inactive-products-modal').style.display = 'none';
            }
        };

        // Handle Inactive Products Form Submission
        document.getElementById('inactive-products-form').addEventListener('submit', function(event) {
            event.preventDefault();
            var productIds = document.getElementById('inactive-product-ids').value;
            var status = document.getElementById('product-status-selection').value;

            fetch('ajax_mark_inactive_products.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    product_ids: productIds, status: status
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload(); // Refresh to reflect updates
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An unexpected error occurred.');
            });

            document.getElementById('inactive-products-modal').style.display = 'none';
        });
    </script>
    <!-- bulk inactive products end -->

    <div id="change-category-modal" class="modal">
        <div class="modal-content">
            <span class="close-category">&times;</span>
            <h2 style="margin: 20px 0;">Change Product Category</h2>
            <form id="change-category-form">
                <input type="hidden" id="category-product-ids" name="category_product_ids">
                <select id="category-selection" name="category" style="width: 100%;" required>
                    <option value="Hotel">Hotel</option>
                    <option value="Restaurant">Restaurant</option>
                    <option value="Attraction">Attraction</option>
                    <option value="Transfers">Transfers</option>
                    <option value="Guide">Guide</option>
                    <option value="Tour">Tour</option>
                    <option value="SIC">SIC</option>
                </select>
                <button type="submit">Confirm</button>
            </form>
        </div>
    </div>
    <script>
        // Show Change Category Modal
        document.getElementById('mark-category-btn').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            if (productIds.length > 0) {
                document.getElementById('category-product-ids').value = productIds.join(',');
                document.getElementById('change-category-modal').style.display = 'block';
            } else {
                alert('Please select at least one product.');
            }
        });

        // Close Change Category Modal
        document.querySelector('.close-category').addEventListener('click', function() {
            document.getElementById('change-category-modal').style.display = 'none';
        });

        // Close modal if clicking outside of it
        window.onclick = function(event) {
            if (event.target == document.getElementById('change-category-modal')) {
                document.getElementById('change-category-modal').style.display = 'none';
            }
        };

        // Handle Change Category Form Submission
        document.getElementById('change-category-form').addEventListener('submit', function(event) {
            event.preventDefault();
            var productIds = document.getElementById('category-product-ids').value;
            var category = document.getElementById('category-selection').value;

            fetch('ajax_change_product_category.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    product_ids: productIds, category: category
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload(); // Refresh to reflect updates
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An unexpected error occurred.');
            });

            document.getElementById('change-category-modal').style.display = 'none';
        });
    </script>

    <!-- parent product start -->
    <div id="parent-product-modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Assign Parent Product</h2>
            <form id="parent-product-form">
                <input type="text" id="parent-product-id" name="parent_product_id">
                <button type="submit">Assign</button>
            </form>
        </div>
    </div>
    <script>
        document.getElementById('add-parent-product-btn').addEventListener('click', function() {
            var checkboxes = document.querySelectorAll('.product-checkbox:checked');
            var productIds = Array.from(checkboxes).map(cb => cb.value);
            if (productIds.length > 0) {
                document.getElementById('product-ids').value = productIds.join(',');
                document.getElementById('parent-product-modal').style.display = 'block';
            } else {
                alert('Please select at least one product.');
            }
        });

        document.querySelector('#parent-product-modal .close').addEventListener('click', function() {
            document.getElementById('parent-product-modal').style.display = 'none';
        });

        window.onclick = function(event) {
            if (event.target == document.getElementById('parent-product-modal')) {
                document.getElementById('parent-product-modal').style.display = 'none';
            }
        };

        document.getElementById('parent-product-form').addEventListener('submit', function(event) {
            event.preventDefault();
            var productIds = document.getElementById('product-ids').value;
            var parentProductId = document.getElementById('parent-product-id').value;

            fetch('ajax_update_parent_product.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    product_ids: productIds,
                    parent_product_id: parentProductId
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload(); // Refresh the page to see updates
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An unexpected error occurred.');
            });

            document.getElementById('parent-product-modal').style.display = 'none';
        });
    </script>
    <!-- parent product end -->
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'product-price-import') {
    include "header.php";

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (isset($_FILES["csv_file"]) && $_FILES["csv_file"]["error"] == 0) {
            $file = $_FILES["csv_file"]["tmp_name"];
            $handle = fopen($file, "r");
    
            if ($handle !== false) {
                // Skip the header row
                fgetcsv($handle);
    
                while (($row = fgetcsv($handle)) !== false) {
                    $productName = $conn->real_escape_string($row[0]);
                    $unitPrice = $row[1];
                    $childPrice = $row[2];
                    $infantPrice = $row[3];
                    $sharingPrice = $row[4];
                    $triplePrice = $row[5];
                    $childWithBedPrice = $row[6];
                    $childNoBedPrice = $row[7];
    
                    // Check if the product exists
                    $checkQuery = "SELECT productID FROM tdu_products WHERE productName = '$productName'";
                    $result = $conn->query($checkQuery);
    
                    if ($result && $result->num_rows > 0) {
                        // Update the price columns if the product exists
                        $updateQuery = "
                            UPDATE tdu_products 
                            SET 
                                unitPrice = '$unitPrice',
                                childPrice = '$childPrice',
                                infantPrice = '$infantPrice',
                                sharingPrice = '$sharingPrice',
                                triplePrice = '$triplePrice',
                                childWithBedPrice = '$childWithBedPrice',
                                childNoBedPrice = '$childNoBedPrice'
                            WHERE productName = '$productName'
                        ";
                        $conn->query($updateQuery);
                    }
                }
                fclose($handle);
                echo "CSV processed successfully.";
            } else {
                echo "Failed to open the uploaded file.";
            }
        } else {
            echo "Error in file upload.";
        }
    }
    ?>
    <h1 style="text-align: center; font-family: Arial, sans-serif; color: #333; margin: 20px;">Upload Products Prices</h1>
    <form action="" method="POST" enctype="multipart/form-data" style="max-width: 500px; margin: 0 auto; padding: 20px; background-color: #f9f9f9; border-radius: 8px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
        <label for="csv_file" style="font-family: Arial, sans-serif; font-size: 16px; color: #555; margin-bottom: 10px; display: block;">Choose CSV file:</label>
        <input type="file" name="csv_file" id="csv_file" accept=".csv" required style="font-family: Arial, sans-serif; font-size: 14px; padding: 8px; border: 1px solid #ccc; border-radius: 4px; width: 100%; margin-bottom: 20px;">
        <button type="submit" style="font-family: Arial, sans-serif; font-size: 16px; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; width: 100%;">Upload and Update</button>
    </form>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'quote-product-faq') {
    include "header.php";

    $quote_no = $_GET['quoteNumber'];
    $sql = "SELECT MIN(quoteid) AS quoteid FROM vtiger_quotes WHERE quote_no = '$quote_no';";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    $quoteid = $row['quoteid'];

    if ($quoteid) {
        echo "<h1 style='margin: 20px;'>$quote_no FAQ</h1>";
        
        // Filter form (client-side)
        echo '<input type="text" id="productFilter" placeholder="Filter by Product Name" style="margin: 0 20px; padding: 10px; width: 95%;">';

        // Get products that have FAQs
        $sql = "SELECT DISTINCT vi.productid, vi.day, tp.productName
                FROM vtiger_inventoryproductrel vi 
                LEFT JOIN tdu_products tp ON vi.productid = tp.productid
                WHERE vi.id = '$quoteid' 
                AND EXISTS (SELECT 1 FROM tdu_products_faq WHERE productid = vi.productid)
                ORDER BY vi.day ASC;";
        $result = mysqli_query($conn, $sql);

        if (mysqli_num_rows($result) == 0) {
            echo "<h3 style='margin: 20px;'>No FAQs found for this quote.</h3>";
        }

        // Display products
        $products = [];
        while ($product = mysqli_fetch_assoc($result)) {
            $products[] = $product;
        }

        // Generate HTML for each product
        foreach ($products as $product) {
            $productid = $product['productid'];
            $productName = htmlspecialchars($product['productName']);
            ?>
            <div class="product-item" style="margin: 20px;" data-product-name="<?= $productName ?>">
                <!-- Dropdown button to toggle all FAQs -->
                <button onclick="toggleAllFaqs('<?php echo $productid; ?>')" style="background-color: #334155; color: white; padding: 10px; width: 100%; text-align: left; font-size: 16px; cursor: pointer;">
                    <?= $productName ?>
                    <i class="fa-solid fa-caret-down" style="float: right;"></i>
                </button>
                <div id="faq-container-<?php echo $productid; ?>" style="display: none; padding: 10px; border: 3px solid #334155;">
                    <?php
                    // Fetch FAQs for the product
                    $sql = "SELECT question, answer FROM tdu_products_faq WHERE productid = '$productid';";
                    $faq_result = mysqli_query($conn, $sql);
                    
                    if (mysqli_num_rows($faq_result) > 0) {
                        while ($row = mysqli_fetch_assoc($faq_result)) {
                            ?>
                            <div style="margin: 10px 0;">
                                <button onclick="toggleAnswer(this)" 
                                        style="background-color: #1390be; color: white; padding: 10px; width: 100%; text-align: left; font-size: 16px; cursor: pointer;">
                                    <?php echo htmlspecialchars($row['question']); ?>
                                    <i class="fa-solid fa-caret-down" style="float: right;"></i>
                                </button>
                                <div style="display: none; padding: 10px; background: white; border: 2px solid #1390be;">
                                    <?php echo nl2br(htmlspecialchars($row['answer'])); ?>
                                </div>
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div>
            <?php
        }
    }
    ?>
    <script>
        function toggleAnswer(btn) {
            var content = btn.nextElementSibling;
            content.style.display = (content.style.display === "block") ? "none" : "block";
        }

        function toggleAllFaqs(productId) {
            var container = document.getElementById('faq-container-' + productId);
            container.style.display = (container.style.display === "block") ? "none" : "block";
        }

        document.getElementById("productFilter").addEventListener("input", function() {
            var filterText = this.value.toLowerCase();
            var productItems = document.querySelectorAll('.product-item');

            productItems.forEach(function(item) {
                var productName = item.getAttribute('data-product-name').toLowerCase();
                if (productName.includes(filterText)) {
                    item.style.display = "";
                } else {
                    item.style.display = "none";
                }
            });
        });
    </script>
    <?php
}

// External admin page for products
else if (($title=='admin') && isset($_GET['opt']) && $_GET['opt'] == 'rezdy-external') {
    include "header.php";
    include "rezdyconn.php";

    $sql_prefered = "SELECT DISTINCT rezdy_uni_code FROM tdu_products WHERE rezdy_uni_code != '' AND preferred = 1;";
    $result_prefered = $conn->query($sql_prefered);
    $preferedRezdyCodes = [];
    while ($row = $result_prefered->fetch_assoc()) {
        $preferedRezdyCodes[] = $row['rezdy_uni_code'];
    }
    $preferedRezdyCodesList = array_map(function($code) use ($rezdyconn) {
        return "'" . $rezdyconn->real_escape_string($code) . "'";
    }, $preferedRezdyCodes);
    $preferedRezdyCodesSql = implode(',', $preferedRezdyCodesList);

    // Filters
    $nameFilter = $_GET['name'] ?? '';
    $supplierFilter = $_GET['supplier'] ?? '';
    $countryFilter = $_GET['country'] ?? '';
    $showExternalFilter = isset($_GET['show_external']) ? $_GET['show_external'] : '';

    // Base query
    $sql = "SELECT productCode, name, supplierName, countryCode, advertisedPrice, show_external 
            FROM products 
            WHERE countryCode IN ('au', 'nz') AND rate='negotiated'";

    if ($nameFilter) {
        $sql .= " AND name LIKE '%" . $rezdyconn->real_escape_string($nameFilter) . "%'";
    }
    if ($supplierFilter) {
        $sql .= " AND supplierName LIKE '%" . $rezdyconn->real_escape_string($supplierFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND countryCode = '" . $rezdyconn->real_escape_string($countryFilter) . "'";
    }
    if ($showExternalFilter != '') {
        $sql .= " AND show_external = '$showExternalFilter'";
    }

    // Pagination
    $limit = 20;
    $page = max((int)($_GET['page'] ?? 1), 1);
    $offset = ($page - 1) * $limit;
    $sqlTotal = $sql;
    if ($preferedRezdyCodesSql) {
        $sql .= " ORDER BY 
                CASE 
                    WHEN productCode IN ($preferedRezdyCodesSql) THEN 0 
                    ELSE 1 
                END, 
                name ASC 
                LIMIT $limit OFFSET $offset";
    } else {
        $sql .= " ORDER BY name ASC LIMIT $limit OFFSET $offset";
    }

    // Fetch data
    $result = $rezdyconn->query($sql);
    $totalRecords = $rezdyconn->query($sqlTotal)->num_rows;
    $totalPages = ceil($totalRecords / $limit);
    ?>

    <h1 style="text-align:center;margin-top:20px;">Rezdy Products</h1>
    <table class="styled-table" style="width:95%;margin:20px auto;">

        <form method="GET">
            <tr>
                <th></th>
                <th>Name</th>
                <th>Supplier</th>
                <th>Country</th>
                <th>Price</th>
                <th>Show</th>
            </tr>
            <tr>
                <input type="hidden" name="opt" value="rezdy-external">
                <td><button type="submit">Search</button></td>
                <td><input type="text" name="name" value="<?= htmlspecialchars($nameFilter); ?>"></td>
                <td><input type="text" name="supplier" value="<?= htmlspecialchars($supplierFilter); ?>"></td>
                <td>
                    <select name="country">
                        <option value="">All</option>
                        <option value="au" <?= $countryFilter == 'au' ? 'selected' : '' ?>>AU</option>
                        <option value="nz" <?= $countryFilter == 'nz' ? 'selected' : '' ?>>NZ</option>
                    </select>
                </td>
                <td></td>
                <td>
                    <select name="show_external">
                        <option value="">All</option>
                        <option value="1" <?= $showExternalFilter === 1 ? 'selected' : '' ?>>Yes</option>
                        <option value="0" <?= $showExternalFilter === 0 ? 'selected' : '' ?>>No</option>
                    </select>
                </td>
            </tr>
        </form>

        <form id="bulkForm">
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><input type="checkbox" class="row-checkbox" name="productCodes[]" value="<?= $row['productCode']; ?>"> <?= htmlspecialchars($row['productCode']); ?></td>
                    <td><?= in_array($row['productCode'], $preferedRezdyCodes) ? '<i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i>' : '' ?> <?= htmlspecialchars($row['name']); ?></td>
                    <td><?= htmlspecialchars($row['supplierName']); ?></td>
                    <td><?= htmlspecialchars($row['countryCode']); ?></td>
                    <td>$<?= number_format((float) $row['advertisedPrice'], 2); ?></td>
                    <td><?= $row['show_external'] ? '<i class="fa-solid fa-circle-check" style="color: green;" title="Yes"></i>' : '<i class="fa-solid fa-circle-xmark" style="color: red;" title="No"></i>'; ?></td>
                </tr>
            <?php endwhile; ?>
            <tr>
                <td><input type="checkbox" id="select-all" onclick="toggleSelectAll(this)"> All</td>
                <td colspan="5">
                    <button type="button" onclick="openBulkExternalModal()">Bulk Edit Show External</button>
                </td>
            </tr>
        </form>
    </table>

    <!-- Modal -->
    <div id="bulk-external-modal" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); width:300px; background:#fff; padding:20px; border:1px solid #ccc;">
        <h3>Set Show External:</h3>
        <select id="external-status-select">
            <option value="1">Yes</option>
            <option value="0">No</option>
        </select><br><br>
        <button onclick="applyBulkExternal()">Apply</button>
        <button onclick="closeModal()">Cancel</button>
    </div>

    <script>
        function toggleSelectAll(checkbox) {
            document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = checkbox.checked);
        }

        function openBulkExternalModal() {
            document.getElementById('bulk-external-modal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('bulk-external-modal').style.display = 'none';
        }

        function applyBulkExternal() {
            const productCodes = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.value);
            const status = document.getElementById('external-status-select').value;

            if (productCodes.length === 0) {
                alert('Select at least one product.');
                return;
            }

            fetch('ajax_update_rezdy_external.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ productCodes, show_external: status })
            })
            .then(res => res.json())
            .then(data => {
                alert(data.message);
                if (data.success) location.reload();
            })
            .catch(err => console.error('Error:', err));
        }
    </script>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select, #bulk-external-modal select {
            width: 100%;
            height: 30px;
            margin: 0;
        }

        .styled-table tr th, .styled-table tr td {
            text-align: left;
        }
    </style>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'fareharbor-external') {
    include "header.php";
    include "fareharborconn.php";

    $sql_preferred = "SELECT DISTINCT fareharbor_product_code FROM tdu_products WHERE fareharbor_product_code != '' AND preferred = 1;";
    $result_preferred = $conn->query($sql_preferred);
    $preferredFHProductPKs = [];
    while ($row = $result_preferred->fetch_assoc()) {
        $preferredFHProductPKs[] = $row['fareharbor_product_code'];
    }
    $preferredFHProductPKsList = array_map(function($pk) use ($fareharborconn) {
        return "'" . $fareharborconn->real_escape_string($pk) . "'";
    }, $preferredFHProductPKs);
    $preferredFHProductPKsSql = implode(',', $preferredFHProductPKsList);

    // Filters
    $nameFilter = $_GET['name'] ?? '';
    $companyFilter = $_GET['company'] ?? '';
    $countryFilter = $_GET['country'] ?? '';
    $showExternalFilter = isset($_GET['show_external']) ? $_GET['show_external'] : '';

    // Base query
    $sql = "SELECT p.pk, p.name AS productName, c.name AS companyName, c.country, p.adult_price, p.show_external
            FROM fareharbor_products p
            LEFT JOIN fareharbor_companies c ON p.company_shortname = c.shortname
            WHERE c.country IN ('Australia', 'New Zealand')";

    if ($nameFilter) {
        $sql .= " AND p.name LIKE '%" . $fareharborconn->real_escape_string($nameFilter) . "%'";
    }
    if ($companyFilter) {
        $sql .= " AND c.name LIKE '%" . $fareharborconn->real_escape_string($companyFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND c.country = '" . $fareharborconn->real_escape_string($countryFilter) . "'";
    }
    if ($showExternalFilter != '') {
        $sql .= " AND p.show_external = '" . $fareharborconn->real_escape_string($showExternalFilter) . "'";
    }

    // Pagination
    $limit = 20;
    $page = max((int)($_GET['page'] ?? 1), 1);
    $offset = ($page - 1) * $limit;
    $sqlTotal = $sql;
    
    if ($preferredFHProductPKsSql) {
        $sql .= " ORDER BY 
                    CASE 
                        WHEN p.pk IN ($preferredFHProductPKsSql) THEN 0 
                        ELSE 1 
                    END,
                    p.name ASC 
                LIMIT $limit OFFSET $offset";
    } else {
        $sql .= " ORDER BY p.name ASC LIMIT $limit OFFSET $offset";
    }

    // Fetch data
    $result = $fareharborconn->query($sql);
    $totalRecords = $fareharborconn->query($sqlTotal)->num_rows;
    $totalPages = ceil($totalRecords / $limit);
    ?>

    <h1 style="text-align:center;margin-top:20px;">FareHarbor Products</h1>
    <table class="styled-table" style="width:95%;margin:20px auto;">
        <form method="GET">
            <tr>
                <th></th>
                <th>Name</th>
                <th>Company</th>
                <th>Country</th>
                <th>Price</th>
                <th>Show</th>
            </tr>
            <tr>
                <input type="hidden" name="opt" value="fareharbor-external">
                <td><button type="submit">Search</button></td>
                <td><input type="text" name="name" value="<?= htmlspecialchars($nameFilter); ?>"></td>
                <td><input type="text" name="company" value="<?= htmlspecialchars($companyFilter); ?>"></td>
                <td>
                    <select name="country">
                        <option value="">All</option>
                        <option value="Australia" <?= $countryFilter == 'Australia' ? 'selected' : '' ?>>AU</option>
                        <option value="New Zealand" <?= $countryFilter == 'New Zealand' ? 'selected' : '' ?>>NZ</option>
                    </select>
                </td>
                <td></td>
                <td>
                    <select name="show_external">
                        <option value="">All</option>
                        <option value="1" <?= $showExternalFilter === '1' ? 'selected' : '' ?>>Yes</option>
                        <option value="0" <?= $showExternalFilter === '0' ? 'selected' : '' ?>>No</option>
                    </select>
                </td>
            </tr>
        </form>

        <form id="bulkForm">
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><input type="checkbox" class="row-checkbox" name="productCodes[]" value="<?= $row['pk']; ?>"> <?= htmlspecialchars($row['pk']); ?></td>
                    <td><?= in_array($row['pk'], $preferredFHProductPKs) ? '<i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i>' : '' ?> <?= htmlspecialchars($row['productName']); ?></td>
                    <td><?= htmlspecialchars($row['companyName']); ?></td>
                    <td><?= htmlspecialchars($row['country']); ?></td>
                    <td>$<?= number_format((float) $row['adult_price'], 2); ?></td>
                    <td><?= $row['show_external'] ? '<i class="fa-solid fa-circle-check" style="color: green;" title="Yes"></i>' : '<i class="fa-solid fa-circle-xmark" style="color: red;" title="No"></i>'; ?></td>
                </tr>
            <?php endwhile; ?>
            <tr>
                <td><input type="checkbox" id="select-all" onclick="toggleSelectAll(this)"> All</td>
                <td colspan="5">
                    <button type="button" onclick="openBulkExternalModal()">Bulk Edit Show External</button>
                </td>
            </tr>
        </form>
    </table>

    <!-- Modal -->
    <div id="bulk-external-modal" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); width:300px; background:#fff; padding:20px; border:1px solid #ccc;">
        <h3>Set Show External:</h3>
        <select id="external-status-select">
            <option value="1">Yes</option>
            <option value="0">No</option>
        </select><br><br>
        <button onclick="applyBulkExternal()">Apply</button>
        <button onclick="closeModal()">Cancel</button>
    </div>

    <script>
        function toggleSelectAll(checkbox) {
            document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = checkbox.checked);
        }

        function openBulkExternalModal() {
            document.getElementById('bulk-external-modal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('bulk-external-modal').style.display = 'none';
        }

        function applyBulkExternal() {
            const productCodes = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.value);
            const status = document.getElementById('external-status-select').value;

            if (productCodes.length === 0) {
                alert('Select at least one product.');
                return;
            }

            fetch('ajax_update_fareharbor_external.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ productCodes, show_external: status })
            })
            .then(res => res.json())
            .then(data => {
                alert(data.message);
                if (data.success) location.reload();
            })
            .catch(err => console.error('Error:', err));
        }
    </script>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select, #bulk-external-modal select {
            width: 100%;
            height: 30px;
            margin: 0;
        }

        .styled-table tr th, .styled-table tr td {
            text-align: left;
        }
    </style>
    <?php
}

// Memberships
else if (($title=='admin') && isset($_GET['opt']) && $_GET['opt'] == 'membership-list') {
    include "header.php";

    $sql = "SELECT membershipid, membershipName FROM tdu_membership;";
    $result = mysqli_query($conn, $sql);
    ?>
    <h1 style="text-align:center; margin: 20px 0;">Tiers</h1>
    <div style="width: 50%; margin: 20px auto;">
        <?php
        if ($result && mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $membershipId = htmlspecialchars($row['membershipid']);
                $membershipName = htmlspecialchars($row['membershipName']);
                $url = "quote.php?opt=membership&id=" . urlencode($membershipId);
                ?>
                <div class="col-md-4 mb-4">
                    <a href="<?php echo $url; ?>" style="text-decoration: none;">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <h2><?php echo $membershipName; ?></h2>
                            </div>
                        </div>
                    </a>
                </div>
                <?php
            }
        } else {
            echo "<p>No memberships found.</p>";
        }
        ?>
        <button id="addMembershipBtn" style="display: block; margin: 10px auto; padding: 10px 20px; background-color: #334155; color: #fff; border: none; border-radius: 5px; cursor: pointer;">
            New Tier
        </button>
    </div>

    <!-- Modal -->
    <div id="membershipModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 300px; background: #fff; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); z-index: 1000; border-radius: 10px;">
        <h3>Add Tier</h3>
        <input type="text" id="membershipName" style="width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 5px;">
        <button id="saveMembership" style="padding: 10px 20px; background-color: #334155; color: #fff; border: none; border-radius: 5px; cursor: pointer;">Save</button>
        <button id="closeModal" style="padding: 10px 20px; background-color: #dc3545; color: #fff; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px;">Cancel</button>
    </div>

    <div id="modalBackdrop" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 999;"></div>

    <style>
        .card {
            border: 1px solid #ddd;
            border-radius: 8px;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .card:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        .card-body {
            padding: 20px;
            text-align: center;
        }

        .mb-4 {
            margin-bottom: 20px !important;
        }
    </style>

    <script>
        document.getElementById('addMembershipBtn').addEventListener('click', function () {
            document.getElementById('membershipModal').style.display = 'block';
            document.getElementById('modalBackdrop').style.display = 'block';
        });

        document.getElementById('closeModal').addEventListener('click', function () {
            document.getElementById('membershipModal').style.display = 'none';
            document.getElementById('modalBackdrop').style.display = 'none';
        });

        document.getElementById('saveMembership').addEventListener('click', function () {
            const membershipName = document.getElementById('membershipName').value.trim();
            if (membershipName === '') {
                alert('Please enter a membership name.');
                return;
            }

            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_new_membership.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.success) {
                        alert('Membership added successfully!');
                        location.reload(); // Reload to see the new membership
                    } else {
                        alert('Error: ' + response.message);
                    }
                } else {
                    alert('An error occurred while saving the membership.');
                }
            };
            xhr.send('membershipName=' + encodeURIComponent(membershipName));
        });
    </script>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'membership') {
    include "header.php";

    $membershipid = $_GET['id'];
    $membership_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    $sql = "SELECT membershipid FROM tdu_organisation WHERE membershipid = $membership_id";
    $result = $conn->query($sql);
    $disable_del = false;
    if ($result->num_rows > 0) {
        $disable_del = true;
    }

    if ($membership_id > 0) {
        $sql = "SELECT membershipName, color FROM tdu_membership WHERE membershipid = $membership_id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $membership = $result->fetch_assoc();
        } else {
            echo "Membership not found.";
            exit;
        }
    }
    ?>
    <div style="padding: 20px; background-color: <?= htmlspecialchars($membership['color']); ?>;">
        <div style="display: flex; justify-content: space-between; margin: 0;">
            <div style="flex: 2; padding-right: 20px;">
                <h1 style="text-align: left;">
                    <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                    <span id="name-display"><?php echo htmlspecialchars($membership['membershipName']); ?></span>
                    <input id="name-edit" style="display:none; height: 35px;" type="text" value="<?php echo htmlspecialchars($membership['membershipName']); ?>">
                    <input id="color-edit" style="display:none;" type="color" value="<?php echo htmlspecialchars($membership['color']); ?>">
                    <button id="editBtn" onclick="toggleEditMode()"><i class="fa-solid fa-pen-to-square"></i></button>
                    <?php if ($disable_del) : ?>
                        <button class="tooltip-del-disable" style="background-color: red; color: white;" disabled><i class="fa-solid fa-trash-can"></i></button>
                    <?php else : ?>
                        <button id="deleteBtn" style="background-color: red; color: white;" onclick="deleteMembership()"><i class="fa-solid fa-trash-can"></i></button>
                    <?php endif;?>
                </h1>
                <div style="margin-top: 20px; text-align: left;">
                    <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                    <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <style>
        .tooltip-del-disable {
            position: relative;
            display: inline-block;
        }
        .tooltip-del-disable:hover::after {
            content: "Cannot delete membership with associated organizations";
            position: absolute;
            bottom: -125%;
            left: 50%;
            transform: translateX(0%);
            background-color: black;
            color: white;
            padding: 5px;
            border-radius: 5px;
            white-space: nowrap;
            font-size: 24px;
            opacity: 0.8;
            text-transform: none !important;
        }
    </style>

    <script>
        function cancelEdit() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = 'inline');
            document.querySelectorAll('input[id$="-edit"]').forEach(el => el.style.display = 'none');

            document.getElementById('editBtn').style.display = 'inline';
            document.getElementById('saveBtn').style.display = 'none';
            document.getElementById('cancelBtn').style.display = 'none';
        }

        function toggleEditMode() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');
            document.querySelectorAll('input[id$="-edit"]').forEach(el => el.style.display = el.style.display === 'none' ? 'inline' : 'none');

            document.getElementById('editBtn').style.display = document.getElementById('editBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('saveBtn').style.display = document.getElementById('saveBtn').style.display === 'none' ? 'inline' : 'none';
            document.getElementById('cancelBtn').style.display = document.getElementById('cancelBtn').style.display === 'none' ? 'inline' : 'none';
        }

        function saveChanges() {
            const data = {
                membershipName: document.getElementById('name-edit').value,
                color: document.getElementById('color-edit').value,
                membership_id: <?php echo $membership_id; ?>
            };

            fetch('ajax_update_membership.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data),
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    window.location.reload();
                } else {
                    alert('Failed to update membership information.');
                }
            })
            .catch(error => console.error('Error:', error));
        }

        function deleteMembership() {
            if (confirm("Are you sure you want to delete this membership? This action cannot be undone.")) {
                fetch('ajax_delete_membership.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ membership_id: <?php echo $membership_id; ?> }),
                })
                .then(response => response.json())
                .then(result => {
                    if (result.success) {
                        alert('Membership deleted successfully.');
                        window.location.href = 'quote.php?opt=membership-list';
                    } else {
                        alert('Failed to delete membership.');
                    }
                })
                .catch(error => console.error('Error:', error));
            }
        }
    </script>

    <?php

    $sql = "SELECT * FROM tdu_membership WHERE membershipid='$membershipid';";
    $result = $conn->query($sql);
    $membershipName = $result->fetch_assoc()['membershipName'];

    $sql_group = "SELECT * FROM tdu_membership_organization WHERE membershipid='$membershipid' AND quote_type='Group' ORDER BY pax_min ASC;";
    $result_group = $conn->query($sql_group);

    $sql_fit = "SELECT * FROM tdu_membership_organization WHERE membershipid='$membershipid' AND quote_type='FIT';";
    $result_fit = $conn->query($sql_fit);
    ?>

    <h1 style="text-align: center; margin: 20px 0;">FIT Markup</h1>
    <table class="styled-table" style="width: 50%; margin: 20px auto;">
        <tr>
            <th>AU MUP (%)</th>
            <th>NZ MUP (%)</th>
            <th></th>
        </tr>
        <?php
        if ($result_fit->num_rows > 0) {
            while ($row = $result_fit->fetch_assoc()) {
                echo "<tr data-id='{$row['auto_id']}'>
                    <td class='editable'>{$row['markup1']} %</td>
                    <td class='editable'>{$row['markup2']} %</td>
                    <td>
                        <button class='edit-btn'>Edit</button>
                        <button class='save-btn' style='display: none;'>Save</button>
                    </td>
                </tr>";
            }
        } else {
            echo "<tr><td colspan='3'>No rules found</td></tr>";
        }
        ?>
    </table>

    <h1 style="text-align: center; margin: 20px 0;">Group Markup</h1>
    <table id="grp-table" class="styled-table" style="width: 50%; margin: 20px auto;"> 
        <tr>
            <th>Type</th>
            <th>Pax Range</th>
            <th>Adult MUP</th>
            <th>Child MUP</th>
            <th><button id="show-new-row-btn">+</button></th>
        </tr>
        <?php
        if ($result_group->num_rows > 0) {
            while ($row = $result_group->fetch_assoc()) {
                if ($row['markup_type'] == 'ratio') {
                    echo "<tr data-id='{$row['auto_id']}'>
                            <td class='editable' data-type='dropdown'>%</td>
                            <td class='editable' data-type='range'>{$row['pax_min']}-{$row['pax_max']}</td>
                            <td class='editable'>{$row['markup1']} %</td>
                            <td class='editable'>{$row['markup2']} %</td>
                            <td>
                                <button class='edit-btn'><i class='fa-solid fa-pen-to-square'></i></button>
                                <button class='save-btn' style='display: none;'>Save</button>
                                <button type='button' class='delete-btn-mup' data-id='{$row['auto_id']}' style='background-color: red; color: white;'><i class='fa-solid fa-trash-can'></i></button>
                            </td>
                        </tr>";
                } else {
                    echo "<tr data-id='{$row['auto_id']}'>
                            <td class='editable' data-type='dropdown'>Amt</td>
                            <td class='editable' data-type='range'>{$row['pax_min']}-{$row['pax_max']}</td>
                            <td class='editable'>$ {$row['markup1']}</td>
                            <td class='editable'>$ {$row['markup2']}</td>
                            <td>
                                <button class='edit-btn'><i class='fa-solid fa-pen-to-square'></i></button>
                                <button class='save-btn' style='display: none;'>Save</button>
                                <button type='button' class='delete-btn-mup' data-id='{$row['auto_id']}' style='background-color: red; color: white;'><i class='fa-solid fa-trash-can'></i></button>
                            </td>
                        </tr>";
                }
            }            
        } else {
            echo "<tr><td colspan='5'>No data found</td></tr>";
        }
        ?>
        <!-- Add New Row -->
        <tr id="new-row" style="display: none;">
            <td>
                <select id="new-markup-type" style="margin: 0; width: 100px;">
                    <option value="ratio">%</option>
                    <option value="amount">Amt</option>
                </select>
            </td>
            <td><input type="number" min="1" id="new-pax-range-min" style="width: 50px;"> - <input type="number" min="1" id="new-pax-range-max" style="width: 50px;"></td>
            <td><input type="number" step="0.01" id="new-adult-markup" style="width: 100px;"></td>
            <td><input type="number" step="0.01" id="new-child-markup" style="width: 100px;"></td>
            <td><button id="add-row-btn">Add</button></td>
        </tr>
    </table>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script>
        $(document).on('click', '.delete-btn-mup', function() {
            if (confirm('Are you sure you want to delete this row?')) {
                var autoId = $(this).data('id');
                var row = $(this).closest('tr');

                $.ajax({
                    url: 'ajax_delete_membership_markup.php',
                    type: 'POST',
                    data: { auto_id: autoId },
                    success: function(response) {
                        if (response == 'success') {
                            row.fadeOut(500, function() {
                                row.remove();
                            });
                        } else {
                            alert('Failed to delete the record.');
                        }
                    },
                    error: function() {
                        alert('Error in processing request.');
                    }
                });
            }
        });
    </script>

    <script>
        // JavaScript to handle showing and hiding the new row
        document.getElementById('show-new-row-btn').addEventListener('click', function () {
            const newRow = document.getElementById('new-row');
            const addRowButton = document.getElementById('show-new-row-btn');
            
            if (newRow.style.display === 'none') {
                newRow.style.display = '';
                addRowButton.style.display = 'none'; // Hide the "Add New Row" button
            }
        });
    </script>

    <!-- JavaScript to handle the AJAX -->
    <script>
        document.getElementById("add-row-btn").addEventListener("click", function() {
            // Get the values from the new row
            const markupType = document.getElementById("new-markup-type").value;
            const paxRangeMin = document.getElementById("new-pax-range-min").value;
            const paxRangeMax = document.getElementById("new-pax-range-max").value;
            const adultMarkup = document.getElementById("new-adult-markup").value;
            const childMarkup = document.getElementById("new-child-markup").value;
            const membershipid = <?php echo $membershipid; ?>;

            if (markupType && paxRangeMin && paxRangeMax && adultMarkup && childMarkup) {
                // Make AJAX call to save the new row to the database
                const xhr = new XMLHttpRequest();
                xhr.open("POST", "ajax_save_membership_group_data.php", true);
                xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                xhr.onreadystatechange = function() {
                    if (xhr.readyState == 4 && xhr.status == 200) {
                        // Check if the save was successful
                        if (xhr.responseText == "success") {
                            // Reload the page
                            location.reload();
                        } else {
                            alert("Pax Range overlap with others, please check your settings");
                        }
                    }
                };

                const data = `markup_type=${markupType}&pax_range_min=${paxRangeMin}&pax_range_max=${paxRangeMax}&adult_markup=${adultMarkup}&child_markup=${childMarkup}&membershipid=${membershipid}`;
                xhr.send(data);
            } else {
                alert("Please fill in all fields.");
            }
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const editButtons = document.querySelectorAll('.edit-btn');
            const saveButtons = document.querySelectorAll('.save-btn');

            editButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const row = button.closest('tr');
                    const cells = row.querySelectorAll('.editable');

                    cells.forEach(cell => {
                        const rawValue = cell.textContent.trim();
                        const type = cell.getAttribute('data-type');
                        let value = rawValue;

                        // Remove $ and % for editing
                        if (value.startsWith('$ ')) value = value.slice(2);
                        if (value.endsWith(' %')) value = value.slice(0, -2);

                        if (type === 'dropdown') {
                            // Dropdown for Markup Type
                            cell.innerHTML = `
                                <select style="margin: 0; width: 100px;">
                                    <option value="ratio" ${value === 'ratio' ? 'selected' : ''}>%</option>
                                    <option value="amount" ${value === 'amount' ? 'selected' : ''}>Amt</option>
                                </select>
                            `;
                        } else if (type === 'range') {
                            // Split Pax Range into two inputs
                            const [paxMin, paxMax] = value.split('-');
                            cell.innerHTML = `
                                <input type="number" value="${paxMin}" style="width: 50px;" /> -
                                <input type="number" value="${paxMax}" style="width: 50px;" />
                            `;
                        } else {
                            // Default for other fields
                            cell.innerHTML = `<input type="number" value="${value}" style="width: 100px;" />`;
                        }
                    });

                    button.style.display = 'none';
                    row.querySelector('.save-btn').style.display = 'inline-block';
                });
            });

            saveButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const row = button.closest('tr');
                    const id = row.getAttribute('data-id');
                    const cells = row.querySelectorAll('.editable');
                    const data = {};

                    cells.forEach((cell, index) => {
                        const input = cell.querySelector('input, select');
                        let value = input.value.trim();

                        // Restore $ and % for saving
                        if (cell.classList.contains('currency')) {
                            value = `$${value}`;
                        }
                        if (cell.classList.contains('percentage')) {
                            value = `${value}%`;
                        }

                        if (cell.getAttribute('data-type') === 'range') {
                            // Handle Pax Range
                            const inputs = cell.querySelectorAll('input');
                            data[`field${index + 1}_min`] = inputs[0].value;
                            data[`field${index + 1}_max`] = inputs[1].value;
                            cell.textContent = `${inputs[0].value}-${inputs[1].value}`;
                        } else {
                            data[`field${index + 1}`] = value;
                            cell.textContent = value;
                        }
                    });

                    // Send the data to a PHP script for updating the database
                    fetch('ajax_update_membership_markup.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ id, ...data })
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.success) {
                            location.reload();
                        } else {
                            alert('Pax Range overlap with others, please check your settings');
                            location.reload();
                        }
                    })
                    .catch(error => console.error('Error:', error));
                });
            });
        });
    </script>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
