<?php
// Office MailBox
if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'office-email') {
    include "header.php";

    $sql = "SELECT 
                te.mailbox,
                COUNT(DISTINCT CASE WHEN (vs.status = 'Closed') THEN te.conversation_id END) AS closed_count,
                COUNT(DISTINCT CASE WHEN (vs.status = 'In Progress') THEN te.conversation_id END) AS in_progress_count,
                COUNT(DISTINCT CASE WHEN (vs.status = 'Wait For Response') THEN te.conversation_id END) AS waiting_count,
                COUNT(DISTINCT CASE WHEN (vs.status IS NULL OR vs.status = '' OR vs.status = 'AI Processed') THEN te.conversation_id END) AS new_count,
                COUNT(DISTINCT CASE WHEN (vfo.object_id IS NULL AND (vs.status IS NULL OR (vs.status != 'Closed' AND vs.status != 'SPAM'))) THEN te.conversation_id END) AS unassigned_count
            FROM 
                tdu_emails te
            LEFT JOIN 
                vtiger_support vs ON te.conversation_id = vs.ticketid
            LEFT JOIN 
                vtiger_freetagged_objects vfo ON te.conversation_id = vfo.object_id
            JOIN (
                SELECT conversation_id, MAX(received_datetime) AS latest_received_datetime
                FROM tdu_emails
                WHERE folder = 'Inbox'
                GROUP BY conversation_id
            ) AS latest_email
                ON te.conversation_id = latest_email.conversation_id 
                AND te.received_datetime = latest_email.latest_received_datetime
            GROUP BY 
                te.mailbox
        ";
    $result = mysqli_query($conn, $sql);

    ?>
    <h1 style="text-align: center; margin-top: 20px;">Mailbox</h1>
    <div class="table-container" style="width: 70%; margin: auto;">
        <div class="table-wrapper">
            <?php
            $categories = [
                "Sales" => ["sales@turtledownunder.com.au", "groupsales@turtledownunder.com.au"],
                "Operation" => ["operations@turtledownunder.com.au", "groups@turtledownunder.com.au", "groups@turtledownunder.co.nz", "operations@turtledownunder.co.nz"],
                "Accounts" => ["accounts@turtledownunder.com.au", "accounts@turtledownunder.co.nz"],
                "Contracts" => ["contracts@turtledownunder.com.au", "contracts@turtledownunder.co.nz"],
                "Asia" => ["asia@turtledownunder.com.au"]
            ];
            $totalCounts = [
                'unassigned_count' => 0,
                'new_count' => 0,
                'in_progress_count' => 0,
                'waiting_count' => 0,
                'closed_count' => 0
            ];

            if (mysqli_num_rows($result) > 0) {
                $sql_allowed = "SELECT m.emails, m.emails_tag FROM tdu_users_mailbox m JOIN vtiger_users u ON m.id=u.id WHERE u.user_name = '$username';";
                $result_allowed = mysqli_query($conn, $sql_allowed);
                if (mysqli_num_rows($result_allowed) > 0) {
                    $row_allowed = mysqli_fetch_assoc($result_allowed);
                    
                    $emails_raw = '';
                    if (!empty($row_allowed['emails'])) {
                        $emails_raw .= $row_allowed['emails'];
                    }
                    if (!empty($row_allowed['emails_tag'])) {
                        $emails_raw .= ($emails_raw ? ',' : '') . $row_allowed['emails_tag'];
                    }
                
                    if (!empty($emails_raw)) {
                        $allowed = array_map('trim', explode(',', $emails_raw));
                    } else {
                        $allowed = getEmailsByRole($title);
                    }
                } else {
                    $allowed = getEmailsByRole($title);
                }
                foreach ($categories as $category => $emails) {
                    mysqli_data_seek($result, 0); // Reset the result pointer
                    $rows = []; // Collect rows for sorting
                    $hasRows = false;
            
                    // Collect rows for this category
                    while ($row = mysqli_fetch_assoc($result)) {
                        if (in_array($row['mailbox'], $emails)) {
                            if (in_array($row['mailbox'], $allowed)) {
                                $rows[] = $row;
                                $hasRows = true;
            
                                // Add counts to totals
                                $totalCounts['unassigned_count'] += $row['unassigned_count'];
                                $totalCounts['new_count'] += $row['new_count'];
                                $totalCounts['in_progress_count'] += $row['in_progress_count'];
                                $totalCounts['waiting_count'] += $row['waiting_count'];
                                $totalCounts['closed_count'] += $row['closed_count'];
                            }
                        }
                    }
            
                    // Sort rows by domain (.au first, then .nz)
                    usort($rows, function ($a, $b) {
                        $domainA = substr(strrchr($a['mailbox'], "."), 1);
                        $domainB = substr(strrchr($b['mailbox'], "."), 1);
                        return strcmp($domainA, $domainB); // Compare domains alphabetically
                    });
            
                    if ($hasRows) {
                        ?>
                        <h3><?php echo $category; ?></h3>
                        <table style="margin: 10px 0;">
                            <tr>
                                <th>Email</th>
                                <th>Untagged</th>
                                <th>New</th>
                                <th>In Progress</th>
                                <th>Wait For Response</th>
                                <th>Closed</th>
                                <th></th>
                            </tr>
                        <?php

                        $previousDomain = null;

                        foreach ($rows as $row) {
                            $currentDomain = substr(strrchr($row['mailbox'], "."), 1);

                            // Add an empty row if transitioning between domains
                            if ($previousDomain && $currentDomain !== $previousDomain) {
                                echo "<tr><td colspan='6' style='height: 10px;'></td></tr>";
                            }

                            // Display the current row
                            ?>
                            <tr>
                                <td style="width: 20%;">
                                    <a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>">
                                        <?php echo htmlspecialchars($row['mailbox']); ?>
                                    </a>
                                </td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&userid=unassigned"><?php echo htmlspecialchars($row['unassigned_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=New"><?php echo htmlspecialchars($row['new_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=In Progress"><?php echo htmlspecialchars($row['in_progress_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=Wait For Response"><?php echo htmlspecialchars($row['waiting_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=Closed"><?php echo htmlspecialchars($row['closed_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&folder=sent">Sent Items</a></td>
                            </tr>
                            <?php

                            // Update the previous domain
                            $previousDomain = $currentDomain;
                        }
                        echo "</table>";
                    }
                }
            
                // Display the totals table
                ?>
                <table style="margin: 10px 0;">
                    <tr>
                        <th></th>
                        <th>Untagged</th>
                        <th>New</th>
                        <th>In Progress</th>
                        <th>Wait For Response</th>
                        <th>Closed</th>
                        <th></th>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Total</td>
                        <td><?php echo htmlspecialchars($totalCounts['unassigned_count']); ?></td>
                        <td><?php echo htmlspecialchars($totalCounts['new_count']); ?></td>
                        <td><?php echo htmlspecialchars($totalCounts['in_progress_count']); ?></td>
                        <td><?php echo htmlspecialchars($totalCounts['waiting_count']); ?></td>
                        <td><?php echo htmlspecialchars($totalCounts['closed_count']); ?></td>
                        <td></td>
                    </tr>
                </table>
                <?php
            } else {
                echo "<p style='text-align:center;'>No records available.</p>";
            }
            ?>
        </div>
    </div>

    <style>
        .table-wrapper tr td {
            width: 12%;
        }
        .table-wrapper a {
            text-decoration: none;
        }
    </style>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'office-mailbox') {
    include "header.php";

    $mailboxFilter = $_GET['mailbox'] ?? '';
    $senderFilter = $_GET['sender'] ?? '';
    $subjectFilter = $_GET['subject'] ?? '';
    $receivedDateRange = $_GET['received_date_range'] ?? '';
    $quoteNoFilter = $_GET['quote_no'] ?? '';
    $vendorNameFilter = $_GET['vendor_name'] ?? '';
    $aiFilter = $_GET['ai_id'] ?? '';    //AI
    $statusFilter = $_GET['status'] ?? '';
    $tagFilter = $_GET['tag'] ?? '';
    $usertagFilter = '';
    $userid = $_GET['userid'] ?? '';

    $sql_allowed = "SELECT f.id, m.emails, m.emails_tag FROM tdu_users_mailbox m 
                    JOIN vtiger_users u ON m.id=u.id 
                    JOIN vtiger_freetags f ON f.tag = CONCAT(u.first_name, ' ', u.last_name) AND raw_tag = 'person'
                    WHERE u.user_name = '$username';";
    $result_allowed = mysqli_query($conn, $sql_allowed);

    if (mysqli_num_rows($result_allowed) > 0) {
        $row_allowed = mysqli_fetch_assoc($result_allowed);
        $userEmails = explode(',', $row_allowed['emails']);
        $tagEmails = explode(',', $row_allowed['emails_tag']);

        if (in_array($mailboxFilter, $tagEmails)) {
            $usertagFilter = $row_allowed['id'];
        } else if (!in_array($mailboxFilter, $userEmails)) {
            $usertagFilter = -1;
        }
    } else if (!in_array($mailboxFilter, getEmailsByRole($title))) {
        $usertagFilter = -1;
    }
    
    $uniqueid = $_GET['uniqueid'] ?? '';
    $folder = $_GET['folder'] == 'sent' ? 'Sent Items' : 'Inbox';
    $search = $_GET['search'] ?? '';
    if(!empty($search)) {
        $folder = '';
    }

    $receivedStartDate = '';
    $receivedEndDate = '';

    if (!empty($receivedDateRange)) {
        $receivedDates = explode(' to ', $receivedDateRange);
        $receivedStartDate = trim($receivedDates[0]);
        $receivedEndDate = isset($receivedDates[1]) ? trim($receivedDates[1]) : trim($receivedDates[0]);
    }

    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql = "SELECT 
                te.id, 
                te.mailbox, 
                te.sender_name, 
                te.subject, 
                te.received_datetime, 
                te.conversation_id, 
                te.recipient,
                te.folder,
                vs.quote_no, 
                tai.id as temp_ai_id,
                tai.country AS ai_country,
                tai.organizationid AS ai_organizationid,
                tai.contactid AS ai_contactid,
                tai.templateref AS ai_templateref,
                tai.travel_date AS ai_travel_date,
                vs.status, 
                tv.vendorName,
                latest_email.tagged_count
            FROM tdu_emails te
            LEFT JOIN vtiger_support vs 
                ON vs.ticketid = te.conversation_id
            JOIN (
                SELECT conversation_id, MAX(received_datetime) AS latest_received_datetime, COUNT(*) AS tagged_count
                FROM tdu_emails
                WHERE folder LIKE '%$folder%' AND (subject LIKE '%$search%' OR plaintext_body LIKE '%$search%')
                GROUP BY conversation_id
            ) AS latest_email
                ON te.conversation_id = latest_email.conversation_id 
                AND te.received_datetime = latest_email.latest_received_datetime
            LEFT JOIN (SELECT DISTINCT object_id FROM vtiger_freetagged_objects) vfo
                ON te.conversation_id = vfo.object_id
            LEFT JOIN tdu_vendors tv
                ON vs.vendorid = tv.vendorid
                
            LEFT JOIN
                tdu_temp_ai_quotes tai
                ON te.conversation_id = tai.conversation_id  -- Match conversation IDs
                AND tai.id = (                             -- Filter for the latest 'tai' record
                    SELECT MAX(sub_tai.id)
                    FROM tdu_temp_ai_quotes sub_tai
                    WHERE sub_tai.conversation_id = tai.conversation_id -- Find max ID AKA latest created
                )
            WHERE 1=1 
            ";

    if (!empty($mailboxFilter)) {
        $sql .= " AND te.mailbox LIKE '" . mysqli_real_escape_string($conn, $mailboxFilter) . "'";
    }
    if (!empty($senderFilter)) {
        if($folder == 'Inbox') {
            $sql .= " AND te.sender_name LIKE '%" . mysqli_real_escape_string($conn, $senderFilter) . "%'";
        } else {
            $sql .= " AND te.recipient LIKE '%" . mysqli_real_escape_string($conn, $senderFilter) . "%'";
        }
    }
    if (!empty($subjectFilter)) {
        $sql .= " AND te.subject LIKE '%" . mysqli_real_escape_string($conn, $subjectFilter) . "%'";
    }
    if (!empty($receivedStartDate) && !empty($receivedEndDate)) {
        $sql .= " AND DATE(te.received_datetime) BETWEEN '" . mysqli_real_escape_string($conn, $receivedStartDate) . "' 
                AND '" . mysqli_real_escape_string($conn, $receivedEndDate) . "'";
    }
    if (!empty($quoteNoFilter)) {
        $sql .= " AND vs.quote_no LIKE '%" . mysqli_real_escape_string($conn, $quoteNoFilter) . "%'";
    }
    if (!empty($vendorNameFilter)) {
        $sql .= " AND tv.vendorName LIKE '%" . mysqli_real_escape_string($conn, $vendorNameFilter) . "%'";
    }
    
    if (!empty($aiFilter)) {
        $sql .= " AND tai.id LIKE '%" . mysqli_real_escape_string($conn, $aiFilter) . "%'";
    }
    
    if (!empty($statusFilter)) {
        if($statusFilter == 'New') {
            $sql .= " AND (vs.status IS NULL OR vs.status = '' OR vs.status = 'AI Processed')";
        } else {
            $sql .= " AND vs.status LIKE '%" . mysqli_real_escape_string($conn, $statusFilter) . "%'";
        }
    }
    else if (empty($search)){
        $sql .= " AND (vs.status IS NULL OR (vs.status != 'Closed' AND vs.status != 'SPAM'))";
    }
    if (!empty($tagFilter)) {
        $sql .= " AND te.conversation_id IN (
                    SELECT vfo.object_id 
                    FROM vtiger_freetagged_objects vfo
                    WHERE tag_id = $tagFilter
                )";
    }
    if (!empty($usertagFilter)) {
        if ($usertagFilter == -1) {
            $sql .= " AND 1 != 1";
        } else {
            $sql .= " AND (
                        te.conversation_id IN (SELECT DISTINCT object_id FROM vtiger_freetagged_objects WHERE tag_id = $usertagFilter)
                        OR 
                        vfo.object_id IS NULL
                        OR
                        te.conversation_id NOT IN (SELECT DISTINCT vfo_sub.object_id FROM vtiger_freetagged_objects vfo_sub JOIN vtiger_freetags vf_sub ON vfo_sub.tag_id = vf_sub.id WHERE vf_sub.raw_tag = 'person')
                        )";
        }
    }
    if ($userid == 'unassigned') {
        $sql .= " AND (vs.status IS NULL OR (vs.status != 'Closed' AND vs.status != 'SPAM')) AND vfo.object_id IS NULL";
    }
    if (!empty($uniqueid)) {
        $sql.= " AND te.id = '". mysqli_real_escape_string($conn, $uniqueid). "'";
    }

    $sql.= " GROUP BY te.conversation_id";
    $sql_total = $sql;

    if (!empty($statusFilter)) {
        $sql .= " ORDER BY te.received_datetime DESC LIMIT $limit OFFSET $offset";
    } else {
        $sql .= " ORDER BY te.received_datetime ASC LIMIT $limit OFFSET $offset";
    }

    $result = mysqli_query($conn, $sql);
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }

        .tooltip-not-reply {
            position: relative;
            display: inline-block;
        }
        .tooltip-not-reply:hover::after {
            content: "This Email has not been replied for 24 hours";
            position: absolute;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            background-color: black;
            color: white;
            padding: 5px;
            border-radius: 5px;
            white-space: nowrap;
            font-size: 24px;
            opacity: 0.8;
            text-transform: none !important;
        }

        .tooltip-previous-reply {
            position: relative;
            display: inline-block;
        }
        .tooltip-previous-reply:hover::after {
            content: "This Conversation has previous messages";
            position: absolute;
            bottom: 125%;
            left: 50%;
            transform: translateX(-50%);
            background-color: black;
            color: white;
            padding: 5px;
            border-radius: 5px;
            white-space: nowrap;
            font-size: 24px;
            opacity: 0.8;
            text-transform: none !important;
        }
    </style>

    <div id="content-all" style="display: none;" style="width: 100%;">
        <h1 style="text-align: center; margin-top: 10px;"><?= $folder ?> <?= $mailboxFilter ?></h1>
        <table class="styled-table">
            <tr>
                <th style="padding: 0; text-align: center;">
                    <?php
                    $restricted_mailboxes = [
                        'groupsales@turtledownunder.com.au',
                        'operations@turtledownunder.com.au',
                        'groups@turtledownunder.com.au',
                        'asia@turtledownunder.com.au',
                    ];

                    if (!in_array($mailboxFilter, $restricted_mailboxes)) {
                        echo '<button type="button" onclick="openComposeForm()">Compose</button>';
                    }
                    ?>
                </th>
                <th>ID</th>
                <th>Time</th>
                <?php 
                if($folder == 'Inbox') {
                    echo '<th>From</th>';
                }
                else {
                    echo '<th>To</th>';
                }
                ?>
                <th></th>
                <th>Subject</th>
                <th></th>
                <th><?= (substr($mailboxFilter, 0, 8) === 'contract') ? 'Vendor' : 'Quote No' ?></th>
                <th>AI ref</th>  <!--AI-->
                <th>Status</th>
                <th>Tag</th>
            </tr>
            <form method="GET">
                <input type="hidden" name="opt" value="office-mailbox">
                <input type="hidden" name="mailbox" value="<?= htmlspecialchars($mailboxFilter) ?>">
                <input type="hidden" name="folder" value="<?= htmlspecialchars($_GET['folder'] ?? '') ?>">
                <tr>
                    <td></td><td></td>
                    <td>Search Email Subject/Content:</td><td colspan="7"><input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search); ?>"></td>
                    <td><button type="submit">Search</button></td>
                </tr>
                <tr>
                    <td style="padding: 0; text-align: center;"><button type="submit">Search</button></td>
                    <td style="max-width: 25px;"><input type="text" name="uniqueid" value="<?= htmlspecialchars($uniqueid) ?>"></td>
                    <td style="max-width: 100px;">
                        <input type="text" id="received_date_range" name="received_date_range" class="flatpickr-input" value="<?= htmlspecialchars($receivedDateRange) ?>">
                    </td>
                    <td><input type="text" name="sender" value="<?= htmlspecialchars($senderFilter) ?>"></td>
                    <td></td>
                    <td><input type="text" name="subject" value="<?= htmlspecialchars($subjectFilter) ?>"></td>
                    <td></td>
                    <?php if (substr($mailboxFilter, 0, 8) === 'contract') { ?>
                        <td><input type="text" name="vendor_name" value="<?= htmlspecialchars($vendorNameFilter) ?>"></td>
                    <?php } else { ?>
                        <td style="max-width: 50px;"><input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter) ?>"></td>
                    <?php } ?>
                    <td style="max-width: 25px;"><input type="text" name="ai_id" value="<?= htmlspecialchars($aiFilter) ?>"></td> <!--AI-->
                    <td style="max-width: 50px;">
                        <select name="status" style="width: 100%;">
                            <option value="">All exclude Closed/SPAM</option>
                            <option value="New" <?= $statusFilter === 'New' ? 'selected' : '' ?>>New</option>
                            <option value="In Progress" <?= $statusFilter === 'In Progress' ? 'selected' : '' ?>>In Progress</option>
                            <option value="Wait For Response" <?= $statusFilter === 'Wait For Response' ? 'selected' : '' ?>>Wait For Response</option>
                            <option value="Closed" <?= $statusFilter === 'Closed' ? 'selected' : '' ?>>Closed</option>
                            <option value="SPAM" <?= $statusFilter === 'SPAM' ? 'selected' : '' ?>>SPAM</option>
                        </select>
                    </td>
                    <td>
                        <input type="text" id="tag-input" autocomplete="off" style="width: 250px;" placeholder="Click SPACE to show all tags">
                        <input type="hidden" name="tag" id="tag-hidden" value="<?= $tagFilter ?>">

                        <!-- Custom suggestions dropdown -->
                        <div id="tag-suggestions" style="position: absolute; background-color: white; border: 1px solid #ccc; max-height: 500px; overflow-y: auto; width: 250px; display: none; z-index: 1000;"></div>
                        <script>
                            document.addEventListener('DOMContentLoaded', function () {
                                const category = "all";
                                const tagMap = {}; // id -> label
                                const tagFilter = "<?= $tagFilter ?>";

                                const tagSuggestions = document.getElementById('tag-suggestions');
                                const tagInput = document.getElementById('tag-input');
                                const hiddenInput = document.getElementById('tag-hidden');

                                if (category) {
                                    const xhr = new XMLHttpRequest();
                                    xhr.open('POST', 'ajax_update_tag.php', true);
                                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                                    xhr.onreadystatechange = function () {
                                        if (xhr.readyState === 4 && xhr.status === 200) {
                                            const tags = JSON.parse(xhr.responseText);
                                            tagSuggestions.innerHTML = ''; // Clear previous suggestions

                                            tags.forEach(function (tag) {
                                                if (tag.raw_tag && tag.tag_name) {
                                                    const label = `(${tag.raw_tag.toUpperCase()}) ${tag.tag_name}`;
                                                    const option = document.createElement('div');
                                                    option.classList.add('tag-option');
                                                    option.textContent = label;
                                                    // Add inline styles to the option
                                                    option.style.padding = '8px';
                                                    option.style.cursor = 'pointer';
                                                    tagSuggestions.appendChild(option);
                                                    tagMap[label] = tag.id; // Save mapping
                                                }
                                            });

                                            // If tagFilter is set, populate the tag-input field
                                            if (tagFilter) {
                                                for (const label in tagMap) {
                                                    if (tagMap[label] == tagFilter) {
                                                        tagInput.value = label;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    };

                                    xhr.send('action=fetch&category=' + encodeURIComponent(category));
                                }

                                // When user selects a tag, update the hidden input
                                tagInput.addEventListener('input', function () {
                                    const value = tagInput.value.toLowerCase();
                                    const options = tagSuggestions.querySelectorAll('.tag-option');
                                    let found = false;

                                    options.forEach(function (option) {
                                        const label = option.textContent.toLowerCase();
                                        if (label.includes(value)) {
                                            option.style.display = ''; // Show matching options
                                            found = true;
                                        } else {
                                            option.style.display = 'none'; // Hide non-matching options
                                        }
                                    });

                                    tagSuggestions.style.display = found ? 'block' : 'none'; // Show/hide dropdown
                                });

                                // Highlight the option on mouse hover
                                tagSuggestions.addEventListener('mouseover', function (e) {
                                    if (e.target.classList.contains('tag-option')) {
                                        e.target.style.backgroundColor = 'lightblue'; // Highlight on hover
                                    }
                                });

                                tagSuggestions.addEventListener('mouseout', function (e) {
                                    if (e.target.classList.contains('tag-option')) {
                                        e.target.style.backgroundColor = ''; // Reset background on mouse out
                                    }
                                });

                                // When an option is clicked, update input and hidden field
                                tagSuggestions.addEventListener('click', function (e) {
                                    if (e.target.classList.contains('tag-option')) {
                                        const label = e.target.textContent;
                                        tagInput.value = label;
                                        hiddenInput.value = tagMap[label]; // Set the hidden input value
                                        tagSuggestions.style.display = 'none'; // Hide suggestions after selection
                                    }
                                });

                                // Hide the dropdown if the user clicks outside
                                document.addEventListener('click', function (e) {
                                    if (!tagSuggestions.contains(e.target) && e.target !== tagInput) {
                                        tagSuggestions.style.display = 'none';
                                    }
                                });

                                // Clear input when it loses focus if not in the list
                                tagInput.addEventListener('blur', function () {
                                    const value = tagInput.value.toLowerCase();
                                    const options = tagSuggestions.querySelectorAll('.tag-option');
                                    let found = false;

                                    options.forEach(function (option) {
                                        if (option.textContent.toLowerCase().includes(value)) {
                                            found = true;
                                        }
                                    });

                                    if (!found) {
                                        tagInput.value = ''; // Clear input if not found
                                        hiddenInput.value = ''; // Reset the hidden input when clearing the input
                                    }
                                });

                                // Clear the input field when it's clicked
                                tagInput.addEventListener('click', function () {
                                    tagInput.value = ''; // Clear input on click
                                    hiddenInput.value = ''; // Reset the hidden input when clearing the input
                                });
                            });
                        </script>
                    </td>
                </tr>
            </form>
            <?php if ($result && mysqli_num_rows($result) > 0): ?>
                <form id="updateForm" method="POST" action="update_support.php">
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <?php
                    $conversation_id = $row['conversation_id'];
                    $sqlTags = "SELECT vf.id as tag_id, vf.tag as tag_name, vf.raw_tag as category
                                FROM vtiger_freetagged_objects vfo
                                LEFT JOIN vtiger_freetags vf ON vfo.tag_id = vf.id
                                WHERE vfo.object_id = '$conversation_id';";
                    $resultTags = mysqli_query($conn, $sqlTags);
                    $tags = [];
                    if ($resultTags && mysqli_num_rows($resultTags) > 0) {
                        while ($tagRow = $resultTags->fetch_assoc()) {
                            $tags[] = ['id' => $tagRow['tag_id'], 'name' => $tagRow['tag_name'], 'category' => $tagRow['category']];
                        }
                    }

                    $sqlFolder = "SELECT folder, received_datetime FROM tdu_emails WHERE conversation_id='$conversation_id' ORDER BY received_datetime DESC LIMIT 1;";
                    $resultFolder = mysqli_query($conn, $sqlFolder);

                    if ($resultFolder) {
                        $rowFolder = mysqli_fetch_assoc($resultFolder);

                        $currentTime = new DateTime(); // Current time
                        $receivedTime = new DateTime($rowFolder['received_datetime']); // Email received time
                        $interval = $currentTime->diff($receivedTime);

                        $alertRed = ($rowFolder['folder'] == 'Inbox' && $interval->h + $interval->d * 24 >= 24) ? ' style="background-color: #ffd1d1;"' : '';
                    }

                    $sqlAttach = "SELECT COUNT(*) AS attachment_count FROM tdu_emails e
                                JOIN tdu_attachments a ON e.message_id=a.message_id
                                WHERE e.conversation_id='$conversation_id';";
                    $resultAttach = mysqli_query($conn, $sqlAttach);
                    if ($resultAttach) {
                        $rowAttach = mysqli_fetch_assoc($resultAttach);
                        $attachmentCount = $rowAttach['attachment_count'] ?? 0;
                    } else {
                        $attachmentCount = 0;
                    }

                    $quote_no = $row['quote_no'];
                    $sqlTaskCount = "SELECT COUNT(*) AS task_count FROM tdu_tasks_management WHERE quote_no = '$quote_no';";
                    $resultTaskCount = mysqli_query($conn, $sqlTaskCount);
                    if ($resultTaskCount) {
                        $rowTaskCount = mysqli_fetch_assoc($resultTaskCount);
                        $relatedTaskCount = $rowTaskCount['task_count'] ?? 0;
                    } else {
                        $relatedTaskCount = 0;
                    }
                    ?>
                    <tr <?= $alertRed ?>>
                        <td style="padding: 0; text-align: center;">
                            <input type="checkbox" class="selectRow" name="selected_conversations[]" value="<?= htmlspecialchars($conversation_id) ?>">
                        </td>
                        <td><?= $row['id'] ?></td>
                        <td style="max-width: 100px;">
                            <?php 
                                $date = new DateTime($row['received_datetime']);
                                echo $date->format('d-M-Y H:i:s'); 
                            ?>
                        </td>
                        <td>
                            <?php
                            if('Inbox' == $row['folder']) {
                                echo htmlspecialchars($row['sender_name']) ;
                            } else {
                                echo htmlspecialchars($row['recipient']) ;
                            }
                            ?>
                        </td>
                        <td style="text-align: right; padding: 0;">
                            <?php
                            if(!empty($alertRed)) {
                                echo '<i class="fa-solid fa-triangle-exclamation tooltip-not-reply" style="color: red;"></i>';
                            }
                            ?>
                        </td>
                        <td>
                            <?php
                            if($row['tagged_count'] > 1) {
                                echo '<i class="fa-solid fa-envelopes-bulk tooltip-previous-reply"></i>';
                            }
                            ?>
                            <a href="quote.php?opt=email-content&conversation_id=<?= urlencode($conversation_id) ?>">
                                <?php 
                                if(isset($row['subject']) && $row['subject'] != '') {
                                    echo htmlspecialchars($row['subject']);
                                }
                                else {
                                    echo '(No subject)';
                                }
                                ?>
                            </a>
                        </td>
                        <td style="text-align: center; padding: 0;">
                            <?= $attachmentCount > 0 ? '<i class="fa-solid fa-paperclip"></i>' : '' ?>
                        </td>
                        <td style="max-width: 50px;">
                            <?= (substr($mailboxFilter, 0, 8) === 'contract') ? $row['vendorName'] : $row['quote_no'] ?>
                            <?php
                            if ($relatedTaskCount > 0) {
                                echo '<a href="task.php?opt=tasks&quote_no=' . $quote_no . '" title="View Related Tasks">
                                        <i class="fa-solid fa-clipboard-list"></i>
                                      </a>';
                            }
                            ?>
                        </td>
                        <td><!--AI START-->
                            <?php
                            // Check if temp_ai_id is available first
                            if (isset($row['temp_ai_id']) && $row['temp_ai_id'] != '') {
                                // Now, check if both contactid and organizationid also exist to activate the link
                                if (isset($row['ai_contactid']) && $row['ai_contactid'] != '' && isset($row['ai_organizationid']) && $row['ai_organizationid'] != '') {
                                    // --- Travel Date Formatting ---
                                    $travelDateFormatted = '';
                                    $dateFormat = 'Y-m-d'; // Easily modifiable date format

                                    if (!empty($row['ai_travel_date'])) {
                                        try {
                                            $travelDateTime = new DateTime($row['ai_travel_date']);
                                            $travelDateFormatted = $travelDateTime->format($dateFormat);
                                        } catch (Exception $e) {
                                            $travelDateFormatted = '';
                                        }
                                    }
                                    // --- End Travel Date Formatting ---

                                    $link_params = [
                                        'airef'          => $row['temp_ai_id'] ?? '',
                                        'country'        => $row['ai_country'] ?? '',
                                        'organisationid' => $row['ai_organizationid'] ?? '', // Will be present due to the condition
                                        'contactid'     => $row['ai_contactid'] ?? '',     // Will be present due to the condition
                                        'templateid'     => $row['ai_templateref'] ?? '',
                                        'travel_date'    => $travelDateFormatted,
                                        'email_subject' => $row['subject'] ?? ''
                                    ];

                                    $queryString = http_build_query($link_params);
                                    $targetPage = "quote.php?opt=create-fit&";
                                    $linkUrl = rtrim($targetPage, '&?') . (strpos($targetPage, '?') === false ? '?' : '&') . $queryString;

                                    // Output the clickable link
                                    echo '<a href="' . htmlspecialchars($linkUrl) . '">' . htmlspecialchars($row['temp_ai_id']) . '</a>';
                                } else {
                                    // temp_ai_id exists, but contactid or organizationid (or both) are missing. Display temp_ai_id as plain text.
                                    echo htmlspecialchars($row['temp_ai_id']);
                                }
                            } else {
                                // If temp_ai_id itself is missing or empty, display N/A
                                echo "N/A";
                            }
                            ?>
                        </td><!--AI END-->
                        <td style="max-width: 50px;">
                            <?php
                            if(isset($row['status']) && $row['status'] != '') {
                                echo htmlspecialchars($row['status']);
                            } else {
                                echo 'New';
                            }
                            ?>
                        </td>
                        <td>
                            <?php foreach ($tags as $tag): ?>
                                <?php 
                                $tag_c = $tag['category']; 
                                $background_color = '';
                                
                                switch ($tag_c) {
                                    case 'person':
                                        $background_color = 'blue';
                                        break;
                                    case 'region':
                                        $background_color = 'green';
                                        break;
                                    case 'type':
                                        $background_color = 'purple';
                                        break;
                                    case 'country':
                                        $background_color = 'orange';
                                        break;
                                }
                                ?>

                                <div class="tag" style="background-color: <?= $background_color ?>;">
                                    <?= htmlspecialchars($tag['name']) ?>
                                </div>
                            <?php endforeach; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
                <tr>
                    <td style="padding: 0; text-align: center;"><input type="checkbox" id="selectAll"> All</td>
                    <td colspan='10'>
                        <button type="button" id="modifyButton">Bulk Edit</button>
                    </td>
                </tr>
                </form>
            <?php endif; ?>

            <?php
            $total_result = mysqli_query($conn, $sql_total);
            $totalRecords = mysqli_num_rows($total_result);
            $totalPages = ceil($totalRecords / $limit);
            ?>
            <tr><td></td><td colspan="10">Number of results: <?= $totalRecords ?></td></tr>
        </table>

        <div id="popupForm" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 30%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
            <h2>Change for all selected Emails</h2><br>
            <form id="updatePopupForm">
                <label for="quote_no">Quote:</label>
                <input type="text" id="quote_no" name="quote_no" placeholder="UNCHANGE">
                <br>
                <label for="status">Status:</label>
                <select id="status" name="status">
                    <option value="">UNCHANGE</option>
                    <option value="In Progress">In Progress</option>
                    <option value="Wait For Response">Wait For Response</option>
                    <option value="Closed">Closed</option>
                    <option value="SPAM">SPAM</option>
                </select>
                <br>
                <?php $tagByTagID = getTagByTagID($conn); ?>
                <label for="tag">Add Tag:</label>
                <select id="tag" name="tag">
                    <option value="">NONE</option>
                    <?php foreach ($tagByTagID as $id => $tagName): ?>
                        <option value="<?= $id ?>"><?= htmlspecialchars($tagName) ?></option>
                    <?php endforeach; ?>
                </select>
                <br>
                <label for="delete_tag">Delete Tag:</label>
                <select id="delete_tag" name="delete_tag">
                    <option value="">NONE</option>
                    <?php foreach ($tagByTagID as $id => $tagName): ?>
                        <option value="<?= $id ?>"><?= htmlspecialchars($tagName) ?></option>
                    <?php endforeach; ?>
                </select>
                <br>
                <button type="button" id="submitUpdate">Save</button>
                <button type="button" id="cancelUpdate">Cancel</button>
            </form>
        </div>

        <script>
            // Select All functionality
            document.getElementById('selectAll').addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('.selectRow');
                checkboxes.forEach(checkbox => checkbox.checked = this.checked);
            });

            // Modify button logic
            document.getElementById('modifyButton').addEventListener('click', function() {
                const selected = document.querySelectorAll('input[name="selected_conversations[]"]:checked');
                if (selected.length === 0) {
                    alert('Please select at least one row.');
                    return;
                }
                // Open popup
                document.getElementById('popupForm').style.display = 'block';
            });

            // Submit update
            document.getElementById('submitUpdate').addEventListener('click', function() {
                const quoteNo = document.getElementById('quote_no').value;
                const status = document.getElementById('status').value;
                const tag = document.getElementById('tag').value;
                const deleteTag = document.getElementById('delete_tag').value;
                const selected = Array.from(document.querySelectorAll('input[name="selected_conversations[]"]:checked'))
                                    .map(checkbox => checkbox.value);

                if (deleteTag.trim() !== '') {
                    const confirmDelete = confirm(`Are you sure you want to delete tag?`);
                    if (!confirmDelete) {
                        return; // Stop execution if user cancels
                    }
                }

                // Use AJAX to send data to the server
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_bulk_save_email_status.php', true);
                xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        alert('Update successful!');
                        location.reload(); // Reload page to reflect changes
                    } else {
                        alert('Error updating records.');
                    }
                };
                xhr.send(JSON.stringify({ 
                    quote_no: quoteNo, 
                    status: status, 
                    tag: tag, 
                    delete_tag: deleteTag,
                    conversations: selected 
                }));
            });

            // Cancel button logic
            document.getElementById('cancelUpdate').addEventListener('click', function() {
                document.getElementById('popupForm').style.display = 'none'; // Hide popup
            });
        </script>
        
        <?php $allowed = getEmailsByRole($title); ?>
        <!-- Hidden compose form container -->
        <div id="composeFormContainer" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
            <h2 style="text-align: center;">Compose Email</h2>
            <form action="email_sender.php" method="POST" enctype="multipart/form-data">
                <div>
                    <label for="from">From:</label>
                    <input type="text" name="from" id="from" value="<?= htmlspecialchars($mailboxFilter) ?>" required readonly>
                </div>
                <div>
                    <label for="to">To:</label>
                    <div style="display: flex; gap: 5px;">
                        <input type="text" name="to" id="to" required style="flex: 1;">
                        <button type="button" onclick="openAddEmailModal('to')">+</button>
                    </div>
                </div>
                <div>
                    <label for="cc">CC:</label>
                    <div style="display: flex; gap: 5px;">
                        <input type="text" name="cc" id="cc" style="flex: 1;">
                        <button type="button" onclick="openAddEmailModal('cc')">+</button>
                    </div>
                </div>
                <div>
                    <label for="subject">Subject:</label>
                    <input type="text" name="subject" id="subject" required style="width: 100%;">
                </div>
                <div>
                    <label for="content">Content:</label>
                    <textarea name="content" id="content" rows="10" style="display: none;"></textarea>
                </div>
                <div id="attachments-container" style="margin-bottom: 10px;">
                    <label>Attachments:</label>
                    <div class="attachment-row" style="margin-bottom: 10px;">
                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                    </div>
                </div>
                <div>
                    <button type="submit" value="compose">Send</button>
                    <button type="button" onclick="closeComposeForm()">Cancel</button>
                </div>
            </form>
        </div>
        <style>
            .ck-editor__editable {
                height: 300px;
                overflow-y: auto;
            }
        </style>
        <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
        <script>
            ClassicEditor
                .create(document.querySelector('#content'), {
                    toolbar: {
                        items: ['heading', 'bold', 'italic', 'link', 'insertTable', 'undo', 'redo']
                    }
                })
                .catch(error => {
                    console.error(error);
                });
        </script>
        <script>
            function handleAttachmentChange(containerId, input) {
                const container = document.getElementById(containerId);

                // If the input has a file, display the file name
                if (input.files.length > 0) {
                    // Hide the input field
                    input.style.display = "none";

                    // Create a span to display the file name
                    const fileName = document.createElement("span");
                    fileName.textContent = input.files[0].name;
                    fileName.style.marginLeft = "10px";
                    fileName.style.fontSize = "0.9em";

                    // Add a remove icon
                    const removeButton = document.createElement("button");
                    removeButton.type = "button";
                    removeButton.style.marginLeft = "10px";
                    removeButton.style.border = "none";
                    removeButton.style.background = "none";
                    removeButton.style.color = "red";
                    removeButton.style.cursor = "pointer";
                    removeButton.style.fontSize = "1.2em";
                    removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                    removeButton.onclick = function () {
                        // Remove the parent row
                        input.parentElement.remove();
                    };

                    // Append the file name and remove button to the current row
                    input.parentElement.appendChild(fileName);
                    input.parentElement.appendChild(removeButton);

                    // Add a new file input for future attachments
                    const newField = document.createElement("div");
                    newField.className = "attachment-row";
                    newField.style.marginBottom = "10px";
                    newField.innerHTML = `
                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('${containerId}', this)">
                    `;

                    container.appendChild(newField);
                }
            }
        </script>

        <!-- Modal for adding email -->
        <div id="emailModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; justify-content: center; align-items: center;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 600px; text-align: center;">
                <h4>Search Email</h4>
                <input type="text" id="emailModalInput" placeholder="Enter email address" style="width: 100%; margin-bottom: 15px; height: 30px;" onkeyup="searchEmail(this.value)">
                <ul id="emailSuggestions" style="list-style: none; padding: 0; margin: 0;"></ul>
                <div style="margin-top: 10px; display: flex; gap: 10px; justify-content: center;">
                    <button onclick="confirmAddEmail()" style="padding: 5px 10px;">Add</button>
                    <button onclick="closeEmailModal()" style="padding: 5px 10px;">Cancel</button>
                </div>
            </div>
        </div>

        <script>
            function searchEmail(query) {
                const suggestions = document.getElementById('emailSuggestions');
                suggestions.innerHTML = ''; // Clear previous suggestions

                if (query.trim().length === 0) {
                    return;
                }
                
                const mailboxFilterId = <?php echo getEmailId($mailboxFilter); ?>;
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_outlook_contacts.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        const results = JSON.parse(xhr.responseText);
                        results.forEach(emailData => {
                            const li = document.createElement('li');
                            li.textContent = `${emailData.sender_name} (${emailData.email})`;
                            li.style.cursor = 'pointer';
                            li.style.padding = '5px 10px';
                            li.style.borderBottom = '1px solid #ddd';
                            li.onclick = function () {
                                document.getElementById('emailModalInput').value = emailData.email;
                                suggestions.innerHTML = ''; // Clear suggestions
                            };
                            suggestions.appendChild(li);
                        });
                    }
                };
                xhr.send(`query=${encodeURIComponent(query)}&mailboxFilterId=${mailboxFilterId}`);
            }
        </script>

        <script>
            let currentFieldId = null;

            function openAddEmailModal(fieldId) {
                currentFieldId = fieldId; // Store the current field ID
                document.getElementById('emailModalInput').value = ''; // Clear the input field
                document.getElementById('emailModal').style.display = 'flex'; // Show the modal
            }

            function closeEmailModal() {
                document.getElementById('emailModal').style.display = 'none'; // Hide the modal
                currentFieldId = null; // Reset the current field ID
            }

            function confirmAddEmail() {
                const emailInput = document.getElementById('emailModalInput').value.trim();
                if (emailInput && currentFieldId) {
                    const field = document.getElementById(currentFieldId);
                    const currentValue = field.value.trim();
                    field.value = currentValue ? `${currentValue}, ${emailInput}` : emailInput;
                }
                closeEmailModal(); // Close the modal after adding
            }

            // Show the compose form
            function openComposeForm() {
                document.getElementById('composeFormContainer').style.display = 'block';
            }

            // Close the compose form
            function closeComposeForm() {
                document.getElementById('composeFormContainer').style.display = 'none';
            }
        </script>

        <style>
            .styled-table th {
                text-align: left;
            }
            .styled-table td {
                word-wrap: break-word;
                white-space: normal;
                max-width: 150px;
                text-align: left;
            }

            .styled-table td input[type="text"], .styled-table td select, #composeFormContainer input[type="text"] {
                width: 100%;
                height: 30px;
                margin: 0;
            }
            #popupForm input, #popupForm select {
                width: 75%;
                height: 30px;
                margin-bottom: 20px;
            }
            .styled-table td select {
                width: 80%;
                height: 30px;
                margin: 0;
            }

            .tag {
                display: inline-block;
                padding: 5px 10px;
                margin: 5px 2px;
                font-size: 14px;
                background-color: green;
                color: white;
                border-radius: 12px;
                position: relative;
            }
        </style>

        <div class="pagination" style="margin-top: 0;">
            <div>
                <?php if ($page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                <?php endif; ?>

                <?php
                $max_pages = min($totalPages, $page + 2);
                for ($i = $page; $i <= $max_pages; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>

                <?php if ($page < $totalPages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                <?php endif; ?>
            </div>
            
            <form method="GET" action="" style="display:inline;">
                <?php
                foreach ($_GET as $key => $value) {
                    if ($key != 'page') {
                        echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                    }
                }
                ?>
                <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
                <button type="submit">Jump</button>
            </form>
        </div>
        <style>
            .pagination {
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 20px 0;
            }
            
            .pagination div {
                display: flex;
                align-items: center;
            }
            
            .pagination a {
                text-decoration: none;
                padding: 8px 12px;
                margin: 0 5px;
                border: 1px solid #334155;
                color: #334155;
                border-radius: 4px;
                transition: background-color 0.3s, color 0.3s;
            }
            
            .pagination a:hover {
                background-color: #334155;
                color: white;
            }
            
            .pagination input[type="number"] {
                width: 50px;
                padding: 10px;
                margin-left: 10px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            
            .pagination button {
                padding: 10px 10px;
                margin-left: 5px;
                border: none;
                border-radius: 4px;
                background-color: #334155;
                color: white;
                cursor: pointer;
                transition: background-color 0.3s;
            }
            
            .pagination button:hover {
                background-color: #334155;
            }
            
            tr:nth-child(odd) {
                background-color: #f9f9f9;
            }
        </style>

        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        <script>
            flatpickr("#received_date_range", { mode: "range", dateFormat: "Y-m-d" });
        </script>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'email-content') {
    include "header.php";
    $conversation_id = $_GET['conversation_id'] ?? '';  // Use conversation_id instead of id

    if(!isset($_GET['replied'])) {
        $sql_history = "INSERT INTO vtiger_support_history (conversation_id, details, created_by) VALUES ('$conversation_id', 'Read Email', '$username_ajax')";
        mysqli_query($conn, $sql_history);
    }

    // tags
    $sqlTags = "SELECT vf.id as tag_id, vf.tag as tag_name, vf.raw_tag as category
                FROM vtiger_freetagged_objects vfo
                LEFT JOIN vtiger_freetags vf ON vfo.tag_id = vf.id
                WHERE vfo.object_id = '$conversation_id';";
    $resultTags = mysqli_query($conn, $sqlTags);
    $tags = [];
    while ($row = $resultTags->fetch_assoc()) {
        $tags[] = ['id' => $row['tag_id'], 'name' => $row['tag_name'], 'category' => $row['category']];
    }

    // status, quote_no
    $sqlTicket = "SELECT vs.status, vs.quote_no, tv.vendorName FROM vtiger_support vs
                LEFT JOIN tdu_vendors tv ON vs.vendorid = tv.vendorid
                WHERE vs.ticketid = '$conversation_id';";
    $resultTicket = mysqli_query($conn, $sqlTicket);
    if ($resultTicket && mysqli_num_rows($resultTicket) > 0) {
        $row = mysqli_fetch_assoc($resultTicket);
        $status = $row['status'] ?? '';
        $quote_no = $row['quote_no'] ?? '';
        $vendorName = $row['vendorName'] ?? '';
    } else {
        $status = '';
        $quote_no = '';
    }

    // emails main query
    $sql = "SELECT msgid, message_id, mailbox, sender, sender_name, cc, subject, received_datetime, full_body, folder, recipient
            FROM tdu_emails 
            WHERE conversation_id='$conversation_id' ORDER BY received_datetime DESC";  // Fetch all emails for the conversation
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $first_row = mysqli_fetch_assoc($result);
        $subject_line = $first_row['subject'];
        $folder_first = $first_row['folder'];
        $main_mailbox = $first_row['mailbox'];
        mysqli_data_seek($result, 0);
    }
    
    $sql_ai = "SELECT msgid, message_id, mailbox, sender, sender_name, cc, subject, received_datetime, full_body, folder, recipient
            FROM tdu_emails 
            WHERE conversation_id='$conversation_id' AND folder='Inbox' ORDER BY received_datetime DESC";  // Fetch all emails for the conversation
    $result_ai = mysqli_query($conn, $sql_ai);

    if ($result_ai && mysqli_num_rows($result_ai) > 0) {
        $first_row_ai = mysqli_fetch_assoc($result_ai);
        mysqli_data_seek($result_ai, 0);
    }
    ?>
    <!-- Loading Spinner -->
    <div id="loadingSpinner" class="spinner-container" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 9999; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
        <div class="spinner"></div>
        <div style="text-align: center;">Loading content, please wait...</div>
    </div>
    <style>
        .spinner {
            margin: 0 auto 10px;
            width: 50px;
            height: 50px;
            border: 6px solid #ccc;
            border-top-color: #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>

    <div style="width: 75%; margin: auto; padding: 20px; border-bottom: 1px solid #ccc;">
        <h1 style="display: flex; justify-content: space-between; align-items: center; margin: 0;">
            <span><a style="margin: 0;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a> <?= htmlspecialchars($subject_line) ?></span>
            <button id="historyBtn" onclick="openHistoryModal()">History</button>
        </h1>
        <div class="tag-container">
            <div style="display: flex; align-items: center;">
                <!-- Section for editing status -->
                <div id="edit-status" style="margin: 20px 0;">
                    <label for="status-select">Status:</label>
                    <select id="status-select" style="width: 150px; height: 30px; margin: 0;">
                        <option value="">New</option>
                        <option value="In Progress" <?= $status === 'In Progress' ? 'selected' : '' ?>>In Progress</option>
                        <option value="Wait For Response" <?= $status === 'Wait For Response' ? 'selected' : '' ?>>Wait For Response</option>
                        <option value="Closed" <?= $status === 'Closed' ? 'selected' : '' ?>>Closed</option>
                        <option value="SPAM" <?= $status === 'SPAM' ? 'selected' : '' ?>>SPAM</option>
                    </select>
                    <button onclick="saveStatus('<?= $conversation_id ?>')">
                        <i class="fa-solid fa-check"></i> Save
                    </button>
                </div>

                <?php
                if (substr($main_mailbox, 0, 8) === 'contract') {
                    if(empty($vendorName) || $title == 'admin')  {
                        ?>
                        <div id="edit-vendor" style="margin: 20px;">
                            <label for="vendor-input">Vendor Name:</label>
                            <input type="text" id="vendor-input" value="<?= htmlspecialchars($vendorName) ?>" style="width: 150px; height: 30px;" list="vendor-id-list" oninput="updateVendorId()">
                            <datalist id="vendor-id-list">
                                <?php
                                $sqlr = "SELECT vendorid, vendorName FROM tdu_vendors";
                                $resultr = mysqli_query($conn, $sqlr);
    
                                while ($rowr = mysqli_fetch_assoc($resultr)) {
                                    echo "<option value=\"{$rowr['vendorName']}\" data-id=\"{$rowr['vendorid']}\">";
                                }
                                ?>
                            </datalist>
                            
                            <!-- Hidden input for vendor ID -->
                            <input type="hidden" id="vendor-id" name="vendor_id" value="<?= htmlspecialchars($vendor_id) ?>">
    
                            <button onclick="saveVendor('<?= $conversation_id ?>')">
                                <i class="fa-solid fa-check"></i> Save
                            </button>
                        </div>
                        <?php
                    } else {
                        echo '<div style="margin: 20px;">Vendor Name: '. htmlspecialchars($vendorName). '</div>';
                    }
                } else {
                    if(empty($quote_no) || $title == 'admin') {
                        ?>
                        <!-- Section for editing quote_no -->
                        <div id="edit-quote" style="margin: 20px;">
                            <label for="quote-input">Quote No:</label>
                            <input type="text" id="quote-input" value="<?= htmlspecialchars($quote_no) ?>" style="width: 150px; height: 30px;" list="quote_no-list" oninput="filterQuotes()">
                            <datalist id="quote_no-list"></datalist>
                            <button onclick="saveQuote('<?= $conversation_id ?>')">
                                <i class="fa-solid fa-check"></i> Save
                            </button>
                        </div>
                        <script>
                            let allQuotes = <?php echo json_encode(fetchTDUNames80($conn)); ?>;

                            function filterQuotes() {
                                const input = document.getElementById('quote-input').value.toLowerCase(); // Get input value
                                const datalist = document.getElementById('quote_no-list');
                                
                                // Clear the previous options
                                datalist.innerHTML = '';

                                // Filter quotes based on the input (partial match)
                                const filteredQuotes = allQuotes.filter(quote => quote.toLowerCase().includes(input));

                                // Limit the number of results to 5
                                const top10Quotes = filteredQuotes.slice(0, 5);

                                // Add the filtered quotes as options in the datalist
                                top10Quotes.forEach(quote => {
                                    const option = document.createElement('option');
                                    option.value = quote;
                                    datalist.appendChild(option);
                                });
                            }
                        </script>
                        <?php
                    }
                    else {
                        echo '<div style="margin: 20px;">Quote No: '. htmlspecialchars($quote_no). '</div>';
                    }
                }
                ?>
            </div>

            <!-- Toggle Edit Mode -->
            <button class="tag-add-btn" onclick="toggleAddTagSelect()">
                <i class="fa-solid fa-link"></i> Add Tag
            </button>
            
            <?php
            if($title == 'admin') {
                ?>
                <button class="tag-create-btn" onclick="toggleCreateTagForm()">
                    <i class="fa-solid fa-plus"></i> Create Tag
                </button>

                <button class="tag-edit-btn" onclick="toggleEditMode()" style="background-color: red;">
                    <i class="fa-solid fa-pen-to-square"></i> Delete Tags
                </button>
                <?php
            }
            ?>

            <?php
                $sql_quoteid = "SELECT MIN(quoteid) AS quoteid FROM vtiger_quotes WHERE quote_no='$quote_no';";
                $result_quoteid = $conn->query($sql_quoteid);
                if ($result_quoteid->num_rows > 0) {
                    $row_quoteid = $result_quoteid->fetch_assoc();
                    $quoteid = $row_quoteid['quoteid'] ?? '';
                } else {
                    $quoteid = '';
                }

                if ($quoteid != '') {
                    $sql_notes = "SELECT COUNT(*) AS note_count FROM vtiger_notes WHERE quoteid='$quoteid'";
                    $result_notes = $conn->query($sql_notes);
                    $row_notes = $result_notes->fetch_assoc();
                    $note_count = $row_notes['note_count'] ?? 0; // Default to 0 if no notes found
                    ?>
                    <button id="toggle-notes" style="position: relative;">
                        Show Quote Notes
                        <?php if ($note_count > 0): ?>
                            <span style="position: absolute; top: -5px; right: -5px; background: red; color: white; font-size: 12px; font-weight: bold; width: 18px; height: 18px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                <?php echo $note_count; ?>
                            </span>
                        <?php endif; ?>
                    </button>
                    <?php
                }
            ?>

            <?php if (!in_array($main_mailbox, ['sales@turtledownunder.com.au', 'groupsales@turtledownunder.com.au', 'asia@turtledownunder.com.au'])) : ?>
                <button id="sidebar-toggle" style="background-color: #2c70a2; color: white;">TAI Summary</button>
            <?php endif; ?>

            <?php
                // --- Fetch Existing Quote Data ---
                $existing_temp_ai_quote = null;
                if (isset($conversation_id) && $conversation_id && isset($conn) && $conn) {
                    $temp_ai_sql = "SELECT * FROM tdu_temp_ai_quotes WHERE conversation_id = ? ORDER BY id DESC LIMIT 1";
                    $stmt_ai = mysqli_prepare($conn, $temp_ai_sql);
                    if ($stmt_ai) {
                        mysqli_stmt_bind_param($stmt_ai, "s", $conversation_id);
                        if (mysqli_stmt_execute($stmt_ai)) {
                            $temp_ai_result = mysqli_stmt_get_result($stmt_ai);
                            if ($temp_ai_result) {
                                $existing_temp_ai_quote = mysqli_fetch_assoc($temp_ai_result); // Fetch row or null
                                mysqli_free_result($temp_ai_result);
                            } else { error_log("Error getting result set for temp AI query: " . mysqli_error($conn)); }
                        } else { error_log("Error executing prepared statement for temp AI query: " . mysqli_stmt_error($stmt_ai)); }
                        mysqli_stmt_close($stmt_ai);
                    } else { error_log("Error preparing statement for temp AI query: " . mysqli_error($conn)); }
                } else {
                    if (!isset($conversation_id) || !$conversation_id) { error_log("Conversation ID not available for fetching existing AI quote."); }
                    if (!isset($conn) || !$conn) { error_log("DB connection not available for fetching existing AI quote."); }
                }
                // Prepare data for JavaScript (ensure it's null if no data)
                $js_existing_quote_data = $existing_temp_ai_quote ? $existing_temp_ai_quote : null;

                // Assume $sender is defined from $first_row['sender'] or similar elsewhere before this block
                $sender = $first_row_ai['sender'] ?? ''; // Example: Make sure $sender is defined
            ?>

            <?php if ($title == 'admin' || $title == 'sales' || $title == 'group') : ?>
                <button id="quotegensidebar-toggle" style="background-color: #2c70a2; color: white; ">TAI Quote</button>
            <?php endif; ?>

            <!-- AI Update confirmation / invoice start -->
            <button id="runAIUpdate" style="background-color: orange; color: black;">TAI Invoice/Confirmation</button>
            <div id="aiExtractionModal" style="display:none; position:fixed; top:15%; left:50%; transform:translateX(-50%); background:#fff; border:1px solid #ccc; padding:20px; z-index:1000; max-height: 80vh;">
                <h2>AI Extraction Results</h2>
                <div id="loadingMessage" class="spinner"></div>
                <pre id="modalContent" style="white-space:pre-wrap;"></pre>
                <button type="button" style="margin-top: 20px;" onclick="window.location.reload()">Close</button>
            </div>
            <style>
                .spinner {
                    margin: 100px 200px;
                    width: 50px;
                    height: 50px;
                    border: 6px solid #ccc;
                    border-top-color: #007bff;
                    border-radius: 50%;
                    animation: spin 1s linear infinite;
                }
                @keyframes spin {
                    to { transform: rotate(360deg); }
                }
            </style>
            <script>
                document.getElementById('runAIUpdate').addEventListener('click', function () {
                    if (!confirm("Are you sure you want to run the AI update for this invoice/confirmation?")) {
                        return;
                    }

                    const conversationId = "<?= $conversation_id ?>"; // Replace with actual conversation ID
                    const modal = document.getElementById('aiExtractionModal');
                    const content = document.getElementById('modalContent');
                    const loadingMessage = document.getElementById('loadingMessage');

                    content.textContent = '';
                    modal.style.display = 'block';
                    loadingMessage.style.display = 'block';

                    fetch('ajax_run_ai_update_inv_conf.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `conversation_id=${conversationId}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        loadingMessage.style.display = 'none';
                        content.innerHTML = ''; // Clear any previous content

                        const confirmationPre = document.createElement('pre');
                        confirmationPre.textContent = JSON.stringify(data.confirmation_ai_array, null, 2);
                        confirmationPre.style.marginBottom = '20px';
                        confirmationPre.style.background = '#f4f4f4';
                        confirmationPre.style.padding = '10px';
                        confirmationPre.style.border = '1px solid #ccc';
                        confirmationPre.style.borderRadius = '5px';

                        const invoicePre = document.createElement('pre');
                        invoicePre.textContent = JSON.stringify(data.invoice_ai_array, null, 2);
                        invoicePre.style.background = '#f4f4f4';
                        invoicePre.style.padding = '10px';
                        invoicePre.style.border = '1px solid #ccc';
                        invoicePre.style.borderRadius = '5px';

                        content.appendChild(confirmationPre);
                        content.appendChild(invoicePre);
                    })
                    .catch(error => {
                        loadingMessage.style.display = 'none';
                        console.error('Error:', error);
                        content.textContent = 'Failed to run AI update.';
                    });
                });
            </script>
            <!-- AI Update confirmation / invoice end -->


            <?php /* --- STYLES --- */ ?>
            <style>
                .container { display: block; }
                .content { padding: 20px; }
                .sidebar {
                    background-color: #f0f0f0;
                    position: fixed;
                    transition: transform 0.3s ease-in-out;
                    padding: 20px;
                    box-sizing: border-box;
                    overflow-y: auto;
                    z-index: 1000;
                }
                #summarySidebar {
                    width: 50vw; height: 100vh; top: 0; right: 0;
                    transform: translateX(100%);
                    box-shadow: -2px 0 5px rgba(0, 0, 0, 0.2);
                }
                #summarySidebar.open { transform: translateX(0); }
                #quoteGenSidebar {
                    width: 100vw; max-width: 1000px; height: 75vh;
                    top: 0; left: 50%;
                    transform: translate(-50%, -100%);
                    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
                    border-radius: 0 0 8px 8px;
                    display: flex; /* Use flexbox for layout */
                    flex-direction: column; /* Stack content and footer */
                }
                #quoteGenSidebar.open { transform: translate(-50%, 0); }

                /* Ensure content area scrolls, not the whole sidebar */
                 #quoteGenContent {
                    flex-grow: 1; /* Takes available space */
                    overflow-y: auto;
                    padding: 0 10px 10px 10px; /* Padding inside content */
                    max-height: calc(75vh - 60px); /* Adjust based on footer height */
                }

                /* Modal Styles (Shared) */
                .modal {
                    display: none; position: fixed; z-index: 1050;
                    left: 0; top: 0; width: 100%; height: 100%;
                    overflow: auto; background-color: rgba(0,0,0,0.5);
                }
                .modal-content {
                    background-color: #fefefe; margin: 10% auto; padding: 20px;
                    border: 1px solid #888; width: 80%; max-width: 600px; /* Adjusted max-width */
                    position: relative; border-radius: 5px;
                    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
                }
                .close-modal {
                    color: #aaa; float: right; font-size: 28px; font-weight: bold;
                    cursor: pointer; line-height: 20px; position: absolute; top: 10px; right: 15px;
                }
                .close-modal:hover, .close-modal:focus { color: black; text-decoration: none; }

                /* Itinerary Modal Specific */
                #itineraryModalContent table { width: 100%; border-collapse: collapse; margin-top: 10px; }
                #itineraryModalContent th, #itineraryModalContent td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                #itineraryModalContent th { background-color: #e9e9e9; }

                /* Report Modal Specific */
                #reportModalContent label { display: block; margin-bottom: 8px; font-weight: bold;}
                #reportReasonTextarea {
                    width: 100%; min-height: 100px; padding: 8px;
                    border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box;
                    font-family: inherit; font-size: 0.95em; margin-bottom: 15px;
                 }
                 .report-modal-buttons { display: flex; justify-content: flex-end; gap: 10px; margin-top: 10px;}
                 .report-modal-buttons button { padding: 8px 15px; border-radius: 4px; cursor: pointer; border: none; font-size: 0.95em;}
                 #submitReportBtn { background-color: #28a745; color: white;}
                 #cancelReportBtn { background-color: #6c757d; color: white;}


                /* Compact Segment Card & AI Details Styles (Keep as before) */
                 .segments-container { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 15px; margin-bottom: 20px; }
                .segment-card-compact { border: 1px solid #ccc; border-radius: 4px; background-color: #fff; box-shadow: 1px 1px 4px rgba(0,0,0,0.08); display: flex; flex-direction: column; font-size: 0.9em; }
                .segment-card-compact .card-header { background-color: #f8f9fa; padding: 8px 12px; border-bottom: 1px solid #eee; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 5px; }
                .segment-card-compact .card-header h5 { margin: 0; font-size: 1.1em; white-space: nowrap; }
                .segment-card-compact .criteria-summary { font-size: 0.9em; color: #555; text-align: right; }
                .segment-card-compact .card-content { padding: 10px 12px; flex-grow: 1; line-height: 1.4; }
                .segment-card-compact .template-summary-line { margin-bottom: 4px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
                .segment-card-compact .template-summary-line strong { color: #333; }
                .segment-card-compact .no-template-msg { color: #888; font-style: italic; margin-top: 10px; text-align: center; }
                .segment-card-compact .card-buttons { margin-top: 10px; padding-top: 8px; border-top: 1px solid #eee; padding: 8px 12px 10px 12px; }
                .segment-card-compact .card-button { padding: 4px 8px; font-size: 0.8em; }
                .view-items-btn { background-color: #6c757d; color: white;}

                .ai-response-details-compact { margin-top: 20px; border-top: 1px solid #ccc; padding-top: 15px; }
                .ai-response-details-compact > details > summary { cursor: pointer; font-weight: bold; font-size: 1.1em; margin-bottom: 15px; padding-bottom: 5px; border-bottom: 1px solid #eee; }
                .ai-key-details-grid { display: grid; grid-template-columns: auto 1fr; gap: 8px 12px; padding: 15px; background-color: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px; margin-bottom: 15px; font-size: 0.95em; }
                .ai-key-details-grid dt { font-weight: bold; color: #555; text-align: right; }
                .ai-key-details-grid dd { margin: 0; word-break: break-word; }
                .ai-key-details-grid dd ul { margin: 0; padding-left: 18px; list-style: disc; font-size: 0.95em; }
                .ai-key-details-grid dd ul li { margin-bottom: 2px; }
                .ai-reasoning-block, .ai-itinerary-block { background-color: #e9ecef; padding: 10px; border: 1px solid #ced4da; border-radius: 4px; font-size: 0.95em; line-height: 1.5; white-space: pre-wrap; word-break: break-word; max-height: 150px; overflow-y: auto; }
                .ai-raw-json-details { margin-top: 15px; border-top: 1px dashed #ddd; padding-top: 10px; }
                .ai-raw-json-details summary { cursor: pointer; font-size: 0.9em; color: #6c757d; font-weight: normal; margin-bottom: 5px; }
                .ai-raw-json-details pre { background-color: #eef; padding: 10px; border-radius: 4px; white-space: pre-wrap; word-break: break-all; max-height: 250px; overflow-y: auto; font-size: 0.85em; margin: 0; }
                .ai-parse-error-block { margin-top: 10px; padding: 10px; background-color: #fff0f0; border: 1px dashed #dc3545; border-radius: 4px; }
                .ai-parse-error-block h5 { margin:0 0 5px 0; color: #dc3545; font-size: 1em; }
                .ai-parse-error-block pre { white-space: pre-wrap; word-break: break-all; font-size: 0.9em; margin:0; }
                .category-filter-container { display: flex; align-items: center; gap: 8px; margin-bottom: 15px; padding: 10px; /* Add padding */ border-bottom: 1px solid #eee; }
                .category-filter-container label { margin: 0; }
                .category-filter-container select { width: auto; min-width: 100px; height: 30px; padding: 5px; }

                /* Footer Styles */
                .quoteGenSidebarFooter {
                    padding: 15px 10px 10px 10px; /* Padding top, sides, bottom */
                    border-top: 1px solid #ccc;
                    background-color: #f8f9fa; /* Optional background */
                    margin-top: auto; /* Pushes footer to bottom in flex container */
                    flex-shrink: 0; /* Prevent footer from shrinking */
                }
                .footer-button-row { display: flex; justify-content: flex-end; gap: 10px; align-items: center; }
                .quoteGenSidebarFooter button { padding: 8px 15px; font-size: 0.95em; border-radius: 4px; cursor: pointer; border: none; }
                .report-quote-btn { background-color: #ffae42; color: black; margin-right: auto; /* Push left */ }
                .regenerate-quote-btn { background-color: #ffc107; color: black; }
                .save-quote-btn { background-color: #28a745; color: white; }
                .close-sidebar-btn { background-color: #dc3545; color: white; }

                #generateAiQuoteBtnInline { /* Inline generate button styling */
                    background-color: #17a2b8; color: white; padding: 8px 15px; border: none; border-radius: 4px;
                    cursor: pointer; font-size: 0.95em; margin-top: 15px; display: block;
                    width: fit-content; margin-left: auto; margin-right: auto; /* Center */
                }
                
                .plain-textarea-lookalike {
                    border: 1px solid #ccc;
                    border-radius: 4px;
                    padding: 8px;
                    min-height: 100px; /* Or desired height */
                    width: 100%;
                    box-sizing: border-box;
                    background-color: #fff; /* Match textarea background */
                    font-family: inherit;   /* Use standard page font */
                    font-size: 0.95em;      /* Match textarea font size */
                    line-height: 1.4;       /* Control line spacing */
                    cursor: text;           /* Show text cursor */
                    overflow-y: auto;       /* Allow scrolling if content exceeds height */
                }
                
                /* Style when focused */
                .plain-textarea-lookalike:focus {
                    outline: none; /* Remove default focus outline */
                    border-color: #80bdff; /* Example focus border color */
                    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25); /* Example focus shadow */
                }
                
                /* Simulate placeholder using ::before pseudo-element */
                .plain-textarea-lookalike:empty::before {
                    content: attr(data-placeholder); /* Get placeholder text from data-attribute */
                    color: #6c757d; /* Placeholder text color (e.g., gray) */
                    pointer-events: none; /* Allow clicking through the placeholder */
                    display: block; /* Or inline-block */
                }
            </style>
            <?php /* --- END STYLES --- */ ?>

            <?php /* --- SIDEBAR HTML STRUCTURES --- */ ?>

            <!-- Quote Gen Sidebar -->
            <div class="sidebar" id="quoteGenSidebar">
                <div id="quoteGenContent"> <?php /* Content takes available space */ ?>
                    <p>Loading Email AI data...</p>
                </div>

                <div class="quoteGenSidebarFooter"> <?php /* Footer container */ ?>
                    <div id="forwardedEmailContainer" style="display: none; margin-bottom: 12px; padding: 0 5px;">
                        <label for="forwardedEmailInput" style="display: block; margin-bottom: 5px; font-size: 0.9em; font-weight: bold; color: #333;">Client Email (Forwarded):</label>
                        <input type="email" id="forwardedEmailInput" placeholder="Enter client's email address" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
                        <small style="display: block; font-size: 0.8em; color: #666; margin-top: 4px;">Required because original sender is internal.</small>
                    </div>
                    <div class="footer-button-row">
                        <button id="reportAiQuoteBtn" class="report-quote-btn" style="display: none;">Report</button>
                        <button id="regenerateAiQuoteBtn" class="regenerate-quote-btn" style="display: none;">Regenerate</button>
                        <button id="saveQuoteBtn" class="save-quote-btn" style="display: none;">Save Quote</button>
                        <button class="close-sidebar-btn" onclick="togglequoteGenSidebar()">Close</button>
                    </div>
                </div>
            </div>

            <!-- Itinerary Modal -->
            <div id="itineraryModal" class="modal">
                <div class="modal-content">
                    <span id="closeItineraryModal" class="close-modal" onclick="closeItineraryModal()">×</span>
                    <h4>Template Itinerary Items</h4>
                    <div id="itineraryModalContent"></div>
                </div>
            </div>

            <!-- ****** NEW: Report Modal ****** -->
            <div id="reportModal" class="modal">
                <div class="modal-content">
                    <span id="closeReportModalBtn" class="close-modal" onclick="closeReportModal()">×</span>
                    <h4>Report AI Suggestion</h4>
                    <div id="reportModalContent">
                        <label for="reportReasonDiv">Reason for Reporting:</label>
                        <!-- Replace textarea with div -->
                        <div
                            id="reportReasonDiv"
                            class="plain-textarea-lookalike"
                            contenteditable="true"
                            role="textbox"
                            aria-multiline="true"
                            data-placeholder="Please explain why this suggestion is incorrect or needs review..."
                        ></div>
                        <!-- End replacement -->
                        <div class="report-modal-buttons">
                             <button type="button" id="cancelReportBtn" onclick="closeReportModal()">Cancel</button>
                             <button type="button" id="submitReportBtn">Submit Report</button>
                        </div>
                    </div>
                </div>
            </div>
             <!-- ****** END: Report Modal ****** -->


            <!-- Summary Sidebar (Keep existing structure) -->
            <div class="sidebar" id="summarySidebar">
                 <?php
                    // Variables assumed defined before this block
                    $message = $first_row ?? null;
                    $body = $message['full_body'] ?? '';
                    $subject = $message['subject'] ?? '';
                    $message_id = $message['message_id'] ?? '';
                    $mailbox = $message['mailbox'] ?? '';
                    // $sender already defined above
                    $cc = $message['cc'] ?? '';

                    // Construct Gemini prompt (Keep as before)
                    $geminiPrompt = "Analyse and Summarise the following email:\n";
                    $geminiPrompt .= "Email Start-----\n";
                    $geminiPrompt .= " Subject - ". $subject ."\n";
                    $geminiPrompt .= " Body - ". $body ."\n";
                    $geminiPrompt .= "------- Email End\n\n";
                    $geminiPrompt .= "Here are some instructions:\n";
                    $geminiPrompt .= " - Do it all in only HTML format\n";
                    $geminiPrompt .= " - Add some styles to the HTML but make sure the class for the html is proceeded with random numbers (e.g., class='container-9785') to not interfere with existing css\n";
                    $geminiPrompt .= " - Have each part of the output be segmented as in each section is its own container with borders (IMPORTANT)\n";
                    $geminiPrompt .= " - The summary will go like this:\n";
                    $geminiPrompt .= " Title (AI Summary and Analysis)\n";
                    $geminiPrompt .= " Summary (summarise the whole email),\n";
                    $geminiPrompt .= " Analysis (analyse the whole email),\n";
                    $geminiPrompt .= " Key Details (display any important details of the email, in table format),\n";
                    $geminiPrompt .= " Conclusion (advice a course of action regarding the email for Turtle Down Under as a company entity, be concise and to the point)\n";
                    $geminiPrompt .= " - There's no need to specify HTML at the start just start with the title\n\n";
                    $geminiPrompt .= " <h2>Draft Reply</h2> (Make an example reply from the perspective of TDU, keep it concise and professional, aim for a short paragraph. Start the reply with 'Dear [Sender Name],', there is no need for a signature)";

                    $draftReplyText = "\n\nRegards,\nTurtle Down Under"; // Default fallback

                    echo "<div id='summaryContainer'></div>"; // Content loaded via JS
                ?>
                <button id="CloseSidebarButton" style="display: none;" onclick="toggleSidebar()">Close Summary</button>
                <button id="ReplyButton" style="display: none;" onclick="openReplyForm('summary')">Reply</button>

                <!-- Reply Form (Keep as before) -->
                 <div id="replyForm-summary" class="reply-form" style="display: none; margin: 20px 0; border: 1px solid #ccc; padding: 20px; background-color: #f9f9f9;">
                    <h2>Reply Message</h2>
                    <form action="email_sender.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="messageid" value="<?= htmlspecialchars($message_id ?? '') ?>">
                        <input type="hidden" name="conversation_id" value="<?= htmlspecialchars($conversation_id ?? '') ?>">
                        <div style="margin-bottom: 10px;"><label for="from-summary">From:</label> <input type="text" name="from" id="from-summary" value="<?= htmlspecialchars($mailbox ?? '') ?>" readonly style="width: 100%;"></div>
                        <div style="margin-bottom: 10px;"><label for="rto-summary">To:</label> <div style="display: flex; gap: 5px;"><input type="text" name="to" id="rto-summary" value="<?= htmlspecialchars($sender ?? '') ?>" required style="flex: 1;"><button type="button" onclick="openAddEmailModal('rto-summary')">+</button></div></div>
                        <div style="margin-bottom: 10px;"><label for="rcc-summary">CC:</label> <div style="display: flex; gap: 5px;"><input type="text" name="cc" id="rcc-summary" value="<?= htmlspecialchars($cc ?? '') ?>" style="flex: 1;"><button type="button" onclick="openAddEmailModal('rcc-summary')">+</button></div></div>
                        <div style="margin-bottom: 10px;"><label for="subject-summary">Subject:</label> <input type="text" name="subject" id="subject-summary" value="Re: <?= htmlspecialchars($subject ?? '') ?>" required style="width: 100%;"></div>
                        <div style="margin-bottom: 10px;"><label for="rcontent-summary">Content:</label> <textarea name="content" id="rcontent-summary" rows="10" style="width: 100%;"><?= htmlspecialchars($draftReplyText) ?></textarea></div>
                        <div id="attachments-containerR-summary" style="margin-bottom: 10px;">
                            <label>Attachments: 
                                <?php if($quoteid && in_array($main_mailbox, ['sales@turtledownunder.com.au', 'groupsales@turtledownunder.com.au', 'asia@turtledownunder.com.au'])) : ?>
                                    <button type="button" onclick="handleFetchQuote('attachments-containerR-summary')">Attach Quote</button>
                                <?php endif; ?>
                            </label><br><br>
                            <div class="attachment-row">
                                <input type="file" name="attachments[]" id="attachments-summary-0" onchange="handleAttachmentChangeR('summary', this)">
                            </div>
                        </div>
                        <div><button type="submit">Send</button> <button type="button" onclick="closeReplyForm('summary')">Cancel</button></div>
                    </form>
                </div>
            </div>

            <script>
                function handleFetchQuote(attachment_block_id) {
                    const quoteid = '<?= $quoteid ?>';
                    document.getElementById('loadingSpinner').style.display = 'block';

                    fetch('ajax_fetch_quote_file.php?quoteid=' + encodeURIComponent(quoteid))
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === 'success') {
                                autoAddAttachment(data.fileName, data.fileUrl, attachment_block_id);
                                document.getElementById('loadingSpinner').style.display = 'none';
                            } else {
                                console.error('Failed to fetch quote:', data.message);
                                document.getElementById('loadingSpinner').style.display = 'none';
                            }
                        })
                        .catch(err => {
                            console.error('Error fetching quote:', err);
                            document.getElementById('loadingSpinner').style.display = 'none';
                        });
                }

                function autoAddAttachment(fileName, fileUrl, attachment_block_id) {
                    const container = document.getElementById(attachment_block_id);

                    const attachmentRow = document.createElement('div');
                    attachmentRow.className = 'attachment-row';
                    attachmentRow.style.marginBottom = '10px';

                    // Hidden input so the file gets sent with the form (for backend processing)
                    const hiddenInput = document.createElement('input');
                    hiddenInput.type = 'hidden';
                    hiddenInput.name = 'existing_attachments[]';
                    hiddenInput.value = fileUrl;

                    // Make file name a clickable download link
                    const fileLink = document.createElement('a');
                    fileLink.href = fileUrl;          // URL to the file
                    fileLink.target = '_blank';       // Open in new tab
                    fileLink.textContent = fileName;
                    fileLink.style.marginLeft = '10px';
                    fileLink.style.fontSize = '0.9em';
                    fileLink.style.textDecoration = 'underline';
                    fileLink.style.color = 'blue';

                    // Remove button
                    const removeButton = document.createElement('button');
                    removeButton.type = 'button';
                    removeButton.style.marginLeft = '10px';
                    removeButton.style.border = 'none';
                    removeButton.style.background = 'none';
                    removeButton.style.color = 'red';
                    removeButton.style.cursor = 'pointer';
                    removeButton.style.fontSize = '1.2em';
                    removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                    removeButton.onclick = function () {
                        attachmentRow.remove();
                    };

                    // Add elements to row
                    attachmentRow.appendChild(hiddenInput);
                    attachmentRow.appendChild(fileLink);
                    attachmentRow.appendChild(removeButton);

                    // Add to container
                    container.appendChild(attachmentRow);
                }
            </script>
            <?php /* --- END SIDEBAR HTML STRUCTURES --- */ ?>


            <?php /* --- FULL SCRIPT BLOCK --- */ ?>
            <script>
                // --- Element References ---
                const quotegensidebar = document.getElementById('quoteGenSidebar');
                const sidebar = document.getElementById('summarySidebar');
                const toggleSummaryButton = document.getElementById('sidebar-toggle');
                const togglequotegenButton = document.getElementById('quotegensidebar-toggle');
                const summaryContainer = document.getElementById('summaryContainer');
                const CloseSidebarButton = document.getElementById('CloseSidebarButton');
                const ReplyButton = document.getElementById('ReplyButton');
                const quoteGenContent = document.getElementById('quoteGenContent');
                const reportAiQuoteBtn = document.getElementById("reportAiQuoteBtn");
                const regenerateAiQuoteBtn = document.getElementById('regenerateAiQuoteBtn');
                const saveQuoteBtn = document.getElementById('saveQuoteBtn');
                const forwardedEmailContainer = document.getElementById('forwardedEmailContainer');
                const forwardedEmailInput = document.getElementById('forwardedEmailInput');
                // Report Modal Elements
                const reportModal = document.getElementById('reportModal');
                const reportReasonDiv = document.getElementById('reportReasonDiv');
                const submitReportBtn = document.getElementById('submitReportBtn');
                const cancelReportBtn = document.getElementById('cancelReportBtn'); // Already handled by closeReportModal

                // --- Variables ---
                const conversationId = '<?= htmlspecialchars($conversation_id ?? '') ?>';
                var geminiPrompt = `<?php echo isset($geminiPrompt) ? addslashes($geminiPrompt) : ''; ?>`;
                const originalSenderEmail = '<?= htmlspecialchars($sender ?? '') ?>';
                const folder = '<?= htmlspecialchars($folder_first ?? '') ?>';
                const mailbox = '<?= htmlspecialchars($main_mailbox ?? '') ?>';
                console.log(folder);

                // --- State Variables ---
                let existingQuoteData = <?php echo json_encode($js_existing_quote_data); ?>;
                let currentDisplayedData = null;

                // --- Helper: Check if sender is internal ---
                function isInternalSender(email) { /* ... Keep as before ... */
                    if (!email) return false;
                    return email.toLowerCase().endsWith('@turtledownunder.com.au');
                }

                // --- Helper: Update Save Button State ---
                function updateSaveButtonState() { 
                    if (!saveQuoteBtn) return;
                    const internalSender = isInternalSender(originalSenderEmail);
                    const requiresForwardedEmail = internalSender;
                    let canSave = currentDisplayedData !== null;
                    if (requiresForwardedEmail && folder=='Inbox') {
                        canSave = canSave && (forwardedEmailInput && forwardedEmailInput.value.trim() !== '');
                    }
                    saveQuoteBtn.disabled = !canSave;
                    if (!saveQuoteBtn.disabled && saveQuoteBtn.textContent === 'Saving...') {
                         saveQuoteBtn.textContent = 'Save Quote';
                    }
                }

                // --- Function: Fetch and Display AI Summary (Summary Sidebar) ---
                function getGeminiAISummary(prompt) { /* ... Keep as before ... */
                    if (!prompt) { console.warn("Gemini summary prompt empty."); if (summaryContainer) summaryContainer.innerHTML = "No prompt data."; return; }
                    if (summaryContainer) summaryContainer.innerHTML = "<i><i class='fas fa-spinner fa-spin'></i> Loading AI summary...</i>";
                    fetch('ajax_ai_summary.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'prompt=' + encodeURIComponent(prompt) })
                    .then(response => { if (!response.ok) throw new Error(`HTTP error! ${response.status}`); return response.text(); })
                    .then(data => {
                        if (summaryContainer) summaryContainer.innerHTML = "";
                        if (CloseSidebarButton) CloseSidebarButton.style.display = "inline-block";
                        if (ReplyButton) ReplyButton.style.display = "inline-block";
                        const tempDiv = document.createElement('div'); tempDiv.innerHTML = data;
                        const summaryContent = tempDiv;
                        if (summaryContent && summaryContent.innerHTML.trim()) { if (summaryContainer) summaryContainer.appendChild(summaryContent.cloneNode(true)); }
                        else { if (summaryContainer) summaryContainer.innerHTML = "Could not parse summary."; }
                        let draftReplyHTML = ""; const headings = tempDiv.querySelectorAll('h2'); let start = false; let current = null;
                        for (const h of headings) { if (h.textContent.includes("Draft Reply")) { current = h.nextElementSibling; start = true; break; } }
                        if (start && current) { while (current) { if (current.tagName === 'H2') break; draftReplyHTML += current.outerHTML; current = current.nextElementSibling; } }
                        else { draftReplyHTML = "\n\nRegards,\nTurtle Down Under"; }
                        if (typeof window.ckEditorInstances !== 'undefined' && window.ckEditorInstances['rcontent-summary']) { window.ckEditorInstances['rcontent-summary'].setData(draftReplyHTML || ''); }
                    })
                    .catch(error => { console.error('Error fetching AI summary:', error); if (summaryContainer) summaryContainer.innerHTML = `<span style="color: red;">Error: ${error.message}</span>`; });
                }

                // --- Modal Functions (Itinerary) ---
                function openItineraryModal(itemsArray) { /* ... Keep as before ... */
                    const modal = document.getElementById('itineraryModal'); const contentDiv = document.getElementById('itineraryModalContent'); if (!modal || !contentDiv) return;
                    contentDiv.innerHTML = ''; const noteP = document.createElement('p'); noteP.style.cssText = 'font-size: 0.85em; font-style: italic; color: #555; margin-bottom: 15px;'; noteP.innerHTML = 'Note: Products/vendors in suggested template.'; contentDiv.appendChild(noteP);
                    if (Array.isArray(itemsArray) && itemsArray.length > 0) {
                        const table = document.createElement('table'); const thead = table.createTHead(); const hr = thead.insertRow(); ['Product Name', 'Vendor Name'].forEach(t => { const th = document.createElement('th'); th.textContent = t; hr.appendChild(th); });
                        const tbody = table.createTBody(); itemsArray.forEach(item => { const row = tbody.insertRow(); row.insertCell().textContent = item.productName || 'N/A'; row.insertCell().textContent = item.vendorName || 'N/A'; }); contentDiv.appendChild(table);
                    } else { contentDiv.appendChild(document.createTextNode('No itinerary items found or data invalid.')); }
                    modal.style.display = 'block';
                 }
                function closeItineraryModal() { /* ... Keep as before ... */
                    const modal = document.getElementById('itineraryModal'); if (modal) modal.style.display = 'none';
                 }

                // --- ****** NEW: Report Modal Functions ****** ---
                function openReportModal() {
                    // *** MODIFIED: Check for reportReasonDiv ***
                    if (!reportModal || !reportReasonDiv) {
                        console.error("Report modal elements not found!"); return;
                    }
                    // *** MODIFIED: Clear div content ***
                    reportReasonDiv.textContent = ''; // Clear previous reason
                    reportModal.style.display = 'block';
                    reportReasonDiv.focus(); // Focus div
                }

                function closeReportModal() {
                    if (reportModal) {
                        reportModal.style.display = 'none';
                    }
                     // Ensure submit button is re-enabled if modal closed prematurely
                     if(submitReportBtn) {
                        submitReportBtn.disabled = false;
                        submitReportBtn.textContent = 'Submit Report';
                     }
                }

                function submitReportFromModal() {
                    // *** Get reference to the contenteditable DIV ***
                    const reportReasonDiv = document.getElementById('reportReasonDiv');

                    // Ensure the div and submit button exist
                    if (!reportReasonDiv || !submitReportBtn) {
                         console.error("Cannot submit report: Missing modal elements (div or button).");
                         return;
                    }

                    // *** Get the text content from the DIV and trim whitespace ***
                    const reason = reportReasonDiv.textContent.trim();

                    // Validate if the reason is empty
                    if (!reason) {
                        alert("Please provide a reason for reporting.");
                        reportReasonDiv.focus(); // Focus the div for user input
                        return; // Stop the submission
                    }

                    // --- Determine ai_ref (ID of the saved quote, if it exists) ---
                    // This part remains the same - it depends on existingQuoteData
                    const ai_ref_id = (existingQuoteData && existingQuoteData.id) ? existingQuoteData.id : null;

                    console.log(`Submitting report for Conv ID: ${conversationId}, AI Ref: ${ai_ref_id}`);

                    // --- Prepare data for the backend ---
                    // This part remains the same
                    const postData = new URLSearchParams();
                    postData.append('conversation_id', conversationId);
                    postData.append('reason', reason); // Use the trimmed textContent from the div
                    if (ai_ref_id !== null) { // Only send ai_ref if it has a value
                         postData.append('ai_ref', ai_ref_id);
                    }
                    postData.append('type', 'MANUAL'); // Set type for manual reports
                    postData.append('status', 'PENDING'); // Set initial status

                    // --- Disable button during submission ---
                    // This part remains the same
                    submitReportBtn.disabled = true;
                    submitReportBtn.textContent = 'Submitting...';

                    // --- Send data via AJAX to the reporting endpoint ---
                    // This fetch call and its handling remain the same
                    fetch('ajax_create_ai_error_log.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: postData
                    })
                    .then(response => {
                         const clone = response.clone();
                         if (!response.ok) {
                            // Try to get error message from response for better debugging
                            return response.text().then(text => {
                                throw new Error(`Server error (${response.status}): ${text || 'No details provided'}`);
                            });
                         }
                         // Try to parse JSON, provide fallback error if invalid
                         return response.json().catch(() => clone.text().then(text => {
                             throw new Error(`Invalid JSON received from server: ${text.substring(0,100)}...`);
                         }));
                    })
                    .then(result => {
                        if (result.success) {
                            alert("Report submitted successfully. Thank you!");
                        } else {
                            alert(`Failed to submit report: ${result.error || 'Unknown server error.'}`);
                            console.error("Report submission failed (Server Response):", result);
                        }
                    })
                    .catch(error => {
                        // Catches fetch network errors, JSON parsing errors, or errors thrown from !response.ok
                        console.error('Error submitting report via fetch:', error);
                        alert(`An error occurred while submitting the report: ${error.message}`);
                    })
                    .finally(() => {
                        // Always close modal. Button state is handled by closeReportModal.
                        closeReportModal();
                    });
                }
                // --- ****** END: Report Modal Functions ****** ---


                // --- Helper: Format JSON Keys for Display ---
                function formatJsonKey(key) { /* ... Keep as before ... */
                    if (!key) return ''; if (key.startsWith('category')) return 'Category';
                    return key.replace(/_/g, ' ').replace(/-/g, ' ').replace(/\b\w/g, char => char.toUpperCase());
                 }

                function handleReport() {
                    // This function now only opens the modal.
                    // The actual data gathering and submission happens in submitReportFromModal.
                    openReportModal();
                }


                // --- Function: Render Quote Gen Sidebar Content ---
                function renderQuoteGenContent(data) { /* ... Keep as before, including button visibility/state logic ... */
                    console.log("Rendering Quote Gen:", JSON.stringify(data, null, 2));
                    if (!quoteGenContent) return; quoteGenContent.innerHTML = '';
                    if (!data || typeof data !== 'object') { displayGenerateQuoteUI("Invalid data."); return; }
                    let html = ''; /* Category Filter */ html += `<div class="category-filter-container"><label for="template-category-filter-sidebar">Category:</label><select id="template-category-filter-sidebar">`; const currentCat = data.selected_category || ''; 
                    let categoryOptions=[]; if(mailbox.toLowerCase()==='groupsales@turtledownunder.com.au'){categoryOptions = ['Group'];} else if(mailbox.toLowerCase()==='sales@turtledownunder.com.au'){categoryOptions = ['SIC', 'Private', 'SIC+Private'];} else if(mailbox.toLowerCase()==='asia@turtledownunder.com.au'){categoryOptions = ['SIC', 'Private', 'SIC+Private', 'Group'];} else {categoryOptions = ['SIC', 'Private', 'SIC+Private', 'Group'];}
                    categoryOptions.forEach(cat => { html += `<option value="${cat}" ${currentCat === cat ? 'selected' : ''}>${cat}</option>`; }); 
                    //['SIC', 'Private', 'SIC+Private', 'Group'].forEach(cat => { html += `<option value="${cat}" ${currentCat === cat ? 'selected' : ''}>${cat}</option>`; }); 
                    html += `</select></div>`;
                    /* Segments */ if (data.segments && Array.isArray(data.segments) && data.segments.length > 0) { html += '<h4 style="margin-bottom: 10px;">Suggested Templates:</h4><div class="segments-container">'; data.segments.forEach(segment => { const t = segment.matched_template || null; const items = (t && Array.isArray(t.template_items)) ? t.template_items : []; html += `<div class="segment-card-compact"><div class="card-header"><h5>Segment ${segment.segment_number || '?'}</h5><span class="criteria-summary">${segment.input_duration || 'N/A'}N / ${segment.input_city || 'N/A'} (${segment.input_country || 'N/A'})</span></div><div class="card-content">`; if (t && t.templateid) { html += `<div class="template-summary-line"><strong>ID:</strong> ${t.templateid}</div><div class="template-summary-line"><strong>Name:</strong> ${t.templatename || 'N/A'}</div><div class="template-summary-line"><strong>Details:</strong> ${t.nights || 'N/A'}N / ${t.category || 'N/A'} / ${t.seaters || 'N/A'} Seats</div><div class="template-summary-line"><strong>Loc:</strong> ${t.city || 'N/A'} (${t.country || 'N/A'})</div>`; if (t.relevance !== undefined) html += `<div class="template-summary-line"><strong>Rel:</strong> ${t.relevance}</div>`; } else { html += `<div class="no-template-msg"><i>No suitable template found.</i></div>`; } html += `</div><div class="card-buttons">`; if (t && items.length > 0) { const json = JSON.stringify(items).replace(/'/g, "\\'"); html += `<button type="button" class="card-button view-items-btn" onclick='openItineraryModal(${json})'>View Items</button>`; } html += `</div></div>`; }); html += '</div>'; } else { html += `<p>${data.message || 'No segments found.'}</p>`; }
                    /* AI Details */ html += `<div class="ai-response-details-compact"><details open><summary>View AI Extraction Details</summary>`; const raw = data.raw_ai_response || '{}'; let parsed = null; let parseErr = false; try { parsed = JSON.parse(raw); } catch (e) { console.error("Parse error:", e, raw); parseErr = true; const safe = raw.replace(/</g, "<").replace(/>/g, ">"); html += `<div class="ai-parse-error-block"><h5>AI Extraction (Raw - Parse Error)</h5><pre>${safe}</pre></div>`; } if (parsed) { html += `<div class="ai-key-details-grid">`; let items = 0; const order = ['duration', 'pax', 'dates', 'cities', 'country', 'category', 'budget']; order.forEach(k => { if (Object.hasOwnProperty.call(parsed, k)) { const v = parsed[k]; if (v !== null && v !== undefined && v !== '') { const fk = formatJsonKey(k); html += `<dt>${fk}:</dt><dd>`; if (['cities', 'country'].includes(k) && typeof v === 'string' && v.includes(',')) { html += `<ul>${v.split(',').map(i => `<li>${i.trim()}</li>`).join('')}</ul>`; } else { html += `${v}`; } html += `</dd>`; items++; } delete parsed[k]; } }); for (const k in parsed) { if (Object.hasOwnProperty.call(parsed, k) && !['reasoning', 'itinerary_items'].includes(k)) { const v = parsed[k]; if (v !== null && v !== undefined && v !== '') { const fk = formatJsonKey(k); html += `<dt>${fk}:</dt><dd>${v ?? 'N/A'}</dd>`; items++; } } } if (items === 0) html += `<dt style="text-align: left;" colspan="2"><i>No details extracted.</i></dt>`; html += `</div>`; if (parsed.reasoning) { const rt = String(parsed.reasoning).replace(/\\n/g, '\n'); html += `<details style="margin-bottom: 10px;"><summary style="font-size: 1em; font-weight: bold;">AI Reasoning</summary><div class="ai-reasoning-block">${rt}</div></details>`; } if (parsed.itinerary_items) { html += `<details style="margin-bottom: 15px;"><summary style="font-size: 1em; font-weight: bold;">Extracted Items</summary><div class="ai-itinerary-block">${parsed.itinerary_items}</div></details>`; } } else if (!parseErr) { html += `<p style="color: #6c757d;"><i>No detailed AI data found.</i></p>`; } html += `</details></div>`;
                    quoteGenContent.innerHTML = html;
                    /* Footer Controls */ const internalSender = isInternalSender(originalSenderEmail);
                    if (reportAiQuoteBtn) { reportAiQuoteBtn.style.display = 'inline-block'; reportAiQuoteBtn.onclick = handleReport; reportAiQuoteBtn.disabled = false; reportAiQuoteBtn.textContent = 'Report'; }
                    if (regenerateAiQuoteBtn) { regenerateAiQuoteBtn.style.display = 'inline-block'; regenerateAiQuoteBtn.onclick = handleGenerateOrRegenerate; regenerateAiQuoteBtn.disabled = false; regenerateAiQuoteBtn.textContent = 'Regenerate'; }
                    if (saveQuoteBtn) { saveQuoteBtn.style.display = 'inline-block'; saveQuoteBtn.onclick = handleSaveQuote; saveQuoteBtn.textContent = 'Save Quote'; if (internalSender && folder=='Inbox') { if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'block'; if (forwardedEmailInput) { forwardedEmailInput.value = ''; forwardedEmailInput.removeEventListener('input', updateSaveButtonState); forwardedEmailInput.addEventListener('input', updateSaveButtonState); } saveQuoteBtn.disabled = true; } else { if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none'; saveQuoteBtn.disabled = false; } } else { if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none'; }
                    updateSaveButtonState();
                 }

                // --- Function: Display Initial "Generate Quote" UI ---
                function displayGenerateQuoteUI(messagePrefix = "") { /* ... Keep as before ... */
                     if (!quoteGenContent) return; let html = `<p>${messagePrefix}No AI analysis saved yet.</p>`; html += `<div style="margin: 15px 0;"><label for="template-category-filter-sidebar" style="margin-right: 5px;">Category:</label><select id="template-category-filter-sidebar" style="width:120px; height: 30px; vertical-align: middle; padding: 5px;">`; 
                     let categoryOptions=[]; if(mailbox.toLowerCase()==='groupsales@turtledownunder.com.au'){categoryOptions = ['Group'];} else if(mailbox.toLowerCase()==='sales@turtledownunder.com.au'){categoryOptions = ['SIC', 'Private', 'SIC+Private'];} else if(mailbox.toLowerCase()==='asia@turtledownunder.com.au'){categoryOptions = ['SIC', 'Private', 'SIC+Private', 'Group'];} else {categoryOptions = ['SIC', 'Private', 'SIC+Private', 'Group'];}
                     categoryOptions.forEach(cat => { html += `<option value="${cat}">${cat}</option>`; }); 
                     //['SIC', 'Private', 'SIC+Private', 'Group'].forEach(cat => { html += `<option value="${cat}">${cat}</option>`; }); 
                     html += `</select></div>`; html += `<button id="generateAiQuoteBtnInline">Generate AI Quote</button>`; quoteGenContent.innerHTML = html; const btn = document.getElementById('generateAiQuoteBtnInline'); if (btn) { btn.addEventListener('click', handleGenerateOrRegenerate); btn.disabled = false; }
                     if (reportAiQuoteBtn) reportAiQuoteBtn.style.display = 'none'; if (regenerateAiQuoteBtn) regenerateAiQuoteBtn.style.display = 'none'; if (saveQuoteBtn) saveQuoteBtn.style.display = 'none'; if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none';
                 }

                // --- Function: Save Current AI Data to Server ---
                function saveAiDataToServer(dataToSave, senderEmailToSave) { /* ... Keep as before ... */
                    console.log("Saving AI data... Sender:", senderEmailToSave); return new Promise((resolve, reject) => {
                    if (!dataToSave || !dataToSave.segments || !dataToSave.raw_ai_response) { reject(new Error("No valid data to save.")); return; }
                    const segments = dataToSave.segments; const refs = segments.map(s => (s.matched_template?.templateid) || 'N/A'); const refStr = refs.join(','); const country = (segments.length > 0 && segments[0].input_country) ? segments[0].input_country : 'N/A';
                    const postData = new URLSearchParams(); postData.append('templateref', refStr); postData.append('country', country); postData.append('ai_response', JSON.stringify(dataToSave)); postData.append('conversation_id', conversationId); postData.append('sender', senderEmailToSave);
                    fetch('ajax_create_temp_quote.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: postData })
                    .then(response => { const c = response.clone(); if (!response.ok) { return response.text().then(t => { throw new Error(`HTTP ${response.status}: ${t || 'Err'}`); }); } return response.json().catch(() => c.text().then(t => { throw new Error(`Invalid JSON: ${t.substring(0,100)}...`); })); })
                    .then(res => { if (res.success && res.temp_quote_id) { resolve(res); } else { throw new Error(res.error || 'Unknown save error.'); } })
                    .catch(err => { console.error('Error saving quote:', err); reject(err); }); });
                 }

                // --- Function: Fetch AI Extraction Data from Server ---
                function fetchAiExtractionData(selectedCategory) { /* ... Keep as before ... */
                     console.log(`Fetching AI data for category: ${selectedCategory}...`); return new Promise((resolve, reject) => {
                     if (!conversationId) { reject(new Error("Conversation ID missing.")); return; }
                     if (quoteGenContent) quoteGenContent.innerHTML = '<p><i><i class="fas fa-spinner fa-spin"></i> Generating AI Analysis...</i></p>'; if (reportAiQuoteBtn) reportAiQuoteBtn.disabled = true; if (regenerateAiQuoteBtn) regenerateAiQuoteBtn.disabled = true; if (saveQuoteBtn) saveQuoteBtn.disabled = true; if (forwardedEmailInput) forwardedEmailInput.disabled = true; if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none'; const btn = document.getElementById('generateAiQuoteBtnInline'); if (btn) btn.disabled = true;
                     fetch('ajax_ai_extract.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'conversationID=' + encodeURIComponent(conversationId) + '&category=' + encodeURIComponent(selectedCategory) })
                     .then(response => { const c = response.clone(); if (!response.ok) { return response.text().then(t => { throw new Error(`HTTP ${response.status}: ${t || 'Err'}`); }); } return response.json().catch(() => c.text().then(t => { throw new Error(`Invalid JSON: ${t.substring(0,100)}...`); })); })
                     .then(res => { console.log("AI Extract Resp:", res); if (res.success) { res.selected_category = selectedCategory; resolve(res); } else { throw new Error(res.error || 'Unknown extraction error.'); } })
                     .catch(err => { console.error('Error fetching AI data:', err); if (quoteGenContent) quoteGenContent.innerHTML = `<p style="color:red;">Failed: ${err.message}</p>`; reject(err); })
                     .finally(() => { if (forwardedEmailInput) forwardedEmailInput.disabled = false; }); });
                 }

                // --- Handler: Generate/Regenerate Button Click ---
                function handleGenerateOrRegenerate() { /* ... Keep as before ... */
                    const sel = document.getElementById('template-category-filter-sidebar'); const cat = sel ? sel.value : ''; const btn = this;
                    if (btn) btn.disabled = true; if (btn && btn.id === 'regenerateAiQuoteBtn') btn.textContent = 'Regenerating...'; if (reportAiQuoteBtn) reportAiQuoteBtn.disabled = true; if (saveQuoteBtn) saveQuoteBtn.disabled = true; if (forwardedEmailInput) forwardedEmailInput.disabled = true;
                    fetchAiExtractionData(cat)
                    .then(data => { currentDisplayedData = data; renderQuoteGenContent(currentDisplayedData); })
                    .catch(error => { alert(`Generation failed: ${error.message}`); if (currentDisplayedData) { renderQuoteGenContent(currentDisplayedData); } else { displayGenerateQuoteUI("Generation Failed. "); } if (btn && btn.id === 'generateAiQuoteBtnInline') { btn.disabled = false; } });
                 }

                // --- Handler: Save Button Click ---
                function handleSaveQuote() { /* ... Keep as before ... */
                    if (!currentDisplayedData) { alert("No AI data to save."); return; }
                    const internal = isInternalSender(originalSenderEmail); let emailToSave = originalSenderEmail;
                    if (internal && folder=='Inbox') { if (!forwardedEmailInput || forwardedEmailInput.value.trim() === '') { alert('Client email required for internal sender.'); forwardedEmailInput?.focus(); return; } if (!/^\S+@\S+\.\S+$/.test(forwardedEmailInput.value.trim())) { alert('Invalid client email format.'); forwardedEmailInput.focus(); return; } emailToSave = forwardedEmailInput.value.trim(); }
                    if (saveQuoteBtn) { saveQuoteBtn.disabled = true; saveQuoteBtn.textContent = 'Saving...'; } if (reportAiQuoteBtn) reportAiQuoteBtn.disabled = true; if (regenerateAiQuoteBtn) regenerateAiQuoteBtn.disabled = true; if (forwardedEmailInput) forwardedEmailInput.disabled = true;
                    saveAiDataToServer(currentDisplayedData, emailToSave)
                    .then(res => { alert(`Quote saved! ID: ${res.temp_quote_id}`); existingQuoteData = { ...existingQuoteData, id: res.temp_quote_id, ai_response: JSON.stringify(currentDisplayedData), conversation_id: conversationId, sender: emailToSave }; })
                    .catch(err => { alert(`Save failed: ${err.message}`); if (saveQuoteBtn) saveQuoteBtn.textContent = 'Save Quote'; }) // Reset text on failure
                    .finally(() => { if (reportAiQuoteBtn) reportAiQuoteBtn.disabled = false; if (regenerateAiQuoteBtn) regenerateAiQuoteBtn.disabled = false; if (forwardedEmailInput) forwardedEmailInput.disabled = false; updateSaveButtonState(); });
                 }

                // --- Sidebar Toggle Functions ---
                function toggleSidebar() { /* ... Keep as before ... */
                    if (!sidebar || !quotegensidebar || !summaryContainer) return; const isOpen = sidebar.classList.toggle('open'); if (isOpen && quotegensidebar.classList.contains('open')) { quotegensidebar.classList.remove('open'); if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none'; } if (isOpen && summaryContainer.innerHTML.trim() === "" && geminiPrompt) { getGeminiAISummary(geminiPrompt); }
                 }
                function togglequoteGenSidebar() { /* ... Keep as before ... */
                    if (!quotegensidebar || !sidebar || !quoteGenContent) return; const isOpen = quotegensidebar.classList.toggle('open'); if (isOpen && sidebar.classList.contains('open')) { sidebar.classList.remove('open'); }
                    if (isOpen) { currentDisplayedData = null; if (existingQuoteData && existingQuoteData.ai_response) { try { console.log("Using existing quote data."); currentDisplayedData = JSON.parse(existingQuoteData.ai_response); renderQuoteGenContent(currentDisplayedData); } catch (e) { console.error("Parse existing data error:", e); existingQuoteData = null; currentDisplayedData = null; displayGenerateQuoteUI("Error loading saved data. "); } } else { console.log("No existing quote, showing generate UI."); displayGenerateQuoteUI(); } }
                    else { if (forwardedEmailContainer) forwardedEmailContainer.style.display = 'none'; } // Hide input on close
                 }

                // --- Event Listeners ---
                if (toggleSummaryButton) { toggleSummaryButton.addEventListener('click', toggleSidebar); } else { console.warn("ID 'sidebar-toggle' not found."); }
                if (togglequotegenButton) { togglequotegenButton.addEventListener('click', togglequoteGenSidebar); } else { console.warn("ID 'quotegensidebar-toggle' not found."); }

                document.addEventListener('DOMContentLoaded', () => {
                    // Itinerary Modal Close Listeners
                    const closeModalButton = document.getElementById('closeItineraryModal');
                    if (closeModalButton) closeModalButton.onclick = closeItineraryModal;
                    const itinModal = document.getElementById('itineraryModal');
                    if (itinModal) itinModal.onclick = function(event) { if (event.target === itinModal) closeItineraryModal(); }

                    // ****** NEW: Report Modal Button Listeners ******
                    if (submitReportBtn) {
                        submitReportBtn.addEventListener('click', submitReportFromModal);
                    } else { console.warn("ID 'submitReportBtn' not found."); }
                    // Cancel/Close buttons handled by onclick attributes calling closeReportModal()

                    // Initial save button state check (if sidebar might start open)
                    setTimeout(() => { if (quotegensidebar && quotegensidebar.classList.contains('open') && currentDisplayedData) { updateSaveButtonState(); } }, 100);
                });

                // Listeners for Generate/Regen/Save/Input attached dynamically in render functions

            </script>
		    </div>
			
            <!-- Hidden form for creating a new tag -->
            <div id="create-tag-form" style="display: none;">
                <select id="tag-category" style="width: 100px; height: 30px;">
                    <option value="person">Person</option>
                    <option value="region">Region</option>
                    <option value="type">Type</option>
                    <option value="country">Country</option>
                </select>
                <input type="text" id="new-tag-name" style="width: 200px; height: 30px;" placeholder="Create New tag" />
                <button onclick="createTag('<?= $conversation_id ?>')"><i class="fa-solid fa-check"></i> Create</button>
            </div>

            <!-- Hidden dropdown for adding a new tag -->
            <div id="add-tag-form" style="display: none; margin: 20px 0;">
                <select id="tag-category-add" style="width: 200px; height: 30px;" onchange="fetchTags()">
                    <option value="">Select Category</option>
                    <option value="person">Person</option>
                    <option value="region">Region</option>
                    <option value="type">Type</option>
                    <option value="country">Country</option>
                </select>
                <select id="existing-tag" style="width: 200px; height: 30px;">
                    <option value="">Select Tag</option>
                </select>
                <button onclick="addTag('<?= $conversation_id ?>')"><i class="fa-solid fa-check"></i> Confirm</button>
            </div>

            <?php if (!empty($tags)): ?>
                <div class="tags-list">
                <?php foreach ($tags as $tag): ?>
                    <?php 
                    $tag_c = $tag['category']; 
                    $background_color = '';
                    
                    switch ($tag_c) {
                        case 'person':
                            $background_color = 'blue';
                            break;
                        case 'region':
                            $background_color = 'green';
                            break;
                        case 'type':
                            $background_color = 'purple';
                            break;
                        case 'country':
                            $background_color = 'orange';
                            break;
                    }
                    ?>

                    <div class="tag" style="background-color: <?= $background_color ?>;">
                        <?= htmlspecialchars($tag['name']) ?>
                        <!-- Remove button for unlinking tags -->
                        <span class="remove-tag" onclick="removeTag(<?= $tag['id'] ?>, '<?= $conversation_id ?>')" 
                            <?= ($title != 'admin' && $tag['name'] == $username_ajax && $global_delete_tag == 1) ? 'style="display: inline;"' : '' ?>>
                            <i class="fa-solid fa-xmark"></i>
                        </span>
                    </div>
                <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div><br></div>
            <?php endif; ?>
        </div>
    </div>
    <script>
        document.getElementById('quote-input').addEventListener('blur', function() {

            var input = this.value;
            var list = document.getElementById('quote_no-list').options;
            var valid = false;

            if (!input) {
                return;
            }

            // Check if input matches any option in the datalist
            for (var i = 0; i < list.length; i++) {
                if (input === list[i].value) {
                    valid = true;
                    break;
                }
            }
            
            if (!valid) {
                alert('Invalid Quote number. Please select a valid one from the list.');
                this.value = '';
            }
        });
    </script>
    <?php

    // Check if any records are found
    if ($result && mysqli_num_rows($result) > 0) {
        $first_income_email = true;
        while ($email = mysqli_fetch_assoc($result)) {
            $mailboxFilter = $email['mailbox'];
            ?>
            <div style="width: 75%; margin: auto; padding: 20px; border-bottom: 1px solid #ccc;">
                <?php
                if($email['folder'] == 'Inbox') {
                    ?>
                    <p><strong><i class="fa-solid fa-inbox"></i> Inbox</strong></p>
                    <p><strong>From:</strong> <?= htmlspecialchars($email['sender_name']) ?> (<?= htmlspecialchars($email['sender']) ?>)</p>
                    <p><strong>To:</strong> <?= htmlspecialchars($email['mailbox']) ?></p>
                    <?php
                } else {
                    ?>
                    <p><strong><i class="fa-regular fa-paper-plane"></i> Sent</strong></p>
                    <p><strong>From:</strong> <?= htmlspecialchars($email['sender_name']) ?> (<?= htmlspecialchars($email['sender']) ?>)</p>
                    <p><strong>To:</strong> <?= htmlspecialchars($email['recipient']) ?></p>
                    <?php
                }
                if(isset($email['cc']) && $email['cc'] != '') {
                    ?>
                    <p><strong>CC:</strong> <?= nl2br(str_replace(',', ", ", htmlspecialchars($email['cc']))) ?></p>
                    <?php
                }
                ?>
                <p><strong>Time:</strong> 
                    <?php 
                        $date = new DateTime($email['received_datetime']);
                        echo $date->format('d-M-Y H:i:s'); 
                    ?>
                </p>
                <?php 
                $email_full_body = $email['full_body'];
                $attachments_files = '';

                $msgid = htmlspecialchars($email['msgid']);
                // Query to fetch the attachment details for the current email
                $attachment_sql = "SELECT attachment_id, file_name, content_id FROM tdu_attachments WHERE message_id = '{$email['message_id']}'";
                $attachment_result = mysqli_query($conn, $attachment_sql);

                // Check if there are any attachments
                if ($attachment_result && mysqli_num_rows($attachment_result) > 0) {
                    while ($attachment = mysqli_fetch_assoc($attachment_result)) {
                        $attachmentId = htmlspecialchars($attachment['attachment_id']);
                        $fileName = htmlspecialchars($attachment['file_name']);
                        $downloadLink = "ajax_outlook_attachment_download.php?attachment_id={$attachmentId}&message_id={$msgid}&file_name={$fileName}";
                        
                        if (false && $attachment['content_id'] != '') {
                            $email_full_body = str_replace('cid:' . $attachment['content_id'], $downloadLink, $email_full_body);
                        } else {
                            $attachments_files .= '<p><a href="' . $downloadLink . '" target="_blank">' . $fileName . '</a></p>';
                        }
                    }
                }

                ?>
                <iframe srcdoc="<?= htmlspecialchars($email_full_body) ?>" style="width: 100%; height: 50vh; border: 1px solid #ccc;"></iframe><br>
                <?php
                if ($attachments_files != '') {
                    echo '<strong>Attachments:</strong>';
                    echo $attachments_files;
                }

                if($email['folder'] == 'Inbox') {
                    ?>
                    <?php if (!in_array($main_mailbox, ['sales@turtledownunder.com.au', 'groupsales@turtledownunder.com.au', 'asia@turtledownunder.com.au'])) : ?>
                        <button onclick="openReplyForm('<?= htmlspecialchars($email['message_id']) ?>')">Reply</button>
                    <?php elseif ($first_income_email): 
                        $first_income_email = false;
                        ?>
                        <button onclick="toggleSidebar()" style="background-color: #2c70a2" <?= ($title != 'group' && $title != 'fit') ? '' : 'disabled title="You are not allowed to reply to sales email, please contact admin"' ?>>TAI Reply</button>
                    <?php endif; ?>
                    <?php
                }
                ?>
                <button onclick="openForwardForm('<?= htmlspecialchars($email['message_id']) ?>')">Forward</button>
            
                <!-- Forward Form (Hidden by Default) -->
                <div id="forwardForm-<?= htmlspecialchars($email['message_id']) ?>" class="forward-form" style="display: none; margin: 20px 0; border: 1px solid #ccc; padding: 20px; background-color: #f9f9f9;">
                    <h2>Forward Message</h2>
                    <form action="email_forward.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="messageid" value="<?= htmlspecialchars($email['message_id']) ?>">
                        <div>
                            <label for="from-<?= htmlspecialchars($email['message_id']) ?>">From:</label>
                            <input type="text" name="from" id="from-<?= htmlspecialchars($email['message_id']) ?>" value="<?= htmlspecialchars($email['mailbox']) ?>" readonly style="width: 100%;">
                        </div>
                        <div>
                            <label for="fto-<?= htmlspecialchars($email['message_id']) ?>">To:</label>
                            <div style="display: flex; gap: 5px;">
                                <input type="text" name="to" id="fto-<?= htmlspecialchars($email['message_id']) ?>" required style="flex: 1;">
                                <button type="button" onclick="openAddEmailModal('fto-<?= htmlspecialchars($email['message_id']) ?>')">+</button>
                            </div>
                        </div>
                        <div>
                            <label for="fcc-<?= htmlspecialchars($email['message_id']) ?>">CC:</label>
                            <div style="display: flex; gap: 5px;">
                                <input type="text" name="cc" id="fcc-<?= htmlspecialchars($email['message_id']) ?>" style="flex: 1;">
                                <button type="button" onclick="openAddEmailModal('fcc-<?= htmlspecialchars($email['message_id']) ?>')">+</button>
                            </div>
                        </div>
                        <div>
                            <label for="subject-<?= htmlspecialchars($email['message_id']) ?>">Subject:</label>
                            <input type="text" name="subject" id="subject-<?= htmlspecialchars($email['message_id']) ?>" value="Fwd: <?= htmlspecialchars($email['subject']) ?>" required style="width: 100%;">
                        </div>
                        <div>
                            <label for="content-<?= htmlspecialchars($email['message_id']) ?>">Content:</label>
                            <textarea name="content" id="fcontent-<?= htmlspecialchars($email['message_id']) ?>" rows="10" style="width: 100%;"></textarea>
                        </div>
                        <div id="attachments-container-<?= htmlspecialchars($email['message_id']) ?>">
                            <label>Attachments:</label>
                            <div class="attachment-row" style="margin-bottom: 10px;">
                                <input type="file" name="attachments[]" id="attachments-<?= htmlspecialchars($email['message_id']) ?>-0" onchange="handleAttachmentChange('<?= htmlspecialchars($email['message_id']) ?>', this)">
                            </div>
                        </div>
                        <div>
                            <button type="submit">Send</button>
                            <button type="button" onclick="closeForwardForm('<?= htmlspecialchars($email['message_id']) ?>')">Cancel</button>
                        </div>
                    </form>
                </div>
                
                <!-- Reply Form (Hidden by Default) -->
                <div id="replyForm-<?= htmlspecialchars($email['message_id']) ?>" class="reply-form" style="display: none; margin: 20px 0; border: 1px solid #ccc; padding: 20px; background-color: #f9f9f9;">
                    <h2>Reply Message</h2>
                    <form action="email_sender.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="messageid" value="<?= htmlspecialchars($email['message_id']) ?>">
                        <input type="hidden" name="conversation_id" value="<?= htmlspecialchars($conversation_id) ?>">
                        <div>
                            <label for="from-<?= htmlspecialchars($email['message_id']) ?>">From:</label>
                            <input type="text" name="from" id="from-<?= htmlspecialchars($email['message_id']) ?>" value="<?= htmlspecialchars($email['mailbox']) ?>" readonly style="width: 100%;">
                        </div>
                        <div>
                            <label for="rto-<?= htmlspecialchars($email['message_id']) ?>">To:</label>
                            <div style="display: flex; gap: 5px;">
                                <input type="text" name="to" id="rto-<?= htmlspecialchars($email['message_id']) ?>" value="<?= htmlspecialchars($email['sender']) ?>" required style="flex: 1;">
                                <button type="button" onclick="openAddEmailModal('rto-<?= htmlspecialchars($email['message_id']) ?>')">+</button>
                            </div>
                        </div>
                        <div>
                            <label for="rcc-<?= htmlspecialchars($email['message_id']) ?>">CC:</label>
                            <div style="display: flex; gap: 5px;">
                                <input type="text" name="cc" id="rcc-<?= htmlspecialchars($email['message_id']) ?>" value="<?= htmlspecialchars($email['cc']) ?>" style="flex: 1;">
                                <button type="button" onclick="openAddEmailModal('rcc-<?= htmlspecialchars($email['message_id']) ?>')">+</button>
                            </div>
                        </div>
                        <div>
                            <label for="subject-<?= htmlspecialchars($email['message_id']) ?>">Subject:</label>
                            <input type="text" name="subject" id="subject-<?= htmlspecialchars($email['message_id']) ?>" value="Re: <?= htmlspecialchars($email['subject']) ?>" required style="width: 100%;">
                        </div>
                        <div>
                            <label for="content-<?= htmlspecialchars($email['message_id']) ?>">Content:</label>
                            <textarea name="content" id="rcontent-<?= htmlspecialchars($email['message_id']) ?>" rows="10" style="width: 100%;"></textarea>
                        </div>
                        <div id="attachments-containerR-<?= htmlspecialchars($email['message_id']) ?>">
                            <label>Attachments:</label>
                            <div class="attachment-row" style="margin-bottom: 10px;">
                                <input type="file" name="attachments[]" id="attachments-<?= htmlspecialchars($email['message_id']) ?>-0" onchange="handleAttachmentChangeR('<?= htmlspecialchars($email['message_id']) ?>', this)">
                            </div>
                        </div>
                        <div>
                            <button type="submit">Send</button>
                            <button type="button" onclick="closeReplyForm('<?= htmlspecialchars($email['message_id']) ?>')">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
            <?php
        }
        ?>
        <!-- Modal for adding email -->
        <div id="emailModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; justify-content: center; align-items: center;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 600px; text-align: center;">
                <h4>Search Email</h4>
                <input type="text" id="emailModalInput" placeholder="Enter email address" style="width: 100%; margin-bottom: 15px; height: 30px;" onkeyup="searchEmail(this.value)">
                <ul id="emailSuggestions" style="list-style: none; padding: 0; margin: 0;"></ul>
                <div style="margin-top: 10px; display: flex; gap: 10px; justify-content: center;">
                    <button onclick="confirmAddEmail()" style="padding: 5px 10px;">Add</button>
                    <button onclick="closeEmailModal()" style="padding: 5px 10px;">Cancel</button>
                </div>
            </div>
        </div>

        <script>
            function searchEmail(query) {
                const suggestions = document.getElementById('emailSuggestions');
                suggestions.innerHTML = ''; // Clear previous suggestions

                if (query.trim().length === 0) {
                    return;
                }

                const mailboxFilterId = <?php echo getEmailId($mailboxFilter); ?>;
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_outlook_contacts.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        const results = JSON.parse(xhr.responseText);
                        results.forEach(emailData => {
                            const li = document.createElement('li');
                            li.textContent = `${emailData.sender_name} (${emailData.email})`;
                            li.style.cursor = 'pointer';
                            li.style.padding = '5px 10px';
                            li.style.borderBottom = '1px solid #ddd';
                            li.onclick = function () {
                                document.getElementById('emailModalInput').value = emailData.email;
                                suggestions.innerHTML = ''; // Clear suggestions
                            };
                            suggestions.appendChild(li);
                        });
                    }
                };
                xhr.send(`query=${encodeURIComponent(query)}&mailboxFilterId=${mailboxFilterId}`);
            }
        </script>

        <script>
            let currentFieldId = null;

            function openAddEmailModal(fieldId) {
                currentFieldId = fieldId; // Store the current field ID
                document.getElementById('emailModalInput').value = ''; // Clear the input field
                document.getElementById('emailModal').style.display = 'flex'; // Show the modal
            }

            function closeEmailModal() {
                document.getElementById('emailModal').style.display = 'none'; // Hide the modal
                currentFieldId = null; // Reset the current field ID
            }

            function confirmAddEmail() {
                const emailInput = document.getElementById('emailModalInput').value.trim();
                if (emailInput && currentFieldId) {
                    const field = document.getElementById(currentFieldId);
                    const currentValue = field.value.trim();
                    field.value = currentValue ? `${currentValue}, ${emailInput}` : emailInput;
                }
                closeEmailModal(); // Close the modal after adding
            }
        </script>
        <?php
    } else {
        ?>
        <p>No emails found for the given conversation.</p>
        <?php
    }

    // Fetch conversation history using mysqli_query
    $sql = "SELECT created_at, details, created_by FROM vtiger_support_history WHERE conversation_id='$conversation_id' ORDER BY created_at DESC";
    $result = mysqli_query($conn, $sql);

    // Check if query was successful and there are results
    $history = [];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $history[] = $row;
        }
    } else {
        $history = null;  // No data found
    }
    ?>    

    <!-- Modal history Structure -->
    <div id="historyModal" style="display: none;">
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5);">
            <div style="position: absolute; top: 20%; left: 25%; width: 50%; background: white; padding: 20px;">
                <h2 style="text-align: center;">History</h2>
                <?php if ($history): ?>
                    <div style="max-height: 600px; overflow-y: auto;">
                        <table class="styled-table">
                            <tr>
                                <th>Time</th>
                                <th>Description</th>
                                <th>By</th>
                            </tr>
                            <?php foreach ($history as $entry): ?>
                                <tr>
                                    <td>
                                        <?php 
                                            $date = new DateTime($entry['created_at']);
                                            echo $date->format('d-M-Y H:i:s'); 
                                        ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($entry['details']); ?></td>
                                    <td><?php echo htmlspecialchars($entry['created_by']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    </div>
                <?php else: ?>
                    <p>No history available for this conversation.</p>
                <?php endif; ?>
                <button onclick="closeHistoryModal()">Close</button>
            </div>
        </div>
    </div>

    <!-- JavaScript to handle opening and closing the modal -->
    <script>
        function openHistoryModal() {
            document.getElementById('historyModal').style.display = 'block';
        }

        function closeHistoryModal() {
            document.getElementById('historyModal').style.display = 'none';
        }
    </script>

    <!-- display reply/forward from -->
    <style>
        .ck-editor__editable {
            height: 300px;
            overflow-y: auto;
        }
    </style>
    <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
    <script>
        var editorInstance;
        function openReplyForm(messageId) {
            document.getElementById('replyForm-' + messageId).style.display = 'block';
        }
        function closeReplyForm(messageId) {
            document.getElementById('replyForm-' + messageId).style.display = 'none';
        }
        function openForwardForm(messageId) {
            document.getElementById('forwardForm-' + messageId).style.display = 'block';
        }
        function closeForwardForm(messageId) {
            document.getElementById('forwardForm-' + messageId).style.display = 'none';
        }

        // --- Create a global object to store editor instances ---
        window.ckEditorInstances = window.ckEditorInstances || {}; // Use window for explicit global scope

        // Keep track if the specific AI reply editor has been initialized
        let aiReplyEditorReady = false;
        let pendingAiDraftHtml = null; // To store AI content if it arrives before editor is ready

        document.querySelectorAll('textarea').forEach((textarea) => {
            const editorId = textarea.id; // <<< Get the ID of the textarea

            if (!editorId) {
                console.warn("Textarea found without an ID. Cannot reliably manage its CKEditor instance.", textarea);
                // Optionally skip this textarea or assign a temporary ID if needed
                // return;
            }

            ClassicEditor.create(textarea, {
                toolbar: {
                    items: ['heading', 'bold', 'italic', 'link', 'insertTable', 'undo', 'redo']
                }
            })
            .then(editor => {

                if (editorId) {
                    // --- Store the instance using its ID as the key ---
                    window.ckEditorInstances[editorId] = editor;

                    // Check if this is the AI reply editor AND if AI content arrived early
                    if (editorId === 'rcontent-summary') {
                        aiReplyEditorReady = true;
                        if (pendingAiDraftHtml !== null) {
                            console.log("AI content arrived before editor, setting data now.");
                            editor.setData(pendingAiDraftHtml);
                            pendingAiDraftHtml = null; // Clear pending content
                        }
                    }
                }

                // REMOVE this line - We will set the AI content later
                // editorInstance.setData(draftReplyHTML);

            })
            .catch((error) => {
                console.error(`Error initializing editor for ID: ${editorId}`, error);
            });
        });
    </script>

    <!-- add attachment -->
    <script>
        function handleAttachmentChange(messageId, input) {
            const container = document.getElementById(`attachments-container-${messageId}`);

            // If the input has a file, display the file name
            if (input.files.length > 0) {
                // Hide the input field
                input.style.display = "none";

                // Create a span to display the file name
                const fileName = document.createElement("span");
                fileName.textContent = input.files[0].name;
                fileName.style.marginLeft = "10px";
                fileName.style.fontSize = "0.9em";

                // Add a remove icon
                const removeButton = document.createElement("button");
                removeButton.type = "button";
                removeButton.style.marginLeft = "10px";
                removeButton.style.border = "none";
                removeButton.style.background = "none";
                removeButton.style.color = "red";
                removeButton.style.cursor = "pointer";
                removeButton.style.fontSize = "1.2em";
                removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                removeButton.onclick = function () {
                    // Remove the parent row
                    input.parentElement.remove();
                };

                // Append the file name and remove button to the current row
                input.parentElement.appendChild(fileName);
                input.parentElement.appendChild(removeButton);

                // Add a new file input for future attachments
                const newField = document.createElement("div");
                newField.className = "attachment-row";
                newField.style.marginBottom = "10px";
                newField.innerHTML = `
                    <input type="file" name="attachments[]" onchange="handleAttachmentChange('${messageId}', this)">
                `;

                container.appendChild(newField);
            }
        }
        function handleAttachmentChangeR(messageId, input) {
            const container = document.getElementById(`attachments-containerR-${messageId}`);

            // If the input has a file, display the file name
            if (input.files.length > 0) {
                // Hide the input field
                input.style.display = "none";

                // Create a span to display the file name
                const fileName = document.createElement("span");
                fileName.textContent = input.files[0].name;
                fileName.style.marginLeft = "10px";
                fileName.style.fontSize = "0.9em";

                // Add a remove icon
                const removeButton = document.createElement("button");
                removeButton.type = "button";
                removeButton.style.marginLeft = "10px";
                removeButton.style.border = "none";
                removeButton.style.background = "none";
                removeButton.style.color = "red";
                removeButton.style.cursor = "pointer";
                removeButton.style.fontSize = "1.2em";
                removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                removeButton.onclick = function () {
                    // Remove the parent row
                    input.parentElement.remove();
                };

                // Append the file name and remove button to the current row
                input.parentElement.appendChild(fileName);
                input.parentElement.appendChild(removeButton);

                // Add a new file input for future attachments
                const newField = document.createElement("div");
                newField.className = "attachment-row";
                newField.style.marginBottom = "10px";
                newField.innerHTML = `
                    <input type="file" name="attachments[]" onchange="handleAttachmentChangeR('${messageId}', this)">
                `;

                container.appendChild(newField);
            }
        }
    </script>

    <!-- edit status, quote no, tag -->
    <script>
        function toggleEditMode() {
            const removeButtons = document.querySelectorAll('.remove-tag');
            removeButtons.forEach(button => {
                button.style.display = button.style.display === 'inline' ? 'none' : 'inline';
            });
        }
    
        function toggleAddTagSelect() {
            const select = document.getElementById('add-tag-form');
            select.style.display = select.style.display === 'none' ? 'block' : 'none';
        }
    
        function toggleCreateTagForm() {
            const form = document.getElementById('create-tag-form');
            form.style.display = form.style.display === 'none' ? 'block' : 'none';
        }
    
        function fetchTags() {
            const category = document.getElementById('tag-category-add').value;
            const mainMailbox = "<?php echo addslashes($main_mailbox); ?>";

            if (category) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_tag.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        const tags = JSON.parse(xhr.responseText);
                        const tagDropdown = document.getElementById('existing-tag');
                        tagDropdown.innerHTML = '<option value="">Select a tag</option>';

                        let lastTitle = null;

                        tags.forEach(function(tag) {
                            // Check if the title changed
                            if (tag.title !== lastTitle) {
                                lastTitle = tag.title;
                                if (lastTitle) {
                                    const titleOption = document.createElement('option');
                                    titleOption.textContent = `--- ${lastTitle.toUpperCase()} ---`;
                                    titleOption.disabled = true;
                                    tagDropdown.appendChild(titleOption);
                                }
                            }

                            const option = document.createElement('option');
                            option.value = tag.id;
                            option.textContent = tag.tag_name;
                            tagDropdown.appendChild(option);
                        });
                    }
                };

                xhr.send('action=fetch&category=' + encodeURIComponent(category) + '&main_mailbox=' + encodeURIComponent(mainMailbox));
            }
        }

        function addTag(ticketID) {
            const tagID = document.getElementById('existing-tag').value;
            const username_ajax = "<?php echo $username_ajax; ?>";

            if (tagID) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_tag.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText);
                        location.reload();
                    }
                };
                xhr.send('action=add&tag_id=' + encodeURIComponent(tagID) + '&ticket_id=' + encodeURIComponent(ticketID) + '&username_ajax=' + encodeURIComponent(username_ajax));
            } else {
                alert('Please select a tag to add.');
            }
        }
    
        function removeTag(tagID, ticketID) {
            const username_ajax = "<?php echo $username_ajax; ?>";
            if (confirm('Are you sure you want to unlink this tag from the ticket?')) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_tag.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText);
                        location.reload();
                    }
                };
                xhr.send('action=remove&tag_id=' + encodeURIComponent(tagID) + '&ticket_id=' + encodeURIComponent(ticketID) + '&username_ajax=' + encodeURIComponent(username_ajax));
            }
        }
    
        function createTag(ticketID) {
            const newTagName = document.getElementById('new-tag-name').value.trim();
            const tagCategory = document.getElementById('tag-category').value; // Get selected value

            if (newTagName) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_tag.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText);
                        location.reload();
                    }
                };
                
                // Sending tag name, category, and ticket ID
                xhr.send('action=create&tag_name=' + encodeURIComponent(newTagName) + 
                        '&ticket_id=' + encodeURIComponent(ticketID) + 
                        '&tag_category=' + encodeURIComponent(tagCategory));
            } else {
                alert('Please enter a tag name.');
            }
        }

        function saveStatus(ticketID) {
            const status = document.getElementById('status-select').value.trim();
            const username_ajax = "<?php echo $username_ajax; ?>";
            const quoteNo = "<?php echo $quote_no; ?>";

            if (status === "Closed" && !quoteNo) {
                alert('You cannot close the ticket without quote no');
                location.reload();
                return;
            }

            if (status) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_status.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText); // Feedback to the user
                        location.reload();
                    }
                };
                xhr.send('ticket_id=' + encodeURIComponent(ticketID) +
                        '&status=' + encodeURIComponent(status) + 
                        '&username_ajax=' + encodeURIComponent(username_ajax));
            } else {
                alert('Please select a status other than New.');
            }
        }

        function saveQuote(ticketID) {
            const quoteNo = document.getElementById('quote-input').value.trim();
            const username_ajax = "<?php echo $username_ajax; ?>";

            if (quoteNo) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_quote.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText); // Feedback to the user
                        location.reload();
                    }
                };
                xhr.send('ticket_id=' + encodeURIComponent(ticketID) +
                        '&quote_no=' + encodeURIComponent(quoteNo) +
                        '&username_ajax=' + encodeURIComponent(username_ajax));
            } else {
                alert('Please enter a Quote No.');
            }
        }

        function updateVendorId() {
            const vendorInput = document.getElementById('vendor-input');
            const vendorIdInput = document.getElementById('vendor-id');
            
            // Get the selected vendorName and find the corresponding vendorId from the datalist options
            const options = document.getElementById('vendor-id-list').options;
            
            for (let option of options) {
                if (option.value === vendorInput.value) {
                    vendorIdInput.value = option.getAttribute('data-id');
                    break;
                }
            }
        }

        function saveVendor(ticketID) {
            const vendorId = document.getElementById('vendor-id').value.trim();
            const username_ajax = "<?php echo $username_ajax; ?>";

            if (vendorId) {
                const xhr = new XMLHttpRequest();
                xhr.open('POST', 'ajax_update_vendor_mail.php', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function () {
                    if (xhr.readyState === 4 && xhr.status === 200) {
                        alert(xhr.responseText); // Feedback to the user
                        location.reload();
                    }
                };
                xhr.send('ticket_id=' + encodeURIComponent(ticketID) +
                        '&vendor_id=' + encodeURIComponent(vendorId) +
                        '&username_ajax=' + encodeURIComponent(username_ajax));
            } else {
                alert('Please enter a Vendor Name.');
            }
        }
    </script>

    <style>
        .ticket-container {
            padding-top: 25px;
            text-align: left;
            word-wrap: break-word;
            width: 50%;
            margin: auto;
        }
        .tags-list {
            margin: 20px 0;
        }
        .tag {
            display: inline-block;
            padding: 5px 10px;
            margin: 5px 2px;
            font-size: 14px;
            background-color: green;
            color: white;
            border-radius: 12px;
            position: relative;
        }
        .remove-tag {
            display: none;
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: red;
            color: white;
            border-radius: 50%;
            cursor: pointer;
            font-weight: bold;
            padding: 2px 5px;
        }
        #create-tag-form {
            margin-top: 10px;
        }
        input[type="text"] {
            width: 80%;
            height: 30px;
            margin: 0;
        }
        div button {
            height: 30px;
        }
        #historyModal th, #historyModal td {
            text-align: left;
        }
    </style>

    <script>
        var folderFirst = "<?php echo 'folder_first'; ?>";
        var replied = "<?php echo isset($_GET['replied']) ? $_GET['replied'] : ''; ?>";

        window.addEventListener('beforeunload', function (e) {
            if (folderFirst === 'Inbox' && !replied) {
                const confirmationMessage = "You haven't replied to this email. Are you sure you want to leave?";
                
                e.returnValue = confirmationMessage;
                return confirmationMessage;
            }
        });
    </script>

    <!-- Notes section -->
    <?php if ($quoteid != '') : ?>
        <div id="div-notes" style="position: fixed; top: 0; right: -50%; width: 50%; height: 100vh; background: #fff; box-shadow: -2px 0 5px rgba(0,0,0,0.2); overflow-y: auto; transition: right 0.3s ease-in-out; padding: 20px;">
            <?php
            $sql_notes = "SELECT * FROM vtiger_notes WHERE quoteid='$quoteid' ORDER BY created_at DESC";
            $result_notes = $conn->query($sql_notes);
            ?>
            <h2 style="margin-bottom: 10px;">Notes</h2>
            <button id="close-notes" style="position: absolute; top: 10px; right: 10px; padding: 5px 10px; background: red; color: white; border: none; cursor: pointer;"><i class="fa-solid fa-xmark"></i></button>
            
            <?php if ($result_notes->num_rows > 0): ?>
                <?php while ($row_notes = $result_notes->fetch_assoc()): ?>
                    <div class="note-container" style="margin-bottom: 20px; border: 1px solid #ddd; padding: 10px;">
                        <table class="note-table" style="width: 100%; border-collapse: collapse;">
                            <tr style="background-color: #f9f9f9;">
                                <th colspan="2">Added at <?php echo $row_notes['created_at']; ?> by <?php echo $row_notes['created_by']; ?></th>
                            </tr>
                            <tr>
                                <th>Category</th>
                                <td><?php echo $row_notes['category']; ?></td>
                            </tr>
                            <?php if ($row_notes['category'] == 'Internal') : ?>
                                <tr>
                                    <th>Subcategory</th>
                                    <td><?php echo $row_notes['subcategory'] ?? 'N/A'; ?></td>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Notes</th>
                                <td><?php echo nl2br($row_notes['notes']); ?></td>
                            </tr>
                            <?php if (!empty($row_notes['attachment_path'])): ?>
                                <tr>
                                    <th>Attachment</th>
                                    <td>
                                        <?php 
                                            $filename = basename($row_notes['attachment_path']);
                                        ?>
                                        <i class="fa-solid fa-file-lines"></i> <a href="<?php echo $row_notes['attachment_path']; ?>" target="_blank"><?php echo $filename; ?></a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <p>No notes found</p>
            <?php endif; ?>

            <div class="note-container" style="margin-bottom: 20px; border: 1px solid #ddd; padding: 10px;">
                <h2 style="text-align: left;">Add Notes</h2>

                <form id="add-note-form" enctype="multipart/form-data">
                    <input type="hidden" name="quoteid" value="<?php echo $quoteid; ?>">
                    <label>Category: 
                        <?php if ($title == 'admin') : ?>
                        <button type="button" id="openCategoryModal" style="margin-bottom: 10px;">+</button>
                        <?php endif; ?>
                    </label>
                    <?php
                    $sql_category_option = "SELECT note_category FROM tdu_note_categories";
                    $result_category_option = $conn->query($sql_category_option);
                    ?>

                    <select name="category" id="note-category" style="width: 100%;">
                        <option value="">Select Category</option>
                        <?php while ($row_category_option = $result_category_option->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($row_category_option['note_category']); ?>">
                                <?php echo htmlspecialchars($row_category_option['note_category']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                    <div id="subcategory-row" style="display: none; width: 100%;">
                        <label>Subcategory:</label>
                        <select name="subcategory" id="subcategory">
                            <option value="">Select Subcategory</option>
                            <option value="Sales">Sales</option>
                            <option value="Operation">Operation</option>
                            <option value="QA">QA</option>
                            <option value="Account">Account</option>
                        </select>
                    </div>
                    <label>Notes:</label>
                    <textarea name="notes" style="width: 100%; height: 150px;"></textarea>

                    <label>Attachment:</label><br>
                    <input type="file" name="attachment" accept=".pdf,.doc,.docx,.jpg,.png,.jpeg,.xls,.xlsx"><br><br>

                    <button type="submit">Save</button>
                </form>
            </div>
        </div>
        <!-- Modal for Adding New Note Category -->
        <div id="newCategoryModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
            <div style="background: white; width: 30%; margin: 10% auto; padding: 20px; border-radius: 5px; position: relative;">
                <h3>Add New Category</h3>
                <button id="closeCategoryModal" style="position: absolute; top: 10px; right: 10px; background: red; color: white; border: none; padding: 5px;"><i class="fa-solid fa-xmark"></i></button>
                <form id="add-category-form">
                    <input type="text" name="new_category" required style="width: 100%; padding: 5px;">
                    <button type="submit" style="margin-top: 10px;">Save</button>
                </form>
            </div>
        </div>
        <script>
            document.getElementById('openCategoryModal').addEventListener('click', function () {
                document.getElementById('newCategoryModal').style.display = 'block';
            });

            document.getElementById('closeCategoryModal').addEventListener('click', function () {
                document.getElementById('newCategoryModal').style.display = 'none';
            });

            document.getElementById('add-category-form').addEventListener('submit', function (e) {
                e.preventDefault();
                
                let formData = new FormData(this);
                
                fetch('ajax_add_note_category.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    alert('Category added successfully!');
                    location.reload();
                })
                .catch(error => console.error('Error:', error));
            });
        </script>
        <style>
            .note-table {
                width: 80%;
                margin: 20px auto;
                border-collapse: collapse;
                border: 1px solid #ddd;
            }

            .note-table td, .note-table th {
                padding: 12px;
                border: 1px solid #ddd;
                vertical-align: top;
            }

            .note-table th {
                text-align: left;
                font-weight: bold;
                width: 30%;
            }

            .note-container {
                margin-bottom: 20px;
            }

            .note-container h2 {
                text-align: center;
                color: #333;
            }
        </style>
        <script>
            document.getElementById('toggle-notes').addEventListener('click', function () {
                document.getElementById('div-notes').style.right = '0';
            });

            document.getElementById('close-notes').addEventListener('click', function () {
                document.getElementById('div-notes').style.right = '-50%';
            });

            document.getElementById('note-category').addEventListener('change', function () {
                document.getElementById('subcategory-row').style.display = this.value === 'Internal' ? '' : 'none';
            });

            document.getElementById('add-note-form').addEventListener('submit', function (e) {
                e.preventDefault();
                
                let formData = new FormData(this);
                
                fetch('ajax_add_quote_note.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    alert('Note added successfully!');
                    location.reload();
                })
                .catch(error => console.error('Error:', error));
            });
        </script>
    <?php endif; ?>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
