<?php
// FIT Quotes List
if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && ( $_GET['opt'] == 'sales-search' || ($_GET['opt'] == 'search' && isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit') ) ) {
    if (($title == 'sales' || $title == 'external') && $quote_view == 'group' && ($_GET["quote_type"] == 'fit' || $_GET["quote_type"] == 'fit-dashboard')) {
        header('Location: quote.php?opt=sales-search&quote_type=group');
        exit;
    }
    else if (($title == 'sales' || $title == 'external') && $quote_view == 'fit' && ($_GET["quote_type"] != 'fit' && $_GET["quote_type"] != 'fit-dashboard')) {
        header('Location: quote.php?opt=sales-search&quote_type=fit-dashboard');
        exit;
    }
    include "header.php";
    $quote_type = $_GET["quote_type"] ?? 'group';

    if (count($_GET) === 1) {
        $todayDate = date('Y-m-d');
        $futureDate = date('Y-m-d', strtotime('+5 years'));
        $_GET['date_range'] = "$todayDate to $futureDate";

        if ($title == 'external') {
            $_GET['assigned_to_external_sales_agent'] = $username_ajax;
        }

        if ($title == 'sales' || $title == 'external') {
            $_GET['quote_stage'] = 'Created,Requote,Accepted';
        }

        if ($title == 'external') {
            $_GET['quote_type'] = 'group';
        } else if ($title == 'sales') {
            $_GET['quote_type'] = 'fit-dashboard';
        }
    }
	
	// Get search query from the keyword search textarea
	$searchQuery = isset($_GET['query']) ? trim($_GET['query']) : '';
	//$searchWords = $searchQuery ? array_unique(preg_split('/\s+/', strtolower($searchQuery))) : [];   //search words separated by whitespace
	$searchWords = array_filter(array_map('trim', explode(',', strtolower($searchQuery))));             //search words separated by comma(,)
	$keywordMatches = array();
	
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
        .styled-table td {
            white-space: nowrap;
        }
        .hover-expand {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 10vw;
            z-index: 1;
        }

        .hover-expand:hover {
            overflow: visible;
            max-width: none;
            background: #f9f9f9;
            position: absolute;
            z-index: 100;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            .pagination {
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 20px 0;
            }
            
            .pagination div {
                display: flex;
                align-items: center;
            }
            
            .pagination a {
                text-decoration: none;
                padding: 8px 12px;
                margin: 0 5px;
                border: 1px solid #334155;
                color: #334155;
                border-radius: 4px;
                transition: background-color 0.3s, color 0.3s;
            }
            
            .pagination a:hover {
                background-color: #334155;
                color: white;
            }
            
            .pagination input[type="number"] {
                width: 50px;
                padding: 10px;
                margin-left: 10px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            
            .pagination button {
                padding: 10px 10px;
                margin-left: 5px;
                border: none;
                border-radius: 4px;
                background-color: #334155;
                color: white;
                cursor: pointer;
                transition: background-color 0.3s;
            }
            
            .pagination button:hover {
                background-color: #334155;
            }
            
            tr:nth-child(odd) {
                background-color: #f9f9f9;
            }
        </style>
		<div>
			<label for="keywords" style="margin-left: 20px">Product Keyword(s):</label>
			<input type="text" id="query" style="width: 80%; height: 30px" value="<?= htmlspecialchars($searchQuery) ?>"></input>
		</div>
        <table class="styled-table" style="text-align: left;">
            <tr>
                <?php
                $current_query_string = $_SERVER['QUERY_STRING'];
                parse_str($current_query_string, $query_params);
                $current_order_by = $_GET['order_by'] ?? 'vqcf.cf_1162';
                $current_order_dir = $_GET['order_dir'] ?? 'asc'; 
                ?>
                <th><h2><a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a></h2></th>
                <th>Travel Date
                    <a href="<?php echo generate_sorting_url('vqcf.cf_1162', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqcf.cf_1162', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th colspan="2">Payment Due
                    <a href="<?php echo generate_sorting_url('vqcf.cf_1182', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqcf.cf_1182', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Type</th>
                <th></th>
                <th>Quote Number
                    <a href="<?php echo generate_sorting_url('vq.quote_no', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.quote_no', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Pax
                    <a href="<?php echo generate_sorting_url('vq.adults', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.adults', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Subject
                    <a href="<?php echo generate_sorting_url('vq.subject', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.subject', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Organization
                    <a href="<?php echo generate_sorting_url('va.accountname', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('va.accountname', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Contact Name
                    <a href="<?php echo generate_sorting_url('contactname', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('contactname', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Contact Phone</th>
                <th>Country</th>
                <th>Quote Stage</th>
                <th>Created Date
                    <a href="<?php echo generate_sorting_url('created_at', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('created_at', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>
                    Region
                    <a href="<?php echo generate_sorting_url('vqinfo.assigned_to_region', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqinfo.assigned_to_region', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>
                    Internal Sales
                    <a href="<?php echo generate_sorting_url('vqinfo.assigned_to_sales_agent', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqinfo.assigned_to_sales_agent', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>
                    External Sales
                    <a href="<?php echo generate_sorting_url('vqinfo.assigned_to_external_sales_agent', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqinfo.assigned_to_external_sales_agent', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>
                    Priority
                    <a href="<?php echo generate_sorting_url('vqinfo.priority', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqinfo.priority', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Follow Up <i id="info-icon" title="Status" class="fa-solid fa-question-circle" style="cursor: pointer;"></i></th>
                <th>Call Time</th>
            </tr>
            <tr>
                <form method="GET" action="">
					<input type="hidden" name="query" id="query_hidden">
                    <input type="hidden" name="opt" value="<?php echo $_GET['opt']; ?>">
                    <td style="text-align: center;"><button type="submit">Search</button></td>
                    <td><input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"></td>
                    <td colspan="2"><input type="text" id="payment_due_range" name="payment_due_range" value="<?php echo isset($_GET['payment_due_range']) ? htmlspecialchars($_GET['payment_due_range']) : ''; ?>"></td>
                    <td>
                        <select name="quote_type" style="margin: 0; width: 100%;">
                            <?php if (($title == 'sales' || $title == 'external') && ($quote_view == 'both')) : ?>
                                <option value="">All</option>
                            <?php endif; ?>
                            <?php if (($title == 'sales' || $title == 'external') && ($quote_view == 'both' || $quote_view == 'group')) : ?>
                                <option value="group" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'group') ? 'selected' : ''; ?>>Group</option>
                            <?php endif; ?>
                            <?php if (($title == 'sales' || $title == 'external') && ($quote_view == 'both' || $quote_view == 'fit')) : ?>
                                <option value="fit-dashboard" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit-dashboard') ? 'selected' : ''; ?>>FIT</option>
                            <?php endif; ?>

                            <?php if ($title != 'sales' && $title != 'external') : ?>
                                <option value="">All</option>
                                <option value="group" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'group') ? 'selected' : ''; ?>>Group</option>
                                <option value="fit-dashboard" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit-dashboard') ? 'selected' : ''; ?>>FIT</option>
                            <?php endif; ?>
                        </select>
                    </td>
                    <td></td>
                    <td><input type="text" name="quote_no" value="<?php echo isset($_GET['quote_no']) ? htmlspecialchars($_GET['quote_no']) : ''; ?>" style="width: 125px;"></td>
                    <td style="width: 5%;"><i class="fa-solid fa-key tooltip-key-partner"></i> <input type="checkbox" name="key_quotes" value="1" <?php echo isset($_GET['key_quotes']) && $_GET['key_quotes'] == '1' ? 'checked' : ''; ?>></td>
                    <td><input type="text" name="subject" value="<?php echo isset($_GET['subject']) ? htmlspecialchars($_GET['subject']) : ''; ?>"></td>
                    <td><input type="text" name="organization" value="<?php echo isset($_GET['organization']) ? htmlspecialchars($_GET['organization']) : ''; ?>"></td>
                    <td><input type="text" name="contact" value="<?php echo isset($_GET['contact']) ? htmlspecialchars($_GET['contact']) : ''; ?>"></td>
                    <td><input type="text" name="contact_mobile" value="<?php echo isset($_GET['contact_mobile']) ? htmlspecialchars($_GET['contact_mobile']) : ''; ?>"></td>
                    <td>
                        <select name="country">
                            <option value=""></option>
                            <option value="Australia" <?php echo (isset($_GET['country']) && $_GET['country'] == 'Australia') ? 'selected' : ''; ?>>Australia</option>
                            <option value="New Zealand" <?php echo (isset($_GET['country']) && $_GET['country'] == 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                        </select>
                    </td>
                    <?php $quoteStages = fetchQuoteStages($conn); ?>
                    <td>
                        <div style="width: 100%;">
                            <input type="text" id="quote_stage_input" name="quote_stage" value="<?php echo isset($_GET['quote_stage']) ? htmlspecialchars($_GET['quote_stage']) : ''; ?>" readonly style="width: 100%;">
                            <div id="checkboxes" style="display: none; border: 1px solid #ccc; padding: 10px; position: absolute; background: white; z-index: 1000;">
                                <?php foreach ($quoteStages as $stage): ?>
                                    <label>
                                        <input type="checkbox" value="<?php echo htmlspecialchars($stage); ?>" 
                                            <?php 
                                            if(isset($_GET['quote_stage']) && $_GET['quote_stage'] != '') {
                                                $checked_stage = explode(',', $_GET['quote_stage']);
                                                echo in_array($stage, $checked_stage) ? 'checked' : '';
                                            }
                                            ?>
                                        >
                                        <?php echo htmlspecialchars($stage); ?>
                                    </label><br>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </td>
                    <script>
                        const input = document.getElementById('quote_stage_input');
                        const checkboxes = document.getElementById('checkboxes');
						
						const queryInput = document.getElementById('query'); // Get the query input element
						const queryHiddenInput = document.getElementById('query_hidden'); // Get the hidden input element

						// Initially set the hidden input value on page load
						queryHiddenInput.value = queryInput.value;

						// Update query_hidden whenever the value in query input changes
						queryInput.addEventListener('input', function() {
							queryHiddenInput.value = queryInput.value; // Update hidden input with current query input value
						});

                        // Toggle the display of the checkboxes on input click
                        input.addEventListener('click', function() {
                            checkboxes.style.display = checkboxes.style.display === 'block' ? 'none' : 'block';
                        });

                        // Update the input field with selected checkbox values
                        document.querySelectorAll('#checkboxes input[type="checkbox"]').forEach(checkbox => {
                            checkbox.addEventListener('change', function() {
                                const selectedValues = Array.from(document.querySelectorAll('#checkboxes input[type="checkbox"]:checked')).map(cb => cb.value);
                                input.value = selectedValues.join(','); // Join selected values with a comma
                            });
                        });

                        // Close the checkbox dropdown when clicking outside
                        document.addEventListener('click', function(event) {
                            if (!input.contains(event.target) && !checkboxes.contains(event.target)) {
                                checkboxes.style.display = 'none';
                            }
                        });
                    </script>
                    <td><input type="text" id="create_date_range" name="create_date_range" value="<?php echo isset($_GET['create_date_range']) ? htmlspecialchars($_GET['create_date_range']) : ''; ?>"></td>
                    <td>
                        <select name="assigned_to_region">
                            <option value=""></option>
                            <?php
                            // Query to get group names from the vtiger_groups table
                            $sqlr = "SELECT groupname FROM vtiger_groups";
                            $resultr = $conn->query($sqlr);

                            // Populate the select dropdown with group names
                            if ($resultr->num_rows > 0) {
                                while ($rowr = $resultr->fetch_assoc()) {
                                    $selected = (isset($_GET['assigned_to_region']) && $_GET['assigned_to_region'] == $rowr['groupname']) ? 'selected' : '';
                                    echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                                }
                            }
                            ?>
                        </select>
                    </td>
                    <td>
                        <input type="text" name="assigned_to_sales_agent" 
                            <?= $global_file_access != 'all' ? 'readonly style="background-color: lightgrey; cursor: not-allowed;"' : '' ?> 
                            value="<?php echo isset($_GET['assigned_to_sales_agent']) ? htmlspecialchars($_GET['assigned_to_sales_agent']) : ''; ?>" 
                            id="assigned_to_sales_agent">
                        <br>
                        <label>
                            <input type="checkbox" id="self_checkbox" onclick="toggleSelf()" <?= $_GET['assigned_to_sales_agent'] == $username_ajax ? 'checked' : '' ?> > Assigned
                        </label>
                    </td>
                    <td>
                        <input type="text" name="assigned_to_external_sales_agent" 
                            <?= $global_file_access != 'all' ? 'readonly style="background-color: lightgrey; cursor: not-allowed;"' : '' ?> 
                            value="<?php echo isset($_GET['assigned_to_external_sales_agent']) ? htmlspecialchars($_GET['assigned_to_external_sales_agent']) : ''; ?>" 
                            id="assigned_to_external_sales_agent">
                        <br>
                        <label>
                            <input type="checkbox" id="external_self_checkbox" onclick="toggleExternalSelf()" <?= $_GET['assigned_to_external_sales_agent'] == $username_ajax ? 'checked' : '' ?>> Assigned
                        </label>
                    </td>
                    <script>
                        function toggleSelf() {
                            let inputField = document.getElementById('assigned_to_sales_agent');
                            let checkbox = document.getElementById('self_checkbox');

                            if (checkbox.checked) {
                                inputField.value = "<?= $username_ajax ?>";
                            } else {
                                inputField.value = "";
                            }
                        }
                        function toggleExternalSelf() {
                            let inputField = document.getElementById('assigned_to_external_sales_agent');
                            let checkbox = document.getElementById('external_self_checkbox');

                            if (checkbox.checked) {
                                inputField.value = "<?= $username_ajax ?>";
                            } else {
                                inputField.value = "";
                            }
                        }
                    </script>
                    <td>
                        <select name="priority">
                            <option value="">All</option>
                            <option value="high" <?php echo (isset($_GET['priority']) && $_GET['priority'] == 'high') ? 'selected' : ''; ?>>High</option>
                            <option value="low" <?php echo (isset($_GET['priority']) && $_GET['priority'] == 'low') ? 'selected' : ''; ?>>Low</option>
                            <option value="none" <?php echo (isset($_GET['priority']) && $_GET['priority'] == 'none') ? 'selected' : ''; ?>>Blank</option>
                            <option value="not connected" <?php echo (isset($_GET['priority']) && $_GET['priority'] == 'not connected') ? 'selected' : ''; ?>>Not Connected</option>
                        </select>
                    </td>
                    <td><input type="text" id="followup_date_range" name="followup_date_range" value="<?php echo isset($_GET['followup_date_range']) ? htmlspecialchars($_GET['followup_date_range']) : ''; ?>"></td>
                    <td><input type="text" id="call_time_date_range" name="call_time_date_range" value="<?php echo isset($_GET['call_time_date_range']) ? htmlspecialchars($_GET['call_time_date_range']) : ''; ?>"></td>
                </form>
                <div id="tooltip" class="tooltip-content">
                    <p><b>Status Descriptions:</b></p>
                    <ul>
                        <li><i class="fa-solid fa-phone" style="color: green;"></i> Call Complete by Internal Agent</li>
                        <li><i class="fa-solid fa-phone-volume" style="color: green;"></i> Call Complete by External Agent</li>
                        <li><i class="fa-solid fa-phone" style="color: red;"></i> Not Called</li>
                    </ul>
                </div>
                <style>
                    /* Tooltip container */
                    .tooltip-content {
                        display: none;
                        position: absolute;
                        background-color: #f9f9f9;
                        border: 1px solid #ddd;
                        padding: 10px;
                        width: 200px;
                        z-index: 10;
                        right: 30px;
                        top: 40px;
                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                    }

                    .tooltip-content ul {
                        list-style-type: none;
                        padding: 0;
                    }

                    .tooltip-content ul li {
                        font-size: 14px;
                        margin: 5px 0;
                    }
                </style>

                <!-- Tooltip JavaScript -->
                <script>
                    // Get the tooltip and the icon element
                    var tooltip = document.getElementById("tooltip");
                    var infoIcon = document.getElementById("info-icon");

                    // Show the tooltip when the question mark icon is clicked
                    infoIcon.onclick = function() {
                        if (tooltip.style.display === "block") {
                            tooltip.style.display = "none";
                        } else {
                            tooltip.style.display = "block";
                        }
                    };

                    // Hide the tooltip when clicking anywhere outside
                    window.onclick = function(event) {
                        if (event.target !== infoIcon && tooltip.style.display === "block") {
                            tooltip.style.display = "none";
                        }
                    };
                </script>
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
                <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
                <script>
                    flatpickr("#date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
                    });

                    flatpickr("#payment_due_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['payment_due_range']) ? htmlspecialchars($_GET['payment_due_range']) : ''; ?>"
                    });

                    flatpickr("#create_date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['create_date_range']) ? htmlspecialchars($_GET['create_date_range']) : ''; ?>"
                    });

                    flatpickr("#followup_date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['followup_date_range']) ? htmlspecialchars($_GET['followup_date_range']) : ''; ?>"
                    });

                    flatpickr("#call_time_date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['call_time_date_range']) ? htmlspecialchars($_GET['call_time_date_range']) : ''; ?>"
                    });
                </script>
            </tr>
    
            <?php
            $help_sql = "";
            if(isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit') {
                $sql = "SELECT 
                            vq.*, 
                            va.organization_name AS accountname, vcd.name AS contactname, 
                            vqcf.cf_1162, vqcf.cf_1182, vuvc.createdtime AS created_at,
                            vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent, vqinfo.priority, vqinfo.assigned_to_region
                        FROM vtiger_quotes_crm vq
                        LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                        LEFT JOIN tdu_contacts vcd ON vq.contactid=vcd.auto_id AND va.organizationid = vcd.organizationid
                        LEFT JOIN vtiger_crmentity_crm vuvc ON vq.quoteid = vuvc.crmid
                        LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid=vqcf.quoteid
                        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='fit'
                        WHERE 1=1";
            } else {
                $sql = "SELECT 
                            vq.*, 
                            va.organization_name AS accountname, va.preferred, vcd.name AS contactname, vcd.mobile AS contact_mobile,
                            vqcf.cf_1162, vqcf.cf_1182,
                            vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent, vqinfo.priority, vqinfo.assigned_to_region
                        FROM (SELECT *
                            FROM vtiger_quotes
                            WHERE quoteid = (
                                SELECT MIN(quoteid) AS quoteid
                                FROM vtiger_quotes AS sub
                                WHERE sub.quote_no = vtiger_quotes.quote_no)
                            ORDER BY quote_no DESC) vq
                        LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
                        LEFT JOIN tdu_contacts vcd ON vq.contactid=vcd.auto_id AND va.organizationid = vcd.organizationid
                        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
                        WHERE deleted = 0";

                if($_GET['quote_type'] == 'fit-dashboard') {
                    $sql .= " AND (vq.quote_no NOT LIKE '%G' OR vq.help_needed = 1)";
                    $help_sql = "(vq.quote_no LIKE '%G' AND vq.help_needed = 1) DESC, ";
                }
                else if($_GET['quote_type'] == 'group') {
                    $sql .= " AND (vq.quote_no LIKE '%G' OR vq.help_needed = 1)";
                    $help_sql = "(vq.quote_no NOT LIKE '%G' AND vq.help_needed = 1) DESC, ";

                }
            }

            if ($title == 'sales' || $title == 'external') {
                if ($department != '') {
                    // Convert department into an array and wrap each value in single quotes
                    $departments = explode(',', $department);
                    $departments = array_map(function($dep) { return "'" . trim($dep) . "'"; }, $departments);
            
                    // Join them into a single string for the IN clause
                    $departmentList = implode(',', $departments);
            
                    // Add to the SQL query
                    $sql .= " AND vqinfo.assigned_to_region IN ($departmentList)";
                }
            }

            if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
                $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
                $start_date = $date_range[0];
                $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
                $sql .= " AND DATE(vqcf.cf_1162) BETWEEN '$start_date' AND '$end_date'";
            }
            if (isset($_GET['payment_due_range']) && !empty($_GET['payment_due_range'])) {
                $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['payment_due_range']));
                $start_date = $date_range[0];
                $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
                $sql .= " AND DATE(vqcf.cf_1182) BETWEEN '$start_date' AND '$end_date'";
            }
            if (isset($_GET['quote_no']) && !empty($_GET['quote_no'])) {
                $quote_no = mysqli_real_escape_string($conn, $_GET['quote_no']);
                $sql .= " AND vq.quote_no LIKE '%$quote_no%'";
            }
            if (isset($_GET['key_quotes']) && $_GET['key_quotes'] == '1') {
                $sql .= " AND (vq.adults + vq.children >= 50 OR va.preferred = 1)";
            }
            if (isset($_GET['subject']) && !empty($_GET['subject'])) {
                $subject = mysqli_real_escape_string($conn, $_GET['subject']);
                $sql .= " AND vq.subject LIKE '%$subject%'";
            }
            if (isset($_GET['organization']) && !empty($_GET['organization'])) {
                $organization = mysqli_real_escape_string($conn, $_GET['organization']);
                $sql .= " AND va.accountname LIKE '%$organization%'";
            }
            if (isset($_GET['contact']) && !empty($_GET['contact'])) {
                $contact = mysqli_real_escape_string($conn, $_GET['contact']);
                if(isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit') {
                    $sql .= " AND CONCAT(vcd.firstname, ' ', vcd.lastname) LIKE '%$contact%'";
                } else {
                    $sql .= " AND vcd.name LIKE '%$contact%'";
                }
            }
            if (isset($_GET['contact_mobile']) && !empty($_GET['contact_mobile'])) {
                $contact_mobile = mysqli_real_escape_string($conn, $_GET['contact_mobile']);
                $sql .= " AND vcd.mobile LIKE '%$contact_mobile%'";
            }
            if (isset($_GET['country']) && !empty($_GET['country'])) {
                $country = mysqli_real_escape_string($conn, $_GET['country']);
                $sql .= " AND vq.country = '$country'";
            }
            if (isset($_GET['quote_stage']) && !empty($_GET['quote_stage'])) {
                $quote_stage = mysqli_real_escape_string($conn, $_GET['quote_stage']);
                $stages_array = explode(',', $quote_stage);
                $stages_array = array_map('trim', $stages_array);
                $stages_array = array_map(function($stage) use ($conn) {
                    return "'" . mysqli_real_escape_string($conn, $stage) . "'";
                }, $stages_array);
                $stages_list = implode(',', $stages_array);
                $sql .= " AND vq.quotestage IN ($stages_list)";
            }
            if (isset($_GET['create_date_range']) && !empty($_GET['create_date_range'])) {
                $create_date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['create_date_range']));
                $create_start_date = $create_date_range[0];
                $create_end_date = isset($create_date_range[1]) ? $create_date_range[1] : $create_date_range[0];
                if($_GET['quote_type'] == 'fit') {
                    $sql .= " AND DATE(vuvc.createdtime) BETWEEN '$create_start_date' AND '$create_end_date'";
                } 
                else {
                    $sql .= " AND DATE(vq.created_at) BETWEEN '$create_start_date' AND '$create_end_date'";
                }
            }
            if (isset($_GET['assigned_to_region']) && !empty($_GET['assigned_to_region'])) {
                $assigned_to_region = mysqli_real_escape_string($conn, $_GET['assigned_to_region']);
                $sql .= " AND vqinfo.assigned_to_region = '$assigned_to_region'";
            }
            if (isset($_GET['assigned_to_sales_agent']) && !empty($_GET['assigned_to_sales_agent'])) {
                $assigned_to_sales_agent = mysqli_real_escape_string($conn, $_GET['assigned_to_sales_agent']);
                if($assigned_to_sales_agent == 'unassigned') {
                    $sql .= " AND (vqinfo.assigned_to_sales_agent IS NULL OR vqinfo.assigned_to_sales_agent = '')";
                } else {
                    $sql .= " AND vqinfo.assigned_to_sales_agent LIKE '%$assigned_to_sales_agent%'";
                }
            }
            if (isset($_GET['assigned_to_external_sales_agent']) && !empty($_GET['assigned_to_external_sales_agent'])) {
                $assigned_to_external_sales_agent = mysqli_real_escape_string($conn, $_GET['assigned_to_external_sales_agent']);
                if($assigned_to_external_sales_agent == 'unassigned') {
                    $sql .= " AND (vqinfo.assigned_to_external_sales_agent IS NULL OR vqinfo.assigned_to_external_sales_agent = '')";
                } else {
                    $sql .= " AND vqinfo.assigned_to_external_sales_agent LIKE '%$assigned_to_external_sales_agent%'";
                }
            }
            if (isset($_GET['followup_date_range']) && !empty($_GET['followup_date_range'])) {
                $followup_date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['followup_date_range']));
                $followup_start_date = $followup_date_range[0];
                $followup_end_date = isset($followup_date_range[1]) ? $followup_date_range[1] : $followup_date_range[0]; // in case only one date is selected
                $sql .= " AND vq.quoteid IN (SELECT quoteid FROM vtiger_quotes_followup WHERE quotetype = 'group' AND DATE(next_follow_up_date) BETWEEN '$followup_start_date' AND '$followup_end_date')";
            }
            if (isset($_GET['call_time_date_range']) && !empty($_GET['call_time_date_range'])) {
                $call_time_date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['call_time_date_range']));
                $call_start_date = $call_time_date_range[0];
                $call_end_date = isset($call_time_date_range[1]) ? $call_time_date_range[1] : $call_time_date_range[0]; // in case only one date is selected
                $sql .= " AND vq.quoteid IN (SELECT quoteid FROM vtiger_quotes_followup WHERE quotetype = 'group' AND DATE(calltime) BETWEEN '$call_start_date' AND '$call_end_date')";
            }
            if ($global_file_access != 'all') {
                if ($global_file_access == 'assigned_created' && $_GET['quote_type'] != 'fit') {
                    $sql .= " AND (
                        vqinfo.assigned_to_sales_agent = '$username_ajax' 
                        OR vqinfo.assigned_to_external_sales_agent = '$username_ajax' 
                        OR vq.created_by = '$username' 
                        OR (
                            (vqinfo.assigned_to_sales_agent IS NULL OR vqinfo.assigned_to_sales_agent = '') 
                            AND (vqinfo.assigned_to_external_sales_agent IS NULL OR vqinfo.assigned_to_external_sales_agent = '')
                        )
                    )";
                } else if ($global_file_access == 'created_only' && $_GET['quote_type'] != 'fit') {
                    $sql .= " AND vq.created_by = '$username'";
                } else if ($global_file_access == 'assigned_only') {
                    $sql .= " AND (
                        vqinfo.assigned_to_sales_agent = '$username_ajax' 
                        OR vqinfo.assigned_to_external_sales_agent = '$username_ajax' 
                        OR (
                            (vqinfo.assigned_to_sales_agent IS NULL OR vqinfo.assigned_to_sales_agent = '') 
                            AND (vqinfo.assigned_to_external_sales_agent IS NULL OR vqinfo.assigned_to_external_sales_agent = '')
                        )
                    )";
                }
            }
            if (isset($_GET['priority']) && !empty($_GET['priority'])) {
                $priority = mysqli_real_escape_string($conn, $_GET['priority']);
                if ($priority == 'none') {
                    $sql .= " AND (vqinfo.priority IS NULL OR vqinfo.priority = '')";
                } else {
                    $sql .= " AND vqinfo.priority = '$priority'";
                }
            }
            if (($title == 'sales' || $title == 'external') && $global_view_followup == 0) {
                if ($title == 'sales') {
                    $followup_need_to_check = " AND (vq.quote_no NOT LIKE '%G' OR vq.help_needed = 1)";
                } else {
                    $followup_need_to_check = " AND (vq.quote_no LIKE '%G' OR vq.help_needed = 1)";
                }

                $quoteids = [];
                $quoteids_payment_due = [];

                // payment due check
                $sql_payment_due_check =   "SELECT 
                                                vq.quoteid, 
                                                SUM(CAST(vph.total_amount AS DECIMAL(10,2))) AS amount_due, 
                                                SUM(CAST(vph.trams_received_amount AS DECIMAL(10,2))) AS amount_received
                                            FROM vtiger_quotes vq 
                                            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                                            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype = 'group' 
                                            LEFT JOIN vtiger_payment_history vph ON vq.quoteid = vph.quoteid
                                            WHERE vq.quotestage = 'Accepted' AND vqcf.cf_1182 <= CURDATE() AND (vph.source != 'final' OR vph.source IS NULL)
                                                AND (vqinfo.assigned_to_sales_agent='$username_ajax' OR vqinfo.assigned_to_external_sales_agent='$username_ajax') $followup_need_to_check
                                            GROUP BY vq.quoteid
                                            HAVING amount_received < amount_due - 30 OR amount_due <= 0 OR amount_due IS NULL OR amount_received IS NULL;";
                $result_payment_due_check = mysqli_query($conn, $sql_payment_due_check);
                if(mysqli_num_rows($result_payment_due_check) > 0) {
                    while ($row_payment_due_check = mysqli_fetch_assoc($result_payment_due_check)) {
                        $quoteids_payment_due[] = mysqli_real_escape_string($conn, $row_payment_due_check['quoteid']);
                    }
                }

                // followup check
                $sql_followup_check =  "SELECT fq.quoteid FROM vtiger_quotes_followup fq 
                                        LEFT JOIN vtiger_quotes_info vqinfo ON fq.quoteid=vqinfo.quoteid AND vqinfo.quotetype = 'group'
                                        LEFT JOIN vtiger_quotes vq ON fq.quoteid=vq.quoteid
                                        WHERE fq.quotetype = 'group' $followup_need_to_check AND fq.calltime IS NULL AND DATE(fq.next_follow_up_date) < CURDATE() AND (vq.quotestage = 'Created' OR vq.quotestage = 'Requote')
                                            AND (vqinfo.assigned_to_sales_agent='$username_ajax' OR vqinfo.assigned_to_external_sales_agent='$username_ajax');";
                $result_followup_check = mysqli_query($conn, $sql_followup_check);
                if(mysqli_num_rows($result_followup_check) > 0) {
                    while ($row_followup_check = mysqli_fetch_assoc($result_followup_check)) {
                        $quoteids[] = mysqli_real_escape_string($conn, $row_followup_check['quoteid']);
                    }
                }

                if (!empty($quoteids)) {
                    $sql .= " OR vq.quoteid IN (" . implode(",", $quoteids) . ")";

                    ?>
                    <div id="editHotelModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: center; z-index: 1000;">
                        <div style="background: white; padding: 20px; border-radius: 8px; width: 50%; text-align: center; box-shadow: 0px 0px 10px rgba(0,0,0,0.3);">
                            <h1 style="margin-bottom: 15px;">Notice</h1>
                            <h2 style="margin-bottom: 15px; color: red;">You have followup pending / payment due</h2>
                            <button onclick="document.getElementById('editHotelModal').style.display='none';" 
                                style="background: #334155; color: white; border: none; padding: 10px 15px; border-radius: 5px; cursor: pointer;">
                                Close
                            </button>
                        </div>
                    </div>
                    <?php 
                }
            }
            if(isset($current_order_by) || isset($current_order_dir)) {
                if (!empty($quoteids) || !empty($quoteids_payment_due)) {
                    $sql .= " ORDER BY 
                        FIELD(vq.quoteid, " . implode(",", array_merge($quoteids, $quoteids_payment_due)) . ") DESC, 
                        $help_sql $current_order_by $current_order_dir, 
                        vqcf.cf_1162 ASC, 
                        (vqcf.cf_1182 = '0000-00-00') ASC, 
                        vqcf.cf_1182 ASC";
                } else {
                    $sql .= " ORDER BY 
                        $help_sql $current_order_by $current_order_dir, 
                        vqcf.cf_1162 ASC, 
                        (vqcf.cf_1182 = '0000-00-00') ASC, 
                        vqcf.cf_1182 ASC";
                }
            }
			
			//allRows will house the filtered rows
			$allRows = [];   
			//algorithm to filter for rows with keywords
			if (!empty($searchWords)) 
			{		
				
				$keywordResult = $conn->query($sql);
						
				// Calculate relevance
				while ($row = mysqli_fetch_assoc($keywordResult)) 
				{
					$relevance = 0;
					$content = "";
					$content2 = "";
					$row['Matches'] = array();
					$base_sql2 = 
					"
                    SELECT DISTINCT
					ROW_NUMBER() OVER (ORDER BY sq.sequence_no) AS row_num,
						sq.quoteid,
						sq.sequence_no,
						sq.cf_928,
						sq.productName,
						sq.vendorName,
						sq.Comment,
						sq.Description
					FROM (
						SELECT
							vi.id AS quoteid, /* Alias vi.id as quoteid for clarity in subquery */
							vi.sequence_no,
							vi.cf_928,
							COALESCE(vpc.productname, tdp.productname) AS productName,
							COALESCE(vvc.vendorname, tdv.vendorname) AS vendorName,
							vi.comment AS Comment,
							tdp.description AS Description,
							vq.quoteid AS actual_quoteid /* Keep actual quoteid for filtering later */
						FROM vtiger_inventoryproductrel vi
						LEFT JOIN tdu_products tdp
							ON vi.productid = tdp.productid
						LEFT JOIN vtiger_products_custom vpc
							ON vi.productid = vpc.productid
						LEFT JOIN vtiger_vendor_custom vvc
							ON vi.vendorid = vvc.vendorid
						LEFT JOIN tdu_vendors tdv
							ON tdp.vendorid = tdv.vendorid
						LEFT JOIN vtiger_quotes vq
							ON vi.id = vq.quoteid
						WHERE vq.quote_no = '$row[quote_no]'
					) AS sq
					WHERE sq.quoteid = (SELECT MIN(quoteid) FROM (SELECT vq.quoteid AS quoteid FROM vtiger_quotes vq WHERE vq.quote_no = '$row[quote_no]') AS min_quote_subquery )
					GROUP BY sq.sequence_no
					ORDER BY sq.sequence_no ASC
                    ";
											
					if (!empty($searchWords)) 
					{
								
						// Remove LIMIT for full results
						$sql2 = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql2);
						$result2 = mysqli_query($conn, $sql2);
						//$allRows = [];
				
						// Calculate relevance
						while ($row2 = mysqli_fetch_assoc($result2)) 
						{
							$content2 = implode(' ', array_map('strtolower', [
								$row2['productName'],
								$row2['vendorName']
							]));
									
							$safe = false;
							foreach ($searchWords as $word) 
							{
								$relevance += substr_count($content2, $word);
								if(substr_count($content2, $word)>0)
								{
									if(array_key_exists($word, $row['Matches'])){$row['Matches'][$word]++;}
									else
									{
										$row['Matches'][$word] = 1;
										if($relevance>0){
										if(array_key_exists($word, $keywordMatches)){$keywordMatches[$word]++;}
										else{$keywordMatches[$word] = 1;}}     
									}
									$safe = true;
								} 
							}
						}
								
						//trim the rows with no matches or mismatch for keywords
						if(empty($row['Matches']) || !empty(array_diff($searchWords, array_keys($row['Matches']))))
						{
							if($relevance>0)
							{//var_dump($row['Matches']);
								$relevance-=10000;//foreach ($cityMatches as $cityMatch => &$cityCount) {$cityCount--;}
							}
						}
					}
						
					if ($relevance > 0) 
					{
						$row['relevance'] = $relevance;
						$allRows[] = $row;
					}
				}
			}else
			{
				$allRows = mysqli_fetch_all($conn->query($sql), MYSQLI_ASSOC);
			}
            
            // Pagination setup
            $results_per_page = 30; // Adjust as needed
            $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
            $offset = ($current_page - 1) * $results_per_page;
            
            // Total count for pagination
            $total_result_query = mysqli_query($conn, $sql);
            $total_quotes = mysqli_num_rows($total_result_query);
            $total_pages = ceil($total_quotes / $results_per_page);
            
            $sql .= " LIMIT $offset, $results_per_page";
            $result = mysqli_query($conn, $sql);
			
			$total_quotes = count($allRows);
            $total_pages = ceil($total_quotes / $results_per_page);
            $offset = ($current_page - 1) * $results_per_page;
            $paginatedRows = array_slice($allRows, $offset, $results_per_page);
            
			

			
            if ($result && mysqli_num_rows($result) > 0) {
                ?>
                <form method="GET" action="">
                    <input type="hidden" name="opt" value="multi-edit-sales">
                    <?php
                    if ($_GET['quote_type'] == 'fit') {
                        $quote_type = 'fit';
                    } else if ($_GET['quote_type'] == 'fit-dashboard') {
                        $quote_type = 'fit-dashboard';
                    } else {
                        $quote_type = 'group';
                    }
                    ?>
                    <input type="hidden" name="quotetype" value="<?php echo $quote_type; ?>">
                    <?php
                    $search_break = null;
                    foreach ($paginatedRows as $row){
                        $quoteid = $row['quoteid'];

                        if($_GET['quote_type'] == 'fit-dashboard' || $_GET['quote_type'] == 'group') {
                            if ($search_break == null && (!empty($quoteids) || !empty($quoteids_payment_due)) && !in_array($row['quoteid'], array_merge($quoteids, $quoteids_payment_due))) {
                                $search_break = true;
                                echo '<tr style="text-align: left; background-color: lightyellow; color: red;"><td></td><td colspan="20">PLEASE WORK ON THESE QUOTES FIRST</td></tr>';
                            }
                        }

                        $disable_link = !empty($quoteids) && !in_array($row['quoteid'], $quoteids) && ($row['quotestage'] == 'Created' || $row['quotestage'] == 'Requote');
                        $work_first_link = !empty($quoteids) && in_array($row['quoteid'], $quoteids) && ($row['quotestage'] == 'Created' || $row['quotestage'] == 'Requote');
                    ?>
                    <tr <?php 
                        if ($disable_link) {
                            echo ' style="opacity: 0.5; cursor: not-allowed;"'; 
                        } else if ($work_first_link) {
                            echo ' style="color: red;"';
                        }

                        if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00' && 
                            in_array($row['quotestage'], ['Accepted', 'Requote After Confirmation', 'PRE QA - pending', 'PRE QA - completed'])) {
                            $date = new DateTime($row['cf_1182']);
                            $today = new DateTime();
                            $interval = $today->diff($date)->days;
                            if ($date < $today || $interval <= 14) {
                                echo 'style="background-color: #f8d7da;"';
                            }
                        }
                        ?>
                        >
                        <td>
                            <input type="checkbox" name="selected_quotes[]" value="<?php echo htmlspecialchars($quoteid); ?>" class="quote-checkbox">
                        </td>
                        <td style="width: 125px;">
                            <?php
                            if (isset($row['cf_1162']) && $row['cf_1162'] != '0000-00-00') {
                                $date = new DateTime($row['cf_1162']);
                                echo $date->format('d-M-Y');
                            }
                            ?>
                        </td>
                        <td style="width: 125px; <?= (!empty($quoteids_payment_due) && in_array($row['quoteid'], $quoteids_payment_due) && $row['quotestage'] == 'Accepted') ? 'background-color: red; color: white;' : '' ?>">
                            <?php 
                            if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00') {
                                $date = new DateTime($row['cf_1182']);
                                echo $date->format('d-M-Y');
                            }
                            ?>
                        </td>
                        <td>
                            <?php if(in_array($row['quotestage'], ['Created', 'Accepted', 'Requote After Confirmation', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers', 'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'])) { ?>
                                <div class="payment-icon-wrapper" style="position: relative;">
                                    <i class="fa-solid fa-circle-dollar-to-slot grey payment-icon" id="payment_icon_<?php echo $quoteid; ?>"></i>
                                    <div class="payment-popup" id="payment_popup_<?php echo $quoteid; ?>" style="display:none; position:absolute; top:24px; left:50%; transform:translateX(-50%); background:white; border:1px solid #ccc; padding:10px; z-index:999; width:220px; box-shadow:0 2px 6px rgba(0,0,0,0.2); font-size:13px;">
                                        <p>Loading...</p>
                                    </div>
                                </div>
                                <style>
                                    .payment-icon {
                                        cursor: pointer;
                                    }
                                    .payment-icon.grey {
                                        color: lightgrey;
                                    }
                                    .payment-icon.green {
                                        color: green;
                                    }
                                    .payment-icon.orange {
                                        color: orange;
                                    }
                                    .payment-icon.red {
                                        color: red;
                                    }
                                </style>
                                <script>
                                    document.addEventListener("DOMContentLoaded", function () {
                                        fetchPaymentStatus(<?php echo $quoteid; ?>);

                                        const icon = document.getElementById("payment_icon_<?php echo $quoteid; ?>");
                                        const popup = document.getElementById("payment_popup_<?php echo $quoteid; ?>");

                                        icon.addEventListener("click", function (e) {
                                            e.stopPropagation();
                                            if (popup.style.display === "none") {
                                                fetch('quote_payment_status_ajax.php?quoteid=<?php echo $quoteid; ?>&action=popup')
                                                    .then(response => response.text())
                                                    .then(data => {
                                                        popup.innerHTML = data;
                                                        popup.style.display = "block";
                                                    });
                                            } else {
                                                popup.style.display = "none";
                                            }
                                        });

                                        document.addEventListener("click", function () {
                                            popup.style.display = "none";
                                        });
                                    });

                                    function fetchPaymentStatus(quoteId) {
                                        fetch('quote_payment_status_ajax.php?quoteid=' + quoteId + '&action=status')
                                            .then(response => response.json())
                                            .then(data => {
                                                const icon = document.getElementById('payment_icon_' + quoteId);
                                                if (data && data.colorClass) {
                                                    icon.classList.remove('grey', 'green', 'orange', 'red');
                                                    icon.classList.add(data.colorClass);

                                                    if (data.colorClass === 'green') {
                                                        const tr = icon.closest('tr');
                                                        const bgColor = window.getComputedStyle(tr).backgroundColor;

                                                        // Compare to RGB equivalent of #f8d7da
                                                        if (bgColor === 'rgb(248, 215, 218)') {
                                                            tr.style.backgroundColor = '';
                                                        }
                                                    }
                                                }
                                            });
                                    }
                                </script>
                            <?php } ?>
                        </td>
                        <td>
                            <?php 
                            if (substr($row['quote_no'], -1) === 'G') {
                                $quote_type = 'group';
                                echo 'Group';
                            } else {
                                $quote_type = 'fit-dashboard';
                                echo 'FIT';
                            }
                            ?>
                        </td>
                        <td>
                            <?php
                            if (isset($row['help_needed'])) {
                                if ($row['help_needed'] == 0) {
                                    echo '<i class="fa-solid fa-hand" style="color:lightgrey; cursor:pointer;" onclick="changeHelpStatus(' . $row['quoteid'] . ', this)"></i>';
                                } elseif ($row['help_needed'] == 1) {
                                    echo '<i class="fa-solid fa-handshake-angle" style="color:red; cursor:pointer;" onclick="changeHelpStatus(' . $row['quoteid'] . ', this)"></i>';
                                } elseif ($row['help_needed'] == 2) {
                                    echo '<i class="fa-solid fa-handshake-angle" style="color:green; cursor:pointer;" onclick="changeHelpStatus(' . $row['quoteid'] . ', this)"></i>';
                                }
                            }
                            ?>
                        </td>
                        <td>
                            <?php
                            if ($disable_link) {
                                // Display plain text (not a clickable link)
                                echo htmlspecialchars($row['quote_no']);
                            } else {
                                // Display as clickable link
                                ?>
                                <a <?= $work_first_link ? 'style="color: red;"' : '' ?> href="?opt=summary&sales=true&quotetype=<?php echo $quote_type; ?>&quoteid=<?php echo urlencode($row['quoteid']); ?>">
                                    <?php echo htmlspecialchars($row['quote_no']); ?>
                                </a>
                                <?php
                            }
                            ?>
                            <?php
                            if (isset($row['duplicate']) && $row['duplicate'] != '') {
                                echo '<i class="fas fa-copy" title="' . $row['duplicate'] . '"></i>';
                            }
                            ?>
                        </td>
                        <td><?php echo htmlspecialchars($row['adults'] + $row['children']); ?></td>
                        <td class="hover-expand">
                            <?php
                            if ($disable_link) {
                                // Display plain text (not a clickable link)
                                echo htmlspecialchars($row['subject']);
                            } else {
                                // Display as clickable link
                                ?>
                                <a <?= $work_first_link ? 'style="color: red;"' : '' ?> href="?opt=summary&sales=true&quotetype=<?php echo $quote_type; ?>&quoteid=<?php echo urlencode($row['quoteid']); ?>">
                                    <?php echo htmlspecialchars($row['subject']); ?>
                                </a>
                                <?php
                            }
                            ?>                            
                        </td>
                        <td class="hover-expand">
                            <?php if ($row['preferred'] == 1): ?>
                                <i class="fa-solid fa-key" title="Key Partner" style="color: blue;"></i>
                            <?php endif; ?>
                            <?php
                            if ($disable_link) {
                                // Display plain text (not a clickable link)
                                echo htmlspecialchars($row['accountname']);
                            } else {
                                // Display as clickable link
                                ?>
                                <a <?= $work_first_link ? 'style="color: red;"' : '' ?> href="quote.php?opt=organization-details&id=<?php echo urlencode($row['accountid']); ?>">
                                    <?php echo htmlspecialchars($row['accountname']); ?>
                                </a>
                                <?php
                            }
                            ?>                            
                        </td>
                        <td><?php echo htmlspecialchars($row['contactname']); ?></td>
                        <td><?php echo htmlspecialchars($row['contact_mobile']); ?></td>
                        <td><?php echo htmlspecialchars($row['country']); ?></td>
                        <td><?php echo htmlspecialchars($row['quotestage']); ?></td>
                        <td><?php $date = new DateTime($row['created_at']); echo $date->format('d-M-Y'); ?></td>
                        <td><?php echo htmlspecialchars($row['assigned_to_region']); ?></td>
                        <td><?php echo htmlspecialchars($row['assigned_to_sales_agent']); ?></td>
                        <td><?php echo htmlspecialchars($row['assigned_to_external_sales_agent']); ?></td>
                        <td><?php echo htmlspecialchars($row['priority']); ?></td>
                        <td colspan="2">
                            <?php
                            $infoquotetype = ($quote_type == 'group' || $quote_type == 'fit-dashboard') ? 'group' : 'fit';
                            $sql_followup = "SELECT vqf.*, vqinfo.assigned_to_sales_agent
                                            FROM vtiger_quotes_followup vqf
                                            LEFT JOIN vtiger_quotes_info vqinfo ON vqf.quoteid = vqinfo.quoteid AND vqinfo.quotetype = '$quote_type'
                                            WHERE vqf.quoteid = '$quoteid' AND vqf.quotetype = '$infoquotetype' ORDER BY vqf.next_follow_up_date ASC;";
                            $result_followup = mysqli_query($conn, $sql_followup);
                            if (mysqli_num_rows($result_followup) > 0) {
                                echo '<div class="status-in-search" style="display: flex;">';
                                while ($row_followup = mysqli_fetch_array($result_followup)) {
                                    $next_follow_up_date = date("d-M-Y H:i:s", strtotime($row_followup['next_follow_up_date']));
                                    $calltime = $row_followup['calltime'] ? date("d-M-Y H:i:s", strtotime($row_followup['calltime'])) : 'N/A';
                                    $description = htmlspecialchars($row_followup['description'], ENT_QUOTES, 'UTF-8');
                                    $icon_style = ($row_followup['followup'] == 'checked') ? "color: green; cursor: pointer;" : "color: red; cursor: pointer;";
                                    echo '<i class="fa-solid fa-phone followup-icon" style="font-size: 16px; ' . $icon_style . '" 
                                            data-date="' . $next_follow_up_date . '" 
                                            data-description="' . $description . '" 
                                            data-calltime="' . $calltime . '"
                                            onclick="openFollowupModal(this)"></i>';
                                }
                                echo '</div>';
                            }
                            ?>
                        </td>
                    </tr>
                    <?php
                    }
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" id="select-all" />All
                        </td>
                        <td colspan="20">
                            <button type="submit">Bulk Edit Details</button>
                        </td>
                    </tr>
                </form>

                <!-- Modal Background -->
                <div id="modalBackground" style="display:none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 9999;"></div>

                <!-- Modal Structure -->
                <div id="followupModal" class="modal" style="display:none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; box-shadow: 0px 0px 10px gray; z-index: 10000;">
                    <h3 style="margin: 0 20px;">Follow-Up Details</h3>
                    <p><strong>Followup Date: <span id="modalDate"></span></strong></p>
                    <p><strong>Call Time: <span id="modalCalltime"></span></strong></p>
                    <p><strong>Description:<br></strong> <span id="modalDescription" style="margin: 10px;"></span></p>
                </div>

                <script>
                    function openFollowupModal(element) {
                        document.getElementById('modalDate').innerText = element.getAttribute('data-date');
                        document.getElementById('modalCalltime').innerText = element.getAttribute('data-calltime');
                        document.getElementById('modalDescription').innerText = element.getAttribute('data-description');
                        document.getElementById('followupModal').style.display = 'block';
                        document.getElementById('modalBackground').style.display = 'block';
                    }

                    function closeFollowupModal() {
                        document.getElementById('followupModal').style.display = 'none';
                        document.getElementById('modalBackground').style.display = 'none';
                    }

                    // Close modal when clicking outside of it
                    document.addEventListener('click', function(event) {
                        var modal = document.getElementById('followupModal');
                        var background = document.getElementById('modalBackground');
                        if ((event.target === background) || (!modal.contains(event.target) && !event.target.classList.contains('followup-icon'))) {
                            closeFollowupModal();
                        }
                    });
                </script>

                <script>
                    document.getElementById('select-all').addEventListener('click', function() {
                        const checkboxes = document.querySelectorAll('.quote-checkbox');
                        checkboxes.forEach(checkbox => {
                            checkbox.checked = this.checked;
                        });
                    });
                </script>
                <?php
            }
            ?>

            <script>
                function changeHelpStatus(quoteid, icon) {
                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "ajax_update_help_status.php", true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

                    xhr.onreadystatechange = function() {
                        if (xhr.readyState == 4 && xhr.status == 200) {
                            // Expect the server to return the new status (0, 1, 2)
                            var newStatus = parseInt(xhr.responseText);

                            if (newStatus === 0) {
                                icon.className = "fa-solid fa-hand";
                                icon.style.color = "lightgrey";
                            } else if (newStatus === 1) {
                                icon.className = "fa-solid fa-handshake-angle";
                                icon.style.color = "red";
                            } else if (newStatus === 2) {
                                icon.className = "fa-solid fa-handshake-angle";
                                icon.style.color = "green";
                            }
                        }
                    };

                    xhr.send("quoteid=" + encodeURIComponent(quoteid));
                }
            </script>
        </table>
        <div style="margin-top: 10px; margin-left: 5%;">number of results found: <?php echo $total_quotes; ?></div>
        <div class="pagination" style="margin-top: 0;">
            <div>
                <?php if ($current_page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $current_page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                <?php endif; ?>
        
                <?php
                $max_pages = min($total_pages, $current_page + 2);
                for ($page = $current_page; $page <= $max_pages; $page++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page])); ?>" <?php if ($page == $current_page) echo 'style="background-color: #334155; color: white;"'; ?>>
                        <?php echo $page; ?>
                    </a>
                <?php endfor; ?>
        
                <?php if ($current_page < $total_pages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $current_page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                <?php endif; ?>
            </div>
            <form method="GET" action="" style="display:inline;">
                <?php
                foreach ($_GET as $key => $value) {
                    if ($key != 'page') {
                        echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                    }
                }
                ?>
                <input type="number" name="page" min="1" max="<?php echo $total_pages; ?>" value="<?php echo $current_page; ?>" style="width:75px;"> / <?php echo $total_pages; ?>
                <button type="submit">Jump</button>
            </form>
        </div>
    </div>
    <style>
        .status-in-search i {
            font-size: 16px;
            margin-right: 8px;
            color: red;
        }
        .status-in-search i.green {
            color: green;
        }
        .status-in-search i.orange {
            color: orange;
        }
        .status-in-search i.grey {
            color: grey;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'multi-edit-sales' && isset($_GET['selected_quotes']) && !empty($_GET['selected_quotes'])) {
    $selected_quotes = $_GET['selected_quotes'];
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $quotetype = ($_POST['quotetype'] == 'group' || $_POST['quotetype'] == 'fit-dashboard') ? 'group' : 'fit';
        $assigned_to_region = $_POST['assigned_to_region'] ?? '';
        $assigned_to_sales_agent = $_POST['assigned_to_sales_agent'] ?? '';
        $assigned_to_external_sales_agent = $_POST['assigned_to_external_sales_agent'] ?? '';
        $priority = $_POST['priority'] ?? '';

        foreach ($selected_quotes as $quoteid) {
            $fields = [
                'assigned_to_region' => $assigned_to_region,
                'assigned_to_sales_agent' => $assigned_to_sales_agent,
                'assigned_to_external_sales_agent' => $assigned_to_external_sales_agent,
                'priority' => $priority,
                'quotetype' => $quotetype
            ];
            
            $update_fields = [];
            foreach ($fields as $column => $value) {
                if ($value != '') {
                    $update_fields[] = "$column = VALUES($column)";
                }
            }
            
            $update_clause = implode(', ', $update_fields);
            $sql = "
                INSERT INTO vtiger_quotes_info 
                (quoteid, assigned_to_region, assigned_to_sales_agent, assigned_to_external_sales_agent, priority, time_stamp_with_name, quotetype)
                VALUES
                ('$quoteid', '$assigned_to_region', '$assigned_to_sales_agent', '$assigned_to_external_sales_agent', '$priority', NOW(), '$quotetype')
                ON DUPLICATE KEY UPDATE $update_clause;";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }

        $conn->close();
        header("Location: quote.php?opt=sales-search");
        exit();
    }

    include "header.php";
    ?>
    <form method="post" action="" style="width: 600px; margin: 0 auto;">
        <h2 style="border-bottom: 2px solid #333; margin: 20px 0;">Bulk Edit Sales Quotes</h2>
        <div class="form-row">
            <label for="priority">Priority:</label>
            <select id="priority" name="priority">
                <option value="" <?php echo empty($priority) ? 'selected' : ''; ?>>Select Priority</option>
                <option value="not connected" <?php echo $priority === 'not connected' ? 'selected' : ''; ?>>Not connected</option>
                <option value="low" <?php echo $priority === 'low' ? 'selected' : ''; ?>>Low</option>
                <option value="high" <?php echo $priority === 'high' ? 'selected' : ''; ?>>High</option>
            </select>
        </div>
        <div class="form-row">
            <label for="assigned_to_region">Assigned To (Region):</label>
            <select name="assigned_to_region">
                <option value=""></option>
                <?php
                $sqlr = "SELECT groupname FROM vtiger_groups";
                $resultr = $conn->query($sqlr);

                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        $selected = '';
                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        <div class="form-row">
            <label for="assigned_to_sales_agent">Assigned To (Internal Sales Agent):</label>
            <select id="assigned_to_sales_agent" name="assigned_to_sales_agent">
                <option value=""></option>
                <?php
                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                        WHERE title IN ('sales', 'admin') 
                        ORDER BY title ASC;";

                $resultr = $conn->query($sqlr);
                $current_title = '';

                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        if ($rowr['title'] !== $current_title) {
                            $current_title = $rowr['title'];
                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                        }

                        $selected = (isset($assigned_to_sales_agent) && $assigned_to_sales_agent == $rowr['name']) ? 'selected' : '';
                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>

        <div class="form-row">
            <label for="assigned_to_external_sales_agent">Assigned To (External Sales Agent):</label>
            <select id="assigned_to_external_sales_agent" name="assigned_to_external_sales_agent">
                <option value=""></option>
                <?php
                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                        WHERE title IN ('external', 'admin') 
                        ORDER BY title ASC;";

                $resultr = $conn->query($sqlr);
                $current_title = '';

                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        if ($rowr['title'] !== $current_title) {
                            $current_title = $rowr['title'];
                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                        }

                        $selected = (isset($assigned_to_external_sales_agent) && $assigned_to_external_sales_agent == $rowr['name']) ? 'selected' : '';
                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        <input type="hidden" name="quotetype" value="<?php echo $_GET['quotetype']; ?>" />
        <button type="submit" name="update_info">Update</button>
    </form>

    <style>
        .form-container {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
        }

        .form-column {
            padding: 20px;
            border-radius: 5px;
        }

        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 300px !important;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-row input[readonly] {
            background-color: #f9f9f9;
            cursor: not-allowed;
        }
    </style>
    <?php
}

// Group Quotes List
else if (($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'search') {
    include "header.php";
	include "cities_countries_functions.php";

    if (count($_GET) === 1) {
        $todayDate = date('Y-m-d');
        $futureDate = date('Y-m-d', strtotime('+5 years'));
        $_GET['date_range'] = "$todayDate to $futureDate";
    }
	if ($title == 'qa') {
        $_GET['quote_stage'] = 'PRE QA - pending,Final QA';
    }

    $quote_type = $_GET['quote_type'] ?? '';

	
	//Cities & countries variables
	$allCities = getAllCities($conn);
    $allCountries = getAllCountries($conn);
    $citiesByCountry = getCitiesByCountry($conn);
    $allCountries = array_keys($citiesByCountry);
    $tagValues = isset($_GET['tagValues']) ? explode(',', $_GET['tagValues']) : array();
    //$tagValues = $_GET['tagValues'];
    $initialTagsJson = json_encode($tagValues);
    $cityMatches = array(); // matches for city
    $keywordMatches = array();
    $cityCountDeductible = 0;
	
	// Get search query from the keyword search textarea
	$searchQuery = isset($_GET['query']) ? trim($_GET['query']) : '';
	//$searchWords = $searchQuery ? array_unique(preg_split('/\s+/', strtolower($searchQuery))) : [];   //search words separated by whitespace
	$searchWords = array_filter(array_map('trim', explode(',', strtolower($searchQuery))));             //search words separated by comma(,)
	$keywordMatches = array();
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
        .styled-table td {
            white-space: nowrap;
        }
        .hover-expand {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 10vw;
            z-index: 1;
        }

        .hover-expand:hover {
            overflow: visible;
            max-width: none;
            background: #f9f9f9;
            position: absolute;
            z-index: 100;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            .pagination {
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 20px 0;
            }
            
            .pagination div {
                display: flex;
                align-items: center;
            }
            
            .pagination a {
                text-decoration: none;
                padding: 8px 12px;
                margin: 0 5px;
                border: 1px solid #334155;
                color: #334155;
                border-radius: 4px;
                transition: background-color 0.3s, color 0.3s;
            }
            
            .pagination a:hover {
                background-color: #334155;
                color: white;
            }
            
            .pagination input[type="number"] {
                width: 50px;
                padding: 10px;
                margin-left: 10px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            
            .pagination button {
                padding: 10px 10px;
                margin-left: 5px;
                border: none;
                border-radius: 4px;
                background-color: #334155;
                color: white;
                cursor: pointer;
                transition: background-color 0.3s;
            }
            
            .pagination button:hover {
                background-color: #334155;
            }
            
            tr:nth-child(odd) {
                background-color: #f9f9f9;
            }
			
			.tag-container {
            border: 1px solid #ccc;
            padding: 5px;
            display: flex;
            flex-wrap: wrap;
            min-height: 40px; /* Ensure some height even when empty */
          }
        
              .tag {
                background-color: #eee;
                border: 1px solid #ccc;
                padding: 3px 5px;
                margin: 2px;
                border-radius: 3px;
                display: flex;
                align-items: center; /* Vertically center the text and the 'x' */
              }
            
              .tag span {
                margin-right: 3px;
              }
            
              .tag .remove-tag {
                cursor: pointer;
                color: #888;
                font-weight: bold;
                margin-left: 3px;
              }
        </style>
		
		<div class="tag-container" id="tagContainer" style="margin-left: 20px"></div>
		<div>
			<select id="countriesTagDropdown" style="width: 100px; margin-left: 20px">
				<option value="" disabled selected>Country Selection</option>
				<?php foreach ($allCountries as $country): ?>
					<option value="<?= htmlspecialchars($country) ?>"><?= htmlspecialchars($country) ?></option>
				<?php endforeach; ?>
			</select>

			<select id="citiesTagDropdown" style="width: 100px">
				<option value="" disabled selected>City Selection</option>
				<?php foreach ($allCities as $city): ?>
					<option value="<?= htmlspecialchars($city) ?>"><?= htmlspecialchars($city) ?></option>
				<?php endforeach; ?>
			</select>
			<br>
			<label for="keywords" style="margin-left: 20px">Product Keyword(s):</label>
			<input type="text" id="query" style="width: 80%; height: 30px" value="<?= htmlspecialchars($searchQuery) ?>"></input>
		</div>
        <table class="styled-table" style="text-align: left;">
            <tr>
                <?php
                $current_query_string = $_SERVER['QUERY_STRING'];
                parse_str($current_query_string, $query_params);
                $current_order_by = $_GET['order_by'] ?? 'vqcf.cf_1162';
                $current_order_dir = $_GET['order_dir'] ?? 'asc'; 
                ?>
                <th><h2><a style="margin: 0 15px;" href="quote.php?opt=ops-group"><i class="fas fa-arrow-left"></i></a></h2></th>
                <th></th>
                <th>Travel Date
                    <a href="<?php echo generate_sorting_url('vqcf.cf_1162', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqcf.cf_1162', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th colspan="2">Payment Due
                    <a href="<?php echo generate_sorting_url('vqcf.cf_1182', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vqcf.cf_1182', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Type</th>
                <th>Quote Number
                    <a href="<?php echo generate_sorting_url('vq.quote_no', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.quote_no', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Pax
                    <a href="<?php echo generate_sorting_url('vq.adults', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.adults', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Subject
                    <a href="<?php echo generate_sorting_url('vq.subject', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.subject', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Organization
                    <a href="<?php echo generate_sorting_url('accountname', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('accountname', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Contact Name
                    <a href="<?php echo generate_sorting_url('contactname', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('contactname', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th>Cities</th>
                <th>Country</th>
                <th>Quote Stage</th>
                <th>Region <button id="openRegionModal">+</button></th>
                <th>OPS</th>
                <th>Created Date
                    <a href="<?php echo generate_sorting_url('vq.created_at', $current_order_dir, $query_params); ?>">
                        <i class="<?php echo get_sort_icon('vq.created_at', $current_order_by, $current_order_dir); ?>"></i>
                    </a>
                </th>
                <th></th>
            </tr>
            <tr>
                <form method="GET" action="">
					<input type="hidden" id="tagValues" name="tagValues" value="<?= htmlspecialchars($_GET['tagValues'] ?? '') ?>">
					<input type="hidden" name="query" id="query_hidden">
                    <input type="hidden" name="opt" value="search">
                    <td style="text-align: center;"><button type="submit">Search</button></td>
                    <td></td>
                    <td><input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"></td>
                    <td colspan="2"><input type="text" id="payment_due_range" name="payment_due_range" value="<?php echo isset($_GET['payment_due_range']) ? htmlspecialchars($_GET['payment_due_range']) : ''; ?>"></td>
                    <td>
                        <select name="quote_type" style="margin: 0; width: 50px;">
                            <option value="">All</option>
                            <option value="group" <?php echo (isset($quote_type) && $quote_type == 'group') ? 'selected' : ''; ?>>Group</option>
                            <option value="fit-dashboard" <?php echo (isset($quote_type) && $quote_type == 'fit-dashboard') ? 'selected' : ''; ?>>FIT</option>
                        </select>
                    </td>
                    <td><input type="text" name="quote_no" value="<?php echo isset($_GET['quote_no']) ? htmlspecialchars($_GET['quote_no']) : ''; ?>" style="width: 125px;"></td>
                    <td style="width: 5%;"><i class="fa-solid fa-key tooltip-key-partner"></i> <input type="checkbox" name="key_quotes" value="1" <?php echo isset($_GET['key_quotes']) && $_GET['key_quotes'] == '1' ? 'checked' : ''; ?>></td>
                    <td><input type="text" name="subject" value="<?php echo isset($_GET['subject']) ? htmlspecialchars($_GET['subject']) : ''; ?>"></td>
                    <td><input type="text" name="organization" value="<?php echo isset($_GET['organization']) ? htmlspecialchars($_GET['organization']) : ''; ?>"></td>
                    <td><input type="text" name="contact" value="<?php echo isset($_GET['contact']) ? htmlspecialchars($_GET['contact']) : ''; ?>"></td>
                    <td><input type="text" name="city" value="<?php echo isset($_GET['city']) ? htmlspecialchars($_GET['city']) : ''; ?>"></td>
                    <td>
                        <select name="country">
                            <option value=""></option>
                            <option value="Australia" <?php echo (isset($_GET['country']) && $_GET['country'] == 'Australia') ? 'selected' : ''; ?>>Australia</option>
                            <option value="New Zealand" <?php echo (isset($_GET['country']) && $_GET['country'] == 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                        </select>
                    </td>
                    <?php 
                    if($quote_type == 'fit') {
                        $quoteStages = fetchQuoteStages($conn); 
                    }
                    else {
                        $quoteStages = fetchGroupQuoteStages($conn); 
                    }
                    ?>
                    <td>
                        <div style="width: 100%;">
                            <input type="text" id="quote_stage_input" name="quote_stage" value="<?php echo isset($_GET['quote_stage']) ? htmlspecialchars($_GET['quote_stage']) : ''; ?>" readonly style="width: 100%;">
                            <div id="checkboxes" style="display: none; border: 1px solid #ccc; padding: 10px; position: absolute; background: white; z-index: 1000;">
                                <?php foreach ($quoteStages as $stage): ?>
                                    <label>
                                        <input type="checkbox" value="<?php echo htmlspecialchars($stage); ?>" 
                                            <?php 
                                            if(isset($_GET['quote_stage']) && $_GET['quote_stage'] != '') {
                                                $checked_stage = explode(',', $_GET['quote_stage']);
                                                echo in_array($stage, $checked_stage) ? 'checked' : '';
                                            }
                                            ?>
                                        >
                                        <?php echo htmlspecialchars($stage); ?>
                                    </label><br>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </td>
                    <?php if ($title != 'qa') { ?>
                    <script>
                        const input = document.getElementById('quote_stage_input');
                        const checkboxes = document.getElementById('checkboxes');
						
						const queryInput = document.getElementById('query'); // Get the query input element
						const queryHiddenInput = document.getElementById('query_hidden'); // Get the hidden input element

						// Initially set the hidden input value on page load
						queryHiddenInput.value = queryInput.value;

						// Update query_hidden whenever the value in query input changes
						queryInput.addEventListener('input', function() {
							queryHiddenInput.value = queryInput.value; // Update hidden input with current query input value
						});

                        // Toggle the display of the checkboxes on input click
                        input.addEventListener('click', function() {
                            checkboxes.style.display = checkboxes.style.display === 'block' ? 'none' : 'block';
                        });

                        // Update the input field with selected checkbox values
                        document.querySelectorAll('#checkboxes input[type="checkbox"]').forEach(checkbox => {
                            checkbox.addEventListener('change', function() {
                                const selectedValues = Array.from(document.querySelectorAll('#checkboxes input[type="checkbox"]:checked')).map(cb => cb.value);
                                input.value = selectedValues.join(','); // Join selected values with a comma
                            });
                        });

                        // Close the checkbox dropdown when clicking outside
                        document.addEventListener('click', function(event) {
                            if (!input.contains(event.target) && !checkboxes.contains(event.target)) {
                                checkboxes.style.display = 'none';
                            }
                        });
                    </script>
                    <?php } ?>
                    <td>
                        <select name="assigned_to_region">
                            <option value=""></option>
                            <?php
                            // Query to get group names from the vtiger_groups table
                            $sqlr = "SELECT groupname FROM vtiger_groups";
                            $resultr = $conn->query($sqlr);

                            // Populate the select dropdown with group names
                            if ($resultr->num_rows > 0) {
                                while ($rowr = $resultr->fetch_assoc()) {
                                    $selected = (isset($_GET['assigned_to_region']) && $_GET['assigned_to_region'] == $rowr['groupname']) ? 'selected' : '';
                                    echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                                }
                            }
                            ?>
                        </select>
                    </td>
                    <td><input type="text" name="ops_by_person" <?= $global_file_access != 'all' ? 'disabled' : '' ?> value="<?php echo isset($_GET['ops_by_person']) ? htmlspecialchars($_GET['ops_by_person']) : ''; ?>"></td>
                    <td><input type="text" id="create_date_range" name="create_date_range" value="<?php echo isset($_GET['create_date_range']) ? htmlspecialchars($_GET['create_date_range']) : ''; ?>"></td>
                    <td><i id="info-icon" title="Status" class="fa-solid fa-question-circle" style="cursor: pointer;"></i></td>
                </form>
                <div id="tooltip" class="tooltip-content">
                    <p><b>Status Descriptions:</b></p>
                    <ul>
                        <li><i class="fa-solid fa-signs-post"></i> Attraction</li>
                        <li><i class="fa-solid fa-hotel"></i> Hotel</li>
                        <li><i class="fa-solid fa-utensils"></i> Restaurant</li>
                        <li><i class="fa-solid fa-bus-simple"></i> Transfers</li>
                        <li><i class="fa-solid fa-person-hiking"></i> Tour</li>
                        <li><i class="fa-solid fa-passport"></i> SIC</li>
                        <li><i class="fa-solid fa-user-tie"></i> Guide</li>
                        <li><p style="color: red;">Red - no information is entered</p></li>
                        <li><p style="color: orange;">Yellow - some information is entered</p></li>
                        <li><p style="color: green;">Green - confirmation is received</p></li>
                        <li><p style="color: grey;">Grey - No products in this category</p></li>
                    </ul>
                </div>
                <style>
                    /* Tooltip container */
                    .tooltip-content {
                        display: none;
                        position: absolute;
                        background-color: #f9f9f9;
                        border: 1px solid #ddd;
                        padding: 10px;
                        width: 200px;
                        z-index: 10;
                        right: 30px;
                        top: 40px;
                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                    }

                    .tooltip-content ul {
                        list-style-type: none;
                        padding: 0;
                    }

                    .tooltip-content ul li {
                        font-size: 14px;
                        margin: 5px 0;
                    }

                    .tooltip-key-partner {
                        position: relative;
                        display: inline-block;
                    }
                    .tooltip-key-partner:hover::after {
                        content: "Key Partners OR Number of Pax > 50";
                        position: absolute;
                        bottom: 125%;
                        left: 50%;
                        transform: translateX(-50%);
                        background-color: black;
                        color: white;
                        padding: 5px;
                        border-radius: 5px;
                        white-space: nowrap;
                        font-size: 24px;
                        opacity: 0.8;
                        text-transform: none !important;
                    }
                </style>

                <!-- Tooltip JavaScript -->
                <script>
                    // Get the tooltip and the icon element
                    var tooltip = document.getElementById("tooltip");
                    var infoIcon = document.getElementById("info-icon");

                    // Show the tooltip when the question mark icon is clicked
                    infoIcon.onclick = function() {
                        if (tooltip.style.display === "block") {
                            tooltip.style.display = "none";
                        } else {
                            tooltip.style.display = "block";
                        }
                    };

                    // Hide the tooltip when clicking anywhere outside
                    window.onclick = function(event) {
                        if (event.target !== infoIcon && tooltip.style.display === "block") {
                            tooltip.style.display = "none";
                        }
                    };
					
					const tagContainer = document.getElementById('tagContainer');
					const citiesTagDropdown = document.getElementById('citiesTagDropdown');
					const countriesTagDropdown = document.getElementById('countriesTagDropdown');

					function createTag(tagName) {
						const tag = document.createElement('div');
						tag.classList.add('tag');
						tag.innerHTML = `<span>${tagName}</span><span class="remove-tag" onclick="removeTag(this)">&#10060</span>`;

						tagContainer.appendChild(tag);

						tag.addEventListener('click', updateTagInputValue); // Attach listener to the TAG ELEMENT!

						updateTagInputValue(); // Call updateTagInputValue after creating the tag
					}
					function removeTag(removeButton) {
						const tag = removeButton.parentNode;
						tagContainer.removeChild(tag);

					// No event listener needed here. The click is already handled by the onclick in the HTML

						updateTagInputValue(); // Call updateTagInputValue after removing the tag
					}
				  
					countriesTagDropdown.addEventListener('change', function() {
						const selectedCountry = this.value;
						citiesTagDropdown.innerHTML = '<option value="" disabled selected>City Selection</option>'; // Clear previous options

						if (selectedCountry) {
							// Fetch cities for the selected country (using the data from PHP)
							const cities = <?php echo json_encode($citiesByCountry); ?>; // Pass PHP array to Javascript
							if (cities[selectedCountry]) {
							  cities[selectedCountry].forEach(city => {
								const option = document.createElement('option');
								option.value = city;
								option.text = city;
								citiesTagDropdown.appendChild(option);
							  });
							}
						}
					});

					citiesTagDropdown.addEventListener('change', function() {
						const selectedTag = this.value;
						if (selectedTag) {
							createTag(selectedTag);
							this.value = "";
						}
						updateTagInputValue();
					});

					function getAllTagValues() {
					const tagContainer = document.getElementById('tagContainer');
					const tags = tagContainer.querySelectorAll('.tag span'); // Select all <span> elements within tags

					const tagValues = [];
					tags.forEach(tag => {
						const tagText = tag.textContent.trim(); // Get text content and remove whitespace
						if (tagText !== "❌" ) { // Filter out the "×" elements
							tagValues.push(tagText);
							}
						});
						return tagValues;
					}
				  // Example: Add initial tags (optional)
				  //const initialTags = ["initialTag1", "initialTag2"];
				  //initialTags.forEach(tag => createTag(tag));
				  
					function updateTagInputValue() {
						const tagValues = getAllTagValues();
						document.getElementById('tagValues').value = tagValues;
					//document.getElementById('tagValues').value = JSON.stringify(tagValues); // Store as JSON
					}
					document.addEventListener('DOMContentLoaded', function() {
					//const initialTagValuesJson = document.getElementById('tagValues').value;
					//const initialTagValues = initialTagValuesJson ? JSON.parse(initialTagValuesJson) : [];
					const initialTagValues = document.getElementById('tagValues').value;
					console.log(initialTagValues);
					let initialTagValuesArray = [];
					if(initialTagValues!=="")
					{
						initialTagValuesArray = initialTagValues.split(",") ;
					}
					//initialTagValuesArray = initialTagValues.split(",") ;
					if(initialTagValuesArray[0]!=="")
					{
						console.log(initialTagValuesArray.length);
						initialTagValuesArray.forEach(tagValue => createTag(tagValue));
					}
					
					});
                </script>
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
                <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
                <script>
                    flatpickr("#date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
                    });

                    flatpickr("#payment_due_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['payment_due_range']) ? htmlspecialchars($_GET['payment_due_range']) : ''; ?>"
                    });

                    flatpickr("#create_date_range", {
                        mode: "range",
                        dateFormat: "Y-m-d",
                        defaultDate: "<?php echo isset($_GET['create_date_range']) ? htmlspecialchars($_GET['create_date_range']) : ''; ?>"
                    });
                </script>
            </tr>
    
            <?php
            $sql = "SELECT vq.*, va.organization_name AS accountname, va.preferred,
                            vcd.name AS contactname, 
                            vqcf.cf_1162, vqcf.cf_1182,
                            vqinfo.assigned_to_region, vqinfo.assigned_to_ops
                    FROM (SELECT *
                            FROM vtiger_quotes
                            WHERE quoteid = (
                                SELECT MIN(quoteid) AS quoteid
                                FROM vtiger_quotes AS sub
                                WHERE sub.quote_no = vtiger_quotes.quote_no)
                            ORDER BY quote_no DESC) vq
                    LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON vq.accountid = va.accountid
                    LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid 
                    LEFT JOIN tdu_contacts vcd ON vq.contactid=vcd.auto_id AND va.organizationid = vcd.organizationid
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype='group'
                    WHERE deleted = 0";
            if($quote_type == 'fit-dashboard') {
                $sql .= " AND vq.quote_no NOT LIKE '%G'";
            }
            else if ($quote_type == 'group') {
                $sql .= " AND vq.quote_no LIKE '%G'";
            }
            
            // if($title == 'fit') {
            //     $sql .= " AND (vqinfo.assigned_to_ops = '$username_ajax' OR vq.quote_no NOT LIKE '%G')";
            // } else if ($title == 'group') {
            //     $sql .= " AND (vqinfo.assigned_to_ops = '$username_ajax' OR vq.quote_no LIKE '%G')";
            // } 

            if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
                $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
                $start_date = $date_range[0];
                $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
                $sql .= " AND DATE(vqcf.cf_1162) BETWEEN '$start_date' AND '$end_date'";
            }
            if (isset($_GET['payment_due_range']) && !empty($_GET['payment_due_range'])) {
                $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['payment_due_range']));
                $start_date = $date_range[0];
                $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
                $sql .= " AND DATE(vqcf.cf_1182) BETWEEN '$start_date' AND '$end_date'";
            }
            if (isset($_GET['quote_no']) && !empty($_GET['quote_no'])) {
                $quote_no = mysqli_real_escape_string($conn, $_GET['quote_no']);
                $sql .= " AND vq.quote_no LIKE '%$quote_no%'";
            }
            if (isset($_GET['key_quotes']) && $_GET['key_quotes'] == '1') {
                $sql .= " AND (vq.adults + vq.children >= 50 OR va.preferred = 1)";
            }
            if (isset($_GET['subject']) && !empty($_GET['subject'])) {
                $subject = mysqli_real_escape_string($conn, $_GET['subject']);
                $sql .= " AND vq.subject LIKE '%$subject%'";
            }
            if (isset($_GET['organization']) && !empty($_GET['organization'])) {
                $organization = mysqli_real_escape_string($conn, $_GET['organization']);
                $sql .= " AND va.organization_name LIKE '%$organization%'";
            }
            if (isset($_GET['contact']) && !empty($_GET['contact'])) {
                $contact = mysqli_real_escape_string($conn, $_GET['contact']);
                $sql .= " AND vcd.name LIKE '%$contact%'";
            }
            if (isset($_GET['country']) && !empty($_GET['country'])) {
                $country = mysqli_real_escape_string($conn, $_GET['country']);
                $sql .= " AND vq.country = '$country'";
            }
            if (isset($_GET['quote_stage']) && !empty($_GET['quote_stage'])) {
                $quote_stage = mysqli_real_escape_string($conn, $_GET['quote_stage']);
                $stages_array = explode(',', $quote_stage);
                $stages_array = array_map('trim', $stages_array);
                $stages_array = array_map(function($stage) use ($conn) {
                    return "'" . mysqli_real_escape_string($conn, $stage) . "'";
                }, $stages_array);
                $stages_list = implode(',', $stages_array);
                $sql .= " AND vq.quotestage IN ($stages_list)";
            }
            if (isset($_GET['assigned_to_region']) && !empty($_GET['assigned_to_region'])) {
                $assigned_to_region = mysqli_real_escape_string($conn, $_GET['assigned_to_region']);
                $sql .= " AND vqinfo.assigned_to_region = '$assigned_to_region'";
            }
            if (isset($_GET['ops_by_person']) && !empty($_GET['ops_by_person'])) {
                $ops_by_person = mysqli_real_escape_string($conn, $_GET['ops_by_person']);
                if($ops_by_person == 'Unassigned') {
                    $sql .= " AND (vqinfo.assigned_to_ops IS NULL OR vqinfo.assigned_to_ops = '')";
                } else {
                    $sql .= " AND vqinfo.assigned_to_ops LIKE '%$ops_by_person%'";
                }
            }
            if ($global_file_access != 'all') {
                if($global_file_access == 'assigned_created') {
                    $sql .= " AND (vqinfo.assigned_to_ops = '$username_ajax' OR vq.created_by = '$username')";
                } else if($global_file_access == 'assigned_only') {
                    $sql .= " AND vqinfo.assigned_to_ops = '$username_ajax'";
                } else {
                    $sql .= " AND vq.created_by = '$username'";
                }
            }
            if (isset($_GET['create_date_range']) && !empty($_GET['create_date_range'])) {
                $create_date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['create_date_range']));
                $create_start_date = $create_date_range[0];
                $create_end_date = isset($create_date_range[1]) ? $create_date_range[1] : $create_date_range[0];
                $sql .= " AND DATE(vq.created_at) BETWEEN '$create_start_date' AND '$create_end_date'";
            }
            if(isset($current_order_by) || isset($current_order_dir)) {
                if ($title == 'group' || $title == 'fit') {
                    $sql .= " ORDER BY (vq.quotestage = 'Payment Received - Release Vouchers') DESC, (vqcf.cf_1162 = '0000-00-00') ASC, $current_order_by $current_order_dir, vqcf.cf_1162 ASC, (vqcf.cf_1182 = '0000-00-00') ASC, vqcf.cf_1182 ASC";
                } else {
                    $sql .= " ORDER BY (vqcf.cf_1162 = '0000-00-00') ASC, $current_order_by $current_order_dir, vqcf.cf_1162 ASC, (vqcf.cf_1182 = '0000-00-00') ASC, vqcf.cf_1182 ASC";
                }
            }
			
			
			//allRows will house the filtered rows
			$allRows = [];
			

			
			
			if (!empty($searchWords) || (!empty($tagValues) && !(is_array($tagValues) && count($tagValues) === 1 &&  isset($tagValues[0]) && trim($tagValues[0]) === ''))) 
			{		
				
				$keywordResult = $conn->query($sql);
				
						
				//algorithm to filter for rows with keywords
				while ($row = mysqli_fetch_assoc($keywordResult)) 
				{
					$relevance = 0;
					$content = "";
					$content2 = "";
					$row['Matches'] = array();
					$base_sql2 = 
					"
                    SELECT DISTINCT
					ROW_NUMBER() OVER (ORDER BY sq.sequence_no) AS row_num,
						sq.quoteid,
						sq.sequence_no,
						sq.cf_928,
						sq.productName,
						sq.vendorName,
						sq.Comment,
						sq.Description
					FROM (
						SELECT
							vi.id AS quoteid, /* Alias vi.id as quoteid for clarity in subquery */
							vi.sequence_no,
							vi.cf_928,
							COALESCE(vpc.productname, tdp.productname) AS productName,
							COALESCE(vvc.vendorname, tdv.vendorname) AS vendorName,
							vi.comment AS Comment,
							tdp.description AS Description,
							vq.quoteid AS actual_quoteid /* Keep actual quoteid for filtering later */
						FROM vtiger_inventoryproductrel vi
						LEFT JOIN tdu_products tdp
							ON vi.productid = tdp.productid
						LEFT JOIN vtiger_products_custom vpc
							ON vi.productid = vpc.productid
						LEFT JOIN vtiger_vendor_custom vvc
							ON vi.vendorid = vvc.vendorid
						LEFT JOIN tdu_vendors tdv
							ON tdp.vendorid = tdv.vendorid
						LEFT JOIN vtiger_quotes vq
							ON vi.id = vq.quoteid
						WHERE vq.quote_no = '$row[quote_no]'
					) AS sq
					WHERE sq.quoteid = (SELECT MIN(quoteid) FROM (SELECT vq.quoteid AS quoteid FROM vtiger_quotes vq WHERE vq.quote_no = '$row[quote_no]') AS min_quote_subquery )
					GROUP BY sq.sequence_no
					ORDER BY sq.sequence_no ASC
                    ";
					
					$cities = getCitiesString($row['quoteid'], $conn);
                    $cities_0 = getCities($row['quoteid'], $conn);
                    //$pax = $row['mode'] == 'standard' ? ($row['adults'] + $row['children']) : $row['pax_min'];
                    $content .= implode(' ', array_map('strtolower', [
                        //$row['cf_1162'],
                        //$pax,
                        //$row['quote_no'],
                        //$row['type'],
                        //$row['quotestage'],
                        //$row['accountname'],
                        //$row['contactname'],
                        //$row['subject'],
                        //$row['assigned_to_region'],
                        $cities
                    ]));
							//algorithm to filter for rows with tags (cities)
				    if (!empty($tagValues)) {
						if ($tagValues[0] != "") {
							$tagCount = count($tagValues);
							$cityCount = count($cities_0);
							$matchCount = 0;
							$tempIncrements = []; // Track how much each city was incremented
					
							foreach ($tagValues as $tag) {
								$tagLower = strtolower($tag);
								foreach ($cities_0 as $city) {
									$cityLower = strtolower($city);
									if ($tagLower === $cityLower) {
										$matchCount++;
										$relevance++;
										// Increment cityMatches and track the change
										$cityMatches[$city] = ($cityMatches[$city] ?? 0) + 1;
										$tempIncrements[$city] = ($tempIncrements[$city] ?? 0) + 1;
										break;
									}
								}
							}
					
							// Check if conditions are violated
							if ($tagCount > $matchCount || $tagCount != $cityCount) {
								$relevance -= 10000;
								// Undo the increments for each city
								foreach ($tempIncrements as $city => $count) {
									$cityMatches[$city] -= $count;
									// Remove the city if its count drops to 0 or below
									if ($cityMatches[$city] <= 0) {
										unset($cityMatches[$city]);
									}
								}
							}
						}
					}
					
					if (!empty($searchWords)) 
					{
								
						// Remove LIMIT for full results
						$sql2 = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql2);
						$result2 = mysqli_query($conn, $sql2);
						//$allRows = [];
				
						// Calculate relevance
						while ($row2 = mysqli_fetch_assoc($result2)) 
						{
							$content2 = implode(' ', array_map('strtolower', [
								$row2['productName'],
								$row2['vendorName']
							]));
									
							$safe = false;
							foreach ($searchWords as $word) 
							{
								$relevance += substr_count($content2, $word);
								if(substr_count($content2, $word)>0)
								{
									if(array_key_exists($word, $row['Matches'])){$row['Matches'][$word]++;}
									else
									{
										$row['Matches'][$word] = 1;
										if($relevance>0){
										if(array_key_exists($word, $keywordMatches)){$keywordMatches[$word]++;}
										else{$keywordMatches[$word] = 1;}}     
									}
									$safe = true;
								} 
							}
						}
								
						//trim the rows with no matches or mismatch for keywords
						if(empty($row['Matches']) || !empty(array_diff($searchWords, array_keys($row['Matches']))))
						{
							if($relevance>0)
							{//var_dump($row['Matches']);
								$relevance-=10000;//foreach ($cityMatches as $cityMatch => &$cityCount) {$cityCount--;}
							}
						}
					}
						
					if ($relevance > 0) 
					{
						$row['relevance'] = $relevance;
						$allRows[] = $row;
					}
				}
			}else
			{
				$allRows = mysqli_fetch_all($conn->query($sql), MYSQLI_ASSOC);
			}
            //var_dump($sql);
            // Pagination setup
            $results_per_page = 30; // Adjust as needed
            $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
            $offset = ($current_page - 1) * $results_per_page;
            //var_dump($sql);
            // Total count for pagination
            $total_result_query = mysqli_query($conn, $sql);
            $total_quotes = mysqli_num_rows($total_result_query);
            $total_pages = ceil($total_quotes / $results_per_page);
            
            $sql .= " LIMIT $offset, $results_per_page";
            $result = mysqli_query($conn, $sql);
            
			//Manual Pagination
			$total_quotes = count($allRows);
            $total_pages = ceil($total_quotes / $results_per_page);
            $offset = ($current_page - 1) * $results_per_page;
            $paginatedRows = array_slice($allRows, $offset, $results_per_page);
			
            if ($result && mysqli_num_rows($result) > 0) {
                ?>
                <form method="GET" action="">
                    <input type="hidden" name="opt" value="multi-edit-grp">
                    <?php
                    foreach ($paginatedRows as $row){
                        $quoteid = $row['quoteid'];
                        $sql_city = "SELECT DISTINCT vpcf.city AS cf_1248 FROM vtiger_inventoryproductrel vi
                                    LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid
                                    WHERE vi.id='$quoteid';";
                        $result_city = mysqli_query($conn, $sql_city);
                        $cities = array();
                        if ($result_city && mysqli_num_rows($result_city) > 0) {
                            while($row_city = mysqli_fetch_assoc($result_city)) {
                                if(isset($row_city['cf_1248']) && $row_city['cf_1248'] != '') {
                                    $cities[] = $row_city['cf_1248'];
                                }
                            }
                        }
                        if (isset($_GET['city']) && !empty($_GET['city'])) {
                            $cityQuery = strtolower($_GET['city']);
                            $found = false;
                            foreach ($cities as $city) {
                                if (strpos(strtolower($city), $cityQuery) !== false) {
                                    $found = true;
                                    break;
                                }
                            }
                            if (!$found) {
                                continue;
                            }
                        }

                        ?>
                        <tr
                            <?php 
                            if (($title == 'group' || $title == 'fit') && $row['quotestage'] == 'Payment Received - Release Vouchers') {
                                echo 'style="background-color: lightgreen;"';
                            }
                            else if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00' && 
                                in_array($row['quotestage'], ['Accepted', 'Requote After Confirmation', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers', 'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'])) {
                                $date = new DateTime($row['cf_1182']);
                                $today = new DateTime();
                                $interval = $today->diff($date)->days;
                                if ($date < $today || $interval <= 14) {
                                    echo 'style="background-color: #f8d7da;"';
                                }
                            }
                            ?>
                            >
                            <td style="width: 100px;">
                                <?php
                                if($title != 'sales' && !(isset($_GET['payment_deadline']) && !empty($_GET['payment_deadline']))) {
                                    ?>
                                    <button type="button" onclick="location.href='?opt=duplicate-quote&quoteid=<?php echo urlencode($quoteid); ?>&quoteNumber=<?php echo urlencode($row['quote_no']); ?>'"><i class="fa-solid fa-copy" title="Duplicate"></i></button>
                                    <button type="button" class="delete-quote-btn" data-quoteid="<?php echo htmlspecialchars($row['quote_no']); ?>" style="background-color: red;"><i class="fa-solid fa-trash-can" title="Delete"></i></button>
                                    <?php
                                }
                                ?>
                            </td>
                            <td>
                                <input type="checkbox" name="selected_quotes[]" value="<?php echo htmlspecialchars($quoteid); ?>" class="quote-checkbox">
                            </td>
                            <td>
                                <?php 
                                if (isset($row['cf_1162']) && $row['cf_1162'] != '0000-00-00') {
                                    $date = new DateTime($row['cf_1162']);
                                    echo $date->format('d-M-Y');
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if (isset($row['cf_1182']) && $row['cf_1182'] != '0000-00-00') {
                                    $date = new DateTime($row['cf_1182']);
                                    echo $date->format('d-M-Y');
                                }
                                ?>
                            </td>
                            <td>
                                <?php if(in_array($row['quotestage'], ['Created', 'Accepted', 'Requote After Confirmation', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers', 'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'])) { ?>
                                    <div class="payment-icon-wrapper" style="position: relative;">
                                        <i class="fa-solid fa-circle-dollar-to-slot grey payment-icon" id="payment_icon_<?php echo $quoteid; ?>"></i>
                                        <div class="payment-popup" id="payment_popup_<?php echo $quoteid; ?>" style="display:none; position:absolute; top:24px; left:50%; transform:translateX(-50%); background:white; border:1px solid #ccc; padding:10px; z-index:999; width:220px; box-shadow:0 2px 6px rgba(0,0,0,0.2); font-size:13px;">
                                            <p>Loading...</p>
                                        </div>
                                    </div>
                                    <style>
                                        .payment-icon {
                                            cursor: pointer;
                                        }
                                        .payment-icon.grey {
                                            color: lightgrey;
                                        }
                                        .payment-icon.green {
                                            color: green;
                                        }
                                        .payment-icon.orange {
                                            color: orange;
                                        }
                                        .payment-icon.red {
                                            color: red;
                                        }
                                    </style>
                                    <script>
                                        document.addEventListener("DOMContentLoaded", function () {
                                            fetchPaymentStatus(<?php echo $quoteid; ?>);

                                            const icon = document.getElementById("payment_icon_<?php echo $quoteid; ?>");
                                            const popup = document.getElementById("payment_popup_<?php echo $quoteid; ?>");

                                            icon.addEventListener("click", function (e) {
                                                e.stopPropagation();
                                                if (popup.style.display === "none") {
                                                    fetch('quote_payment_status_ajax.php?quoteid=<?php echo $quoteid; ?>&action=popup')
                                                        .then(response => response.text())
                                                        .then(data => {
                                                            popup.innerHTML = data;
                                                            popup.style.display = "block";
                                                        });
                                                } else {
                                                    popup.style.display = "none";
                                                }
                                            });

                                            document.addEventListener("click", function () {
                                                popup.style.display = "none";
                                            });
                                        });

                                        function fetchPaymentStatus(quoteId) {
                                            fetch('quote_payment_status_ajax.php?quoteid=' + quoteId + '&action=status')
                                                .then(response => response.json())
                                                .then(data => {
                                                    const icon = document.getElementById('payment_icon_' + quoteId);
                                                    if (data && data.colorClass) {
                                                        icon.classList.remove('grey', 'green', 'orange', 'red');
                                                        icon.classList.add(data.colorClass);

                                                        if (data.colorClass === 'green') {
                                                            const tr = icon.closest('tr');
                                                            const bgColor = window.getComputedStyle(tr).backgroundColor;

                                                            // Compare to RGB equivalent of #f8d7da
                                                            if (bgColor === 'rgb(248, 215, 218)') {
                                                                tr.style.backgroundColor = '';
                                                            }
                                                        }
                                                    }
                                                });
                                        }
                                    </script>
                                <?php } ?>
                            </td>
                            <td><?php echo (substr($row['quote_no'], -1) === 'G') ? 'Group' : 'FIT'; ?><?php echo $row['mode'] != 'standard' ? ' (R)' : ''?></td>
                            <td>
                                <a href="?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>"><?php echo htmlspecialchars($row['quote_no']); ?></a>
                                <?php
                                if (isset($row['duplicate']) &&  $row['duplicate'] != '') {
                                    echo '<i class="fas fa-copy" title="'.$row['duplicate'].'"></i>';
                                }
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($row['adults'] + $row['children']); ?></td>
                            <td class="hover-expand">
                                <a href="?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>"><?php echo htmlspecialchars($row['subject']); ?></a>
                            </td>
                            <td class="hover-expand">
                                <?php if ($row['preferred'] == 1): ?>
                                    <i class="fa-solid fa-key" title="Key Partner" style="color: blue;"></i>
                                <?php endif; ?>
                                <a href="quote.php?opt=organization-details&id=<?php echo urlencode($row['accountid']); ?>">
                                    <?php echo htmlspecialchars($row['accountname']); ?>
                                </a>
                            </td>
                            <td style="max-width: 5vw; overflow: hidden; text-overflow: ellipsis;"><?php echo htmlspecialchars($row['contactname'] ?? ''); ?></td>
                            <td class="hover-expand">
                                <?php
                                if ($result_city && mysqli_num_rows($result_city) > 0) {
                                    echo implode(', ', $cities);
                                }
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($row['country']); ?></td>
                            <td class="hover-expand"><?php echo htmlspecialchars($row['quotestage']); ?></td>
                            <td><?php echo htmlspecialchars($row['assigned_to_region']); ?></td>
                            <td><?php echo htmlspecialchars($row['assigned_to_ops']); ?></td>
                            <td><?php $date = new DateTime($row['created_at']); echo $date->format('d-M-Y'); ?></td>
                            <td>
                                <div class="status-in-search" id="status_<?php echo $quoteid; ?>" 
                                    style="display: flex; justify-content: space-between; padding-right: 20px;">
                                    <i class="fa-solid fa-signs-post grey"></i>
                                    <i class="fa-solid fa-hotel grey"></i>
                                    <i class="fa-solid fa-utensils grey"></i>
                                    <i class="fa-solid fa-person-hiking grey"></i>
                                    <i class="fa-solid fa-bus-simple grey"></i>
                                    <i class="fa-solid fa-user-tie grey"></i>
                                    <i class="fa-solid fa-passport grey"></i>
                                </div>

                                <style>
                                    .status-in-search i {
                                        font-size: 16px;
                                        margin-right: 8px;
                                        color: lightgrey;
                                    }
                                    .status-in-search i.green {
                                        color: green;
                                    }
                                    .status-in-search i.orange {
                                        color: orange;
                                    }
                                    .status-in-search i.red {
                                        color: red;
                                    }
                                </style>

                                <?php
                                if($row['quotestage'] != 'Created') {
                                    ?>
                                    <script>
                                        document.addEventListener("DOMContentLoaded", function () {
                                            fetchStatus(<?php echo $quoteid; ?>);
                                        });

                                        function fetchStatus(quoteId) {
                                            fetch('quote_search_status_ajax.php?quoteid=' + quoteId)
                                                .then(response => response.json())
                                                .then(data => {
                                                    const statusContainer = document.getElementById('status_' + quoteId);
                                                    if (data) {
                                                        statusContainer.innerHTML = `
                                                            <i class="fa-solid fa-signs-post ${data.attraction}"></i>
                                                            <i class="fa-solid fa-hotel ${data.hotel}"></i>
                                                            <i class="fa-solid fa-utensils ${data.restaurant}"></i>
                                                            <i class="fa-solid fa-person-hiking ${data.tour}"></i>
                                                            <i class="fa-solid fa-bus-simple ${data.transfers}"></i>
                                                            <i class="fa-solid fa-user-tie ${data.guide}"></i>
                                                            <i class="fa-solid fa-passport ${data.sic}"></i>
                                                        `;
                                                    }
                                                })
                                                .catch(error => console.error('Error fetching status:', error));
                                        }
                                    </script>
                                    <?php
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    <tr>
                        <td></td>
                        <td>
                            <input type="checkbox" id="select-all" />All
                        </td>
                        <td colspan="16">
                            <button type="submit">Bulk Edit Details</button>
                        </td>
                    </tr>
                </form>
                <?php
            }
            ?>
        </table>

        <!-- Modal for Adding New Region -->
        <div id="quoteRegionModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5);">
            <div style="background: white; width: 30%; margin: 10% auto; padding: 20px; border-radius: 5px; position: relative;">
                <h3>Add New Region</h3>
                <button id="closeRegionModal" style="position: absolute; top: 10px; right: 10px; background: red; color: white; border: none; padding: 5px;">
                    <i class="fa-solid fa-xmark"></i>
                </button>
                <form id="add-region-form">
                    <input type="text" id="newRegion" name="region" required style="width: 100%; padding: 5px;">
                    <button type="submit" style="margin-top: 10px; cursor: pointer;">Save</button>
                </form>
            </div>
        </div>
        <script>
            document.getElementById('openRegionModal').addEventListener('click', function () {
                document.getElementById('quoteRegionModal').style.display = 'block';
            });

            document.getElementById('closeRegionModal').addEventListener('click', function () {
                document.getElementById('quoteRegionModal').style.display = 'none';
            });

            document.getElementById('add-region-form').addEventListener('submit', function (e) {
                e.preventDefault();

                let formData = new FormData(this);

                fetch('ajax_save_new_region.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    alert('Region added successfully!');
                    location.reload();
                })
                .catch(error => console.error('Error:', error));
            });
        </script>

        <script>
            document.getElementById('select-all').addEventListener('click', function() {
                const checkboxes = document.querySelectorAll('.quote-checkbox');
                checkboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
            });
        </script>
        <div style="margin-top: 10px; margin-left: 5%;">number of results found: <?php echo $total_quotes; ?></div>
        <div class="pagination" style="margin-top: 0;">
            <div>
                <?php if ($current_page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $current_page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                <?php endif; ?>
        
                <?php
                $max_pages = min($total_pages, $current_page + 2);
                for ($page = $current_page; $page <= $max_pages; $page++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page])); ?>" <?php if ($page == $current_page) echo 'style="background-color: #334155; color: white;"'; ?>>
                        <?php echo $page; ?>
                    </a>
                <?php endfor; ?>
        
                <?php if ($current_page < $total_pages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $current_page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                <?php endif; ?>
            </div>
            <form method="GET" action="" style="display:inline;">
                <?php
                foreach ($_GET as $key => $value) {
                    if ($key != 'page') {
                        echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                    }
                }
                ?>
                <input type="number" name="page" min="1" max="<?php echo $total_pages; ?>" value="<?php echo $current_page; ?>" style="width:75px;"> / <?php echo $total_pages; ?>
                <button type="submit">Jump</button>
            </form>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });

        document.addEventListener('DOMContentLoaded', function () {
            const deleteButtons = document.querySelectorAll('.delete-quote-btn');

            deleteButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const quoteId = button.getAttribute('data-quoteid');

                    if (confirm('Are you sure you want to delete this quote?')) {
                        fetch('ajax_delete_quote_by_id.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: `quoteid=${encodeURIComponent(quoteId)}`
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('Quote deleted successfully.');
                                location.reload();
                            } else {
                                alert('Failed to delete quote: ' + (data.error || 'Unknown error'));
                            }
                        })
                        .catch(error => {
                            console.error('Error deleting quote:', error);
                            alert('An error occurred while deleting the quote.');
                        });
                    }
                });
            });
        });
    </script>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'duplicate-quote' && isset($_GET['quoteid']) && isset($_GET['quoteNumber'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['duplicate_quote'])) {
        $quoteid = $_POST['quoteid'];
        $quote_number = $_POST['quoteNumber'];
        $subject = mysqli_real_escape_string($conn, $_POST['subject'] ?? '');
        $quote_stage = mysqli_real_escape_string($conn, $_POST['quote_stage'] ?? '');
        
        $organization_name = mysqli_real_escape_string($conn, $_POST['organization_name'] ?? '');
        $contact_name = mysqli_real_escape_string($conn, $_POST['contact_name'] ?? '');

        $query =   "SELECT 
                        o.organizationid AS accountid,
                        c.auto_id AS contactid
                    FROM tdu_contacts c
                    LEFT JOIN tdu_organisation o ON c.organizationid = o.organizationid
                    WHERE o.organization_name = '$organization_name' AND c.name = '$contact_name'";
        $result = mysqli_query($conn, $query);
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $accountid = $row['accountid'];
            $contactid = $row['contactid'];
        } else {
            $accountid = '';
            $contactid = '';
        }
        
        $assign_region = mysqli_real_escape_string($conn, $_POST['assigned_to_region'] ?? '');
        $priority = mysqli_real_escape_string($conn, $_POST['priority'] ?? '');
        $country = mysqli_real_escape_string($conn, $_POST['country'] ?? '');
    
        // Custom Information
        $date_of_travel = mysqli_real_escape_string($conn, $_POST['date_of_travel'] ?? '');
        $payment_deadline = mysqli_real_escape_string($conn, $_POST['payment_deadline'] ?? '');
        $accepted_date = mysqli_real_escape_string($conn, $_POST['accepted_date'] ?? '');

        $adults = $_POST['no_of_adults'];
        $children = $_POST['no_of_children'];
        $infants = $_POST['no_of_infants'];

        if (substr($quote_number, -1) === 'G') {
            $quotetype = 'group';
            $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%G';";
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if ($row['max_quote_no']) {
                $numeric_part = (int)substr($row['max_quote_no'], 3, -1);
                $new_numeric_part = $numeric_part + 1;
                $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part) . 'G';
            } else {
                $new_quote_no = "TDU00001G";
            }
        } else {
            $quotetype = 'fit';
            $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%' AND quote_no NOT LIKE 'TDU%G';";
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if ($row['max_quote_no']) {
                $numeric_part = (int)substr($row['max_quote_no'], 3);
                $new_numeric_part = $numeric_part + 1;
                $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part);
            } else {
                $new_quote_no = "TDU30001";
            }
        }

        // Fetch the maximum quoteid to determine the new quoteid
        $sql_max_quoteid = "SELECT IFNULL(MAX(quoteid), 0) AS max_quoteid FROM vtiger_quotes";
        $result_max_quoteid = mysqli_query($conn, $sql_max_quoteid);
    
        if ($result_max_quoteid) {
            $row_max = mysqli_fetch_assoc($result_max_quoteid);
            $max_quoteid = $row_max['max_quoteid'];
            $new_quoteid = $max_quoteid + 1;
                
            // Insert the new row into vtiger_quotes
            $sql_duplicate_quote = "
                INSERT INTO vtiger_quotes (quoteid, quote_no, subject, quotestage, contactid, accountid, country, mode, created_by, duplicate, adults, children, infants, 	
                                            nsingle_room, ndouble_room, ntriple_room, nchild_without_bed, groupid, child_ages, auto_email_follow_up, auto_email_follow_up_datetime, deleted)
                SELECT $new_quoteid, '$new_quote_no', '$subject', '$quote_stage', '$contactid', '$accountid', '$country', mode, '$username', '$quote_number', '$adults', '$children', '$infants',
                        nsingle_room, ndouble_room, ntriple_room, nchild_without_bed, groupid, child_ages, auto_email_follow_up, auto_email_follow_up_datetime, 0
                FROM vtiger_quotes
                WHERE quoteid = '$quoteid';
            ";
            if (mysqli_query($conn, $sql_duplicate_quote)) { 
                if($assign_region) {
                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, assigned_to_region, priority) 
                            VALUES ('$new_quoteid', 'group', '$assign_region', '$priority')
                            ON DUPLICATE KEY UPDATE assigned_to_region = '$assign_region', priority = '$priority'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
        
                    $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
                    $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
                    $travel_month = (int) $travel_month;
                    $travel_day = (int) $travel_day;
        
                    $sql = "SELECT * FROM tdu_auto_assign_rules 
                            WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                            AND (category = 'sales' OR category = 'external')
                            AND (
                                ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                                AND
                                ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                            )";
                    $result = mysqli_query($conn, $sql);
        
                    if(mysqli_num_rows($result) == 0) {
                        $sql = "SELECT * FROM tdu_auto_assign_rules 
                                WHERE assign_type = 'region' AND region = '$assign_region'
                                AND (
                                    ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                                    AND
                                    ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                                )";
                        $result = mysqli_query($conn, $sql);
                    }
        
                    if (mysqli_num_rows($result) > 0) {
                        $assignment_map = [
                            "sales" => "assigned_to_sales_agent",
                            "external" => "assigned_to_external_sales_agent"
                        ];
        
                        while ($row = mysqli_fetch_assoc($result)) {
                            $category = $row['category'];
                            if(!isset($assignment_map[$category])) {
                                continue;
                            }
                            $key = $assignment_map[$category];
                            $value = $row['username'];
        
                            $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                                    VALUES ('$new_quoteid', 'group', '$value')
                                    ON DUPLICATE KEY UPDATE $key = '$value'";
                            mysqli_query($conn, $sql) or die(mysqli_error($conn));
                        }
                    }
                }

                $tablesToDuplicate = [
                    'vtiger_inventoryproductrel',
                    'vtiger_display_order'
                ];
                foreach ($tablesToDuplicate as $table) {
                    duplicateTableRows($conn, $table, $quoteid, $new_quoteid, 'id');
                }

                $tablesToDuplicate = [
                    'tdu_self_booked_hotels',
                    'vtiger_coach_info',
                    'vtiger_itinerary',
                    'vtiger_itinerary_new_event',
                    'vtiger_products_saleprice',
                    'vtiger_quotescf',
                    'vtiger_transfer_index'
                ];
                foreach ($tablesToDuplicate as $table) {
                    duplicateTableRows($conn, $table, $quoteid, $new_quoteid);
                }

                $update_sql3 = "UPDATE vtiger_quotescf SET cf_1162 = '$date_of_travel', cf_1182 = '$payment_deadline', cf_1188 = '$accepted_date', cf_1542 = '$priority' WHERE quoteid = '$new_quoteid';";
                mysqli_query($conn, $update_sql3) or die(mysqli_error($mysqli));

                header("Location: ?opt=summary&quoteNumber=".$new_quote_no);
                exit();
            } else {
                echo "Error duplicating quote row: " . mysqli_error($conn);
            }
        }
        
        $conn->close();
        redirectWithoutParam('edit');
    }

    include "header.php";
    ?>
    <div style="margin:15px;">
        <form method="post" style="margin-top: 20px;">
            <h2>Duplicate Quote <?php echo $_GET['quoteNumber']; ?></h2>
            <div class="form-row">
                <label for="subject">*Subject:</label>
                <input type="text" id="subject" name="subject" required>
            </div>
            
            <?php $accountContacts = getAccountContacts2($conn); ?>
            <div class="form-row">
                <label for="organization_name">*Organization Name:</label>
                <!-- <button type="button" id="addOrganizationBtn">+</button> -->
                <button type="button" onclick="window.location.href='quote.php?opt=add-new-organization'">+</button>
                <input type="text" id="organization_name" value="<?php echo $new_organization_name; ?>" name="organization_name" required autocomplete="off">
                <datalist id="organizationList">
                    <?php foreach (array_keys($accountContacts) as $name): ?>
                        <option value="<?php echo $name; ?>"></option>
                    <?php endforeach; ?>
                </datalist>
            </div>
            
            <div class="form-row">
                <label for="contact_name">*Contact Name:</label>
                <select id="contact_name" name="contact_name" required>
                    <option value="">Select a contact</option>
                </select>
            </div>

            <script>
                var accountContacts = <?php echo json_encode($accountContacts); ?>;

                document.getElementById('organization_name').addEventListener('input', function() {
                    var organizationName = this.value;
                    var contactSelect = document.getElementById('contact_name');

                    // Clear the contact dropdown
                    contactSelect.innerHTML = '<option value="">Select a contact</option>';

                    // Populate the contact dropdown based on the selected organization
                    if (accountContacts[organizationName]) {
                        var contactNames = accountContacts[organizationName];
                        contactNames.forEach(function(name) {
                            var option = document.createElement('option');
                            option.value = name;
                            option.textContent = name;
                            contactSelect.appendChild(option);
                        });
                    }
                });
            </script>
            
            <div class="form-row">
                <label for="quote_stage">*Quote Stage:</label>
                <select id="quote_stage" name="quote_stage" required>
                    <option value="Created" selected>Created</option>
                </select>
            </div>
            <div class="form-row">
                <label for="assigned_to_region">*Region:</label>
                <select name="assigned_to_region">
                    <option value=""></option>
                    <?php
                    // Query to get group names from the vtiger_groups table
                    $sqlr = "SELECT groupname FROM vtiger_groups";
                    $resultr = $conn->query($sqlr);

                    // Populate the select dropdown with group names
                    if ($resultr->num_rows > 0) {
                        while ($rowr = $resultr->fetch_assoc()) {
                            $selected = '';
                            echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-row">
                <label for="priority">Priority:</label>
                <select id="priority" name="priority">
                    <option value="" disabled selected>Select priority</option>
                    <option value="not connected">Not connected</option>
                    <option value="low">Low</option>
                    <option value="high">High</option>
                </select>
            </div>
            <div class="form-row">
                <label for="country">*Country:</label>
                <select id="country" name="country" required>
                    <option value="" disabled selected>Select country</option>
                    <option value="Australia">Australia</option>
                    <option value="New Zealand">New Zealand</option>
                </select>
            </div>

            <h2></h2>
            <div class="form-row">
                <label for="date_of_travel">*Date Of Travel:</label>
                <input type="date" id="date_of_travel" name="date_of_travel" required>
            </div>
            <div class="form-row">
                <label for="payment_deadline">Payment-Cancellation Deadline:</label>
                <input type="date" id="payment_deadline" name="payment_deadline">
            </div>
            <div class="form-row">
                <label for="accepted_date">Accepted Date:</label>
                <input type="date" id="accepted_date" name="accepted_date">
            </div>

            <h2></h2>
            <div class="form-row">
                <label for="no_of_adults">No of Adults:</label>
                <input type="number" id="no_of_adults" name="no_of_adults" min="1" value="1" required>
            </div>
            <div class="form-row">
                <label for="no_of_children">No of Children:</label>
                <input type="number" id="no_of_children" name="no_of_children" min="0" value="0" required>
            </div>
            <div class="form-row">
                <label for="no_of_infants">No of Infants:</label>
                <input type="number" id="no_of_infants" name="no_of_infants" min="0" value="0" required>
            </div>

            <input type="hidden" name="quoteid" value="<?php echo htmlspecialchars($_GET['quoteid']); ?>">
            <input type="hidden" name="quoteNumber" value="<?php echo htmlspecialchars($_GET['quoteNumber']); ?>">
            <h4 style="text-align:center;">Please complete the form before continue</h4><br>
            <button type="submit" style="margin:5px;" name="duplicate_quote">Duplicate</button>
            <button type="button" style="margin:5px;" onclick="window.location.href='?opt=search'">Cancel</button>
        </form>
        
        <style>
            .form-row {
                margin-bottom: 10px;
            }
        
            .form-row label {
                margin-right: 10px;
            }
        
            .form-row input, .form-row textarea {
                width: 100%;
            }
            h2 {
                text-align: left;
                border-bottom: 2px solid #333;
                padding-bottom: 10px;
                margin-bottom: 20px;
            }
            form {
                width: 600px;
                margin: 0 auto;
            }
            .form-row {
                display: flex;
                justify-content: space-between;
                margin-bottom: 10px;
            }
            .form-row label {
                width: 45%;
            }
            .form-row input, .form-row select, .form-row textarea {
                width: 45%;
                padding: 5px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }
        </style>
    </div>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'multi-edit-grp' && isset($_GET['selected_quotes']) && !empty($_GET['selected_quotes'])) {
    $selected_quotes = $_GET['selected_quotes'];
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        foreach ($selected_quotes as $quoteid) {
            $table = 'vtiger_quotescf';
            if (isset($_POST['priority']) && $_POST['priority'] != '') {
                $priority = $_POST['priority'];
                $sql_update_priority = "UPDATE vtiger_quotes_info SET priority = '$priority' WHERE quoteid = '$quoteid' AND quotetype = 'group';";
                mysqli_query($conn, $sql_update_priority) or die(mysqli_error($conn));
            }
            if (isset($_POST['assigned_to_ops']) && $_POST['assigned_to_ops'] != '') {
                $assigned_to_ops = $_POST['assigned_to_ops'];
                $sql_update_assigned_to_ops = "UPDATE vtiger_quotes_info SET assigned_to_ops = '$assigned_to_ops' WHERE quoteid = '$quoteid' AND quotetype = 'group';";
                mysqli_query($conn, $sql_update_assigned_to_ops) or die(mysqli_error($conn));
            }
        }

        $conn->close();
        header("Location: quote.php?opt=search");
        exit();
        
    }
    include "header.php";
    ?>
    <form method="post" action="" style="width: 600px; margin: 0 auto;">
        <h2 style="border-bottom: 2px solid #333; margin: 20px 0;">Bulk Edit Group Quotes</h2>

        <div class="form-row">
            <label for="priority">Priority:</label>
            <select id="priority" name="priority">
                <option value="">Select priority</option>
                <option value="not connected">Not connected</option>
                <option value="low">Low</option>
                <option value="high">High</option>
            </select>
        </div>
        <div class="form-row">
            <label for="assigned_to_ops">Assigned To Ops Person:</label>
            <select name="assigned_to_ops">
                <option value=""></option>
                <?php
                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                        WHERE title IN ('group', 'fit', 'admin') 
                        ORDER BY title ASC;";

                $resultr = $conn->query($sqlr);
                $current_title = '';

                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        if ($rowr['title'] !== $current_title) {
                            $current_title = $rowr['title'];
                            echo "<option value='' disabled>--- " . strtoupper($current_title) . " ---</option>";
                        }

                        $selected = '';
                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        
        <input type="hidden" name="quotetype" value="<?php echo $_GET['quotetype']; ?>" />
        <button type="submit" name="update_info">Update</button>
    </form>

    <style>
        .form-container {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
        }

        .form-column {
            padding: 20px;
            border-radius: 5px;
        }

        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 300px !important;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-row input[readonly] {
            background-color: #f9f9f9;
            cursor: not-allowed;
        }
    </style>
    <?php
}

// Create New Quotes
else if (($title=='admin' || $title=='group' || $title == 'fit' || $title == 'sales') && isset($_GET['opt']) && $_GET['opt'] == 'create-standard') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_quote'])) {
        // Quote Details
        $subject = mysqli_real_escape_string($conn, $_POST['subject'] ?? '');
        $quote_stage = mysqli_real_escape_string($conn, $_POST['quote_stage'] ?? '');
        
        $organization_name = mysqli_real_escape_string($conn, $_POST['organization_name'] ?? '');
        $contact_name = mysqli_real_escape_string($conn, $_POST['contact_name'] ?? '');

        $query =   "SELECT 
                        o.organizationid AS accountid,
                        c.auto_id AS contactid
                    FROM tdu_contacts c
                    LEFT JOIN tdu_organisation o ON c.organizationid = o.organizationid
                    WHERE o.organization_name = '$organization_name' AND c.name = '$contact_name'";
        $result = mysqli_query($conn, $query);
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $accountid = $row['accountid'];
            $contactid = $row['contactid'];
        } else {
            $accountid = '';
            $contactid = '';
        }
        
        $assign_region = mysqli_real_escape_string($conn, $_POST['assigned_to_region'] ?? '');
        
        $priority = mysqli_real_escape_string($conn, $_POST['priority'] ?? '');
        $country = mysqli_real_escape_string($conn, $_POST['country'] ?? '');
    
        // Custom Information
        $date_of_travel = mysqli_real_escape_string($conn, $_POST['date_of_travel'] ?? '');
        $payment_deadline = mysqli_real_escape_string($conn, $_POST['payment_deadline'] ?? '');
        $accepted_date = mysqli_real_escape_string($conn, $_POST['accepted_date'] ?? '');

        $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%G';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if ($row['max_quote_no']) {
            $numeric_part = (int)substr($row['max_quote_no'], 3, -1);
            $new_numeric_part = $numeric_part + 1;
            $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part) . 'G';
        } else {
            $new_quote_no = "TDU00001G";
        }

        $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if ($row['max_quoteid']) {
            $new_quoteid = $row['max_quoteid'] + 1;
        } else {
            $new_quoteid = 1;
        }

        $adults = $_POST['no_of_adults'];
        $children = $_POST['no_of_children'];
        $infants = $_POST['no_of_infants'];

        $child_ages_array = [];
        for ($i = 1; $i <= $children; $i++) {
            if (isset($_POST["child_age_$i"]) && $_POST["child_age_$i"] !== '') {
                $child_ages_array[] = mysqli_real_escape_string($conn, $_POST["child_age_$i"]);
            }
        }
        $child_ages = implode(',', $child_ages_array);
        
        $insert_sql = "INSERT INTO vtiger_quotes (quoteid, quote_no, subject, quotestage, contactid, accountid, country, mode, created_at, created_by, adults, children, infants, child_ages) 
                       VALUES ('$new_quoteid', '$new_quote_no', '$subject', '$quote_stage', '$contactid', '$accountid', '$country', 'standard', NOW(), '$username', '$adults', '$children', '$infants', '$child_ages');";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($mysqli));
        
        $insert_sql3 = "INSERT INTO vtiger_quotescf (quoteid, cf_1162, cf_1182, cf_1188, cf_1542) 
                        VALUES ('$new_quoteid', '$date_of_travel', '$payment_deadline', '$accepted_date', '$priority');";
        mysqli_query($conn, $insert_sql3) or die(mysqli_error($mysqli));

        $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                       VALUES ('$new_quoteid', '$username', 'New Quote with Stage $quote_stage', NOW());";
        mysqli_query($conn, $insert_sql4) or die(mysqli_error($mysqli));
        
        if($assign_region) {
            $quotetype = 'group';
            $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, assigned_to_region, priority) 
                    VALUES ('$new_quoteid', 'group', '$assign_region', '$priority')
                    ON DUPLICATE KEY UPDATE assigned_to_region = '$assign_region', priority = '$priority'";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
            $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
            $travel_month = (int) $travel_month;
            $travel_day = (int) $travel_day;

            $sql = "SELECT * FROM tdu_auto_assign_rules 
                    WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                    AND (category = 'sales' OR category = 'external')
                    AND (
                        ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                        AND
                        ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                    )";
            $result = mysqli_query($conn, $sql);

            if(mysqli_num_rows($result) == 0) {
                $sql = "SELECT * FROM tdu_auto_assign_rules 
                        WHERE assign_type = 'region' AND region = '$assign_region'
                        AND (
                            ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                            AND
                            ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                        )";
                $result = mysqli_query($conn, $sql);
            }

            if (mysqli_num_rows($result) > 0) {
                $assignment_map = [
                    "sales" => "assigned_to_sales_agent",
                    "external" => "assigned_to_external_sales_agent"
                ];

                while ($row = mysqli_fetch_assoc($result)) {
                    $category = $row['category'];
                    if(!isset($assignment_map[$category])) {
                        continue;
                    }
                    $key = $assignment_map[$category];
                    $value = $row['username'];

                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                            VALUES ('$new_quoteid', 'group', '$value')
                            ON DUPLICATE KEY UPDATE $key = '$value'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }

            createTaskWithMessage($conn, 'Created', $new_quote_no, 'High', date('Y-m-d'));
        }

        header("Location: ?opt=summary&quoteNumber=$new_quote_no");
        exit();
    }

    include "header.php";
    ?>
    <form method="post" style="margin-top: 20px;">
        <h2>Quote Details</h2>
        <div class="form-row">
            <label for="subject">*Subject:</label>
            <input type="text" id="subject" name="subject" required>
        </div>
        <?php $accountContacts = getAccountContacts2($conn); ?>
        <div class="form-row">
            <label for="organization_name">*Organization Name:</label>
            <button type="button" onclick="window.location.href='quote.php?opt=add-new-organization'">+</button>
            <input type="text" id="organization_name" value="<?php echo $new_organization_name; ?>" name="organization_name" required autocomplete="off">
            <datalist id="organizationList">
                <?php foreach (array_keys($accountContacts) as $name): ?>
                    <option value="<?php echo $name; ?>"></option>
                <?php endforeach; ?>
            </datalist>
        </div>
        
        <div class="form-row">
            <label for="contact_name">*Contact Name:</label>
            <select id="contact_name" name="contact_name" required>
                <option value="">Select a contact</option>
            </select>
        </div>

        <script>
            var accountContacts = <?php echo json_encode($accountContacts); ?>;

            document.getElementById('organization_name').addEventListener('input', function() {
                var organizationName = this.value;
                var contactSelect = document.getElementById('contact_name');

                // Clear the contact dropdown
                contactSelect.innerHTML = '<option value="">Select a contact</option>';

                // Populate the contact dropdown based on the selected organization
                if (accountContacts[organizationName]) {
                    var contactNames = accountContacts[organizationName];
                    contactNames.forEach(function(name) {
                        var option = document.createElement('option');
                        option.value = name;
                        option.textContent = name;
                        contactSelect.appendChild(option);
                    });
                }
            });
        </script>

        <div class="form-row">
            <label for="quote_stage">*Quote Stage:</label>
            <select id="quote_stage" name="quote_stage" required>
                <option value="Created" selected>Created</option>
            </select>
        </div>
        <div class="form-row">
            <label for="assigned_to_region">*Region:</label>
            <select name="assigned_to_region">
                <option value=""></option>
                <?php
                // Query to get group names from the vtiger_groups table
                $sqlr = "SELECT groupname FROM vtiger_groups";
                $resultr = $conn->query($sqlr);

                // Populate the select dropdown with group names
                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        $selected = '';
                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                    }
                }
                ?>
            </select>
        </div>
        <div class="form-row">
            <label for="priority">Priority:</label>
            <select id="priority" name="priority">
                <option value="" disabled selected>Select priority</option>
                <option value="not connected">Not connected</option>
                <option value="low">Low</option>
                <option value="high">High</option>
            </select>
        </div>
        <div class="form-row">
            <label for="country">*Country:</label>
            <select id="country" name="country" required>
                <option value="" disabled selected>Select country</option>
                <option value="Australia">Australia</option>
                <option value="New Zealand">New Zealand</option>
            </select>
        </div>

        <h2>Custom Information</h2>
        <div class="form-row">
            <label for="date_of_travel">*Date Of Travel:</label>
            <input type="date" id="date_of_travel" name="date_of_travel" required>
        </div>
        <div class="form-row">
            <label for="payment_deadline">Payment-Cancellation Deadline:</label>
            <input type="date" id="payment_deadline" name="payment_deadline">
        </div>
        <div class="form-row">
            <label for="accepted_date">Accepted Date:</label>
            <input type="date" id="accepted_date" name="accepted_date">
        </div>
        
        <h2>Number of Passengers</h2>
        <div class="form-row">
            <label for="no_of_adults">No of Adults:</label>
            <input type="number" id="no_of_adults" name="no_of_adults" min="1" value="1" required>
        </div>
        <div class="form-row">
            <label for="no_of_children">No of Children:</label>
            <input type="number" id="no_of_children" name="no_of_children" min="0" value="0" required onchange="updateChildrenAgeFields()">
        </div>
        <div id="children-age-fields"></div>
        <script>
            function updateChildrenAgeFields() {
                let childrenCount = document.getElementById('no_of_children').value;
                let container = document.getElementById('children-age-fields');
                container.innerHTML = ''; // Clear previous inputs

                for (let i = 1; i <= childrenCount; i++) {
                    let div = document.createElement('div');
                    div.classList.add('form-row');

                    let label = document.createElement('label');
                    label.setAttribute('for', 'child_age_' + i);
                    label.innerText = 'Age of Child ' + i + ':';

                    let input = document.createElement('input');
                    input.type = 'number';
                    input.id = 'child_age_' + i;
                    input.name = 'child_age_' + i;
                    input.min = 3;
                    input.max = 17;
                    input.required = true;

                    div.appendChild(label);
                    div.appendChild(input);
                    container.appendChild(div);
                }
            }
        </script>
        <div class="form-row">
            <label for="no_of_infants">No of Infants:</label>
            <input type="number" id="no_of_infants" name="no_of_infants" min="0" value="0" required>
        </div>
        
        <button type="submit" name="create_quote">Create New Quote</button>
        <button type="button" onclick="confirmCancel()">Cancel</button>
        
        <script>
            function confirmCancel() {
                if (confirm('Are you sure you want to cancel?')) {
                    window.location.href = '?opt=search';
                }
            }
        </script>
    </form>
    <script>
        document.querySelector('form').addEventListener('submit', function(event) {
            // Get the values of the "no_of_adults" and "no_of_children" fields
            const noOfAdults = parseInt(document.getElementById('no_of_adults').value) || 0;
            const noOfChildren = parseInt(document.getElementById('no_of_children').value) || 0;

            // Check if the total is greater than 10
            if (noOfAdults + noOfChildren <= 10) {
                // Prevent form submission
                event.preventDefault();

                // Display an alert to the user
                alert('The total number of adults and children must exceed 10.');
            }
        });
    </script>

    <script>
        document.getElementById('quote_stage').addEventListener('change', function() {
            var quoteStage = this.value;
            
            if (quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') {
                // Set accepted_date to today's date
                var today = new Date().toISOString().split('T')[0]; // Format as YYYY-MM-DD
                document.getElementById('accepted_date').value = today;
                
                // Make payment_deadline required
                document.getElementById('payment_deadline').required = true;
            } else {
                // Remove required attribute if it's a different quote stage
                document.getElementById('payment_deadline').required = false;
            }
        });
    </script>
    
    <style>
        .modal {
            display: none; 
            position: fixed; 
            z-index: 1; 
            padding-top: 100px; 
            left: 0;
            top: 0;
            width: 100%;
            height: 100%; 
            background-color: rgba(0,0,0,0.4); 
        }
    
        .modal-content {
            background-color: white;
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            width: 40%;
        }
    
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
    
        .close:hover, .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    
        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
    
        .form-row input, .form-row textarea {
            width: 100%;
        }
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
    <?php
}
else if (($title=='admin' || $title=='group' || $title == 'fit' || $title == 'sales') && isset($_GET['opt']) && $_GET['opt'] == 'create-fit') {
    if(!(isset($_GET['organisationid']) && $_GET['organisationid'] != '' && isset($_GET['contactid']) && $_GET['contactid'] != '')) {
        include "header.php";
        ?>
        <h2 style="text-align:center; margin-top: 20px;">Organization OR Contact missing</h2>
        <?php
        exit();
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_quote'])) {
        // Quote Details
        $subject = mysqli_real_escape_string($conn, $_POST['subject'] ?? '');
        $quote_stage = mysqli_real_escape_string($conn, $_POST['quote_stage'] ?? '');

        if(isset($_POST['organisationid']) && $_POST['organisationid'] != '') {
            $accountid = $_POST['organisationid'];
            $contactid = '';
            $country = 'Australia';
            if(isset($_GET['country']) && $_GET['country'] != '') {
                $country = $_GET['country'];
            }
            $query = "SELECT va.region, va.organization_name FROM tdu_organisation va WHERE va.organizationid = '$accountid'";
            $result = mysqli_query($conn, $query);
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $assign_region = $row['region'];
                $organization_name = $row['organization_name'];
            } else {
                $assign_region = '';
                $organization_name = '';
            }
            $organization_name = mysqli_real_escape_string($conn, $organization_name ?? '');
        } else {
            $assign_region = mysqli_real_escape_string($conn, $_POST['assigned_to_region'] ?? '');

            $organization_name = mysqli_real_escape_string($conn, $_POST['organization_name'] ?? '');
            $contact_name = mysqli_real_escape_string($conn, $_POST['contact_name'] ?? '');

            $query =   "SELECT 
                            o.organizationid AS accountid,
                            c.auto_id AS contactid
                        FROM tdu_contacts c
                        LEFT JOIN tdu_organisation o ON c.organizationid = o.organizationid
                        WHERE o.organization_name = '$organization_name' AND c.name = '$contact_name'";
            $result = mysqli_query($conn, $query);
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $accountid = $row['accountid'];
                $contactid = $row['contactid'];
            } else {
                $accountid = '';
                $contactid = '';
            }
            
            $country = mysqli_real_escape_string($conn, $_POST['country'] ?? '');
        }

        if(isset($_GET['contactid']) && $_GET['contactid'] != '') {
            $contactid = $_GET['contactid'];
        }
                
        $priority = mysqli_real_escape_string($conn, $_POST['priority'] ?? '');
    
        // Custom Information
        $date_of_travel = mysqli_real_escape_string($conn, $_POST['date_of_travel'] ?? '');
        $payment_deadline = mysqli_real_escape_string($conn, $_POST['payment_deadline'] ?? '');
        $accepted_date = mysqli_real_escape_string($conn, $_POST['accepted_date'] ?? '');
        // $flight_details = mysqli_real_escape_string($conn, $_POST['flight_details'] ?? '');
        // $no_pax = mysqli_real_escape_string($conn, $_POST['no_pax'] ?? '');

        // $quotetype = 'fit';
        $adults = (int) $_POST['no_of_adults'];
        $children = (int) $_POST['no_of_children'];
        $infants = $_POST['no_of_infants'];

        if($adults + $children > 15) {
            $quotetype = 'group';

            $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%G';";
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if ($row['max_quote_no']) {
                $numeric_part = (int)substr($row['max_quote_no'], 3, -1);
                $new_numeric_part = $numeric_part + 1;
                $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part) . 'G';
            } else {
                $new_quote_no = "TDU00001G";
            }
        } else {
            $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%' AND quote_no NOT LIKE 'TDU%G';";
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if ($row['max_quote_no']) {
                $numeric_part = (int)substr($row['max_quote_no'], 3);
                $new_numeric_part = $numeric_part + 1;
                $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part);
            } else {
                $new_quote_no = "TDU30001";
            }
        }

        $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if ($row['max_quoteid']) {
            $new_quoteid = $row['max_quoteid'] + 1;
        } else {
            $new_quoteid = 1;
        }

        $single_room = $_POST['single_room'];
        $double_room = $_POST['double_room'];
        $triple_room = $_POST['triple_room'];
        $child_without_bed = $_POST['child_without_bed'];
        $child_with_bed = $children - $child_without_bed;

        $child_ages_array = [];
        for ($i = 1; $i <= $children; $i++) {
            if (isset($_POST["child_age_$i"]) && $_POST["child_age_$i"] !== '') {
                $child_ages_array[] = mysqli_real_escape_string($conn, $_POST["child_age_$i"]);
            }
        }
        $child_ages = implode(',', $child_ages_array);

        $airef = 0;
        if (isset($_GET['airef']) && $_GET['airef'] != '') {
            $airef = $_GET['airef'];
        }
        // Prepare the SQL query
        $insert_sql = "INSERT INTO vtiger_quotes (quoteid, quote_no, subject, quotestage, contactid, accountid, country, mode, created_at, created_by, adults, children, infants, nsingle_room, ndouble_room, ntriple_room, nchild_without_bed, child_ages, ai_ref_id) 
                       VALUES ('$new_quoteid', '$new_quote_no', '$subject', '$quote_stage', '$contactid', '$accountid', '$country', 'standard', NOW(), '$username', '$adults', '$children', '$infants', '$single_room', '$double_room', '$triple_room', '$child_without_bed', '$child_ages', '$airef');";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($mysqli));

        if (isset($_GET['airef']) && $_GET['airef'] != '') {
            $airef = $_GET['airef'];

            $sql_ai_ref = "SELECT conversation_id FROM tdu_temp_ai_quotes WHERE id='$airef';";
            $result_ai_ref = mysqli_query($conn, $sql_ai_ref);
            if ($row_ai_ref = mysqli_fetch_assoc($result_ai_ref)) {
                $ticketID = $row_ai_ref['conversation_id'];
                $sqlInsertUpdate = "INSERT INTO vtiger_support (ticketid, quote_no) 
                                    VALUES ('$ticketID', '$new_quote_no') 
                                    ON DUPLICATE KEY UPDATE quote_no = '$new_quote_no'";
                mysqli_query($conn, $sqlInsertUpdate) or die(mysqli_error($mysqli));
            }
        }
                
        $insert_sql3 = "INSERT INTO vtiger_quotescf (quoteid, cf_1162, cf_1182, cf_1188, cf_1542) 
                        VALUES ('$new_quoteid', '$date_of_travel', '$payment_deadline', '$accepted_date', '$priority');";
        mysqli_query($conn, $insert_sql3) or die(mysqli_error($mysqli));

        $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                       VALUES ('$new_quoteid', '$username', 'New Quote with Stage $quote_stage', NOW());";
        mysqli_query($conn, $insert_sql4) or die(mysqli_error($mysqli));

        $next_seq = 1;
        $next_seq = insertRooms($conn, $new_quoteid, 'Single', $single_room, 0, $next_seq);
        $next_seq = insertRooms($conn, $new_quoteid, 'Double', $double_room, $child_without_bed, $next_seq);
        $next_seq = insertRooms($conn, $new_quoteid, 'Triple', $triple_room, $child_with_bed, $next_seq);

        if($assign_region) {
            $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, assigned_to_region, priority) 
                    VALUES ('$new_quoteid', 'group', '$assign_region', '$priority')
                    ON DUPLICATE KEY UPDATE assigned_to_region = '$assign_region', priority = '$priority'";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
            $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
            $travel_month = (int) $travel_month;
            $travel_day = (int) $travel_day;

            $sql = "SELECT * FROM tdu_auto_assign_rules 
                    WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                    AND (category = 'sales' OR category = 'external')
                    AND (
                        ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                        AND
                        ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                    )";
            $result = mysqli_query($conn, $sql);

            if(mysqli_num_rows($result) == 0) {
                $sql = "SELECT * FROM tdu_auto_assign_rules 
                        WHERE assign_type = 'region' AND region = '$assign_region'
                        AND (
                            ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                            AND
                            ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                        )";
                $result = mysqli_query($conn, $sql);
            }

            if (mysqli_num_rows($result) > 0) {
                $assignment_map = [
                    "sales" => "assigned_to_sales_agent",
                    "external" => "assigned_to_external_sales_agent"
                ];

                while ($row = mysqli_fetch_assoc($result)) {
                    $category = $row['category'];
                    if(!isset($assignment_map[$category])) {
                        continue;
                    }
                    $key = $assignment_map[$category];
                    $value = $row['username'];

                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                            VALUES ('$new_quoteid', 'group', '$value')
                            ON DUPLICATE KEY UPDATE $key = '$value'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }

            createTaskWithMessage($conn, 'Created', $new_quote_no, 'High', date('Y-m-d'));
        }

        $templateid = isset($_GET['templateid']) ? mysqli_real_escape_string($conn, $_GET['templateid']) : '';

        echo "<script>
                var templateIds = '$templateid'.split(',').map(id => id.trim()); // Split and trim template IDs
                var currentIndex = 0;

                function sendAjaxRequest() {
                    if (currentIndex >= templateIds.length) {
                        // Redirect after all requests are complete
                        window.location.href = '?opt=summary&quoteNumber=$new_quote_no';
                        return;
                    }

                    var templateId = templateIds[currentIndex];
                    var xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_quote_template.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.onreadystatechange = function() {
                        if (xhr.readyState == 4 && xhr.status == 200) {
                            console.log('AJAX response for templateId ' + templateId + ':', xhr.responseText);
                            currentIndex++; // Move to the next template ID
                            sendAjaxRequest(); // Call the function again for the next ID
                        }
                    };
                    xhr.send('quoteid=$new_quoteid&templateid=' + encodeURIComponent(templateId));
                }

                sendAjaxRequest(); // Start the first AJAX call
            </script>";

        exit();
    }

    include "header.php";
    ?>
    <form method="post" style="margin-top: 20px;" id="passengerForm">
        <?php
        if(isset($_GET['organisationid']) && $_GET['organisationid'] != '') {
            $organisationid = $_GET['organisationid'];
            $query = "SELECT organization_name, country, region FROM tdu_organisation WHERE organizationid = '$organisationid'";
            $result = mysqli_query($conn, $query);
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $organization_name = $row['organization_name'];
                $country = $row['country'];
                $region = $row['region'];
            }
            ?>
            <h2>New Quote for <?= $organization_name ?></h2>
            <div class="form-row">
                <label for="subject">*Subject:</label>
                <input type="text" id="subject" name="subject" required value="<?= $_GET['email_subject'] ?? '' ?>">
            </div>
            <input type="hidden" id="organisationid" value="<?= $organisationid ?>" name="organisationid">
            <input type="hidden" id="quote_stage" value="Created" name="quote_stage">
            <input type="hidden" id="assigned_to" value="(Group) <?= $region ?>" name="assigned_to">
            <?php
        } else {
            ?>
            <h2>New Quote</h2>
            <div class="form-row">
                <label for="subject">*Subject:</label>
                <input type="text" id="subject" name="subject" required>
            </div>
            <?php $accountContacts = getAccountContacts2($conn); ?>
            <div class="form-row">
                <label for="organization_name">*Organization Name:</label>
                <button type="button" onclick="window.location.href='quote.php?opt=add-new-organization'">+</button>
                <input type="text" id="organization_name" value="" name="organization_name" required autocomplete="off">
                <datalist id="organizationList">
                    <?php foreach (array_keys($accountContacts) as $name): ?>
                        <option value="<?php echo $name; ?>"></option>
                    <?php endforeach; ?>
                </datalist>
            </div>
            <div class="form-row">
                <label for="contact_name">*Contact Name:</label>
                <select id="contact_name" name="contact_name" required>
                    <option value="">Select a contact</option>
                </select>
            </div>

            <script>
                var accountContacts = <?php echo json_encode($accountContacts); ?>;

                document.getElementById('organization_name').addEventListener('input', function() {
                    var organizationName = this.value;
                    var contactSelect = document.getElementById('contact_name');

                    // Clear the contact dropdown
                    contactSelect.innerHTML = '<option value="">Select a contact</option>';

                    // Populate the contact dropdown based on the selected organization
                    if (accountContacts[organizationName]) {
                        var contactNames = accountContacts[organizationName];
                        contactNames.forEach(function(name) {
                            var option = document.createElement('option');
                            option.value = name;
                            option.textContent = name;
                            contactSelect.appendChild(option);
                        });
                    }
                });
            </script>

            <div class="form-row">
                <label for="quote_stage">*Quote Stage:</label>
                <select id="quote_stage" name="quote_stage" required>
                    <option value="Created" selected>Created</option>
                </select>
            </div>
            <div class="form-row">
                <label for="assigned_to_region">*Region:</label>
                <select name="assigned_to_region">
                    <option value=""></option>
                    <?php
                    // Query to get group names from the vtiger_groups table
                    $sqlr = "SELECT groupname FROM vtiger_groups";
                    $resultr = $conn->query($sqlr);

                    // Populate the select dropdown with group names
                    if ($resultr->num_rows > 0) {
                        while ($rowr = $resultr->fetch_assoc()) {
                            $selected = '';
                            echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-row">
                <label for="priority">Priority:</label>
                <select id="priority" name="priority">
                    <option value="" disabled selected>Select priority</option>
                    <option value="not connected">Not connected</option>
                    <option value="low">Low</option>
                    <option value="high">High</option>
                </select>
            </div>
            <div class="form-row">
                <label for="country">*Country:</label>
                <select id="country" name="country" required>
                    <option value="" disabled selected>Select country</option>
                    <option value="Australia">Australia</option>
                    <option value="New Zealand">New Zealand</option>
                </select>
            </div>
            <?php
        } 
        ?>

        <h2>Travel Info</h2>
        <div class="form-row">
            <label for="date_of_travel">*Date Of Travel:</label>
            <input type="date" id="date_of_travel" name="date_of_travel" required value="<?= $_GET['travel_date'] ?? '' ?>">
        </div>
        <?php
        if(!(isset($_GET['organisationid']) && $_GET['organisationid'] != '')) {
            ?>
            <div class="form-row">
                <label for="payment_deadline">Payment-Cancellation Deadline:</label>
                <input type="date" id="payment_deadline" name="payment_deadline">
            </div>
            <div class="form-row">
                <label for="accepted_date">Accepted Date:</label>
                <input type="date" id="accepted_date" name="accepted_date">
            </div>
            <?php
        }
        ?>
        
        <h2>Room Configuration</h2>
        <div class="form-row">
            <label for="single_room">Number of Single Rooms:</label>
            <input type="number" id="single_room" name="single_room" min="0" value="0" required>
        </div>
        <div class="form-row">
            <label for="double_room">Number of Double Rooms:</label>
            <input type="number" id="double_room" name="double_room" min="0" value="0" required>
        </div>
        <div class="form-row">
            <label for="triple_room">Number of Triple Rooms:</label>
            <input type="number" id="triple_room" name="triple_room" min="0" value="0" required>
        </div>
        <div class="form-row">
            <label for="child_without_bed">Number of Children Without Bed:</label>
            <input type="number" id="child_without_bed" name="child_without_bed" min="0" value="0" required onchange="updateChildrenAgeFields()">
        </div>
        <div class="form-row">
            <label for="child_with_bed">Number of Children With Bed:</label>
            <input type="number" id="child_with_bed" name="child_with_bed" min="0" value="0" required onchange="updateChildrenAgeFields()">
        </div>

        <h2>Number of Passengers</h2>
        <div class="form-row">
            <label for="no_of_adults">No of Adults:</label>
            <input type="number" id="no_of_adults" name="no_of_adults" min="1" value="1" readonly style="cursor: not-allowed;">
        </div>
        <div class="form-row">
            <label for="no_of_children">No of Children:</label>
            <input type="number" id="no_of_children" name="no_of_children" min="0" value="0" required onchange="updateChildrenAgeFields()">
        </div>
        <div id="children-age-fields"></div>
        <script>
            function updateChildrenAgeFields() {
                let childrenCount = document.getElementById('no_of_children').value;
                let container = document.getElementById('children-age-fields');
                container.innerHTML = ''; // Clear previous inputs

                for (let i = 1; i <= childrenCount; i++) {
                    let div = document.createElement('div');
                    div.classList.add('form-row');

                    let label = document.createElement('label');
                    label.setAttribute('for', 'child_age_' + i);
                    label.innerText = 'Age of Child ' + i + ':';

                    let input = document.createElement('input');
                    input.type = 'number';
                    input.id = 'child_age_' + i;
                    input.name = 'child_age_' + i;
                    input.min = 3;
                    input.max = 17;
                    input.required = true;

                    div.appendChild(label);
                    div.appendChild(input);
                    container.appendChild(div);
                }
            }
        </script>
        <div class="form-row">
            <label for="no_of_infants">No of Infants (Age 0-2):</label>
            <input type="number" id="no_of_infants" name="no_of_infants" min="0" value="0">
        </div>
        
        <button type="submit" name="create_quote">Create New Quote</button>
        <button type="button" onclick="confirmCancel()">Cancel</button>
        
        <script>
            function confirmCancel() {
                if (confirm('Are you sure you want to cancel?')) {
                    window.location.href = '?opt=search';
                }
            }
        </script>

        <script>
            // Get references to inputs and calculated passenger fields
            const noOfAdults = document.getElementById('no_of_adults');
            const noOfChildren = document.getElementById('no_of_children');
            const noOfInfants = document.getElementById('no_of_infants');

            const singleRoomInput = document.getElementById('single_room');
            const doubleRoomInput = document.getElementById('double_room');
            const tripleRoomInput = document.getElementById('triple_room');
            const childWithoutBedInput = document.getElementById('child_without_bed');
            const childWithBedInput = document.getElementById('child_with_bed');

            // Function to calculate totals
            function updatePassengerCounts() {
                const singleRoomAdults = parseInt(singleRoomInput.value) || 0;
                const doubleRoomAdults = (parseInt(doubleRoomInput.value) || 0) * 2;
                const tripleRoomAdults = (parseInt(tripleRoomInput.value) || 0) * 3;

                const totalAdults = singleRoomAdults + doubleRoomAdults + tripleRoomAdults - (parseInt(childWithBedInput.value) || 0);
                const totalChildren = 
                    (parseInt(childWithoutBedInput.value) || 0) + 
                    (parseInt(childWithBedInput.value) || 0);

                noOfAdults.value = totalAdults;
                noOfChildren.value = totalChildren;
            }

            // Add event listeners to inputs
            [singleRoomInput, doubleRoomInput, tripleRoomInput, childWithoutBedInput, childWithBedInput].forEach(input => {
                input.addEventListener('input', updatePassengerCounts);
            });

            // Initialize passenger counts
            updatePassengerCounts();
        </script>

        <script>
            document.getElementById('passengerForm').addEventListener('submit', function(event) {
                const noOfAdults = parseInt(document.getElementById('no_of_adults').value) || 0;

                if (noOfAdults < 1) {
                    event.preventDefault(); // Prevent form submission
                    alert('The number of adults must be at least 1.');
                }
            });
        </script>
    </form>

    <script>
        document.getElementById('quote_stage').addEventListener('change', function() {
            var quoteStage = this.value;
            
            if (quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') {
                // Set accepted_date to today's date
                var today = new Date().toISOString().split('T')[0]; // Format as YYYY-MM-DD
                document.getElementById('accepted_date').value = today;
                
                // Make payment_deadline required
                document.getElementById('payment_deadline').required = true;
            } else {
                // Remove required attribute if it's a different quote stage
                document.getElementById('payment_deadline').required = false;
            }
        });
    </script>
    
    <style>
        .modal {
            display: none; 
            position: fixed; 
            z-index: 1; 
            padding-top: 100px; 
            left: 0;
            top: 0;
            width: 100%;
            height: 100%; 
            background-color: rgba(0,0,0,0.4); 
        }
    
        .modal-content {
            background-color: white;
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            width: 40%;
        }
    
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
    
        .close:hover, .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    
        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
    
        .form-row input, .form-row textarea {
            width: 100%;
        }
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
    <?php
}
else if (($title=='admin' || $title=='group' || $title == 'fit' || $title == 'sales') && isset($_GET['opt']) && $_GET['opt'] == 'create-group') {
    if(!(isset($_GET['organisationid']) && $_GET['organisationid'] != '' && isset($_GET['contactid']) && $_GET['contactid'] != '')) {
        include "header.php";
        ?>
        <h2 style="text-align:center; margin-top: 20px;">Organization OR Contact missing</h2>
        <?php
        exit();
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_quote'])) {
        // Quote Details
        $subject = mysqli_real_escape_string($conn, $_POST['subject'] ?? '');
        $quote_stage = mysqli_real_escape_string($conn, $_POST['quote_stage'] ?? '');
        
        $organization_name = mysqli_real_escape_string($conn, $_POST['organization_name'] ?? '');
        $contact_name = mysqli_real_escape_string($conn, $_POST['contact_name'] ?? '');

        $query =   "SELECT 
                        o.organizationid AS accountid,
                        c.auto_id AS contactid
                    FROM tdu_contacts c
                    LEFT JOIN tdu_organisation o ON c.organizationid = o.organizationid
                    WHERE o.organization_name = '$organization_name' AND c.name = '$contact_name'";
        $result = mysqli_query($conn, $query);
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $accountid = $row['accountid'];
            $contactid = $row['contactid'];
        } else {
            $accountid = '';
            $contactid = '';
        }

        if(isset($_GET['organisationid']) && $_GET['organisationid'] != '' && isset($_GET['contactid']) && $_GET['contactid'] != '') {
            $accountid = $_GET['organisationid'];
            $contactid = $_GET['contactid'];
        }
        
        $assign_region = mysqli_real_escape_string($conn, $_POST['assigned_to_region'] ?? '');
        
        $priority = mysqli_real_escape_string($conn, $_POST['priority'] ?? '');
        $country = mysqli_real_escape_string($conn, $_POST['country'] ?? '');
    
        // Custom Information
        $date_of_travel = mysqli_real_escape_string($conn, $_POST['date_of_travel'] ?? '');
        $payment_deadline = mysqli_real_escape_string($conn, $_POST['payment_deadline'] ?? '');
        $accepted_date = mysqli_real_escape_string($conn, $_POST['accepted_date'] ?? '');
        $flight_details = mysqli_real_escape_string($conn, $_POST['flight_details'] ?? '');
        
        $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%G';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if ($row['max_quote_no']) {
            $numeric_part = (int)substr($row['max_quote_no'], 3, -1);
            $new_numeric_part = $numeric_part + 1;
            $new_quote_no = 'TDU' . sprintf('%05d', $new_numeric_part) . 'G';
        } else {
            $new_quote_no = "TDU00001G";
        }

        $sql = "SELECT MAX(quote_no) AS max_quote_no, MAX(quoteid) AS max_quoteid FROM vtiger_quotes WHERE quote_no LIKE 'TDU%';";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if ($row['max_quoteid']) {
            $new_quoteid = $row['max_quoteid'] + 1;
        } else {
            $new_quoteid = 1;
        }

        $adults = $_POST['no_of_adults'];
        $children = $_POST['no_of_children'];
        $infants = $_POST['no_of_infants'];

        $child_ages_array = [];
        for ($i = 1; $i <= $children; $i++) {
            if (isset($_POST["child_age_$i"]) && $_POST["child_age_$i"] !== '') {
                $child_ages_array[] = mysqli_real_escape_string($conn, $_POST["child_age_$i"]);
            }
        }
        $child_ages = implode(',', $child_ages_array);
        
        $insert_sql = "INSERT INTO vtiger_quotes (quoteid, quote_no, subject, quotestage, contactid, accountid, country, created_at, created_by, adults, children, infants, child_ages) 
                       VALUES ('$new_quoteid', '$new_quote_no', '$subject', '$quote_stage', '$contactid', '$accountid', '$country', NOW(), '$username', '$adults', '$children', '$infants', '$child_ages');";
        mysqli_query($conn, $insert_sql) or die(mysqli_error($mysqli));
        
        $insert_sql3 = "INSERT INTO vtiger_quotescf (quoteid, cf_1162, cf_1182, cf_1188, cf_1542) 
                        VALUES ('$new_quoteid', '$date_of_travel', '$payment_deadline', '$accepted_date', '$priority');";
        mysqli_query($conn, $insert_sql3) or die(mysqli_error($mysqli));

        $insert_sql4 = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                       VALUES ('$new_quoteid', '$username', 'New Quote with Stage $quote_stage', NOW());";
        mysqli_query($conn, $insert_sql4) or die(mysqli_error($mysqli));

        if($assign_region) {
            $quotetype = 'group';
            $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, assigned_to_region, priority) 
                    VALUES ('$new_quoteid', 'group', '$assign_region', '$priority')
                    ON DUPLICATE KEY UPDATE assigned_to_region = '$assign_region', priority = '$priority'";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $travel_month = date('n', strtotime($date_of_travel)); // Get month (1-12)
            $travel_day = date('j', strtotime($date_of_travel));   // Get day (1-31)
            $travel_month = (int) $travel_month;
            $travel_day = (int) $travel_day;

            $sql = "SELECT * FROM tdu_auto_assign_rules 
                    WHERE assign_type = 'keyPartner' AND (region = '$organization_name' OR region LIKE '%$organization_name;;%' OR region LIKE '%;;$organization_name%')
                    AND (category = 'sales' OR category = 'external')
                    AND (
                        ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                        AND
                        ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                    )";
            $result = mysqli_query($conn, $sql);

            if(mysqli_num_rows($result) == 0) {
                $sql = "SELECT * FROM tdu_auto_assign_rules 
                        WHERE assign_type = 'region' AND region = '$assign_region'
                        AND (
                            ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                            AND
                            ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                        )";
                $result = mysqli_query($conn, $sql);
            }

            if (mysqli_num_rows($result) > 0) {
                $assignment_map = [
                    "sales" => "assigned_to_sales_agent",
                    "external" => "assigned_to_external_sales_agent"
                ];

                while ($row = mysqli_fetch_assoc($result)) {
                    $category = $row['category'];
                    if(!isset($assignment_map[$category])) {
                        continue;
                    }
                    $key = $assignment_map[$category];
                    $value = $row['username'];

                    $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                            VALUES ('$new_quoteid', 'group', '$value')
                            ON DUPLICATE KEY UPDATE $key = '$value'";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }

            createTaskWithMessage($conn, 'Created', $new_quote_no, 'High', date('Y-m-d'));
        }

        header("Location: ?opt=summary&quoteNumber=$new_quote_no");
        exit();
    }
    
    include "header.php";
    ?>
    <form method="post" style="margin-top: 20px;">
        <h2>Pax Range Quote Details</h2>
        <div class="form-row">
            <label for="subject">*Subject:</label>
            <input type="text" id="subject" name="subject" required>
        </div>
        
        <div class="form-row">
            <label for="quote_stage">*Quote Stage:</label>
            <select id="quote_stage" name="quote_stage" required>
                <option value="Created" selected>Created</option>
            </select>
        </div>
        <div class="form-row">
            <?php
                $sqlr = "SELECT region FROM tdu_organisation WHERE organizationid=" . $_GET['organisationid'];
                $resultr = $conn->query($sqlr);
                $rowr = $resultr->fetch_assoc();
                $assign_region_r = $rowr['region'];
            ?>
            <label for="assigned_to_region">*Region:</label>
            <input type="text" id="assigned_to_region" name="assigned_to_region" value="<?= $assign_region_r ?>" required readonly>
        </div>
        <div class="form-row">
            <label for="priority">Priority:</label>
            <select id="priority" name="priority">
                <option value="" disabled selected>Select priority</option>
                <option value="not connected">Not connected</option>
                <option value="low">Low</option>
                <option value="high">High</option>
            </select>
        </div>
        <div class="form-row">
            <label for="country">*Country:</label>
            <select id="country" name="country" required>
                <option value="" disabled selected>Select country</option>
                <option value="Australia">Australia</option>
                <option value="New Zealand">New Zealand</option>
            </select>
        </div>

        <h2>Custom Information</h2>
        <div class="form-row">
            <label for="date_of_travel">*Date Of Travel:</label>
            <input type="date" id="date_of_travel" name="date_of_travel" required>
        </div>
        <div class="form-row">
            <label for="payment_deadline">Payment-Cancellation Deadline:</label>
            <input type="date" id="payment_deadline" name="payment_deadline">
        </div>
        <div class="form-row">
            <label for="accepted_date">Accepted Date:</label>
            <input type="date" id="accepted_date" name="accepted_date">
        </div>
        
        <h2>Number of Passengers</h2>
        <div class="form-row">
            <label for="no_of_adults">No of Adults:</label>
            <input type="number" id="no_of_adults" name="no_of_adults" min="1" value="1" required>
        </div>
        <div class="form-row">
            <label for="no_of_children">No of Children:</label>
            <input type="number" id="no_of_children" name="no_of_children" min="0" value="0" required onchange="updateChildrenAgeFields()">
        </div>
        <div id="children-age-fields"></div>
        <script>
            function updateChildrenAgeFields() {
                let childrenCount = document.getElementById('no_of_children').value;
                let container = document.getElementById('children-age-fields');
                container.innerHTML = ''; // Clear previous inputs

                for (let i = 1; i <= childrenCount; i++) {
                    let div = document.createElement('div');
                    div.classList.add('form-row');

                    let label = document.createElement('label');
                    label.setAttribute('for', 'child_age_' + i);
                    label.innerText = 'Age of Child ' + i + ':';

                    let input = document.createElement('input');
                    input.type = 'number';
                    input.id = 'child_age_' + i;
                    input.name = 'child_age_' + i;
                    input.min = 3;
                    input.max = 17;
                    input.required = true;

                    div.appendChild(label);
                    div.appendChild(input);
                    container.appendChild(div);
                }
            }
        </script>
        <div class="form-row">
            <label for="no_of_infants">No of Infants:</label>
            <input type="number" id="no_of_infants" name="no_of_infants" min="0" value="0" required>
        </div>

        <button type="submit" name="create_quote">Create New Quote</button>
        <button type="button" onclick="confirmCancel()">Cancel</button>
        
        <script>
            function confirmCancel() {
                if (confirm('Are you sure you want to cancel?')) {
                    window.location.href = '?opt=search';
                }
            }
        </script>
    </form>
    <script>
        document.querySelector('form').addEventListener('submit', function(event) {
            // Get the values of the "no_of_adults" and "no_of_children" fields
            const noOfAdults = parseInt(document.getElementById('no_of_adults').value) || 0;
            const noOfChildren = parseInt(document.getElementById('no_of_children').value) || 0;

            // Check if the total is greater than 10
            if (noOfAdults + noOfChildren <= 10) {
                // Prevent form submission
                event.preventDefault();

                // Display an alert to the user
                alert('The total number of adults and children must exceed 10.');
            }
        });
    </script>

    <script>
        document.getElementById('quote_stage').addEventListener('change', function() {
            var quoteStage = this.value;
            
            if (quoteStage === 'Accepted' || quoteStage === 'Accepted - Groups') {
                // Set accepted_date to today's date
                var today = new Date().toISOString().split('T')[0]; // Format as YYYY-MM-DD
                document.getElementById('accepted_date').value = today;
                
                // Make payment_deadline required
                document.getElementById('payment_deadline').required = true;
            } else {
                // Remove required attribute if it's a different quote stage
                document.getElementById('payment_deadline').required = false;
            }
        });
    </script>
    
    <style>
        .modal {
            display: none; 
            position: fixed; 
            z-index: 1; 
            padding-top: 100px; 
            left: 0;
            top: 0;
            width: 100%;
            height: 100%; 
            background-color: rgba(0,0,0,0.4); 
        }
    
        .modal-content {
            background-color: white;
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            width: 40%;
        }
    
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
    
        .close:hover, .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    
        .form-row {
            margin-bottom: 10px;
        }
    
        .form-row label {
            margin-right: 10px;
        }
    
        .form-row input, .form-row textarea {
            width: 100%;
        }
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
        }
        .form-row input, .form-row select, .form-row textarea {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
    <?php
}

// Custom Products Pending Approval
else if (($title=='admin') && isset($_GET['opt']) && $_GET['opt'] == 'custom-approval') {
    include "header.php";

    // Filters
    $productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
    $quoteNoFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';

    // Base query
    $sql = "SELECT vpc.productname, vq.quote_no, vq.quoteid, vi.sequence_no
            FROM (
                SELECT *
                FROM vtiger_quotes
                WHERE quoteid = (
                    SELECT MIN(quoteid) AS quoteid
                    FROM vtiger_quotes AS sub
                    WHERE sub.quote_no = vtiger_quotes.quote_no
                )
            ) vq
            JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
            JOIN vtiger_products_custom vpc ON vi.productid = vpc.productid
            WHERE vi.margin IS NULL";

    // Apply filters
    if ($productNameFilter) {
        $sql .= " AND vpc.productname LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
    }
    if ($quoteNoFilter) {
        $sql .= " AND vq.quote_no LIKE '%" . $conn->real_escape_string($quoteNoFilter) . "%'";
    }

    // Pagination
    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY vq.quote_no DESC LIMIT $limit OFFSET $offset";

    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Custom Products Pending Approval</h1>
    <table class="styled-table" style="width: 60%; margin: 20px auto;">
        <tr>
            <th></th>
            <th style="text-align: left;">Product Name</th>
            <th style="text-align: left;">Quote Number</th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="custom-approval">
                <td><button type="submit">Search</button></td>
                <td>
                    <input type="text" name="productname" value="<?= htmlspecialchars($productNameFilter); ?>">
                </td>
                <td>
                    <input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter); ?>">
                </td>
            </form>
        </tr>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><input type="checkbox" class="quote-checkbox" data-quoteid="<?= htmlspecialchars($row['quoteid']); ?>" data-sequence_no="<?= htmlspecialchars($row['sequence_no']); ?>"></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['productname']); ?></td>
                    <td style="text-align: left;">
                        <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($row['quote_no']); ?>">
                            <?= htmlspecialchars($row['quote_no']); ?>
                        </a>
                    </td>
                </tr>
            <?php endwhile; ?>
            <tr>
                <td><input type="checkbox" id="select-all"> All</td>
                <td style="text-align: left;">
                    <button type="button" style="background-color: #4CAF50; color: white; border: none; border-radius: 5px;" id="bulk-approve-btn"><i class='fa-solid fa-check'></i> Approve Selected</button>
                    <button type="button" style="background-color: red; color: white; border: none; border-radius: 5px;" id="bulk-deny-btn"><i class='fa-solid fa-xmark'></i> Deny Selected</button>
                </td>
                <td></td>
            </tr>
            <tr>
                <td></td><td style="text-align: left;">Number of results: <?= $totalRecords ?></td><td></td>
            </tr>
        <?php else: ?>
            <tr>
                <td colspan="3">No results found.</td>
            </tr>
        <?php endif; ?>
    </table>

    <script>
        // Select all checkboxes
        document.getElementById('select-all').addEventListener('click', function () {
            const checkboxes = document.querySelectorAll('.quote-checkbox');
            checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        });

        // Bulk actions
        const handleBulkAction = (action) => {
            const selectedItems = Array.from(document.querySelectorAll('.quote-checkbox:checked'));
            if (selectedItems.length === 0) {
                alert("No items selected.");
                return;
            }

            if (confirm(`Are you sure you want to ${action} the selected items?`)) {
                const data = selectedItems.map(item => ({
                    quoteid: item.dataset.quoteid,
                    sequence_no: item.dataset.sequence_no
                }));

                fetch('ajax_bulk_approve_or_deny.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ action, items: data })
                })
                .then(response => response.text())
                .then(message => {
                    alert(message);
                    location.reload(); // Refresh the page to reflect changes
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while processing your request.');
                });
            }
        };

        document.getElementById('bulk-approve-btn').addEventListener('click', () => handleBulkAction('approve'));
        document.getElementById('bulk-deny-btn').addEventListener('click', () => handleBulkAction('deny'));
    </script>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php
}

// Multiple Vendor Pending Select
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'alt-vendor-approval') {
    include "header.php";

    // Filters
    $productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
    $quoteNoFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';

    // Base query
    $sql = "SELECT tpa.auto_id AS tpavid, vq.quote_no, tp.productName, tv.vendorName, tp.category, tpa.price1, tpa.price2, tpa.price3
            FROM tdu_product_alt_vendors_in_quote tpa
            LEFT JOIN tdu_product_vendors tpv ON tpv.auto_id = tpa.productvendorid
            LEFT JOIN vtiger_quotes vq ON vq.quoteid = tpa.quoteid
            LEFT JOIN tdu_products tp ON tpv.productid = tp.productid
            LEFT JOIN tdu_vendors tv ON tpv.vendorid = tv.vendorid
            WHERE tpa.actioned = 0 AND price1 != '' ";

    // Apply filters
    if ($productNameFilter) {
        $sql .= " AND tp.productName LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
    }
    if ($quoteNoFilter) {
        $sql .= " AND vq.quote_no LIKE '%" . $conn->real_escape_string($quoteNoFilter) . "%'";
    }

    // Pagination
    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY vq.quote_no DESC LIMIT $limit OFFSET $offset";
    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Multiple Vendor Pending Select</h1>
    <table class="styled-table" style="width: 80%; margin: 20px auto; text-align: left;">
        <tr>
            <th></th>
            <th>Quote No</th>
            <th>Product Name</th>
            <th>Vendor Name</th>
            <th>Category</th>
            <th>Adult Price</th>
            <th>Child Price</th>
            <th>Infant Price</th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="alt-vendor-approval">
                <td style="text-align: center;"><button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button></td>
                <td><input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter); ?>"></td>
                <td><input type="text" name="productname" value="<?= htmlspecialchars($productNameFilter); ?>"></td>
                <td colspan="5"></td>
            </form>
        </tr>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td style="text-align: center;">
                        <button type='button' class='save-alt-price-btn' data-tpavid="<?= $row['tpavid'] ?>">
                            <i class='fa-solid fa-check'></i>
                        </button>
                    </td>
                    <td>
                        <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($row['quote_no']); ?>">
                            <?= htmlspecialchars($row['quote_no']); ?>
                        </a>
                    </td>
                    <td>
                        <a href="?opt=alt-vendor-approval&quote_no=<?= urlencode($row['quote_no']); ?>&productname=<?= urlencode($row['productName']); ?>">
                            <?= htmlspecialchars($row['productName']); ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($row['vendorName']); ?></td>
                    <td><?= htmlspecialchars($row['category']); ?></td>
                    <td><?= $row['price1'] !== '' ? '$ ' . htmlspecialchars($row['price1']) : ''; ?></td>
                    <td><?= $row['price2'] !== '' ? '$ ' . htmlspecialchars($row['price2']) : ''; ?></td>
                    <td><?= $row['price3'] !== '' ? '$ ' . htmlspecialchars($row['price3']) : ''; ?></td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="8">No results found.</td>
            </tr>
        <?php endif; ?>
    </table>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Approve Button Click Handler
            $(document).on("click", ".save-alt-price-btn", function() {
                let button = $(this);
                let tpavid = button.data("tpavid");

                // Confirmation prompt
                if (!confirm("Are you sure you want to approve this vendor price?")) {
                    return;
                }

                $.ajax({
                    url: "ajax_approve_alt_product_vendors.php",
                    type: "POST",
                    data: { tpavid: tpavid },
                    success: function(response) {
                        if (response.trim() === "success") {
                            alert("Vendor approved successfully!");
                            
                            // Reload the page without 'productname' in the URL
                            let url = new URL(window.location.href);
                            url.searchParams.delete("productname");
                            window.location.href = url.toString();
                        } else {
                            alert("Approval failed: " + response);
                        }
                    }
                });
            });
        });
    </script>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
